# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociationProperty(object):
    """
    A property represented as a name-value pair.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssociationProperty object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AssociationProperty.
        :type name: str

        :param value:
            The value to assign to the value property of this AssociationProperty.
        :type value: str

        :param patterns:
            The value to assign to the patterns property of this AssociationProperty.
        :type patterns: list[oci.log_analytics.models.PatternOverride]

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'patterns': 'list[PatternOverride]'
        }

        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'patterns': 'patterns'
        }

        self._name = None
        self._value = None
        self._patterns = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssociationProperty.
        The name of the association property.


        :return: The name of this AssociationProperty.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssociationProperty.
        The name of the association property.


        :param name: The name of this AssociationProperty.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        Gets the value of this AssociationProperty.
        The value of the association property.


        :return: The value of this AssociationProperty.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AssociationProperty.
        The value of the association property.


        :param value: The value of this AssociationProperty.
        :type: str
        """
        self._value = value

    @property
    def patterns(self):
        """
        Gets the patterns of this AssociationProperty.
        A list of pattern level overrides for this property.


        :return: The patterns of this AssociationProperty.
        :rtype: list[oci.log_analytics.models.PatternOverride]
        """
        return self._patterns

    @patterns.setter
    def patterns(self, patterns):
        """
        Sets the patterns of this AssociationProperty.
        A list of pattern level overrides for this property.


        :param patterns: The patterns of this AssociationProperty.
        :type: list[oci.log_analytics.models.PatternOverride]
        """
        self._patterns = patterns

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
