# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplyNetworkFirewallPolicyDetails(object):
    """
    Request data required to clone a network firewall policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApplyNetworkFirewallPolicyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param firewalls:
            The value to assign to the firewalls property of this ApplyNetworkFirewallPolicyDetails.
        :type firewalls: list[str]

        """
        self.swagger_types = {
            'firewalls': 'list[str]'
        }

        self.attribute_map = {
            'firewalls': 'firewalls'
        }

        self._firewalls = None

    @property
    def firewalls(self):
        """
        Gets the firewalls of this ApplyNetworkFirewallPolicyDetails.
        Ordered priority list of firewall OCIDs on which the update needs to be applied in given order. If the list is a subset of the firewalls attached, then given firewalls would be deployed first with the change, followed by remaining firewalls.


        :return: The firewalls of this ApplyNetworkFirewallPolicyDetails.
        :rtype: list[str]
        """
        return self._firewalls

    @firewalls.setter
    def firewalls(self, firewalls):
        """
        Sets the firewalls of this ApplyNetworkFirewallPolicyDetails.
        Ordered priority list of firewall OCIDs on which the update needs to be applied in given order. If the list is a subset of the firewalls attached, then given firewalls would be deployed first with the change, followed by remaining firewalls.


        :param firewalls: The firewalls of this ApplyNetworkFirewallPolicyDetails.
        :type: list[str]
        """
        self._firewalls = firewalls

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
