# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SddcPassword(object):
    """
    SDDC vCenter/NSX/HCX password.
    """

    #: A constant which can be used with the password_type property of a SddcPassword.
    #: This constant has a value of "VCENTER"
    PASSWORD_TYPE_VCENTER = "VCENTER"

    #: A constant which can be used with the password_type property of a SddcPassword.
    #: This constant has a value of "NSX"
    PASSWORD_TYPE_NSX = "NSX"

    #: A constant which can be used with the password_type property of a SddcPassword.
    #: This constant has a value of "HCX"
    PASSWORD_TYPE_HCX = "HCX"

    def __init__(self, **kwargs):
        """
        Initializes a new SddcPassword object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param password_type:
            The value to assign to the password_type property of this SddcPassword.
            Allowed values for this property are: "VCENTER", "NSX", "HCX", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type password_type: str

        :param value:
            The value to assign to the value property of this SddcPassword.
        :type value: str

        """
        self.swagger_types = {
            'password_type': 'str',
            'value': 'str'
        }

        self.attribute_map = {
            'password_type': 'passwordType',
            'value': 'value'
        }

        self._password_type = None
        self._value = None

    @property
    def password_type(self):
        """
        **[Required]** Gets the password_type of this SddcPassword.
        SDDC password type.

        Allowed values for this property are: "VCENTER", "NSX", "HCX", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The password_type of this SddcPassword.
        :rtype: str
        """
        return self._password_type

    @password_type.setter
    def password_type(self, password_type):
        """
        Sets the password_type of this SddcPassword.
        SDDC password type.


        :param password_type: The password_type of this SddcPassword.
        :type: str
        """
        allowed_values = ["VCENTER", "NSX", "HCX"]
        if not value_allowed_none_or_none_sentinel(password_type, allowed_values):
            password_type = 'UNKNOWN_ENUM_VALUE'
        self._password_type = password_type

    @property
    def value(self):
        """
        **[Required]** Gets the value of this SddcPassword.
        SDDC vCenter/NSX/HCX password context.


        :return: The value of this SddcPassword.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this SddcPassword.
        SDDC vCenter/NSX/HCX password context.


        :param value: The value of this SddcPassword.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
