# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .host_insight_host_recommendations import HostInsightHostRecommendations
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostCpuRecommendations(HostInsightHostRecommendations):
    """
    Contains CPU recommendation.
    """

    #: A constant which can be used with the burstable property of a HostCpuRecommendations.
    #: This constant has a value of "BASELINE_1_8"
    BURSTABLE_BASELINE_1_8 = "BASELINE_1_8"

    #: A constant which can be used with the burstable property of a HostCpuRecommendations.
    #: This constant has a value of "BASELINE_1_2"
    BURSTABLE_BASELINE_1_2 = "BASELINE_1_2"

    #: A constant which can be used with the burstable property of a HostCpuRecommendations.
    #: This constant has a value of "NO_RECOMMENDATION"
    BURSTABLE_NO_RECOMMENDATION = "NO_RECOMMENDATION"

    #: A constant which can be used with the burstable property of a HostCpuRecommendations.
    #: This constant has a value of "DISABLE_BURSTABLE"
    BURSTABLE_DISABLE_BURSTABLE = "DISABLE_BURSTABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new HostCpuRecommendations object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.HostCpuRecommendations.metric_recommendation_name` attribute
        of this class is ``HOST_CPU_RECOMMENDATIONS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_recommendation_name:
            The value to assign to the metric_recommendation_name property of this HostCpuRecommendations.
            Allowed values for this property are: "HOST_CPU_RECOMMENDATIONS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type metric_recommendation_name: str

        :param burstable:
            The value to assign to the burstable property of this HostCpuRecommendations.
            Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "NO_RECOMMENDATION", "DISABLE_BURSTABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type burstable: str

        """
        self.swagger_types = {
            'metric_recommendation_name': 'str',
            'burstable': 'str'
        }

        self.attribute_map = {
            'metric_recommendation_name': 'metricRecommendationName',
            'burstable': 'burstable'
        }

        self._metric_recommendation_name = None
        self._burstable = None
        self._metric_recommendation_name = 'HOST_CPU_RECOMMENDATIONS'

    @property
    def burstable(self):
        """
        Gets the burstable of this HostCpuRecommendations.
        Show if OPSI recommend to convert an instance to a burstable instance and show recommended cpu baseline if positive recommendation.

        Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "NO_RECOMMENDATION", "DISABLE_BURSTABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The burstable of this HostCpuRecommendations.
        :rtype: str
        """
        return self._burstable

    @burstable.setter
    def burstable(self, burstable):
        """
        Sets the burstable of this HostCpuRecommendations.
        Show if OPSI recommend to convert an instance to a burstable instance and show recommended cpu baseline if positive recommendation.


        :param burstable: The burstable of this HostCpuRecommendations.
        :type: str
        """
        allowed_values = ["BASELINE_1_8", "BASELINE_1_2", "NO_RECOMMENDATION", "DISABLE_BURSTABLE"]
        if not value_allowed_none_or_none_sentinel(burstable, allowed_values):
            burstable = 'UNKNOWN_ENUM_VALUE'
        self._burstable = burstable

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
