# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails(object):
    """
    Provides the information used to install all Windows updates of a specified type on managed instances within the specified compartment.
    """

    #: A constant which can be used with the windows_update_types property of a InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
    #: This constant has a value of "SECURITY"
    WINDOWS_UPDATE_TYPES_SECURITY = "SECURITY"

    #: A constant which can be used with the windows_update_types property of a InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
    #: This constant has a value of "BUGFIX"
    WINDOWS_UPDATE_TYPES_BUGFIX = "BUGFIX"

    #: A constant which can be used with the windows_update_types property of a InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
    #: This constant has a value of "ENHANCEMENT"
    WINDOWS_UPDATE_TYPES_ENHANCEMENT = "ENHANCEMENT"

    #: A constant which can be used with the windows_update_types property of a InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
    #: This constant has a value of "OTHER"
    WINDOWS_UPDATE_TYPES_OTHER = "OTHER"

    #: A constant which can be used with the windows_update_types property of a InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
    #: This constant has a value of "ALL"
    WINDOWS_UPDATE_TYPES_ALL = "ALL"

    def __init__(self, **kwargs):
        """
        Initializes a new InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :type compartment_id: str

        :param windows_update_types:
            The value to assign to the windows_update_types property of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
            Allowed values for items in this list are: "SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", "ALL"
        :type windows_update_types: list[str]

        :param work_request_details:
            The value to assign to the work_request_details property of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :type work_request_details: oci.os_management_hub.models.WorkRequestDetails

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'windows_update_types': 'list[str]',
            'work_request_details': 'WorkRequestDetails'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'windows_update_types': 'windowsUpdateTypes',
            'work_request_details': 'workRequestDetails'
        }

        self._compartment_id = None
        self._windows_update_types = None
        self._work_request_details = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def windows_update_types(self):
        """
        Gets the windows_update_types of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        The types of Windows updates to be installed.

        Allowed values for items in this list are: "SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", "ALL"


        :return: The windows_update_types of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :rtype: list[str]
        """
        return self._windows_update_types

    @windows_update_types.setter
    def windows_update_types(self, windows_update_types):
        """
        Sets the windows_update_types of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        The types of Windows updates to be installed.


        :param windows_update_types: The windows_update_types of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :type: list[str]
        """
        allowed_values = ["SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER", "ALL"]

        if windows_update_types and windows_update_types is not NONE_SENTINEL:
            for value in windows_update_types:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `windows_update_types`, must be None or one of {allowed_values}"
                    )
        self._windows_update_types = windows_update_types

    @property
    def work_request_details(self):
        """
        Gets the work_request_details of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.

        :return: The work_request_details of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :rtype: oci.os_management_hub.models.WorkRequestDetails
        """
        return self._work_request_details

    @work_request_details.setter
    def work_request_details(self, work_request_details):
        """
        Sets the work_request_details of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.

        :param work_request_details: The work_request_details of this InstallAllWindowsUpdatesOnManagedInstancesInCompartmentDetails.
        :type: oci.os_management_hub.models.WorkRequestDetails
        """
        self._work_request_details = work_request_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
