# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SoftwareSourceEventData(object):
    """
    Provides additional information for a software source event.
    """

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "ENABLE_MODULE_STREAMS"
    OPERATION_TYPE_ENABLE_MODULE_STREAMS = "ENABLE_MODULE_STREAMS"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "DISABLE_MODULE_STREAMS"
    OPERATION_TYPE_DISABLE_MODULE_STREAMS = "DISABLE_MODULE_STREAMS"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "SWITCH_MODULE_STREAM"
    OPERATION_TYPE_SWITCH_MODULE_STREAM = "SWITCH_MODULE_STREAM"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "INSTALL_MODULE_PROFILE"
    OPERATION_TYPE_INSTALL_MODULE_PROFILE = "INSTALL_MODULE_PROFILE"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "REMOVE_MODULE_PROFILES"
    OPERATION_TYPE_REMOVE_MODULE_PROFILES = "REMOVE_MODULE_PROFILES"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "SET_SOFTWARE_SOURCES"
    OPERATION_TYPE_SET_SOFTWARE_SOURCES = "SET_SOFTWARE_SOURCES"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "UPDATE_SOFTWARE_SOURCE"
    OPERATION_TYPE_UPDATE_SOFTWARE_SOURCE = "UPDATE_SOFTWARE_SOURCE"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "CREATE_SOFTWARE_SOURCE"
    OPERATION_TYPE_CREATE_SOFTWARE_SOURCE = "CREATE_SOFTWARE_SOURCE"

    #: A constant which can be used with the operation_type property of a SoftwareSourceEventData.
    #: This constant has a value of "LIFECYCLE_PROMOTION"
    OPERATION_TYPE_LIFECYCLE_PROMOTION = "LIFECYCLE_PROMOTION"

    #: A constant which can be used with the status property of a SoftwareSourceEventData.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a SoftwareSourceEventData.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new SoftwareSourceEventData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_type:
            The value to assign to the operation_type property of this SoftwareSourceEventData.
            Allowed values for this property are: "ENABLE_MODULE_STREAMS", "DISABLE_MODULE_STREAMS", "SWITCH_MODULE_STREAM", "INSTALL_MODULE_PROFILE", "REMOVE_MODULE_PROFILES", "SET_SOFTWARE_SOURCES", "UPDATE_SOFTWARE_SOURCE", "CREATE_SOFTWARE_SOURCE", "LIFECYCLE_PROMOTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_type: str

        :param status:
            The value to assign to the status property of this SoftwareSourceEventData.
            Allowed values for this property are: "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param additional_details:
            The value to assign to the additional_details property of this SoftwareSourceEventData.
        :type additional_details: oci.os_management_hub.models.WorkRequestEventDataAdditionalDetails

        """
        self.swagger_types = {
            'operation_type': 'str',
            'status': 'str',
            'additional_details': 'WorkRequestEventDataAdditionalDetails'
        }

        self.attribute_map = {
            'operation_type': 'operationType',
            'status': 'status',
            'additional_details': 'additionalDetails'
        }

        self._operation_type = None
        self._status = None
        self._additional_details = None

    @property
    def operation_type(self):
        """
        **[Required]** Gets the operation_type of this SoftwareSourceEventData.
        Type of software source operation.

        Allowed values for this property are: "ENABLE_MODULE_STREAMS", "DISABLE_MODULE_STREAMS", "SWITCH_MODULE_STREAM", "INSTALL_MODULE_PROFILE", "REMOVE_MODULE_PROFILES", "SET_SOFTWARE_SOURCES", "UPDATE_SOFTWARE_SOURCE", "CREATE_SOFTWARE_SOURCE", "LIFECYCLE_PROMOTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_type of this SoftwareSourceEventData.
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """
        Sets the operation_type of this SoftwareSourceEventData.
        Type of software source operation.


        :param operation_type: The operation_type of this SoftwareSourceEventData.
        :type: str
        """
        allowed_values = ["ENABLE_MODULE_STREAMS", "DISABLE_MODULE_STREAMS", "SWITCH_MODULE_STREAM", "INSTALL_MODULE_PROFILE", "REMOVE_MODULE_PROFILES", "SET_SOFTWARE_SOURCES", "UPDATE_SOFTWARE_SOURCE", "CREATE_SOFTWARE_SOURCE", "LIFECYCLE_PROMOTION"]
        if not value_allowed_none_or_none_sentinel(operation_type, allowed_values):
            operation_type = 'UNKNOWN_ENUM_VALUE'
        self._operation_type = operation_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this SoftwareSourceEventData.
        Status of the software source operation.

        Allowed values for this property are: "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this SoftwareSourceEventData.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this SoftwareSourceEventData.
        Status of the software source operation.


        :param status: The status of this SoftwareSourceEventData.
        :type: str
        """
        allowed_values = ["SUCCEEDED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def additional_details(self):
        """
        Gets the additional_details of this SoftwareSourceEventData.

        :return: The additional_details of this SoftwareSourceEventData.
        :rtype: oci.os_management_hub.models.WorkRequestEventDataAdditionalDetails
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this SoftwareSourceEventData.

        :param additional_details: The additional_details of this SoftwareSourceEventData.
        :type: oci.os_management_hub.models.WorkRequestEventDataAdditionalDetails
        """
        self._additional_details = additional_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
