# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupPolicy(object):
    """
    PostgreSQL database system backup policy.
    """

    #: A constant which can be used with the kind property of a BackupPolicy.
    #: This constant has a value of "DAILY"
    KIND_DAILY = "DAILY"

    #: A constant which can be used with the kind property of a BackupPolicy.
    #: This constant has a value of "WEEKLY"
    KIND_WEEKLY = "WEEKLY"

    #: A constant which can be used with the kind property of a BackupPolicy.
    #: This constant has a value of "MONTHLY"
    KIND_MONTHLY = "MONTHLY"

    #: A constant which can be used with the kind property of a BackupPolicy.
    #: This constant has a value of "NONE"
    KIND_NONE = "NONE"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupPolicy object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.psql.models.DailyBackupPolicy`
        * :class:`~oci.psql.models.WeeklyBackupPolicy`
        * :class:`~oci.psql.models.NoneBackupPolicy`
        * :class:`~oci.psql.models.MonthlyBackupPolicy`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this BackupPolicy.
            Allowed values for this property are: "DAILY", "WEEKLY", "MONTHLY", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type kind: str

        :param retention_days:
            The value to assign to the retention_days property of this BackupPolicy.
        :type retention_days: int

        """
        self.swagger_types = {
            'kind': 'str',
            'retention_days': 'int'
        }

        self.attribute_map = {
            'kind': 'kind',
            'retention_days': 'retentionDays'
        }

        self._kind = None
        self._retention_days = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['kind']

        if type == 'DAILY':
            return 'DailyBackupPolicy'

        if type == 'WEEKLY':
            return 'WeeklyBackupPolicy'

        if type == 'NONE':
            return 'NoneBackupPolicy'

        if type == 'MONTHLY':
            return 'MonthlyBackupPolicy'
        else:
            return 'BackupPolicy'

    @property
    def kind(self):
        """
        Gets the kind of this BackupPolicy.
        The kind of backup policy.

        Allowed values for this property are: "DAILY", "WEEKLY", "MONTHLY", "NONE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The kind of this BackupPolicy.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this BackupPolicy.
        The kind of backup policy.


        :param kind: The kind of this BackupPolicy.
        :type: str
        """
        allowed_values = ["DAILY", "WEEKLY", "MONTHLY", "NONE"]
        if not value_allowed_none_or_none_sentinel(kind, allowed_values):
            kind = 'UNKNOWN_ENUM_VALUE'
        self._kind = kind

    @property
    def retention_days(self):
        """
        Gets the retention_days of this BackupPolicy.
        How many days the data should be stored after the database system deletion.


        :return: The retention_days of this BackupPolicy.
        :rtype: int
        """
        return self._retention_days

    @retention_days.setter
    def retention_days(self, retention_days):
        """
        Sets the retention_days of this BackupPolicy.
        How many days the data should be stored after the database system deletion.


        :param retention_days: The retention_days of this BackupPolicy.
        :type: int
        """
        self._retention_days = retention_days

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
