# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefinedTagFilterValue(object):
    """
    This is a defined tag filter value.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefinedTagFilterValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param namespace:
            The value to assign to the namespace property of this DefinedTagFilterValue.
        :type namespace: str

        :param tag_key:
            The value to assign to the tag_key property of this DefinedTagFilterValue.
        :type tag_key: str

        :param value:
            The value to assign to the value property of this DefinedTagFilterValue.
        :type value: str

        """
        self.swagger_types = {
            'namespace': 'str',
            'tag_key': 'str',
            'value': 'str'
        }

        self.attribute_map = {
            'namespace': 'namespace',
            'tag_key': 'tagKey',
            'value': 'value'
        }

        self._namespace = None
        self._tag_key = None
        self._value = None

    @property
    def namespace(self):
        """
        Gets the namespace of this DefinedTagFilterValue.
        This is the namespace of the defined tag.


        :return: The namespace of this DefinedTagFilterValue.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this DefinedTagFilterValue.
        This is the namespace of the defined tag.


        :param namespace: The namespace of this DefinedTagFilterValue.
        :type: str
        """
        self._namespace = namespace

    @property
    def tag_key(self):
        """
        Gets the tag_key of this DefinedTagFilterValue.
        This is the key of the defined tag.


        :return: The tag_key of this DefinedTagFilterValue.
        :rtype: str
        """
        return self._tag_key

    @tag_key.setter
    def tag_key(self, tag_key):
        """
        Sets the tag_key of this DefinedTagFilterValue.
        This is the key of the defined tag.


        :param tag_key: The tag_key of this DefinedTagFilterValue.
        :type: str
        """
        self._tag_key = tag_key

    @property
    def value(self):
        """
        Gets the value of this DefinedTagFilterValue.
        This is the value of the defined tag.


        :return: The value of this DefinedTagFilterValue.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this DefinedTagFilterValue.
        This is the value of the defined tag.


        :param value: The value of this DefinedTagFilterValue.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
