# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Resource(object):
    """
    This is the schedule resource entity.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Resource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Resource.
        :type id: str

        :param metadata:
            The value to assign to the metadata property of this Resource.
        :type metadata: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'metadata': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'metadata': 'metadata'
        }

        self._id = None
        self._metadata = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Resource.
        This is the resource OCID.


        :return: The id of this Resource.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Resource.
        This is the resource OCID.


        :param id: The id of this Resource.
        :type: str
        """
        self._id = id

    @property
    def metadata(self):
        """
        Gets the metadata of this Resource.
        This is additional information that helps to identity the resource for the schedule.

            {
              \"id\": \"<OCID_of_bucket>\"
              \"metadata\":
              {
                \"namespaceName\": \"sampleNamespace\",
                \"bucketName\": \"sampleBucket\"
              }
            }


        :return: The metadata of this Resource.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this Resource.
        This is additional information that helps to identity the resource for the schedule.

            {
              \"id\": \"<OCID_of_bucket>\"
              \"metadata\":
              {
                \"namespaceName\": \"sampleNamespace\",
                \"bucketName\": \"sampleBucket\"
              }
            }


        :param metadata: The metadata of this Resource.
        :type: dict(str, str)
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
