# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlOutParamDetails(object):
    """
    Position and SQL Type of PL/SQL OUT parameter
    """

    #: A constant which can be used with the out_param_type property of a SqlOutParamDetails.
    #: This constant has a value of "SQL_CURSOR"
    OUT_PARAM_TYPE_SQL_CURSOR = "SQL_CURSOR"

    #: A constant which can be used with the out_param_type property of a SqlOutParamDetails.
    #: This constant has a value of "ARRAY"
    OUT_PARAM_TYPE_ARRAY = "ARRAY"

    def __init__(self, **kwargs):
        """
        Initializes a new SqlOutParamDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param out_param_position:
            The value to assign to the out_param_position property of this SqlOutParamDetails.
        :type out_param_position: int

        :param out_param_type:
            The value to assign to the out_param_type property of this SqlOutParamDetails.
            Allowed values for this property are: "SQL_CURSOR", "ARRAY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type out_param_type: str

        """
        self.swagger_types = {
            'out_param_position': 'int',
            'out_param_type': 'str'
        }

        self.attribute_map = {
            'out_param_position': 'outParamPosition',
            'out_param_type': 'outParamType'
        }

        self._out_param_position = None
        self._out_param_type = None

    @property
    def out_param_position(self):
        """
        **[Required]** Gets the out_param_position of this SqlOutParamDetails.
        Position of PL/SQL procedure OUT parameter


        :return: The out_param_position of this SqlOutParamDetails.
        :rtype: int
        """
        return self._out_param_position

    @out_param_position.setter
    def out_param_position(self, out_param_position):
        """
        Sets the out_param_position of this SqlOutParamDetails.
        Position of PL/SQL procedure OUT parameter


        :param out_param_position: The out_param_position of this SqlOutParamDetails.
        :type: int
        """
        self._out_param_position = out_param_position

    @property
    def out_param_type(self):
        """
        **[Required]** Gets the out_param_type of this SqlOutParamDetails.
        SQL Type of PL/SQL procedure OUT parameter

        Allowed values for this property are: "SQL_CURSOR", "ARRAY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The out_param_type of this SqlOutParamDetails.
        :rtype: str
        """
        return self._out_param_type

    @out_param_type.setter
    def out_param_type(self, out_param_type):
        """
        Sets the out_param_type of this SqlOutParamDetails.
        SQL Type of PL/SQL procedure OUT parameter


        :param out_param_type: The out_param_type of this SqlOutParamDetails.
        :type: str
        """
        allowed_values = ["SQL_CURSOR", "ARRAY"]
        if not value_allowed_none_or_none_sentinel(out_param_type, allowed_values):
            out_param_type = 'UNKNOWN_ENUM_VALUE'
        self._out_param_type = out_param_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
