# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .resource_type_metadata_details import ResourceTypeMetadataDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SystemFormatResourceTypeMetadataDetails(ResourceTypeMetadataDetails):
    """
    The resource type metadata is defined in machine friendly format.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SystemFormatResourceTypeMetadataDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.SystemFormatResourceTypeMetadataDetails.format` attribute
        of this class is ``SYSTEM_FORMAT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param format:
            The value to assign to the format property of this SystemFormatResourceTypeMetadataDetails.
            Allowed values for this property are: "SYSTEM_FORMAT"
        :type format: str

        :param required_properties:
            The value to assign to the required_properties property of this SystemFormatResourceTypeMetadataDetails.
        :type required_properties: list[str]

        :param agent_properties:
            The value to assign to the agent_properties property of this SystemFormatResourceTypeMetadataDetails.
        :type agent_properties: list[str]

        :param valid_properties_for_create:
            The value to assign to the valid_properties_for_create property of this SystemFormatResourceTypeMetadataDetails.
        :type valid_properties_for_create: list[str]

        :param valid_properties_for_update:
            The value to assign to the valid_properties_for_update property of this SystemFormatResourceTypeMetadataDetails.
        :type valid_properties_for_update: list[str]

        :param unique_property_sets:
            The value to assign to the unique_property_sets property of this SystemFormatResourceTypeMetadataDetails.
        :type unique_property_sets: list[oci.stack_monitoring.models.UniquePropertySet]

        :param valid_property_values:
            The value to assign to the valid_property_values property of this SystemFormatResourceTypeMetadataDetails.
        :type valid_property_values: dict(str, list[str])

        """
        self.swagger_types = {
            'format': 'str',
            'required_properties': 'list[str]',
            'agent_properties': 'list[str]',
            'valid_properties_for_create': 'list[str]',
            'valid_properties_for_update': 'list[str]',
            'unique_property_sets': 'list[UniquePropertySet]',
            'valid_property_values': 'dict(str, list[str])'
        }

        self.attribute_map = {
            'format': 'format',
            'required_properties': 'requiredProperties',
            'agent_properties': 'agentProperties',
            'valid_properties_for_create': 'validPropertiesForCreate',
            'valid_properties_for_update': 'validPropertiesForUpdate',
            'unique_property_sets': 'uniquePropertySets',
            'valid_property_values': 'validPropertyValues'
        }

        self._format = None
        self._required_properties = None
        self._agent_properties = None
        self._valid_properties_for_create = None
        self._valid_properties_for_update = None
        self._unique_property_sets = None
        self._valid_property_values = None
        self._format = 'SYSTEM_FORMAT'

    @property
    def required_properties(self):
        """
        Gets the required_properties of this SystemFormatResourceTypeMetadataDetails.
        List of required properties for resource type.


        :return: The required_properties of this SystemFormatResourceTypeMetadataDetails.
        :rtype: list[str]
        """
        return self._required_properties

    @required_properties.setter
    def required_properties(self, required_properties):
        """
        Sets the required_properties of this SystemFormatResourceTypeMetadataDetails.
        List of required properties for resource type.


        :param required_properties: The required_properties of this SystemFormatResourceTypeMetadataDetails.
        :type: list[str]
        """
        self._required_properties = required_properties

    @property
    def agent_properties(self):
        """
        Gets the agent_properties of this SystemFormatResourceTypeMetadataDetails.
        List of properties needed by the agent for monitoring the resource.
        Valid only if resource type is OCI management agent based. When specified,
        these properties are passed to the management agent during resource create or update.


        :return: The agent_properties of this SystemFormatResourceTypeMetadataDetails.
        :rtype: list[str]
        """
        return self._agent_properties

    @agent_properties.setter
    def agent_properties(self, agent_properties):
        """
        Sets the agent_properties of this SystemFormatResourceTypeMetadataDetails.
        List of properties needed by the agent for monitoring the resource.
        Valid only if resource type is OCI management agent based. When specified,
        these properties are passed to the management agent during resource create or update.


        :param agent_properties: The agent_properties of this SystemFormatResourceTypeMetadataDetails.
        :type: list[str]
        """
        self._agent_properties = agent_properties

    @property
    def valid_properties_for_create(self):
        """
        Gets the valid_properties_for_create of this SystemFormatResourceTypeMetadataDetails.
        List of valid properties for resource type while creating the monitored resource.
        If resources of this type specifies any other properties during create operation,
        the operation will fail.


        :return: The valid_properties_for_create of this SystemFormatResourceTypeMetadataDetails.
        :rtype: list[str]
        """
        return self._valid_properties_for_create

    @valid_properties_for_create.setter
    def valid_properties_for_create(self, valid_properties_for_create):
        """
        Sets the valid_properties_for_create of this SystemFormatResourceTypeMetadataDetails.
        List of valid properties for resource type while creating the monitored resource.
        If resources of this type specifies any other properties during create operation,
        the operation will fail.


        :param valid_properties_for_create: The valid_properties_for_create of this SystemFormatResourceTypeMetadataDetails.
        :type: list[str]
        """
        self._valid_properties_for_create = valid_properties_for_create

    @property
    def valid_properties_for_update(self):
        """
        Gets the valid_properties_for_update of this SystemFormatResourceTypeMetadataDetails.
        List of valid properties for resource type while updating the monitored resource.
        If resources of this type specifies any other properties during update operation,
        the operation will fail.


        :return: The valid_properties_for_update of this SystemFormatResourceTypeMetadataDetails.
        :rtype: list[str]
        """
        return self._valid_properties_for_update

    @valid_properties_for_update.setter
    def valid_properties_for_update(self, valid_properties_for_update):
        """
        Sets the valid_properties_for_update of this SystemFormatResourceTypeMetadataDetails.
        List of valid properties for resource type while updating the monitored resource.
        If resources of this type specifies any other properties during update operation,
        the operation will fail.


        :param valid_properties_for_update: The valid_properties_for_update of this SystemFormatResourceTypeMetadataDetails.
        :type: list[str]
        """
        self._valid_properties_for_update = valid_properties_for_update

    @property
    def unique_property_sets(self):
        """
        Gets the unique_property_sets of this SystemFormatResourceTypeMetadataDetails.
        List of property sets used to uniquely identify the resources.
        This check is made during create or update of stack monitoring resource.
        The resource has to pass unique check for each set in the list.
        For example, database can have user, password and SID as one unique set.
        Another unique set would be user, password and service name.


        :return: The unique_property_sets of this SystemFormatResourceTypeMetadataDetails.
        :rtype: list[oci.stack_monitoring.models.UniquePropertySet]
        """
        return self._unique_property_sets

    @unique_property_sets.setter
    def unique_property_sets(self, unique_property_sets):
        """
        Sets the unique_property_sets of this SystemFormatResourceTypeMetadataDetails.
        List of property sets used to uniquely identify the resources.
        This check is made during create or update of stack monitoring resource.
        The resource has to pass unique check for each set in the list.
        For example, database can have user, password and SID as one unique set.
        Another unique set would be user, password and service name.


        :param unique_property_sets: The unique_property_sets of this SystemFormatResourceTypeMetadataDetails.
        :type: list[oci.stack_monitoring.models.UniquePropertySet]
        """
        self._unique_property_sets = unique_property_sets

    @property
    def valid_property_values(self):
        """
        Gets the valid_property_values of this SystemFormatResourceTypeMetadataDetails.
        List of valid values for the properties. This is useful when resource type wants to
        restrict only certain values for some properties. For instance for 'osType' property,
        supported values can be restricted to be either Linux or Windows.
        Example: `{ \"osType\": [\"Linux\",\"Windows\",\"Solaris\"]}`


        :return: The valid_property_values of this SystemFormatResourceTypeMetadataDetails.
        :rtype: dict(str, list[str])
        """
        return self._valid_property_values

    @valid_property_values.setter
    def valid_property_values(self, valid_property_values):
        """
        Sets the valid_property_values of this SystemFormatResourceTypeMetadataDetails.
        List of valid values for the properties. This is useful when resource type wants to
        restrict only certain values for some properties. For instance for 'osType' property,
        supported values can be restricted to be either Linux or Windows.
        Example: `{ \"osType\": [\"Linux\",\"Windows\",\"Solaris\"]}`


        :param valid_property_values: The valid_property_values of this SystemFormatResourceTypeMetadataDetails.
        :type: dict(str, list[str])
        """
        self._valid_property_values = valid_property_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
