# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostScanAgentConfiguration(object):
    """
    Agent configuration for host scan agent settings. This model is polymorphic, presenting different configuration options based on selected agent vendor.
    """

    #: A constant which can be used with the vendor property of a HostScanAgentConfiguration.
    #: This constant has a value of "OCI"
    VENDOR_OCI = "OCI"

    #: A constant which can be used with the vendor property of a HostScanAgentConfiguration.
    #: This constant has a value of "QUALYS"
    VENDOR_QUALYS = "QUALYS"

    #: A constant which can be used with the vendor_type property of a HostScanAgentConfiguration.
    #: This constant has a value of "OCI"
    VENDOR_TYPE_OCI = "OCI"

    #: A constant which can be used with the vendor_type property of a HostScanAgentConfiguration.
    #: This constant has a value of "QUALYS"
    VENDOR_TYPE_QUALYS = "QUALYS"

    def __init__(self, **kwargs):
        """
        Initializes a new HostScanAgentConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.vulnerability_scanning.models.HostScanAgentConfigurationQualys`
        * :class:`~oci.vulnerability_scanning.models.HostScanAgentConfigurationOCI`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vendor:
            The value to assign to the vendor property of this HostScanAgentConfiguration.
            Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vendor: str

        :param vendor_type:
            The value to assign to the vendor_type property of this HostScanAgentConfiguration.
            Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vendor_type: str

        """
        self.swagger_types = {
            'vendor': 'str',
            'vendor_type': 'str'
        }

        self.attribute_map = {
            'vendor': 'vendor',
            'vendor_type': 'vendorType'
        }

        self._vendor = None
        self._vendor_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['vendor']

        if type == 'QUALYS':
            return 'HostScanAgentConfigurationQualys'

        if type == 'OCI':
            return 'HostScanAgentConfigurationOCI'
        else:
            return 'HostScanAgentConfiguration'

    @property
    def vendor(self):
        """
        **[Required]** Gets the vendor of this HostScanAgentConfiguration.
        Vendor to use for the host scan agent.

        Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vendor of this HostScanAgentConfiguration.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this HostScanAgentConfiguration.
        Vendor to use for the host scan agent.


        :param vendor: The vendor of this HostScanAgentConfiguration.
        :type: str
        """
        allowed_values = ["OCI", "QUALYS"]
        if not value_allowed_none_or_none_sentinel(vendor, allowed_values):
            vendor = 'UNKNOWN_ENUM_VALUE'
        self._vendor = vendor

    @property
    def vendor_type(self):
        """
        Gets the vendor_type of this HostScanAgentConfiguration.
        Vendor to use for the host scan agent.

        Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vendor_type of this HostScanAgentConfiguration.
        :rtype: str
        """
        return self._vendor_type

    @vendor_type.setter
    def vendor_type(self, vendor_type):
        """
        Sets the vendor_type of this HostScanAgentConfiguration.
        Vendor to use for the host scan agent.


        :param vendor_type: The vendor_type of this HostScanAgentConfiguration.
        :type: str
        """
        allowed_values = ["OCI", "QUALYS"]
        if not value_allowed_none_or_none_sentinel(vendor_type, allowed_values):
            vendor_type = 'UNKNOWN_ENUM_VALUE'
        self._vendor_type = vendor_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
