# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostVulnerability(object):
    """
    A vulnerability found in one or more host scans in a compartment
    """

    #: A constant which can be used with the severity property of a HostVulnerability.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a HostVulnerability.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a HostVulnerability.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a HostVulnerability.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a HostVulnerability.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the state property of a HostVulnerability.
    #: This constant has a value of "OPEN"
    STATE_OPEN = "OPEN"

    #: A constant which can be used with the state property of a HostVulnerability.
    #: This constant has a value of "FIXED"
    STATE_FIXED = "FIXED"

    #: A constant which can be used with the state property of a HostVulnerability.
    #: This constant has a value of "NOT_APPLICABLE"
    STATE_NOT_APPLICABLE = "NOT_APPLICABLE"

    #: A constant which can be used with the vulnerability_type property of a HostVulnerability.
    #: This constant has a value of "CVE"
    VULNERABILITY_TYPE_CVE = "CVE"

    #: A constant which can be used with the vulnerability_type property of a HostVulnerability.
    #: This constant has a value of "PROBLEM"
    VULNERABILITY_TYPE_PROBLEM = "PROBLEM"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerability.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerability.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerability.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerability.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerability.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerability.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new HostVulnerability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HostVulnerability.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HostVulnerability.
        :type compartment_id: str

        :param authentication:
            The value to assign to the authentication property of this HostVulnerability.
        :type authentication: str

        :param cve_reference:
            The value to assign to the cve_reference property of this HostVulnerability.
        :type cve_reference: str

        :param cve_details:
            The value to assign to the cve_details property of this HostVulnerability.
        :type cve_details: oci.vulnerability_scanning.models.CveDetails

        :param severity:
            The value to assign to the severity property of this HostVulnerability.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param state:
            The value to assign to the state property of this HostVulnerability.
            Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param name:
            The value to assign to the name property of this HostVulnerability.
        :type name: str

        :param time_last_detected:
            The value to assign to the time_last_detected property of this HostVulnerability.
        :type time_last_detected: datetime

        :param time_first_detected:
            The value to assign to the time_first_detected property of this HostVulnerability.
        :type time_first_detected: datetime

        :param host_count:
            The value to assign to the host_count property of this HostVulnerability.
        :type host_count: int

        :param vulnerability_type:
            The value to assign to the vulnerability_type property of this HostVulnerability.
            Allowed values for this property are: "CVE", "PROBLEM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vulnerability_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostVulnerability.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'authentication': 'str',
            'cve_reference': 'str',
            'cve_details': 'CveDetails',
            'severity': 'str',
            'state': 'str',
            'name': 'str',
            'time_last_detected': 'datetime',
            'time_first_detected': 'datetime',
            'host_count': 'int',
            'vulnerability_type': 'str',
            'lifecycle_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'authentication': 'authentication',
            'cve_reference': 'cveReference',
            'cve_details': 'cveDetails',
            'severity': 'severity',
            'state': 'state',
            'name': 'name',
            'time_last_detected': 'timeLastDetected',
            'time_first_detected': 'timeFirstDetected',
            'host_count': 'hostCount',
            'vulnerability_type': 'vulnerabilityType',
            'lifecycle_state': 'lifecycleState'
        }

        self._id = None
        self._compartment_id = None
        self._authentication = None
        self._cve_reference = None
        self._cve_details = None
        self._severity = None
        self._state = None
        self._name = None
        self._time_last_detected = None
        self._time_first_detected = None
        self._host_count = None
        self._vulnerability_type = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HostVulnerability.
        ID of the vulnerability


        :return: The id of this HostVulnerability.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HostVulnerability.
        ID of the vulnerability


        :param id: The id of this HostVulnerability.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HostVulnerability.
        Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in different compartments, based on scan target location


        :return: The compartment_id of this HostVulnerability.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HostVulnerability.
        Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in different compartments, based on scan target location


        :param compartment_id: The compartment_id of this HostVulnerability.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def authentication(self):
        """
        Gets the authentication of this HostVulnerability.
        Mechanism used for scan authentication


        :return: The authentication of this HostVulnerability.
        :rtype: str
        """
        return self._authentication

    @authentication.setter
    def authentication(self, authentication):
        """
        Sets the authentication of this HostVulnerability.
        Mechanism used for scan authentication


        :param authentication: The authentication of this HostVulnerability.
        :type: str
        """
        self._authentication = authentication

    @property
    def cve_reference(self):
        """
        Gets the cve_reference of this HostVulnerability.
        Reference to MITRE CVE ID


        :return: The cve_reference of this HostVulnerability.
        :rtype: str
        """
        return self._cve_reference

    @cve_reference.setter
    def cve_reference(self, cve_reference):
        """
        Sets the cve_reference of this HostVulnerability.
        Reference to MITRE CVE ID


        :param cve_reference: The cve_reference of this HostVulnerability.
        :type: str
        """
        self._cve_reference = cve_reference

    @property
    def cve_details(self):
        """
        Gets the cve_details of this HostVulnerability.

        :return: The cve_details of this HostVulnerability.
        :rtype: oci.vulnerability_scanning.models.CveDetails
        """
        return self._cve_details

    @cve_details.setter
    def cve_details(self, cve_details):
        """
        Sets the cve_details of this HostVulnerability.

        :param cve_details: The cve_details of this HostVulnerability.
        :type: oci.vulnerability_scanning.models.CveDetails
        """
        self._cve_details = cve_details

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this HostVulnerability.
        Severity of the vulnerability

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this HostVulnerability.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this HostVulnerability.
        Severity of the vulnerability


        :param severity: The severity of this HostVulnerability.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def state(self):
        """
        Gets the state of this HostVulnerability.
        State of the vulnerability

        Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this HostVulnerability.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this HostVulnerability.
        State of the vulnerability


        :param state: The state of this HostVulnerability.
        :type: str
        """
        allowed_values = ["OPEN", "FIXED", "NOT_APPLICABLE"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def name(self):
        """
        **[Required]** Gets the name of this HostVulnerability.
        Vulnerability name


        :return: The name of this HostVulnerability.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this HostVulnerability.
        Vulnerability name


        :param name: The name of this HostVulnerability.
        :type: str
        """
        self._name = name

    @property
    def time_last_detected(self):
        """
        **[Required]** Gets the time_last_detected of this HostVulnerability.
        Date of scan result that most recently reported the vulnerability


        :return: The time_last_detected of this HostVulnerability.
        :rtype: datetime
        """
        return self._time_last_detected

    @time_last_detected.setter
    def time_last_detected(self, time_last_detected):
        """
        Sets the time_last_detected of this HostVulnerability.
        Date of scan result that most recently reported the vulnerability


        :param time_last_detected: The time_last_detected of this HostVulnerability.
        :type: datetime
        """
        self._time_last_detected = time_last_detected

    @property
    def time_first_detected(self):
        """
        **[Required]** Gets the time_first_detected of this HostVulnerability.
        Date of scan result that first reported the vulnerability


        :return: The time_first_detected of this HostVulnerability.
        :rtype: datetime
        """
        return self._time_first_detected

    @time_first_detected.setter
    def time_first_detected(self, time_first_detected):
        """
        Sets the time_first_detected of this HostVulnerability.
        Date of scan result that first reported the vulnerability


        :param time_first_detected: The time_first_detected of this HostVulnerability.
        :type: datetime
        """
        self._time_first_detected = time_first_detected

    @property
    def host_count(self):
        """
        **[Required]** Gets the host_count of this HostVulnerability.
        Number of scanned hosts in this compartment whose scan results currently report this vulnerability


        :return: The host_count of this HostVulnerability.
        :rtype: int
        """
        return self._host_count

    @host_count.setter
    def host_count(self, host_count):
        """
        Sets the host_count of this HostVulnerability.
        Number of scanned hosts in this compartment whose scan results currently report this vulnerability


        :param host_count: The host_count of this HostVulnerability.
        :type: int
        """
        self._host_count = host_count

    @property
    def vulnerability_type(self):
        """
        **[Required]** Gets the vulnerability_type of this HostVulnerability.
        Specifies the type of Vulnerability

        Allowed values for this property are: "CVE", "PROBLEM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vulnerability_type of this HostVulnerability.
        :rtype: str
        """
        return self._vulnerability_type

    @vulnerability_type.setter
    def vulnerability_type(self, vulnerability_type):
        """
        Sets the vulnerability_type of this HostVulnerability.
        Specifies the type of Vulnerability


        :param vulnerability_type: The vulnerability_type of this HostVulnerability.
        :type: str
        """
        allowed_values = ["CVE", "PROBLEM"]
        if not value_allowed_none_or_none_sentinel(vulnerability_type, allowed_values):
            vulnerability_type = 'UNKNOWN_ENUM_VALUE'
        self._vulnerability_type = vulnerability_type

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this HostVulnerability.
        The current state of the resource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostVulnerability.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostVulnerability.
        The current state of the resource.


        :param lifecycle_state: The lifecycle_state of this HostVulnerability.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
