// SPDX-License-Identifier: (Apache-2.0 OR MIT)
// the constants and SIMD approach are adapted from cloudwego's sonic-rs

macro_rules! write_escape {
    ($escape:expr, $dst:expr) => {
        core::ptr::copy_nonoverlapping($escape.0.as_ptr(), $dst, 8);
    };
}

pub const NEED_ESCAPED: [u8; 256] = [
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];

pub const QUOTE_TAB: [([u8; 7], u8); 96] = [
    (*b"\\u0000\0", 6),
    (*b"\\u0001\0", 6),
    (*b"\\u0002\0", 6),
    (*b"\\u0003\0", 6),
    (*b"\\u0004\0", 6),
    (*b"\\u0005\0", 6),
    (*b"\\u0006\0", 6),
    (*b"\\u0007\0", 6),
    (*b"\\b\0\0\0\0\0", 2),
    (*b"\\t\0\0\0\0\0", 2),
    (*b"\\n\0\0\0\0\0", 2),
    (*b"\\u000b\0", 6),
    (*b"\\f\0\0\0\0\0", 2),
    (*b"\\r\0\0\0\0\0", 2),
    (*b"\\u000e\0", 6),
    (*b"\\u000f\0", 6),
    (*b"\\u0010\0", 6),
    (*b"\\u0011\0", 6),
    (*b"\\u0012\0", 6),
    (*b"\\u0013\0", 6),
    (*b"\\u0014\0", 6),
    (*b"\\u0015\0", 6),
    (*b"\\u0016\0", 6),
    (*b"\\u0017\0", 6),
    (*b"\\u0018\0", 6),
    (*b"\\u0019\0", 6),
    (*b"\\u001a\0", 6),
    (*b"\\u001b\0", 6),
    (*b"\\u001c\0", 6),
    (*b"\\u001d\0", 6),
    (*b"\\u001e\0", 6),
    (*b"\\u001f\0", 6),
    ([0; 7], 0),
    ([0; 7], 0),
    (*b"\\\"\0\0\0\0\0", 2),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
    (*b"\\\\\0\0\0\0\0", 2),
    ([0; 7], 0),
    ([0; 7], 0),
    ([0; 7], 0),
];
