#!/usr/bin/python

###############################################################################
# NAME: genedrop.py
# VERSION: 2.0.0a6 (25MAY2004)
# AUTHOR: John B. Cole, PhD (jcole@aipl.arsusda.gov)
# LICENSE: LGPL
###############################################################################

from pyp_classes import *
from pyp_io import *
from pyp_metrics import *
from pyp_nrm import *
from pyp_utils import *

if __name__=='__main__':

	print 'Starting pypedal.py at %s' % asctime(localtime(time()))

	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
	example = preprocess('boichard2.ped',sepchar=' ')
	print '\tCollecting pedigree metadata at %s' % asctime(localtime(time()))
	example_meta = Pedigree(example,'example.ped','example_meta')
	print '\tCalling effective_founder_genomes() at %s' % asctime(localtime(time()))
        effective_founder_genomes(example,filetag='boichard',rounds=200)

	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
        example = preprocess('boichard2a.ped',sepchar=' ')
        print '\tCollecting pedigree metadata at %s' % asctime(localtime(time()))
        example_meta = Pedigree(example,'example.ped','example_meta')
        print '\tCalling effective_founder_genomes() at %s' % asctime(localtime(time()))
        effective_founder_genomes(example,filetag='boichard2a',rounds=200)

	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
        example = preprocess('boichard2b.ped',sepchar=' ')
        print '\tCollecting pedigree metadata at %s' % asctime(localtime(time()))
        example_meta = Pedigree(example,'example.ped','example_meta')
        print '\tCalling effective_founder_genomes() at %s' % asctime(localtime(time()))
        effective_founder_genomes(example,filetag='boichard2b',rounds=200)

	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
        example = preprocess('lacy.ped',sepchar=' ')
        print '\tCollecting pedigree metadata at %s' % asctime(localtime(time()))
        example_meta = Pedigree(example,'lacy.ped','example_meta')
        print '\tCalling effective_founder_genomes() at %s' % asctime(localtime(time()))
        effective_founder_genomes(example,filetag='lacy',rounds=200)

	print 'Stopping pypedal.py at %s' % asctime(localtime(time()))
