#!/usr/bin/python

###############################################################################
# NAME: new_methods.py
# VERSION: 2.0.0a3 (19APR2004)
# AUTHOR: John B. Cole, PhD (jcole@aipl.arsusda.gov)
# LICENSE: LGPL
###############################################################################

from pyp_classes import *
from pyp_io import *
from pyp_metrics import *
from pyp_nrm import *
from pyp_utils import *

if __name__=='__main__':

	print 'Starting pypedal.py at %s' % asctime(localtime(time()))
	print '\tPreprocessing pedigree at %s' % asctime(localtime(time()))
	example = preprocess('boichard2.ped',sepchar=' ')
	example = renumber(example,'example',io='yes')
	print '\tCalling set_ancestor_flag at %s' % asctime(localtime(time()))
	set_ancestor_flag(example,'example',io='yes')
	print '\tCollecting pedigree metadata at %s' % asctime(localtime(time()))
	example_meta = Pedigree(example,'example.ped','example_meta')
	print '\tCalling related_animals() at %s' % asctime(localtime(time()))
	list_a = related_animals(example[6].animalID,example)
	print list_a
	print '\tCalling related_animals() at %s' % asctime(localtime(time()))
	list_b = related_animals(example[13].animalID,example)
	print list_b
	print '\tCalling common_ancestors() at %s' % asctime(localtime(time()))
	list_r = common_ancestors(example[6].animalID,example[13].animalID,example)
	print list_r
	print 'Stopping pypedal.py at %s' % asctime(localtime(time()))