# pointpats: Point Pattern Analysis in PySAL

[![Continuous Integration](https://github.com/pysal/pointpats/actions/workflows/tests.yaml/badge.svg)](https://github.com/pysal/pointpats/actions/workflows/tests.yaml)
[![codecov](https://codecov.io/gh/pysal/pointpats/branch/master/graph/badge.svg)](https://codecov.io/gh/pysal/pointpats)
[![Documentation Status](https://readthedocs.org/projects/pointpats/badge/?version=latest)](https://pointpats.readthedocs.io/en/latest/?badge=latest)
[![PyPI version](https://badge.fury.io/py/pointpats.svg)](https://badge.fury.io/py/pointpats)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3265637.svg)](https://doi.org/10.5281/zenodo.3265637)

Statistical analysis of planar point patterns.

This package is part of [PySAL](https://pysal.org): The Python Spatial Analysis Library.

## Introduction

This [pointpats](https://github.com/pysal/pointpats) package is intended
to support the statistical analysis of planar point patterns.

It currently works on cartesian coordinates. Users with data in
geographic coordinates need to project their data prior to using this
module.

## Documentation

Online documentation is available
[here](https://pointpats.readthedocs.io).

## Examples

- [Basic point pattern
    structure](https://github.com/pysal/pointpats/tree/main/notebooks/pointpattern.ipynb)
- [Centrography and
    visualization](https://github.com/pysal/pointpats/tree/main/notebooks/centrography.ipynb)
- [Marks](https://github.com/pysal/pointpats/tree/main/notebooks/marks.ipynb)
- [Simulation of point
    processes](https://github.com/pysal/pointpats/tree/main/notebooks/process.ipynb)
- [Distance based
    statistics](https://github.com/pysal/pointpats/tree/main/notebooks/distance_statistics-numpy-oriented.ipynb)

##  Installation

Install pointpats by running:

    $ pip install pointpats

## Development

pointpats development is hosted on
[github](https://github.com/pysal/pointpats).

As part of the PySAL project, pointpats development follows these
[guidelines](http://pysal.org/getting_started).

##  Bug reports

To search for or report bugs, please see pointpats'
[issues](https://github.com/pysal/pointpats/issues).

##  BibTeX Citation

```
@misc{sergio_rey_2019_3265637,
  author       = {Sergio Rey and
                  Wei Kang and
                  Hu Shao and
                  Levi John Wolf and
                  Mridul Seth and
                  James Gaboardi and
                  Dani Arribas-Bel},
  title        = {pysal/pointpats: pointpats 2.1.0},
  month        = jul,
  year         = 2019,
  doi          = {10.5281/zenodo.3265637},
  url          = {https://doi.org/10.5281/zenodo.3265637}
}
```
