# History of changes

## Version 5.0alpha5 (2021-02-23)

### Pull Requests Merged

* [PR 14796](https://github.com/spyder-ide/spyder/pull/14796) - PR: Fix plugin dependencies solver, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14782](https://github.com/spyder-ide/spyder/pull/14782) - PR: Several fixes to load external plugins, by [@ccordoba12](https://github.com/ccordoba12)

In this release 2 pull requests were closed.


----


## Version 5.0alpha4 (2021-02-14)

### Issues Closed

* [Issue 14661](https://github.com/spyder-ide/spyder/issues/14661) - There's a blank space in the menus in the top in macOS ([PR 14682](https://github.com/spyder-ide/spyder/pull/14682) by [@dalthviz](https://github.com/dalthviz))
* [Issue 14612](https://github.com/spyder-ide/spyder/issues/14612) - View and Help application menus are not being display in master. ([PR 14619](https://github.com/spyder-ide/spyder/pull/14619) by [@dalthviz](https://github.com/dalthviz))
* [Issue 14537](https://github.com/spyder-ide/spyder/issues/14537) - Migrate Spyder preferences dialog to a separate plugin ([PR 14536](https://github.com/spyder-ide/spyder/pull/14536) by [@andfoy](https://github.com/andfoy))
* [Issue 12195](https://github.com/spyder-ide/spyder/issues/12195) - Move Explorer/Projects plugin to use new API ([PR 14596](https://github.com/spyder-ide/spyder/pull/14596) by [@steff456](https://github.com/steff456))

In this release 4 issues were closed.

### Pull Requests Merged

* [PR 14737](https://github.com/spyder-ide/spyder/pull/14737) - PR: Update code of conduct with version 2.0 of Contributor Covenant's one, by [@juanis2112](https://github.com/juanis2112)
* [PR 14721](https://github.com/spyder-ide/spyder/pull/14721) - PR: Minor editor refactoring, by [@steff456](https://github.com/steff456)
* [PR 14690](https://github.com/spyder-ide/spyder/pull/14690) - PR: Update the date of copyright notice, by [@storm-sergey](https://github.com/storm-sergey)
* [PR 14682](https://github.com/spyder-ide/spyder/pull/14682) - PR: Add flag to prevent adding initial empty QAction on Mac for non-migrated menus, by [@dalthviz](https://github.com/dalthviz) ([14661](https://github.com/spyder-ide/spyder/issues/14661))
* [PR 14628](https://github.com/spyder-ide/spyder/pull/14628) - PR: Add button to show and hide replace widget from find widget, by [@juanis2112](https://github.com/juanis2112) ([25](https://github.com/spyder-ide/ux-improvements/issues/25))
* [PR 14619](https://github.com/spyder-ide/spyder/pull/14619) - PR: Support dynamic menus on Mac, by [@dalthviz](https://github.com/dalthviz) ([14612](https://github.com/spyder-ide/spyder/issues/14612))
* [PR 14614](https://github.com/spyder-ide/spyder/pull/14614) - PR: Remove secondary toolbars from toolbars in view menu, by [@juanis2112](https://github.com/juanis2112)
* [PR 14596](https://github.com/spyder-ide/spyder/pull/14596) - PR: Migrate Files to the new API, by [@steff456](https://github.com/steff456) ([12195](https://github.com/spyder-ide/spyder/issues/12195))
* [PR 14592](https://github.com/spyder-ide/spyder/pull/14592) - PR: Fix wrong spelled words, by [@freddii](https://github.com/freddii)
* [PR 14586](https://github.com/spyder-ide/spyder/pull/14586) - PR: Add a new Application plugin, by [@dalthviz](https://github.com/dalthviz)
* [PR 14584](https://github.com/spyder-ide/spyder/pull/14584) - PR: Fix spelling mistakes in comments and docstrings, by [@freddii](https://github.com/freddii)
* [PR 14576](https://github.com/spyder-ide/spyder/pull/14576) - PR: Add STIL to the list of supported languages, by [@andfoy](https://github.com/andfoy)
* [PR 14562](https://github.com/spyder-ide/spyder/pull/14562) - PR: Add color system file for new scale of colors in Spyder 5, by [@juanis2112](https://github.com/juanis2112)
* [PR 14536](https://github.com/spyder-ide/spyder/pull/14536) - PR: Migrate Spyder preference dialog to a plugin of the new API, by [@andfoy](https://github.com/andfoy) ([14537](https://github.com/spyder-ide/spyder/issues/14537))
* [PR 14320](https://github.com/spyder-ide/spyder/pull/14320) - PR: Create status bar plugin (New API), by [@ccordoba12](https://github.com/ccordoba12)

In this release 15 pull requests were closed.


----


## Version 5.0alpha3 (2021-01-08)

### Issues Closed

* [Issue 13698](https://github.com/spyder-ide/spyder/issues/13698) - Profiler pane issues and details ([PR 13711](https://github.com/spyder-ide/spyder/pull/13711) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13657](https://github.com/spyder-ide/spyder/issues/13657) - Find pane issues and details ([PR 13675](https://github.com/spyder-ide/spyder/pull/13675) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13103](https://github.com/spyder-ide/spyder/issues/13103) - Move Main Interpreter preferences to new Plugin API ([PR 13104](https://github.com/spyder-ide/spyder/pull/13104) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12183](https://github.com/spyder-ide/spyder/issues/12183) - Move Pylint plugin to use new API ([PR 12160](https://github.com/spyder-ide/spyder/pull/12160) by [@goanpeca](https://github.com/goanpeca))

In this release 4 issues were closed.

### Pull Requests Merged

* [PR 14498](https://github.com/spyder-ide/spyder/pull/14498) - PR: Fix two typos in Contributing guide, by [@real-yfprojects](https://github.com/real-yfprojects)
* [PR 14449](https://github.com/spyder-ide/spyder/pull/14449) - PR: Fix wrong import (Testing), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14388](https://github.com/spyder-ide/spyder/pull/14388) - PR: Fix changing directory when opening and closing projects, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14370](https://github.com/spyder-ide/spyder/pull/14370) - PR: Fix some real and some potential bugs, by [@novaya](https://github.com/novaya)
* [PR 14319](https://github.com/spyder-ide/spyder/pull/14319) - PR: Fix typo in variable name, by [@novaya](https://github.com/novaya)
* [PR 14283](https://github.com/spyder-ide/spyder/pull/14283) - PR: Fix wrong import (Code analysis), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13711](https://github.com/spyder-ide/spyder/pull/13711) - PR: Fix some issues with the profiler, by [@goanpeca](https://github.com/goanpeca) ([13698](https://github.com/spyder-ide/spyder/issues/13698))
* [PR 13675](https://github.com/spyder-ide/spyder/pull/13675) - PR: Fix some issues with the Find in files plugin, by [@goanpeca](https://github.com/goanpeca) ([13657](https://github.com/spyder-ide/spyder/issues/13657))
* [PR 13547](https://github.com/spyder-ide/spyder/pull/13547) - PR: Add new toolbar plugin, by [@goanpeca](https://github.com/goanpeca)
* [PR 13542](https://github.com/spyder-ide/spyder/pull/13542) - PR: Create new MainMenu plugin, by [@goanpeca](https://github.com/goanpeca)
* [PR 13104](https://github.com/spyder-ide/spyder/pull/13104) - PR: Migrate Main interpreter to new plugin API, by [@goanpeca](https://github.com/goanpeca) ([13103](https://github.com/spyder-ide/spyder/issues/13103))
* [PR 12160](https://github.com/spyder-ide/spyder/pull/12160) - PR: Move Pylint plugin to new API, by [@goanpeca](https://github.com/goanpeca) ([12183](https://github.com/spyder-ide/spyder/issues/12183))

In this release 12 pull requests were closed.


----


## Version 5.0alpha2 (2020-11-12)

### Issues Closed

* [Issue 13947](https://github.com/spyder-ide/spyder/issues/13947) - Fix import in test_mainwindow after merge of #13828 ([PR 13948](https://github.com/spyder-ide/spyder/pull/13948) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13695](https://github.com/spyder-ide/spyder/issues/13695) - [API] Support adding icons to menus ([PR 13709](https://github.com/spyder-ide/spyder/pull/13709) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13684](https://github.com/spyder-ide/spyder/issues/13684) - Differences in online help pane toolbar ([PR 13686](https://github.com/spyder-ide/spyder/pull/13686) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13683](https://github.com/spyder-ide/spyder/issues/13683) - The icon of internal console settings disappeared  ([PR 13689](https://github.com/spyder-ide/spyder/pull/13689) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13670](https://github.com/spyder-ide/spyder/issues/13670) - Breakpoint's hamburger menu has duplicated options than in context menu ([PR 13672](https://github.com/spyder-ide/spyder/pull/13672) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13665](https://github.com/spyder-ide/spyder/issues/13665) - Spyder crashes with `select all` + `copy all` in the help pane ([PR 13676](https://github.com/spyder-ide/spyder/pull/13676) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13659](https://github.com/spyder-ide/spyder/issues/13659) - Plots pane issues and details ([PR 13677](https://github.com/spyder-ide/spyder/pull/13677) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13524](https://github.com/spyder-ide/spyder/issues/13524) - "Run in current namespace" missing in Spyder 5.0.0a1 ([PR 13528](https://github.com/spyder-ide/spyder/pull/13528) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13422](https://github.com/spyder-ide/spyder/issues/13422) - After new Spyder IDE installation, clicked on popup to read "tutorial" ([PR 13529](https://github.com/spyder-ide/spyder/pull/13529) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13096](https://github.com/spyder-ide/spyder/issues/13096) - Move shortcut standalone preferences page to new plugin with new API ([PR 13097](https://github.com/spyder-ide/spyder/pull/13097) by [@goanpeca](https://github.com/goanpeca))
* [Issue 10722](https://github.com/spyder-ide/spyder/issues/10722) - Move creation of actions and shortcuts to the plugin API ([PR 13097](https://github.com/spyder-ide/spyder/pull/13097) by [@goanpeca](https://github.com/goanpeca))

In this release 11 issues were closed.

### Pull Requests Merged

* [PR 14018](https://github.com/spyder-ide/spyder/pull/14018) - PR: Update script installer to handle python-slugify package, by [@dalthviz](https://github.com/dalthviz)
* [PR 14015](https://github.com/spyder-ide/spyder/pull/14015) - PR: Use our convention for os.path to fix import error (Breakpoints), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13948](https://github.com/spyder-ide/spyder/pull/13948) - PR: Fix EmptyProject test fixture. Remove notify_project_open call, by [@dalthviz](https://github.com/dalthviz) ([13947](https://github.com/spyder-ide/spyder/issues/13947))
* [PR 13904](https://github.com/spyder-ide/spyder/pull/13904) - PR: Add missing instruction to Maintenance guide, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13886](https://github.com/spyder-ide/spyder/pull/13886) - PR: Update duplicate messages after the release of 4.1.5, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13874](https://github.com/spyder-ide/spyder/pull/13874) - PR: Fix loading of external (non dockable) plugins and other fixes, by [@goanpeca](https://github.com/goanpeca)
* [PR 13871](https://github.com/spyder-ide/spyder/pull/13871) - PR: Add some instructions for maintainers, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13709](https://github.com/spyder-ide/spyder/pull/13709) - PR: Add icon to menu creation mixin, by [@goanpeca](https://github.com/goanpeca) ([13695](https://github.com/spyder-ide/spyder/issues/13695))
* [PR 13689](https://github.com/spyder-ide/spyder/pull/13689) - PR: Restore submenu icon on internal console settings, by [@goanpeca](https://github.com/goanpeca) ([13683](https://github.com/spyder-ide/spyder/issues/13683))
* [PR 13686](https://github.com/spyder-ide/spyder/pull/13686) - PR: Update placeholder text in Online Help plugin, by [@goanpeca](https://github.com/goanpeca) ([13684](https://github.com/spyder-ide/spyder/issues/13684))
* [PR 13677](https://github.com/spyder-ide/spyder/pull/13677) - PR: Fix several issues with the plots pane from API migration, by [@goanpeca](https://github.com/goanpeca) ([13659](https://github.com/spyder-ide/spyder/issues/13659))
* [PR 13676](https://github.com/spyder-ide/spyder/pull/13676) - PR: Rename original browser copy action, by [@goanpeca](https://github.com/goanpeca) ([13665](https://github.com/spyder-ide/spyder/issues/13665))
* [PR 13672](https://github.com/spyder-ide/spyder/pull/13672) - PR: Remove actions from breakpoints options menu, by [@goanpeca](https://github.com/goanpeca) ([13670](https://github.com/spyder-ide/spyder/issues/13670))
* [PR 13600](https://github.com/spyder-ide/spyder/pull/13600) - PR:  Refactor the toolbar handling on main widgets, by [@goanpeca](https://github.com/goanpeca)
* [PR 13529](https://github.com/spyder-ide/spyder/pull/13529) - PR: Fix error when showing context menu on Help plugin, by [@goanpeca](https://github.com/goanpeca) ([13422](https://github.com/spyder-ide/spyder/issues/13422))
* [PR 13528](https://github.com/spyder-ide/spyder/pull/13528) - PR: Fix missing Run section on Preferences, by [@goanpeca](https://github.com/goanpeca) ([13524](https://github.com/spyder-ide/spyder/issues/13524))
* [PR 13440](https://github.com/spyder-ide/spyder/pull/13440) - PR: Create a simple code editor and use that for other plugins, by [@goanpeca](https://github.com/goanpeca)
* [PR 13097](https://github.com/spyder-ide/spyder/pull/13097) - PR: Move shortcuts to new API, by [@goanpeca](https://github.com/goanpeca) ([13096](https://github.com/spyder-ide/spyder/issues/13096), [10722](https://github.com/spyder-ide/spyder/issues/10722))

In this release 18 pull requests were closed.


----


## Version 5.0alpha1 (2020-08-04)

### Issues Closed

* [Issue 13471](https://github.com/spyder-ide/spyder/issues/13471) - Recursing problem with new plugin API on master ([PR 13472](https://github.com/spyder-ide/spyder/pull/13472) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13378](https://github.com/spyder-ide/spyder/issues/13378) - Some problems with the Find plugin in master ([PR 13398](https://github.com/spyder-ide/spyder/pull/13398) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13310](https://github.com/spyder-ide/spyder/issues/13310) - Traceback from the Files pane (AttributeError: 'FindInFilesWidget' object has no attribute 'extras_toolbar') ([PR 13316](https://github.com/spyder-ide/spyder/pull/13316) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13142](https://github.com/spyder-ide/spyder/issues/13142) - Spyder prints "code True" in internal console ([PR 13208](https://github.com/spyder-ide/spyder/pull/13208) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13127](https://github.com/spyder-ide/spyder/issues/13127) - All plugins in the new API are shown after startup ([PR 13208](https://github.com/spyder-ide/spyder/pull/13208) by [@goanpeca](https://github.com/goanpeca))
* [Issue 13099](https://github.com/spyder-ide/spyder/issues/13099) - Migrate RunConfig to Plugin with new API ([PR 13100](https://github.com/spyder-ide/spyder/pull/13100) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12938](https://github.com/spyder-ide/spyder/issues/12938) - Add cookicutter handling and UI generation ([PR 12924](https://github.com/spyder-ide/spyder/pull/12924) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12798](https://github.com/spyder-ide/spyder/issues/12798) - Create new Appearance Plugin using new API ([PR 12793](https://github.com/spyder-ide/spyder/pull/12793) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12760](https://github.com/spyder-ide/spyder/issues/12760) - Move Working Directory to new API ([PR 12756](https://github.com/spyder-ide/spyder/pull/12756) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12727](https://github.com/spyder-ide/spyder/issues/12727) - Move Internal Console plugin to new API ([PR 12438](https://github.com/spyder-ide/spyder/pull/12438) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12725](https://github.com/spyder-ide/spyder/issues/12725) - Move collections editor out of Variable Explorer into widgets ([PR 12726](https://github.com/spyder-ide/spyder/pull/12726) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12488](https://github.com/spyder-ide/spyder/issues/12488) - An idea to improve the visual of the 'Lock panes and toolbars' action in the View menu ([PR 12527](https://github.com/spyder-ide/spyder/pull/12527) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 12325](https://github.com/spyder-ide/spyder/issues/12325) - Move Breakpoints plugin to use new API ([PR 12324](https://github.com/spyder-ide/spyder/pull/12324) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12191](https://github.com/spyder-ide/spyder/issues/12191) - Move Profiler plugin to use new API ([PR 12377](https://github.com/spyder-ide/spyder/pull/12377) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12190](https://github.com/spyder-ide/spyder/issues/12190) - Move History plugin to use new API ([PR 12490](https://github.com/spyder-ide/spyder/pull/12490) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12189](https://github.com/spyder-ide/spyder/issues/12189) - Move Find in files plugin to use new API ([PR 12382](https://github.com/spyder-ide/spyder/pull/12382) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12187](https://github.com/spyder-ide/spyder/issues/12187) - Move Online Help plugin to use new API  ([PR 12330](https://github.com/spyder-ide/spyder/pull/12330) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12186](https://github.com/spyder-ide/spyder/issues/12186) - Move Help plugin to use new API ([PR 12338](https://github.com/spyder-ide/spyder/pull/12338) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12182](https://github.com/spyder-ide/spyder/issues/12182) - Move Plots plugin to use new API ([PR 12196](https://github.com/spyder-ide/spyder/pull/12196) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12180](https://github.com/spyder-ide/spyder/issues/12180) - Modernize global plugin API ([PR 11741](https://github.com/spyder-ide/spyder/pull/11741) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12130](https://github.com/spyder-ide/spyder/issues/12130) - Update plots plugin to python 3 ([PR 12131](https://github.com/spyder-ide/spyder/pull/12131) by [@steff456](https://github.com/steff456))
* [Issue 12002](https://github.com/spyder-ide/spyder/issues/12002) - spyder-kernels dependency not correctly detected for dev version ([PR 12017](https://github.com/spyder-ide/spyder/pull/12017) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11839](https://github.com/spyder-ide/spyder/issues/11839) - Move find in files plugin to python3 ([PR 11840](https://github.com/spyder-ide/spyder/pull/11840) by [@steff456](https://github.com/steff456))
* [Issue 11725](https://github.com/spyder-ide/spyder/issues/11725) - Move PyLint plugin to Python 3 ([PR 11816](https://github.com/spyder-ide/spyder/pull/11816) by [@steff456](https://github.com/steff456))
* [Issue 11616](https://github.com/spyder-ide/spyder/issues/11616) - Move breakpoints plugin to python3 only ([PR 11815](https://github.com/spyder-ide/spyder/pull/11815) by [@steff456](https://github.com/steff456))

In this release 25 issues were closed.

### Pull Requests Merged

* [PR 13472](https://github.com/spyder-ide/spyder/pull/13472) - PR: Fix parent of project type, by [@goanpeca](https://github.com/goanpeca) ([13471](https://github.com/spyder-ide/spyder/issues/13471))
* [PR 13460](https://github.com/spyder-ide/spyder/pull/13460) - PR: Use Binder images from our binder-environments repo, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13414](https://github.com/spyder-ide/spyder/pull/13414) - PR: Remove duplicate preferences pages, by [@goanpeca](https://github.com/goanpeca)
* [PR 13403](https://github.com/spyder-ide/spyder/pull/13403) - PR: Move completion plugin files to manager plugin and create a completions.manager.api file, by [@goanpeca](https://github.com/goanpeca)
* [PR 13400](https://github.com/spyder-ide/spyder/pull/13400) - PR: Find internal plugins in plugin module for Spyder installs, by [@goanpeca](https://github.com/goanpeca)
* [PR 13398](https://github.com/spyder-ide/spyder/pull/13398) - PR: Add option to disable tooltip on toolbars when creating actions, by [@goanpeca](https://github.com/goanpeca) ([13378](https://github.com/spyder-ide/spyder/issues/13378))
* [PR 13375](https://github.com/spyder-ide/spyder/pull/13375) - PR: Generalize error reporting via signal and simplify widget, by [@goanpeca](https://github.com/goanpeca)
* [PR 13367](https://github.com/spyder-ide/spyder/pull/13367) - PR: Add file hover-go-to relative to project root, by [@goanpeca](https://github.com/goanpeca)
* [PR 13317](https://github.com/spyder-ide/spyder/pull/13317) - PR: Add name validation and status of project methods, by [@goanpeca](https://github.com/goanpeca)
* [PR 13316](https://github.com/spyder-ide/spyder/pull/13316) - PR: Add check for extras_toolbar existence, by [@goanpeca](https://github.com/goanpeca) ([13310](https://github.com/spyder-ide/spyder/issues/13310))
* [PR 13299](https://github.com/spyder-ide/spyder/pull/13299) - PR: Fix project logic to allow for extra dialogs, by [@goanpeca](https://github.com/goanpeca)
* [PR 13290](https://github.com/spyder-ide/spyder/pull/13290) - PR: Display external plugins in the dependencies dialog, by [@goanpeca](https://github.com/goanpeca)
* [PR 13280](https://github.com/spyder-ide/spyder/pull/13280) - PR: Add intermediate Project API while new API migration is finished, by [@goanpeca](https://github.com/goanpeca)
* [PR 13278](https://github.com/spyder-ide/spyder/pull/13278) - PR: Fix toolbar title and tabify of external plugins, by [@goanpeca](https://github.com/goanpeca)
* [PR 13208](https://github.com/spyder-ide/spyder/pull/13208) - PR: Fix visible plugins on restart and online server start, by [@goanpeca](https://github.com/goanpeca) ([13142](https://github.com/spyder-ide/spyder/issues/13142), [13127](https://github.com/spyder-ide/spyder/issues/13127))
* [PR 13186](https://github.com/spyder-ide/spyder/pull/13186) - PR: Fix a wrong import in our tests, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13151](https://github.com/spyder-ide/spyder/pull/13151) - PR: Fix test_lsp_config_dialog, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13143](https://github.com/spyder-ide/spyder/pull/13143) - PR: Fix showing internal errors, by [@impact27](https://github.com/impact27)
* [PR 13122](https://github.com/spyder-ide/spyder/pull/13122) - PR: Fix spelling error in tutorial (Help), by [@scottwedge](https://github.com/scottwedge)
* [PR 13116](https://github.com/spyder-ide/spyder/pull/13116) - PR: Fix rename of CodeEditor kwarg (History), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13100](https://github.com/spyder-ide/spyder/pull/13100) - PR: Migrate RunConfig to Plugin with new API, by [@goanpeca](https://github.com/goanpeca) ([13099](https://github.com/spyder-ide/spyder/issues/13099))
* [PR 13070](https://github.com/spyder-ide/spyder/pull/13070) - WIP: Add ability to hot start some plugins., by [@goanpeca](https://github.com/goanpeca) ([13067](https://github.com/spyder-ide/spyder/issues/13067))
* [PR 12965](https://github.com/spyder-ide/spyder/pull/12965) - PR: Fix reporting internal PyLS errors and generalize reporting error mechanism, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12961](https://github.com/spyder-ide/spyder/pull/12961) - PR: Add job to build docs, by [@goanpeca](https://github.com/goanpeca)
* [PR 12924](https://github.com/spyder-ide/spyder/pull/12924) - PR: Add cookiecutter widget, by [@goanpeca](https://github.com/goanpeca) ([12938](https://github.com/spyder-ide/spyder/issues/12938))
* [PR 12893](https://github.com/spyder-ide/spyder/pull/12893) - PR: Add entry point plugin discovery and add plugin deps solver, by [@goanpeca](https://github.com/goanpeca)
* [PR 12793](https://github.com/spyder-ide/spyder/pull/12793) - PR: Create a new Appearance plugin, by [@goanpeca](https://github.com/goanpeca) ([12798](https://github.com/spyder-ide/spyder/issues/12798))
* [PR 12756](https://github.com/spyder-ide/spyder/pull/12756) - PR: Migrate Working Directory plugin to the new API, by [@goanpeca](https://github.com/goanpeca) ([12760](https://github.com/spyder-ide/spyder/issues/12760))
* [PR 12726](https://github.com/spyder-ide/spyder/pull/12726) - PR: Move collections editor out of the Variable Explorer and into the widgets module, by [@goanpeca](https://github.com/goanpeca) ([12725](https://github.com/spyder-ide/spyder/issues/12725))
* [PR 12669](https://github.com/spyder-ide/spyder/pull/12669) - PR: Update duplicates.yml, by [@goanpeca](https://github.com/goanpeca)
* [PR 12527](https://github.com/spyder-ide/spyder/pull/12527) - PR: Change icon and text of 'Lock Interface Action' when clicked, by [@jnsebgosselin](https://github.com/jnsebgosselin) ([12488](https://github.com/spyder-ide/spyder/issues/12488))
* [PR 12490](https://github.com/spyder-ide/spyder/pull/12490) - PR: Migrate History Plugin to new API, by [@goanpeca](https://github.com/goanpeca) ([12190](https://github.com/spyder-ide/spyder/issues/12190))
* [PR 12438](https://github.com/spyder-ide/spyder/pull/12438) - PR: Migrate Console Plugin to the new API, by [@goanpeca](https://github.com/goanpeca) ([12727](https://github.com/spyder-ide/spyder/issues/12727))
* [PR 12382](https://github.com/spyder-ide/spyder/pull/12382) - PR: Migrate Find in files plugin to new API, by [@goanpeca](https://github.com/goanpeca) ([12189](https://github.com/spyder-ide/spyder/issues/12189))
* [PR 12377](https://github.com/spyder-ide/spyder/pull/12377) - PR: Migrate Profiler to new API, by [@goanpeca](https://github.com/goanpeca) ([12191](https://github.com/spyder-ide/spyder/issues/12191))
* [PR 12338](https://github.com/spyder-ide/spyder/pull/12338) - PR: Migrate Help plugin to new API, by [@goanpeca](https://github.com/goanpeca) ([12186](https://github.com/spyder-ide/spyder/issues/12186))
* [PR 12330](https://github.com/spyder-ide/spyder/pull/12330) - PR: Move Online help to new API , by [@goanpeca](https://github.com/goanpeca) ([12187](https://github.com/spyder-ide/spyder/issues/12187))
* [PR 12324](https://github.com/spyder-ide/spyder/pull/12324) - PR: Move Breakpoints Plugin to new API, by [@goanpeca](https://github.com/goanpeca) ([12325](https://github.com/spyder-ide/spyder/issues/12325))
* [PR 12196](https://github.com/spyder-ide/spyder/pull/12196) - PR: Move Plots to use new Plugin API, by [@goanpeca](https://github.com/goanpeca) ([12182](https://github.com/spyder-ide/spyder/issues/12182))
* [PR 12131](https://github.com/spyder-ide/spyder/pull/12131) - PR: Update plots plugin to Python 3, by [@steff456](https://github.com/steff456) ([12130](https://github.com/spyder-ide/spyder/issues/12130))
* [PR 12017](https://github.com/spyder-ide/spyder/pull/12017) - PR: Update spyder-kernels requirement for Spyder 5, by [@ccordoba12](https://github.com/ccordoba12) ([12002](https://github.com/spyder-ide/spyder/issues/12002))
* [PR 11935](https://github.com/spyder-ide/spyder/pull/11935) - PR: Spelling correction, by [@michelwoo](https://github.com/michelwoo)
* [PR 11840](https://github.com/spyder-ide/spyder/pull/11840) - PR: Update Find plugin to Python 3, by [@steff456](https://github.com/steff456) ([11839](https://github.com/spyder-ide/spyder/issues/11839))
* [PR 11816](https://github.com/spyder-ide/spyder/pull/11816) - PR: Update Pylint plugin to Python 3, by [@steff456](https://github.com/steff456) ([11725](https://github.com/spyder-ide/spyder/issues/11725))
* [PR 11815](https://github.com/spyder-ide/spyder/pull/11815) - PR: Update Breakpoints plugin to Python 3, by [@steff456](https://github.com/steff456) ([11616](https://github.com/spyder-ide/spyder/issues/11616))
* [PR 11741](https://github.com/spyder-ide/spyder/pull/11741) - PR: Create new API for plugins and widgets, by [@goanpeca](https://github.com/goanpeca) ([12180](https://github.com/spyder-ide/spyder/issues/12180))
* [PR 10963](https://github.com/spyder-ide/spyder/pull/10963) - PR: Remove Python 2 and 3.5 from our CIs, by [@ccordoba12](https://github.com/ccordoba12)

In this release 47 pull requests were closed.


----


## Version 4.2.2 (2021-02-22)

### Important fixes
* Improve performance when typing in the editor.
* Make variable explorer work for kernels started in remote servers.
* Fix using TKinter in the Windows and macOS installers.

### Issues Closed

* [Issue 14779](https://github.com/spyder-ide/spyder/issues/14779) - SystemError when switching projects ([PR 14791](https://github.com/spyder-ide/spyder/pull/14791) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14730](https://github.com/spyder-ide/spyder/issues/14730) - Bug at code folding of code cells
* [Issue 14656](https://github.com/spyder-ide/spyder/issues/14656) - Tk graphics backend is giving error on Big Sur with DMG installer
* [Issue 14653](https://github.com/spyder-ide/spyder/issues/14653) - Possible Black Autoformat Bug ([PR 14759](https://github.com/spyder-ide/spyder/pull/14759) by [@andfoy](https://github.com/andfoy))
* [Issue 14570](https://github.com/spyder-ide/spyder/issues/14570) - Lags appear when typing in large files in the editor ([PR 14574](https://github.com/spyder-ide/spyder/pull/14574) by [@andfoy](https://github.com/andfoy))
* [Issue 14551](https://github.com/spyder-ide/spyder/issues/14551) - functools.cached_property doesn't behave as expected in the spyder console ([PR 14715](https://github.com/spyder-ide/spyder/pull/14715) by [@impact27](https://github.com/impact27))
* [Issue 14542](https://github.com/spyder-ide/spyder/issues/14542) - Opening Dataframe in Variable Explorer not working with packaged 4.2.1 dmg version of Spyder ([PR 14545](https://github.com/spyder-ide/spyder/pull/14545) by [@mrclary](https://github.com/mrclary))
* [Issue 14535](https://github.com/spyder-ide/spyder/issues/14535) - DeprecationWarning: implicit conversion to integers in spyder/widgets/colors.py:78 ([PR 14543](https://github.com/spyder-ide/spyder/pull/14543) by [@juliangilbey](https://github.com/juliangilbey))
* [Issue 14527](https://github.com/spyder-ide/spyder/issues/14527) - Variable explorer sorting by Size ([PR 14761](https://github.com/spyder-ide/spyder/pull/14761) by [@steff456](https://github.com/steff456))
* [Issue 14499](https://github.com/spyder-ide/spyder/issues/14499) - outline view display variables and attributes
* [Issue 14483](https://github.com/spyder-ide/spyder/issues/14483) - Launch Issues with 4.2.1 and macOS ([PR 14564](https://github.com/spyder-ide/spyder/pull/14564) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14477](https://github.com/spyder-ide/spyder/issues/14477) - Debugger ignores some tuple assignments ([PR 14484](https://github.com/spyder-ide/spyder/pull/14484) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14476](https://github.com/spyder-ide/spyder/issues/14476) - Make Pdb continuation prompt consistent ([PR 14478](https://github.com/spyder-ide/spyder/pull/14478) by [@impact27](https://github.com/impact27))
* [Issue 14472](https://github.com/spyder-ide/spyder/issues/14472) - Hitting debug twice makes it unable to continue ([PR 14711](https://github.com/spyder-ide/spyder/pull/14711) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14413](https://github.com/spyder-ide/spyder/issues/14413) - TypeError in Outline explorer ([PR 14757](https://github.com/spyder-ide/spyder/pull/14757) by [@andfoy](https://github.com/andfoy))
* [Issue 14385](https://github.com/spyder-ide/spyder/issues/14385) - Tkinter failed to import ([PR 14727](https://github.com/spyder-ide/spyder/pull/14727) by [@dalthviz](https://github.com/dalthviz))
* [Issue 14380](https://github.com/spyder-ide/spyder/issues/14380) - Debug mode not working on win10 for any code ([PR 14382](https://github.com/spyder-ide/spyder/pull/14382) by [@impact27](https://github.com/impact27))
* [Issue 14374](https://github.com/spyder-ide/spyder/issues/14374) - Matching bracket highlighting index error ([PR 14376](https://github.com/spyder-ide/spyder/pull/14376) by [@hengin](https://github.com/hengin))
* [Issue 14273](https://github.com/spyder-ide/spyder/issues/14273) - Spyder crashes after Monitor Scale change ([PR 14696](https://github.com/spyder-ide/spyder/pull/14696) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13252](https://github.com/spyder-ide/spyder/issues/13252) - Can't set custom interpreters in Preferences on macOS ([PR 14565](https://github.com/spyder-ide/spyder/pull/14565) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12663](https://github.com/spyder-ide/spyder/issues/12663) - Cursor moves position after deleting a character and changing line ([PR 14559](https://github.com/spyder-ide/spyder/pull/14559) by [@hengin](https://github.com/hengin))
* [Issue 11538](https://github.com/spyder-ide/spyder/issues/11538) - Variable explorer doesn't show variables on remote kernel ([PR 14447](https://github.com/spyder-ide/spyder/pull/14447) by [@impact27](https://github.com/impact27))
* [Issue 9179](https://github.com/spyder-ide/spyder/issues/9179) - brace matching confused by strings with braces ([PR 14376](https://github.com/spyder-ide/spyder/pull/14376) by [@hengin](https://github.com/hengin))
* [Issue 5401](https://github.com/spyder-ide/spyder/issues/5401) - Ctrl+C not working when using input on Windows ([PR 14557](https://github.com/spyder-ide/spyder/pull/14557) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 2965](https://github.com/spyder-ide/spyder/issues/2965) - Parenthesis highlight in the Editor is inconsistent ([PR 14376](https://github.com/spyder-ide/spyder/pull/14376) by [@hengin](https://github.com/hengin))
* [Issue 1354](https://github.com/spyder-ide/spyder/issues/1354) - The editor adds ":" when type in multiply lines list comprehension ([PR 14376](https://github.com/spyder-ide/spyder/pull/14376) by [@hengin](https://github.com/hengin))

In this release 26 issues were closed.

### Pull Requests Merged

* [PR 14794](https://github.com/spyder-ide/spyder/pull/14794) - PR: Update core dependencies for 4.2.2, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14791](https://github.com/spyder-ide/spyder/pull/14791) - PR: Constrain Watchdog to be less than 2.0.0, by [@ccordoba12](https://github.com/ccordoba12) ([14779](https://github.com/spyder-ide/spyder/issues/14779))
* [PR 14790](https://github.com/spyder-ide/spyder/pull/14790) - PR: Simplify how we enter debugging mode in IPython console tests, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14763](https://github.com/spyder-ide/spyder/pull/14763) - PR: Update translations from Crowdin, by [@spyder-bot](https://github.com/spyder-bot)
* [PR 14762](https://github.com/spyder-ide/spyder/pull/14762) - PR: Update translations for 4.2.2, by [@steff456](https://github.com/steff456)
* [PR 14761](https://github.com/spyder-ide/spyder/pull/14761) - PR: Catch type error when sorting by size in variable explorer, by [@steff456](https://github.com/steff456) ([14527](https://github.com/spyder-ide/spyder/issues/14527))
* [PR 14759](https://github.com/spyder-ide/spyder/pull/14759) - PR: Prevent double saving when running a file, by [@andfoy](https://github.com/andfoy) ([14653](https://github.com/spyder-ide/spyder/issues/14653))
* [PR 14757](https://github.com/spyder-ide/spyder/pull/14757) - PR: Prevent None items in Outline Explorer, by [@andfoy](https://github.com/andfoy) ([14413](https://github.com/spyder-ide/spyder/issues/14413))
* [PR 14727](https://github.com/spyder-ide/spyder/pull/14727) - PR: Add assets for Tkinter (Windows installer), by [@dalthviz](https://github.com/dalthviz) ([14385](https://github.com/spyder-ide/spyder/issues/14385))
* [PR 14719](https://github.com/spyder-ide/spyder/pull/14719) - PR: Improve design of Kite dialog, by [@juanis2112](https://github.com/juanis2112) ([32](https://github.com/spyder-ide/ux-improvements/issues/32))
* [PR 14715](https://github.com/spyder-ide/spyder/pull/14715) - PR: Test for spyder-kernels#278, by [@impact27](https://github.com/impact27) ([14551](https://github.com/spyder-ide/spyder/issues/14551))
* [PR 14711](https://github.com/spyder-ide/spyder/pull/14711) - PR: Sync subrepo with spyder-kernels#271, by [@ccordoba12](https://github.com/ccordoba12) ([14472](https://github.com/spyder-ide/spyder/issues/14472))
* [PR 14696](https://github.com/spyder-ide/spyder/pull/14696) - PR: Improve DPI change detection , by [@dalthviz](https://github.com/dalthviz) ([14273](https://github.com/spyder-ide/spyder/issues/14273))
* [PR 14667](https://github.com/spyder-ide/spyder/pull/14667) - PR: Move IPython out of zipped libraries in macOS application, by [@mrclary](https://github.com/mrclary)
* [PR 14655](https://github.com/spyder-ide/spyder/pull/14655) - PR: Update metainfo file and install it, by [@ximion](https://github.com/ximion)
* [PR 14624](https://github.com/spyder-ide/spyder/pull/14624) - PR: Fix IPython console for internal environment on macOS app, by [@mrclary](https://github.com/mrclary)
* [PR 14607](https://github.com/spyder-ide/spyder/pull/14607) - PR: Don't terminate folding thread before running new update (Editor), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14600](https://github.com/spyder-ide/spyder/pull/14600) - PR: Compute extended ranges for folding out of its thread (Editor), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14574](https://github.com/spyder-ide/spyder/pull/14574) - PR: Move folding update to a thread, by [@andfoy](https://github.com/andfoy) ([14570](https://github.com/spyder-ide/spyder/issues/14570))
* [PR 14565](https://github.com/spyder-ide/spyder/pull/14565) - PR: Remove PYTHONEXECUTABLE from env vars passed to the kernel, by [@ccordoba12](https://github.com/ccordoba12) ([13252](https://github.com/spyder-ide/spyder/issues/13252))
* [PR 14564](https://github.com/spyder-ide/spyder/pull/14564) - PR: Don't open script that starts Spyder at startup on macOS, by [@ccordoba12](https://github.com/ccordoba12) ([14483](https://github.com/spyder-ide/spyder/issues/14483))
* [PR 14559](https://github.com/spyder-ide/spyder/pull/14559) - PR: Workaround for Qt-bug where cursor moves unintuitively after text deletion, by [@hengin](https://github.com/hengin) ([12663](https://github.com/spyder-ide/spyder/issues/12663))
* [PR 14557](https://github.com/spyder-ide/spyder/pull/14557) - PR: Sync subrepo with spyder-kernels#277, by [@ccordoba12](https://github.com/ccordoba12) ([5401](https://github.com/spyder-ide/spyder/issues/5401))
* [PR 14552](https://github.com/spyder-ide/spyder/pull/14552) - PR: Update release instructions, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14545](https://github.com/spyder-ide/spyder/pull/14545) - PR: Fix Variable Explorer pandas KeyError in macOS App, by [@mrclary](https://github.com/mrclary) ([14542](https://github.com/spyder-ide/spyder/issues/14542))
* [PR 14543](https://github.com/spyder-ide/spyder/pull/14543) - Fix DeprecationWarning: explicitly cast to an integer, by [@juliangilbey](https://github.com/juliangilbey) ([14535](https://github.com/spyder-ide/spyder/issues/14535))
* [PR 14514](https://github.com/spyder-ide/spyder/pull/14514) - PR: Fix test compatibility with Pandas 1.2.0, by [@dalthviz](https://github.com/dalthviz)
* [PR 14484](https://github.com/spyder-ide/spyder/pull/14484) - PR: Update subrepo with spyder-kernels#272, by [@ccordoba12](https://github.com/ccordoba12) ([14477](https://github.com/spyder-ide/spyder/issues/14477))
* [PR 14482](https://github.com/spyder-ide/spyder/pull/14482) - PR: Save prompt number while recursive debugging, by [@impact27](https://github.com/impact27)
* [PR 14478](https://github.com/spyder-ide/spyder/pull/14478) - PR: Update continuation prompt, by [@impact27](https://github.com/impact27) ([14476](https://github.com/spyder-ide/spyder/issues/14476))
* [PR 14447](https://github.com/spyder-ide/spyder/pull/14447) - PR: Tunnel comm port to make all features that depend on comms work for remote kernels, by [@impact27](https://github.com/impact27) ([11538](https://github.com/spyder-ide/spyder/issues/11538))
* [PR 14382](https://github.com/spyder-ide/spyder/pull/14382) - PR: Make Pdb work better without comms, by [@impact27](https://github.com/impact27) ([14380](https://github.com/spyder-ide/spyder/issues/14380))
* [PR 14376](https://github.com/spyder-ide/spyder/pull/14376) - PR: Bracket matching fixes (affects highlighting and autocompletion), by [@hengin](https://github.com/hengin) ([9179](https://github.com/spyder-ide/spyder/issues/9179), [2965](https://github.com/spyder-ide/spyder/issues/2965), [14374](https://github.com/spyder-ide/spyder/issues/14374), [1354](https://github.com/spyder-ide/spyder/issues/1354))
* [PR 13864](https://github.com/spyder-ide/spyder/pull/13864) - PR: Synchronize symbols and folding after a timeout (Editor), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13541](https://github.com/spyder-ide/spyder/pull/13541) - PR: Don't add manics conda channel to Binder's environment.yml, by [@yuvipanda](https://github.com/yuvipanda)

In this release 35 pull requests were closed.


----


## Version 4.2.1 (2020-12-18)

### New features

* Code folding for cells.

### Important fixes

* Search works as expected for folded regions.
* IPython Console preferences are applied on the fly.
* IPython files (`*.ipy`) are better support in the Editor.
* Reduce time to show Preferences dialog.
* Support for macOS Big Sur.

### Issues Closed

* [Issue 14440](https://github.com/spyder-ide/spyder/issues/14440) - Missing "magic" key for custom color schemes ([PR 14450](https://github.com/spyder-ide/spyder/pull/14450) by [@dalthviz](https://github.com/dalthviz))
* [Issue 14404](https://github.com/spyder-ide/spyder/issues/14404) - Apply asyncio patch for Tornado < 6.1 ([PR 14414](https://github.com/spyder-ide/spyder/pull/14414) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14377](https://github.com/spyder-ide/spyder/issues/14377) - Kernel running well on Python 3.9 for Spyder 4.2 but the title of app still showing 3.7? ([PR 14396](https://github.com/spyder-ide/spyder/pull/14396) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14348](https://github.com/spyder-ide/spyder/issues/14348) - Not working working directory (-w) of project (-p) from command line ([PR 14227](https://github.com/spyder-ide/spyder/pull/14227) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14330](https://github.com/spyder-ide/spyder/issues/14330) - Spyder freezes for a long period every time preferences is open due to checking conda envs ([PR 14332](https://github.com/spyder-ide/spyder/pull/14332) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14329](https://github.com/spyder-ide/spyder/issues/14329) - Consider changing the tooltip in the Files pane filter toggle to be less confusing and match the others ([PR 14359](https://github.com/spyder-ide/spyder/pull/14359) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14328](https://github.com/spyder-ide/spyder/issues/14328) - Changing the filename filters doesn't update files shown if filters are enabled until the button is toggled off and back on ([PR 14337](https://github.com/spyder-ide/spyder/pull/14337) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14309](https://github.com/spyder-ide/spyder/issues/14309) - New way to update folding regions (PR #13783) freezes Spyder ([PR 14315](https://github.com/spyder-ide/spyder/pull/14315) by [@andfoy](https://github.com/andfoy))
* [Issue 14282](https://github.com/spyder-ide/spyder/issues/14282) - The extra selection is not sometimes displayed. ([PR 14295](https://github.com/spyder-ide/spyder/pull/14295) by [@ok97465](https://github.com/ok97465))
* [Issue 14263](https://github.com/spyder-ide/spyder/issues/14263) - Flags logic is broken for small files ([PR 14266](https://github.com/spyder-ide/spyder/pull/14266) by [@impact27](https://github.com/impact27))
* [Issue 14262](https://github.com/spyder-ide/spyder/issues/14262) - Code Analysis not working in packaged 4.2 MacOS app ([PR 14269](https://github.com/spyder-ide/spyder/pull/14269) by [@mrclary](https://github.com/mrclary))
* [Issue 14243](https://github.com/spyder-ide/spyder/issues/14243) - Add wheel for rtree to Mac installer ([PR 14410](https://github.com/spyder-ide/spyder/pull/14410) by [@mrclary](https://github.com/mrclary))
* [Issue 14222](https://github.com/spyder-ide/spyder/issues/14222) - Cannot launch Spyder after updating to macOS 11 Big Sur, please help. ([PR 14256](https://github.com/spyder-ide/spyder/pull/14256) by [@impact27](https://github.com/impact27))
* [Issue 14221](https://github.com/spyder-ide/spyder/issues/14221) - Move symbol switcher to use LSP symbols ([PR 14244](https://github.com/spyder-ide/spyder/pull/14244) by [@andfoy](https://github.com/andfoy))
* [Issue 14220](https://github.com/spyder-ide/spyder/issues/14220) - Improvements to the Windows installer ([PR 14279](https://github.com/spyder-ide/spyder/pull/14279) by [@dalthviz](https://github.com/dalthviz))
* [Issue 14218](https://github.com/spyder-ide/spyder/issues/14218) - High typing latency in MacOS Big Sur ([PR 14256](https://github.com/spyder-ide/spyder/pull/14256) by [@impact27](https://github.com/impact27))
* [Issue 14203](https://github.com/spyder-ide/spyder/issues/14203) - Spyder 4.2 tour dialog box not respecting light theme from previous spyder ([PR 14420](https://github.com/spyder-ide/spyder/pull/14420) by [@juanis2112](https://github.com/juanis2112))
* [Issue 14192](https://github.com/spyder-ide/spyder/issues/14192) - Pager when getting help blocks IPython console ([PR 14418](https://github.com/spyder-ide/spyder/pull/14418) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14183](https://github.com/spyder-ide/spyder/issues/14183) - TypeError when getting text snippets ([PR 14186](https://github.com/spyder-ide/spyder/pull/14186) by [@andfoy](https://github.com/andfoy))
* [Issue 14175](https://github.com/spyder-ide/spyder/issues/14175) - Allow setting line length, when setting `black` as autoformatter ([PR 14187](https://github.com/spyder-ide/spyder/pull/14187) by [@steff456](https://github.com/steff456))
* [Issue 14155](https://github.com/spyder-ide/spyder/issues/14155) - Dictionary has keys and values mixed up ([PR 14333](https://github.com/spyder-ide/spyder/pull/14333) by [@hengin](https://github.com/hengin))
* [Issue 14152](https://github.com/spyder-ide/spyder/issues/14152) - Items are collapsed in the outline explorer after a change was made in the editor when the option "Follow cursor position" is unchecked. ([PR 14238](https://github.com/spyder-ide/spyder/pull/14238) by [@andfoy](https://github.com/andfoy))
* [Issue 14112](https://github.com/spyder-ide/spyder/issues/14112) - Execute permission bits are set to 1 for newly created files ([PR 14246](https://github.com/spyder-ide/spyder/pull/14246) by [@dalthviz](https://github.com/dalthviz))
* [Issue 14100](https://github.com/spyder-ide/spyder/issues/14100) - PermissionError when trying to change current working directory ([PR 14278](https://github.com/spyder-ide/spyder/pull/14278) by [@steff456](https://github.com/steff456))
* [Issue 13779](https://github.com/spyder-ide/spyder/issues/13779) - Crash while folding code block/function ([PR 13783](https://github.com/spyder-ide/spyder/pull/13783) by [@andfoy](https://github.com/andfoy))
* [Issue 13544](https://github.com/spyder-ide/spyder/issues/13544) - Pandas Series index wrong in Variable Explorer ([PR 14259](https://github.com/spyder-ide/spyder/pull/14259) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13535](https://github.com/spyder-ide/spyder/issues/13535) - Code Analysis output button and path handling on Windows ([PR 14305](https://github.com/spyder-ide/spyder/pull/14305) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13288](https://github.com/spyder-ide/spyder/issues/13288) - TimeoutError: Timeout while waiting for comm port. ([PR 14228](https://github.com/spyder-ide/spyder/pull/14228) by [@impact27](https://github.com/impact27))
* [Issue 13248](https://github.com/spyder-ide/spyder/issues/13248) - RuntimeError when trying to detect if completion widget is visible after closing editor window ([PR 14344](https://github.com/spyder-ide/spyder/pull/14344) by [@steff456](https://github.com/steff456))
* [Issue 12877](https://github.com/spyder-ide/spyder/issues/12877) - ValueError when opening array within array ([PR 14352](https://github.com/spyder-ide/spyder/pull/14352) by [@hengin](https://github.com/hengin))
* [Issue 12485](https://github.com/spyder-ide/spyder/issues/12485) - Collapsed code search bug ([PR 14398](https://github.com/spyder-ide/spyder/pull/14398) by [@andfoy](https://github.com/andfoy))
* [Issue 11360](https://github.com/spyder-ide/spyder/issues/11360) - Code Folding Occasionally Breaks ([PR 13783](https://github.com/spyder-ide/spyder/pull/13783) by [@andfoy](https://github.com/andfoy))
* [Issue 11357](https://github.com/spyder-ide/spyder/issues/11357) - IPython Console: Improvements for preferences application ([PR 12834](https://github.com/spyder-ide/spyder/pull/12834) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11090](https://github.com/spyder-ide/spyder/issues/11090) - Magics are marked as invalid syntax in ipy files ([PR 11101](https://github.com/spyder-ide/spyder/pull/11101) by [@impact27](https://github.com/impact27))
* [Issue 7846](https://github.com/spyder-ide/spyder/issues/7846) - Code folding cells
* [Issue 1983](https://github.com/spyder-ide/spyder/issues/1983) - Windows taskbar icon appears twice, if the Spyder icon is pinned ([PR 14219](https://github.com/spyder-ide/spyder/pull/14219) by [@dalthviz](https://github.com/dalthviz))

In this release 36 issues were closed.

### Pull Requests Merged

* [PR 14456](https://github.com/spyder-ide/spyder/pull/14456) - PR: Update core deps, by [@dalthviz](https://github.com/dalthviz)
* [PR 14453](https://github.com/spyder-ide/spyder/pull/14453) - PR: Set color of pager label (IPython console), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14452](https://github.com/spyder-ide/spyder/pull/14452) - PR: Preserve custom interpreters introduced manually (Main interpreter), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14451](https://github.com/spyder-ide/spyder/pull/14451) - PR: Show Kite's on-boarding dialog the third time Spyder is started, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14450](https://github.com/spyder-ide/spyder/pull/14450) - PR: Add default values for color schemes, by [@dalthviz](https://github.com/dalthviz) ([14440](https://github.com/spyder-ide/spyder/issues/14440))
* [PR 14444](https://github.com/spyder-ide/spyder/pull/14444) - PR: Add .pyt and .pyi as extensions recognized as Python files (Editor), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14443](https://github.com/spyder-ide/spyder/pull/14443) - PR: Remove option to set max number of lines (History), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14430](https://github.com/spyder-ide/spyder/pull/14430) - PR: Fix validation for incorrectly uninstalled packages in is_module_installed, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14420](https://github.com/spyder-ide/spyder/pull/14420) - PR: Change colors for tour dialog in light mode, by [@juanis2112](https://github.com/juanis2112) ([14203](https://github.com/spyder-ide/spyder/issues/14203))
* [PR 14418](https://github.com/spyder-ide/spyder/pull/14418) - PR: Show a warning telling people how to get out of the pager (IPython console), by [@ccordoba12](https://github.com/ccordoba12) ([14192](https://github.com/spyder-ide/spyder/issues/14192))
* [PR 14415](https://github.com/spyder-ide/spyder/pull/14415) - PR: Update minimal required versions of python-language-server and pyls-spyder, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14414](https://github.com/spyder-ide/spyder/pull/14414) - PR: Don't apply asyncio patch for Tornado 6.1+ (IPython console), by [@ccordoba12](https://github.com/ccordoba12) ([14404](https://github.com/spyder-ide/spyder/issues/14404))
* [PR 14410](https://github.com/spyder-ide/spyder/pull/14410) - PR: Add Rtree and other fixes for the macOS app, by [@mrclary](https://github.com/mrclary) ([14243](https://github.com/spyder-ide/spyder/issues/14243))
* [PR 14408](https://github.com/spyder-ide/spyder/pull/14408) - PR: Update translations from Crowdin, by [@spyder-bot](https://github.com/spyder-bot)
* [PR 14407](https://github.com/spyder-ide/spyder/pull/14407) - PR: Update translations, by [@andfoy](https://github.com/andfoy)
* [PR 14398](https://github.com/spyder-ide/spyder/pull/14398) - PR: Improve unfold_if_colapsed logic to consider nested blocks, by [@andfoy](https://github.com/andfoy) ([12485](https://github.com/spyder-ide/spyder/issues/12485))
* [PR 14396](https://github.com/spyder-ide/spyder/pull/14396) - PR: Don't show Python version on window title for our Mac and Windows apps, by [@ccordoba12](https://github.com/ccordoba12) ([14377](https://github.com/spyder-ide/spyder/issues/14377))
* [PR 14390](https://github.com/spyder-ide/spyder/pull/14390) - PR: Pin cryptography to 3.2.1 to avoid issues with lack of wheels for version 3.3 (Windows installer), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14389](https://github.com/spyder-ide/spyder/pull/14389) - PR: Change colors for tour dialog in light mode, by [@juanis2112](https://github.com/juanis2112)
* [PR 14387](https://github.com/spyder-ide/spyder/pull/14387) - PR: Add python_requires to setup.py, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14367](https://github.com/spyder-ide/spyder/pull/14367) - PR: Change application of options that require direct code execution (IPython console), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14366](https://github.com/spyder-ide/spyder/pull/14366) - PR: Sync spyder-kernels subrepo, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14359](https://github.com/spyder-ide/spyder/pull/14359) - PR: Use a single tooltip for the Files filter button, by [@ccordoba12](https://github.com/ccordoba12) ([14329](https://github.com/spyder-ide/spyder/issues/14329))
* [PR 14352](https://github.com/spyder-ide/spyder/pull/14352) - PR: Fix error when opening array of boolean arrays in Variable Explorer, by [@hengin](https://github.com/hengin) ([12877](https://github.com/spyder-ide/spyder/issues/12877))
* [PR 14350](https://github.com/spyder-ide/spyder/pull/14350) - PR: Use Pyzmq 19 on Windows (Testing), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14344](https://github.com/spyder-ide/spyder/pull/14344) - PR: Catch RuntimeError in the editor, by [@steff456](https://github.com/steff456) ([13248](https://github.com/spyder-ide/spyder/issues/13248))
* [PR 14342](https://github.com/spyder-ide/spyder/pull/14342) - PR: Increase IPython version to 7.6.0+, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14337](https://github.com/spyder-ide/spyder/pull/14337) - PR: Update view after applying filters if filters are on (Files), by [@ccordoba12](https://github.com/ccordoba12) ([14328](https://github.com/spyder-ide/spyder/issues/14328))
* [PR 14333](https://github.com/spyder-ide/spyder/pull/14333) - PR: Fix variable explorer sort by size bug, by [@hengin](https://github.com/hengin) ([14155](https://github.com/spyder-ide/spyder/issues/14155))
* [PR 14332](https://github.com/spyder-ide/spyder/pull/14332) - PR: Improve detection of conda and pyenv environments, by [@ccordoba12](https://github.com/ccordoba12) ([14330](https://github.com/spyder-ide/spyder/issues/14330))
* [PR 14318](https://github.com/spyder-ide/spyder/pull/14318) - PR: Fix issues with external kernels runfile and shutdown, by [@impact27](https://github.com/impact27)
* [PR 14315](https://github.com/spyder-ide/spyder/pull/14315) - PR: Replace Jaro-Wrinkler distance by normalized Jaccard index (Folding), by [@andfoy](https://github.com/andfoy) ([14309](https://github.com/spyder-ide/spyder/issues/14309))
* [PR 14308](https://github.com/spyder-ide/spyder/pull/14308) - PR: Prevent comms from crashing Spyder, by [@impact27](https://github.com/impact27)
* [PR 14305](https://github.com/spyder-ide/spyder/pull/14305) - PR: Normalize file paths for correct handling of filenames for static code analysis, by [@dalthviz](https://github.com/dalthviz) ([13535](https://github.com/spyder-ide/spyder/issues/13535))
* [PR 14295](https://github.com/spyder-ide/spyder/pull/14295) - PR: Check for initial selection before updating decorations, by [@ok97465](https://github.com/ok97465) ([14282](https://github.com/spyder-ide/spyder/issues/14282))
* [PR 14284](https://github.com/spyder-ide/spyder/pull/14284) - PR: Increase max Pytest version (Testing), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14279](https://github.com/spyder-ide/spyder/pull/14279) - PR: Add Rtree wheel to the Windows installer, by [@dalthviz](https://github.com/dalthviz) ([14220](https://github.com/spyder-ide/spyder/issues/14220))
* [PR 14278](https://github.com/spyder-ide/spyder/pull/14278) - PR: Catch IOError and OSError in spyder-kernels get_cwd, by [@steff456](https://github.com/steff456) ([14100](https://github.com/spyder-ide/spyder/issues/14100))
* [PR 14269](https://github.com/spyder-ide/spyder/pull/14269) - PR: Fix Code Analysis in macOS Application, by [@mrclary](https://github.com/mrclary) ([14262](https://github.com/spyder-ide/spyder/issues/14262))
* [PR 14266](https://github.com/spyder-ide/spyder/pull/14266) - PR: Align flags if not enough lines to create a scrollbar, by [@impact27](https://github.com/impact27) ([14263](https://github.com/spyder-ide/spyder/issues/14263))
* [PR 14259](https://github.com/spyder-ide/spyder/pull/14259) - PR: Recalculate index when sorting (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([13544](https://github.com/spyder-ide/spyder/issues/13544))
* [PR 14256](https://github.com/spyder-ide/spyder/pull/14256) - PR: Set QT_MAC_WANTS_LAYER env var to solve problems in Big Sur, by [@impact27](https://github.com/impact27) ([14222](https://github.com/spyder-ide/spyder/issues/14222), [14218](https://github.com/spyder-ide/spyder/issues/14218))
* [PR 14246](https://github.com/spyder-ide/spyder/pull/14246) - PR: Set base permission to 0o666 minus umask for files when saving, by [@dalthviz](https://github.com/dalthviz) ([14112](https://github.com/spyder-ide/spyder/issues/14112))
* [PR 14244](https://github.com/spyder-ide/spyder/pull/14244) - PR: Migrate the symbol switcher to use the LSP information, by [@andfoy](https://github.com/andfoy) ([14221](https://github.com/spyder-ide/spyder/issues/14221))
* [PR 14239](https://github.com/spyder-ide/spyder/pull/14239) - PR: Disable set-env usage on GitHub Actions and update conda action, by [@andfoy](https://github.com/andfoy)
* [PR 14238](https://github.com/spyder-ide/spyder/pull/14238) - PR: Fix issues with expanded symbols when cursor is not being followed up, by [@andfoy](https://github.com/andfoy) ([14152](https://github.com/spyder-ide/spyder/issues/14152))
* [PR 14231](https://github.com/spyder-ide/spyder/pull/14231) - PR: Improve startup time a bit, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14229](https://github.com/spyder-ide/spyder/pull/14229) - PR: Simplify creation of main application and splash screen, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14228](https://github.com/spyder-ide/spyder/pull/14228) - PR: Don't wait for disconnected comm (IPython console), by [@impact27](https://github.com/impact27) ([13288](https://github.com/spyder-ide/spyder/issues/13288))
* [PR 14227](https://github.com/spyder-ide/spyder/pull/14227) - PR: Fix opening projects from the command line, by [@ccordoba12](https://github.com/ccordoba12) ([14348](https://github.com/spyder-ide/spyder/issues/14348))
* [PR 14219](https://github.com/spyder-ide/spyder/pull/14219) - PR: Context menu entry to open files with Spyder and taskbar pinned icon (Windows installer), by [@dalthviz](https://github.com/dalthviz) ([1983](https://github.com/spyder-ide/spyder/issues/1983))
* [PR 14195](https://github.com/spyder-ide/spyder/pull/14195) - PR: Pin NumPy version to prevent RuntimeError - sanity check on Windows installer (Windows 10), by [@dalthviz](https://github.com/dalthviz)
* [PR 14187](https://github.com/spyder-ide/spyder/pull/14187) - PR: Fix bug in preferences with max line length, by [@steff456](https://github.com/steff456) ([14175](https://github.com/spyder-ide/spyder/issues/14175))
* [PR 14186](https://github.com/spyder-ide/spyder/pull/14186) - PR: Prevent indexing prefix tree with None values, by [@andfoy](https://github.com/andfoy) ([14183](https://github.com/spyder-ide/spyder/issues/14183))
* [PR 14185](https://github.com/spyder-ide/spyder/pull/14185) - PR: Don't use len to check for empty sequences (Snippets), by [@ElieGouzien](https://github.com/ElieGouzien)
* [PR 14181](https://github.com/spyder-ide/spyder/pull/14181) - PR: Improve release instructions, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14180](https://github.com/spyder-ide/spyder/pull/14180) - PR: Update our subrepos after releasing 4.2.0, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14178](https://github.com/spyder-ide/spyder/pull/14178) - PR: Fix conda environment list on Windows application, by [@mrclary](https://github.com/mrclary)
* [PR 14071](https://github.com/spyder-ide/spyder/pull/14071) - PR: Replace deprecated imp with importlib, by [@oscargus](https://github.com/oscargus)
* [PR 13783](https://github.com/spyder-ide/spyder/pull/13783) - PR: Improve folding updates and line displacement on the editor, by [@andfoy](https://github.com/andfoy) ([13779](https://github.com/spyder-ide/spyder/issues/13779), [11360](https://github.com/spyder-ide/spyder/issues/11360))
* [PR 12834](https://github.com/spyder-ide/spyder/pull/12834) - PR: Improve handling of IPython Console preferences, by [@dalthviz](https://github.com/dalthviz) ([11357](https://github.com/spyder-ide/spyder/issues/11357))
* [PR 11101](https://github.com/spyder-ide/spyder/pull/11101) - PR: Support IPython files, by [@impact27](https://github.com/impact27) ([11090](https://github.com/spyder-ide/spyder/issues/11090))

In this release 62 pull requests were closed.


----


## Version 4.2.0 (2020-11-08)

### New features

* New, self-contained installers for Windows and macOS.
* Add support for inline and interactive Matplotlib plots in the debugger.
* Automatic detection of conda and pyenv environments in
  `Preferences > Python interpreter`.
* Add functionality to do auto-formatting in the Editor. It can be triggered in
  the menu `Source > Format file or selection` or with the shorcut
  `Ctrl+Alt+I` (`Cmd+Alt+I` in macOS).
* Add support for text snippets in the Editor. The list of available snippets
  is shown in `Preferences > Completion and linting > Snippets`.
* Support caching cells send in succession to the IPython console. This will
  run one cell after the previous one finished.
* Make variables take precedence over Pdb commands in the debugger. In case a
  variable clashes with a command, you'll have to prefix the command with `!`.
* Show a message to take a tour of Spyder features the first time 4.2.0 is
  launched.
* Drop support for Python 2.7 and 3.5.

### Important fixes

* Improve performance in the Editor when painting indent guides and showing
  linting messages.
* Prevent the creation of temporary files in Dropbox directories after saving
  in the Editor.
* Prevent the Outline to degrade performance in the Editor when visible. This
  was achieved by moving this pane to use the LSP architecture.
* Support Jedi 0.17.2

### Issues Closed

* [Issue 14163](https://github.com/spyder-ide/spyder/issues/14163) - NameError: name 'DistributionNotFound' is not defined ([PR 14164](https://github.com/spyder-ide/spyder/pull/14164) by [@impact27](https://github.com/impact27))
* [Issue 14140](https://github.com/spyder-ide/spyder/issues/14140) - LSP Server Does Not Startup on macOS Application ([PR 14142](https://github.com/spyder-ide/spyder/pull/14142) by [@mrclary](https://github.com/mrclary))
* [Issue 14136](https://github.com/spyder-ide/spyder/issues/14136) - Conda Environment Status Shows Full Path ([PR 14123](https://github.com/spyder-ide/spyder/pull/14123) by [@mrclary](https://github.com/mrclary))
* [Issue 14125](https://github.com/spyder-ide/spyder/issues/14125) - TypeError when inserting text in code snippet ([PR 14157](https://github.com/spyder-ide/spyder/pull/14157) by [@andfoy](https://github.com/andfoy))
* [Issue 14117](https://github.com/spyder-ide/spyder/issues/14117) - Update translations for 4.2.0 ([PR 14159](https://github.com/spyder-ide/spyder/pull/14159) by [@spyder-bot](https://github.com/spyder-bot))
* [Issue 14113](https://github.com/spyder-ide/spyder/issues/14113) - Error when inserting text in code snippet ([PR 14114](https://github.com/spyder-ide/spyder/pull/14114) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14107](https://github.com/spyder-ide/spyder/issues/14107) - RuntimeError when closing project ([PR 14109](https://github.com/spyder-ide/spyder/pull/14109) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14082](https://github.com/spyder-ide/spyder/issues/14082) - Set column width automatically after changing autoformatter ([PR 14147](https://github.com/spyder-ide/spyder/pull/14147) by [@steff456](https://github.com/steff456))
* [Issue 14040](https://github.com/spyder-ide/spyder/issues/14040) - Pager is broken in IPython console ([PR 14056](https://github.com/spyder-ide/spyder/pull/14056) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 14001](https://github.com/spyder-ide/spyder/issues/14001) - Cannot save if remove_trailing_spaces is enabled ([PR 14016](https://github.com/spyder-ide/spyder/pull/14016) by [@andfoy](https://github.com/andfoy))
* [Issue 13999](https://github.com/spyder-ide/spyder/issues/13999) - Error while restarting the kernel ([PR 14057](https://github.com/spyder-ide/spyder/pull/14057) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13985](https://github.com/spyder-ide/spyder/issues/13985) - Bug: Code style linting is ignored after Spyder restart ([PR 14043](https://github.com/spyder-ide/spyder/pull/14043) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13978](https://github.com/spyder-ide/spyder/issues/13978) - Migrate mac-application repo to spyder repo ([PR 13992](https://github.com/spyder-ide/spyder/pull/13992) by [@mrclary](https://github.com/mrclary))
* [Issue 13977](https://github.com/spyder-ide/spyder/issues/13977) - TypeError: 'bool' object is not callable at Spyder startup ([PR 14007](https://github.com/spyder-ide/spyder/pull/14007) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13964](https://github.com/spyder-ide/spyder/issues/13964) - PYTHONPATH not set when running profiler ([PR 14022](https://github.com/spyder-ide/spyder/pull/14022) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13957](https://github.com/spyder-ide/spyder/issues/13957) - Replace with | replace/find next | replace in selection | replace all ([PR 14054](https://github.com/spyder-ide/spyder/pull/14054) by [@TediaN97](https://github.com/TediaN97))
* [Issue 13928](https://github.com/spyder-ide/spyder/issues/13928) - The ouline explorer doesn't populate for some files with latest 4.x ([PR 14119](https://github.com/spyder-ide/spyder/pull/14119) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13918](https://github.com/spyder-ide/spyder/issues/13918) - Debugger panel is not updated correctly in latest 4.x ([PR 13919](https://github.com/spyder-ide/spyder/pull/13919) by [@impact27](https://github.com/impact27))
* [Issue 13909](https://github.com/spyder-ide/spyder/issues/13909) - Variables not defined error while in debug mode when running a list comprehension ([PR 13920](https://github.com/spyder-ide/spyder/pull/13920) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13908](https://github.com/spyder-ide/spyder/issues/13908) - Turning "Highlight current line" off breaks parenthesis matching highlighting ([PR 13281](https://github.com/spyder-ide/spyder/pull/13281) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13903](https://github.com/spyder-ide/spyder/issues/13903) - Add option to list available environments as main interpreter in Preferences ([PR 13950](https://github.com/spyder-ide/spyder/pull/13950) by [@steff456](https://github.com/steff456))
* [Issue 13897](https://github.com/spyder-ide/spyder/issues/13897) - Outline explorer only populate its content after a file is changed on latest 4.x ([PR 13981](https://github.com/spyder-ide/spyder/pull/13981) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13896](https://github.com/spyder-ide/spyder/issues/13896) - Outline exporer items auto expands to follow cursor position in latest 4.x ([PR 13885](https://github.com/spyder-ide/spyder/pull/13885) by [@andfoy](https://github.com/andfoy))
* [Issue 13892](https://github.com/spyder-ide/spyder/issues/13892) - Debugging __init__ impossible ([PR 13902](https://github.com/spyder-ide/spyder/pull/13902) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13891](https://github.com/spyder-ide/spyder/issues/13891) - Creating a pint Quantity in the console fails ([PR 13902](https://github.com/spyder-ide/spyder/pull/13902) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13882](https://github.com/spyder-ide/spyder/issues/13882) - Saving layout doesn't store the right sizes. ([PR 14078](https://github.com/spyder-ide/spyder/pull/14078) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13877](https://github.com/spyder-ide/spyder/issues/13877) - Variable names are displayed in the Outline pane ([PR 13885](https://github.com/spyder-ide/spyder/pull/13885) by [@andfoy](https://github.com/andfoy))
* [Issue 13872](https://github.com/spyder-ide/spyder/issues/13872) - Spinner is shown constantly in Outline explorer for files without a language server ([PR 13885](https://github.com/spyder-ide/spyder/pull/13885) by [@andfoy](https://github.com/andfoy))
* [Issue 13832](https://github.com/spyder-ide/spyder/issues/13832) - Replace kite dialog when opening spyder the first time for the tour dialog. ([PR 13953](https://github.com/spyder-ide/spyder/pull/13953) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13807](https://github.com/spyder-ide/spyder/issues/13807) - "Go to definition" causes error in Python 3.6 ([PR 13839](https://github.com/spyder-ide/spyder/pull/13839) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13806](https://github.com/spyder-ide/spyder/issues/13806) - object.[tab] causes internal error in IPython console ([PR 13830](https://github.com/spyder-ide/spyder/pull/13830) by [@steff456](https://github.com/steff456))
* [Issue 13786](https://github.com/spyder-ide/spyder/issues/13786) - A generic icon is shown in gnome-shell in a Wayland session ([PR 13787](https://github.com/spyder-ide/spyder/pull/13787) by [@musicinmybrain](https://github.com/musicinmybrain))
* [Issue 13762](https://github.com/spyder-ide/spyder/issues/13762) - Highlighting word when there is only one occurence ([PR 13834](https://github.com/spyder-ide/spyder/pull/13834) by [@steff456](https://github.com/steff456))
* [Issue 13754](https://github.com/spyder-ide/spyder/issues/13754) - Change colors for IPython console error message ([PR 13963](https://github.com/spyder-ide/spyder/pull/13963) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13741](https://github.com/spyder-ide/spyder/issues/13741) - Fix PYTHONPATH manager tooltip to match the title of the dialog window it triggers ([PR 13817](https://github.com/spyder-ide/spyder/pull/13817) by [@juanitagomezr](https://github.com/juanitagomezr))
* [Issue 13733](https://github.com/spyder-ide/spyder/issues/13733) - Variable type and size are out of order ([PR 13791](https://github.com/spyder-ide/spyder/pull/13791) by [@skjerns](https://github.com/skjerns))
* [Issue 13722](https://github.com/spyder-ide/spyder/issues/13722) - Spyder doesn't create a new folder in project explorer ([PR 13740](https://github.com/spyder-ide/spyder/pull/13740) by [@akwasigroch](https://github.com/akwasigroch))
* [Issue 13719](https://github.com/spyder-ide/spyder/issues/13719) - IPython.core.inputtransformer2 is only present in IPython >= 7.0 ([PR 13721](https://github.com/spyder-ide/spyder/pull/13721) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13668](https://github.com/spyder-ide/spyder/issues/13668) - Internal console inserts unwanted red highlighting on background ([PR 13281](https://github.com/spyder-ide/spyder/pull/13281) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13666](https://github.com/spyder-ide/spyder/issues/13666) - Internal console inserts unwanted background highlighting on left parenthesis ([PR 13281](https://github.com/spyder-ide/spyder/pull/13281) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13632](https://github.com/spyder-ide/spyder/issues/13632) - Cannot use imported modules with joblib ([PR 13818](https://github.com/spyder-ide/spyder/pull/13818) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13623](https://github.com/spyder-ide/spyder/issues/13623) - Unnecessary error when restarting the kernel ([PR 13634](https://github.com/spyder-ide/spyder/pull/13634) by [@impact27](https://github.com/impact27))
* [Issue 13620](https://github.com/spyder-ide/spyder/issues/13620) - RecursionError when opening a dataframe with Pandas 1.1.0 in the kernel and 1.0.5 in Spyder ([PR 13843](https://github.com/spyder-ide/spyder/pull/13843) by [@steff456](https://github.com/steff456))
* [Issue 13585](https://github.com/spyder-ide/spyder/issues/13585) - Plain text in help pane has a bug ([PR 13598](https://github.com/spyder-ide/spyder/pull/13598) by [@steff456](https://github.com/steff456))
* [Issue 13557](https://github.com/spyder-ide/spyder/issues/13557) - Date object not editable in variable explorer ([PR 13876](https://github.com/spyder-ide/spyder/pull/13876) by [@steff456](https://github.com/steff456))
* [Issue 13531](https://github.com/spyder-ide/spyder/issues/13531) - Run configuration per file dialog doesn't display complete ([PR 13590](https://github.com/spyder-ide/spyder/pull/13590) by [@steff456](https://github.com/steff456))
* [Issue 13519](https://github.com/spyder-ide/spyder/issues/13519) - Builtins can still be shadowed, causing kernel startup to fail, when a project is open ([PR 14017](https://github.com/spyder-ide/spyder/pull/14017) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13507](https://github.com/spyder-ide/spyder/issues/13507) - No xdg-open on VM instance ([PR 13971](https://github.com/spyder-ide/spyder/pull/13971) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13465](https://github.com/spyder-ide/spyder/issues/13465) - Fix some further issues with the Files pane UX ([PR 13833](https://github.com/spyder-ide/spyder/pull/13833) by [@steff456](https://github.com/steff456))
* [Issue 13439](https://github.com/spyder-ide/spyder/issues/13439) - Code analysis and profiler don't have shortcuts assigned ([PR 13970](https://github.com/spyder-ide/spyder/pull/13970) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13371](https://github.com/spyder-ide/spyder/issues/13371) - Add "Insert above/below" options for lists in variable explorer ([PR 13380](https://github.com/spyder-ide/spyder/pull/13380) by [@dpturibio](https://github.com/dpturibio))
* [Issue 13351](https://github.com/spyder-ide/spyder/issues/13351) - Some issues with Spyder projects and the workspace functionality in the PyLS ([PR 13828](https://github.com/spyder-ide/spyder/pull/13828) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13347](https://github.com/spyder-ide/spyder/issues/13347) - Clicking an item in Analyze pane does nothing but return to post-scan initial state ([PR 14090](https://github.com/spyder-ide/spyder/pull/14090) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13342](https://github.com/spyder-ide/spyder/issues/13342) - IndexError in Code Analysis prevents Spyder from getting launched ([PR 13753](https://github.com/spyder-ide/spyder/pull/13753) by [@steff456](https://github.com/steff456))
* [Issue 13283](https://github.com/spyder-ide/spyder/issues/13283) - Can't terminate debugging session ([PR 13379](https://github.com/spyder-ide/spyder/pull/13379) by [@impact27](https://github.com/impact27))
* [Issue 13241](https://github.com/spyder-ide/spyder/issues/13241) - Improvements to the help pane ([PR 13750](https://github.com/spyder-ide/spyder/pull/13750) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13240](https://github.com/spyder-ide/spyder/issues/13240) - Fix Introduction tour ([PR 13717](https://github.com/spyder-ide/spyder/pull/13717) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13239](https://github.com/spyder-ide/spyder/issues/13239) - Add Tutorial Videos item to Spyder Help menu ([PR 13895](https://github.com/spyder-ide/spyder/pull/13895) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13145](https://github.com/spyder-ide/spyder/issues/13145) - Create our own installer for Windows ([PR 13269](https://github.com/spyder-ide/spyder/pull/13269) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13121](https://github.com/spyder-ide/spyder/issues/13121) - TypeError: KiteClient.sig_response_ready in Kite's client ([PR 13884](https://github.com/spyder-ide/spyder/pull/13884) by [@andfoy](https://github.com/andfoy))
* [Issue 13041](https://github.com/spyder-ide/spyder/issues/13041) - Atomic writes generate temp files in Dropbox ([PR 13915](https://github.com/spyder-ide/spyder/pull/13915) by [@skjerns](https://github.com/skjerns))
* [Issue 13020](https://github.com/spyder-ide/spyder/issues/13020) - Editor sluggish on document diagnostics update ([PR 13281](https://github.com/spyder-ide/spyder/pull/13281) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12677](https://github.com/spyder-ide/spyder/issues/12677) - Add instructions about using "conda update anaconda" to the update dialog ([PR 14091](https://github.com/spyder-ide/spyder/pull/14091) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12651](https://github.com/spyder-ide/spyder/issues/12651) - Indentation handling when running code cells (IndentationError: unexpected indent) ([PR 13852](https://github.com/spyder-ide/spyder/pull/13852) by [@impact27](https://github.com/impact27))
* [Issue 12631](https://github.com/spyder-ide/spyder/issues/12631) - Feature Request: --safe-mode in spyder main cli options ([PR 12926](https://github.com/spyder-ide/spyder/pull/12926) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12564](https://github.com/spyder-ide/spyder/issues/12564) - Intended behaviour of add_pathlist_to_PYTHONPATH not clear ([PR 14022](https://github.com/spyder-ide/spyder/pull/14022) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12259](https://github.com/spyder-ide/spyder/issues/12259) - MacApp: Jedi Completion Not Entirely Working from Non-conda environment ([PR 13839](https://github.com/spyder-ide/spyder/pull/13839) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12200](https://github.com/spyder-ide/spyder/issues/12200) - Feature Request: Upgrade Spyder's Environment Handling ([PR 13950](https://github.com/spyder-ide/spyder/pull/13950) by [@steff456](https://github.com/steff456))
* [Issue 12045](https://github.com/spyder-ide/spyder/issues/12045) - Spyder prompts to install command line tools in macOS  ([PR 14105](https://github.com/spyder-ide/spyder/pull/14105) by [@juanis2112](https://github.com/juanis2112))
* [Issue 11396](https://github.com/spyder-ide/spyder/issues/11396) - Integration of automatic formatting tools: autopep8, yapf and black ([PR 13295](https://github.com/spyder-ide/spyder/pull/13295) by [@andfoy](https://github.com/andfoy))
* [Issue 11118](https://github.com/spyder-ide/spyder/issues/11118) - Problem in autocompletion of class attributes in Spyder 4 editor  ([PR 14058](https://github.com/spyder-ide/spyder/pull/14058) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 9725](https://github.com/spyder-ide/spyder/issues/9725) - Shift-Enter to run a cell is not cached ([PR 10873](https://github.com/spyder-ide/spyder/pull/10873) by [@impact27](https://github.com/impact27))
* [Issue 8864](https://github.com/spyder-ide/spyder/issues/8864) - Indent guides makes the Editor extremely slow on large files ([PR 13867](https://github.com/spyder-ide/spyder/pull/13867) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 3161](https://github.com/spyder-ide/spyder/issues/3161) - Check : Profiler unable to find modules ([PR 14022](https://github.com/spyder-ide/spyder/pull/14022) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 620](https://github.com/spyder-ide/spyder/issues/620) - Unable to see plots made with Matplotlib while debugging ([PR 13327](https://github.com/spyder-ide/spyder/pull/13327) by [@impact27](https://github.com/impact27))
* [Issue 588](https://github.com/spyder-ide/spyder/issues/588) - Add support for text snippets ([PR 14019](https://github.com/spyder-ide/spyder/pull/14019) by [@andfoy](https://github.com/andfoy))

In this release 76 issues were closed.

### Pull Requests Merged

* [PR 14170](https://github.com/spyder-ide/spyder/pull/14170) - PR: Update PyLS and spyder-kernels required versions for 4.2, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14168](https://github.com/spyder-ide/spyder/pull/14168) - PR: Fix logging to a file, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14167](https://github.com/spyder-ide/spyder/pull/14167) - PR: Update subrepo with spyder-kernels#255, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14164](https://github.com/spyder-ide/spyder/pull/14164) - PR: Fix get_package_version, by [@impact27](https://github.com/impact27) ([14163](https://github.com/spyder-ide/spyder/issues/14163))
* [PR 14160](https://github.com/spyder-ide/spyder/pull/14160) - PR: Fix detection of conda and pyenv environments on Windows, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14159](https://github.com/spyder-ide/spyder/pull/14159) - PR: Update translations from Crowdin, by [@spyder-bot](https://github.com/spyder-bot) ([14117](https://github.com/spyder-ide/spyder/issues/14117))
* [PR 14157](https://github.com/spyder-ide/spyder/pull/14157) - PR: Prevent code snippet search from picking the root text node, by [@andfoy](https://github.com/andfoy) ([14125](https://github.com/spyder-ide/spyder/issues/14125))
* [PR 14154](https://github.com/spyder-ide/spyder/pull/14154) - PR: Fix some strings for translation, by [@juanis2112](https://github.com/juanis2112)
* [PR 14147](https://github.com/spyder-ide/spyder/pull/14147) - PR: Set column width automatically after changing autoformatter, by [@steff456](https://github.com/steff456) ([14082](https://github.com/spyder-ide/spyder/issues/14082))
* [PR 14146](https://github.com/spyder-ide/spyder/pull/14146) - PR: Change default auto-formatter to be Black (Editor), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14142](https://github.com/spyder-ide/spyder/pull/14142) - PR: Resolve LSP not starting in Mac app, by [@mrclary](https://github.com/mrclary) ([14140](https://github.com/spyder-ide/spyder/issues/14140))
* [PR 14137](https://github.com/spyder-ide/spyder/pull/14137) - PR: Fix project opening when starting Spyder in Mac app, by [@juanis2112](https://github.com/juanis2112)
* [PR 14135](https://github.com/spyder-ide/spyder/pull/14135) - PR: Update macOS app with new dependencies, by [@mrclary](https://github.com/mrclary)
* [PR 14123](https://github.com/spyder-ide/spyder/pull/14123) - PR: Add search paths to PATH in is_program_installed, by [@mrclary](https://github.com/mrclary) ([14136](https://github.com/spyder-ide/spyder/issues/14136))
* [PR 14119](https://github.com/spyder-ide/spyder/pull/14119) - PR: Check that we can get symbols in a file not part of a Python module, by [@ccordoba12](https://github.com/ccordoba12) ([13928](https://github.com/spyder-ide/spyder/issues/13928))
* [PR 14115](https://github.com/spyder-ide/spyder/pull/14115) - PR: Update translation files, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14114](https://github.com/spyder-ide/spyder/pull/14114) - PR: Add name and value to base node class (Snippets), by [@ccordoba12](https://github.com/ccordoba12) ([14113](https://github.com/spyder-ide/spyder/issues/14113))
* [PR 14109](https://github.com/spyder-ide/spyder/pull/14109) - PR: Catch an error when stopping watcher (Projects), by [@ccordoba12](https://github.com/ccordoba12) ([14107](https://github.com/spyder-ide/spyder/issues/14107))
* [PR 14105](https://github.com/spyder-ide/spyder/pull/14105) - PR: Add find_git function to verify correctly if git is installed on macOS, by [@juanis2112](https://github.com/juanis2112) ([12045](https://github.com/spyder-ide/spyder/issues/12045))
* [PR 14104](https://github.com/spyder-ide/spyder/pull/14104) - PR: Customize tour dialog when starting Spyder, by [@juanis2112](https://github.com/juanis2112) ([22](https://github.com/spyder-ide/ux-improvements/issues/22))
* [PR 14091](https://github.com/spyder-ide/spyder/pull/14091) - PR: Improve message about new releases (Main Window), by [@ccordoba12](https://github.com/ccordoba12) ([12677](https://github.com/spyder-ide/spyder/issues/12677))
* [PR 14090](https://github.com/spyder-ide/spyder/pull/14090) - PR: Don't try to reload analysis for the currently displayed file (Code Analysis), by [@ccordoba12](https://github.com/ccordoba12) ([13347](https://github.com/spyder-ide/spyder/issues/13347))
* [PR 14078](https://github.com/spyder-ide/spyder/pull/14078) - PR: Use current size and position when saving window settings (Main Window), by [@ccordoba12](https://github.com/ccordoba12) ([13882](https://github.com/spyder-ide/spyder/issues/13882))
* [PR 14074](https://github.com/spyder-ide/spyder/pull/14074) - PR: Remove PyYAML deprecation warning, by [@oscargus](https://github.com/oscargus)
* [PR 14059](https://github.com/spyder-ide/spyder/pull/14059) - PR: Add build for Windows installer with extra packages, by [@dalthviz](https://github.com/dalthviz)
* [PR 14058](https://github.com/spyder-ide/spyder/pull/14058) - PR: Update subrepo with python-language-server#879, by [@ccordoba12](https://github.com/ccordoba12) ([11118](https://github.com/spyder-ide/spyder/issues/11118))
* [PR 14057](https://github.com/spyder-ide/spyder/pull/14057) - PR: Catch an error when trying to restart the kernel (IPython console), by [@ccordoba12](https://github.com/ccordoba12) ([13999](https://github.com/spyder-ide/spyder/issues/13999))
* [PR 14056](https://github.com/spyder-ide/spyder/pull/14056) - PR: Remove option to use pager because it's broken (IPython console), by [@ccordoba12](https://github.com/ccordoba12) ([14040](https://github.com/spyder-ide/spyder/issues/14040))
* [PR 14054](https://github.com/spyder-ide/spyder/pull/14054) - PR: Change replace labels in find/replace widget, by [@TediaN97](https://github.com/TediaN97) ([13957](https://github.com/spyder-ide/spyder/issues/13957))
* [PR 14051](https://github.com/spyder-ide/spyder/pull/14051) - PR: Improvements to the About Spyder dialog, by [@jnsebgosselin](https://github.com/jnsebgosselin)
* [PR 14043](https://github.com/spyder-ide/spyder/pull/14043) - PR: Update subrepo with python-language-server#873, by [@ccordoba12](https://github.com/ccordoba12) ([13985](https://github.com/spyder-ide/spyder/issues/13985))
* [PR 14037](https://github.com/spyder-ide/spyder/pull/14037) - PR: Some improvements to the create project dialog., by [@jnsebgosselin](https://github.com/jnsebgosselin)
* [PR 14033](https://github.com/spyder-ide/spyder/pull/14033) - PR: Fix issue where external IPython consoles do not launch for macOS application, by [@mrclary](https://github.com/mrclary)
* [PR 14027](https://github.com/spyder-ide/spyder/pull/14027) - PR: Some improvements to the "Run > Configuration per file" dialog (2), by [@jnsebgosselin](https://github.com/jnsebgosselin)
* [PR 14022](https://github.com/spyder-ide/spyder/pull/14022) - PR: Simplify add_pathlist_to_PYTHONPATH, by [@ccordoba12](https://github.com/ccordoba12) ([3161](https://github.com/spyder-ide/spyder/issues/3161), [13964](https://github.com/spyder-ide/spyder/issues/13964), [12564](https://github.com/spyder-ide/spyder/issues/12564))
* [PR 14019](https://github.com/spyder-ide/spyder/pull/14019) - PR: Enable text snippets support in the editor, by [@andfoy](https://github.com/andfoy) ([588](https://github.com/spyder-ide/spyder/issues/588))
* [PR 14017](https://github.com/spyder-ide/spyder/pull/14017) - PR: Don't pass PYTHONPATH directly to the kernel (IPython console), by [@ccordoba12](https://github.com/ccordoba12) ([13519](https://github.com/spyder-ide/spyder/issues/13519))
* [PR 14016](https://github.com/spyder-ide/spyder/pull/14016) - PR: Fix remove_trailing_spaces method and attribute clash, by [@andfoy](https://github.com/andfoy) ([14001](https://github.com/spyder-ide/spyder/issues/14001))
* [PR 14014](https://github.com/spyder-ide/spyder/pull/14014) - PR: Add get_package_version for more complete version list, by [@oscargus](https://github.com/oscargus)
* [PR 14008](https://github.com/spyder-ide/spyder/pull/14008) - PR: Improve how the options in Preferences/Appearance are applied, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 14007](https://github.com/spyder-ide/spyder/pull/14007) - PR: Catch TypeError when loading third-party plugins (Main Window), by [@ccordoba12](https://github.com/ccordoba12) ([13977](https://github.com/spyder-ide/spyder/issues/13977))
* [PR 13992](https://github.com/spyder-ide/spyder/pull/13992) - PR: Add scripts and files necessary to create a macOS installer, by [@mrclary](https://github.com/mrclary) ([13978](https://github.com/spyder-ide/spyder/issues/13978))
* [PR 13981](https://github.com/spyder-ide/spyder/pull/13981) - PR: Update Outline when opening or closing projects, by [@ccordoba12](https://github.com/ccordoba12) ([13897](https://github.com/spyder-ide/spyder/issues/13897))
* [PR 13979](https://github.com/spyder-ide/spyder/pull/13979) - PR: Some improvements to the "Run > Configuration per file" dialog, by [@jnsebgosselin](https://github.com/jnsebgosselin)
* [PR 13974](https://github.com/spyder-ide/spyder/pull/13974) - PR: Remove support for Python 2 and 3.5 in setup.py, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13972](https://github.com/spyder-ide/spyder/pull/13972) - PR: Use a better method to check the spinner is not shown in a couple of Outline tests, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13971](https://github.com/spyder-ide/spyder/pull/13971) - PR: Add warning for xdg-utils when trying to open a file in the editor in the external file explorer, by [@juanis2112](https://github.com/juanis2112) ([13507](https://github.com/spyder-ide/spyder/issues/13507))
* [PR 13970](https://github.com/spyder-ide/spyder/pull/13970) - PR: Add shortcuts to Profiler and Code Analysis panes, by [@juanis2112](https://github.com/juanis2112) ([13439](https://github.com/spyder-ide/spyder/issues/13439))
* [PR 13963](https://github.com/spyder-ide/spyder/pull/13963) - PR: Change colors for kernel errors in IPython console, by [@juanis2112](https://github.com/juanis2112) ([13754](https://github.com/spyder-ide/spyder/issues/13754))
* [PR 13958](https://github.com/spyder-ide/spyder/pull/13958) - PR: Update, revise and copyedit existing tour steps, by [@CAM-Gerlach](https://github.com/CAM-Gerlach)
* [PR 13953](https://github.com/spyder-ide/spyder/pull/13953) - PR: Change Kite dialog to tour dialog when starting Spyder for first time, by [@juanis2112](https://github.com/juanis2112) ([13832](https://github.com/spyder-ide/spyder/issues/13832))
* [PR 13950](https://github.com/spyder-ide/spyder/pull/13950) - PR: Show conda and pyenv environments in Python interpreter (Preferences), by [@steff456](https://github.com/steff456) ([13903](https://github.com/spyder-ide/spyder/issues/13903), [12200](https://github.com/spyder-ide/spyder/issues/12200))
* [PR 13938](https://github.com/spyder-ide/spyder/pull/13938) - PR: Update outline for files in previous session after Spyder started, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13920](https://github.com/spyder-ide/spyder/pull/13920) - PR: Update subrepo with spyder-kernels#252, by [@ccordoba12](https://github.com/ccordoba12) ([13909](https://github.com/spyder-ide/spyder/issues/13909))
* [PR 13919](https://github.com/spyder-ide/spyder/pull/13919) - PR: Fix debugger panel not being updated, by [@impact27](https://github.com/impact27) ([13918](https://github.com/spyder-ide/spyder/issues/13918))
* [PR 13915](https://github.com/spyder-ide/spyder/pull/13915) - PR: Avoid atomic writes leaving trail of temporary files in Dropbox directories, by [@skjerns](https://github.com/skjerns) ([13041](https://github.com/spyder-ide/spyder/issues/13041))
* [PR 13902](https://github.com/spyder-ide/spyder/pull/13902) - PR: Update subrepo with spyder-kernels#251, by [@ccordoba12](https://github.com/ccordoba12) ([13892](https://github.com/spyder-ide/spyder/issues/13892), [13891](https://github.com/spyder-ide/spyder/issues/13891))
* [PR 13895](https://github.com/spyder-ide/spyder/pull/13895) - PR: Add tutorial videos to help menu, update link to troubleshooting in docs, by [@juanis2112](https://github.com/juanis2112) ([13239](https://github.com/spyder-ide/spyder/issues/13239))
* [PR 13894](https://github.com/spyder-ide/spyder/pull/13894) - PR: Disable toolbar fullscreen button for macOS, by [@juanis2112](https://github.com/juanis2112) ([5](https://github.com/spyder-ide/ux-improvements/issues/5))
* [PR 13885](https://github.com/spyder-ide/spyder/pull/13885) - PR: Restore code cells and block comments in the Outline pane and fix other issues, by [@andfoy](https://github.com/andfoy) ([13896](https://github.com/spyder-ide/spyder/issues/13896), [13877](https://github.com/spyder-ide/spyder/issues/13877), [13872](https://github.com/spyder-ide/spyder/issues/13872))
* [PR 13884](https://github.com/spyder-ide/spyder/pull/13884) - PR: Display an error message when Kite sends a non-dict response, by [@andfoy](https://github.com/andfoy) ([13121](https://github.com/spyder-ide/spyder/issues/13121))
* [PR 13881](https://github.com/spyder-ide/spyder/pull/13881) - PR: Test icons for naming changes in QtAwesome, by [@dalthviz](https://github.com/dalthviz)
* [PR 13876](https://github.com/spyder-ide/spyder/pull/13876) - PR: Make date objects editable in the object explorer, by [@steff456](https://github.com/steff456) ([13557](https://github.com/spyder-ide/spyder/issues/13557))
* [PR 13867](https://github.com/spyder-ide/spyder/pull/13867) - PR: Improve performance when painting indent guides, by [@ccordoba12](https://github.com/ccordoba12) ([8864](https://github.com/spyder-ide/spyder/issues/8864))
* [PR 13852](https://github.com/spyder-ide/spyder/pull/13852) - PR: Add test for spyder-kernels#243, by [@impact27](https://github.com/impact27) ([12651](https://github.com/spyder-ide/spyder/issues/12651))
* [PR 13843](https://github.com/spyder-ide/spyder/pull/13843) - PR: Update optional dependency on Pandas to 1.1.1, by [@steff456](https://github.com/steff456) ([13620](https://github.com/spyder-ide/spyder/issues/13620))
* [PR 13839](https://github.com/spyder-ide/spyder/pull/13839) - PR: Update Jedi requirement to 0.17.2, by [@ccordoba12](https://github.com/ccordoba12) ([13807](https://github.com/spyder-ide/spyder/issues/13807), [12259](https://github.com/spyder-ide/spyder/issues/12259))
* [PR 13834](https://github.com/spyder-ide/spyder/pull/13834) - PR: Only highlight multiple occurrences in the editor, by [@steff456](https://github.com/steff456) ([13762](https://github.com/spyder-ide/spyder/issues/13762))
* [PR 13833](https://github.com/spyder-ide/spyder/pull/13833) - PR: Fix some UX/UI issues in the Files pane, by [@steff456](https://github.com/steff456) ([13465](https://github.com/spyder-ide/spyder/issues/13465))
* [PR 13830](https://github.com/spyder-ide/spyder/pull/13830) - PR: Update version of qtconsole to 4.7.7, by [@steff456](https://github.com/steff456) ([13806](https://github.com/spyder-ide/spyder/issues/13806))
* [PR 13828](https://github.com/spyder-ide/spyder/pull/13828) - PR: Don't send requests to the PyLS until it's been properly initialized, by [@ccordoba12](https://github.com/ccordoba12) ([13351](https://github.com/spyder-ide/spyder/issues/13351))
* [PR 13818](https://github.com/spyder-ide/spyder/pull/13818) - PR: Update subrepo with spyder-kernels#244, by [@dalthviz](https://github.com/dalthviz) ([13632](https://github.com/spyder-ide/spyder/issues/13632))
* [PR 13817](https://github.com/spyder-ide/spyder/pull/13817) - PR: Change tooltip of PYTHONPATH manager to match title in dialog, by [@juanitagomezr](https://github.com/juanitagomezr) ([13741](https://github.com/spyder-ide/spyder/issues/13741))
* [PR 13814](https://github.com/spyder-ide/spyder/pull/13814) - PR: Press enter on completion test, by [@bnavigator](https://github.com/bnavigator)
* [PR 13796](https://github.com/spyder-ide/spyder/pull/13796) - PR: Remove repeated SymbolKind enum, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13791](https://github.com/spyder-ide/spyder/pull/13791) - PR: Restore sorting of types and natural sorting, by [@skjerns](https://github.com/skjerns) ([13733](https://github.com/spyder-ide/spyder/issues/13733))
* [PR 13789](https://github.com/spyder-ide/spyder/pull/13789) - PR: Update contributing guide to install main dependencies from the dev label in our channel, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13787](https://github.com/spyder-ide/spyder/pull/13787) - PR: Call QGuiApplication.setDesktopFileName to fix generic icon on GNOME/Wayland, by [@musicinmybrain](https://github.com/musicinmybrain) ([13786](https://github.com/spyder-ide/spyder/issues/13786))
* [PR 13765](https://github.com/spyder-ide/spyder/pull/13765) - PR: Remove pin for python-jsonrpc-server and update PyLS subrepo (Testing), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13756](https://github.com/spyder-ide/spyder/pull/13756) - PR: Pin python-jsonrpc-server to a working version in our CIs (for now), by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13753](https://github.com/spyder-ide/spyder/pull/13753) - PR: Handle IndexError in Pylint history, by [@steff456](https://github.com/steff456) ([13342](https://github.com/spyder-ide/spyder/issues/13342))
* [PR 13750](https://github.com/spyder-ide/spyder/pull/13750) - PR: Fixes to Help plugin according to UX review, by [@juanis2112](https://github.com/juanis2112) ([13241](https://github.com/spyder-ide/spyder/issues/13241))
* [PR 13740](https://github.com/spyder-ide/spyder/pull/13740) - PR: Fix create folder in Projects, by [@akwasigroch](https://github.com/akwasigroch) ([13722](https://github.com/spyder-ide/spyder/issues/13722))
* [PR 13721](https://github.com/spyder-ide/spyder/pull/13721) - PR: Correctly import IPythonInputSplitter for IPython < 7.0, by [@ccordoba12](https://github.com/ccordoba12) ([13719](https://github.com/spyder-ide/spyder/issues/13719))
* [PR 13717](https://github.com/spyder-ide/spyder/pull/13717) - PR: Fix technical bugs on tour, by [@juanis2112](https://github.com/juanis2112) ([13240](https://github.com/spyder-ide/spyder/issues/13240))
* [PR 13634](https://github.com/spyder-ide/spyder/pull/13634) - PR: Skip error when getting values (IPython console), by [@impact27](https://github.com/impact27) ([13623](https://github.com/spyder-ide/spyder/issues/13623))
* [PR 13627](https://github.com/spyder-ide/spyder/pull/13627) - PR: Fix some issues with the PyLS subrepo, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13598](https://github.com/spyder-ide/spyder/pull/13598) - PR: Fix messages shown in plain text (Help), by [@steff456](https://github.com/steff456) ([13585](https://github.com/spyder-ide/spyder/issues/13585))
* [PR 13590](https://github.com/spyder-ide/spyder/pull/13590) - PR: Fix height of "Run > Configuration per file" dialog by adding a scrollbar to it, by [@steff456](https://github.com/steff456) ([13531](https://github.com/spyder-ide/spyder/issues/13531))
* [PR 13380](https://github.com/spyder-ide/spyder/pull/13380) - PR: Add option to insert elements above/below in lists (Variable Explorer), by [@dpturibio](https://github.com/dpturibio) ([13371](https://github.com/spyder-ide/spyder/issues/13371))
* [PR 13379](https://github.com/spyder-ide/spyder/pull/13379) - PR: Fix close button while debugging, by [@impact27](https://github.com/impact27) ([13283](https://github.com/spyder-ide/spyder/issues/13283))
* [PR 13327](https://github.com/spyder-ide/spyder/pull/13327) - PR: Improve Pdb input handling, by [@impact27](https://github.com/impact27) ([620](https://github.com/spyder-ide/spyder/issues/620))
* [PR 13295](https://github.com/spyder-ide/spyder/pull/13295) - PR: Enable LSP autoformatting support, by [@andfoy](https://github.com/andfoy) ([11396](https://github.com/spyder-ide/spyder/issues/11396))
* [PR 13281](https://github.com/spyder-ide/spyder/pull/13281) - PR: Improve performance when processing linting results and scrolling (Editor), by [@ccordoba12](https://github.com/ccordoba12) ([13908](https://github.com/spyder-ide/spyder/issues/13908), [13668](https://github.com/spyder-ide/spyder/issues/13668), [13666](https://github.com/spyder-ide/spyder/issues/13666), [13020](https://github.com/spyder-ide/spyder/issues/13020))
* [PR 13269](https://github.com/spyder-ide/spyder/pull/13269) - PR: Windows Installer script, by [@dalthviz](https://github.com/dalthviz) ([13145](https://github.com/spyder-ide/spyder/issues/13145))
* [PR 13190](https://github.com/spyder-ide/spyder/pull/13190) - PR: Go to current position when using the Pdb `where` command, by [@impact27](https://github.com/impact27)
* [PR 13149](https://github.com/spyder-ide/spyder/pull/13149) - PR: Normcase breakpoints to avoid issues on Windows, by [@impact27](https://github.com/impact27)
* [PR 13109](https://github.com/spyder-ide/spyder/pull/13109) - PR: Migrate the Outline Explorer to use LSP information, by [@andfoy](https://github.com/andfoy)
* [PR 12926](https://github.com/spyder-ide/spyder/pull/12926) - PR: Add safe-mode option to Spyder in non dev mode, by [@juanis2112](https://github.com/juanis2112) ([12631](https://github.com/spyder-ide/spyder/issues/12631))
* [PR 12236](https://github.com/spyder-ide/spyder/pull/12236) - PR: Start kernels and Jedi envs with explicit environment (Mac app), by [@mrclary](https://github.com/mrclary)
* [PR 12235](https://github.com/spyder-ide/spyder/pull/12235) - PR: Use clean environment for Python version and module checks (Mac app), by [@mrclary](https://github.com/mrclary)
* [PR 12232](https://github.com/spyder-ide/spyder/pull/12232) - PR: Display interpreter status if Spyder not launched from conda envrionment (Mac app), by [@mrclary](https://github.com/mrclary) ([6](https://github.com/spyder-ide/mac-application/issues/6))
* [PR 12134](https://github.com/spyder-ide/spyder/pull/12134) - PR: Use '!' for Pdb commands and add other options to control the debugger (IPython console), by [@impact27](https://github.com/impact27)
* [PR 12011](https://github.com/spyder-ide/spyder/pull/12011) - PR: Initial changes to create again a macOS standalone app, by [@mrclary](https://github.com/mrclary)
* [PR 10873](https://github.com/spyder-ide/spyder/pull/10873) - PR: Add a cache to runcell, by [@impact27](https://github.com/impact27) ([9725](https://github.com/spyder-ide/spyder/issues/9725))

In this release 105 pull requests were closed.


----


## Version 4.1.6 (2020-11-08)

### Important fixes

* Fix support for Python 2

### Issues Closed

* [Issue 13962](https://github.com/spyder-ide/spyder/issues/13962) - Spyder within Python 2.7 Anaconda environment crashes ([PR 14169](https://github.com/spyder-ide/spyder/pull/14169) by [@ccordoba12](https://github.com/ccordoba12))

In this release 1 issue was closed.

### Pull Requests Merged

* [PR 14169](https://github.com/spyder-ide/spyder/pull/14169) - PR: Fixes to release 4.1.6, by [@ccordoba12](https://github.com/ccordoba12) ([13962](https://github.com/spyder-ide/spyder/issues/13962))

In this release 1 pull request was closed.


----


## Version 4.1.5 (2020-09-01)

### New features

* Add natural sorting for variables in the Variable Explorer.
* Add shortcut to open files in the Editor in the operating system file
  explorer.
* Add an option to run lines of code when entering the debugger. This is
  present in `Preferences > IPython console > Startup`.

### Important fixes

* Fix error when opening projects.
* Fix error when hovering in the Editor caused by Kite.
* Don't save files when running cells.
* Several improvements to the user experience of Files.

### Issues Closed

* [Issue 13635](https://github.com/spyder-ide/spyder/issues/13635) - Update spyder-kernels subrepo ([PR 13202](https://github.com/spyder-ide/spyder/pull/13202) by [@impact27](https://github.com/impact27))
* [Issue 13490](https://github.com/spyder-ide/spyder/issues/13490) - Test `test_dbg_input` is failing in Linux fast CI ([PR 13499](https://github.com/spyder-ide/spyder/pull/13499) by [@impact27](https://github.com/impact27))
* [Issue 13481](https://github.com/spyder-ide/spyder/issues/13481) - Can't open Dict in variable explorer with mixed data types as keys. ([PR 13545](https://github.com/spyder-ide/spyder/pull/13545) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13444](https://github.com/spyder-ide/spyder/issues/13444) - Explorer "New" actions should depend on selected files ([PR 13482](https://github.com/spyder-ide/spyder/pull/13482) by [@steff456](https://github.com/steff456))
* [Issue 13417](https://github.com/spyder-ide/spyder/issues/13417) - Error in Spyder tutorial ([PR 13419](https://github.com/spyder-ide/spyder/pull/13419) by [@aznpooface](https://github.com/aznpooface))
* [Issue 13388](https://github.com/spyder-ide/spyder/issues/13388) - BrokenPipeError when trying to connect to the Pydoc server ([PR 13407](https://github.com/spyder-ide/spyder/pull/13407) by [@steff456](https://github.com/steff456))
* [Issue 13363](https://github.com/spyder-ide/spyder/issues/13363) - Profiler doesn't sort by time ([PR 13426](https://github.com/spyder-ide/spyder/pull/13426) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13346](https://github.com/spyder-ide/spyder/issues/13346) - TypeError when opening a project ([PR 13377](https://github.com/spyder-ide/spyder/pull/13377) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13297](https://github.com/spyder-ide/spyder/issues/13297) - TypeError when hovering in the editor ([PR 13575](https://github.com/spyder-ide/spyder/pull/13575) by [@andfoy](https://github.com/andfoy))
* [Issue 13254](https://github.com/spyder-ide/spyder/issues/13254) - Add (0) to first image stored when saving all images from IDE ([PR 13334](https://github.com/spyder-ide/spyder/pull/13334) by [@arteagac](https://github.com/arteagac))
* [Issue 13230](https://github.com/spyder-ide/spyder/issues/13230) - Another KeyError when folding regions ([PR 13279](https://github.com/spyder-ide/spyder/pull/13279) by [@steff456](https://github.com/steff456))
* [Issue 13197](https://github.com/spyder-ide/spyder/issues/13197) - Spyder saves files before running code cells (but should not) ([PR 13202](https://github.com/spyder-ide/spyder/pull/13202) by [@impact27](https://github.com/impact27))
* [Issue 13179](https://github.com/spyder-ide/spyder/issues/13179) - Some improvements for the Files plugin ([PR 13209](https://github.com/spyder-ide/spyder/pull/13209) by [@dalthviz](https://github.com/dalthviz))
* [Issue 13158](https://github.com/spyder-ide/spyder/issues/13158) - Feature request: keyboard shortcut for "Show in external file explorer"
* [Issue 13144](https://github.com/spyder-ide/spyder/issues/13144) - I'm not able to search by context in the shortcuts table ([PR 13294](https://github.com/spyder-ide/spyder/pull/13294) by [@steff456](https://github.com/steff456))
* [Issue 12795](https://github.com/spyder-ide/spyder/issues/12795) - Startup script for debugger ([PR 10542](https://github.com/spyder-ide/spyder/pull/10542) by [@impact27](https://github.com/impact27))
* [Issue 7844](https://github.com/spyder-ide/spyder/issues/7844) - Add a "Copy to clipboard" button to the "About Spyder" window ([PR 13268](https://github.com/spyder-ide/spyder/pull/13268) by [@davidxbuck](https://github.com/davidxbuck))

In this release 17 issues were closed.

### Pull Requests Merged

* [PR 13679](https://github.com/spyder-ide/spyder/pull/13679) - PR: Update required version of spyder-kernels for 4.1.5, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13621](https://github.com/spyder-ide/spyder/pull/13621) - PR: Install PyLS locally without modifying site-packages, by [@andfoy](https://github.com/andfoy)
* [PR 13575](https://github.com/spyder-ide/spyder/pull/13575) - PR: Prevent raising an exception when a hover request returns a list, by [@andfoy](https://github.com/andfoy) ([13297](https://github.com/spyder-ide/spyder/issues/13297))
* [PR 13559](https://github.com/spyder-ide/spyder/pull/13559) - PR: Fix using dir in the spyder module, by [@impact27](https://github.com/impact27)
* [PR 13558](https://github.com/spyder-ide/spyder/pull/13558) - PR: Add natural sorting for dicts (Variable Explorer), by [@skjerns](https://github.com/skjerns)
* [PR 13554](https://github.com/spyder-ide/spyder/pull/13554) - PR: Change About and Dependencies dialogs to non-modal, by [@juanis2112](https://github.com/juanis2112)
* [PR 13545](https://github.com/spyder-ide/spyder/pull/13545) - PR: Fix error when showing dicts with mixed type keys (Variable Explorer), by [@ccordoba12](https://github.com/ccordoba12) ([13481](https://github.com/spyder-ide/spyder/issues/13481))
* [PR 13499](https://github.com/spyder-ide/spyder/pull/13499) - PR: Fix failing test for IPython 7.17, by [@impact27](https://github.com/impact27) ([13490](https://github.com/spyder-ide/spyder/issues/13490))
* [PR 13482](https://github.com/spyder-ide/spyder/pull/13482) - PR: Explorer "New" actions now depend on selected files, by [@steff456](https://github.com/steff456) ([13444](https://github.com/spyder-ide/spyder/issues/13444))
* [PR 13426](https://github.com/spyder-ide/spyder/pull/13426) - PR: Fix sorting of files in profiler by fixing parser, by [@juanis2112](https://github.com/juanis2112) ([13363](https://github.com/spyder-ide/spyder/issues/13363))
* [PR 13419](https://github.com/spyder-ide/spyder/pull/13419) - PR: Fix error in tutorial (Help), by [@aznpooface](https://github.com/aznpooface) ([13417](https://github.com/spyder-ide/spyder/issues/13417))
* [PR 13408](https://github.com/spyder-ide/spyder/pull/13408) - PR: Fix some failing tests, by [@goanpeca](https://github.com/goanpeca)
* [PR 13407](https://github.com/spyder-ide/spyder/pull/13407) - PR: Catch BrokenPipeError when trying to open a port (Online Help), by [@steff456](https://github.com/steff456) ([13388](https://github.com/spyder-ide/spyder/issues/13388))
* [PR 13396](https://github.com/spyder-ide/spyder/pull/13396) - PR: Improve Binder installation, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13395](https://github.com/spyder-ide/spyder/pull/13395) - PR: Remove Github action to add Binder badge on pull request creation, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13393](https://github.com/spyder-ide/spyder/pull/13393) - PR: Fix Binder actions, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13392](https://github.com/spyder-ide/spyder/pull/13392) - PR: Add Github actions to display a Binder badge in our PRs, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13377](https://github.com/spyder-ide/spyder/pull/13377) - PR: Verify path before notifying project was open, by [@dalthviz](https://github.com/dalthviz) ([13346](https://github.com/spyder-ide/spyder/issues/13346))
* [PR 13376](https://github.com/spyder-ide/spyder/pull/13376) - PR: Fix some issues with the Find and Code Analysis panes, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13359](https://github.com/spyder-ide/spyder/pull/13359) - PR: Add a "Show in external file browser" shortcut (Editor), by [@athompson673](https://github.com/athompson673)
* [PR 13334](https://github.com/spyder-ide/spyder/pull/13334) - PR: Fix for consistent numbering when saving multiple plots, by [@arteagac](https://github.com/arteagac) ([13254](https://github.com/spyder-ide/spyder/issues/13254))
* [PR 13311](https://github.com/spyder-ide/spyder/pull/13311) - PR: Remove Python 2 testing on Github Actions, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13294](https://github.com/spyder-ide/spyder/pull/13294) - PR: Enable filtering in multiple columns in the shortcuts table (Preferences), by [@steff456](https://github.com/steff456) ([13144](https://github.com/spyder-ide/spyder/issues/13144))
* [PR 13293](https://github.com/spyder-ide/spyder/pull/13293) - PR: Fix linux container dependencies install, by [@goanpeca](https://github.com/goanpeca)
* [PR 13279](https://github.com/spyder-ide/spyder/pull/13279) - PR: Catch KeyError in codefolding when folding regions, by [@steff456](https://github.com/steff456) ([13230](https://github.com/spyder-ide/spyder/issues/13230))
* [PR 13268](https://github.com/spyder-ide/spyder/pull/13268) - PR: Add "Copy to clipboard" button to the "About Spyder" dialog, by [@davidxbuck](https://github.com/davidxbuck) ([7844](https://github.com/spyder-ide/spyder/issues/7844))
* [PR 13259](https://github.com/spyder-ide/spyder/pull/13259) - PR: Update Contributing guide to specify forking the Spyder repo, by [@CAM-Gerlach](https://github.com/CAM-Gerlach)
* [PR 13209](https://github.com/spyder-ide/spyder/pull/13209) - PR: Improve Files plugin UI, by [@dalthviz](https://github.com/dalthviz) ([13179](https://github.com/spyder-ide/spyder/issues/13179))
* [PR 13202](https://github.com/spyder-ide/spyder/pull/13202) - PR: Do not save file when runcell, by [@impact27](https://github.com/impact27) ([13635](https://github.com/spyder-ide/spyder/issues/13635), [13197](https://github.com/spyder-ide/spyder/issues/13197))
* [PR 10542](https://github.com/spyder-ide/spyder/pull/10542) - PR: Add startup lines to the debugger, by [@impact27](https://github.com/impact27) ([12795](https://github.com/spyder-ide/spyder/issues/12795))

In this release 30 pull requests were closed.


----


## Version 4.1.4 (2020-07-10)

### Important fixes

* Fix linter not being updated after changes on Windows.
* Correctly restart kernels after a crash while running code.
* Clear variable explorer after a kernel restart.
* Fix several errors when sorting variables in the variable explorer.
* Fix selection color in several syntax highlighting themes.
* Support Jedi 0.17.1, which fixes several issues with code completion in the
  editor.
* Fix errors when running Dask code in the IPython console.
* Show scrollflag in macOS with the dark theme.
* Only show folding arrows when the user hovers over them, which improves
  responsiveness in the editor
* Fix several problems with the integration between our projects and the
  Python language server.
* Handle NaT values in the Variable Explorer.

### Issues Closed

* [Issue 13205](https://github.com/spyder-ide/spyder/issues/13205) - Invalid interpreter causes crash over the LSP/pyls ([PR 13217](https://github.com/spyder-ide/spyder/pull/13217) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13191](https://github.com/spyder-ide/spyder/issues/13191) - Missing arrows to change tab on mac ([PR 13249](https://github.com/spyder-ide/spyder/pull/13249) by [@impact27](https://github.com/impact27))
* [Issue 13178](https://github.com/spyder-ide/spyder/issues/13178) - Some improvements to the Find pane ([PR 13215](https://github.com/spyder-ide/spyder/pull/13215) by [@steff456](https://github.com/steff456))
* [Issue 13172](https://github.com/spyder-ide/spyder/issues/13172) - Update translations for 4.1.4 ([PR 13170](https://github.com/spyder-ide/spyder/pull/13170) by [@spyder-bot](https://github.com/spyder-bot))
* [Issue 13164](https://github.com/spyder-ide/spyder/issues/13164) - Kernel fails to send config sometimes ([PR 13166](https://github.com/spyder-ide/spyder/pull/13166) by [@impact27](https://github.com/impact27))
* [Issue 13148](https://github.com/spyder-ide/spyder/issues/13148) - Segmentation fault when requesting context menu for a one file in project explorer ([PR 13226](https://github.com/spyder-ide/spyder/pull/13226) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 13119](https://github.com/spyder-ide/spyder/issues/13119) - Minor spelling error in Spyder tutorial
* [Issue 13110](https://github.com/spyder-ide/spyder/issues/13110) - Linting is not respecting pycodestyle.cfg ([PR 13146](https://github.com/spyder-ide/spyder/pull/13146) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13069](https://github.com/spyder-ide/spyder/issues/13069) - Debugger panel is not shown for pyw files ([PR 13085](https://github.com/spyder-ide/spyder/pull/13085) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13059](https://github.com/spyder-ide/spyder/issues/13059) - Fix abbreviations for seconds in profiler ([PR 13081](https://github.com/spyder-ide/spyder/pull/13081) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13048](https://github.com/spyder-ide/spyder/issues/13048) - Spyder claims to be "Connecting to kernel" while running a file ([PR 13056](https://github.com/spyder-ide/spyder/pull/13056) by [@impact27](https://github.com/impact27))
* [Issue 13018](https://github.com/spyder-ide/spyder/issues/13018) - Kernel is not restarted correctly when RecursiveError is thrown on Windows ([PR 12972](https://github.com/spyder-ide/spyder/pull/12972) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 13009](https://github.com/spyder-ide/spyder/issues/13009) - Missing fold marks in the Spyder 2 theme ([PR 13015](https://github.com/spyder-ide/spyder/pull/13015) by [@juanis2112](https://github.com/juanis2112))
* [Issue 13004](https://github.com/spyder-ide/spyder/issues/13004) - Right-clicking an empty folder doesn't show the context menu of the Files pane ([PR 13032](https://github.com/spyder-ide/spyder/pull/13032) by [@steff456](https://github.com/steff456))
* [Issue 12999](https://github.com/spyder-ide/spyder/issues/12999) - IPython console hangs after changing warning to errors ([PR 13007](https://github.com/spyder-ide/spyder/pull/13007) by [@impact27](https://github.com/impact27))
* [Issue 12992](https://github.com/spyder-ide/spyder/issues/12992) - Shift+return not working for run selection -  no solutions work ([PR 13047](https://github.com/spyder-ide/spyder/pull/13047) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12892](https://github.com/spyder-ide/spyder/issues/12892) - Open new file causes an error ([PR 13040](https://github.com/spyder-ide/spyder/pull/13040) by [@steff456](https://github.com/steff456))
* [Issue 12883](https://github.com/spyder-ide/spyder/issues/12883) - File names are repeated in Code analysis file combobox ([PR 12884](https://github.com/spyder-ide/spyder/pull/12884) by [@steff456](https://github.com/steff456))
* [Issue 12857](https://github.com/spyder-ide/spyder/issues/12857) - Selection color makes comments not visible ([PR 12981](https://github.com/spyder-ide/spyder/pull/12981) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12825](https://github.com/spyder-ide/spyder/issues/12825) - Variable inspector opens window out of focus ([PR 13033](https://github.com/spyder-ide/spyder/pull/13033) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12810](https://github.com/spyder-ide/spyder/issues/12810) - Can't close any editor tab when in debug mode ([PR 12985](https://github.com/spyder-ide/spyder/pull/12985) by [@steff456](https://github.com/steff456))
* [Issue 12801](https://github.com/spyder-ide/spyder/issues/12801) - Include first __main__ caller in post-mortem debugger stack trace
* [Issue 12799](https://github.com/spyder-ide/spyder/issues/12799) - Improve error message when loading spydata files ([PR 13052](https://github.com/spyder-ide/spyder/pull/13052) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12755](https://github.com/spyder-ide/spyder/issues/12755) - I closed an autosave file and Spyder said there is some error ([PR 12822](https://github.com/spyder-ide/spyder/pull/12822) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 12748](https://github.com/spyder-ide/spyder/issues/12748) - Update CI to include caching ([PR 12826](https://github.com/spyder-ide/spyder/pull/12826) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12740](https://github.com/spyder-ide/spyder/issues/12740) - Code Analysis customize history not working and actions unavailable when pane is undocked ([PR 12874](https://github.com/spyder-ide/spyder/pull/12874) by [@steff456](https://github.com/steff456))
* [Issue 12735](https://github.com/spyder-ide/spyder/issues/12735) - Change output of code analysis to show the full names of the pylint messages ([PR 12803](https://github.com/spyder-ide/spyder/pull/12803) by [@CAM-Gerlach](https://github.com/CAM-Gerlach))
* [Issue 12733](https://github.com/spyder-ide/spyder/issues/12733) - Change menu item to run code analysis ([PR 12734](https://github.com/spyder-ide/spyder/pull/12734) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12716](https://github.com/spyder-ide/spyder/issues/12716) - I never want to restart Spyder when the display dpi changes  ([PR 12881](https://github.com/spyder-ide/spyder/pull/12881) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12704](https://github.com/spyder-ide/spyder/issues/12704) - Deleting space before a word trigger meaningless completion ([PR 12710](https://github.com/spyder-ide/spyder/pull/12710) by [@steff456](https://github.com/steff456))
* [Issue 12689](https://github.com/spyder-ide/spyder/issues/12689) - Variables need to be deleted twice in the variable viewer ([PR 12695](https://github.com/spyder-ide/spyder/pull/12695) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12661](https://github.com/spyder-ide/spyder/issues/12661) - Change "Replace selection" to "Replace in selection" ([PR 12811](https://github.com/spyder-ide/spyder/pull/12811) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12659](https://github.com/spyder-ide/spyder/issues/12659) - 'Replace selection' reduces selected range ([PR 12745](https://github.com/spyder-ide/spyder/pull/12745) by [@steff456](https://github.com/steff456))
* [Issue 12657](https://github.com/spyder-ide/spyder/issues/12657) - Change text for collapse and expand selection, remove restore in Code Analysis pane ([PR 12653](https://github.com/spyder-ide/spyder/pull/12653) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12654](https://github.com/spyder-ide/spyder/issues/12654) - runtests.py attempts to collect tests from subrepos if extra arguments are given ([PR 12672](https://github.com/spyder-ide/spyder/pull/12672) by [@mrclary](https://github.com/mrclary))
* [Issue 12637](https://github.com/spyder-ide/spyder/issues/12637) - The scrollflag is missing in Spyder 4 on MacOS 10.15 ([PR 13071](https://github.com/spyder-ide/spyder/pull/13071) by [@steff456](https://github.com/steff456))
* [Issue 12620](https://github.com/spyder-ide/spyder/issues/12620) - Incorrect sorting with numbers in scientific notation ([PR 12901](https://github.com/spyder-ide/spyder/pull/12901) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12598](https://github.com/spyder-ide/spyder/issues/12598) - Connecting to external PyLS server is broken
* [Issue 12597](https://github.com/spyder-ide/spyder/issues/12597) - Code cells not properly executed from splitted editors or new window editors ([PR 12713](https://github.com/spyder-ide/spyder/pull/12713) by [@impact27](https://github.com/impact27))
* [Issue 12596](https://github.com/spyder-ide/spyder/issues/12596) - Additional empty line is added at the end of the template ([PR 12708](https://github.com/spyder-ide/spyder/pull/12708) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12575](https://github.com/spyder-ide/spyder/issues/12575) - Variable Explorer very slow with large dataframe ([PR 12697](https://github.com/spyder-ide/spyder/pull/12697) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12572](https://github.com/spyder-ide/spyder/issues/12572) - Support for jedi 0.17.0 ([PR 12792](https://github.com/spyder-ide/spyder/pull/12792) by [@andfoy](https://github.com/andfoy))
* [Issue 12563](https://github.com/spyder-ide/spyder/issues/12563) - Improve error message when trying to view a dataframe and Pandas is not installed next to Spyder ([PR 12902](https://github.com/spyder-ide/spyder/pull/12902) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12562](https://github.com/spyder-ide/spyder/issues/12562) - Colour Theme Editor UI Issue ([PR 12986](https://github.com/spyder-ide/spyder/pull/12986) by [@steff456](https://github.com/steff456))
* [Issue 12558](https://github.com/spyder-ide/spyder/issues/12558) - Middle mouse button click on editor tabs may close wrong tab ([PR 12617](https://github.com/spyder-ide/spyder/pull/12617) by [@steff456](https://github.com/steff456))
* [Issue 12491](https://github.com/spyder-ide/spyder/issues/12491) - Shortcut to go to Project pane is not working ([PR 12843](https://github.com/spyder-ide/spyder/pull/12843) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 12465](https://github.com/spyder-ide/spyder/issues/12465) - Spyder is interfering with Dask
* [Issue 12437](https://github.com/spyder-ide/spyder/issues/12437) - Minor issue with editor on macOS and the light theme ([PR 13060](https://github.com/spyder-ide/spyder/pull/13060) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12333](https://github.com/spyder-ide/spyder/issues/12333) - Tab-completion of keyword arguments makes paranthesis ([PR 12792](https://github.com/spyder-ide/spyder/pull/12792) by [@andfoy](https://github.com/andfoy))
* [Issue 12328](https://github.com/spyder-ide/spyder/issues/12328) - test_mainwindow.py opens too many file descriptors and sockets ([PR 12534](https://github.com/spyder-ide/spyder/pull/12534) by [@impact27](https://github.com/impact27))
* [Issue 12315](https://github.com/spyder-ide/spyder/issues/12315) - Restore code folding for large files ([PR 12937](https://github.com/spyder-ide/spyder/pull/12937) by [@andfoy](https://github.com/andfoy))
* [Issue 12266](https://github.com/spyder-ide/spyder/issues/12266) - Crash in fallback plugin when typing character ([PR 13038](https://github.com/spyder-ide/spyder/pull/13038) by [@andfoy](https://github.com/andfoy))
* [Issue 12225](https://github.com/spyder-ide/spyder/issues/12225) - LSP cycling : restarting ... ready ... restarting ... ([PR 12912](https://github.com/spyder-ide/spyder/pull/12912) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11933](https://github.com/spyder-ide/spyder/issues/11933) - Calltips not showing in editor for some functions with Jedi 0.15 ([PR 12792](https://github.com/spyder-ide/spyder/pull/12792) by [@andfoy](https://github.com/andfoy))
* [Issue 11889](https://github.com/spyder-ide/spyder/issues/11889) - TimeoutError when starting a kernel still poping out ([PR 12457](https://github.com/spyder-ide/spyder/pull/12457) by [@impact27](https://github.com/impact27))
* [Issue 11654](https://github.com/spyder-ide/spyder/issues/11654) - Fix request_params in send_workspace_folders_change ([PR 12812](https://github.com/spyder-ide/spyder/pull/12812) by [@andfoy](https://github.com/andfoy))
* [Issue 11506](https://github.com/spyder-ide/spyder/issues/11506) - Linter stays half-dead on Windows ([PR 12771](https://github.com/spyder-ide/spyder/pull/12771) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11154](https://github.com/spyder-ide/spyder/issues/11154) - Problem decoding source (pyflakes E) (Spyder 4) ([PR 12771](https://github.com/spyder-ide/spyder/pull/12771) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 10702](https://github.com/spyder-ide/spyder/issues/10702) - Variables disappear from Spyder 4.0 Variable Explorer  ([PR 10843](https://github.com/spyder-ide/spyder/pull/10843) by [@impact27](https://github.com/impact27))
* [Issue 10329](https://github.com/spyder-ide/spyder/issues/10329) - re.error when creating kernel
* [Issue 8329](https://github.com/spyder-ide/spyder/issues/8329) - Error when trying to inspect a 'NaT' in Variable Explorer ([PR 12700](https://github.com/spyder-ide/spyder/pull/12700) by [@dalthviz](https://github.com/dalthviz))
* [Issue 3291](https://github.com/spyder-ide/spyder/issues/3291) - Spyder open file dialog doesn't show special/hidden files on macOS  ([PR 12886](https://github.com/spyder-ide/spyder/pull/12886) by [@goanpeca](https://github.com/goanpeca))

In this release 62 issues were closed.

### Pull Requests Merged

* [PR 13251](https://github.com/spyder-ide/spyder/pull/13251) - PR: Add fonts-ubuntu to the list of deb packages installed on Binder, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13249](https://github.com/spyder-ide/spyder/pull/13249) - PR: Remove arrows config in macOS stylesheet, by [@impact27](https://github.com/impact27) ([13191](https://github.com/spyder-ide/spyder/issues/13191))
* [PR 13242](https://github.com/spyder-ide/spyder/pull/13242) - PR: Update required versions of spyder-kernels and PyLS for 4.1.4, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13226](https://github.com/spyder-ide/spyder/pull/13226) - PR: Fix segfault when right-clicking any entry in the project explorer (2), by [@jnsebgosselin](https://github.com/jnsebgosselin) ([13148](https://github.com/spyder-ide/spyder/issues/13148))
* [PR 13217](https://github.com/spyder-ide/spyder/pull/13217) - PR: Validate Python interpreter when applying options (Main interpreter), by [@ccordoba12](https://github.com/ccordoba12) ([13205](https://github.com/spyder-ide/spyder/issues/13205))
* [PR 13215](https://github.com/spyder-ide/spyder/pull/13215) - PR: Some improvements for the Find pane, by [@steff456](https://github.com/steff456) ([13178](https://github.com/spyder-ide/spyder/issues/13178))
* [PR 13204](https://github.com/spyder-ide/spyder/pull/13204) - PR: Update spyder-kernels subrepo to fix an error with ipykernel 5.3.1, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13203](https://github.com/spyder-ide/spyder/pull/13203) - PR: Add scroll arrows fix for Qt 5.9 and 5.12, by [@goanpeca](https://github.com/goanpeca)
* [PR 13174](https://github.com/spyder-ide/spyder/pull/13174) - PR: Send comm config on every message to avoid TimeoutError's, by [@impact27](https://github.com/impact27)
* [PR 13170](https://github.com/spyder-ide/spyder/pull/13170) - PR: New translations from Crowdin, by [@spyder-bot](https://github.com/spyder-bot) ([13172](https://github.com/spyder-ide/spyder/issues/13172))
* [PR 13169](https://github.com/spyder-ide/spyder/pull/13169) - PR: Update translation files, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13166](https://github.com/spyder-ide/spyder/pull/13166) - PR: Ask config after configuration, by [@impact27](https://github.com/impact27) ([13164](https://github.com/spyder-ide/spyder/issues/13164))
* [PR 13146](https://github.com/spyder-ide/spyder/pull/13146) - PR: Some fixes to load project configuration files correctly, by [@ccordoba12](https://github.com/ccordoba12) ([13110](https://github.com/spyder-ide/spyder/issues/13110))
* [PR 13130](https://github.com/spyder-ide/spyder/pull/13130) - PR: Backport PR 13122, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13111](https://github.com/spyder-ide/spyder/pull/13111) - PR: Emit sig_project_closed when switching projects , by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13108](https://github.com/spyder-ide/spyder/pull/13108) - PR: Update author_email in setup.py, by [@goanpeca](https://github.com/goanpeca)
* [PR 13095](https://github.com/spyder-ide/spyder/pull/13095) - PR: Update Jedi to 0.17.1, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 13085](https://github.com/spyder-ide/spyder/pull/13085) - PR: Make an in-depth audit of different LSP calls, by [@ccordoba12](https://github.com/ccordoba12) ([13069](https://github.com/spyder-ide/spyder/issues/13069))
* [PR 13081](https://github.com/spyder-ide/spyder/pull/13081) - PR: Change time units in Profiler to match the International System of Units, by [@juanis2112](https://github.com/juanis2112) ([13059](https://github.com/spyder-ide/spyder/issues/13059))
* [PR 13071](https://github.com/spyder-ide/spyder/pull/13071) - PR: Show the scrollflag in macOS, by [@steff456](https://github.com/steff456) ([12637](https://github.com/spyder-ide/spyder/issues/12637))
* [PR 13060](https://github.com/spyder-ide/spyder/pull/13060) - PR: Fix scroll arrows, add retina images for tab bar and adjust colors shape and size, by [@goanpeca](https://github.com/goanpeca) ([12437](https://github.com/spyder-ide/spyder/issues/12437))
* [PR 13056](https://github.com/spyder-ide/spyder/pull/13056) - PR: Show console when other execution happens, by [@impact27](https://github.com/impact27) ([13048](https://github.com/spyder-ide/spyder/issues/13048))
* [PR 13052](https://github.com/spyder-ide/spyder/pull/13052) - PR: Improve error message for loading spydata with missing dependencies, by [@juanis2112](https://github.com/juanis2112) ([12799](https://github.com/spyder-ide/spyder/issues/12799))
* [PR 13047](https://github.com/spyder-ide/spyder/pull/13047) - PR: Clear old set shortcuts if they are now empty (Shortcuts), by [@dalthviz](https://github.com/dalthviz) ([12992](https://github.com/spyder-ide/spyder/issues/12992))
* [PR 13040](https://github.com/spyder-ide/spyder/pull/13040) - PR: Fix ValueError when an untitled file is open in the editor, by [@steff456](https://github.com/steff456) ([12892](https://github.com/spyder-ide/spyder/issues/12892))
* [PR 13038](https://github.com/spyder-ide/spyder/pull/13038) - PR: Check when prefix size is less than zero or longer than the string size (Fallback completions), by [@andfoy](https://github.com/andfoy) ([12266](https://github.com/spyder-ide/spyder/issues/12266))
* [PR 13033](https://github.com/spyder-ide/spyder/pull/13033) - PR: Update window flags on text editor for macOS (Variable Explorer), by [@goanpeca](https://github.com/goanpeca) ([12825](https://github.com/spyder-ide/spyder/issues/12825))
* [PR 13032](https://github.com/spyder-ide/spyder/pull/13032) - PR: Show the context menu with disabled options in the file explorer when it is empty, by [@steff456](https://github.com/steff456) ([13004](https://github.com/spyder-ide/spyder/issues/13004))
* [PR 13015](https://github.com/spyder-ide/spyder/pull/13015) - PR: Add code folding arrow icons for Spyder 2 icon theme, by [@juanis2112](https://github.com/juanis2112) ([13009](https://github.com/spyder-ide/spyder/issues/13009))
* [PR 13007](https://github.com/spyder-ide/spyder/pull/13007) - PR: Print stderr messages to the console (IPython console), by [@impact27](https://github.com/impact27) ([12999](https://github.com/spyder-ide/spyder/issues/12999))
* [PR 13003](https://github.com/spyder-ide/spyder/pull/13003) - PR: Store the analyzed filenames of the Code Analysis plugin, by [@steff456](https://github.com/steff456)
* [PR 13000](https://github.com/spyder-ide/spyder/pull/13000) - PR: Minor fixes in Readme, by [@amish-d](https://github.com/amish-d)
* [PR 12987](https://github.com/spyder-ide/spyder/pull/12987) - PR: Add warning on console if file is not saved before running it, by [@impact27](https://github.com/impact27)
* [PR 12986](https://github.com/spyder-ide/spyder/pull/12986) - PR: Add minimum width for the color names in the edit appearance panel, by [@steff456](https://github.com/steff456) ([12562](https://github.com/spyder-ide/spyder/issues/12562))
* [PR 12985](https://github.com/spyder-ide/spyder/pull/12985) - PR: Add message when the debug mode is on and the file cannot be closed, by [@steff456](https://github.com/steff456) ([12810](https://github.com/spyder-ide/spyder/issues/12810))
* [PR 12981](https://github.com/spyder-ide/spyder/pull/12981) - PR: Change ocurrence color for various themes to make comments visible, by [@juanis2112](https://github.com/juanis2112) ([12857](https://github.com/spyder-ide/spyder/issues/12857))
* [PR 12972](https://github.com/spyder-ide/spyder/pull/12972) - PR: Fix several problems about kernel restarts, by [@ccordoba12](https://github.com/ccordoba12) ([13018](https://github.com/spyder-ide/spyder/issues/13018))
* [PR 12937](https://github.com/spyder-ide/spyder/pull/12937) - PR: Enable/disable folding guides when cursor enters/exits the left panel, by [@andfoy](https://github.com/andfoy) ([12315](https://github.com/spyder-ide/spyder/issues/12315))
* [PR 12912](https://github.com/spyder-ide/spyder/pull/12912) - PR: Use QProcess instead of subprocess for the LPS transport layer and server, by [@ccordoba12](https://github.com/ccordoba12) ([12225](https://github.com/spyder-ide/spyder/issues/12225))
* [PR 12902](https://github.com/spyder-ide/spyder/pull/12902) - PR: Improve messages for missing modules in Variable Explorer, by [@juanis2112](https://github.com/juanis2112) ([12563](https://github.com/spyder-ide/spyder/issues/12563))
* [PR 12901](https://github.com/spyder-ide/spyder/pull/12901) - PR: Use UserRole to sort columns by actual value and not display value (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([12620](https://github.com/spyder-ide/spyder/issues/12620))
* [PR 12886](https://github.com/spyder-ide/spyder/pull/12886) - PR: Use QFileDialog on OSX to open files, by [@goanpeca](https://github.com/goanpeca) ([3291](https://github.com/spyder-ide/spyder/issues/3291))
* [PR 12884](https://github.com/spyder-ide/spyder/pull/12884) - PR: Verify if file is already shown in the combobox to avoid duplicates (Code Analysis), by [@steff456](https://github.com/steff456) ([12883](https://github.com/spyder-ide/spyder/issues/12883))
* [PR 12881](https://github.com/spyder-ide/spyder/pull/12881) - PR: Improve detection of screen scale change by storing current dpi, by [@dalthviz](https://github.com/dalthviz) ([12716](https://github.com/spyder-ide/spyder/issues/12716))
* [PR 12874](https://github.com/spyder-ide/spyder/pull/12874) - PR: Fix customizing Code Analysis history, by [@steff456](https://github.com/steff456) ([12740](https://github.com/spyder-ide/spyder/issues/12740))
* [PR 12852](https://github.com/spyder-ide/spyder/pull/12852) - PR: Fix hiding completion on backspace when nothing before cursor, by [@ElieGouzien](https://github.com/ElieGouzien)
* [PR 12845](https://github.com/spyder-ide/spyder/pull/12845) - PR: Set the Python language server current working directory to an empty dir, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12843](https://github.com/spyder-ide/spyder/pull/12843) - PR: Unmaximize on new/open/close/delete project, by [@jitseniesen](https://github.com/jitseniesen) ([12491](https://github.com/spyder-ide/spyder/issues/12491))
* [PR 12835](https://github.com/spyder-ide/spyder/pull/12835) - PR: Test that a file with the same name of a standard library module doesn't break the console, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12831](https://github.com/spyder-ide/spyder/pull/12831) - PR: Remove some odd blanks introduced in review, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12826](https://github.com/spyder-ide/spyder/pull/12826) - PR: Enable conda package cache in Github actions, by [@goanpeca](https://github.com/goanpeca) ([12748](https://github.com/spyder-ide/spyder/issues/12748))
* [PR 12822](https://github.com/spyder-ide/spyder/pull/12822) - PR: Ensure autosave files don't overwrite existing files, by [@jitseniesen](https://github.com/jitseniesen) ([12755](https://github.com/spyder-ide/spyder/issues/12755))
* [PR 12812](https://github.com/spyder-ide/spyder/pull/12812) - PR: Implement workspace/didChangeWorkspaceFolders correctly and fix major issues with workspace-only servers, by [@andfoy](https://github.com/andfoy) ([11654](https://github.com/spyder-ide/spyder/issues/11654))
* [PR 12811](https://github.com/spyder-ide/spyder/pull/12811) - PR: Change text of "Replace selection" to "Replace in selection", by [@juanis2112](https://github.com/juanis2112) ([12661](https://github.com/spyder-ide/spyder/issues/12661))
* [PR 12803](https://github.com/spyder-ide/spyder/pull/12803) - PR: Add Pylint message name to code analysis pane and refine format, by [@CAM-Gerlach](https://github.com/CAM-Gerlach) ([12735](https://github.com/spyder-ide/spyder/issues/12735))
* [PR 12792](https://github.com/spyder-ide/spyder/pull/12792) - PR: Update Jedi requirement to 0.17 and Parso to 0.7, by [@andfoy](https://github.com/andfoy) ([12572](https://github.com/spyder-ide/spyder/issues/12572), [12333](https://github.com/spyder-ide/spyder/issues/12333), [11933](https://github.com/spyder-ide/spyder/issues/11933))
* [PR 12781](https://github.com/spyder-ide/spyder/pull/12781) - PR: Add tool tip to EOLStatus, by [@OverLordGoldDragon](https://github.com/OverLordGoldDragon)
* [PR 12777](https://github.com/spyder-ide/spyder/pull/12777) - PR: Don't load files twice at startup and remove multiple calls to document_did_open, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12771](https://github.com/spyder-ide/spyder/pull/12771) - PR: Set LSP server stdout to None on Windows, by [@ccordoba12](https://github.com/ccordoba12) ([11506](https://github.com/spyder-ide/spyder/issues/11506), [11154](https://github.com/spyder-ide/spyder/issues/11154))
* [PR 12770](https://github.com/spyder-ide/spyder/pull/12770) - PR: Improve completions provided by FileComboBox, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12769](https://github.com/spyder-ide/spyder/pull/12769) - PR: Allow the default interpreter to be selected as a custom one in our Preferences, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12746](https://github.com/spyder-ide/spyder/pull/12746) - PR: Fix a couple of failing tests , by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12745](https://github.com/spyder-ide/spyder/pull/12745) - PR: Fix selected range after "Replace Selection", by [@steff456](https://github.com/steff456) ([12659](https://github.com/spyder-ide/spyder/issues/12659))
* [PR 12734](https://github.com/spyder-ide/spyder/pull/12734) - PR: Change menu item in Source menu from "Run static code analysis" to "Run code analysis", by [@juanis2112](https://github.com/juanis2112) ([12733](https://github.com/spyder-ide/spyder/issues/12733))
* [PR 12713](https://github.com/spyder-ide/spyder/pull/12713) - PR: Clone cell list to splitted editors, by [@impact27](https://github.com/impact27) ([12597](https://github.com/spyder-ide/spyder/issues/12597))
* [PR 12710](https://github.com/spyder-ide/spyder/pull/12710) - PR: Fix showing/hiding completions when backspace is pressed, by [@steff456](https://github.com/steff456) ([12704](https://github.com/spyder-ide/spyder/issues/12704))
* [PR 12708](https://github.com/spyder-ide/spyder/pull/12708) - PR: Remove additional empty line at the end of the template, by [@juanis2112](https://github.com/juanis2112) ([12596](https://github.com/spyder-ide/spyder/issues/12596))
* [PR 12700](https://github.com/spyder-ide/spyder/pull/12700) - PR: Handle NaT values (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([8329](https://github.com/spyder-ide/spyder/issues/8329))
* [PR 12697](https://github.com/spyder-ide/spyder/pull/12697) - PR: Store copy of the list representation of index and columns (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([12575](https://github.com/spyder-ide/spyder/issues/12575))
* [PR 12695](https://github.com/spyder-ide/spyder/pull/12695) - PR: Don't interrupt the kernel when resetting namespace, by [@ccordoba12](https://github.com/ccordoba12) ([12689](https://github.com/spyder-ide/spyder/issues/12689))
* [PR 12672](https://github.com/spyder-ide/spyder/pull/12672) - PR: Ignore external-deps directory in runtests.py, by [@mrclary](https://github.com/mrclary) ([12654](https://github.com/spyder-ide/spyder/issues/12654))
* [PR 12653](https://github.com/spyder-ide/spyder/pull/12653) - PR: Change text for collapse and expand selection and remove restore action in Code Analysis pane, by [@juanis2112](https://github.com/juanis2112) ([12657](https://github.com/spyder-ide/spyder/issues/12657))
* [PR 12639](https://github.com/spyder-ide/spyder/pull/12639) - PR: Add cron job for cancelling old builds, by [@goanpeca](https://github.com/goanpeca)
* [PR 12638](https://github.com/spyder-ide/spyder/pull/12638) - PR: Update release instructions to include localization updates, by [@goanpeca](https://github.com/goanpeca)
* [PR 12617](https://github.com/spyder-ide/spyder/pull/12617) - PR: Make middle mouse button click on editor tabs close the intended tab, by [@steff456](https://github.com/steff456) ([12558](https://github.com/spyder-ide/spyder/issues/12558))
* [PR 12534](https://github.com/spyder-ide/spyder/pull/12534) - PR: Close leaks without changing tests, by [@impact27](https://github.com/impact27) ([12328](https://github.com/spyder-ide/spyder/issues/12328))
* [PR 12480](https://github.com/spyder-ide/spyder/pull/12480) - PR: Add an option to filter logger messages when debugging, by [@andfoy](https://github.com/andfoy)
* [PR 12457](https://github.com/spyder-ide/spyder/pull/12457) - PR: Don't raise TimeoutError if the kernel is dead, by [@impact27](https://github.com/impact27) ([11889](https://github.com/spyder-ide/spyder/issues/11889))
* [PR 10843](https://github.com/spyder-ide/spyder/pull/10843) - PR: Fix sorting and loading data in the Variable Explorer, by [@impact27](https://github.com/impact27) ([10702](https://github.com/spyder-ide/spyder/issues/10702))

In this release 79 pull requests were closed.


----


## Version 4.1.3 (2020-05-08)

### New features

* New files are saved now as Utf-8 (instead of as Ascii).
* Make functionality to go to the previous/next cursor more intuitive.
* New dark and light themes for the Online Help pane.

### Important fixes

* Make Spyder work on Python 3.8 and Windows.
* Fix several startup crashes related to problems with Kite.
* Fix contrast issues present in several syntax highlighting themes.
* Fix "Directly enter debugging when errors appear" run option.
* Fix startup crash when Spyder is using the Brazilian Portuguese translation.
* Fix segfault on Unix systems when removing plots.
* Correctly position linting markers when code is folded in the editor.
* Correctly show variables while debugging in the Variable Explorer.

### Issues Closed

* [Issue 12510](https://github.com/spyder-ide/spyder/issues/12510) - Problem with Spyder's opening ([PR 12516](https://github.com/spyder-ide/spyder/pull/12516) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12477](https://github.com/spyder-ide/spyder/issues/12477) - Hovers don't hide when Spyder loses focus ([PR 12606](https://github.com/spyder-ide/spyder/pull/12606) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12459](https://github.com/spyder-ide/spyder/issues/12459) - Spyder quits when removing a plot and save plots dialog is wrong. ([PR 12518](https://github.com/spyder-ide/spyder/pull/12518) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12442](https://github.com/spyder-ide/spyder/issues/12442) - TimeoutError in the IPython console when moving or deleting startup script
* [Issue 12424](https://github.com/spyder-ide/spyder/issues/12424) - Improve Readme instructions on how to install Spyder from source ([PR 12432](https://github.com/spyder-ide/spyder/pull/12432) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12417](https://github.com/spyder-ide/spyder/issues/12417) - Inconsistencies with the completion widget ([PR 12453](https://github.com/spyder-ide/spyder/pull/12453) by [@steff456](https://github.com/steff456))
* [Issue 12416](https://github.com/spyder-ide/spyder/issues/12416) - Don't save files as ascii in the editor if there's no coding line ([PR 12467](https://github.com/spyder-ide/spyder/pull/12467) by [@andfoy](https://github.com/andfoy))
* [Issue 12415](https://github.com/spyder-ide/spyder/issues/12415) - Not all shortcuts are displayed in the preferences table ([PR 12514](https://github.com/spyder-ide/spyder/pull/12514) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12410](https://github.com/spyder-ide/spyder/issues/12410) - Check handling of str responses in Kite client signals ([PR 12435](https://github.com/spyder-ide/spyder/pull/12435) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12400](https://github.com/spyder-ide/spyder/issues/12400) - Console won't close ([PR 12448](https://github.com/spyder-ide/spyder/pull/12448) by [@steff456](https://github.com/steff456))
* [Issue 12396](https://github.com/spyder-ide/spyder/issues/12396) - KeyError when renaming file in the editor ([PR 12508](https://github.com/spyder-ide/spyder/pull/12508) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 12373](https://github.com/spyder-ide/spyder/issues/12373) - Code analysis not updated after Backspace ([PR 12374](https://github.com/spyder-ide/spyder/pull/12374) by [@andfoy](https://github.com/andfoy))
* [Issue 12357](https://github.com/spyder-ide/spyder/issues/12357) - Error with kite when using work vpn ([PR 12364](https://github.com/spyder-ide/spyder/pull/12364) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12321](https://github.com/spyder-ide/spyder/issues/12321) - Code analysis markers are not positioned correctly when code is folded ([PR 12452](https://github.com/spyder-ide/spyder/pull/12452) by [@steff456](https://github.com/steff456))
* [Issue 12313](https://github.com/spyder-ide/spyder/issues/12313) - Spyder is opening bootstrap.py when using "python bootstrap.py" ([PR 12314](https://github.com/spyder-ide/spyder/pull/12314) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12296](https://github.com/spyder-ide/spyder/issues/12296) - "TypeError: 'bool' object is not callable" in dataframe viewer ([PR 12342](https://github.com/spyder-ide/spyder/pull/12342) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12287](https://github.com/spyder-ide/spyder/issues/12287) - TypeError when switching to plain text mode in Help for an object with no help ([PR 12308](https://github.com/spyder-ide/spyder/pull/12308) by [@steff456](https://github.com/steff456))
* [Issue 12280](https://github.com/spyder-ide/spyder/issues/12280) - Error when clearing variables in the Variable Explorer ([PR 12363](https://github.com/spyder-ide/spyder/pull/12363) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12253](https://github.com/spyder-ide/spyder/issues/12253) - ZeroDivisionError when trying to show a plot ([PR 12455](https://github.com/spyder-ide/spyder/pull/12455) by [@steff456](https://github.com/steff456))
* [Issue 12244](https://github.com/spyder-ide/spyder/issues/12244) - Something broke recently with windows CI ([PR 11066](https://github.com/spyder-ide/spyder/pull/11066) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12215](https://github.com/spyder-ide/spyder/issues/12215) - View variable explorer supported objects in the object explorer ([PR 12260](https://github.com/spyder-ide/spyder/pull/12260) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12210](https://github.com/spyder-ide/spyder/issues/12210) - Save console output generates errors
* [Issue 12201](https://github.com/spyder-ide/spyder/issues/12201) - Problem when closing a project ([PR 12439](https://github.com/spyder-ide/spyder/pull/12439) by [@dalthviz](https://github.com/dalthviz))
* [Issue 12179](https://github.com/spyder-ide/spyder/issues/12179) - Shortcuts table loads whatever is saved on the shortcuts section ([PR 12177](https://github.com/spyder-ide/spyder/pull/12177) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12168](https://github.com/spyder-ide/spyder/issues/12168) - Shortcuts on tips not adapted to platform ([PR 12169](https://github.com/spyder-ide/spyder/pull/12169) by [@goanpeca](https://github.com/goanpeca))
* [Issue 12154](https://github.com/spyder-ide/spyder/issues/12154) - White brackets in the Obsidian theme ([PR 12270](https://github.com/spyder-ide/spyder/pull/12270) by [@juanis2112](https://github.com/juanis2112))
* [Issue 12139](https://github.com/spyder-ide/spyder/issues/12139) - If main window is closed with undocked panes, those are not shown during the next session ([PR 12294](https://github.com/spyder-ide/spyder/pull/12294) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12102](https://github.com/spyder-ide/spyder/issues/12102) - Namespace is not set correctly while debugging ([PR 12117](https://github.com/spyder-ide/spyder/pull/12117) by [@impact27](https://github.com/impact27))
* [Issue 12034](https://github.com/spyder-ide/spyder/issues/12034) - NameError: free variable 'self' referenced before assignment in Variable Explorer ([PR 12109](https://github.com/spyder-ide/spyder/pull/12109) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11986](https://github.com/spyder-ide/spyder/issues/11986) - "Directly enter debugging when errors appear" is not working ([PR 12148](https://github.com/spyder-ide/spyder/pull/12148) by [@impact27](https://github.com/impact27))
* [Issue 11961](https://github.com/spyder-ide/spyder/issues/11961) - Duplicate line down has changed behavior with Duplicate line up
* [Issue 11953](https://github.com/spyder-ide/spyder/issues/11953) - "TypeError: not enough arguments for format string" when starting Spyder in Portuguese
* [Issue 11930](https://github.com/spyder-ide/spyder/issues/11930) - Tests are fragile ([PR 11066](https://github.com/spyder-ide/spyder/pull/11066) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11923](https://github.com/spyder-ide/spyder/issues/11923) - Run in console's namespace with existing kernel not working ([PR 12436](https://github.com/spyder-ide/spyder/pull/12436) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11919](https://github.com/spyder-ide/spyder/issues/11919) - An issue with the "File Association" example in the settings ([PR 12093](https://github.com/spyder-ide/spyder/pull/12093) by [@steff456](https://github.com/steff456))
* [Issue 11880](https://github.com/spyder-ide/spyder/issues/11880) - Spyder doesn't start in Python 3.8 ([PR 12178](https://github.com/spyder-ide/spyder/pull/12178) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11875](https://github.com/spyder-ide/spyder/issues/11875) - Profiler crash in Spyder 4.1.0 ([PR 12094](https://github.com/spyder-ide/spyder/pull/12094) by [@steff456](https://github.com/steff456))
* [Issue 11870](https://github.com/spyder-ide/spyder/issues/11870) - test_mainwindow incorrectly picks up pytest arguments ([PR 11704](https://github.com/spyder-ide/spyder/pull/11704) by [@CAM-Gerlach](https://github.com/CAM-Gerlach))
* [Issue 11790](https://github.com/spyder-ide/spyder/issues/11790) - ZeroDivisionError when viewing dataframes ([PR 12341](https://github.com/spyder-ide/spyder/pull/12341) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11698](https://github.com/spyder-ide/spyder/issues/11698) - Go to previous cursor position not working ([PR 12114](https://github.com/spyder-ide/spyder/pull/12114) by [@steff456](https://github.com/steff456))
* [Issue 11235](https://github.com/spyder-ide/spyder/issues/11235) - TypeError when starting Kite client ([PR 12364](https://github.com/spyder-ide/spyder/pull/12364) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11152](https://github.com/spyder-ide/spyder/issues/11152) - pyls-mypy messages are not displayed correctly in some cases ([PR 12519](https://github.com/spyder-ide/spyder/pull/12519) by [@steff456](https://github.com/steff456))
* [Issue 10148](https://github.com/spyder-ide/spyder/issues/10148) - Editor unindents when typing : ([PR 12055](https://github.com/spyder-ide/spyder/pull/12055) by [@remisalmon](https://github.com/remisalmon))
* [Issue 10124](https://github.com/spyder-ide/spyder/issues/10124) - Explain CodeEditor's parameters within the doctring ([PR 12290](https://github.com/spyder-ide/spyder/pull/12290) by [@Akashtyagi08](https://github.com/Akashtyagi08))
* [Issue 9696](https://github.com/spyder-ide/spyder/issues/9696) - Online Help pane doesn't support the dark theme ([PR 11893](https://github.com/spyder-ide/spyder/pull/11893) by [@dalthviz](https://github.com/dalthviz))
* [Issue 7831](https://github.com/spyder-ide/spyder/issues/7831) - Inconsistent behavior with creating/saving files with default names ([PR 12359](https://github.com/spyder-ide/spyder/pull/12359) by [@steff456](https://github.com/steff456))

In this release 46 issues were closed.

### Pull Requests Merged

* [PR 12632](https://github.com/spyder-ide/spyder/pull/12632) - PR: Update minimal required version of spyder-kernels to 1.9.1, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12629](https://github.com/spyder-ide/spyder/pull/12629) - PR: Update translations for 4.1.3, by [@spyder-bot](https://github.com/spyder-bot)
* [PR 12618](https://github.com/spyder-ide/spyder/pull/12618) - PR: Update translation file strings, by [@goanpeca](https://github.com/goanpeca)
* [PR 12613](https://github.com/spyder-ide/spyder/pull/12613) - PR: Invert duplicate line down and up behaviour, by [@jnsebgosselin](https://github.com/jnsebgosselin)
* [PR 12606](https://github.com/spyder-ide/spyder/pull/12606) - PR: Hide tooltip and calltip widgets when window is not active, by [@ccordoba12](https://github.com/ccordoba12) ([12477](https://github.com/spyder-ide/spyder/issues/12477))
* [PR 12590](https://github.com/spyder-ide/spyder/pull/12590) - PR: Update check-manifest ignore rules to work with its 0.42 version, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12580](https://github.com/spyder-ide/spyder/pull/12580) - PR: Install Pylint 2.4 in our CIs, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12569](https://github.com/spyder-ide/spyder/pull/12569) - PR: Fix color constrast in Solarized themes, by [@grantcarthew](https://github.com/grantcarthew)
* [PR 12549](https://github.com/spyder-ide/spyder/pull/12549) - PR: More improvements to Online Help, by [@dalthviz](https://github.com/dalthviz)
* [PR 12526](https://github.com/spyder-ide/spyder/pull/12526) - PR: A couple of fixes for the python-language-server subrepo, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12519](https://github.com/spyder-ide/spyder/pull/12519) - PR: Correctly display messages from the pyls-mypy plugin, by [@steff456](https://github.com/steff456) ([11152](https://github.com/spyder-ide/spyder/issues/11152))
* [PR 12518](https://github.com/spyder-ide/spyder/pull/12518) - PR: Fix segfault on Unix systems when removing plots, by [@goanpeca](https://github.com/goanpeca) ([12459](https://github.com/spyder-ide/spyder/issues/12459))
* [PR 12516](https://github.com/spyder-ide/spyder/pull/12516) - PR: Handle error when checking if Kite is already running, by [@dalthviz](https://github.com/dalthviz) ([12510](https://github.com/spyder-ide/spyder/issues/12510))
* [PR 12514](https://github.com/spyder-ide/spyder/pull/12514) - PR: Fix missing shortcuts on Preferences, by [@goanpeca](https://github.com/goanpeca) ([12415](https://github.com/spyder-ide/spyder/issues/12415))
* [PR 12513](https://github.com/spyder-ide/spyder/pull/12513) - PR: Update test_run_static_code_analysis for the latest Pylint version, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12508](https://github.com/spyder-ide/spyder/pull/12508) - PR: Handle KeyError when processing rename in autosave, by [@jitseniesen](https://github.com/jitseniesen) ([12396](https://github.com/spyder-ide/spyder/issues/12396))
* [PR 12467](https://github.com/spyder-ide/spyder/pull/12467) - PR: Encode and store UTF-8 files by default, by [@andfoy](https://github.com/andfoy) ([12416](https://github.com/spyder-ide/spyder/issues/12416))
* [PR 12458](https://github.com/spyder-ide/spyder/pull/12458) - PR: Change convention and refactor icons on the code analysis pane, by [@juanis2112](https://github.com/juanis2112)
* [PR 12455](https://github.com/spyder-ide/spyder/pull/12455) - PR: Add broken icon in the Plots pane if the figure is corrupted, by [@steff456](https://github.com/steff456) ([12253](https://github.com/spyder-ide/spyder/issues/12253))
* [PR 12453](https://github.com/spyder-ide/spyder/pull/12453) - PR: Fix unstable completions when using backspace, by [@steff456](https://github.com/steff456) ([12417](https://github.com/spyder-ide/spyder/issues/12417))
* [PR 12452](https://github.com/spyder-ide/spyder/pull/12452) - PR: Code analysis and debug markers correctly positioned when code is folded, by [@steff456](https://github.com/steff456) ([12321](https://github.com/spyder-ide/spyder/issues/12321))
* [PR 12448](https://github.com/spyder-ide/spyder/pull/12448) - PR: Catch AttributeError when closing a console, by [@steff456](https://github.com/steff456) ([12400](https://github.com/spyder-ide/spyder/issues/12400))
* [PR 12445](https://github.com/spyder-ide/spyder/pull/12445) - PR: Remove warning message when undocking panes, by [@goanpeca](https://github.com/goanpeca)
* [PR 12439](https://github.com/spyder-ide/spyder/pull/12439) - PR: Add validation for current line values when loading files (Editor), by [@dalthviz](https://github.com/dalthviz) ([12201](https://github.com/spyder-ide/spyder/issues/12201))
* [PR 12436](https://github.com/spyder-ide/spyder/pull/12436) - PR: Use runfile for external spyder-kernels, by [@dalthviz](https://github.com/dalthviz) ([11923](https://github.com/spyder-ide/spyder/issues/11923))
* [PR 12435](https://github.com/spyder-ide/spyder/pull/12435) - PR: Add support for a string response when getting Kite available languages, by [@dalthviz](https://github.com/dalthviz) ([12410](https://github.com/spyder-ide/spyder/issues/12410))
* [PR 12432](https://github.com/spyder-ide/spyder/pull/12432) - PR: Link the Contributing guide on our Readme to tell people how to run Spyder from a clone, by [@ccordoba12](https://github.com/ccordoba12) ([12424](https://github.com/spyder-ide/spyder/issues/12424))
* [PR 12389](https://github.com/spyder-ide/spyder/pull/12389) - PR: Add a git subrepo for the python-language-server, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12376](https://github.com/spyder-ide/spyder/pull/12376) - PR: Make test_get_git_refs work when merging against 4.x, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 12374](https://github.com/spyder-ide/spyder/pull/12374) - PR: Trigger documentDidChange on backspace, by [@andfoy](https://github.com/andfoy) ([12373](https://github.com/spyder-ide/spyder/issues/12373))
* [PR 12364](https://github.com/spyder-ide/spyder/pull/12364) - PR: Handle string status responses in Kite due to VPN errors, by [@dalthviz](https://github.com/dalthviz) ([12357](https://github.com/spyder-ide/spyder/issues/12357), [11235](https://github.com/spyder-ide/spyder/issues/11235))
* [PR 12363](https://github.com/spyder-ide/spyder/pull/12363) - PR: Make refresh namespacebrowser an interrupt call (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([12280](https://github.com/spyder-ide/spyder/issues/12280))
* [PR 12362](https://github.com/spyder-ide/spyder/pull/12362) - PR: Fix the same font in Preferences and update action icons (Online Help), by [@dalthviz](https://github.com/dalthviz)
* [PR 12359](https://github.com/spyder-ide/spyder/pull/12359) - PR: Fix inconsistent behavior when creating/saving files with default names, by [@steff456](https://github.com/steff456) ([7831](https://github.com/spyder-ide/spyder/issues/7831))
* [PR 12342](https://github.com/spyder-ide/spyder/pull/12342) - PR: Use def instead of lambda to define slots for data conversion (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([12296](https://github.com/spyder-ide/spyder/issues/12296))
* [PR 12341](https://github.com/spyder-ide/spyder/pull/12341) - PR: Validate column max/min difference (Variable Explorer), by [@dalthviz](https://github.com/dalthviz) ([11790](https://github.com/spyder-ide/spyder/issues/11790))
* [PR 12314](https://github.com/spyder-ide/spyder/pull/12314) - PR: Don't pass sys.argv to get_options if not running tests, by [@ccordoba12](https://github.com/ccordoba12) ([12313](https://github.com/spyder-ide/spyder/issues/12313))
* [PR 12308](https://github.com/spyder-ide/spyder/pull/12308) - PR: Fix TypeError in the Help plugin in plain text mode, by [@steff456](https://github.com/steff456) ([12287](https://github.com/spyder-ide/spyder/issues/12287))
* [PR 12297](https://github.com/spyder-ide/spyder/pull/12297) - PR: Only cancel previous builds on pull_request events, by [@goanpeca](https://github.com/goanpeca)
* [PR 12294](https://github.com/spyder-ide/spyder/pull/12294) - PR: Save main window settings after plugin windows are closed, by [@ccordoba12](https://github.com/ccordoba12) ([12139](https://github.com/spyder-ide/spyder/issues/12139))
* [PR 12290](https://github.com/spyder-ide/spyder/pull/12290) - PR: Add docstring to explain CodeEditor parameters, by [@Akashtyagi08](https://github.com/Akashtyagi08) ([10124](https://github.com/spyder-ide/spyder/issues/10124))
* [PR 12286](https://github.com/spyder-ide/spyder/pull/12286) - PR: Emit sig_editor_shown for objects that can be edited inline in the Variable Explorer, by [@juanis2112](https://github.com/juanis2112)
* [PR 12283](https://github.com/spyder-ide/spyder/pull/12283) - PR: Update README build badges, by [@goanpeca](https://github.com/goanpeca)
* [PR 12281](https://github.com/spyder-ide/spyder/pull/12281) - PR: Add skip to builds plus check for skipping if PRs do not change Python files, by [@goanpeca](https://github.com/goanpeca)
* [PR 12270](https://github.com/spyder-ide/spyder/pull/12270) - PR: Change color of matched brackets in some of the dark highlighting themes, by [@juanis2112](https://github.com/juanis2112) ([12154](https://github.com/spyder-ide/spyder/issues/12154))
* [PR 12260](https://github.com/spyder-ide/spyder/pull/12260) - PR: Remove restriction to populate object attributes in the Object Explorer, by [@dalthviz](https://github.com/dalthviz) ([12215](https://github.com/spyder-ide/spyder/issues/12215))
* [PR 12256](https://github.com/spyder-ide/spyder/pull/12256) - PR: Enable status check for stdio LSP servers, by [@andfoy](https://github.com/andfoy)
* [PR 12234](https://github.com/spyder-ide/spyder/pull/12234) - PR: Fix file tests for shortcuts, by [@goanpeca](https://github.com/goanpeca)
* [PR 12227](https://github.com/spyder-ide/spyder/pull/12227) - PR: Fix running fast tests locally on macOS, by [@goanpeca](https://github.com/goanpeca)
* [PR 12181](https://github.com/spyder-ide/spyder/pull/12181) - PR: Move dock attributes from plugin to dockwidget, by [@goanpeca](https://github.com/goanpeca)
* [PR 12178](https://github.com/spyder-ide/spyder/pull/12178) - PR: Patch asyncio to start Spyder with Python 3.8 on Windows, by [@dalthviz](https://github.com/dalthviz) ([11880](https://github.com/spyder-ide/spyder/issues/11880))
* [PR 12177](https://github.com/spyder-ide/spyder/pull/12177) - PR: Register actions without shortcuts and only display registered actions, by [@goanpeca](https://github.com/goanpeca) ([12179](https://github.com/spyder-ide/spyder/issues/12179))
* [PR 12169](https://github.com/spyder-ide/spyder/pull/12169) - PR: Display correct shortcut string on tooltips, by [@goanpeca](https://github.com/goanpeca) ([12168](https://github.com/spyder-ide/spyder/issues/12168))
* [PR 12148](https://github.com/spyder-ide/spyder/pull/12148) - PR: Add a test for post mortem functionality in the console, by [@impact27](https://github.com/impact27) ([11986](https://github.com/spyder-ide/spyder/issues/11986))
* [PR 12140](https://github.com/spyder-ide/spyder/pull/12140) - PR: Fix completion hiding when within function or comprehension., by [@ElieGouzien](https://github.com/ElieGouzien)
* [PR 12119](https://github.com/spyder-ide/spyder/pull/12119) - PR: Fix links to PyQt5 docs, by [@StefRe](https://github.com/StefRe)
* [PR 12117](https://github.com/spyder-ide/spyder/pull/12117) - PR: Test that we set the namespace correctly while debugging, by [@impact27](https://github.com/impact27) ([12102](https://github.com/spyder-ide/spyder/issues/12102))
* [PR 12114](https://github.com/spyder-ide/spyder/pull/12114) - PR: Fix go to previous/next cursor position , by [@steff456](https://github.com/steff456) ([11698](https://github.com/spyder-ide/spyder/issues/11698))
* [PR 12109](https://github.com/spyder-ide/spyder/pull/12109) - PR: Catch NameError when trying to load more data in the dataframe and array viewers, by [@dalthviz](https://github.com/dalthviz) ([12034](https://github.com/spyder-ide/spyder/issues/12034))
* [PR 12094](https://github.com/spyder-ide/spyder/pull/12094) - PR: Remove size parameter in TextEditor constructor call, by [@steff456](https://github.com/steff456) ([11875](https://github.com/spyder-ide/spyder/issues/11875))
* [PR 12093](https://github.com/spyder-ide/spyder/pull/12093) - PR: Fix file association dialog example in settings, by [@steff456](https://github.com/steff456) ([11919](https://github.com/spyder-ide/spyder/issues/11919))
* [PR 12055](https://github.com/spyder-ide/spyder/pull/12055) - PR: Correctly unindent code for valid Python, by [@remisalmon](https://github.com/remisalmon) ([10148](https://github.com/spyder-ide/spyder/issues/10148))
* [PR 11893](https://github.com/spyder-ide/spyder/pull/11893) - PR: Use custom CSS when serving docs for the Online Help, by [@dalthviz](https://github.com/dalthviz) ([9696](https://github.com/spyder-ide/spyder/issues/9696))
* [PR 11704](https://github.com/spyder-ide/spyder/pull/11704) - PR: Fix issues parsing runtests.py args and passing them properly to Spyder and Pytest, by [@CAM-Gerlach](https://github.com/CAM-Gerlach) ([11870](https://github.com/spyder-ide/spyder/issues/11870))
* [PR 11066](https://github.com/spyder-ide/spyder/pull/11066) - PR: Use github actions to run all our tests, by [@goanpeca](https://github.com/goanpeca) ([12244](https://github.com/spyder-ide/spyder/issues/12244), [11930](https://github.com/spyder-ide/spyder/issues/11930))

In this release 65 pull requests were closed.


---


## Version 4.1.2 (2020-04-03)

### New features

* Add a new entry to the status bar to show the current state of the Python
  language server. This will allow users to know if completions, linting and
  folding are working as expected or have issues. Clicking on this entry will
  also show a menu from which is possible to restart the server manually.

### Important fixes

* Completely disable warning informing to restart Spyder when a screen
  resolution is detected on macOS.
* Show an error message when it's not possible to create a special console
  for Sympy, Cython or Pylab.
* Restore code folding for all files with less than 2000 lines.
* Fix showing help for dot objects (e.g. `np.sin`) in the IPython console.
* Fix showing kernel initialization error messages on Windows.

### Issues Closed

* [Issue 12091](https://github.com/spyder-ide/spyder/issues/12091) - Update translations for 4.1.2 ([PR 11825](https://github.com/spyder-ide/spyder/pull/11825) by [@spyder-bot](https://github.com/spyder-bot))
* [Issue 12052](https://github.com/spyder-ide/spyder/issues/12052) - TypeError when trying to view output of Code Analysis pane ([PR 12053](https://github.com/spyder-ide/spyder/pull/12053) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 12026](https://github.com/spyder-ide/spyder/issues/12026) - Segmentation fault while painting flags ([PR 12036](https://github.com/spyder-ide/spyder/pull/12036) by [@impact27](https://github.com/impact27))
* [Issue 12024](https://github.com/spyder-ide/spyder/issues/12024) - Unable to save file to mapped network drive on Windows 7 ([PR 12050](https://github.com/spyder-ide/spyder/pull/12050) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11997](https://github.com/spyder-ide/spyder/issues/11997) - RuntimeError when disconnecting monitors ([PR 12008](https://github.com/spyder-ide/spyder/pull/12008) by [@steff456](https://github.com/steff456))
* [Issue 11988](https://github.com/spyder-ide/spyder/issues/11988) - OSError when importing Numpy in Object Explorer  ([PR 12003](https://github.com/spyder-ide/spyder/pull/12003) by [@steff456](https://github.com/steff456))
* [Issue 11963](https://github.com/spyder-ide/spyder/issues/11963) - Error when trying to delete two or more variables ([PR 11968](https://github.com/spyder-ide/spyder/pull/11968) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11903](https://github.com/spyder-ide/spyder/issues/11903) - TypeError when changing monitors ([PR 11937](https://github.com/spyder-ide/spyder/pull/11937) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11885](https://github.com/spyder-ide/spyder/issues/11885) - test_arrayeditor.py::test_arrayeditor_with_inf_array fails because of deprecation warning (Py3.8) ([PR 11899](https://github.com/spyder-ide/spyder/pull/11899) by [@bnavigator](https://github.com/bnavigator))
* [Issue 11872](https://github.com/spyder-ide/spyder/issues/11872) - psutil.NoSuchProcess when restarting the kernel ([PR 11910](https://github.com/spyder-ide/spyder/pull/11910) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11869](https://github.com/spyder-ide/spyder/issues/11869) - Code folding disabled w/ <2000 lines (4.1.1) ([PR 11888](https://github.com/spyder-ide/spyder/pull/11888) by [@steff456](https://github.com/steff456))
* [Issue 11862](https://github.com/spyder-ide/spyder/issues/11862) - IndexError: string index out of range in fallback plugin ([PR 12077](https://github.com/spyder-ide/spyder/pull/12077) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11846](https://github.com/spyder-ide/spyder/issues/11846) - Popup "A monitor scale change was detected" every few minutes ([PR 11884](https://github.com/spyder-ide/spyder/pull/11884) by [@steff456](https://github.com/steff456))
* [Issue 11821](https://github.com/spyder-ide/spyder/issues/11821) - Completion doc widget and editor/console to help improvements ([PR 11826](https://github.com/spyder-ide/spyder/pull/11826) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11622](https://github.com/spyder-ide/spyder/issues/11622) - UI enhancements to the Variable Explorer ([PR 11814](https://github.com/spyder-ide/spyder/pull/11814) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11026](https://github.com/spyder-ide/spyder/issues/11026) - Code completion and linting stop working during the current session ([PR 12020](https://github.com/spyder-ide/spyder/pull/12020) by [@goanpeca](https://github.com/goanpeca))

In this release 16 issues were closed.

### Pull Requests Merged

* [PR 12083](https://github.com/spyder-ide/spyder/pull/12083) - PR: Update translation files, by [@goanpeca](https://github.com/goanpeca)
* [PR 12077](https://github.com/spyder-ide/spyder/pull/12077) - PR: Prevent error when checking if prefix is valid in fallback with utf-16 characters, by [@ccordoba12](https://github.com/ccordoba12) ([11862](https://github.com/spyder-ide/spyder/issues/11862))
* [PR 12053](https://github.com/spyder-ide/spyder/pull/12053) - PR: Fix error when showing Pylint output, by [@ccordoba12](https://github.com/ccordoba12) ([12052](https://github.com/spyder-ide/spyder/issues/12052))
* [PR 12050](https://github.com/spyder-ide/spyder/pull/12050) - PR: Add validation for path existence before writing to filename, by [@dalthviz](https://github.com/dalthviz) ([12024](https://github.com/spyder-ide/spyder/issues/12024))
* [PR 12043](https://github.com/spyder-ide/spyder/pull/12043) - PR: Fix typo in Windows executable filename extensions, by [@StefRe](https://github.com/StefRe)
* [PR 12036](https://github.com/spyder-ide/spyder/pull/12036) - PR: Avoid segfault when painting flags after removing lines, by [@impact27](https://github.com/impact27) ([12026](https://github.com/spyder-ide/spyder/issues/12026))
* [PR 12020](https://github.com/spyder-ide/spyder/pull/12020) - PR: Add autorestart mechanism for LSP servers and status widget with menu to restart them manually, by [@goanpeca](https://github.com/goanpeca) ([11026](https://github.com/spyder-ide/spyder/issues/11026))
* [PR 12008](https://github.com/spyder-ide/spyder/pull/12008) - PR: Catch RuntimeError to prevent errors when disconnecting monitors, by [@steff456](https://github.com/steff456) ([11997](https://github.com/spyder-ide/spyder/issues/11997))
* [PR 12003](https://github.com/spyder-ide/spyder/pull/12003) - PR: Fix OSError when importing Numpy in Object Explorer, by [@steff456](https://github.com/steff456) ([11988](https://github.com/spyder-ide/spyder/issues/11988))
* [PR 11991](https://github.com/spyder-ide/spyder/pull/11991) - PR: Check if block is valid before painting it in the scrollflag panel, by [@impact27](https://github.com/impact27)
* [PR 11982](https://github.com/spyder-ide/spyder/pull/11982) - PR: Make a string translatable, by [@bnavigator](https://github.com/bnavigator)
* [PR 11968](https://github.com/spyder-ide/spyder/pull/11968) - PR: Set data only one time after multiple removes, by [@dalthviz](https://github.com/dalthviz) ([11963](https://github.com/spyder-ide/spyder/issues/11963))
* [PR 11937](https://github.com/spyder-ide/spyder/pull/11937) - PR: Catch TypeError when handling screen change, by [@dalthviz](https://github.com/dalthviz) ([11903](https://github.com/spyder-ide/spyder/issues/11903))
* [PR 11910](https://github.com/spyder-ide/spyder/pull/11910) - PR: Fix error when restarting the kernel and restore showing kernel errors on Windows, by [@ccordoba12](https://github.com/ccordoba12) ([11872](https://github.com/spyder-ide/spyder/issues/11872))
* [PR 11899](https://github.com/spyder-ide/spyder/pull/11899) - PR: Fix deprecation warnings, by [@bnavigator](https://github.com/bnavigator) ([11885](https://github.com/spyder-ide/spyder/issues/11885))
* [PR 11888](https://github.com/spyder-ide/spyder/pull/11888) - PR: Activate code folding when the panel is not visible, by [@steff456](https://github.com/steff456) ([11869](https://github.com/spyder-ide/spyder/issues/11869))
* [PR 11886](https://github.com/spyder-ide/spyder/pull/11886) - PR: Fix tests in Azure/macOS, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11884](https://github.com/spyder-ide/spyder/pull/11884) - PR: Disable screen resolution change message in macOS and allow to hide it during the current session, by [@steff456](https://github.com/steff456) ([11846](https://github.com/spyder-ide/spyder/issues/11846))
* [PR 11826](https://github.com/spyder-ide/spyder/pull/11826) - PR: Fix getting help from the console for dot objects and remove redundant info from completion hints, by [@dalthviz](https://github.com/dalthviz) ([11821](https://github.com/spyder-ide/spyder/issues/11821))
* [PR 11825](https://github.com/spyder-ide/spyder/pull/11825) - PR: New translations for 4.1.2, by [@spyder-bot](https://github.com/spyder-bot) ([12091](https://github.com/spyder-ide/spyder/issues/12091))
* [PR 11824](https://github.com/spyder-ide/spyder/pull/11824) - PR: Correctly hide already complete word in completion widget, by [@ElieGouzien](https://github.com/ElieGouzien)
* [PR 11814](https://github.com/spyder-ide/spyder/pull/11814) - PR: Add loading indicator for the Variable Explorer, by [@dalthviz](https://github.com/dalthviz) ([11622](https://github.com/spyder-ide/spyder/issues/11622))
* [PR 11365](https://github.com/spyder-ide/spyder/pull/11365) - PR: Detect unavailable dependencies for special consoles, by [@dalthviz](https://github.com/dalthviz)

In this release 23 pull requests were closed.


----


## Version 4.1.1 (2020-03-18)

### New features

* Add file path completions to the Editor. This works by writing the
  beginning of a file path, either absolute or relative, inside a
  string and pressing `Tab` or `Ctrl+Space` to get completions for
  it.
* Add a new command line option called `--report-segfault` to be
  able to send segmentation fault reports to Github.

### Important fixes

* Fix a critical error when starting kernels on Windows.
* Update Jedi to 0.15.2.
* Add conda activation scripts for the kernel to the package.

### Issues Closed

* [Issue 11851](https://github.com/spyder-ide/spyder/issues/11851) - TimeoutError: Timeout while waiting for comm port ([PR 11853](https://github.com/spyder-ide/spyder/pull/11853) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11819](https://github.com/spyder-ide/spyder/issues/11819) - Activation of kernel env fails when using anaconda shortcut (FileNotFound error kernel start 4.1.0) ([PR 11838](https://github.com/spyder-ide/spyder/pull/11838) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11634](https://github.com/spyder-ide/spyder/issues/11634) - Error when importing CSV  file from  Variable tab  ([PR 11812](https://github.com/spyder-ide/spyder/pull/11812) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11150](https://github.com/spyder-ide/spyder/issues/11150) - Unable to load docstring into "Help" pane for functions with certain decorators ([PR 11809](https://github.com/spyder-ide/spyder/pull/11809) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 10536](https://github.com/spyder-ide/spyder/issues/10536) - Send segmentation fault reports to Github ([PR 10553](https://github.com/spyder-ide/spyder/pull/10553) by [@impact27](https://github.com/impact27))
* [Issue 5519](https://github.com/spyder-ide/spyder/issues/5519) - Add path autocompletion to the Editor

In this release 6 issues were closed.

### Pull Requests Merged

* [PR 11854](https://github.com/spyder-ide/spyder/pull/11854) - PR: Update minimal required version for the PyLS, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11853](https://github.com/spyder-ide/spyder/pull/11853) - PR: Increase time to detect if kernel is alive and to receive the comm config, by [@ccordoba12](https://github.com/ccordoba12) ([11851](https://github.com/spyder-ide/spyder/issues/11851))
* [PR 11841](https://github.com/spyder-ide/spyder/pull/11841) - PR: Install the right version of jupyter_client for Python 2 in our CIs, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11838](https://github.com/spyder-ide/spyder/pull/11838) - PR: Add conda activation scripts to the package, by [@ccordoba12](https://github.com/ccordoba12) ([11819](https://github.com/spyder-ide/spyder/issues/11819))
* [PR 11812](https://github.com/spyder-ide/spyder/pull/11812) - PR: Fix validation for import as ndarray/array, by [@dalthviz](https://github.com/dalthviz) ([11634](https://github.com/spyder-ide/spyder/issues/11634))
* [PR 11809](https://github.com/spyder-ide/spyder/pull/11809) - PR: Update Jedi requirement to 0.15.2, by [@ccordoba12](https://github.com/ccordoba12) ([11150](https://github.com/spyder-ide/spyder/issues/11150))
* [PR 11807](https://github.com/spyder-ide/spyder/pull/11807) - PR: Restore rtree to the conda deps, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 10553](https://github.com/spyder-ide/spyder/pull/10553) - PR: Allow to report segmentation faults to Github, by [@impact27](https://github.com/impact27) ([10536](https://github.com/spyder-ide/spyder/issues/10536))

In this release 8 pull requests were closed.


----


## Version 4.1.0 (2020-03-15)

### New features

* Several improvements to the interface and user experience of the Plots pane.
* Show hidden files in Files and Project panes.
* Allow automatic introduction of docstrings in the Sphinx format.
* Implicitly create a project when Spyder is launched with a folder path as
  argument in the command line
* Activate conda environment prior to kernel start in the IPython console.
* Re-add the ability to run IPython magics inside of cells.
* Allow running PyQt applications multiple times.
* Make adjustable the maximum number of recent projects in the Projects
  menu.

### Important fixes

* Disable code folding and indent guides when files have more than 2000 lines
  for performance reasons.
* Critical performance improvements to the Editor and Files.
* Several fixes to the autosave mechanism.
* Preserve creation time when saving files.
* Don't corrupt symlinks when saving files associated to them.
* Improve the code completion experience in the Editor.
* Start kernels in a thread to avoid freezing the entire interface.
* Correctly update the debugging panel in the Editor when debugging in
  multiple consoles.
* Make the Code Analysis pane to read the nearest pylintrc file, according to
  the hierarchy defined by Pylint.

### Issues Closed

* [Issue 11765](https://github.com/spyder-ide/spyder/issues/11765) - Highlighting does not work for terminal-style completions in the iPython console ([PR 11766](https://github.com/spyder-ide/spyder/pull/11766) by [@keepiru](https://github.com/keepiru))
* [Issue 11731](https://github.com/spyder-ide/spyder/issues/11731) - Update translations for 4.1 ([PR 11772](https://github.com/spyder-ide/spyder/pull/11772) by [@spyder-bot](https://github.com/spyder-bot))
* [Issue 11718](https://github.com/spyder-ide/spyder/issues/11718) - Symbolic and hard links "broken" when saving files ([PR 11722](https://github.com/spyder-ide/spyder/pull/11722) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11692](https://github.com/spyder-ide/spyder/issues/11692) - Crowdin translations are outdated ([PR 11711](https://github.com/spyder-ide/spyder/pull/11711) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11671](https://github.com/spyder-ide/spyder/issues/11671) - No code folding at startup ([PR 11681](https://github.com/spyder-ide/spyder/pull/11681) by [@andfoy](https://github.com/andfoy))
* [Issue 11652](https://github.com/spyder-ide/spyder/issues/11652) - Facing error when trying to open spyder tutorial ([PR 11762](https://github.com/spyder-ide/spyder/pull/11762) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11630](https://github.com/spyder-ide/spyder/issues/11630) - Cell shortcut remap not sticking on macOS ([PR 11661](https://github.com/spyder-ide/spyder/pull/11661) by [@steff456](https://github.com/steff456))
* [Issue 11625](https://github.com/spyder-ide/spyder/issues/11625) - Code completion is added when indenting code ([PR 11650](https://github.com/spyder-ide/spyder/pull/11650) by [@andfoy](https://github.com/andfoy))
* [Issue 11609](https://github.com/spyder-ide/spyder/issues/11609) - UnicodeEncodeError in save_autosave_mapping ([PR 11619](https://github.com/spyder-ide/spyder/pull/11619) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 11600](https://github.com/spyder-ide/spyder/issues/11600) - Auto-completion should not complete already complete words ([PR 11732](https://github.com/spyder-ide/spyder/pull/11732) by [@steff456](https://github.com/steff456))
* [Issue 11597](https://github.com/spyder-ide/spyder/issues/11597) - Spyder not launching when Kite installation is faulty ([PR 11602](https://github.com/spyder-ide/spyder/pull/11602) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11596](https://github.com/spyder-ide/spyder/issues/11596) - Variable of npz file cannot be read if namespace has the same name ([PR 11628](https://github.com/spyder-ide/spyder/pull/11628) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11591](https://github.com/spyder-ide/spyder/issues/11591) - Options for different modes of documentation are not available when the Help Pane is undocked.  ([PR 11593](https://github.com/spyder-ide/spyder/pull/11593) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11586](https://github.com/spyder-ide/spyder/issues/11586) - spyder --defaults raises TypeError ([PR 11587](https://github.com/spyder-ide/spyder/pull/11587) by [@steff456](https://github.com/steff456))
* [Issue 11579](https://github.com/spyder-ide/spyder/issues/11579) - Help is not displaying single-line docstrings ([PR 11672](https://github.com/spyder-ide/spyder/pull/11672) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11546](https://github.com/spyder-ide/spyder/issues/11546) - test_goto_uri hangs when not run from git repository ([PR 11547](https://github.com/spyder-ide/spyder/pull/11547) by [@bnavigator](https://github.com/bnavigator))
* [Issue 11539](https://github.com/spyder-ide/spyder/issues/11539) - Unable to restart Spyder: FileNotFoundError - 'external-deps' ([PR 11541](https://github.com/spyder-ide/spyder/pull/11541) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11532](https://github.com/spyder-ide/spyder/issues/11532) - Crash when trying to run a Python file in a project from the explorer pane - Spyder 4.0.1 ([PR 11533](https://github.com/spyder-ide/spyder/pull/11533) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11526](https://github.com/spyder-ide/spyder/issues/11526) - Autocomplete dict error ([PR 11592](https://github.com/spyder-ide/spyder/pull/11592) by [@andfoy](https://github.com/andfoy))
* [Issue 11514](https://github.com/spyder-ide/spyder/issues/11514) - Error when changing the Python interpreter to Python 2 ([PR 11540](https://github.com/spyder-ide/spyder/pull/11540) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11503](https://github.com/spyder-ide/spyder/issues/11503) - "Maintain focus ..." option has no effect in Spyder4 ([PR 11554](https://github.com/spyder-ide/spyder/pull/11554) by [@steff456](https://github.com/steff456))
* [Issue 11502](https://github.com/spyder-ide/spyder/issues/11502) - Unintuitive behavior: Mouse wheel scrolling in editor steals keyboard focus ([PR 11530](https://github.com/spyder-ide/spyder/pull/11530) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11497](https://github.com/spyder-ide/spyder/issues/11497) - Spyder 4 cannot launch when Kite is installed ([PR 11517](https://github.com/spyder-ide/spyder/pull/11517) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11495](https://github.com/spyder-ide/spyder/issues/11495) - Flags are misaligned when scrolling if code is folded ([PR 11488](https://github.com/spyder-ide/spyder/pull/11488) by [@impact27](https://github.com/impact27))
* [Issue 11493](https://github.com/spyder-ide/spyder/issues/11493) - Make fallback completions respect prefix ([PR 11531](https://github.com/spyder-ide/spyder/pull/11531) by [@andfoy](https://github.com/andfoy))
* [Issue 11489](https://github.com/spyder-ide/spyder/issues/11489) - Copy file reference in variable explorer generates PicklingError ([PR 11574](https://github.com/spyder-ide/spyder/pull/11574) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11477](https://github.com/spyder-ide/spyder/issues/11477) - Imports hang after debugging (Spyder 4) ([PR 11479](https://github.com/spyder-ide/spyder/pull/11479) by [@impact27](https://github.com/impact27))
* [Issue 11471](https://github.com/spyder-ide/spyder/issues/11471) - Cannot open objects in variable explorer ([PR 11549](https://github.com/spyder-ide/spyder/pull/11549) by [@impact27](https://github.com/impact27))
* [Issue 11468](https://github.com/spyder-ide/spyder/issues/11468) - Another KeyError while autosaving ([PR 11647](https://github.com/spyder-ide/spyder/pull/11647) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 11464](https://github.com/spyder-ide/spyder/issues/11464) - Error when renaming file in the open files dialog  ([PR 11627](https://github.com/spyder-ide/spyder/pull/11627) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11455](https://github.com/spyder-ide/spyder/issues/11455) - Unable to delete multiple variables in Variable Explorer ([PR 11567](https://github.com/spyder-ide/spyder/pull/11567) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11435](https://github.com/spyder-ide/spyder/issues/11435) - Add sphinx/reStructuredText docstrings ([PR 11460](https://github.com/spyder-ide/spyder/pull/11460) by [@ok97465](https://github.com/ok97465))
* [Issue 11417](https://github.com/spyder-ide/spyder/issues/11417) - Signature calltip doesn't work without automatic bracket completion (Kite example) ([PR 11422](https://github.com/spyder-ide/spyder/pull/11422) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11412](https://github.com/spyder-ide/spyder/issues/11412) - Spyder 4.0.1 editing *really* laggy ([PR 11488](https://github.com/spyder-ide/spyder/pull/11488) by [@impact27](https://github.com/impact27))
* [Issue 11406](https://github.com/spyder-ide/spyder/issues/11406) - Kernel dies silently and doesn't restart properly. ([PR 11192](https://github.com/spyder-ide/spyder/pull/11192) by [@impact27](https://github.com/impact27))
* [Issue 11403](https://github.com/spyder-ide/spyder/issues/11403) - Spyder 4 is not preserving files creation time ([PR 11443](https://github.com/spyder-ide/spyder/pull/11443) by [@andfoy](https://github.com/andfoy))
* [Issue 11399](https://github.com/spyder-ide/spyder/issues/11399) - Snippets do not display when the text starts by underscore ([PR 11400](https://github.com/spyder-ide/spyder/pull/11400) by [@andfoy](https://github.com/andfoy))
* [Issue 11376](https://github.com/spyder-ide/spyder/issues/11376) - Infinite loop when "gl-N" (with a single digit) appears in multiline docstring ([PR 11378](https://github.com/spyder-ide/spyder/pull/11378) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11375](https://github.com/spyder-ide/spyder/issues/11375) - Corrupt autosave files don't get reset ([PR 11608](https://github.com/spyder-ide/spyder/pull/11608) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 11370](https://github.com/spyder-ide/spyder/issues/11370) - Issue reporter due to disconnected network drive after wakeup ([PR 11473](https://github.com/spyder-ide/spyder/pull/11473) by [@andfoy](https://github.com/andfoy))
* [Issue 11363](https://github.com/spyder-ide/spyder/issues/11363) - Implicitly create project when launched with a folder path as argument ([PR 11416](https://github.com/spyder-ide/spyder/pull/11416) by [@akdor1154](https://github.com/akdor1154))
* [Issue 11358](https://github.com/spyder-ide/spyder/issues/11358) - Don't restart automatically Spyder when a monitor scale change is detected ([PR 11359](https://github.com/spyder-ide/spyder/pull/11359) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11355](https://github.com/spyder-ide/spyder/issues/11355) - Editor: wrong tooltip position when undocking ([PR 11361](https://github.com/spyder-ide/spyder/pull/11361) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11351](https://github.com/spyder-ide/spyder/issues/11351) - Spyder showing Kite: unsupported on status bar ([PR 11449](https://github.com/spyder-ide/spyder/pull/11449) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11348](https://github.com/spyder-ide/spyder/issues/11348) - Renaming a python file in the file explorer causes an error ([PR 11505](https://github.com/spyder-ide/spyder/pull/11505) by [@jitseniesen](https://github.com/jitseniesen))
* [Issue 11346](https://github.com/spyder-ide/spyder/issues/11346) - Don't show "No documentation available" tooltip on hover ([PR 11377](https://github.com/spyder-ide/spyder/pull/11377) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11331](https://github.com/spyder-ide/spyder/issues/11331) - Numpy arrays not writable ([PR 11555](https://github.com/spyder-ide/spyder/pull/11555) by [@steff456](https://github.com/steff456))
* [Issue 11318](https://github.com/spyder-ide/spyder/issues/11318) - Add external plugins to dependencies ([PR 11364](https://github.com/spyder-ide/spyder/pull/11364) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11308](https://github.com/spyder-ide/spyder/issues/11308) - Spyder 4.0.1: Error when saving file to network drive (but saving worked) ([PR 11465](https://github.com/spyder-ide/spyder/pull/11465) by [@andfoy](https://github.com/andfoy))
* [Issue 11293](https://github.com/spyder-ide/spyder/issues/11293) - AltGr closes completion widget ([PR 11321](https://github.com/spyder-ide/spyder/pull/11321) by [@MaxGyver83](https://github.com/MaxGyver83))
* [Issue 11291](https://github.com/spyder-ide/spyder/issues/11291) - KeyError in folding when deleting a line ([PR 11310](https://github.com/spyder-ide/spyder/pull/11310) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11267](https://github.com/spyder-ide/spyder/issues/11267) - Improvements to the Help panel ([PR 11272](https://github.com/spyder-ide/spyder/pull/11272) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11258](https://github.com/spyder-ide/spyder/issues/11258) - Replace text is always enabled even for read-only plugins. ([PR 11259](https://github.com/spyder-ide/spyder/pull/11259) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 11247](https://github.com/spyder-ide/spyder/issues/11247) - Opening a folder with a lot of binary files freezes Spyder ([PR 11248](https://github.com/spyder-ide/spyder/pull/11248) by [@impact27](https://github.com/impact27))
* [Issue 11244](https://github.com/spyder-ide/spyder/issues/11244) - Tooltip doesn't disappear if generated on first line of editor ([PR 11271](https://github.com/spyder-ide/spyder/pull/11271) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11240](https://github.com/spyder-ide/spyder/issues/11240) - Spyder crashes at startup after setting custom high DPI scaling at less than 1.0 ([PR 11254](https://github.com/spyder-ide/spyder/pull/11254) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11237](https://github.com/spyder-ide/spyder/issues/11237) - code autocomplete inserts extra characters ([PR 11400](https://github.com/spyder-ide/spyder/pull/11400) by [@andfoy](https://github.com/andfoy))
* [Issue 11228](https://github.com/spyder-ide/spyder/issues/11228) - TypeError when disconnecting sig_display_object_info signal ([PR 11241](https://github.com/spyder-ide/spyder/pull/11241) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11227](https://github.com/spyder-ide/spyder/issues/11227) - set_options_opengl is called too late ([PR 11585](https://github.com/spyder-ide/spyder/pull/11585) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11226](https://github.com/spyder-ide/spyder/issues/11226) - AttributeError in dockwidgets tabbar ([PR 11239](https://github.com/spyder-ide/spyder/pull/11239) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11222](https://github.com/spyder-ide/spyder/issues/11222) - PyLS freezes spyder ([PR 11223](https://github.com/spyder-ide/spyder/pull/11223) by [@impact27](https://github.com/impact27))
* [Issue 11217](https://github.com/spyder-ide/spyder/issues/11217) - Extra closing parenthesis added after new line ([PR 11256](https://github.com/spyder-ide/spyder/pull/11256) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11216](https://github.com/spyder-ide/spyder/issues/11216) - Loadmat internal error in variable explorer ([PR 11238](https://github.com/spyder-ide/spyder/pull/11238) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11148](https://github.com/spyder-ide/spyder/issues/11148) - Commenting lines that include the first one in a file freezes Spyder ([PR 11212](https://github.com/spyder-ide/spyder/pull/11212) by [@impact27](https://github.com/impact27))
* [Issue 11137](https://github.com/spyder-ide/spyder/issues/11137) - TimeoutError when running cells after a kernel restart ([PR 11192](https://github.com/spyder-ide/spyder/pull/11192) by [@impact27](https://github.com/impact27))
* [Issue 11129](https://github.com/spyder-ide/spyder/issues/11129) - Variable explorer shows DatetimeIndex with numpy datetime64 format instead of timestamp ([PR 11210](https://github.com/spyder-ide/spyder/pull/11210) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11128](https://github.com/spyder-ide/spyder/issues/11128) - Indentation level is not reset when writing a comment after indent within a long instruction ([PR 11334](https://github.com/spyder-ide/spyder/pull/11334) by [@impact27](https://github.com/impact27))
* [Issue 11092](https://github.com/spyder-ide/spyder/issues/11092) - Copy line and duplicate line shortcuts are confusing ([PR 11122](https://github.com/spyder-ide/spyder/pull/11122) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 11082](https://github.com/spyder-ide/spyder/issues/11082) - Hitting esc requests code completions ([PR 11328](https://github.com/spyder-ide/spyder/pull/11328) by [@goanpeca](https://github.com/goanpeca))
* [Issue 11061](https://github.com/spyder-ide/spyder/issues/11061) - IPython magics no longer work in Spyder 4 ([PR 11103](https://github.com/spyder-ide/spyder/pull/11103) by [@impact27](https://github.com/impact27))
* [Issue 11024](https://github.com/spyder-ide/spyder/issues/11024) - Spyder 4.0.0 gives an error when restarting it in Python 2.7 ([PR 11219](https://github.com/spyder-ide/spyder/pull/11219) by [@dalthviz](https://github.com/dalthviz))
* [Issue 11023](https://github.com/spyder-ide/spyder/issues/11023) - Unexpected indent when running a single cell
* [Issue 11021](https://github.com/spyder-ide/spyder/issues/11021) - Autocomplete triggered by Ctrl + Enter ([PR 11745](https://github.com/spyder-ide/spyder/pull/11745) by [@ccordoba12](https://github.com/ccordoba12))
* [Issue 11001](https://github.com/spyder-ide/spyder/issues/11001) - KeyError when removing variables in the Variable Explorer ([PR 11567](https://github.com/spyder-ide/spyder/pull/11567) by [@dalthviz](https://github.com/dalthviz))
* [Issue 10971](https://github.com/spyder-ide/spyder/issues/10971) - Crashing in kite_tutorial.py ([PR 11287](https://github.com/spyder-ide/spyder/pull/11287) by [@dalthviz](https://github.com/dalthviz))
* [Issue 10911](https://github.com/spyder-ide/spyder/issues/10911) - Change theme settings in external plugins is not possible ([PR 11389](https://github.com/spyder-ide/spyder/pull/11389) by [@steff456](https://github.com/steff456))
* [Issue 10883](https://github.com/spyder-ide/spyder/issues/10883) - Show hidden files in the project explorer ([PR 11545](https://github.com/spyder-ide/spyder/pull/11545) by [@goanpeca](https://github.com/goanpeca))
* [Issue 10864](https://github.com/spyder-ide/spyder/issues/10864) - Date/time-based filename (when saving) for figures on Plots pane ([PR 11690](https://github.com/spyder-ide/spyder/pull/11690) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 10863](https://github.com/spyder-ide/spyder/issues/10863) - Plots should remember last saved path ([PR 11670](https://github.com/spyder-ide/spyder/pull/11670) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 10798](https://github.com/spyder-ide/spyder/issues/10798) - Completions sometimes insert extraneous text ([PR 11437](https://github.com/spyder-ide/spyder/pull/11437) by [@ok97465](https://github.com/ok97465))
* [Issue 10785](https://github.com/spyder-ide/spyder/issues/10785) - Can't change dir to network drive in console ([PR 11393](https://github.com/spyder-ide/spyder/pull/11393) by [@dalthviz](https://github.com/dalthviz))
* [Issue 10745](https://github.com/spyder-ide/spyder/issues/10745) - Variable explorer viewers too small on high DPI ([PR 10976](https://github.com/spyder-ide/spyder/pull/10976) by [@jsh9](https://github.com/jsh9))
* [Issue 10704](https://github.com/spyder-ide/spyder/issues/10704) - Segmentation fault when closing an undocked plugin ([PR 11472](https://github.com/spyder-ide/spyder/pull/11472) by [@impact27](https://github.com/impact27))
* [Issue 10657](https://github.com/spyder-ide/spyder/issues/10657) - Saving a protected file hangs Spyder ([PR 11764](https://github.com/spyder-ide/spyder/pull/11764) by [@steff456](https://github.com/steff456))
* [Issue 10640](https://github.com/spyder-ide/spyder/issues/10640) - Increase or make adjustable the maximum number of Recent Projects ([PR 10801](https://github.com/spyder-ide/spyder/pull/10801) by [@juanis2112](https://github.com/juanis2112))
* [Issue 10627](https://github.com/spyder-ide/spyder/issues/10627) - Variable explorer shortcuts not updated after configuration change ([PR 11441](https://github.com/spyder-ide/spyder/pull/11441) by [@dalthviz](https://github.com/dalthviz))
* [Issue 10538](https://github.com/spyder-ide/spyder/issues/10538) - Debugging improvements ([PR 10610](https://github.com/spyder-ide/spyder/pull/10610) by [@dalthviz](https://github.com/dalthviz))
* [Issue 9888](https://github.com/spyder-ide/spyder/issues/9888) - Missing space when rendering NumPy docstrings ([PR 11270](https://github.com/spyder-ide/spyder/pull/11270) by [@dalthviz](https://github.com/dalthviz))
* [Issue 9367](https://github.com/spyder-ide/spyder/issues/9367) - Some issues with the Plot viewer ([PR 11576](https://github.com/spyder-ide/spyder/pull/11576) by [@jnsebgosselin](https://github.com/jnsebgosselin))
* [Issue 9077](https://github.com/spyder-ide/spyder/issues/9077) - Compiled modules of non-default interpreters fail to import on Windows ([PR 11327](https://github.com/spyder-ide/spyder/pull/11327) by [@goanpeca](https://github.com/goanpeca))
* [Issue 7699](https://github.com/spyder-ide/spyder/issues/7699) - Unusual characters break help ([PR 11332](https://github.com/spyder-ide/spyder/pull/11332) by [@dalthviz](https://github.com/dalthviz))
* [Issue 6695](https://github.com/spyder-ide/spyder/issues/6695) - Cannot plot local varibles in variable explorer when debugging
* [Issue 6181](https://github.com/spyder-ide/spyder/issues/6181) - Code completion window too small on high resolution screens ([PR 11322](https://github.com/spyder-ide/spyder/pull/11322) by [@dalthviz](https://github.com/dalthviz))
* [Issue 5345](https://github.com/spyder-ide/spyder/issues/5345) - Static Code Analysis Not Reading .pylintrc file ([PR 11708](https://github.com/spyder-ide/spyder/pull/11708) by [@CAM-Gerlach](https://github.com/CAM-Gerlach))
* [Issue 2970](https://github.com/spyder-ide/spyder/issues/2970) - PyQt code cannot run twice
* [Issue 1918](https://github.com/spyder-ide/spyder/issues/1918) - `__file__` continues in namespace after runfile if ctrl-c

In this release 96 issues were closed.

### Pull Requests Merged

* [PR 11801](https://github.com/spyder-ide/spyder/pull/11801) - PR: Disable Polish translation, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11800](https://github.com/spyder-ide/spyder/pull/11800) - PR: Update version constraints for spyder-kernels, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11793](https://github.com/spyder-ide/spyder/pull/11793) - PR: Update spyder-kernels subrepo, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11772](https://github.com/spyder-ide/spyder/pull/11772) - PR: Update translations, by [@spyder-bot](https://github.com/spyder-bot) ([11731](https://github.com/spyder-ide/spyder/issues/11731))
* [PR 11770](https://github.com/spyder-ide/spyder/pull/11770) - PR: Remove line wrap from po files, by [@goanpeca](https://github.com/goanpeca)
* [PR 11766](https://github.com/spyder-ide/spyder/pull/11766) - PR: Fix broken completions highlighting in the IPython console, by [@keepiru](https://github.com/keepiru) ([11765](https://github.com/spyder-ide/spyder/issues/11765))
* [PR 11764](https://github.com/spyder-ide/spyder/pull/11764) - PR: Fix saving protected files on Windows by checking if they are read-only, by [@steff456](https://github.com/steff456) ([10657](https://github.com/spyder-ide/spyder/issues/10657))
* [PR 11762](https://github.com/spyder-ide/spyder/pull/11762) - PR: Use the same temp base dir for Sphinx config, src and build paths, by [@dalthviz](https://github.com/dalthviz) ([11652](https://github.com/spyder-ide/spyder/issues/11652))
* [PR 11755](https://github.com/spyder-ide/spyder/pull/11755) - PR: Some improvements to fallback completions, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11746](https://github.com/spyder-ide/spyder/pull/11746) - PR: Fix highlighting based on Pygments, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11745](https://github.com/spyder-ide/spyder/pull/11745) - PR: Only ask for completions when text is generated after pressing a key in the Editor, by [@ccordoba12](https://github.com/ccordoba12) ([11021](https://github.com/spyder-ide/spyder/issues/11021))
* [PR 11739](https://github.com/spyder-ide/spyder/pull/11739) - PR: Add API entry for translation utilities, by [@goanpeca](https://github.com/goanpeca)
* [PR 11732](https://github.com/spyder-ide/spyder/pull/11732) - PR: Do not include complete words as part of completion suggestions, by [@steff456](https://github.com/steff456) ([11600](https://github.com/spyder-ide/spyder/issues/11600))
* [PR 11722](https://github.com/spyder-ide/spyder/pull/11722) - PR: Use resolved path (without symlinks) to save files, by [@dalthviz](https://github.com/dalthviz) ([11718](https://github.com/spyder-ide/spyder/issues/11718))
* [PR 11715](https://github.com/spyder-ide/spyder/pull/11715) - PR: Disable code folding when files are too long and add an option to disable code folding, by [@andfoy](https://github.com/andfoy)
* [PR 11714](https://github.com/spyder-ide/spyder/pull/11714) - PR: Fix issues with autocompletion characters and prevent whitespace from triggering completions, by [@andfoy](https://github.com/andfoy)
* [PR 11713](https://github.com/spyder-ide/spyder/pull/11713) - PR: Fix translations, by [@goanpeca](https://github.com/goanpeca)
* [PR 11711](https://github.com/spyder-ide/spyder/pull/11711) - PR: Update translation files, by [@goanpeca](https://github.com/goanpeca) ([11692](https://github.com/spyder-ide/spyder/issues/11692))
* [PR 11708](https://github.com/spyder-ide/spyder/pull/11708) - PR: Make pylint plugin find most local .pylintrc to given file and set cwd correctly, by [@CAM-Gerlach](https://github.com/CAM-Gerlach) ([5345](https://github.com/spyder-ide/spyder/issues/5345))
* [PR 11690](https://github.com/spyder-ide/spyder/pull/11690) - PR: Date/time-based filename (when saving) figures in Plots pane, by [@jnsebgosselin](https://github.com/jnsebgosselin) ([10864](https://github.com/spyder-ide/spyder/issues/10864))
* [PR 11684](https://github.com/spyder-ide/spyder/pull/11684) - PR: Give focus to Plots pane when switching to it by shortcut if it's visible, by [@ok97465](https://github.com/ok97465)
* [PR 11681](https://github.com/spyder-ide/spyder/pull/11681) - PR: Prevent code folding from not being called on startup, by [@andfoy](https://github.com/andfoy) ([11671](https://github.com/spyder-ide/spyder/issues/11671))
* [PR 11672](https://github.com/spyder-ide/spyder/pull/11672) - PR: Fix hover endpoint for Kite on Windows and allow docs without signature in Help, by [@dalthviz](https://github.com/dalthviz) ([11579](https://github.com/spyder-ide/spyder/issues/11579))
* [PR 11670](https://github.com/spyder-ide/spyder/pull/11670) - PR: Remember last saved path in Plots pane, by [@jnsebgosselin](https://github.com/jnsebgosselin) ([10863](https://github.com/spyder-ide/spyder/issues/10863))
* [PR 11664](https://github.com/spyder-ide/spyder/pull/11664) - PR: Remove highlight on key release event, by [@goanpeca](https://github.com/goanpeca)
* [PR 11661](https://github.com/spyder-ide/spyder/pull/11661) - PR: Use register_shortcut for a successful remap of cell shortcuts, by [@steff456](https://github.com/steff456) ([11630](https://github.com/spyder-ide/spyder/issues/11630))
* [PR 11656](https://github.com/spyder-ide/spyder/pull/11656) - PR: Fix test_conda_env_activation, by [@goanpeca](https://github.com/goanpeca)
* [PR 11650](https://github.com/spyder-ide/spyder/pull/11650) - PR: Prevent Tab/Backtab from triggering completions, by [@andfoy](https://github.com/andfoy) ([11625](https://github.com/spyder-ide/spyder/issues/11625))
* [PR 11647](https://github.com/spyder-ide/spyder/pull/11647) - PR: Fix KeyError on autosave, by [@jitseniesen](https://github.com/jitseniesen) ([11468](https://github.com/spyder-ide/spyder/issues/11468))
* [PR 11628](https://github.com/spyder-ide/spyder/pull/11628) - PR: Handle loading data from NpzFile instances and add an override flag to the load, by [@dalthviz](https://github.com/dalthviz) ([11596](https://github.com/spyder-ide/spyder/issues/11596))
* [PR 11627](https://github.com/spyder-ide/spyder/pull/11627) - PR: Validation for tab indexes when refreshing the Editor, by [@dalthviz](https://github.com/dalthviz) ([11464](https://github.com/spyder-ide/spyder/issues/11464))
* [PR 11626](https://github.com/spyder-ide/spyder/pull/11626) - PR: Skip some tests that are failing or timing out too much, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11619](https://github.com/spyder-ide/spyder/pull/11619) - PR: Convert autosave mapping to ASCII before saving, by [@jitseniesen](https://github.com/jitseniesen) ([11609](https://github.com/spyder-ide/spyder/issues/11609))
* [PR 11608](https://github.com/spyder-ide/spyder/pull/11608) - PR: Handle corrupted pid files in autosave component, by [@jitseniesen](https://github.com/jitseniesen) ([11375](https://github.com/spyder-ide/spyder/issues/11375))
* [PR 11602](https://github.com/spyder-ide/spyder/pull/11602) - PR: Add handling for faulty Kite installations, by [@dalthviz](https://github.com/dalthviz) ([11597](https://github.com/spyder-ide/spyder/issues/11597))
* [PR 11593](https://github.com/spyder-ide/spyder/pull/11593) - PR: Ensure Help pane actions are enabled after being undocked, by [@dalthviz](https://github.com/dalthviz) ([11591](https://github.com/spyder-ide/spyder/issues/11591))
* [PR 11592](https://github.com/spyder-ide/spyder/pull/11592) - PR: Handle TextEdit correctly when receiving completions, by [@andfoy](https://github.com/andfoy) ([11526](https://github.com/spyder-ide/spyder/issues/11526))
* [PR 11590](https://github.com/spyder-ide/spyder/pull/11590) - PR: Fix running tests locally from file, by [@jnsebgosselin](https://github.com/jnsebgosselin)
* [PR 11587](https://github.com/spyder-ide/spyder/pull/11587) - PR: Fix TypeError in `spyder --defaults`, by [@steff456](https://github.com/steff456) ([11586](https://github.com/spyder-ide/spyder/issues/11586))
* [PR 11585](https://github.com/spyder-ide/spyder/pull/11585) - PR: Set OpenGL backend before the QApplication is created, by [@ccordoba12](https://github.com/ccordoba12) ([11227](https://github.com/spyder-ide/spyder/issues/11227))
* [PR 11576](https://github.com/spyder-ide/spyder/pull/11576) - PR: UX and UI Improvements to the Plots pane, by [@jnsebgosselin](https://github.com/jnsebgosselin) ([9367](https://github.com/spyder-ide/spyder/issues/9367))
* [PR 11574](https://github.com/spyder-ide/spyder/pull/11574) - PR: Add handling for PicklingError when getting values from the kernel, by [@dalthviz](https://github.com/dalthviz) ([11489](https://github.com/spyder-ide/spyder/issues/11489))
* [PR 11567](https://github.com/spyder-ide/spyder/pull/11567) - PR: Reset source model from parent after setting data (Variable explorer), by [@dalthviz](https://github.com/dalthviz) ([11455](https://github.com/spyder-ide/spyder/issues/11455), [11001](https://github.com/spyder-ide/spyder/issues/11001))
* [PR 11555](https://github.com/spyder-ide/spyder/pull/11555) - PR: Change variable explorer title for NumPy object arrays, by [@steff456](https://github.com/steff456) ([11331](https://github.com/spyder-ide/spyder/issues/11331))
* [PR 11554](https://github.com/spyder-ide/spyder/pull/11554) - PR: Fix focus to the editor given the focus_to_editor option, by [@steff456](https://github.com/steff456) ([11503](https://github.com/spyder-ide/spyder/issues/11503))
* [PR 11549](https://github.com/spyder-ide/spyder/pull/11549) - PR: Remove usage of load_exception in KernelComm and fix importing spyder-kernels subrepo, by [@impact27](https://github.com/impact27) ([11471](https://github.com/spyder-ide/spyder/issues/11471))
* [PR 11548](https://github.com/spyder-ide/spyder/pull/11548) - PR: Only run git tests when in a git repo, by [@bnavigator](https://github.com/bnavigator)
* [PR 11547](https://github.com/spyder-ide/spyder/pull/11547) - PR: Fix hanging test when not in git repository, by [@bnavigator](https://github.com/bnavigator) ([11546](https://github.com/spyder-ide/spyder/issues/11546))
* [PR 11545](https://github.com/spyder-ide/spyder/pull/11545) - PR: Show hidden files in explorer and project explorer, by [@goanpeca](https://github.com/goanpeca) ([10883](https://github.com/spyder-ide/spyder/issues/10883))
* [PR 11544](https://github.com/spyder-ide/spyder/pull/11544) - PR: Add debug calls for 3rd party plugin loading, by [@goanpeca](https://github.com/goanpeca)
* [PR 11541](https://github.com/spyder-ide/spyder/pull/11541) - PR: Fix restarting Spyder when it was started using bootstrap.py, by [@ccordoba12](https://github.com/ccordoba12) ([11539](https://github.com/spyder-ide/spyder/issues/11539))
* [PR 11540](https://github.com/spyder-ide/spyder/pull/11540) - PR: Update Chinese translation text to use the correct % character, by [@dalthviz](https://github.com/dalthviz) ([11514](https://github.com/spyder-ide/spyder/issues/11514))
* [PR 11533](https://github.com/spyder-ide/spyder/pull/11533) - PR: Add console_namespace positional arg (set to False) when calling Run in an Explorer widget, by [@dalthviz](https://github.com/dalthviz) ([11532](https://github.com/spyder-ide/spyder/issues/11532))
* [PR 11531](https://github.com/spyder-ide/spyder/pull/11531) - PR: Prevent fallback to output completions when the prefix is invalid, by [@andfoy](https://github.com/andfoy) ([11493](https://github.com/spyder-ide/spyder/issues/11493))
* [PR 11530](https://github.com/spyder-ide/spyder/pull/11530) - PR: Prevent editor stealing focus of other widgets while scrolling, by [@dalthviz](https://github.com/dalthviz) ([11502](https://github.com/spyder-ide/spyder/issues/11502))
* [PR 11517](https://github.com/spyder-ide/spyder/pull/11517) - PR: Update psutil dependency constraint and add checks for dependency integrity, by [@goanpeca](https://github.com/goanpeca) ([11497](https://github.com/spyder-ide/spyder/issues/11497))
* [PR 11505](https://github.com/spyder-ide/spyder/pull/11505) - PR: Handle file renamed in the explorer correctly in the editor, by [@jitseniesen](https://github.com/jitseniesen) ([11348](https://github.com/spyder-ide/spyder/issues/11348))
* [PR 11498](https://github.com/spyder-ide/spyder/pull/11498) - PR: Add Polish translation, by [@wojnilowicz](https://github.com/wojnilowicz)
* [PR 11488](https://github.com/spyder-ide/spyder/pull/11488) - PR: Optimise keyPressEvent in the editor, by [@impact27](https://github.com/impact27) ([11495](https://github.com/spyder-ide/spyder/issues/11495), [11412](https://github.com/spyder-ide/spyder/issues/11412))
* [PR 11479](https://github.com/spyder-ide/spyder/pull/11479) - PR: Fix errors when restarting the kernel while in debugging, by [@impact27](https://github.com/impact27) ([11477](https://github.com/spyder-ide/spyder/issues/11477))
* [PR 11478](https://github.com/spyder-ide/spyder/pull/11478) - PR: Improve formatting of Contributing guide, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11476](https://github.com/spyder-ide/spyder/pull/11476) - PR: Pin parso to 0.5.2 because version 0.6.0 is incompatible with Jedi 0.14, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11473](https://github.com/spyder-ide/spyder/pull/11473) - PR: Monkeypatch watchdog's main dispatcher to prevent network failures, by [@andfoy](https://github.com/andfoy) ([11370](https://github.com/spyder-ide/spyder/issues/11370))
* [PR 11472](https://github.com/spyder-ide/spyder/pull/11472) - PR: Avoid Python destroying Qt window and causing segfault, by [@impact27](https://github.com/impact27) ([10704](https://github.com/spyder-ide/spyder/issues/10704))
* [PR 11465](https://github.com/spyder-ide/spyder/pull/11465) - PR: Prevent operation not permitted errors when writing to samba shares, by [@andfoy](https://github.com/andfoy) ([11308](https://github.com/spyder-ide/spyder/issues/11308))
* [PR 11462](https://github.com/spyder-ide/spyder/pull/11462) - PR: Add debug logger calls for dragEnterEvent in the Editor, by [@dalthviz](https://github.com/dalthviz)
* [PR 11460](https://github.com/spyder-ide/spyder/pull/11460) - PR: Add automatic introduction of docstrings in Sphinx format, by [@ok97465](https://github.com/ok97465) ([11435](https://github.com/spyder-ide/spyder/issues/11435))
* [PR 11449](https://github.com/spyder-ide/spyder/pull/11449) - PR: Encode url parameters before sending requests to Kite, by [@dalthviz](https://github.com/dalthviz) ([11351](https://github.com/spyder-ide/spyder/issues/11351))
* [PR 11443](https://github.com/spyder-ide/spyder/pull/11443) - PR: Preserve creation time when performing an atomic_write, by [@andfoy](https://github.com/andfoy) ([11403](https://github.com/spyder-ide/spyder/issues/11403))
* [PR 11441](https://github.com/spyder-ide/spyder/pull/11441) - PR: Properly register shortcuts for some actions of the Variable Explorer, by [@dalthviz](https://github.com/dalthviz) ([10627](https://github.com/spyder-ide/spyder/issues/10627))
* [PR 11437](https://github.com/spyder-ide/spyder/pull/11437) - PR: Display the latest result of requested completions, by [@ok97465](https://github.com/ok97465) ([10798](https://github.com/spyder-ide/spyder/issues/10798))
* [PR 11422](https://github.com/spyder-ide/spyder/pull/11422) - PR: Enable signature request without automatic bracket completion, by [@dalthviz](https://github.com/dalthviz) ([11417](https://github.com/spyder-ide/spyder/issues/11417))
* [PR 11416](https://github.com/spyder-ide/spyder/pull/11416) - PR: Interpret -p project argument relative to the directory of invocation, by [@akdor1154](https://github.com/akdor1154) ([11363](https://github.com/spyder-ide/spyder/issues/11363))
* [PR 11415](https://github.com/spyder-ide/spyder/pull/11415) - PR: Fix some spelling errors, by [@hjung4](https://github.com/hjung4)
* [PR 11400](https://github.com/spyder-ide/spyder/pull/11400) - PR: Prevent underscore prefixed snippets to be omitted, by [@andfoy](https://github.com/andfoy) ([11399](https://github.com/spyder-ide/spyder/issues/11399), [11237](https://github.com/spyder-ide/spyder/issues/11237))
* [PR 11395](https://github.com/spyder-ide/spyder/pull/11395) - PR: Handle screen change to trigger restart and prevent display issues, by [@dalthviz](https://github.com/dalthviz)
* [PR 11393](https://github.com/spyder-ide/spyder/pull/11393) - PR: Use normpath to set network folders as cwd on Windows, by [@dalthviz](https://github.com/dalthviz) ([10785](https://github.com/spyder-ide/spyder/issues/10785))
* [PR 11389](https://github.com/spyder-ide/spyder/pull/11389) - PR: Add support for third party plugins to react to color scheme changes, by [@steff456](https://github.com/steff456) ([10911](https://github.com/spyder-ide/spyder/issues/10911))
* [PR 11378](https://github.com/spyder-ide/spyder/pull/11378) - PR: Fix infinite loop with issue shorthand within comments, by [@goanpeca](https://github.com/goanpeca) ([11376](https://github.com/spyder-ide/spyder/issues/11376))
* [PR 11377](https://github.com/spyder-ide/spyder/pull/11377) - PR: Add check to prevent hover with no docs, by [@goanpeca](https://github.com/goanpeca) ([11346](https://github.com/spyder-ide/spyder/issues/11346))
* [PR 11364](https://github.com/spyder-ide/spyder/pull/11364) - PR: Include plugins in dependencies dialog, by [@goanpeca](https://github.com/goanpeca) ([11318](https://github.com/spyder-ide/spyder/issues/11318))
* [PR 11361](https://github.com/spyder-ide/spyder/pull/11361) - PR: Fix tooltip position after the editor is undocked, by [@dalthviz](https://github.com/dalthviz) ([11355](https://github.com/spyder-ide/spyder/issues/11355))
* [PR 11359](https://github.com/spyder-ide/spyder/pull/11359) - PR: Make scale restart optional, by [@dalthviz](https://github.com/dalthviz) ([11358](https://github.com/spyder-ide/spyder/issues/11358))
* [PR 11350](https://github.com/spyder-ide/spyder/pull/11350) - PR: Add a git subrepo for spyder-kernels, by [@ccordoba12](https://github.com/ccordoba12)
* [PR 11334](https://github.com/spyder-ide/spyder/pull/11334) - PR: Fix several indentation cases, by [@impact27](https://github.com/impact27) ([11128](https://github.com/spyder-ide/spyder/issues/11128))
* [PR 11332](https://github.com/spyder-ide/spyder/pull/11332) - PR: Get current word to inspect current object from the IPython console, by [@dalthviz](https://github.com/dalthviz) ([7699](https://github.com/spyder-ide/spyder/issues/7699))
* [PR 11329](https://github.com/spyder-ide/spyder/pull/11329) - PR: Remove "The send queue is full! Retrying..." when LSP is not initialised, by [@impact27](https://github.com/impact27)
* [PR 11328](https://github.com/spyder-ide/spyder/pull/11328) - PR: Add escape key to completion ignore keys, by [@goanpeca](https://github.com/goanpeca) ([11082](https://github.com/spyder-ide/spyder/issues/11082))
* [PR 11327](https://github.com/spyder-ide/spyder/pull/11327) - PR: Activate conda environment prior to kernel start, by [@goanpeca](https://github.com/goanpeca) ([9077](https://github.com/spyder-ide/spyder/issues/9077), [89](https://github.com/spyder-ide/spyder-kernels/issues/89))
* [PR 11322](https://github.com/spyder-ide/spyder/pull/11322) - PR: Add a restart message when a monitor scale change is detected, by [@dalthviz](https://github.com/dalthviz) ([6181](https://github.com/spyder-ide/spyder/issues/6181))
* [PR 11321](https://github.com/spyder-ide/spyder/pull/11321) - PR: Don't close autocompletion menu when AltGr is pressed, by [@MaxGyver83](https://github.com/MaxGyver83) ([11293](https://github.com/spyder-ide/spyder/issues/11293))
* [PR 11317](https://github.com/spyder-ide/spyder/pull/11317) - PR: Finalise kernel shutdown in a thread, by [@impact27](https://github.com/impact27) ([197](https://github.com/spyder-ide/spyder-kernels/issues/197))
* [PR 11310](https://github.com/spyder-ide/spyder/pull/11310) - PR: Catch KeyError when trying to highlight folding region, by [@ccordoba12](https://github.com/ccordoba12) ([11291](https://github.com/spyder-ide/spyder/issues/11291))
* [PR 11287](https://github.com/spyder-ide/spyder/pull/11287) - PR: Fix snippets completion with a single token in placeholder, by [@dalthviz](https://github.com/dalthviz) ([10971](https://github.com/spyder-ide/spyder/issues/10971))
* [PR 11272](https://github.com/spyder-ide/spyder/pull/11272) - PR: Improvements to the Help pane (style, loading page and some other issues), by [@dalthviz](https://github.com/dalthviz) ([11267](https://github.com/spyder-ide/spyder/issues/11267))
* [PR 11271](https://github.com/spyder-ide/spyder/pull/11271) - PR: Hide tooltip when the window is blocked, by [@dalthviz](https://github.com/dalthviz) ([11244](https://github.com/spyder-ide/spyder/issues/11244))
* [PR 11270](https://github.com/spyder-ide/spyder/pull/11270) - PR: Add css to style parameters in the Help pane when using Sphinx >=2, by [@dalthviz](https://github.com/dalthviz) ([9888](https://github.com/spyder-ide/spyder/issues/9888))
* [PR 11259](https://github.com/spyder-ide/spyder/pull/11259) - PR: Do not show replace widget when it is not enabled, by [@jnsebgosselin](https://github.com/jnsebgosselin) ([11258](https://github.com/spyder-ide/spyder/issues/11258))
* [PR 11256](https://github.com/spyder-ide/spyder/pull/11256) - PR: Change unmatched brackets in line validation, by [@dalthviz](https://github.com/dalthviz) ([11217](https://github.com/spyder-ide/spyder/issues/11217))
* [PR 11254](https://github.com/spyder-ide/spyder/pull/11254) - PR: Validate custom scale factor not being below 1.0, by [@dalthviz](https://github.com/dalthviz) ([11240](https://github.com/spyder-ide/spyder/issues/11240))
* [PR 11248](https://github.com/spyder-ide/spyder/pull/11248) - PR: Cache call to get_icon_by_extension_or_type, by [@impact27](https://github.com/impact27) ([11247](https://github.com/spyder-ide/spyder/issues/11247))
* [PR 11241](https://github.com/spyder-ide/spyder/pull/11241) - PR: Handle error when disconnecting object info signal after idle, by [@dalthviz](https://github.com/dalthviz) ([11228](https://github.com/spyder-ide/spyder/issues/11228))
* [PR 11239](https://github.com/spyder-ide/spyder/pull/11239) - PR: Handle AttributeError when generating context menu on dockwidget tabs, by [@dalthviz](https://github.com/dalthviz) ([11226](https://github.com/spyder-ide/spyder/issues/11226))
* [PR 11238](https://github.com/spyder-ide/spyder/pull/11238) - PR: Handle AttributeError when creating an ArrayEditor, by [@dalthviz](https://github.com/dalthviz) ([11216](https://github.com/spyder-ide/spyder/issues/11216))
* [PR 11223](https://github.com/spyder-ide/spyder/pull/11223) - PR: Fix freeze when LSP client queue is full, by [@impact27](https://github.com/impact27) ([11222](https://github.com/spyder-ide/spyder/issues/11222))
* [PR 11219](https://github.com/spyder-ide/spyder/pull/11219) - PR: Handle encoding when restarting Spyder to fix an error with Python 2.7, by [@dalthviz](https://github.com/dalthviz) ([11024](https://github.com/spyder-ide/spyder/issues/11024))
* [PR 11212](https://github.com/spyder-ide/spyder/pull/11212) - PR: Fix infinite loop when commenting first block, by [@impact27](https://github.com/impact27) ([11148](https://github.com/spyder-ide/spyder/issues/11148))
* [PR 11210](https://github.com/spyder-ide/spyder/pull/11210) - PR: Use Pandas tolist to get formatted indexes and headers in the DataFrame editor, by [@dalthviz](https://github.com/dalthviz) ([11129](https://github.com/spyder-ide/spyder/issues/11129))
* [PR 11192](https://github.com/spyder-ide/spyder/pull/11192) - PR: Send comm config again if comm times out, by [@impact27](https://github.com/impact27) ([11406](https://github.com/spyder-ide/spyder/issues/11406), [11137](https://github.com/spyder-ide/spyder/issues/11137))
* [PR 11122](https://github.com/spyder-ide/spyder/pull/11122) - PR: Rename copy line and duplicate line shortcuts, by [@jnsebgosselin](https://github.com/jnsebgosselin) ([11092](https://github.com/spyder-ide/spyder/issues/11092))
* [PR 11103](https://github.com/spyder-ide/spyder/pull/11103) - PR: Add IPython magic runcell test, by [@impact27](https://github.com/impact27) ([11061](https://github.com/spyder-ide/spyder/issues/11061))
* [PR 10976](https://github.com/spyder-ide/spyder/pull/10976) - PR: Implement dynamic variable explorer window size, by [@jsh9](https://github.com/jsh9) ([10745](https://github.com/spyder-ide/spyder/issues/10745))
* [PR 10801](https://github.com/spyder-ide/spyder/pull/10801) - PR: Make adjustable the maximum number of recent projects, by [@juanis2112](https://github.com/juanis2112) ([10640](https://github.com/spyder-ide/spyder/issues/10640))
* [PR 10610](https://github.com/spyder-ide/spyder/pull/10610) - PR: Update debugging panel with current console pdb state, by [@dalthviz](https://github.com/dalthviz) ([10538](https://github.com/spyder-ide/spyder/issues/10538))
* [PR 9554](https://github.com/spyder-ide/spyder/pull/9554) - PR: Remove stylesheet workarounds for the options and browse button when under the dark theme, by [@jnsebgosselin](https://github.com/jnsebgosselin)

In this release 115 pull requests were closed.


----


## Version 4.0.1 (2020-01-02)

### Important fixes

* Remove password-based authentication to report errors on Github.
* Several performance improvements in the Editor.

### Issues Closed

* [Issue 11191](https://github.com/spyder-ide/spyder/issues/11191) - Travis fails with IPython 7.11 ([PR 11194](https://github.com/spyder-ide/spyder/pull/11194))
* [Issue 11140](https://github.com/spyder-ide/spyder/issues/11140) - Simple typo: witdh -> width ([PR 11141](https://github.com/spyder-ide/spyder/pull/11141))
* [Issue 11132](https://github.com/spyder-ide/spyder/issues/11132) - Duplicate keyboard shortcuts, restoring them to default crashes  ([PR 11197](https://github.com/spyder-ide/spyder/pull/11197))
* [Issue 11096](https://github.com/spyder-ide/spyder/issues/11096) - "Select All" in Variable Explorer for DataFrames ([PR 11100](https://github.com/spyder-ide/spyder/pull/11100))
* [Issue 11076](https://github.com/spyder-ide/spyder/issues/11076) - Kite pop-up doesn't show up if Editor pane undocked ([PR 11114](https://github.com/spyder-ide/spyder/pull/11114))
* [Issue 11074](https://github.com/spyder-ide/spyder/issues/11074) - AttributeError: 'QTextBlock' object has no attribute '_selection' ([PR 11075](https://github.com/spyder-ide/spyder/pull/11075))
* [Issue 11070](https://github.com/spyder-ide/spyder/issues/11070) - Copying or duplicating multiple selected lines deselects last line each time ([PR 11089](https://github.com/spyder-ide/spyder/pull/11089))
* [Issue 11060](https://github.com/spyder-ide/spyder/issues/11060) - Variable explorer slow to open in spyder 4 with large dataframes ([PR 11102](https://github.com/spyder-ide/spyder/pull/11102))
* [Issue 11059](https://github.com/spyder-ide/spyder/issues/11059) - Github warning when using Issue reporter ([PR 11209](https://github.com/spyder-ide/spyder/pull/11209))
* [Issue 11058](https://github.com/spyder-ide/spyder/issues/11058) - Exceptions when I cancelled saving an unsaved file ([PR 11077](https://github.com/spyder-ide/spyder/pull/11077))
* [Issue 11050](https://github.com/spyder-ide/spyder/issues/11050) - Feature request: add a minimum height for the slider range of the scrollflag panel ([PR 11057](https://github.com/spyder-ide/spyder/pull/11057))
* [Issue 11047](https://github.com/spyder-ide/spyder/issues/11047) - Error when getting completions with Jedi 0.15 ([PR 11087](https://github.com/spyder-ide/spyder/pull/11087))
* [Issue 11007](https://github.com/spyder-ide/spyder/issues/11007) - Status bar displays incorrect interpreter on Windows ([PR 11008](https://github.com/spyder-ide/spyder/pull/11008))
* [Issue 11006](https://github.com/spyder-ide/spyder/issues/11006) - Status bar does not update current interpreter ([PR 11008](https://github.com/spyder-ide/spyder/pull/11008))
* [Issue 11000](https://github.com/spyder-ide/spyder/issues/11000) - Spyder very slow when working on large python files ([PR 11011](https://github.com/spyder-ide/spyder/pull/11011))
* [Issue 10992](https://github.com/spyder-ide/spyder/issues/10992) - Spyder 4.0.0 unbearably slow when adding or removing lines ([PR 11010](https://github.com/spyder-ide/spyder/pull/11010))
* [Issue 10955](https://github.com/spyder-ide/spyder/issues/10955) - The object modified is too big to be sent back to the kernel ([PR 10987](https://github.com/spyder-ide/spyder/pull/10987))
* [Issue 10918](https://github.com/spyder-ide/spyder/issues/10918) - KeyError when drawing folding regions ([PR 11088](https://github.com/spyder-ide/spyder/pull/11088))
* [Issue 10912](https://github.com/spyder-ide/spyder/issues/10912) - When plotting new plot, plot pane does automatically scroll down to newest plot. ([PR 10914](https://github.com/spyder-ide/spyder/pull/10914))
* [Issue 10897](https://github.com/spyder-ide/spyder/issues/10897) - Blank line printed on console for each chart plotted ([PR 10909](https://github.com/spyder-ide/spyder/pull/10909))
* [Issue 10893](https://github.com/spyder-ide/spyder/issues/10893) - Spyder closes unexpectedly when trying to change plain text font ([PR 11172](https://github.com/spyder-ide/spyder/pull/11172))
* [Issue 10844](https://github.com/spyder-ide/spyder/issues/10844) - Can't open file with non unicode name by drag and drop ([PR 10846](https://github.com/spyder-ide/spyder/pull/10846))
* [Issue 10835](https://github.com/spyder-ide/spyder/issues/10835) - Hover tips interfere with editor text selection ([PR 10855](https://github.com/spyder-ide/spyder/pull/10855))
* [Issue 10786](https://github.com/spyder-ide/spyder/issues/10786) - Alt+Space shortcut cannot be set in Spyder 4 ([PR 10836](https://github.com/spyder-ide/spyder/pull/10836))
* [Issue 10221](https://github.com/spyder-ide/spyder/issues/10221) - Spyder stalls for 2 minutes on startup when starting a remote Xorg session ([PR 10837](https://github.com/spyder-ide/spyder/pull/10837))
* [Issue 8093](https://github.com/spyder-ide/spyder/issues/8093) - Variable Explorer crashes when viewing Numpy matrix with inf ([PR 10856](https://github.com/spyder-ide/spyder/pull/10856))
* [Issue 7998](https://github.com/spyder-ide/spyder/issues/7998) - "Show blank spaces" refuses to work on files without officially "supported" extensions ([PR 10887](https://github.com/spyder-ide/spyder/pull/10887))
* [Issue 7848](https://github.com/spyder-ide/spyder/issues/7848) - Variable editor problems on clicking ([PR 10866](https://github.com/spyder-ide/spyder/pull/10866))
* [Issue 7362](https://github.com/spyder-ide/spyder/issues/7362) - Cannot type further letters or symbols after : in symbol finder dialog ([PR 10865](https://github.com/spyder-ide/spyder/pull/10865))
* [Issue 6992](https://github.com/spyder-ide/spyder/issues/6992) - Default Help "Usage" screen always shows hardcoded default inspect shortcut, not actual one ([PR 10869](https://github.com/spyder-ide/spyder/pull/10869))
* [Issue 4833](https://github.com/spyder-ide/spyder/issues/4833) - Error when copying text from a Dataframe on Python 2 ([PR 11104](https://github.com/spyder-ide/spyder/pull/11104))
* [Issue 2675](https://github.com/spyder-ide/spyder/issues/2675) - Multiline search and replace doesn't replace ([PR 10872](https://github.com/spyder-ide/spyder/pull/10872))

In this release 32 issues were closed.

### Pull Requests Merged

* [PR 11209](https://github.com/spyder-ide/spyder/pull/11209) - PR: Remove password-based authentication from the Github login dialog ([11059](https://github.com/spyder-ide/spyder/issues/11059))
* [PR 11197](https://github.com/spyder-ide/spyder/pull/11197) - PR: Fix creation of config files for external plugins ([11132](https://github.com/spyder-ide/spyder/issues/11132))
* [PR 11194](https://github.com/spyder-ide/spyder/pull/11194) - PR: Skip some failing tests for the IPython console ([11191](https://github.com/spyder-ide/spyder/issues/11191))
* [PR 11184](https://github.com/spyder-ide/spyder/pull/11184) - PR: Fix shortcut reset error and add test
* [PR 11172](https://github.com/spyder-ide/spyder/pull/11172) - PR: Fix completions for the internal console and prevent hard crash ([10893](https://github.com/spyder-ide/spyder/issues/10893))
* [PR 11159](https://github.com/spyder-ide/spyder/pull/11159) - PR: Don't register keyring as a dependency on Linux and Python 2
* [PR 11141](https://github.com/spyder-ide/spyder/pull/11141) - PR: Fix simple typo in docstring ([11140](https://github.com/spyder-ide/spyder/issues/11140))
* [PR 11114](https://github.com/spyder-ide/spyder/pull/11114) - PR: Handle CompletionWidget position when undocking editor ([11076](https://github.com/spyder-ide/spyder/issues/11076))
* [PR 11104](https://github.com/spyder-ide/spyder/pull/11104) - PR: Handle enconding error when copying dataframes in Python 2 ([4833](https://github.com/spyder-ide/spyder/issues/4833))
* [PR 11102](https://github.com/spyder-ide/spyder/pull/11102) - PR: Set time limit to calculate columns size hint for Dataframe Editor ([11060](https://github.com/spyder-ide/spyder/issues/11060))
* [PR 11100](https://github.com/spyder-ide/spyder/pull/11100) - PR: Copy index and headers of dataframe ([11096](https://github.com/spyder-ide/spyder/issues/11096))
* [PR 11091](https://github.com/spyder-ide/spyder/pull/11091) - PR: Workaround to avoid a glitch when duplicating current line or text selection
* [PR 11089](https://github.com/spyder-ide/spyder/pull/11089) - PR: Fix copying or duplicating multiple selected lines ([11070](https://github.com/spyder-ide/spyder/issues/11070))
* [PR 11088](https://github.com/spyder-ide/spyder/pull/11088) - PR: Catch KeyError when trying to draw a folding region ([10918](https://github.com/spyder-ide/spyder/issues/10918))
* [PR 11087](https://github.com/spyder-ide/spyder/pull/11087) - PR: Add Jedi as a new dependency for users to be aware of its right version ([11047](https://github.com/spyder-ide/spyder/issues/11047))
* [PR 11077](https://github.com/spyder-ide/spyder/pull/11077) - PR: Keep finfo.newly_created state when cancelling save_as ([11058](https://github.com/spyder-ide/spyder/issues/11058))
* [PR 11075](https://github.com/spyder-ide/spyder/pull/11075) - PR: Call data instead of block to fix AttributeError in the editor ([11074](https://github.com/spyder-ide/spyder/issues/11074))
* [PR 11057](https://github.com/spyder-ide/spyder/pull/11057) - PR: Set a minimum value for the scrollflag's slider height ([11050](https://github.com/spyder-ide/spyder/issues/11050))
* [PR 11036](https://github.com/spyder-ide/spyder/pull/11036) - PR: Improve efficiency of __mark_occurences method
* [PR 11011](https://github.com/spyder-ide/spyder/pull/11011) - PR: Optimize editor scrollflag panel painting ([11000](https://github.com/spyder-ide/spyder/issues/11000))
* [PR 11010](https://github.com/spyder-ide/spyder/pull/11010) - PR: Change update_all to update_current on editor changes ([10992](https://github.com/spyder-ide/spyder/issues/10992))
* [PR 11008](https://github.com/spyder-ide/spyder/pull/11008) - PR: Correctly update Python interpreter on status bar when modified for Windows ([11007](https://github.com/spyder-ide/spyder/issues/11007), [11007](https://github.com/spyder-ide/spyder/issues/11007), [11006](https://github.com/spyder-ide/spyder/issues/11006), [11006](https://github.com/spyder-ide/spyder/issues/11006))
* [PR 11002](https://github.com/spyder-ide/spyder/pull/11002) - PR: Skip test_go_to_definition completely on macOS
* [PR 10987](https://github.com/spyder-ide/spyder/pull/10987) - PR: Remove serialized length limit when sending modified variables back to the kernel ([10955](https://github.com/spyder-ide/spyder/issues/10955))
* [PR 10967](https://github.com/spyder-ide/spyder/pull/10967) - PR: Create sections for project and build status in README.md
* [PR 10956](https://github.com/spyder-ide/spyder/pull/10956) - PR: Fix simple error in a test widget
* [PR 10954](https://github.com/spyder-ide/spyder/pull/10954) - PR: Add crowdin config
* [PR 10953](https://github.com/spyder-ide/spyder/pull/10953) - PR: Update readme to use the correct branch for binder
* [PR 10950](https://github.com/spyder-ide/spyder/pull/10950) - PR: Add link to try out current Spyder on mybinder.org
* [PR 10948](https://github.com/spyder-ide/spyder/pull/10948) - PR: Correctly show several missing deps in our dialog
* [PR 10914](https://github.com/spyder-ide/spyder/pull/10914) - PR: Automatically scroll down to newest plot in Plots pane ([10912](https://github.com/spyder-ide/spyder/issues/10912))
* [PR 10909](https://github.com/spyder-ide/spyder/pull/10909) - PR: Fix extra blank line added to qtconsole when plotting ([10897](https://github.com/spyder-ide/spyder/issues/10897))
* [PR 10887](https://github.com/spyder-ide/spyder/pull/10887) - PR: Fix showing spaces for generic files ([7998](https://github.com/spyder-ide/spyder/issues/7998))
* [PR 10872](https://github.com/spyder-ide/spyder/pull/10872) - PR: Fix find/replace widget for multiline regex ([2675](https://github.com/spyder-ide/spyder/issues/2675))
* [PR 10869](https://github.com/spyder-ide/spyder/pull/10869) - PR: Fix help intro message with correct shortcut and update if shortcut changes ([6992](https://github.com/spyder-ide/spyder/issues/6992))
* [PR 10866](https://github.com/spyder-ide/spyder/pull/10866) - PR: Fix updates with complex values on variable explorer ([7848](https://github.com/spyder-ide/spyder/issues/7848))
* [PR 10865](https://github.com/spyder-ide/spyder/pull/10865) - PR: Handle non-ascii text in the switcher ([7362](https://github.com/spyder-ide/spyder/issues/7362))
* [PR 10856](https://github.com/spyder-ide/spyder/pull/10856) - PR: Check if arrays have inf values and add test ([8093](https://github.com/spyder-ide/spyder/issues/8093))
* [PR 10855](https://github.com/spyder-ide/spyder/pull/10855) - PR: Hide tooltip widget with mouse click and keypress ([10835](https://github.com/spyder-ide/spyder/issues/10835))
* [PR 10846](https://github.com/spyder-ide/spyder/pull/10846) - PR: Unquote url properly for drag and drop ([10844](https://github.com/spyder-ide/spyder/issues/10844))
* [PR 10837](https://github.com/spyder-ide/spyder/pull/10837) - PR: Do not import keyring when running through SSH ([10221](https://github.com/spyder-ide/spyder/issues/10221))
* [PR 10836](https://github.com/spyder-ide/spyder/pull/10836) - PR: Fix the shortcut override in the ShortcutEditor. ([10786](https://github.com/spyder-ide/spyder/issues/10786))
* [PR 10804](https://github.com/spyder-ide/spyder/pull/10804) - PR: Implement a faster paint event for cells

In this release 43 pull requests were closed.


----


## Version 4.0.0 (2019-12-06)

### New features

#### Main Window

* Add a dark theme for the entire interface.
* Add a new `Plots` pane to browse all inline figures generated by the IPython console.
* Several plugins were renamed to have a simpler interface:
  - `Static code analysis` to `Code Analysis`
  - `File explorer` to `Files`
  - `Find in files` to `Find`
  - `History log` to `History`
  - `Project explorer` to `Project`
* Add a new action called `Undock` to the Options menu of every plugin. This action
  creates a separate window that only contains the plugin and can be moved to a
  different place of the screen or to a different monitor.
* Add a clock to the status bar, for those who like to work in full screen mode. It can
  be activated in
  `Preferences > General > Advanced settings > Status bar > Show clock`.
* Show current conda environment and git branch (if any) in the status bar.
* Add translation for Simplified Chinese.

#### Editor

* Add code folding functionality.
* Show code completions as you type.
* Add autosave functionality to be able to recover unsaved files after a crash.
* Add indentation guides. They can be activated under the `Source` menu.
* Add a panel to show the current class and method/function where the cursor is placed,
  inspired by similar functionality present in Microsoft Visual Studio. It can activated
  under the menu `Source > Show selector for classes and functions`.
* Allow setting multiple line length indicators under
  `Preferences > Editor > Display > Show vertical lines`.
* Add `Ctrl+Alt+Shift+,` and `Ctrl+Alt+Shift+.` shortcuts to go to the previous/next
  warning and error, respectively.
* Allow scrolling past the end of the file. This can activated in
  `Preferences > Editor > Display > Scroll past the end`.
* Add the ability to take into account code indentation and PEP 8 when adding and
  removing comments.
* Add an option to convert end-of-line characters on save.  This can activated in
  `Preferences > Editor > Advanced settings > End-of-line characters`
* Add `Ctrl+{` and `Ctrl+_` shortcuts to split panels vertically and horizontally,
  respectively.
* Add `Alt+Shift+W` shortcut to close the current split panel.
* After pressing a quote or brace the current selection gets enclosed on it.
* Add automatic docstring generation (parameters, return vals and exceptions raised) in
  Numpydoc and Googledoc formats.
* Add an option to its context menu to sort files alphabetically.
* Add the ability to reference issues on Gitlab (`gl`), Github (`gh`) and Bitbucket
  (`bb`) in comments or strings by using the convention `{gl/gh/bb}:my-org/my-repo#123`.
  You can also reference them by `{gl/gh/bb}-123`, if you've previously set up an
  `upstream` or `origin` remote in your repo.
* Use the Language Server Protocol for code completion and linting.

#### IPython console
* Files are now run in an empty namespace. This avoids picking up variables defined in
  the console while running a file. To get the previous behavior you need to go to the
  menu `Run > Configuration per file` and activate the option called
  `Run in console’s namespace instead of an empty one`.
* Add menu options to start consoles in Pylab, Sympy and Cython modes.
* Run cells through a function called `runcell` instead of pasting their contents
  directly to the console.
* Use Jupyter comms to handle communications between frontend and kernel.

#### Debugger

* Add code completion to it.
* Add the ability to execute multi-line statements on it.
* Add syntax highlighting to it and color `ipdb` prompts.
* Add permanent history to it, separate from the console history.
* `runfile` and `runcell` can now be called when the debugger is active.
* Add the ability to debug cells by pressing `Alt+Shift+Return` or by going to the menu
  `Debug > Debug cell`.
* Add an option to ignore installed Python libraries while debugging. It can be turned on
  in the menu `Debug > Ignore Python libraries while debugging`.
* Add the ability to see inline plots while debugging. For that you need to activate the
  option called `Process execute events while debugging`, present in in the `Debug` menu.
* Disambiguate file names in the Breakpoints pane.

#### Variable Explorer

* Add a new viewer to inspect any Python object in a tree-like way.
* Add the ability to search for variable names and types.
* Restore the ability to refresh it while code is being executed.
* Add support for Numpy object arrays.
* Add MultiIndex display support to the DataFrame viewer.
* Add support for all Pandas indexes.
* Add support for sets.
* Add a new option to exclude callables and modules.
* Add an option to its context menu (the one you get with a mouse right-click) to resize
  columns to its contents.

#### Files

* Add the possibility to associate different external applications to open specific file
  extensions (e.g. `.txt` files with Notepad++ or VSCode).
* Add a context menu action called `Open externally` to all files to open them with the
  operating system default program associated with the file type.
* Add multi-select functionality, i.e. using `Ctrl/Shift+click` to select multiple files.
* Add the ability to copy/paste files and their absolute or relative paths.
* Use special icons for different file types.
* Add an option to open files and directories with a single click.

#### Outline

* Show cells grouped in sections. Level 1 cells are defined by `#%%` (as before), level 2
  cells by `#%%%`, level 3 cells by `#%%%%` and so on. With this new syntax, all `n+1`
  cells will be conveniently grouped under n-level cells in the outline tree.
* Add an option to sort files alphabetically. By default files are shown in the same
  order as in the Editor.
* Add a default name for cells to encourage users to name them. This way cells can be
  more easily spotted in the outline tree.

#### Preferences:

* Spyder can now read default configuration options saved in `spyder.ini` files from
  system (e.g. `/etc/spyder`) and conda environment (e.g.
  `~/miniconda/envs/py36/etc/spyder`) directories. This can be used by sysadmins to turn
  on/off certain options by default for all users in an organization. To inspect the
  paths from which Spyder reads these files per operating system and the order in which
  it does that, you can use the new command line option `spyder --paths`.

#### API Changes

##### Major changes
* Create one module per plugin in `spyder.plugins` and move there all widgets and utility
  modules used by that plugin. For example, `spyder.widgets.sourcecode.codeeditor` is now
  at `spyder.plugins.editor.widgets.codeeditor`.
* Create the `spyder.api` module to expose a public API for external plugins. *Note*:
  This is still not stable. It'll be improved and stabilized for Spyder 5 (to be released
  in 2020).
* Add a `SpyderPlugin` class to be able to create plugins without an associated graphical
  pane.

##### Minor changes
* Remove the `SpyderPluginMixin` class. Its contents were added to `BasePluginMixin` and
  `BasePluginWidgetMixin` (in `plugins/base.py`).
* Move `SpyderDockWidget` to `widgets/dock.py`.
* Config pages of all plugins are now located in a separate module called
  `spyder/plugins/<plugin>/confpage.py`

#### Under the hood
* Drop support for Python 3.4.
* Increase minimal PyQt supported version to 5.6.
* Deprecate the usage of `debug_print` and use the `logging` module instead.

### Issues Closed

* [Issue 10917](https://github.com/spyder-ide/spyder/issues/10917) - No plotting available for some variables in Variable Explorer ([PR 10929](https://github.com/spyder-ide/spyder/pull/10929))
* [Issue 10900](https://github.com/spyder-ide/spyder/issues/10900) - Regression: Indent guides broken in any Editor split panel except the first ([PR 10910](https://github.com/spyder-ide/spyder/pull/10910))
* [Issue 10884](https://github.com/spyder-ide/spyder/issues/10884) - String "Run in console's namespace instead of an empty one" translated but still show English on UI ([PR 10886](https://github.com/spyder-ide/spyder/pull/10886))
* [Issue 10851](https://github.com/spyder-ide/spyder/issues/10851) - Pdb switch code editor tabs without reason ([PR 10850](https://github.com/spyder-ide/spyder/pull/10850))
* [Issue 10834](https://github.com/spyder-ide/spyder/issues/10834) - Keyboard events leak from console to editor while debugging ([PR 10847](https://github.com/spyder-ide/spyder/pull/10847))
* [Issue 10763](https://github.com/spyder-ide/spyder/issues/10763) - Fails to install Spyder4.0.0rc2 on Windows due to ujson dependency
* [Issue 10736](https://github.com/spyder-ide/spyder/issues/10736) - runfile changes the current tab in the editor ([PR 10839](https://github.com/spyder-ide/spyder/pull/10839))
* [Issue 10672](https://github.com/spyder-ide/spyder/issues/10672) - Update translations for 4.0.0 ([PR 10930](https://github.com/spyder-ide/spyder/pull/10930))

In this release 8 issues were closed.

### Pull Requests Merged

* [PR 10947](https://github.com/spyder-ide/spyder/pull/10947) - PR: Show PyLS errors only in debug or development modes
* [PR 10940](https://github.com/spyder-ide/spyder/pull/10940) - PR: Update versions of spyder-kernels and PyLS for the final release
* [PR 10935](https://github.com/spyder-ide/spyder/pull/10935) - PR: Some corrections to the French translation
* [PR 10930](https://github.com/spyder-ide/spyder/pull/10930) - PR: Disable Hungarian and Russian translations ([10810](https://github.com/spyder-ide/spyder/issues/10810), [10809](https://github.com/spyder-ide/spyder/issues/10809), [10672](https://github.com/spyder-ide/spyder/issues/10672))
* [PR 10929](https://github.com/spyder-ide/spyder/pull/10929) - PR: Use proxy_model when refreshing plot actions state ([10917](https://github.com/spyder-ide/spyder/issues/10917))
* [PR 10920](https://github.com/spyder-ide/spyder/pull/10920) - PR: Show autosave dialog on top of splash screen in macOS
* [PR 10910](https://github.com/spyder-ide/spyder/pull/10910) - PR: Show indent guides for splited editor panels ([10900](https://github.com/spyder-ide/spyder/issues/10900))
* [PR 10902](https://github.com/spyder-ide/spyder/pull/10902) - PR: Update Simplified Chinese translation
* [PR 10901](https://github.com/spyder-ide/spyder/pull/10901) - PR: Update Portuguese (Brazilian) translation for Spyder 4
* [PR 10899](https://github.com/spyder-ide/spyder/pull/10899) - PR: Fix restart when using an external interpreter in development mode
* [PR 10892](https://github.com/spyder-ide/spyder/pull/10892) - PR: Only assign icons to files and directories in Files
* [PR 10886](https://github.com/spyder-ide/spyder/pull/10886) - PR: Remove non-ascii character in a translation string ([10884](https://github.com/spyder-ide/spyder/issues/10884))
* [PR 10885](https://github.com/spyder-ide/spyder/pull/10885) - PR: Skip test_debug_unsaved_file in macOS and Python 3
* [PR 10882](https://github.com/spyder-ide/spyder/pull/10882) - PR: Update Simplified Chinese translations against RC3
* [PR 10868](https://github.com/spyder-ide/spyder/pull/10868) - PR: Add Simplified Chinese translation for Spyder 4
* [PR 10859](https://github.com/spyder-ide/spyder/pull/10859) - PR: Add a reviewed German translation
* [PR 10850](https://github.com/spyder-ide/spyder/pull/10850) - PR: Only go to line in editor when Pdb changes line ([10851](https://github.com/spyder-ide/spyder/issues/10851))
* [PR 10847](https://github.com/spyder-ide/spyder/pull/10847) - PR: Make sure processEvents is not called by Pdb ([10834](https://github.com/spyder-ide/spyder/issues/10834))
* [PR 10839](https://github.com/spyder-ide/spyder/pull/10839) - PR: Don't switch tabs in runfile or runcell ([10736](https://github.com/spyder-ide/spyder/issues/10736))
* [PR 10764](https://github.com/spyder-ide/spyder/pull/10764) - PR: Update Spanish translation for Spyder 4
* [PR 10720](https://github.com/spyder-ide/spyder/pull/10720) - PR: Add french translations
* [PR 10714](https://github.com/spyder-ide/spyder/pull/10714) - PR: Update Japanese translation for 4.0.0

In this release 22 pull requests were closed.


----


## Version 4.0rc3 (2019-11-27)

### Issues Closed

* [Issue 10842](https://github.com/spyder-ide/spyder/issues/10842) - Calltip has unbound local error ([PR 10848](https://github.com/spyder-ide/spyder/pull/10848))
* [Issue 10797](https://github.com/spyder-ide/spyder/issues/10797) - Autocompletions should not be triggered by backspace ([PR 10802](https://github.com/spyder-ide/spyder/pull/10802))
* [Issue 10783](https://github.com/spyder-ide/spyder/issues/10783) - Autocompletions should not be triggered when inserting a newline ([PR 10802](https://github.com/spyder-ide/spyder/pull/10802))
* [Issue 10777](https://github.com/spyder-ide/spyder/issues/10777) - KeyError when removing syntax error in editor ([PR 10782](https://github.com/spyder-ide/spyder/pull/10782))
* [Issue 10766](https://github.com/spyder-ide/spyder/issues/10766) - Enabling or disabling "Show blank spaces" causes Spyder to perma-hang ([PR 10767](https://github.com/spyder-ide/spyder/pull/10767))
* [Issue 10754](https://github.com/spyder-ide/spyder/issues/10754) - Make Spyder display a clear/user-friendly error when used with a too-old Spyder-Kernels version ([PR 10781](https://github.com/spyder-ide/spyder/pull/10781))
* [Issue 10752](https://github.com/spyder-ide/spyder/issues/10752) - Spyder encounters internal error on hover (TypeError / ValueError) ([PR 10757](https://github.com/spyder-ide/spyder/pull/10757))
* [Issue 10660](https://github.com/spyder-ide/spyder/issues/10660) - Adding applications to file associations is broken on Windows due to unescaped backslashes ([PR 10733](https://github.com/spyder-ide/spyder/pull/10733))
* [Issue 10647](https://github.com/spyder-ide/spyder/issues/10647) - Snippets corrupted after completion inserted over placeholder ([PR 10701](https://github.com/spyder-ide/spyder/pull/10701))
* [Issue 10624](https://github.com/spyder-ide/spyder/issues/10624) - Selector for classes and functions not working correctly. ([PR 10825](https://github.com/spyder-ide/spyder/pull/10825))
* [Issue 10528](https://github.com/spyder-ide/spyder/issues/10528) - Completions are not working for underscore variables ([PR 10730](https://github.com/spyder-ide/spyder/pull/10730))
* [Issue 10521](https://github.com/spyder-ide/spyder/issues/10521) - Segmentation fault in paintEvent ([PR 10771](https://github.com/spyder-ide/spyder/pull/10771))
* [Issue 10209](https://github.com/spyder-ide/spyder/issues/10209) - Spyder freezes when trying to connect to an LSP server ([PR 10481](https://github.com/spyder-ide/spyder/pull/10481))
* [Issue 9956](https://github.com/spyder-ide/spyder/issues/9956) - Code folding bug ([PR 10333](https://github.com/spyder-ide/spyder/pull/10333))
* [Issue 5533](https://github.com/spyder-ide/spyder/issues/5533) - Online help index contains invalid links ([PR 10755](https://github.com/spyder-ide/spyder/pull/10755))

In this release 15 issues were closed.

### Pull Requests Merged

* [PR 10848](https://github.com/spyder-ide/spyder/pull/10848) - PR: Fix show_calltip for the IPython console ([10842](https://github.com/spyder-ide/spyder/issues/10842))
* [PR 10838](https://github.com/spyder-ide/spyder/pull/10838) - PR: Update minimal PyLS version required by us
* [PR 10826](https://github.com/spyder-ide/spyder/pull/10826) - PR: Catch extra exception for external plugins
* [PR 10825](https://github.com/spyder-ide/spyder/pull/10825) - PR: Fix class/function selector by using the LSP ([10624](https://github.com/spyder-ide/spyder/issues/10624))
* [PR 10820](https://github.com/spyder-ide/spyder/pull/10820) - PR: Prevent calls to document/didChange whenever the cursor changes position
* [PR 10802](https://github.com/spyder-ide/spyder/pull/10802) - PR: Prevent automatic completions on backspace and return ([10797](https://github.com/spyder-ide/spyder/issues/10797), [10783](https://github.com/spyder-ide/spyder/issues/10783))
* [PR 10782](https://github.com/spyder-ide/spyder/pull/10782) - PR: Fix several issues with the new LSP folding ([10777](https://github.com/spyder-ide/spyder/issues/10777))
* [PR 10781](https://github.com/spyder-ide/spyder/pull/10781) - PR: Improve error message of spyder-kernels version in external interpreter ([10754](https://github.com/spyder-ide/spyder/issues/10754))
* [PR 10771](https://github.com/spyder-ide/spyder/pull/10771) - PR: Fix segfault in replace by calling setFocus outside of EditBlock ([10521](https://github.com/spyder-ide/spyder/issues/10521))
* [PR 10767](https://github.com/spyder-ide/spyder/pull/10767) - PR: Don't request folding when rehighlighting the whole document ([10766](https://github.com/spyder-ide/spyder/issues/10766))
* [PR 10765](https://github.com/spyder-ide/spyder/pull/10765) - PR: Fix opening files with spaces
* [PR 10757](https://github.com/spyder-ide/spyder/pull/10757) - PR: Fix hover regression and improve tests for it ([10752](https://github.com/spyder-ide/spyder/issues/10752))
* [PR 10755](https://github.com/spyder-ide/spyder/pull/10755) - PR: Fix link handling and pydoc numpy related import for Online Help ([5533](https://github.com/spyder-ide/spyder/issues/5533))
* [PR 10733](https://github.com/spyder-ide/spyder/pull/10733) - PR: Fix logic for removing extra quotes on windows path applications ([10660](https://github.com/spyder-ide/spyder/issues/10660))
* [PR 10730](https://github.com/spyder-ide/spyder/pull/10730) - PR: Fix underscore completions ([10528](https://github.com/spyder-ide/spyder/issues/10528))
* [PR 10701](https://github.com/spyder-ide/spyder/pull/10701) - PR: Fix snippet region computation for completion insertions over selections ([10647](https://github.com/spyder-ide/spyder/issues/10647))
* [PR 10481](https://github.com/spyder-ide/spyder/pull/10481) - PR: Don't block when transport layer is down ([10209](https://github.com/spyder-ide/spyder/issues/10209))
* [PR 10333](https://github.com/spyder-ide/spyder/pull/10333) - PR: Enable LSP folding support ([9956](https://github.com/spyder-ide/spyder/issues/9956))

In this release 18 pull requests were closed.


----


## Version 4.0rc2 (2019-11-18)

### Issues Closed

* [Issue 10735](https://github.com/spyder-ide/spyder/issues/10735) - Rename in (variable explorer) is not working properly ([PR 10739](https://github.com/spyder-ide/spyder/pull/10739))
* [Issue 10726](https://github.com/spyder-ide/spyder/issues/10726) - Toolbar tooltips are not updated correctly after a change is made to the shortcuts ([PR 10727](https://github.com/spyder-ide/spyder/pull/10727))
* [Issue 10712](https://github.com/spyder-ide/spyder/issues/10712) - Add a clock to the statusbar ([PR 10725](https://github.com/spyder-ide/spyder/pull/10725))
* [Issue 10709](https://github.com/spyder-ide/spyder/issues/10709) - Errors when removing variables in the Variable Explorer ([PR 10729](https://github.com/spyder-ide/spyder/pull/10729))
* [Issue 10696](https://github.com/spyder-ide/spyder/issues/10696) - Pdb and IPython completes are inconsistent  ([PR 10695](https://github.com/spyder-ide/spyder/pull/10695))
* [Issue 10692](https://github.com/spyder-ide/spyder/issues/10692) - Autocomplete in the console only displays file extensions
* [Issue 10686](https://github.com/spyder-ide/spyder/issues/10686) - Fix path manager synchronize on windows ([PR 10711](https://github.com/spyder-ide/spyder/pull/10711))
* [Issue 10684](https://github.com/spyder-ide/spyder/issues/10684) - EditorStack file and symbol switcher not working #2 ([PR 10685](https://github.com/spyder-ide/spyder/pull/10685))
* [Issue 10682](https://github.com/spyder-ide/spyder/issues/10682) - Some proposed improvements to the file switcher ([PR 10698](https://github.com/spyder-ide/spyder/pull/10698))
* [Issue 10674](https://github.com/spyder-ide/spyder/issues/10674) - Observing $0 / $1 vars in help topic name upon clicking a tooltip ([PR 10731](https://github.com/spyder-ide/spyder/pull/10731))
* [Issue 10653](https://github.com/spyder-ide/spyder/issues/10653) - Error when reporting inotify message ([PR 10662](https://github.com/spyder-ide/spyder/pull/10662))
* [Issue 10650](https://github.com/spyder-ide/spyder/issues/10650) - Error while getting completion of function/method definition ([PR 10688](https://github.com/spyder-ide/spyder/pull/10688))
* [Issue 10646](https://github.com/spyder-ide/spyder/issues/10646) - Go to definition in editor not working for files in user PYTHONPATH ([PR 10629](https://github.com/spyder-ide/spyder/pull/10629))
* [Issue 10634](https://github.com/spyder-ide/spyder/issues/10634) - 'Show completions on the fly' cannot be turned off ([PR 10732](https://github.com/spyder-ide/spyder/pull/10732))
* [Issue 10609](https://github.com/spyder-ide/spyder/issues/10609) - Kite tutorial keeps trying to reload tutorial file ([PR 10615](https://github.com/spyder-ide/spyder/pull/10615))
* [Issue 10593](https://github.com/spyder-ide/spyder/issues/10593) - Error in cv2 autocompletion ([PR 10605](https://github.com/spyder-ide/spyder/pull/10605))
* [Issue 10590](https://github.com/spyder-ide/spyder/issues/10590) - Crash when trying to run a Python file in a project ([PR 10607](https://github.com/spyder-ide/spyder/pull/10607))
* [Issue 10588](https://github.com/spyder-ide/spyder/issues/10588) - IndentationError in pdb breaks the console
* [Issue 10563](https://github.com/spyder-ide/spyder/issues/10563) - runcell is buggy ([PR 10565](https://github.com/spyder-ide/spyder/pull/10565))
* [Issue 10537](https://github.com/spyder-ide/spyder/issues/10537) - Object Explorer improvements ([PR 10546](https://github.com/spyder-ide/spyder/pull/10546))
* [Issue 10534](https://github.com/spyder-ide/spyder/issues/10534) - Completion hint is somtimes strange when using kite ([PR 10731](https://github.com/spyder-ide/spyder/pull/10731))
* [Issue 10449](https://github.com/spyder-ide/spyder/issues/10449) - Kernel times out when sending big variable (it worked in Spyder 3) ([PR 10450](https://github.com/spyder-ide/spyder/pull/10450))
* [Issue 10299](https://github.com/spyder-ide/spyder/issues/10299) - Add jedi env and sys path update to LSP ([PR 10629](https://github.com/spyder-ide/spyder/pull/10629))
* [Issue 10276](https://github.com/spyder-ide/spyder/issues/10276) - Autocomplete introduces code snippet in import statement
* [Issue 10275](https://github.com/spyder-ide/spyder/issues/10275) - Local code not shown in Kite completions ([PR 10638](https://github.com/spyder-ide/spyder/pull/10638))
* [Issue 10264](https://github.com/spyder-ide/spyder/issues/10264) - Find in files freezes spyder ([PR 10582](https://github.com/spyder-ide/spyder/pull/10582))
* [Issue 9865](https://github.com/spyder-ide/spyder/issues/9865) - Cancelling "Save as" leads to modified marker (that cannot be undone) ([PR 10635](https://github.com/spyder-ide/spyder/pull/10635))
* [Issue 9125](https://github.com/spyder-ide/spyder/issues/9125) - Autosave recovery dialog expands beyond screen instead of using scrollbars with too many items ([PR 10549](https://github.com/spyder-ide/spyder/pull/10549))
* [Issue 8715](https://github.com/spyder-ide/spyder/issues/8715) - Add filters to exclude modules and functions in Variable Explorer ([PR 10734](https://github.com/spyder-ide/spyder/pull/10734))
* [Issue 4398](https://github.com/spyder-ide/spyder/issues/4398) - Variable explorer is not updated during code execution ([PR 10567](https://github.com/spyder-ide/spyder/pull/10567))
* [Issue 3321](https://github.com/spyder-ide/spyder/issues/3321) - No shortcuts displayed for plugins ([PR 10560](https://github.com/spyder-ide/spyder/pull/10560))
* [Issue 3254](https://github.com/spyder-ide/spyder/issues/3254) - Shortcuts for external plugins can't be registered ([PR 10560](https://github.com/spyder-ide/spyder/pull/10560))
* [Issue 1004](https://github.com/spyder-ide/spyder/issues/1004) - Make the editor use the selected interpreter in Preferences for completions ([PR 10629](https://github.com/spyder-ide/spyder/pull/10629))

In this release 33 issues were closed.

### Pull Requests Merged

* [PR 10747](https://github.com/spyder-ide/spyder/pull/10747) - PR: Update versions of our dependencies required for rc2
* [PR 10739](https://github.com/spyder-ide/spyder/pull/10739) - PR: Map indexes from proxy model to source model for Variable Explorer actions ([10735](https://github.com/spyder-ide/spyder/issues/10735))
* [PR 10734](https://github.com/spyder-ide/spyder/pull/10734) - PR: Add option to exclude callables and modules in the Variable Explorer ([8715](https://github.com/spyder-ide/spyder/issues/8715))
* [PR 10732](https://github.com/spyder-ide/spyder/pull/10732) - PR: Add delay to dot completion logic ([10634](https://github.com/spyder-ide/spyder/issues/10634))
* [PR 10731](https://github.com/spyder-ide/spyder/pull/10731) - PR: Fix hint for completion and title of help on click ([10674](https://github.com/spyder-ide/spyder/issues/10674), [10534](https://github.com/spyder-ide/spyder/issues/10534))
* [PR 10729](https://github.com/spyder-ide/spyder/pull/10729) - PR: Map indexes from proxy model when removing variables ([10709](https://github.com/spyder-ide/spyder/issues/10709))
* [PR 10727](https://github.com/spyder-ide/spyder/pull/10727) - PR: Fix updating actions tooltips after a change is applied to the shortcuts ([10726](https://github.com/spyder-ide/spyder/issues/10726))
* [PR 10725](https://github.com/spyder-ide/spyder/pull/10725) - PR: Add a clock to the status bar ([10712](https://github.com/spyder-ide/spyder/issues/10712))
* [PR 10715](https://github.com/spyder-ide/spyder/pull/10715) - PR: Add restart option to PluginConfigPage
* [PR 10713](https://github.com/spyder-ide/spyder/pull/10713) - PR: Show the recovery dialog on top of the splash screen
* [PR 10711](https://github.com/spyder-ide/spyder/pull/10711) - PR: Reenable path manager sync on windows ([10686](https://github.com/spyder-ide/spyder/issues/10686))
* [PR 10708](https://github.com/spyder-ide/spyder/pull/10708) - PR: Minor improvements to the shortcut editor
* [PR 10698](https://github.com/spyder-ide/spyder/pull/10698) - PR: Sort items in Switcher in ascending order and move logic to filter items in the proxy model ([10682](https://github.com/spyder-ide/spyder/issues/10682))
* [PR 10695](https://github.com/spyder-ide/spyder/pull/10695) - PR: Use IPython completer for Pdb ([10696](https://github.com/spyder-ide/spyder/issues/10696))
* [PR 10688](https://github.com/spyder-ide/spyder/pull/10688) - PR: Fix completion of function/method definition in Kite ([10650](https://github.com/spyder-ide/spyder/issues/10650))
* [PR 10685](https://github.com/spyder-ide/spyder/pull/10685) - PR: Fix Fileswitcher for 'EditorStack' instances #2 ([10684](https://github.com/spyder-ide/spyder/issues/10684))
* [PR 10683](https://github.com/spyder-ide/spyder/pull/10683) - PR: Make the list view of the file switcher look active at all times.
* [PR 10677](https://github.com/spyder-ide/spyder/pull/10677) - PR: Make to HTMLDelegate drawControl
* [PR 10662](https://github.com/spyder-ide/spyder/pull/10662) - PR: Fix handling of inotify error ([10653](https://github.com/spyder-ide/spyder/issues/10653))
* [PR 10659](https://github.com/spyder-ide/spyder/pull/10659) - PR: Calculate switcher items height from content, padding and font size instead of hard-coded values
* [PR 10654](https://github.com/spyder-ide/spyder/pull/10654) - PR: Display file match items on one line in the find in files browser
* [PR 10648](https://github.com/spyder-ide/spyder/pull/10648) - PR: Send Kite completions requests correctly for selections
* [PR 10644](https://github.com/spyder-ide/spyder/pull/10644) - PR: Prevent status bar widget blinking during startup
* [PR 10638](https://github.com/spyder-ide/spyder/pull/10638) - PR: Trigger completions after braces ([10275](https://github.com/spyder-ide/spyder/issues/10275))
* [PR 10635](https://github.com/spyder-ide/spyder/pull/10635) - PR: Don't mark files as dirty if "Save as" operation is canceled ([9865](https://github.com/spyder-ide/spyder/issues/9865))
* [PR 10631](https://github.com/spyder-ide/spyder/pull/10631) - PR: Don't repeatedly request Kite onboarding file
* [PR 10630](https://github.com/spyder-ide/spyder/pull/10630) - PR: Fix completions bug in Kite introduced by PR 10605
* [PR 10629](https://github.com/spyder-ide/spyder/pull/10629) - PR: Add LSP support for handling jedi script extra paths and environment ([10646](https://github.com/spyder-ide/spyder/issues/10646), [10299](https://github.com/spyder-ide/spyder/issues/10299), [1004](https://github.com/spyder-ide/spyder/issues/1004))
* [PR 10623](https://github.com/spyder-ide/spyder/pull/10623) - PR: Improve path manager
* [PR 10615](https://github.com/spyder-ide/spyder/pull/10615) - PR: Prevent reload of kite onboarding file ([10609](https://github.com/spyder-ide/spyder/issues/10609))
* [PR 10607](https://github.com/spyder-ide/spyder/pull/10607) - PR: Fix 'run file' project explorer action and add test for it ([10590](https://github.com/spyder-ide/spyder/issues/10590))
* [PR 10605](https://github.com/spyder-ide/spyder/pull/10605) - PR: Filter completions with an empty value for the 'insertText' key ([10593](https://github.com/spyder-ide/spyder/issues/10593))
* [PR 10587](https://github.com/spyder-ide/spyder/pull/10587) - PR: Split slow and fast tests in different slots on Travis and Azure
* [PR 10582](https://github.com/spyder-ide/spyder/pull/10582) - PR: Add results in batches and limit results on Find pane to a maximum ([10264](https://github.com/spyder-ide/spyder/issues/10264))
* [PR 10567](https://github.com/spyder-ide/spyder/pull/10567) - PR: Add button and keyboard shortcut to refresh the variable explorer during execution ([4398](https://github.com/spyder-ide/spyder/issues/4398))
* [PR 10565](https://github.com/spyder-ide/spyder/pull/10565) - PR: Improve cell name detection and run cells with the right namespace while debugging ([10563](https://github.com/spyder-ide/spyder/issues/10563))
* [PR 10560](https://github.com/spyder-ide/spyder/pull/10560) - PR: Add methods to handle external plugins shortcuts ([3321](https://github.com/spyder-ide/spyder/issues/3321), [3254](https://github.com/spyder-ide/spyder/issues/3254))
* [PR 10549](https://github.com/spyder-ide/spyder/pull/10549) - PR: Add scrollbar to autosave dialog ([9125](https://github.com/spyder-ide/spyder/issues/9125))
* [PR 10546](https://github.com/spyder-ide/spyder/pull/10546) - PR: Improvements to the Object Explorer (font, resize, and actions over row) ([10537](https://github.com/spyder-ide/spyder/issues/10537))
* [PR 10527](https://github.com/spyder-ide/spyder/pull/10527) - PR: Add an option to execute IPython events while debugging
* [PR 10450](https://github.com/spyder-ide/spyder/pull/10450) - PR: Increase timeout for several calls to the kernel ([10449](https://github.com/spyder-ide/spyder/issues/10449))

In this release 41 pull requests were closed.


----


## Version 4.0rc1 (2019-11-03)

### Issues Closed

* [Issue 10571](https://github.com/spyder-ide/spyder/issues/10571) - Update Kite link in call-to-action ([PR 10579](https://github.com/spyder-ide/spyder/pull/10579))
* [Issue 10489](https://github.com/spyder-ide/spyder/issues/10489) - Cannot remove thumbnails on Plots pane ([PR 10508](https://github.com/spyder-ide/spyder/pull/10508))
* [Issue 10478](https://github.com/spyder-ide/spyder/issues/10478) - "OSError: inotify watch limit reached" with many files in a project ([PR 10480](https://github.com/spyder-ide/spyder/pull/10480))
* [Issue 10457](https://github.com/spyder-ide/spyder/issues/10457) - Decreasing automatic_completions_after_ms setting causes lag when typing ([PR 10502](https://github.com/spyder-ide/spyder/pull/10502))
* [Issue 10453](https://github.com/spyder-ide/spyder/issues/10453) - Completion before ")" causes internal problem. ([PR 10454](https://github.com/spyder-ide/spyder/pull/10454))
* [Issue 10448](https://github.com/spyder-ide/spyder/issues/10448) - Autocompletions not working inside function calls ([PR 10510](https://github.com/spyder-ide/spyder/pull/10510))
* [Issue 10447](https://github.com/spyder-ide/spyder/issues/10447) - Kite completions not being shown ([PR 10509](https://github.com/spyder-ide/spyder/pull/10509))
* [Issue 10442](https://github.com/spyder-ide/spyder/issues/10442) - The kite logo on the status bar is pixelated on retina display: ([PR 10483](https://github.com/spyder-ide/spyder/pull/10483))
* [Issue 10439](https://github.com/spyder-ide/spyder/issues/10439) - Another TypeError when going to definition ([PR 10479](https://github.com/spyder-ide/spyder/pull/10479))
* [Issue 10436](https://github.com/spyder-ide/spyder/issues/10436) - Spyder executable file opened on launch ([PR 10443](https://github.com/spyder-ide/spyder/pull/10443))
* [Issue 10430](https://github.com/spyder-ide/spyder/issues/10430) - UnicodeEncodeError for Kite engine ([PR 10433](https://github.com/spyder-ide/spyder/pull/10433))
* [Issue 10401](https://github.com/spyder-ide/spyder/issues/10401) - No completions returned from Kite after unicode emoji ([PR 10459](https://github.com/spyder-ide/spyder/pull/10459))
* [Issue 10349](https://github.com/spyder-ide/spyder/issues/10349) - Kite autosearch docs not working on mouse events ([PR 10541](https://github.com/spyder-ide/spyder/pull/10541))
* [Issue 10131](https://github.com/spyder-ide/spyder/issues/10131) - Can't click in tooltip because it disappears ([PR 10568](https://github.com/spyder-ide/spyder/pull/10568))
* [Issue 10045](https://github.com/spyder-ide/spyder/issues/10045) - ValueError when closing project on USB stick ([PR 10419](https://github.com/spyder-ide/spyder/pull/10419))
* [Issue 9900](https://github.com/spyder-ide/spyder/issues/9900) - Remove old defaults for spyder ([PR 10180](https://github.com/spyder-ide/spyder/pull/10180))
* [Issue 9805](https://github.com/spyder-ide/spyder/issues/9805) - Update configuration manager to handle site/system level configuration ([PR 10180](https://github.com/spyder-ide/spyder/pull/10180))
* [Issue 5970](https://github.com/spyder-ide/spyder/issues/5970) - When newly created, unsaved file open, running any file triggers the save as dialog ([PR 10115](https://github.com/spyder-ide/spyder/pull/10115))
* [Issue 3232](https://github.com/spyder-ide/spyder/issues/3232) - Add "step into my code" option to the debugger ([PR 10199](https://github.com/spyder-ide/spyder/pull/10199))
* [Issue 2902](https://github.com/spyder-ide/spyder/issues/2902) - Very slow line execution using IPython in macOS

In this release 20 issues were closed.

### Pull Requests Merged

* [PR 10586](https://github.com/spyder-ide/spyder/pull/10586) - PR: Update minimal required version of spyder-kernels
* [PR 10579](https://github.com/spyder-ide/spyder/pull/10579) - PR: Update Kite installer links & remove centering logic ([10571](https://github.com/spyder-ide/spyder/issues/10571))
* [PR 10568](https://github.com/spyder-ide/spyder/pull/10568) - PR: Fix tooltip for hints position ([10131](https://github.com/spyder-ide/spyder/issues/10131))
* [PR 10548](https://github.com/spyder-ide/spyder/pull/10548) - PR: Fix error in Azure when trying to update conda
* [PR 10544](https://github.com/spyder-ide/spyder/pull/10544) - PR: Move runcell test to a better place
* [PR 10541](https://github.com/spyder-ide/spyder/pull/10541) - PR: Retrieve Kite copilot documentation on click ([10349](https://github.com/spyder-ide/spyder/issues/10349))
* [PR 10539](https://github.com/spyder-ide/spyder/pull/10539) - PR: Replace usage of localhost for 127.0.0.1
* [PR 10533](https://github.com/spyder-ide/spyder/pull/10533) - PR: Handle case where a line is destroyed in outline explorer
* [PR 10529](https://github.com/spyder-ide/spyder/pull/10529) - PR: Fix errors when updating menus and the editor was not fully loaded
* [PR 10512](https://github.com/spyder-ide/spyder/pull/10512) - PR: Fix blocknumber segfault
* [PR 10510](https://github.com/spyder-ide/spyder/pull/10510) - PR: Fix on the fly completions inside braces ([10448](https://github.com/spyder-ide/spyder/issues/10448))
* [PR 10509](https://github.com/spyder-ide/spyder/pull/10509) - PR: Add a "wait_for" timeout for completions ([10447](https://github.com/spyder-ide/spyder/issues/10447))
* [PR 10508](https://github.com/spyder-ide/spyder/pull/10508) - PR: Remove thumbnails on plots pane successfully ([10489](https://github.com/spyder-ide/spyder/issues/10489))
* [PR 10504](https://github.com/spyder-ide/spyder/pull/10504) - PR: Correctly handle Kite replacement range, fixing dict completions
* [PR 10502](https://github.com/spyder-ide/spyder/pull/10502) - PR: Completions performance improvements ([10457](https://github.com/spyder-ide/spyder/issues/10457))
* [PR 10496](https://github.com/spyder-ide/spyder/pull/10496) - PR: Print info_page content in the IPython console tests
* [PR 10486](https://github.com/spyder-ide/spyder/pull/10486) - PR: Clear logs menu to avoid creating duplicates
* [PR 10483](https://github.com/spyder-ide/spyder/pull/10483) - PR: Fix kite logo for OSX ([10442](https://github.com/spyder-ide/spyder/issues/10442))
* [PR 10480](https://github.com/spyder-ide/spyder/pull/10480) - PR: Handle inotify error on Linux ([10478](https://github.com/spyder-ide/spyder/issues/10478))
* [PR 10479](https://github.com/spyder-ide/spyder/pull/10479) - PR: Make default responses of completion plugins to be None ([10439](https://github.com/spyder-ide/spyder/issues/10439))
* [PR 10476](https://github.com/spyder-ide/spyder/pull/10476) - PR: Remove deleteLater calls
* [PR 10468](https://github.com/spyder-ide/spyder/pull/10468) - PR: Cleanup test_mainwindow tests
* [PR 10466](https://github.com/spyder-ide/spyder/pull/10466) - PR: Use pytest-faulthandler to debug segmentation faults in our tests
* [PR 10465](https://github.com/spyder-ide/spyder/pull/10465) - PR: Update kite test
* [PR 10464](https://github.com/spyder-ide/spyder/pull/10464) - PR: Print shell content upon failure and try to correct segfaults in IPython console tests
* [PR 10459](https://github.com/spyder-ide/spyder/pull/10459) - PR: Send correct Unicode offset encoding to Kite ([10401](https://github.com/spyder-ide/spyder/issues/10401))
* [PR 10454](https://github.com/spyder-ide/spyder/pull/10454) - PR: Check length of parameters when trying to parse signatures ([10453](https://github.com/spyder-ide/spyder/issues/10453))
* [PR 10444](https://github.com/spyder-ide/spyder/pull/10444) - PR: Use a single main window instance to run all its tests
* [PR 10443](https://github.com/spyder-ide/spyder/pull/10443) - PR: Skip opening launch script in macOS application ([10436](https://github.com/spyder-ide/spyder/issues/10436))
* [PR 10438](https://github.com/spyder-ide/spyder/pull/10438) - PR: Use a new comm socket for comms
* [PR 10433](https://github.com/spyder-ide/spyder/pull/10433) - PR: Fix encoding issues when using Python 2 ([10430](https://github.com/spyder-ide/spyder/issues/10430))
* [PR 10419](https://github.com/spyder-ide/spyder/pull/10419) - PR: Handle paths for recent files on a different mount than the project root path ([10045](https://github.com/spyder-ide/spyder/issues/10045))
* [PR 10414](https://github.com/spyder-ide/spyder/pull/10414) - PR: Register Spyder with macOS launch services
* [PR 10260](https://github.com/spyder-ide/spyder/pull/10260) - PR: Show Kite onboarding file once after Kite was installed
* [PR 10199](https://github.com/spyder-ide/spyder/pull/10199) - PR: Add an option to ignore installed Python libraries while debugging ([3232](https://github.com/spyder-ide/spyder/issues/3232))
* [PR 10180](https://github.com/spyder-ide/spyder/pull/10180) - PR: Add global and environment configuration paths to load default options from them ([9900](https://github.com/spyder-ide/spyder/issues/9900), [9805](https://github.com/spyder-ide/spyder/issues/9805))
* [PR 10115](https://github.com/spyder-ide/spyder/pull/10115) - PR: Run and debug files without saving them ([5970](https://github.com/spyder-ide/spyder/issues/5970))
* [PR 10111](https://github.com/spyder-ide/spyder/pull/10111) - PR: Kill LSP transport layer if Spyder gets killed

In this release 38 pull requests were closed.


----


## Version 4.0beta7 (2019-10-17)

### Issues Closed

* [Issue 10424](https://github.com/spyder-ide/spyder/issues/10424) - Kite call-to-action consistently causes a Spyder hard crash ([PR 10432](https://github.com/spyder-ide/spyder/pull/10432))
* [Issue 10404](https://github.com/spyder-ide/spyder/issues/10404) - TypeError in go-to-definition ([PR 10399](https://github.com/spyder-ide/spyder/pull/10399))
* [Issue 10388](https://github.com/spyder-ide/spyder/issues/10388) - Big toolip when using kite ([PR 10405](https://github.com/spyder-ide/spyder/pull/10405))
* [Issue 10372](https://github.com/spyder-ide/spyder/issues/10372) - IndexError when autocompleting using Kite ([PR 10418](https://github.com/spyder-ide/spyder/pull/10418))
* [Issue 10351](https://github.com/spyder-ide/spyder/issues/10351) - Syntax coloring  incorrect with import as statements ([PR 10421](https://github.com/spyder-ide/spyder/pull/10421))
* [Issue 10335](https://github.com/spyder-ide/spyder/issues/10335) - Editor plugin not raised after selecting file in Switcher ([PR 10420](https://github.com/spyder-ide/spyder/pull/10420))
* [Issue 10290](https://github.com/spyder-ide/spyder/issues/10290) - Deleting line when breakpoint it set causes crash
* [Issue 9356](https://github.com/spyder-ide/spyder/issues/9356) - UnicodeEncodeError when pylint tries to print non-ascii character ([PR 9851](https://github.com/spyder-ide/spyder/pull/9851))
* [Issue 7787](https://github.com/spyder-ide/spyder/issues/7787) - Suppress ipdb output during debug ([PR 10207](https://github.com/spyder-ide/spyder/pull/10207))
* [Issue 7031](https://github.com/spyder-ide/spyder/issues/7031) - Profiler raises a UnicodeEncodeError when non-ASCII characters are printed by the source file ([PR 9851](https://github.com/spyder-ide/spyder/pull/9851))
* [Issue 1643](https://github.com/spyder-ide/spyder/issues/1643) - Spyder does not fully support IPython scripts (*.ipy)
* [Issue 1073](https://github.com/spyder-ide/spyder/issues/1073) - Debugging: Unable to run selection while debugging ([PR 10190](https://github.com/spyder-ide/spyder/pull/10190))
* [Issue 288](https://github.com/spyder-ide/spyder/issues/288) - Code completion doesn't work in the debugger

In this release 13 issues were closed.

### Pull Requests Merged

* [PR 10434](https://github.com/spyder-ide/spyder/pull/10434) - PR: Increase minimal required version of spyder-kernels to 1.6
* [PR 10432](https://github.com/spyder-ide/spyder/pull/10432) - PR: Add bloom files to our tarballs ([10424](https://github.com/spyder-ide/spyder/issues/10424))
* [PR 10421](https://github.com/spyder-ide/spyder/pull/10421) - PR: Update highlighter regex for 'as' keyword ([10351](https://github.com/spyder-ide/spyder/issues/10351))
* [PR 10420](https://github.com/spyder-ide/spyder/pull/10420) - PR: Editor plugin is raised after selecting file in the switcher ([10335](https://github.com/spyder-ide/spyder/issues/10335))
* [PR 10418](https://github.com/spyder-ide/spyder/pull/10418) - PR: Check length of parameters data vs active parameter index ([10372](https://github.com/spyder-ide/spyder/issues/10372))
* [PR 10413](https://github.com/spyder-ide/spyder/pull/10413) - PR: Don't use PyLS 0.29 for now in our tests
* [PR 10411](https://github.com/spyder-ide/spyder/pull/10411) - PR: Add validation for number of parameters in function calltip ([10408](https://github.com/spyder-ide/spyder/issues/10408))
* [PR 10405](https://github.com/spyder-ide/spyder/pull/10405) - PR: Add validation for completion signature processing ([10388](https://github.com/spyder-ide/spyder/issues/10388))
* [PR 10403](https://github.com/spyder-ide/spyder/pull/10403) - PR: Improve LSP support for MarkupString[] for hover requests
* [PR 10399](https://github.com/spyder-ide/spyder/pull/10399) - PR: Fix deadlock when going to a definition ([10404](https://github.com/spyder-ide/spyder/issues/10404))
* [PR 10327](https://github.com/spyder-ide/spyder/pull/10327) - PR: Try opening closed files in the frontend side
* [PR 10207](https://github.com/spyder-ide/spyder/pull/10207) - PR: Disable printing stack when using debug buttons ([7787](https://github.com/spyder-ide/spyder/issues/7787))
* [PR 10190](https://github.com/spyder-ide/spyder/pull/10190) - PR: Full multiline support and better history management for the debugger ([1073](https://github.com/spyder-ide/spyder/issues/1073))
* [PR 10153](https://github.com/spyder-ide/spyder/pull/10153) - PR: Add console handler to send file contents to the kernel during execution
* [PR 9940](https://github.com/spyder-ide/spyder/pull/9940) - PR: Add autocomplete to the debugger
* [PR 9851](https://github.com/spyder-ide/spyder/pull/9851) - PR: Set encoding to utf8 for Profiler and Pylint processes ([9356](https://github.com/spyder-ide/spyder/issues/9356), [7031](https://github.com/spyder-ide/spyder/issues/7031))

In this release 16 pull requests were closed.


----


## Version 4.0beta6 (2019-10-14)

### Issues Closed

* [Issue 10352](https://github.com/spyder-ide/spyder/issues/10352) - An error occurs when autocompleting 'subplots' using kite. ([PR 10365](https://github.com/spyder-ide/spyder/pull/10365))
* [Issue 10331](https://github.com/spyder-ide/spyder/issues/10331) - Automatic_completions* options not being set at startup ([PR 10348](https://github.com/spyder-ide/spyder/pull/10348))
* [Issue 10308](https://github.com/spyder-ide/spyder/issues/10308) - A file switcher test is failing on master ([PR 10309](https://github.com/spyder-ide/spyder/pull/10309))
* [Issue 10296](https://github.com/spyder-ide/spyder/issues/10296) - Portuguese (BRAZIL) minor error ([PR 10344](https://github.com/spyder-ide/spyder/pull/10344))
* [Issue 10289](https://github.com/spyder-ide/spyder/issues/10289) - crash in 4.0.0b5 related to non-ascii characters and tooltips ([PR 10256](https://github.com/spyder-ide/spyder/pull/10256))
* [Issue 10284](https://github.com/spyder-ide/spyder/issues/10284) - Can not change font ([PR 10306](https://github.com/spyder-ide/spyder/pull/10306))
* [Issue 10255](https://github.com/spyder-ide/spyder/issues/10255) - Selected figure thumbnail in Plots not highlighted in dark mode ([PR 10259](https://github.com/spyder-ide/spyder/pull/10259))
* [Issue 10248](https://github.com/spyder-ide/spyder/issues/10248) - Trailing spaces are being removed on line change even if the option is unset in preferences ([PR 10261](https://github.com/spyder-ide/spyder/pull/10261))
* [Issue 10235](https://github.com/spyder-ide/spyder/issues/10235) - Completions docs UI shows docs for wrong completion ([PR 10262](https://github.com/spyder-ide/spyder/pull/10262))
* [Issue 10230](https://github.com/spyder-ide/spyder/issues/10230) - Several errors with code snippets ([PR 10256](https://github.com/spyder-ide/spyder/pull/10256))
* [Issue 10227](https://github.com/spyder-ide/spyder/issues/10227) - Kite completions ordering is not respected ([PR 10301](https://github.com/spyder-ide/spyder/pull/10301))
* [Issue 10226](https://github.com/spyder-ide/spyder/issues/10226) - Kite (and LSP) completions frequently not displayed ([PR 10301](https://github.com/spyder-ide/spyder/pull/10301))
* [Issue 10214](https://github.com/spyder-ide/spyder/issues/10214) - Minimal pyxdg version not set in setup.py ([PR 10218](https://github.com/spyder-ide/spyder/pull/10218))
* [Issue 10208](https://github.com/spyder-ide/spyder/issues/10208) - OSError when saving files on Linux ([PR 10236](https://github.com/spyder-ide/spyder/pull/10236))
* [Issue 10203](https://github.com/spyder-ide/spyder/issues/10203) - IndexError in Kite completitons  ([PR 10216](https://github.com/spyder-ide/spyder/pull/10216))
* [Issue 10141](https://github.com/spyder-ide/spyder/issues/10141) - Ctrl+I doesn't work in editor when hovers are deactivated ([PR 10254](https://github.com/spyder-ide/spyder/pull/10254))
* [Issue 10134](https://github.com/spyder-ide/spyder/issues/10134) - On the fly code completion interferes with normal typing ([PR 10262](https://github.com/spyder-ide/spyder/pull/10262))
* [Issue 10118](https://github.com/spyder-ide/spyder/issues/10118) - Open Collective ([PR 10237](https://github.com/spyder-ide/spyder/pull/10237))
* [Issue 10071](https://github.com/spyder-ide/spyder/issues/10071) - Kite is always started ([PR 10354](https://github.com/spyder-ide/spyder/pull/10354))
* [Issue 9992](https://github.com/spyder-ide/spyder/issues/9992) - Completion stopped working after switching to "This is an external server" ([PR 10278](https://github.com/spyder-ide/spyder/pull/10278))
* [Issue 7008](https://github.com/spyder-ide/spyder/issues/7008) - Keyboard shortcut dialog unuseable / crash ([PR 10215](https://github.com/spyder-ide/spyder/pull/10215))

In this release 21 issues were closed.

### Pull Requests Merged

* [PR 10370](https://github.com/spyder-ide/spyder/pull/10370) - PR: Remove extraneous Kite config option
* [PR 10365](https://github.com/spyder-ide/spyder/pull/10365) - PR: Fix Kite error when args in signature is None ([10352](https://github.com/spyder-ide/spyder/issues/10352))
* [PR 10358](https://github.com/spyder-ide/spyder/pull/10358) - PR: Update test_c_and_n_pdb_commands test
* [PR 10354](https://github.com/spyder-ide/spyder/pull/10354) - PR: Enable better configuration of completions clients ([10071](https://github.com/spyder-ide/spyder/issues/10071))
* [PR 10348](https://github.com/spyder-ide/spyder/pull/10348) - PR: Apply autocompletion options at startup ([10331](https://github.com/spyder-ide/spyder/issues/10331))
* [PR 10344](https://github.com/spyder-ide/spyder/pull/10344) - PR: Fix error in Portuguese translation ([10296](https://github.com/spyder-ide/spyder/issues/10296))
* [PR 10338](https://github.com/spyder-ide/spyder/pull/10338) - PR: Add LSP log option when spyder is in debug mode
* [PR 10332](https://github.com/spyder-ide/spyder/pull/10332) - PR: Add a call-to-action for Kite
* [PR 10324](https://github.com/spyder-ide/spyder/pull/10324) - PR: Add branding for code snippet completions
* [PR 10321](https://github.com/spyder-ide/spyder/pull/10321) - PR: Show exact match completions
* [PR 10314](https://github.com/spyder-ide/spyder/pull/10314) - PR: Fix tests on Windows
* [PR 10309](https://github.com/spyder-ide/spyder/pull/10309) - PR: Fix test and path shortening for the switcher ([10308](https://github.com/spyder-ide/spyder/issues/10308))
* [PR 10306](https://github.com/spyder-ide/spyder/pull/10306) - PR: Fix regression for set_font method ([10284](https://github.com/spyder-ide/spyder/issues/10284))
* [PR 10301](https://github.com/spyder-ide/spyder/pull/10301) - PR: Fix completions prioritization and Kite completions behavior ([10227](https://github.com/spyder-ide/spyder/issues/10227), [10226](https://github.com/spyder-ide/spyder/issues/10226))
* [PR 10278](https://github.com/spyder-ide/spyder/pull/10278) - PR: Add several validations for external LSP servers ([9992](https://github.com/spyder-ide/spyder/issues/9992))
* [PR 10270](https://github.com/spyder-ide/spyder/pull/10270) - PR: Fix regression and add test for language selection on preferences
* [PR 10262](https://github.com/spyder-ide/spyder/pull/10262) - PR: Add delay and minimum chars to on the fly completions ([10235](https://github.com/spyder-ide/spyder/issues/10235), [10134](https://github.com/spyder-ide/spyder/issues/10134))
* [PR 10261](https://github.com/spyder-ide/spyder/pull/10261) - PR: Only remove trailing spaces when option is turned on in Preferences ([10248](https://github.com/spyder-ide/spyder/issues/10248))
* [PR 10259](https://github.com/spyder-ide/spyder/pull/10259) - PR: Better highlight selected figure in thumbnail. ([10255](https://github.com/spyder-ide/spyder/issues/10255))
* [PR 10256](https://github.com/spyder-ide/spyder/pull/10256) - PR: Fix several code snippets corner cases ([10289](https://github.com/spyder-ide/spyder/issues/10289), [10230](https://github.com/spyder-ide/spyder/issues/10230))
* [PR 10254](https://github.com/spyder-ide/spyder/pull/10254) - PR: Always enable hovers on the PyLS ([10141](https://github.com/spyder-ide/spyder/issues/10141))
* [PR 10253](https://github.com/spyder-ide/spyder/pull/10253) - PR: Move some options from editor to LSP Preferences page
* [PR 10252](https://github.com/spyder-ide/spyder/pull/10252) - PR: Add ability to modify other plugin options
* [PR 10251](https://github.com/spyder-ide/spyder/pull/10251) - PR: Add an installation UI for Kite
* [PR 10249](https://github.com/spyder-ide/spyder/pull/10249) - PR: Avoid stripping if the event comes from another editor
* [PR 10237](https://github.com/spyder-ide/spyder/pull/10237) - PR: Add open collective funding button ([10118](https://github.com/spyder-ide/spyder/issues/10118))
* [PR 10236](https://github.com/spyder-ide/spyder/pull/10236) - PR: Fix OSError when saving files on Linux ([10208](https://github.com/spyder-ide/spyder/issues/10208))
* [PR 10233](https://github.com/spyder-ide/spyder/pull/10233) - PR: Send current cursor position to Kite to enable autosearch in Kite Copilot
* [PR 10220](https://github.com/spyder-ide/spyder/pull/10220) - PR: Catch errors when sending messages to tcp sockets that reject a connection from our LSP client
* [PR 10219](https://github.com/spyder-ide/spyder/pull/10219) - PR: Create LSP logs for all active instances of Spyder
* [PR 10218](https://github.com/spyder-ide/spyder/pull/10218) - PR: Add minimal requirement for pyxdg to 0.26 ([10214](https://github.com/spyder-ide/spyder/issues/10214))
* [PR 10216](https://github.com/spyder-ide/spyder/pull/10216) - PR: Fix signature processing when no signature is retrieved with Kite ([10203](https://github.com/spyder-ide/spyder/issues/10203))
* [PR 10215](https://github.com/spyder-ide/spyder/pull/10215) - PR: Fix keyboard shortcut dialog crash ([7008](https://github.com/spyder-ide/spyder/issues/7008))
* [PR 10211](https://github.com/spyder-ide/spyder/pull/10211) - PR: Fix connection to an external LSP server
* [PR 10205](https://github.com/spyder-ide/spyder/pull/10205) - PR: Add checkbox to verify changes in advanced options of LSP preferences
* [PR 10179](https://github.com/spyder-ide/spyder/pull/10179) - PR: Implement Kite installation logic
* [PR 10166](https://github.com/spyder-ide/spyder/pull/10166) - PR: Add status bar widget for Kite

In this release 37 pull requests were closed.


----


## Version 4.0beta5 (2019-09-15)

### Issues Closed

* [Issue 10176](https://github.com/spyder-ide/spyder/issues/10176) - Handle connection errors when quitting Kite outside Spyder ([PR 10177](https://github.com/spyder-ide/spyder/pull/10177))
* [Issue 10159](https://github.com/spyder-ide/spyder/issues/10159) - TypeError in kite client ([PR 10173](https://github.com/spyder-ide/spyder/pull/10173))
* [Issue 10139](https://github.com/spyder-ide/spyder/issues/10139) - 'Enable docstring style linting' setting not saved in Preferences ([PR 10145](https://github.com/spyder-ide/spyder/pull/10145))
* [Issue 10138](https://github.com/spyder-ide/spyder/issues/10138) - Spyder hangs if you open the Issue reporter while Preferences is open ([PR 10142](https://github.com/spyder-ide/spyder/pull/10142))
* [Issue 10136](https://github.com/spyder-ide/spyder/issues/10136) - Issue reporter misbehaves if you delete characters of the header with the Delete key ([PR 10140](https://github.com/spyder-ide/spyder/pull/10140))
* [Issue 10135](https://github.com/spyder-ide/spyder/issues/10135) - Issue reporter dialog should not be modal ([PR 10143](https://github.com/spyder-ide/spyder/pull/10143))
* [Issue 10109](https://github.com/spyder-ide/spyder/issues/10109) - Incorrect Kite completions ordering ([PR 10110](https://github.com/spyder-ide/spyder/pull/10110))
* [Issue 10073](https://github.com/spyder-ide/spyder/issues/10073) - Outline links to editor wrong when code is folded ([PR 10074](https://github.com/spyder-ide/spyder/pull/10074))
* [Issue 10048](https://github.com/spyder-ide/spyder/issues/10048) - runfile breaks debugfile ([PR 10047](https://github.com/spyder-ide/spyder/pull/10047))
* [Issue 10039](https://github.com/spyder-ide/spyder/issues/10039) - Editor has several problems to handle emojis ([PR 10043](https://github.com/spyder-ide/spyder/pull/10043))
* [Issue 10038](https://github.com/spyder-ide/spyder/issues/10038) - KeyError when autosaving file ([PR 10100](https://github.com/spyder-ide/spyder/pull/10100))
* [Issue 10029](https://github.com/spyder-ide/spyder/issues/10029) - Ignore ConnectionError on Kite completions request ([PR 10076](https://github.com/spyder-ide/spyder/pull/10076))
* [Issue 10014](https://github.com/spyder-ide/spyder/issues/10014) - "Projects > Recent" always opens last project ([PR 10035](https://github.com/spyder-ide/spyder/pull/10035))
* [Issue 10011](https://github.com/spyder-ide/spyder/issues/10011) - re.error when getting signature in the editor ([PR 10016](https://github.com/spyder-ide/spyder/pull/10016))
* [Issue 10002](https://github.com/spyder-ide/spyder/issues/10002) - Remove "No match" entry in editor's code completion widget ([PR 10007](https://github.com/spyder-ide/spyder/pull/10007))
* [Issue 9996](https://github.com/spyder-ide/spyder/issues/9996) - Resize in dataframe viewer does not honor column name length ([PR 10017](https://github.com/spyder-ide/spyder/pull/10017))
* [Issue 9993](https://github.com/spyder-ide/spyder/issues/9993) - TypeError in Kite client ([PR 10076](https://github.com/spyder-ide/spyder/pull/10076))
* [Issue 9973](https://github.com/spyder-ide/spyder/issues/9973) - Sorting is not right when viewing a list in the Variable Explorer ([PR 9980](https://github.com/spyder-ide/spyder/pull/9980))
* [Issue 9963](https://github.com/spyder-ide/spyder/issues/9963) - Running an empty cell is broken ([PR 9014](https://github.com/spyder-ide/spyder/pull/9014))
* [Issue 9959](https://github.com/spyder-ide/spyder/issues/9959) -  TypeError in object explorer ([PR 9967](https://github.com/spyder-ide/spyder/pull/9967))
* [Issue 9950](https://github.com/spyder-ide/spyder/issues/9950) - Syntax Highlighter is supressing outlined QTextCharFormat style ([PR 10137](https://github.com/spyder-ide/spyder/pull/10137))
* [Issue 9933](https://github.com/spyder-ide/spyder/issues/9933) - PyLS settings are not being applied live ([PR 10164](https://github.com/spyder-ide/spyder/pull/10164))
* [Issue 9924](https://github.com/spyder-ide/spyder/issues/9924) - Warning/error on last row not in warning list ([PR 9943](https://github.com/spyder-ide/spyder/pull/9943))
* [Issue 9796](https://github.com/spyder-ide/spyder/issues/9796) - Centralize all dependencies in one place and declare all the ones present in setup.py ([PR 9975](https://github.com/spyder-ide/spyder/pull/9975))
* [Issue 9747](https://github.com/spyder-ide/spyder/issues/9747) - Separator on plots plugin acts more like a button than a resize area ([PR 9720](https://github.com/spyder-ide/spyder/pull/9720))
* [Issue 9568](https://github.com/spyder-ide/spyder/issues/9568) - Implement code snippets for completions ([PR 9850](https://github.com/spyder-ide/spyder/pull/9850))
* [Issue 9516](https://github.com/spyder-ide/spyder/issues/9516) - Variable Explorer bug when sorting by 'size' ([PR 9980](https://github.com/spyder-ide/spyder/pull/9980))
* [Issue 9420](https://github.com/spyder-ide/spyder/issues/9420) - FileNotFoundError when closing a file that's opened in several Spyder instances ([PR 10077](https://github.com/spyder-ide/spyder/pull/10077))
* [Issue 9361](https://github.com/spyder-ide/spyder/issues/9361) - Add a command to debug a single cell ([PR 9014](https://github.com/spyder-ide/spyder/pull/9014))
* [Issue 9342](https://github.com/spyder-ide/spyder/issues/9342) - File not saved when calling runfile from console ([PR 9966](https://github.com/spyder-ide/spyder/pull/9966))
* [Issue 9246](https://github.com/spyder-ide/spyder/issues/9246) - Set icons for other completion kind items ([PR 9897](https://github.com/spyder-ide/spyder/pull/9897))
* [Issue 9198](https://github.com/spyder-ide/spyder/issues/9198) - Make changing the working directory via the toolbar work with local external Spyder kernels ([PR 9999](https://github.com/spyder-ide/spyder/pull/9999))
* [Issue 9197](https://github.com/spyder-ide/spyder/issues/9197) - Plots plugin doesn't show plots generated in local, external Spyder kernels ([PR 10001](https://github.com/spyder-ide/spyder/pull/10001))
* [Issue 8580](https://github.com/spyder-ide/spyder/issues/8580) - Improvements to the File switcher ([PR 10060](https://github.com/spyder-ide/spyder/pull/10060))
* [Issue 7377](https://github.com/spyder-ide/spyder/issues/7377) - Indentation errors for fuction calls with `#` in a string ([PR 9566](https://github.com/spyder-ide/spyder/pull/9566))
* [Issue 5606](https://github.com/spyder-ide/spyder/issues/5606) - Editor sets incorrect indent when character immediately before the break is a paren ([PR 9566](https://github.com/spyder-ide/spyder/pull/9566))
* [Issue 4180](https://github.com/spyder-ide/spyder/issues/4180) - It should be possible to get the same behaviour with Spyder's Run button than with IPython's %run
* [Issue 3798](https://github.com/spyder-ide/spyder/issues/3798) - Invert colors for "Pretty-Printing" symbolic math in IPython's dark background ([PR 10114](https://github.com/spyder-ide/spyder/pull/10114))
* [Issue 3181](https://github.com/spyder-ide/spyder/issues/3181) - Show signature to the right of the completion widget ([PR 9897](https://github.com/spyder-ide/spyder/pull/9897))
* [Issue 2871](https://github.com/spyder-ide/spyder/issues/2871) - Hide completion widget when scrolling up and down ([PR 9897](https://github.com/spyder-ide/spyder/pull/9897))
* [Issue 887](https://github.com/spyder-ide/spyder/issues/887) - Fix issues with incorrect auto-indentation ([PR 9566](https://github.com/spyder-ide/spyder/pull/9566))

In this release 41 issues were closed.

### Pull Requests Merged

* [PR 10202](https://github.com/spyder-ide/spyder/pull/10202) - PR: Update spyder-kernels and PyLS minimal required versions
* [PR 10196](https://github.com/spyder-ide/spyder/pull/10196) - PR: Detect zombie process and add python as default Kite client available language
* [PR 10195](https://github.com/spyder-ide/spyder/pull/10195) - PR: Fix formatting of missing dependencies dialog
* [PR 10189](https://github.com/spyder-ide/spyder/pull/10189) - PR: Fix multiline support for pdb history
* [PR 10181](https://github.com/spyder-ide/spyder/pull/10181) - PR: Use multi config for project configuration
* [PR 10177](https://github.com/spyder-ide/spyder/pull/10177) - PR: Handle Kite client connection errors when quitting Kite outside Spyder ([10176](https://github.com/spyder-ide/spyder/issues/10176))
* [PR 10174](https://github.com/spyder-ide/spyder/pull/10174) - PR: Gather responses from other completion sources when LSP raises an error
* [PR 10173](https://github.com/spyder-ide/spyder/pull/10173) - PR: Fix error when response is None in Kite client ([10159](https://github.com/spyder-ide/spyder/issues/10159))
* [PR 10170](https://github.com/spyder-ide/spyder/pull/10170) - PR: Add class variables to set configuration options for plugins
* [PR 10164](https://github.com/spyder-ide/spyder/pull/10164) - PR: Fix PyLS options not being updated correctly when a previous server was running ([9933](https://github.com/spyder-ide/spyder/issues/9933))
* [PR 10162](https://github.com/spyder-ide/spyder/pull/10162) - PR: Remove adding second interpreter prompt after error
* [PR 10160](https://github.com/spyder-ide/spyder/pull/10160) - PR: Fix banners for the IPython console
* [PR 10158](https://github.com/spyder-ide/spyder/pull/10158) - PR: Don't call MainWindow's apply_settings method when no needed
* [PR 10150](https://github.com/spyder-ide/spyder/pull/10150) - PR: Avoid RuntimeError when handling completion responses
* [PR 10145](https://github.com/spyder-ide/spyder/pull/10145) - PR: Fix PyLS actions triggering in Preferences ([10139](https://github.com/spyder-ide/spyder/issues/10139))
* [PR 10143](https://github.com/spyder-ide/spyder/pull/10143) - PR: Set error dialog as non-modal ([10135](https://github.com/spyder-ide/spyder/issues/10135))
* [PR 10142](https://github.com/spyder-ide/spyder/pull/10142) - PR: Revert windows on top for config dialog ([10138](https://github.com/spyder-ide/spyder/issues/10138))
* [PR 10140](https://github.com/spyder-ide/spyder/pull/10140) - PR: Fix Del key on report error dialog ([10136](https://github.com/spyder-ide/spyder/issues/10136))
* [PR 10137](https://github.com/spyder-ide/spyder/pull/10137) - PR: Prevent background overrides to extra decorations ([9950](https://github.com/spyder-ide/spyder/issues/9950))
* [PR 10114](https://github.com/spyder-ide/spyder/pull/10114) - PR: Handle Sympy foreground color setting following a color scheme change ([3798](https://github.com/spyder-ide/spyder/issues/3798))
* [PR 10110](https://github.com/spyder-ide/spyder/pull/10110) - PR: Fix completion order for lower/upper case entries ([10109](https://github.com/spyder-ide/spyder/issues/10109))
* [PR 10104](https://github.com/spyder-ide/spyder/pull/10104) - PR: Hide tooltips if switching editor in stack
* [PR 10103](https://github.com/spyder-ide/spyder/pull/10103) - PR: Fix code editor freeze when searching for next/previous warnings
* [PR 10100](https://github.com/spyder-ide/spyder/pull/10100) - PR: Update autosave information after file is renamed ([10038](https://github.com/spyder-ide/spyder/issues/10038))
* [PR 10088](https://github.com/spyder-ide/spyder/pull/10088) - PR: Always enable Kite completions
* [PR 10087](https://github.com/spyder-ide/spyder/pull/10087) - PR: Separate pdb input from regular input
* [PR 10085](https://github.com/spyder-ide/spyder/pull/10085) - PR: Stop IPython console channels faster
* [PR 10082](https://github.com/spyder-ide/spyder/pull/10082) - PR: Change the current cell color of the Spyder Dark theme
* [PR 10077](https://github.com/spyder-ide/spyder/pull/10077) - PR: Store autosave information in separate files instead of the Spyder config ([9420](https://github.com/spyder-ide/spyder/issues/9420))
* [PR 10076](https://github.com/spyder-ide/spyder/pull/10076) - PR: Check if responses are not None in Kite plugin handlers ([9993](https://github.com/spyder-ide/spyder/issues/9993), [10029](https://github.com/spyder-ide/spyder/issues/10029))
* [PR 10074](https://github.com/spyder-ide/spyder/pull/10074) - PR: Fix getting blocks by numbers in the editor ([10073](https://github.com/spyder-ide/spyder/issues/10073))
* [PR 10072](https://github.com/spyder-ide/spyder/pull/10072) - PR: Hide size/type columns and add show/hide actions to header (right click) and plugin opts.
* [PR 10070](https://github.com/spyder-ide/spyder/pull/10070) - PR: Prevent Kite error at startup if Kite is closed on macOS
* [PR 10067](https://github.com/spyder-ide/spyder/pull/10067) - PR: Improve check to see if Spyder is running in a macOS app
* [PR 10066](https://github.com/spyder-ide/spyder/pull/10066) - PR: Speedup of console shutdown time
* [PR 10060](https://github.com/spyder-ide/spyder/pull/10060) - PR: Migrate FileSwitcher functionality to Switcher ([8580](https://github.com/spyder-ide/spyder/issues/8580))
* [PR 10049](https://github.com/spyder-ide/spyder/pull/10049) - PR: Avoid discarding file open event in macOS app
* [PR 10047](https://github.com/spyder-ide/spyder/pull/10047) - PR: Add new test for unnamed first cell and debugcell ([10048](https://github.com/spyder-ide/spyder/issues/10048))
* [PR 10044](https://github.com/spyder-ide/spyder/pull/10044) - PR: Fix a couple of main window debugging tests
* [PR 10043](https://github.com/spyder-ide/spyder/pull/10043) - PR: Solve some issues with QString compatibility with emojis ([10039](https://github.com/spyder-ide/spyder/issues/10039))
* [PR 10035](https://github.com/spyder-ide/spyder/pull/10035) - PR: Fix "Projects > Recent" menu entries ([10014](https://github.com/spyder-ide/spyder/issues/10014))
* [PR 10033](https://github.com/spyder-ide/spyder/pull/10033) - PR: Skip new switcher test in CircleCI because it gives a segfault
* [PR 10032](https://github.com/spyder-ide/spyder/pull/10032) - PR: Add an option to run a file in the console's current namespace
* [PR 10017](https://github.com/spyder-ide/spyder/pull/10017) - PR: Resize dataframeeditor header to contents ([9996](https://github.com/spyder-ide/spyder/issues/9996))
* [PR 10016](https://github.com/spyder-ide/spyder/pull/10016) - PR: Escape regex characters from parameters while processing a signature ([10011](https://github.com/spyder-ide/spyder/issues/10011))
* [PR 10010](https://github.com/spyder-ide/spyder/pull/10010) - PR: Add permanent history to the debugger
* [PR 10007](https://github.com/spyder-ide/spyder/pull/10007) - PR: Remove "No match" entry in editor's code completion widget ([10002](https://github.com/spyder-ide/spyder/issues/10002))
* [PR 10006](https://github.com/spyder-ide/spyder/pull/10006) - PR: Correct Pympler required version
* [PR 10001](https://github.com/spyder-ide/spyder/pull/10001) - PR: Connect Plots plugin to external Spyder kernels ([9197](https://github.com/spyder-ide/spyder/issues/9197))
* [PR 10000](https://github.com/spyder-ide/spyder/pull/10000) - PR: Drop support for Python 3.4
* [PR 9999](https://github.com/spyder-ide/spyder/pull/9999) - PR: Allow setting the cwd through our toolbar for local external Spyder kernels ([9198](https://github.com/spyder-ide/spyder/issues/9198))
* [PR 9995](https://github.com/spyder-ide/spyder/pull/9995) - PR: Fix tests in Travis
* [PR 9988](https://github.com/spyder-ide/spyder/pull/9988) - PR: Improve support for Kite on macOS
* [PR 9980](https://github.com/spyder-ide/spyder/pull/9980) - PR: Don't convert values to text strings and fix sorting issues in the Variable Explorer ([9973](https://github.com/spyder-ide/spyder/issues/9973), [9516](https://github.com/spyder-ide/spyder/issues/9516))
* [PR 9975](https://github.com/spyder-ide/spyder/pull/9975) - PR: Centralize dependencies and declare the missing ones ([9796](https://github.com/spyder-ide/spyder/issues/9796))
* [PR 9967](https://github.com/spyder-ide/spyder/pull/9967) - PR: Improve error handling while getting objects attributes ([9959](https://github.com/spyder-ide/spyder/issues/9959))
* [PR 9966](https://github.com/spyder-ide/spyder/pull/9966) - PR: Save files when calling runfile directly in the console ([9342](https://github.com/spyder-ide/spyder/issues/9342))
* [PR 9960](https://github.com/spyder-ide/spyder/pull/9960) - PR: Do not add empty messages to history
* [PR 9944](https://github.com/spyder-ide/spyder/pull/9944) - PR: Add syntax highlighting to the debugger
* [PR 9943](https://github.com/spyder-ide/spyder/pull/9943) - PR: Add last line warnings/errors to their menu list ([9924](https://github.com/spyder-ide/spyder/issues/9924))
* [PR 9913](https://github.com/spyder-ide/spyder/pull/9913) - PR: Add unambiguous file names to Breakpoints pane
* [PR 9897](https://github.com/spyder-ide/spyder/pull/9897) - PR: Improvements to the completion widget ([9246](https://github.com/spyder-ide/spyder/issues/9246), [3181](https://github.com/spyder-ide/spyder/issues/3181), [2871](https://github.com/spyder-ide/spyder/issues/2871))
* [PR 9879](https://github.com/spyder-ide/spyder/pull/9879) - PR: Modifications for easier compatibility with Python 3.8
* [PR 9850](https://github.com/spyder-ide/spyder/pull/9850) - PR: Implement code snippets for our completion clients ([9568](https://github.com/spyder-ide/spyder/issues/9568))
* [PR 9720](https://github.com/spyder-ide/spyder/pull/9720) - PR: Make the width of thumbnails scrollbar resizable ([9747](https://github.com/spyder-ide/spyder/issues/9747))
* [PR 9566](https://github.com/spyder-ide/spyder/pull/9566) - PR: Correct auto-indent behaving in unexpected ways ([887](https://github.com/spyder-ide/spyder/issues/887), [7377](https://github.com/spyder-ide/spyder/issues/7377), [5606](https://github.com/spyder-ide/spyder/issues/5606))
* [PR 9343](https://github.com/spyder-ide/spyder/pull/9343) - PR: Use Jupyter comms to communicate between frontend and kernel
* [PR 9133](https://github.com/spyder-ide/spyder/pull/9133) - PR: Create generic switcher
* [PR 9014](https://github.com/spyder-ide/spyder/pull/9014) - PR: Use cell name in runcell to run it from the console and add functionality to debug cells ([9963](https://github.com/spyder-ide/spyder/issues/9963), [9361](https://github.com/spyder-ide/spyder/issues/9361))

In this release 69 pull requests were merged.


----


## Version 4.0beta4 (2019-08-02)

### Issues Closed

* [Issue 9945](https://github.com/spyder-ide/spyder/issues/9945) - Unify behavior to trigger elements edition (Variable Explorer) ([PR 9948](https://github.com/spyder-ide/spyder/pull/9948))
* [Issue 9915](https://github.com/spyder-ide/spyder/issues/9915) - Settings not getting applied ([PR 9932](https://github.com/spyder-ide/spyder/pull/9932))
* [Issue 9914](https://github.com/spyder-ide/spyder/issues/9914) - Preferences do not fully reset (transient.ini) ([PR 9917](https://github.com/spyder-ide/spyder/pull/9917))
* [Issue 9911](https://github.com/spyder-ide/spyder/issues/9911) - IPython console crashes when using netCDF4 ([PR 9925](https://github.com/spyder-ide/spyder/pull/9925))
* [Issue 9908](https://github.com/spyder-ide/spyder/issues/9908) - KeyError: 'willSave' when splitting the editor ([PR 9887](https://github.com/spyder-ide/spyder/pull/9887))
* [Issue 9893](https://github.com/spyder-ide/spyder/issues/9893) - Variable explorer search button keeps pressed after hiding the search field with Esc ([PR 9894](https://github.com/spyder-ide/spyder/pull/9894))
* [Issue 9891](https://github.com/spyder-ide/spyder/issues/9891) - Improve shortcuts table UI ([PR 9921](https://github.com/spyder-ide/spyder/pull/9921))
* [Issue 9878](https://github.com/spyder-ide/spyder/issues/9878) - Windows layout does not work properly ([PR 9903](https://github.com/spyder-ide/spyder/pull/9903))
* [Issue 9871](https://github.com/spyder-ide/spyder/issues/9871) - New automatic completion makes it hard to work ([PR 9895](https://github.com/spyder-ide/spyder/pull/9895))
* [Issue 9849](https://github.com/spyder-ide/spyder/issues/9849) - Control-click URL in tutorial causes ValueError ([PR 9857](https://github.com/spyder-ide/spyder/pull/9857))
* [Issue 9835](https://github.com/spyder-ide/spyder/issues/9835) - Variable explorer: Sorting not working ([PR 9840](https://github.com/spyder-ide/spyder/pull/9840))
* [Issue 9826](https://github.com/spyder-ide/spyder/issues/9826) - Dark theme is not applied to context menu appearing on plots in ipython console
* [Issue 9802](https://github.com/spyder-ide/spyder/issues/9802) - Add capability of splitting the Configuration manager files to use ([PR 9820](https://github.com/spyder-ide/spyder/pull/9820))
* [Issue 9801](https://github.com/spyder-ide/spyder/issues/9801) - Add a configuration manager to handle global user preferences and projects preferences ([PR 9820](https://github.com/spyder-ide/spyder/pull/9820))
* [Issue 9794](https://github.com/spyder-ide/spyder/issues/9794) - Fail to Launch Spyder Tutorial ([PR 9831](https://github.com/spyder-ide/spyder/pull/9831))
* [Issue 9785](https://github.com/spyder-ide/spyder/issues/9785) - Equation is not displayed in Help pane on Windows ([PR 9793](https://github.com/spyder-ide/spyder/pull/9793))
* [Issue 9763](https://github.com/spyder-ide/spyder/issues/9763) - Align plugin tabs to the left and center dockwidget tabs for all OSes ([PR 9808](https://github.com/spyder-ide/spyder/pull/9808))
* [Issue 9755](https://github.com/spyder-ide/spyder/issues/9755) - KeyError textDocumentSync when opening Spyder with a project ([PR 9887](https://github.com/spyder-ide/spyder/pull/9887))
* [Issue 9749](https://github.com/spyder-ide/spyder/issues/9749) - No curly brackets on Spyder 4.0.0b3 on macOS with a French keyboard ([PR 9813](https://github.com/spyder-ide/spyder/pull/9813))
* [Issue 9746](https://github.com/spyder-ide/spyder/issues/9746) - Plots viewer arrows a bit too small ([PR 9745](https://github.com/spyder-ide/spyder/pull/9745))
* [Issue 9721](https://github.com/spyder-ide/spyder/issues/9721) - Prevent LSP client to listen to external hosts ([PR 9728](https://github.com/spyder-ide/spyder/pull/9728))
* [Issue 9714](https://github.com/spyder-ide/spyder/issues/9714) - Dependencies dialog should provide correct package name ([PR 9789](https://github.com/spyder-ide/spyder/pull/9789))
* [Issue 9713](https://github.com/spyder-ide/spyder/issues/9713) - Replace cannot ignore case when using regular expressions ([PR 9716](https://github.com/spyder-ide/spyder/pull/9716))
* [Issue 9688](https://github.com/spyder-ide/spyder/issues/9688) - Replace selection in wrong tab on startup ([PR 9710](https://github.com/spyder-ide/spyder/pull/9710))
* [Issue 9685](https://github.com/spyder-ide/spyder/issues/9685) - Selected text unselected after "Replace selection" ([PR 9687](https://github.com/spyder-ide/spyder/pull/9687))
* [Issue 9669](https://github.com/spyder-ide/spyder/issues/9669) - Cannot use viewer for collections, arrays, dataframes that are attributes of general objects ([PR 9806](https://github.com/spyder-ide/spyder/pull/9806))
* [Issue 9659](https://github.com/spyder-ide/spyder/issues/9659) - Add inf support to array builder! ([PR 9777](https://github.com/spyder-ide/spyder/pull/9777))
* [Issue 9644](https://github.com/spyder-ide/spyder/issues/9644) - Pylint output window is not inheriting the dark theme
* [Issue 9611](https://github.com/spyder-ide/spyder/issues/9611) - Minimize icon is out of center ([PR 9784](https://github.com/spyder-ide/spyder/pull/9784))
* [Issue 9604](https://github.com/spyder-ide/spyder/issues/9604) - Analyze Button of Code Pane doesn't respect save before analysis Preference ([PR 9864](https://github.com/spyder-ide/spyder/pull/9864))
* [Issue 9594](https://github.com/spyder-ide/spyder/issues/9594) - Completion widget of the IPython console is not showed correctly with the dark theme
* [Issue 9561](https://github.com/spyder-ide/spyder/issues/9561) - Selected working directory in Preferences is not preserved after a restart ([PR 9792](https://github.com/spyder-ide/spyder/pull/9792))
* [Issue 9451](https://github.com/spyder-ide/spyder/issues/9451) - Editing or viewing a datetime looses miliseconds part of the datetime timestamp ([PR 9848](https://github.com/spyder-ide/spyder/pull/9848))
* [Issue 9008](https://github.com/spyder-ide/spyder/issues/9008) - Add current conda environment as status widget ([PR 9778](https://github.com/spyder-ide/spyder/pull/9778))
* [Issue 8834](https://github.com/spyder-ide/spyder/issues/8834) - Hard crash when opening Numpy array in VarExp  with one or more np.object fields ([PR 5260](https://github.com/spyder-ide/spyder/pull/5260))
* [Issue 8767](https://github.com/spyder-ide/spyder/issues/8767) - Icons not displaying in Options menus in macOS ([PR 8923](https://github.com/spyder-ide/spyder/pull/8923))
* [Issue 7960](https://github.com/spyder-ide/spyder/issues/7960) - Search for "whole words" does not return the correct number of matches ([PR 9716](https://github.com/spyder-ide/spyder/pull/9716))
* [Issue 6416](https://github.com/spyder-ide/spyder/issues/6416) - Bug: Replace Selection changes double backslashes to single backslashes ([PR 9708](https://github.com/spyder-ide/spyder/pull/9708))
* [Issue 5734](https://github.com/spyder-ide/spyder/issues/5734) - Shift-Tab does not remove final indent level for non 4-multiple indents (e.g. continuations) ([PR 9869](https://github.com/spyder-ide/spyder/pull/9869))
* [Issue 5491](https://github.com/spyder-ide/spyder/issues/5491) - Relative paths in workspace.ini to make projects moveable ([PR 9672](https://github.com/spyder-ide/spyder/pull/9672))
* [Issue 5062](https://github.com/spyder-ide/spyder/issues/5062) - Run in external system terminal doesn't work in macOS ([PR 9673](https://github.com/spyder-ide/spyder/pull/9673))
* [Issue 4067](https://github.com/spyder-ide/spyder/issues/4067) - Add fuzzy search functionality to the Variable Explorer ([PR 9384](https://github.com/spyder-ide/spyder/pull/9384))
* [Issue 1914](https://github.com/spyder-ide/spyder/issues/1914) - Automatically show code completion widget ([PR 9839](https://github.com/spyder-ide/spyder/pull/9839))

In this release 43 issues were closed.

### Pull Requests Merged

* [PR 9948](https://github.com/spyder-ide/spyder/pull/9948) - PR: Enable edition only with double click (Variable Explorer) ([9945](https://github.com/spyder-ide/spyder/issues/9945))
* [PR 9941](https://github.com/spyder-ide/spyder/pull/9941) - PR: Fix running bash scripts in our CIs
* [PR 9936](https://github.com/spyder-ide/spyder/pull/9936) - PR: Fix loading from old defaults and removing deprecated options
* [PR 9932](https://github.com/spyder-ide/spyder/pull/9932) - PR: Fix preferences not being set ([9915](https://github.com/spyder-ide/spyder/issues/9915))
* [PR 9931](https://github.com/spyder-ide/spyder/pull/9931) - PR: Add error message when reporting PyLS internal errors
* [PR 9929](https://github.com/spyder-ide/spyder/pull/9929) - PR: Increase minimum required version of qtconsole to 4.5.2
* [PR 9926](https://github.com/spyder-ide/spyder/pull/9926) - PR: Install a working build of Python 3.6 in Azure to fix our tests
* [PR 9925](https://github.com/spyder-ide/spyder/pull/9925) - PR: Fix wrapping calltip text for elements without signature in the IPython console ([9911](https://github.com/spyder-ide/spyder/issues/9911))
* [PR 9921](https://github.com/spyder-ide/spyder/pull/9921) - PR: Improve shortcuts entry in Preferences ([9891](https://github.com/spyder-ide/spyder/issues/9891))
* [PR 9917](https://github.com/spyder-ide/spyder/pull/9917) - PR: Add new config files to reset ([9914](https://github.com/spyder-ide/spyder/issues/9914))
* [PR 9904](https://github.com/spyder-ide/spyder/pull/9904) - PR: Remove unused imports
* [PR 9903](https://github.com/spyder-ide/spyder/pull/9903) - PR: Rescale window layout parameters ([9878](https://github.com/spyder-ide/spyder/issues/9878))
* [PR 9902](https://github.com/spyder-ide/spyder/pull/9902) - PR: Skip most IPython console tests in macOS and Python 2.7
* [PR 9895](https://github.com/spyder-ide/spyder/pull/9895) - PR: Disable automatic completions when spacebar or backspace are pressed ([9871](https://github.com/spyder-ide/spyder/issues/9871))
* [PR 9894](https://github.com/spyder-ide/spyder/pull/9894) - PR: Change the way to show/hide the search widget in the Variable Explorer ([9893](https://github.com/spyder-ide/spyder/issues/9893))
* [PR 9887](https://github.com/spyder-ide/spyder/pull/9887) - PR: Prevent errors when LSP servers don't specify some settings ([9908](https://github.com/spyder-ide/spyder/issues/9908), [9755](https://github.com/spyder-ide/spyder/issues/9755))
* [PR 9877](https://github.com/spyder-ide/spyder/pull/9877) - PR: Inherit style in the output dialog from code analysis
* [PR 9870](https://github.com/spyder-ide/spyder/pull/9870) - PR: Remove several deprecation warnings
* [PR 9869](https://github.com/spyder-ide/spyder/pull/9869) - PR: Improve unindent behavior ([5734](https://github.com/spyder-ide/spyder/issues/5734))
* [PR 9866](https://github.com/spyder-ide/spyder/pull/9866) - PR: Reenable sorting of keyboard shortcuts table after clearing filter text
* [PR 9864](https://github.com/spyder-ide/spyder/pull/9864) - PR: Made Analyze button respect "save before" setting ([9604](https://github.com/spyder-ide/spyder/issues/9604))
* [PR 9857](https://github.com/spyder-ide/spyder/pull/9857) - PR: Fix control-click URL in tutorial ValueError ([9849](https://github.com/spyder-ide/spyder/issues/9849))
* [PR 9852](https://github.com/spyder-ide/spyder/pull/9852) - PR: Make LSP tests to be run independently
* [PR 9848](https://github.com/spyder-ide/spyder/pull/9848) - PR: Add millisecond editing capabilities to variable explorer ([9451](https://github.com/spyder-ide/spyder/issues/9451))
* [PR 9840](https://github.com/spyder-ide/spyder/pull/9840) - PR: Fix sorting by column in the Variable Explorer ([9835](https://github.com/spyder-ide/spyder/issues/9835))
* [PR 9839](https://github.com/spyder-ide/spyder/pull/9839) - PR: Perform code completions on the fly ([1914](https://github.com/spyder-ide/spyder/issues/1914))
* [PR 9831](https://github.com/spyder-ide/spyder/pull/9831) - PR: Add rst files again to our tarballs ([9794](https://github.com/spyder-ide/spyder/issues/9794))
* [PR 9820](https://github.com/spyder-ide/spyder/pull/9820) - PR: Update and modernize config system to support multiple types of configurations ([9802](https://github.com/spyder-ide/spyder/issues/9802), [9801](https://github.com/spyder-ide/spyder/issues/9801))
* [PR 9818](https://github.com/spyder-ide/spyder/pull/9818) - PR: Increase maximum Pytest supported version
* [PR 9814](https://github.com/spyder-ide/spyder/pull/9814) - PR: Use text instead of key in the editor close quotes extension
* [PR 9813](https://github.com/spyder-ide/spyder/pull/9813) - PR: Use text instead of key in the editor close bracket extension ([9749](https://github.com/spyder-ide/spyder/issues/9749))
* [PR 9808](https://github.com/spyder-ide/spyder/pull/9808) - PR: Align plugin tabs to the left and center dockwidget ones ([9763](https://github.com/spyder-ide/spyder/issues/9763))
* [PR 9806](https://github.com/spyder-ide/spyder/pull/9806) - PR: Add edition capabilities for object's attributes in the Object Explorer ([9669](https://github.com/spyder-ide/spyder/issues/9669))
* [PR 9798](https://github.com/spyder-ide/spyder/pull/9798) - PR: Improve robustness of LSP tests
* [PR 9793](https://github.com/spyder-ide/spyder/pull/9793) - PR: Improve rendering of equations with MathJax on Windows in the Help pane ([9785](https://github.com/spyder-ide/spyder/issues/9785))
* [PR 9792](https://github.com/spyder-ide/spyder/pull/9792) - PR: Preserve selected working directory in Preferences after a restart ([9561](https://github.com/spyder-ide/spyder/issues/9561))
* [PR 9789](https://github.com/spyder-ide/spyder/pull/9789) - PR: Add package name to dependencies ([9714](https://github.com/spyder-ide/spyder/issues/9714))
* [PR 9787](https://github.com/spyder-ide/spyder/pull/9787) - PR: Remove backslash of path for import_data on Windows
* [PR 9784](https://github.com/spyder-ide/spyder/pull/9784) - PR: Update collapse/expand icons ([9611](https://github.com/spyder-ide/spyder/issues/9611))
* [PR 9779](https://github.com/spyder-ide/spyder/pull/9779) - PR: Remove CONF calls on widgets for issue reporter
* [PR 9778](https://github.com/spyder-ide/spyder/pull/9778) - PR: Add conda environment status widget ([9008](https://github.com/spyder-ide/spyder/issues/9008))
* [PR 9777](https://github.com/spyder-ide/spyder/pull/9777) - PR: Fix inf handling and generalize array builder for initial support on other languages ([9659](https://github.com/spyder-ide/spyder/issues/9659))
* [PR 9753](https://github.com/spyder-ide/spyder/pull/9753) - PR: Implement a completion plugin for Kite
* [PR 9748](https://github.com/spyder-ide/spyder/pull/9748) - PR: Fix stripping on return for strings
* [PR 9745](https://github.com/spyder-ide/spyder/pull/9745) - PR: Fix height of thumbnail scrollbar arrow buttons in the Plots plugin ([9746](https://github.com/spyder-ide/spyder/issues/9746))
* [PR 9741](https://github.com/spyder-ide/spyder/pull/9741) - PR: Add basic config dlg tests for plugins
* [PR 9740](https://github.com/spyder-ide/spyder/pull/9740) - PR: Keep preferences on top and give focus if the shortcut is called
* [PR 9728](https://github.com/spyder-ide/spyder/pull/9728) - PR: Prevent LSP listen to external hosts ([9721](https://github.com/spyder-ide/spyder/issues/9721))
* [PR 9716](https://github.com/spyder-ide/spyder/pull/9716) - PR: Fix several find/replace bugs ([9713](https://github.com/spyder-ide/spyder/issues/9713), [7960](https://github.com/spyder-ide/spyder/issues/7960))
* [PR 9712](https://github.com/spyder-ide/spyder/pull/9712) - PR: Changed issue numbers in code to links
* [PR 9711](https://github.com/spyder-ide/spyder/pull/9711) - PR: Remove some redundant icons
* [PR 9710](https://github.com/spyder-ide/spyder/pull/9710) - PR: Replace in correct file after startup ([9688](https://github.com/spyder-ide/spyder/issues/9688))
* [PR 9709](https://github.com/spyder-ide/spyder/pull/9709) - PR: Add tooltips for find next/previous buttons
* [PR 9708](https://github.com/spyder-ide/spyder/pull/9708) - PR: Fix replace in selection with backslashes ([6416](https://github.com/spyder-ide/spyder/issues/6416))
* [PR 9704](https://github.com/spyder-ide/spyder/pull/9704) - PR: Refactor completion architecture to support multiple sources
* [PR 9687](https://github.com/spyder-ide/spyder/pull/9687) - PR: Restored selection after replaced in selection ([9685](https://github.com/spyder-ide/spyder/issues/9685))
* [PR 9682](https://github.com/spyder-ide/spyder/pull/9682) - PR: Fix QComboBox with newer Qt versions and qdarkstyle ([191](https://github.com/ColinDuquesnoy/QDarkStyleSheet/issues/191))
* [PR 9679](https://github.com/spyder-ide/spyder/pull/9679) - PR: Convert LSPManager into a proper SpyderPlugin
* [PR 9673](https://github.com/spyder-ide/spyder/pull/9673) - PR: Add support to run files in external system terminal for macOS ([5062](https://github.com/spyder-ide/spyder/issues/5062))
* [PR 9672](https://github.com/spyder-ide/spyder/pull/9672) - PR: Save project recent files as relative paths in workspace.ini ([5491](https://github.com/spyder-ide/spyder/issues/5491))
* [PR 9384](https://github.com/spyder-ide/spyder/pull/9384) - PR: Add fuzzy search to the Variable Explorer ([4067](https://github.com/spyder-ide/spyder/issues/4067))
* [PR 8923](https://github.com/spyder-ide/spyder/pull/8923) - PR: Show icons in Options menus for macOS ([8767](https://github.com/spyder-ide/spyder/issues/8767))
* [PR 5260](https://github.com/spyder-ide/spyder/pull/5260) - PR: Add support for object arrays in the Variable Explorer ([8834](https://github.com/spyder-ide/spyder/issues/8834))

In this release 63 pull requests were closed.


----


## Version 4.0beta3 (2019-06-29)

### Issues Closed

* [Issue 9691](https://github.com/spyder-ide/spyder/issues/9691) - Can't set other Python interpreter ([PR 9706](https://github.com/spyder-ide/spyder/pull/9706))
* [Issue 9668](https://github.com/spyder-ide/spyder/issues/9668) - Hovers and calltips broken in the Editor ([PR 9670](https://github.com/spyder-ide/spyder/pull/9670))
* [Issue 9635](https://github.com/spyder-ide/spyder/issues/9635) - Make highlighting of errors and warning synchronized with errors and warnings popup show and hide ([PR 9636](https://github.com/spyder-ide/spyder/pull/9636))
* [Issue 9631](https://github.com/spyder-ide/spyder/issues/9631) - Highlighting errors and warnings wipe underlining of errors and warning. ([PR 9636](https://github.com/spyder-ide/spyder/pull/9636))
* [Issue 9628](https://github.com/spyder-ide/spyder/issues/9628) - Python LSP codeeditor configurations are being replaced each time a new LSP server is available ([PR 9633](https://github.com/spyder-ide/spyder/pull/9633))
* [Issue 9627](https://github.com/spyder-ide/spyder/issues/9627) - Add an option to turn off the underlining of errors and warnings in the Editor. ([PR 9630](https://github.com/spyder-ide/spyder/pull/9630))
* [Issue 9616](https://github.com/spyder-ide/spyder/issues/9616) - Lowercase in text out of pattern ([PR 9677](https://github.com/spyder-ide/spyder/pull/9677))
* [Issue 9614](https://github.com/spyder-ide/spyder/issues/9614) - URL awereness is broken in latest master ([PR 9625](https://github.com/spyder-ide/spyder/pull/9625))
* [Issue 9596](https://github.com/spyder-ide/spyder/issues/9596) - Some completion trigger characters supported by LSP servers are not used ([PR 9605](https://github.com/spyder-ide/spyder/pull/9605))
* [Issue 9578](https://github.com/spyder-ide/spyder/issues/9578) - WaitSpinner color under the dark theme should be white and suggestion for improving the look of the spinner ([PR 9584](https://github.com/spyder-ide/spyder/pull/9584))
* [Issue 9577](https://github.com/spyder-ide/spyder/issues/9577) - Remember what was selected in the "Search in" combo box of the "Find"pluggin ([PR 9586](https://github.com/spyder-ide/spyder/pull/9586))
* [Issue 9570](https://github.com/spyder-ide/spyder/issues/9570) - Error for calltip with empty signature ([PR 9582](https://github.com/spyder-ide/spyder/pull/9582))
* [Issue 9557](https://github.com/spyder-ide/spyder/issues/9557) - Traceback on Spyder launch when auto-opens previous project
* [Issue 9549](https://github.com/spyder-ide/spyder/issues/9549) - Create preferences setting to allow file associations ([PR 9504](https://github.com/spyder-ide/spyder/pull/9504))
* [Issue 9543](https://github.com/spyder-ide/spyder/issues/9543) - Wrap text in warnings and hover tips ([PR 9585](https://github.com/spyder-ide/spyder/pull/9585))
* [Issue 9542](https://github.com/spyder-ide/spyder/issues/9542) - Text written in Help pane gets automatically selected after match ([PR 9552](https://github.com/spyder-ide/spyder/pull/9552))
* [Issue 9531](https://github.com/spyder-ide/spyder/issues/9531) - Crash when trying to autocomplete with fallback ([PR 9563](https://github.com/spyder-ide/spyder/pull/9563))
* [Issue 9529](https://github.com/spyder-ide/spyder/issues/9529) - Calltips in IPython console are empty but work in qtconsole ([PR 9533](https://github.com/spyder-ide/spyder/pull/9533))
* [Issue 9522](https://github.com/spyder-ide/spyder/issues/9522) - KeyError in PyLS when opening projects ([PR 9482](https://github.com/spyder-ide/spyder/pull/9482))
* [Issue 9515](https://github.com/spyder-ide/spyder/issues/9515) - Bug with default actions for Ctrl+Tab and Ctrl+Backtab in the Editor ([PR 9517](https://github.com/spyder-ide/spyder/pull/9517))
* [Issue 9513](https://github.com/spyder-ide/spyder/issues/9513) - Improvements to URL awareness ([PR 9572](https://github.com/spyder-ide/spyder/pull/9572))
* [Issue 9512](https://github.com/spyder-ide/spyder/issues/9512) - Toggle uppercase/lowercase menu icons ([PR 9518](https://github.com/spyder-ide/spyder/pull/9518))
* [Issue 9511](https://github.com/spyder-ide/spyder/issues/9511) - Toggling docstring style linting in preferences doesn't work in macOS ([PR 9637](https://github.com/spyder-ide/spyder/pull/9637))
* [Issue 9506](https://github.com/spyder-ide/spyder/issues/9506) - The vertical position of the tab switcher dialog window is wrong in Spyder 4 ([PR 9507](https://github.com/spyder-ide/spyder/pull/9507))
* [Issue 9505](https://github.com/spyder-ide/spyder/issues/9505) - Removing all variables on remote kernels fails ([PR 9548](https://github.com/spyder-ide/spyder/pull/9548))
* [Issue 9501](https://github.com/spyder-ide/spyder/issues/9501) - Cursor is not restore properly in the Editor ([PR 9502](https://github.com/spyder-ide/spyder/pull/9502))
* [Issue 9497](https://github.com/spyder-ide/spyder/issues/9497) - Moving tabs in the Editor is slow ([PR 9569](https://github.com/spyder-ide/spyder/pull/9569))
* [Issue 9474](https://github.com/spyder-ide/spyder/issues/9474) - Symbol switcher throws exception after Enter ([PR 9524](https://github.com/spyder-ide/spyder/pull/9524))
* [Issue 9472](https://github.com/spyder-ide/spyder/issues/9472) - Restore underlining errors and warnings in the Editor ([PR 9597](https://github.com/spyder-ide/spyder/pull/9597))
* [Issue 9469](https://github.com/spyder-ide/spyder/issues/9469) - EditorStack file and symbol switcher not working ([PR 9521](https://github.com/spyder-ide/spyder/pull/9521))
* [Issue 9463](https://github.com/spyder-ide/spyder/issues/9463) - Add simplified Github Issue/PR URL recognition ([PR 9473](https://github.com/spyder-ide/spyder/pull/9473))
* [Issue 9457](https://github.com/spyder-ide/spyder/issues/9457) - Not able to create a new breakpoint after a collapsed function ([PR 9555](https://github.com/spyder-ide/spyder/pull/9555))
* [Issue 9449](https://github.com/spyder-ide/spyder/issues/9449) - spyder 4 startup error ([PR 9467](https://github.com/spyder-ide/spyder/pull/9467))
* [Issue 9443](https://github.com/spyder-ide/spyder/issues/9443) - Code cells that fill the whole screen lose their background highlight ([PR 9444](https://github.com/spyder-ide/spyder/pull/9444))
* [Issue 9442](https://github.com/spyder-ide/spyder/issues/9442) - Information icon in File Switcher is not themed under the dark theme ([PR 9477](https://github.com/spyder-ide/spyder/pull/9477))
* [Issue 9439](https://github.com/spyder-ide/spyder/issues/9439) - Under the dark theme, the right warning display sidebar is not offset to match the scroll bar position ([PR 9450](https://github.com/spyder-ide/spyder/pull/9450))
* [Issue 9434](https://github.com/spyder-ide/spyder/issues/9434) - Code folding does not fold correctly when there are blank lines ([PR 9526](https://github.com/spyder-ide/spyder/pull/9526))
* [Issue 9425](https://github.com/spyder-ide/spyder/issues/9425) - Changing LSP-related settings when another Spyder instance is open stops LSP from working ([PR 9468](https://github.com/spyder-ide/spyder/pull/9468))
* [Issue 9405](https://github.com/spyder-ide/spyder/issues/9405) - Zoom buttons state and scaling percentage update when "Fits plot to window" is activated ([PR 9407](https://github.com/spyder-ide/spyder/pull/9407))
* [Issue 9395](https://github.com/spyder-ide/spyder/issues/9395) - using BeautifulSoup4 to webscrape wikipedia ([PR 9401](https://github.com/spyder-ide/spyder/pull/9401))
* [Issue 9393](https://github.com/spyder-ide/spyder/issues/9393) - Hover Tooltips make change focus off the spyder main window on Linux ([PR 9394](https://github.com/spyder-ide/spyder/pull/9394))
* [Issue 9390](https://github.com/spyder-ide/spyder/issues/9390) - Error when launching Preferences in Chinese ([PR 9571](https://github.com/spyder-ide/spyder/pull/9571))
* [Issue 9381](https://github.com/spyder-ide/spyder/issues/9381) - Overwritten file permissions on save ([PR 9550](https://github.com/spyder-ide/spyder/pull/9550))
* [Issue 9368](https://github.com/spyder-ide/spyder/issues/9368) - Resizing plot panes does not resize the content ([PR 9386](https://github.com/spyder-ide/spyder/pull/9386))
* [Issue 9357](https://github.com/spyder-ide/spyder/issues/9357) - Help Panel: LaTeX rendering is unreadable when using dark theme ([PR 9377](https://github.com/spyder-ide/spyder/pull/9377))
* [Issue 9303](https://github.com/spyder-ide/spyder/issues/9303) - Single click to open files doesn't work in project explorer ([PR 9402](https://github.com/spyder-ide/spyder/pull/9402))
* [Issue 9265](https://github.com/spyder-ide/spyder/issues/9265) - Autosaves are created for unmodified files and not removed on close with split Editor panes ([PR 9485](https://github.com/spyder-ide/spyder/pull/9485))
* [Issue 9247](https://github.com/spyder-ide/spyder/issues/9247) - Improve messages of code analysis tooltip ([PR 9422](https://github.com/spyder-ide/spyder/pull/9422))
* [Issue 9194](https://github.com/spyder-ide/spyder/issues/9194) - Pass language from console and editor on calltip call ([PR 9290](https://github.com/spyder-ide/spyder/pull/9290))
* [Issue 9085](https://github.com/spyder-ide/spyder/issues/9085) - Default code cell name  ([PR 9082](https://github.com/spyder-ide/spyder/pull/9082))
* [Issue 9007](https://github.com/spyder-ide/spyder/issues/9007) - Connect our LSP client to the workspace functionality provided by the PyLS. ([PR 9482](https://github.com/spyder-ide/spyder/pull/9482))
* [Issue 8564](https://github.com/spyder-ide/spyder/issues/8564) - New line creates whitespaces that conflict with PEP 8 ([PR 8734](https://github.com/spyder-ide/spyder/pull/8734))
* [Issue 8371](https://github.com/spyder-ide/spyder/issues/8371) - Support color scheme Sublime Text Monokai Extended (and more) ([PR 8381](https://github.com/spyder-ide/spyder/pull/8381))
* [Issue 8076](https://github.com/spyder-ide/spyder/issues/8076) - Incorrect custom shortcut displayed in menus for Run Cell command ([PR 9458](https://github.com/spyder-ide/spyder/pull/9458))
* [Issue 8068](https://github.com/spyder-ide/spyder/issues/8068) - Fully implement Spyder's new dark theme
* [Issue 8000](https://github.com/spyder-ide/spyder/issues/8000) - IndexError for some shortcuts in the Editor ([PR 9523](https://github.com/spyder-ide/spyder/pull/9523))
* [Issue 7976](https://github.com/spyder-ide/spyder/issues/7976) - Automatic Updates on Outline Explorer ([PR 9082](https://github.com/spyder-ide/spyder/pull/9082))
* [Issue 6055](https://github.com/spyder-ide/spyder/issues/6055) - Ctrl-Tab doesn't switch between Editor files in macOS ([PR 9400](https://github.com/spyder-ide/spyder/pull/9400))
* [Issue 1536](https://github.com/spyder-ide/spyder/issues/1536) - Pylint should follow the opened file ([PR 9430](https://github.com/spyder-ide/spyder/pull/9430))
* [Issue 885](https://github.com/spyder-ide/spyder/issues/885) - Outline Explorer: Highlight current class/method automatically ([PR 9219](https://github.com/spyder-ide/spyder/pull/9219))
* [Issue 558](https://github.com/spyder-ide/spyder/issues/558) - Add Object Explorer for exploring an object's properties ([PR 8852](https://github.com/spyder-ide/spyder/pull/8852))

In this release 61 issues were closed.

### Pull Requests Merged

* [PR 9706](https://github.com/spyder-ide/spyder/pull/9706) - PR: Fixes content type attribute error for global config dialog ([9691](https://github.com/spyder-ide/spyder/issues/9691))
* [PR 9677](https://github.com/spyder-ide/spyder/pull/9677) - PR: Fix texts out of pattern in Preferences ([9616](https://github.com/spyder-ide/spyder/issues/9616))
* [PR 9670](https://github.com/spyder-ide/spyder/pull/9670) - PR: Fix formating of text/documentation in tooltips and calltips ([9668](https://github.com/spyder-ide/spyder/issues/9668))
* [PR 9667](https://github.com/spyder-ide/spyder/pull/9667) - PR: Demand PyLS 0.27+ and disable Pylint linting
* [PR 9660](https://github.com/spyder-ide/spyder/pull/9660) - PR: Disable autosave if not running in single instance mode
* [PR 9657](https://github.com/spyder-ide/spyder/pull/9657) - PR: Update Contributing guide
* [PR 9646](https://github.com/spyder-ide/spyder/pull/9646) - PR: Avoid that code analysis tree collapses on selection
* [PR 9642](https://github.com/spyder-ide/spyder/pull/9642) - PR: Fix EditorPluginExample test
* [PR 9637](https://github.com/spyder-ide/spyder/pull/9637) - PR: Fix checkboxes loading from config file in macOS ([9511](https://github.com/spyder-ide/spyder/issues/9511))
* [PR 9636](https://github.com/spyder-ide/spyder/pull/9636) - PR: Fix and improvement to the highlighting and underlining of errors and warnings in the Editor ([9635](https://github.com/spyder-ide/spyder/issues/9635), [9631](https://github.com/spyder-ide/spyder/issues/9631))
* [PR 9634](https://github.com/spyder-ide/spyder/pull/9634) - PR: Downgrade Jedi in our CIs because the latest version broke the PyLS
* [PR 9633](https://github.com/spyder-ide/spyder/pull/9633) - PR: Fix project workspace startup ([9628](https://github.com/spyder-ide/spyder/issues/9628))
* [PR 9630](https://github.com/spyder-ide/spyder/pull/9630) - PR: Add an option to turn on/off the underlining of errors and warnings in the Editor.  ([9627](https://github.com/spyder-ide/spyder/issues/9627))
* [PR 9625](https://github.com/spyder-ide/spyder/pull/9625) - PR: Fix url awareness missing variable and add regression test ([9614](https://github.com/spyder-ide/spyder/issues/9614))
* [PR 9605](https://github.com/spyder-ide/spyder/pull/9605) - PR: Enable other LSP completion characters ([9596](https://github.com/spyder-ide/spyder/issues/9596))
* [PR 9597](https://github.com/spyder-ide/spyder/pull/9597) - PR: Restore underlining errors and warnings in the Editor ([9472](https://github.com/spyder-ide/spyder/issues/9472))
* [PR 9595](https://github.com/spyder-ide/spyder/pull/9595) - PR: Send fallback completions to the end of the completion widget
* [PR 9586](https://github.com/spyder-ide/spyder/pull/9586) - PR: Add and get "Search in" combo box index of the "Find" plugin from/to config ([9577](https://github.com/spyder-ide/spyder/issues/9577))
* [PR 9585](https://github.com/spyder-ide/spyder/pull/9585) - PR: Wrap text in tooltips, hints and calltips ([9543](https://github.com/spyder-ide/spyder/issues/9543))
* [PR 9584](https://github.com/spyder-ide/spyder/pull/9584) - PR: Style improvement to the wait spinner used in the Find plugin ([9578](https://github.com/spyder-ide/spyder/issues/9578))
* [PR 9582](https://github.com/spyder-ide/spyder/pull/9582) - PR: Add validation for empty signature while getting calltip in the IPython Console ([9570](https://github.com/spyder-ide/spyder/issues/9570))
* [PR 9572](https://github.com/spyder-ide/spyder/pull/9572) - PR: URL awareness improvements ([9513](https://github.com/spyder-ide/spyder/issues/9513))
* [PR 9571](https://github.com/spyder-ide/spyder/pull/9571) - PR: Fix error when launching Preferences in Chinese ([9390](https://github.com/spyder-ide/spyder/issues/9390))
* [PR 9569](https://github.com/spyder-ide/spyder/pull/9569) - PR: Add a worker to VCSStatus for getting Git active branch, state, branches (plus tags) ([9497](https://github.com/spyder-ide/spyder/issues/9497))
* [PR 9563](https://github.com/spyder-ide/spyder/pull/9563) - PR: Fix segfault when getting fallback completions ([9531](https://github.com/spyder-ide/spyder/issues/9531))
* [PR 9560](https://github.com/spyder-ide/spyder/pull/9560) - PR: Add desktop.ini file to .gitignore
* [PR 9556](https://github.com/spyder-ide/spyder/pull/9556) - PR: Remove extra padding around plots and variable explorer plugins
* [PR 9555](https://github.com/spyder-ide/spyder/pull/9555) - PR: Fix line count when code is collapsed ([9457](https://github.com/spyder-ide/spyder/issues/9457))
* [PR 9552](https://github.com/spyder-ide/spyder/pull/9552) - PR: Don't stay with selected text when it's found valid in the Help pane ([9542](https://github.com/spyder-ide/spyder/issues/9542))
* [PR 9550](https://github.com/spyder-ide/spyder/pull/9550) - PR: Preserve file permissions when saving in the editor ([9381](https://github.com/spyder-ide/spyder/issues/9381))
* [PR 9548](https://github.com/spyder-ide/spyder/pull/9548) - PR: Enclose kernel_env assignment in a try/except ([9505](https://github.com/spyder-ide/spyder/issues/9505))
* [PR 9541](https://github.com/spyder-ide/spyder/pull/9541) - PR: Watch a project file tree for changes
* [PR 9535](https://github.com/spyder-ide/spyder/pull/9535) - PR: Fix calltip size on linux
* [PR 9533](https://github.com/spyder-ide/spyder/pull/9533) - PR: Add documentation element to calltips in the IPython Console ([9529](https://github.com/spyder-ide/spyder/issues/9529))
* [PR 9526](https://github.com/spyder-ide/spyder/pull/9526) - PR: Correct indentation folding cases ([9434](https://github.com/spyder-ide/spyder/issues/9434))
* [PR 9524](https://github.com/spyder-ide/spyder/pull/9524) - PR: Add validation for Enter in the File Switcher ([9474](https://github.com/spyder-ide/spyder/issues/9474))
* [PR 9523](https://github.com/spyder-ide/spyder/pull/9523) - PR: Fix Prev/Next cursor position for unsaved files ([8000](https://github.com/spyder-ide/spyder/issues/8000))
* [PR 9521](https://github.com/spyder-ide/spyder/pull/9521) - PR: Fix Fileswitcher for 'EditorStack' instances ([9469](https://github.com/spyder-ide/spyder/issues/9469))
* [PR 9518](https://github.com/spyder-ide/spyder/pull/9518) - PR: Add icons to toggle uppercase/lowercase menu action ([9512](https://github.com/spyder-ide/spyder/issues/9512))
* [PR 9517](https://github.com/spyder-ide/spyder/pull/9517) - PR: Prevent indentation/unindentation in the CodeEditor when Ctrl+Tab or Ctrl+Shift+Tab is pressed ([9515](https://github.com/spyder-ide/spyder/issues/9515))
* [PR 9507](https://github.com/spyder-ide/spyder/pull/9507) - PR: Fix editor tab switcher vertical position ([9506](https://github.com/spyder-ide/spyder/issues/9506))
* [PR 9504](https://github.com/spyder-ide/spyder/pull/9504) - PR: Add support for configurable file extension associations ([9549](https://github.com/spyder-ide/spyder/issues/9549))
* [PR 9502](https://github.com/spyder-ide/spyder/pull/9502) - PR: Restore cursor properly in the Editor after a key release or a focus out event. ([9501](https://github.com/spyder-ide/spyder/issues/9501))
* [PR 9494](https://github.com/spyder-ide/spyder/pull/9494) - PR: Remove cell separator detection from syntax highlighting and use oedata instead ([9443](https://github.com/spyder-ide/spyder/issues/9443))
* [PR 9485](https://github.com/spyder-ide/spyder/pull/9485) - PR: Use file contents to decide when to autosave ([9265](https://github.com/spyder-ide/spyder/issues/9265))
* [PR 9482](https://github.com/spyder-ide/spyder/pull/9482) - PR: Add support for LSP workspace calls ([9522](https://github.com/spyder-ide/spyder/issues/9522), [9007](https://github.com/spyder-ide/spyder/issues/9007))
* [PR 9478](https://github.com/spyder-ide/spyder/pull/9478) - PR: Add icon for binary files
* [PR 9477](https://github.com/spyder-ide/spyder/pull/9477) - PR: Fix background color of information icon in File Switcher ([9442](https://github.com/spyder-ide/spyder/issues/9442))
* [PR 9473](https://github.com/spyder-ide/spyder/pull/9473) - PR: Add uri hover and click detection for shorthand github/bitbucket/gitlab issues ([9463](https://github.com/spyder-ide/spyder/issues/9463))
* [PR 9468](https://github.com/spyder-ide/spyder/pull/9468) - PR: Disable LSP services on CodeEditors before restarting LSP client ([9425](https://github.com/spyder-ide/spyder/issues/9425))
* [PR 9467](https://github.com/spyder-ide/spyder/pull/9467) - PR: Handle git not found error and add regression test ([9449](https://github.com/spyder-ide/spyder/issues/9449))
* [PR 9459](https://github.com/spyder-ide/spyder/pull/9459) - PR: Autocomplete only left part of selected word.
* [PR 9458](https://github.com/spyder-ide/spyder/pull/9458) - PR: Fix custom shortcut not displayed in menu entries for "Run cell" and "Run cell and advance"  ([8076](https://github.com/spyder-ide/spyder/issues/8076))
* [PR 9450](https://github.com/spyder-ide/spyder/pull/9450) - PR: Fix editor scrollflag area position and height under the dark theme ([9439](https://github.com/spyder-ide/spyder/issues/9439))
* [PR 9444](https://github.com/spyder-ide/spyder/pull/9444) - PR: Fix code cells that fill the whole screen lose their background highlight ([9443](https://github.com/spyder-ide/spyder/issues/9443))
* [PR 9437](https://github.com/spyder-ide/spyder/pull/9437) - PR: Try to reduce some flakiness in our tests
* [PR 9430](https://github.com/spyder-ide/spyder/pull/9430) - PR: Make Code Analysis pane follow the currently active file ([1536](https://github.com/spyder-ide/spyder/issues/1536))
* [PR 9422](https://github.com/spyder-ide/spyder/pull/9422) - PR: Enhance the display of warnings and errors  ([9247](https://github.com/spyder-ide/spyder/issues/9247))
* [PR 9417](https://github.com/spyder-ide/spyder/pull/9417) - PR: Reorganize global fixtures in conftest files
* [PR 9410](https://github.com/spyder-ide/spyder/pull/9410) - PR: Minor layout improvement to the "Appearance" preference panel.
* [PR 9407](https://github.com/spyder-ide/spyder/pull/9407) - PR: Disable zooming and update displayed scaling percent when "Fits plot to window" is checked ([9405](https://github.com/spyder-ide/spyder/issues/9405))
* [PR 9404](https://github.com/spyder-ide/spyder/pull/9404) - PR: Add a code of conduct
* [PR 9402](https://github.com/spyder-ide/spyder/pull/9402) - PR: Connect project explorer to file explorer when "Single click to open" option is updated ([9303](https://github.com/spyder-ide/spyder/issues/9303))
* [PR 9401](https://github.com/spyder-ide/spyder/pull/9401) - PR: Fix signature format for dict kwargs ([9395](https://github.com/spyder-ide/spyder/issues/9395))
* [PR 9400](https://github.com/spyder-ide/spyder/pull/9400) - PR: Fix Ctrl+Tab to cycle files on the editor ([6055](https://github.com/spyder-ide/spyder/issues/6055))
* [PR 9394](https://github.com/spyder-ide/spyder/pull/9394) - PR: Change calltip from tool to tooltip on linux ([9393](https://github.com/spyder-ide/spyder/issues/9393))
* [PR 9387](https://github.com/spyder-ide/spyder/pull/9387) - PR: Underline URIs in the Editor and enable opening them by Ctrl+click
* [PR 9386](https://github.com/spyder-ide/spyder/pull/9386) - PR: Resize plot when Plots pane is resized and "Fits plots to window" is checked. ([9368](https://github.com/spyder-ide/spyder/issues/9368))
* [PR 9385](https://github.com/spyder-ide/spyder/pull/9385) - PR: Improve LSP preferences UI
* [PR 9382](https://github.com/spyder-ide/spyder/pull/9382) - PR: Don't package our tests in our wheels and tarball
* [PR 9380](https://github.com/spyder-ide/spyder/pull/9380) - PR: Fix not selecting the right LSP language in "Other languages" tab
* [PR 9377](https://github.com/spyder-ide/spyder/pull/9377) - PR: Update MathJax to its latest version ([9357](https://github.com/spyder-ide/spyder/issues/9357))
* [PR 9371](https://github.com/spyder-ide/spyder/pull/9371) - PR: Fix test_get_git_refs when run by Travis on tags
* [PR 9364](https://github.com/spyder-ide/spyder/pull/9364) - PR: Move test_calltip to test_hints_and_calltips.py
* [PR 9363](https://github.com/spyder-ide/spyder/pull/9363) - PR: Refactor code in LSPManager to not imply that we're still passing signals around
* [PR 9362](https://github.com/spyder-ide/spyder/pull/9362) - PR: Show nicer close icons on macOS when hovering on tabs
* [PR 9320](https://github.com/spyder-ide/spyder/pull/9320) - PR: Reimplement fallback plugin for code completions
* [PR 9290](https://github.com/spyder-ide/spyder/pull/9290) - PR: Correctly handle programming language in calltips ([9194](https://github.com/spyder-ide/spyder/issues/9194))
* [PR 9274](https://github.com/spyder-ide/spyder/pull/9274) - PR: Shutdown running kernels more forcefully so they close faster
* [PR 9249](https://github.com/spyder-ide/spyder/pull/9249) - PR: Add stdio LSP transport client
* [PR 9226](https://github.com/spyder-ide/spyder/pull/9226) - PR: Add SpyderPlugin class to public API
* [PR 9219](https://github.com/spyder-ide/spyder/pull/9219) - PR: Highlight current entry in the Outline Explorer and update it on-the-fly ([885](https://github.com/spyder-ide/spyder/issues/885))
* [PR 9082](https://github.com/spyder-ide/spyder/pull/9082) - PR: Use blocks to identify lines and add unique cell names ([9085](https://github.com/spyder-ide/spyder/issues/9085), [7976](https://github.com/spyder-ide/spyder/issues/7976))
* [PR 8852](https://github.com/spyder-ide/spyder/pull/8852) - PR: Add an Object Explorer to the Variable Explorer ([558](https://github.com/spyder-ide/spyder/issues/558))
* [PR 8768](https://github.com/spyder-ide/spyder/pull/8768) - PR: Change IPython Console icon
* [PR 8734](https://github.com/spyder-ide/spyder/pull/8734) - PR: Remove blanks if no content is added in a line and Enter is pressed to create a new line ([8564](https://github.com/spyder-ide/spyder/issues/8564))
* [PR 8381](https://github.com/spyder-ide/spyder/pull/8381) - PR: Add some color schemes from Eclipse ([8371](https://github.com/spyder-ide/spyder/issues/8371))

In this release 87 pull requests were closed.


----


## Version 4.0beta2 (2019-05-19)

### Issues Closed

* [Issue 9341](https://github.com/spyder-ide/spyder/issues/9341) - RuntimeError after closing a split editor ([PR 9345](https://github.com/spyder-ide/spyder/pull/9345))
* [Issue 9332](https://github.com/spyder-ide/spyder/issues/9332) - Search is broken in file switcher and produces exception due to indentation error ([PR 9333](https://github.com/spyder-ide/spyder/pull/9333))
* [Issue 9323](https://github.com/spyder-ide/spyder/issues/9323) - Close brackets or close quotes doesn't update the LSP ([PR 9324](https://github.com/spyder-ide/spyder/pull/9324))
* [Issue 9311](https://github.com/spyder-ide/spyder/issues/9311) - Some issues with calltips and hovers ([PR 9322](https://github.com/spyder-ide/spyder/pull/9322))
* [Issue 9299](https://github.com/spyder-ide/spyder/issues/9299) - Code style warnings are not updated in the Editor after "Delete line" shortcut ([PR 9300](https://github.com/spyder-ide/spyder/pull/9300))
* [Issue 9298](https://github.com/spyder-ide/spyder/issues/9298) - About dialog on OSX is too big and bolded ([PR 9306](https://github.com/spyder-ide/spyder/pull/9306))
* [Issue 9294](https://github.com/spyder-ide/spyder/issues/9294) - Error when getting hover of "dict" ([PR 9301](https://github.com/spyder-ide/spyder/pull/9301))
* [Issue 9287](https://github.com/spyder-ide/spyder/issues/9287) - Hovers, tooltips and calltips are shown at the wrong position on Linux ([PR 9293](https://github.com/spyder-ide/spyder/pull/9293))
* [Issue 9281](https://github.com/spyder-ide/spyder/issues/9281) - Avoid the possibility of duplicate preferences dialogs ([PR 9280](https://github.com/spyder-ide/spyder/pull/9280))
* [Issue 9273](https://github.com/spyder-ide/spyder/issues/9273) - Autocomplete choice 1 option ([PR 9260](https://github.com/spyder-ide/spyder/pull/9260))
* [Issue 9269](https://github.com/spyder-ide/spyder/issues/9269) - Autocompletion doesn't update ([PR 9260](https://github.com/spyder-ide/spyder/pull/9260))
* [Issue 9268](https://github.com/spyder-ide/spyder/issues/9268) - Autocompletion appears right before return and change the text ([PR 9260](https://github.com/spyder-ide/spyder/pull/9260))
* [Issue 9267](https://github.com/spyder-ide/spyder/issues/9267) - Auto completion widget shows even after line return ([PR 9260](https://github.com/spyder-ide/spyder/pull/9260))
* [Issue 9257](https://github.com/spyder-ide/spyder/issues/9257) - Spyder steals my letters! ([PR 9260](https://github.com/spyder-ide/spyder/pull/9260))
* [Issue 9248](https://github.com/spyder-ide/spyder/issues/9248) - Appearance preferences for syntax highlighting with dark theme look weird ([PR 9348](https://github.com/spyder-ide/spyder/pull/9348))
* [Issue 9245](https://github.com/spyder-ide/spyder/issues/9245) - Improve dialog to start servers for other languages
* [Issue 9242](https://github.com/spyder-ide/spyder/issues/9242) - Remove unused Pyflakes and pep8 checks ([PR 9243](https://github.com/spyder-ide/spyder/pull/9243))
* [Issue 9236](https://github.com/spyder-ide/spyder/issues/9236) - Opening a new editor window results in an error ([PR 9282](https://github.com/spyder-ide/spyder/pull/9282))
* [Issue 9211](https://github.com/spyder-ide/spyder/issues/9211) - Show PyLS server errors in Spyder's error report dialog ([PR 9266](https://github.com/spyder-ide/spyder/pull/9266))
* [Issue 9209](https://github.com/spyder-ide/spyder/issues/9209) - Setting ignore rules for Pycodestyle is not working ([PR 9231](https://github.com/spyder-ide/spyder/pull/9231))
* [Issue 9208](https://github.com/spyder-ide/spyder/issues/9208) - Hide debugger panel for files that are not Python ones ([PR 9289](https://github.com/spyder-ide/spyder/pull/9289))
* [Issue 9207](https://github.com/spyder-ide/spyder/issues/9207) - Rename plugins for a simpler, less crowded interface ([PR 9237](https://github.com/spyder-ide/spyder/pull/9237))
* [Issue 9195](https://github.com/spyder-ide/spyder/issues/9195) - Cannot connect to an external PyLS server ([PR 9203](https://github.com/spyder-ide/spyder/pull/9203))
* [Issue 9187](https://github.com/spyder-ide/spyder/issues/9187) - Define Hint behavior ([PR 9191](https://github.com/spyder-ide/spyder/pull/9191))
* [Issue 9173](https://github.com/spyder-ide/spyder/issues/9173) - Error when closing a panel ([PR 9175](https://github.com/spyder-ide/spyder/pull/9175))
* [Issue 9151](https://github.com/spyder-ide/spyder/issues/9151) - Add icons for Latex file type ([PR 9228](https://github.com/spyder-ide/spyder/pull/9228))
* [Issue 9150](https://github.com/spyder-ide/spyder/issues/9150) - Improve the "Open recent" menu ([PR 9230](https://github.com/spyder-ide/spyder/pull/9230))
* [Issue 9120](https://github.com/spyder-ide/spyder/issues/9120) - QDarkStyle issue on Mac for status bar ([PR 9121](https://github.com/spyder-ide/spyder/pull/9121))
* [Issue 9044](https://github.com/spyder-ide/spyder/issues/9044) - Editor text is all shown in bold text ([PR 9046](https://github.com/spyder-ide/spyder/pull/9046))
* [Issue 9006](https://github.com/spyder-ide/spyder/issues/9006) - Shorten status bar widgets size ([PR 9010](https://github.com/spyder-ide/spyder/pull/9010))
* [Issue 8985](https://github.com/spyder-ide/spyder/issues/8985) - Reconnect warning menu with PyLS output ([PR 9011](https://github.com/spyder-ide/spyder/pull/9011))
* [Issue 8930](https://github.com/spyder-ide/spyder/issues/8930) - Single click to interact with items in Project Explorer, rather than double-click ([PR 9024](https://github.com/spyder-ide/spyder/pull/9024))
* [Issue 8865](https://github.com/spyder-ide/spyder/issues/8865) - LSP services don't work in any split Editor pane but the first (left/topmost) one ([PR 9075](https://github.com/spyder-ide/spyder/pull/9075))
* [Issue 8859](https://github.com/spyder-ide/spyder/issues/8859) - Completion popup menu isn't dismissed after typing a delimiter and causes unexpected behavior ([PR 9057](https://github.com/spyder-ide/spyder/pull/9057))
* [Issue 8846](https://github.com/spyder-ide/spyder/issues/8846) - Errors in the debugger panel and stuck indicator after ending the debugging ([PR 8854](https://github.com/spyder-ide/spyder/pull/8854))
* [Issue 8828](https://github.com/spyder-ide/spyder/issues/8828) - Tests are failing with PyLS 0.23+ ([PR 8972](https://github.com/spyder-ide/spyder/pull/8972))
* [Issue 8816](https://github.com/spyder-ide/spyder/issues/8816) - Deleting a server in the LSP preferences pane when only one is present raises exceptions ([PR 8647](https://github.com/spyder-ide/spyder/pull/8647))
* [Issue 8815](https://github.com/spyder-ide/spyder/issues/8815) - Error in code completion when case-sensitive completions are disabled ([PR 9104](https://github.com/spyder-ide/spyder/pull/9104))
* [Issue 8813](https://github.com/spyder-ide/spyder/issues/8813) - Errors triggered when saving "Saving as" a file in latest master ([PR 8932](https://github.com/spyder-ide/spyder/pull/8932))
* [Issue 8749](https://github.com/spyder-ide/spyder/issues/8749) - Closing moved files creates IndexError ([PR 8782](https://github.com/spyder-ide/spyder/pull/8782))
* [Issue 8727](https://github.com/spyder-ide/spyder/issues/8727) - autocomplete fails to select an option in the list ([PR 8724](https://github.com/spyder-ide/spyder/pull/8724))
* [Issue 8723](https://github.com/spyder-ide/spyder/issues/8723) - autocomplete fails when pressing tab too quickly ([PR 8724](https://github.com/spyder-ide/spyder/pull/8724))
* [Issue 8655](https://github.com/spyder-ide/spyder/issues/8655) - Autosave not removed when closing a changed file without saving ([PR 8733](https://github.com/spyder-ide/spyder/pull/8733))
* [Issue 8654](https://github.com/spyder-ide/spyder/issues/8654) - Text files are wrongly autosaved when opened without changing them ([PR 9205](https://github.com/spyder-ide/spyder/pull/9205))
* [Issue 8641](https://github.com/spyder-ide/spyder/issues/8641) - Assign a keyboard shortcut for "next figure" and "previous figure" of the Plots pane ([PR 8643](https://github.com/spyder-ide/spyder/pull/8643))
* [Issue 8640](https://github.com/spyder-ide/spyder/issues/8640) - Assign a keyboard shortcut to switch to the Plots pane ([PR 9036](https://github.com/spyder-ide/spyder/pull/9036))
* [Issue 8631](https://github.com/spyder-ide/spyder/issues/8631) - Cannot restore files between different drives in Windows ([PR 8650](https://github.com/spyder-ide/spyder/pull/8650))
* [Issue 8628](https://github.com/spyder-ide/spyder/issues/8628) - Autocomplete replace "import" keyword ([PR 8648](https://github.com/spyder-ide/spyder/pull/8648))
* [Issue 8626](https://github.com/spyder-ide/spyder/issues/8626) - Display warning about rendering of plots below the new IPython prompt ([PR 8627](https://github.com/spyder-ide/spyder/pull/8627))
* [Issue 8613](https://github.com/spyder-ide/spyder/issues/8613) - Use new functionality in Qt 5.6 to resize dockwidgets programatically ([PR 9155](https://github.com/spyder-ide/spyder/pull/9155))
* [Issue 8609](https://github.com/spyder-ide/spyder/issues/8609) - Disabling Automatic Code Completion makes completion, analysis and calltips stop working permanently ([PR 9104](https://github.com/spyder-ide/spyder/pull/9104))
* [Issue 8603](https://github.com/spyder-ide/spyder/issues/8603) - The command line does not appear in ipython console after the warning about rendering of plots is displayed. ([PR 8604](https://github.com/spyder-ide/spyder/pull/8604))
* [Issue 8579](https://github.com/spyder-ide/spyder/issues/8579) - Error when triggering completion in the Internal Console ([PR 8593](https://github.com/spyder-ide/spyder/pull/8593))
* [Issue 8567](https://github.com/spyder-ide/spyder/issues/8567) - Deleting a folder which contains a sub-folder(s) raises an error ([PR 8599](https://github.com/spyder-ide/spyder/pull/8599))
* [Issue 8566](https://github.com/spyder-ide/spyder/issues/8566) - File names pasted in editor when copied from OS file manager ([PR 8569](https://github.com/spyder-ide/spyder/pull/8569))
* [Issue 8565](https://github.com/spyder-ide/spyder/issues/8565) - Code analysis and completion often break when the "Automatic code completion" option is checked ([PR 8600](https://github.com/spyder-ide/spyder/pull/8600))
* [Issue 8560](https://github.com/spyder-ide/spyder/issues/8560) - Sometimes segmentation Fault when placing the mouse cursor over linenumbers ([PR 5283](https://github.com/spyder-ide/spyder/pull/5283))
* [Issue 8557](https://github.com/spyder-ide/spyder/issues/8557) - KeyError when closing dataframe editor ([PR 8559](https://github.com/spyder-ide/spyder/pull/8559))
* [Issue 8556](https://github.com/spyder-ide/spyder/issues/8556) - Outline Explorer does not properly handle async functions and methods ([PR 8821](https://github.com/spyder-ide/spyder/pull/8821))
* [Issue 8545](https://github.com/spyder-ide/spyder/issues/8545) - Full Screen in dual monitor enviroment (windows) ([PR 8546](https://github.com/spyder-ide/spyder/pull/8546))
* [Issue 8523](https://github.com/spyder-ide/spyder/issues/8523) - Plot plugin context menu wrong style and copy to clipboard action glitches ([PR 8524](https://github.com/spyder-ide/spyder/pull/8524))
* [Issue 8520](https://github.com/spyder-ide/spyder/issues/8520) - Enclose console warning about plots being rendered in the Plots plugin in horizontal bars ([PR 8584](https://github.com/spyder-ide/spyder/pull/8584))
* [Issue 8515](https://github.com/spyder-ide/spyder/issues/8515) - Error when deleting a project ([PR 8516](https://github.com/spyder-ide/spyder/pull/8516))
* [Issue 8511](https://github.com/spyder-ide/spyder/issues/8511) - Not working shortcut for copy figure in Plots Widget if there are multiple consoles. ([PR 8512](https://github.com/spyder-ide/spyder/pull/8512))
* [Issue 8510](https://github.com/spyder-ide/spyder/issues/8510) - Error when trying to go to cursor position in Outline ([PR 8517](https://github.com/spyder-ide/spyder/pull/8517))
* [Issue 8506](https://github.com/spyder-ide/spyder/issues/8506) - AttributeError: 'WebView' object has no attribute 'setBackgroundColor' ([PR 8508](https://github.com/spyder-ide/spyder/pull/8508))
* [Issue 8486](https://github.com/spyder-ide/spyder/issues/8486) - The editor menu has undock option after undock. ([PR 8489](https://github.com/spyder-ide/spyder/pull/8489))
* [Issue 8478](https://github.com/spyder-ide/spyder/issues/8478) - Improve IPython console Options menu ([PR 8578](https://github.com/spyder-ide/spyder/pull/8578))
* [Issue 8477](https://github.com/spyder-ide/spyder/issues/8477) - Set dark color for blank html template ([PR 8497](https://github.com/spyder-ide/spyder/pull/8497))
* [Issue 8468](https://github.com/spyder-ide/spyder/issues/8468) - Feature Request: copy figure of plot widget to clipboard ([PR 8470](https://github.com/spyder-ide/spyder/pull/8470))
* [Issue 8458](https://github.com/spyder-ide/spyder/issues/8458) - Spyder won't load previously open files from any project with a clean prefs file ([PR 8460](https://github.com/spyder-ide/spyder/pull/8460))
* [Issue 8455](https://github.com/spyder-ide/spyder/issues/8455) - Project Explorer is sometimes not set correctly when switching projects ([PR 8456](https://github.com/spyder-ide/spyder/pull/8456))
* [Issue 8450](https://github.com/spyder-ide/spyder/issues/8450) - Project switching with recent projects menu fails to open correct project ([PR 8452](https://github.com/spyder-ide/spyder/pull/8452))
* [Issue 8443](https://github.com/spyder-ide/spyder/issues/8443) - Backgroud color of Plotwidget in dark theme ([PR 8446](https://github.com/spyder-ide/spyder/pull/8446))
* [Issue 8388](https://github.com/spyder-ide/spyder/issues/8388) - Use language type icons present in Material design ([PR 8440](https://github.com/spyder-ide/spyder/pull/8440))
* [Issue 8386](https://github.com/spyder-ide/spyder/issues/8386) - Change function/class/method icons ([PR 8390](https://github.com/spyder-ide/spyder/pull/8390))
* [Issue 8375](https://github.com/spyder-ide/spyder/issues/8375) - Spyder editor does not open previously opened files in a project ([PR 8429](https://github.com/spyder-ide/spyder/pull/8429))
* [Issue 8344](https://github.com/spyder-ide/spyder/issues/8344) - Title field of error dialog is too small in macOS ([PR 8378](https://github.com/spyder-ide/spyder/pull/8378))
* [Issue 8330](https://github.com/spyder-ide/spyder/issues/8330) - qtawsome 0.5.0 requirements is not high enough for master ([PR 8340](https://github.com/spyder-ide/spyder/pull/8340))
* [Issue 8321](https://github.com/spyder-ide/spyder/issues/8321) - Make a copy of a files inside Project explorer ([PR 8606](https://github.com/spyder-ide/spyder/pull/8606))
* [Issue 8320](https://github.com/spyder-ide/spyder/issues/8320) - Some issues with the Plots plugin ([PR 8419](https://github.com/spyder-ide/spyder/pull/8419))
* [Issue 8309](https://github.com/spyder-ide/spyder/issues/8309) - A word write wrong in portuguese in the file pt_BR/LC_MESSAGES/spyder.po ([PR 8441](https://github.com/spyder-ide/spyder/pull/8441))
* [Issue 8297](https://github.com/spyder-ide/spyder/issues/8297) - Autocomplete doesn't replace text sometimes ([PR 8434](https://github.com/spyder-ide/spyder/pull/8434))
* [Issue 8293](https://github.com/spyder-ide/spyder/issues/8293) - More easily override conflicted shortcuts ([PR 9031](https://github.com/spyder-ide/spyder/pull/9031))
* [Issue 8291](https://github.com/spyder-ide/spyder/issues/8291) - Add QDarkstyle to the Dependencies list ([PR 8300](https://github.com/spyder-ide/spyder/pull/8300))
* [Issue 8284](https://github.com/spyder-ide/spyder/issues/8284) - Improve "Spyder Dark" syntax highlighting theme ([PR 8357](https://github.com/spyder-ide/spyder/pull/8357))
* [Issue 8283](https://github.com/spyder-ide/spyder/issues/8283) - AttributeError: 'NoneType' object has no attribute 'raise_' error on startup in latest master ([PR 8349](https://github.com/spyder-ide/spyder/pull/8349))
* [Issue 8270](https://github.com/spyder-ide/spyder/issues/8270) - Simplify Github PR template ([PR 8272](https://github.com/spyder-ide/spyder/pull/8272))
* [Issue 8267](https://github.com/spyder-ide/spyder/issues/8267) - Triple quotes in a code cell breaks runcell ([PR 8276](https://github.com/spyder-ide/spyder/pull/8276))
* [Issue 8244](https://github.com/spyder-ide/spyder/issues/8244) - Runcell traceback line number off by one for every code block it's after  ([PR 8245](https://github.com/spyder-ide/spyder/pull/8245))
* [Issue 8242](https://github.com/spyder-ide/spyder/issues/8242) - Double Quotes at the beginning or end of the a code cell breaks runcell ([PR 8245](https://github.com/spyder-ide/spyder/pull/8245))
* [Issue 8241](https://github.com/spyder-ide/spyder/issues/8241) - Cannot runcell if double backslash is present ([PR 8243](https://github.com/spyder-ide/spyder/pull/8243))
* [Issue 8237](https://github.com/spyder-ide/spyder/issues/8237) - Mitigate Spyder wiping users' files with more robust atomic saves/autosaves ([PR 8347](https://github.com/spyder-ide/spyder/pull/8347))
* [Issue 8213](https://github.com/spyder-ide/spyder/issues/8213) - PyLS hangs if definition cannot be located ([PR 9138](https://github.com/spyder-ide/spyder/pull/9138))
* [Issue 8172](https://github.com/spyder-ide/spyder/issues/8172) - Warnings and errors from PyLS don't go away after fixing them, even when saving file ([PR 8257](https://github.com/spyder-ide/spyder/pull/8257))
* [Issue 8171](https://github.com/spyder-ide/spyder/issues/8171) - Plots plugin is not docked correctly after first start ([PR 8192](https://github.com/spyder-ide/spyder/pull/8192))
* [Issue 8159](https://github.com/spyder-ide/spyder/issues/8159) - PATH problem since updating macOS ([PR 8351](https://github.com/spyder-ide/spyder/pull/8351))
* [Issue 8153](https://github.com/spyder-ide/spyder/issues/8153) - Spyder crashes on launch with PyLS >=0.21 ([PR 8600](https://github.com/spyder-ide/spyder/pull/8600))
* [Issue 8121](https://github.com/spyder-ide/spyder/issues/8121) - Option to show/hide code style analysis warnings does not work ([PR 9182](https://github.com/spyder-ide/spyder/pull/9182))
* [Issue 8087](https://github.com/spyder-ide/spyder/issues/8087) - Add dark theme style to Help pane ([PR 8086](https://github.com/spyder-ide/spyder/pull/8086))
* [Issue 8080](https://github.com/spyder-ide/spyder/issues/8080) - Consider making the dark theme (and corresponding Spyder Dark syntax scheme) the default in Spyder 4 ([PR 8266](https://github.com/spyder-ide/spyder/pull/8266))
* [Issue 8072](https://github.com/spyder-ide/spyder/issues/8072) - Make internal console respect user's syntax highlighting theme ([PR 8251](https://github.com/spyder-ide/spyder/pull/8251))
* [Issue 8071](https://github.com/spyder-ide/spyder/issues/8071) - Centralize remaining theme-related options (like Rstudio does) under a renamed "Themes" pref pane ([PR 8266](https://github.com/spyder-ide/spyder/pull/8266))
* [Issue 8069](https://github.com/spyder-ide/spyder/issues/8069) - Spyder dark theme overrides background color set in syntax highlighting theme, except behind text ([PR 8081](https://github.com/spyder-ide/spyder/pull/8081))
* [Issue 8066](https://github.com/spyder-ide/spyder/issues/8066) - The pyls process opens a black DOS windows under Windows10 ([PR 8360](https://github.com/spyder-ide/spyder/pull/8360))
* [Issue 8056](https://github.com/spyder-ide/spyder/issues/8056) - Shift-Tab moves focus outside of current Editor pane in Spyder 4
* [Issue 8043](https://github.com/spyder-ide/spyder/issues/8043) - Closing a Python file in Spyder cause a LSP error ([PR 8044](https://github.com/spyder-ide/spyder/pull/8044))
* [Issue 8037](https://github.com/spyder-ide/spyder/issues/8037) - DataFrames in Variable Explorer: Missings should have distinctive background color ([PR 8059](https://github.com/spyder-ide/spyder/pull/8059))
* [Issue 8022](https://github.com/spyder-ide/spyder/issues/8022) - KeyboardInterrupt shows up when Spyder starts ([PR 8600](https://github.com/spyder-ide/spyder/pull/8600))
* [Issue 8013](https://github.com/spyder-ide/spyder/issues/8013) - Stop button in the IPython console is not working with Python 3.7 on Windows ([PR 8337](https://github.com/spyder-ide/spyder/pull/8337))
* [Issue 8011](https://github.com/spyder-ide/spyder/issues/8011) - Restore option to open a new editor window ([PR 8192](https://github.com/spyder-ide/spyder/pull/8192))
* [Issue 7996](https://github.com/spyder-ide/spyder/issues/7996) - Cog menu glitch during Spyder setup in master ([PR 8004](https://github.com/spyder-ide/spyder/pull/8004))
* [Issue 7993](https://github.com/spyder-ide/spyder/issues/7993) - Order of root file items in the Outline Explorer should be synced with that of the current EditorStack ([PR 8015](https://github.com/spyder-ide/spyder/pull/8015))
* [Issue 7982](https://github.com/spyder-ide/spyder/issues/7982) - Show files that are not Python files in the Outline Explorer ([PR 7984](https://github.com/spyder-ide/spyder/pull/7984))
* [Issue 7963](https://github.com/spyder-ide/spyder/issues/7963) - TODO labels are missing in Spyder 4 ([PR 8004](https://github.com/spyder-ide/spyder/pull/8004))
* [Issue 7930](https://github.com/spyder-ide/spyder/issues/7930) - UnicodeEncodeError in TextEditor ([PR 8342](https://github.com/spyder-ide/spyder/pull/8342))
* [Issue 7905](https://github.com/spyder-ide/spyder/issues/7905) - Connect to remote kernel: Have a choice between password or keyfile ([PR 7914](https://github.com/spyder-ide/spyder/pull/7914))
* [Issue 7885](https://github.com/spyder-ide/spyder/issues/7885) - numpy.set_printoptions formatter keyword has no effect on output
* [Issue 7883](https://github.com/spyder-ide/spyder/issues/7883) - GNU Emacs Style Key Sequences do not work in master AND shortcut conflicts ([PR 7929](https://github.com/spyder-ide/spyder/pull/7929))
* [Issue 7880](https://github.com/spyder-ide/spyder/issues/7880) - Error when closing dataframe while data is being fetched ([PR 8598](https://github.com/spyder-ide/spyder/pull/8598))
* [Issue 7875](https://github.com/spyder-ide/spyder/issues/7875) - Config is resetted after a CONF_VERSION bump ([PR 8397](https://github.com/spyder-ide/spyder/pull/8397))
* [Issue 7872](https://github.com/spyder-ide/spyder/issues/7872) - The "Next word" and " Previous word" shortcuts do not work as expected ([PR 7874](https://github.com/spyder-ide/spyder/pull/7874))
* [Issue 7865](https://github.com/spyder-ide/spyder/issues/7865) - Multiple `History...` entries in Static Code Analysis context menu ([PR 7866](https://github.com/spyder-ide/spyder/pull/7866))
* [Issue 7854](https://github.com/spyder-ide/spyder/issues/7854) - Problem with shortcuts using the "Shift" and another key ([PR 7929](https://github.com/spyder-ide/spyder/pull/7929))
* [Issue 7845](https://github.com/spyder-ide/spyder/issues/7845) - Select the dark or light version of the Spyder icon in the "About Spyder" dialog window depending on the color of the window background ([PR 8541](https://github.com/spyder-ide/spyder/pull/8541))
* [Issue 7833](https://github.com/spyder-ide/spyder/issues/7833) - Completion not working in Editor due to undeclared dependency on coloredlogs ([PR 7994](https://github.com/spyder-ide/spyder/pull/7994))
* [Issue 7798](https://github.com/spyder-ide/spyder/issues/7798) - Outline explorer do not sync correctly when closing/re-opening a file in master ([PR 7799](https://github.com/spyder-ide/spyder/pull/7799))
* [Issue 7760](https://github.com/spyder-ide/spyder/issues/7760) - Run unsaved file in Editor without needing to save ([PR 7310](https://github.com/spyder-ide/spyder/pull/7310))
* [Issue 7754](https://github.com/spyder-ide/spyder/issues/7754) - Saving a new file or renaming an existing file in master is broken ([PR 7758](https://github.com/spyder-ide/spyder/pull/7758))
* [Issue 7751](https://github.com/spyder-ide/spyder/issues/7751) - 'ClientWidget' object has no attribute 'show_time_action' ([PR 8062](https://github.com/spyder-ide/spyder/pull/8062))
* [Issue 7744](https://github.com/spyder-ide/spyder/issues/7744) - Go to line is not working in the outline explorer when clicking on the last item of a file ([PR 7745](https://github.com/spyder-ide/spyder/pull/7745))
* [Issue 7743](https://github.com/spyder-ide/spyder/issues/7743) - The "Redo" shortcut in the Editor is not working in Spyder4.0.0.dev0 ([PR 7768](https://github.com/spyder-ide/spyder/pull/7768))
* [Issue 7736](https://github.com/spyder-ide/spyder/issues/7736) - Add the outline explorer option "Group code cells" to config and make it False by default ([PR 7738](https://github.com/spyder-ide/spyder/pull/7738))
* [Issue 7729](https://github.com/spyder-ide/spyder/issues/7729) - The "Go to cursor position" feature of the outline explorer  is broken in master ([PR 7730](https://github.com/spyder-ide/spyder/pull/7730))
* [Issue 7726](https://github.com/spyder-ide/spyder/issues/7726) - Go to definition in the Editor stopped working after the introspection services migration to use the LSP ([PR 7975](https://github.com/spyder-ide/spyder/pull/7975))
* [Issue 7704](https://github.com/spyder-ide/spyder/issues/7704) - No cog menu in variable explorer widget toolbar when more than one Ipython console is opened ([PR 7710](https://github.com/spyder-ide/spyder/pull/7710))
* [Issue 7680](https://github.com/spyder-ide/spyder/issues/7680) - Use a separate configuration directory for beta and dev releases to avoid contaminating user settings ([PR 8837](https://github.com/spyder-ide/spyder/pull/8837))
* [Issue 7629](https://github.com/spyder-ide/spyder/issues/7629) - DataFrame viewer resizes the index column wrongly ([PR 8550](https://github.com/spyder-ide/spyder/pull/8550))
* [Issue 7518](https://github.com/spyder-ide/spyder/issues/7518) - Creating a new project makes the path with mixed slashes ([PR 7698](https://github.com/spyder-ide/spyder/pull/7698))
* [Issue 7339](https://github.com/spyder-ide/spyder/issues/7339) - Indent guides going too far down ([PR 8469](https://github.com/spyder-ide/spyder/pull/8469))
* [Issue 7338](https://github.com/spyder-ide/spyder/issues/7338) - Outline explorer not synchronized at startup ([PR 7968](https://github.com/spyder-ide/spyder/pull/7968))
* [Issue 7235](https://github.com/spyder-ide/spyder/issues/7235) - Outliner has no options in the "gear" menu ([PR 7866](https://github.com/spyder-ide/spyder/pull/7866))
* [Issue 7224](https://github.com/spyder-ide/spyder/issues/7224) - Clearing the variables in a console also clears Pylab and SymPy name spaces and variables ([PR 7876](https://github.com/spyder-ide/spyder/pull/7876))
* [Issue 7214](https://github.com/spyder-ide/spyder/issues/7214) - Outline pane, clicking on file name should move to start of file ([PR 7962](https://github.com/spyder-ide/spyder/pull/7962))
* [Issue 7146](https://github.com/spyder-ide/spyder/issues/7146) - MacOS displaying Windows icons and shortcuts ([PR 8212](https://github.com/spyder-ide/spyder/pull/8212))
* [Issue 7113](https://github.com/spyder-ide/spyder/issues/7113) - Make a function that runs cell blocks instead of copying cell contents into the console ([PR 7310](https://github.com/spyder-ide/spyder/pull/7310))
* [Issue 7111](https://github.com/spyder-ide/spyder/issues/7111) - Master: There is an area in the top left of spyder that is unclickable ([PR 8104](https://github.com/spyder-ide/spyder/pull/8104))
* [Issue 7109](https://github.com/spyder-ide/spyder/issues/7109) - Allow keyboard shorcuts to be cleared in preferences ([PR 7929](https://github.com/spyder-ide/spyder/pull/7929))
* [Issue 7091](https://github.com/spyder-ide/spyder/issues/7091) - QtWebEngineProcess stays open after closing ipython tab ([PR 8740](https://github.com/spyder-ide/spyder/pull/8740))
* [Issue 6827](https://github.com/spyder-ide/spyder/issues/6827) - Enable automatic insertion of closing quotes inside function calls ([PR 8659](https://github.com/spyder-ide/spyder/pull/8659))
* [Issue 5911](https://github.com/spyder-ide/spyder/issues/5911) - Feature Request: Sort tabs alphabetically
* [Issue 5907](https://github.com/spyder-ide/spyder/issues/5907) - Buttons not displayed in mac OS ([PR 8364](https://github.com/spyder-ide/spyder/pull/8364))
* [Issue 5543](https://github.com/spyder-ide/spyder/issues/5543) - Variable explorer column widths are re-generated in every console evaluation ([PR 5764](https://github.com/spyder-ide/spyder/pull/5764))
* [Issue 5515](https://github.com/spyder-ide/spyder/issues/5515) - Enhancements proposal related to the undocking and docking of plugins in the Main Window ([PR 8192](https://github.com/spyder-ide/spyder/pull/8192))
* [Issue 5326](https://github.com/spyder-ide/spyder/issues/5326) - Improve debug logging ([PR 7734](https://github.com/spyder-ide/spyder/pull/7734))
* [Issue 5323](https://github.com/spyder-ide/spyder/issues/5323) - Ctrl+K does not kill to line end
* [Issue 5005](https://github.com/spyder-ide/spyder/issues/5005) - Toggle breakpoints by single click
* [Issue 4936](https://github.com/spyder-ide/spyder/issues/4936) - Feature request: automatic generation of docstring template ([PR 8700](https://github.com/spyder-ide/spyder/pull/8700))
* [Issue 4742](https://github.com/spyder-ide/spyder/issues/4742) - Adapt code introspection, autocompletion and linting to comply with the Language Server Protocol ([PR 4751](https://github.com/spyder-ide/spyder/pull/4751))
* [Issue 4591](https://github.com/spyder-ide/spyder/issues/4591) - Split all plugins to be in their own modules ([PR 7725](https://github.com/spyder-ide/spyder/pull/7725))
* [Issue 4580](https://github.com/spyder-ide/spyder/issues/4580) - Missing "x" on tab for open files in editor ([PR 8363](https://github.com/spyder-ide/spyder/pull/8363))
* [Issue 3689](https://github.com/spyder-ide/spyder/issues/3689) - How to remember the configurations of connecting to remote kernel? ([PR 8222](https://github.com/spyder-ide/spyder/pull/8222))
* [Issue 3414](https://github.com/spyder-ide/spyder/issues/3414) - Add encapsulate with parentheses (quotes, brackets, braces) function ([PR 8637](https://github.com/spyder-ide/spyder/pull/8637))
* [Issue 3064](https://github.com/spyder-ide/spyder/issues/3064) - Allow users to configure PEP8 options ([PR 8647](https://github.com/spyder-ide/spyder/pull/8647))
* [Issue 2855](https://github.com/spyder-ide/spyder/issues/2855) - Hide the titlebar from panes/dockwidgets if locked ([PR 8192](https://github.com/spyder-ide/spyder/pull/8192))
* [Issue 2854](https://github.com/spyder-ide/spyder/issues/2854) - Add custom title bar to dockwidgets/panes ([PR 8192](https://github.com/spyder-ide/spyder/pull/8192))
* [Issue 2641](https://github.com/spyder-ide/spyder/issues/2641) - Enhancement: insert filename as compatible path ([PR 8606](https://github.com/spyder-ide/spyder/pull/8606))
* [Issue 2550](https://github.com/spyder-ide/spyder/issues/2550) - Dock matplotlib figures ([PR 6430](https://github.com/spyder-ide/spyder/pull/6430))
* [Issue 2350](https://github.com/spyder-ide/spyder/issues/2350) - Add a Spyder dark theme
* [Issue 2264](https://github.com/spyder-ide/spyder/issues/2264) - "TODO" should not be labeled with checkmark ([PR 8058](https://github.com/spyder-ide/spyder/pull/8058))
* [Issue 2111](https://github.com/spyder-ide/spyder/issues/2111) - Enhancement: Implement autosave of editor files every X minutes ([PR 7660](https://github.com/spyder-ide/spyder/pull/7660))
* [Issue 1634](https://github.com/spyder-ide/spyder/issues/1634) - Support for current element highlighting when "." appears in selection ([PR 5676](https://github.com/spyder-ide/spyder/pull/5676))
* [Issue 528](https://github.com/spyder-ide/spyder/issues/528) - Add an arrow to point to the current line being debugged in the Editor

In this release 173 issues were closed.

### Pull Requests Merged

* [PR 9355](https://github.com/spyder-ide/spyder/pull/9355) - PR: Add fix for calltips with args and kwargs
* [PR 9348](https://github.com/spyder-ide/spyder/pull/9348) - PR: Fix code editor background color ([9248](https://github.com/spyder-ide/spyder/issues/9248))
* [PR 9345](https://github.com/spyder-ide/spyder/pull/9345) - PR: Remove CodeEditor instances from LSP client when split editor is closed ([9341](https://github.com/spyder-ide/spyder/issues/9341))
* [PR 9334](https://github.com/spyder-ide/spyder/pull/9334) - PR: Fix showing signatures in the IPython console after an open paren
* [PR 9333](https://github.com/spyder-ide/spyder/pull/9333) - PR: Fix fileswitcher search and improve tests ([9332](https://github.com/spyder-ide/spyder/issues/9332))
* [PR 9330](https://github.com/spyder-ide/spyder/pull/9330) - PR: Fix about dialog missing breaks
* [PR 9327](https://github.com/spyder-ide/spyder/pull/9327) - PR: Remove autosaves on successful file close to partially mitigate spurious creation bugs
* [PR 9324](https://github.com/spyder-ide/spyder/pull/9324) - PR: Have LSP update after closequotes and closebrackets ([9323](https://github.com/spyder-ide/spyder/issues/9323))
* [PR 9322](https://github.com/spyder-ide/spyder/pull/9322) - PR: Fix some hover and calltip issues ([9311](https://github.com/spyder-ide/spyder/issues/9311))
* [PR 9310](https://github.com/spyder-ide/spyder/pull/9310) - PR: Restrict PyLS version to be less than 0.25
* [PR 9309](https://github.com/spyder-ide/spyder/pull/9309) - PR: Mark test_update_warnings_after_delete_line as slow and second
* [PR 9306](https://github.com/spyder-ide/spyder/pull/9306) - PR: Fix About dialog format on macOS ([9298](https://github.com/spyder-ide/spyder/issues/9298))
* [PR 9301](https://github.com/spyder-ide/spyder/pull/9301) - PR: Fix hover/calltip for Python objects without signature ([9294](https://github.com/spyder-ide/spyder/issues/9294))
* [PR 9300](https://github.com/spyder-ide/spyder/pull/9300) - PR: Request a didChange when deleting a line in the Editor ([9299](https://github.com/spyder-ide/spyder/issues/9299))
* [PR 9293](https://github.com/spyder-ide/spyder/pull/9293) - PR: Fix window flags for linux calltips ([9287](https://github.com/spyder-ide/spyder/issues/9287))
* [PR 9289](https://github.com/spyder-ide/spyder/pull/9289) - PR: Hide debugger panel for files that are not Python ones ([9208](https://github.com/spyder-ide/spyder/issues/9208))
* [PR 9288](https://github.com/spyder-ide/spyder/pull/9288) - PR: Reorganize LSP server editor dialog
* [PR 9282](https://github.com/spyder-ide/spyder/pull/9282) - PR: Fix update calls of status bars for new Editor windows ([9236](https://github.com/spyder-ide/spyder/issues/9236))
* [PR 9280](https://github.com/spyder-ide/spyder/pull/9280) - PR: Avoid the possibility of duplicate preferences dialogs ([9281](https://github.com/spyder-ide/spyder/issues/9281))
* [PR 9266](https://github.com/spyder-ide/spyder/pull/9266) - PR: Show PyLS server errors in Spyder's error report dialog ([9211](https://github.com/spyder-ide/spyder/issues/9211))
* [PR 9260](https://github.com/spyder-ide/spyder/pull/9260) - PR: Improvements to autocompletion ([9273](https://github.com/spyder-ide/spyder/issues/9273), [9269](https://github.com/spyder-ide/spyder/issues/9269), [9268](https://github.com/spyder-ide/spyder/issues/9268), [9267](https://github.com/spyder-ide/spyder/issues/9267), [9257](https://github.com/spyder-ide/spyder/issues/9257))
* [PR 9243](https://github.com/spyder-ide/spyder/pull/9243) - PR: Remove unused Pyflakes and Pep8 check functions ([9242](https://github.com/spyder-ide/spyder/issues/9242))
* [PR 9237](https://github.com/spyder-ide/spyder/pull/9237) - PR: Rename plugins to have a simpler interface ([9207](https://github.com/spyder-ide/spyder/issues/9207))
* [PR 9231](https://github.com/spyder-ide/spyder/pull/9231) - PR: Handle empty options in pycodestyle and pydocstyle preferences ([9209](https://github.com/spyder-ide/spyder/issues/9209))
* [PR 9230](https://github.com/spyder-ide/spyder/pull/9230) - PR: Display extension type icons and create entry as files are opened in "Open recent" menu ([9150](https://github.com/spyder-ide/spyder/issues/9150))
* [PR 9229](https://github.com/spyder-ide/spyder/pull/9229) - PR: Fix typo on PR template
* [PR 9228](https://github.com/spyder-ide/spyder/pull/9228) - PR: Add icon for Latex files ([9151](https://github.com/spyder-ide/spyder/issues/9151))
* [PR 9224](https://github.com/spyder-ide/spyder/pull/9224) - PR: Ask for animations in pull request template
* [PR 9210](https://github.com/spyder-ide/spyder/pull/9210) - PR: Add a syntax highlighter for Python log files
* [PR 9205](https://github.com/spyder-ide/spyder/pull/9205) - PR: Prevent rehighlight() from setting changed_since_autosave_flag ([8654](https://github.com/spyder-ide/spyder/issues/8654))
* [PR 9203](https://github.com/spyder-ide/spyder/pull/9203) - PR: Add option to connect to external PyLS servers ([9195](https://github.com/spyder-ide/spyder/issues/9195))
* [PR 9191](https://github.com/spyder-ide/spyder/pull/9191) - PR: Enable hover hints ([9187](https://github.com/spyder-ide/spyder/issues/9187))
* [PR 9186](https://github.com/spyder-ide/spyder/pull/9186) - PR: Use a single LSP manager instance per module in our tests
* [PR 9182](https://github.com/spyder-ide/spyder/pull/9182) - PR: Fix Source menu entry to show code style warnings ([8121](https://github.com/spyder-ide/spyder/issues/8121))
* [PR 9176](https://github.com/spyder-ide/spyder/pull/9176) - PR: Avoid running introspection in tests unless we require it
* [PR 9175](https://github.com/spyder-ide/spyder/pull/9175) - PR: Remove sig_lsp_notification and improve introspection tests ([9173](https://github.com/spyder-ide/spyder/issues/9173))
* [PR 9174](https://github.com/spyder-ide/spyder/pull/9174) - PR: Apply dark theme to help icon of arraybuilder
* [PR 9155](https://github.com/spyder-ide/spyder/pull/9155) - PR: Simplify custom layout definition with the new features in Qt 5.6 ([8613](https://github.com/spyder-ide/spyder/issues/8613))
* [PR 9154](https://github.com/spyder-ide/spyder/pull/9154) - PR: Reorganize preferences entry for the Editor
* [PR 9152](https://github.com/spyder-ide/spyder/pull/9152) - PR: Scroll to the selected item after go next thumbnail in Plots plugin
* [PR 9142](https://github.com/spyder-ide/spyder/pull/9142) - PR: Correctly log errors when handling LSP responses for Python 2
* [PR 9140](https://github.com/spyder-ide/spyder/pull/9140) - PR: Use calltip widget to display calltips and tooltips
* [PR 9138](https://github.com/spyder-ide/spyder/pull/9138) - PR: Catch errors generated when handling LSP responses in CodeEditor ([8213](https://github.com/spyder-ide/spyder/issues/8213))
* [PR 9121](https://github.com/spyder-ide/spyder/pull/9121) - PR: Force darkstyle style on status bar ([9120](https://github.com/spyder-ide/spyder/issues/9120))
* [PR 9109](https://github.com/spyder-ide/spyder/pull/9109) - PR: Add an option to sort editor tabs alphabetically
* [PR 9104](https://github.com/spyder-ide/spyder/pull/9104) - PR: Remove "Code Introspection/Analysis" tab of Editor Preferences ([8815](https://github.com/spyder-ide/spyder/issues/8815), [8609](https://github.com/spyder-ide/spyder/issues/8609))
* [PR 9088](https://github.com/spyder-ide/spyder/pull/9088) - PR: Update simplified chinese translation
* [PR 9075](https://github.com/spyder-ide/spyder/pull/9075) - PR: Make completion work in split panels again ([8865](https://github.com/spyder-ide/spyder/issues/8865))
* [PR 9057](https://github.com/spyder-ide/spyder/pull/9057) - PR: Fix completion popup dismissed after typing delimeters or operators ([8859](https://github.com/spyder-ide/spyder/issues/8859))
* [PR 9054](https://github.com/spyder-ide/spyder/pull/9054) - PR: Add an "Fit plots to window" option to the plots pane
* [PR 9048](https://github.com/spyder-ide/spyder/pull/9048) - PR: Add basic active git branch display on status bar
* [PR 9046](https://github.com/spyder-ide/spyder/pull/9046) - PR: Fix bold editor issues when setting bold status widgets ([9044](https://github.com/spyder-ide/spyder/issues/9044))
* [PR 9040](https://github.com/spyder-ide/spyder/pull/9040) - PR: Fix getting Rope completions from the latest PyLS
* [PR 9036](https://github.com/spyder-ide/spyder/pull/9036) - PR: Add Ctrl+Shift+G to switch to plots plugin ([8640](https://github.com/spyder-ide/spyder/issues/8640))
* [PR 9034](https://github.com/spyder-ide/spyder/pull/9034) - PR: Disable status timers if widget is not visible
* [PR 9033](https://github.com/spyder-ide/spyder/pull/9033) - PR: Fix error when PyLS completions response is None
* [PR 9031](https://github.com/spyder-ide/spyder/pull/9031) - PR: Automatically unbind conflicting shortcuts when pressing okay in shortcut manager ([8293](https://github.com/spyder-ide/spyder/issues/8293))
* [PR 9029](https://github.com/spyder-ide/spyder/pull/9029) - PR: Fix error at startup when updating warnings menu
* [PR 9024](https://github.com/spyder-ide/spyder/pull/9024) - PR: Add single click to open files on file and project explorer ([8930](https://github.com/spyder-ide/spyder/issues/8930))
* [PR 9011](https://github.com/spyder-ide/spyder/pull/9011) - PR: Reconnect warning menu with PyLS output ([8985](https://github.com/spyder-ide/spyder/issues/8985))
* [PR 9010](https://github.com/spyder-ide/spyder/pull/9010) - PR: Simplify status bar content and reorganize code ([9006](https://github.com/spyder-ide/spyder/issues/9006))
* [PR 8972](https://github.com/spyder-ide/spyder/pull/8972) - PR: Disable parameter inclusion in the PyLS ([8828](https://github.com/spyder-ide/spyder/issues/8828))
* [PR 8932](https://github.com/spyder-ide/spyder/pull/8932) - PR: Catch error in Outline explorer when renaming file ([8813](https://github.com/spyder-ide/spyder/issues/8813))
* [PR 8911](https://github.com/spyder-ide/spyder/pull/8911) - PR: Fix Windows tests with pip
* [PR 8877](https://github.com/spyder-ide/spyder/pull/8877) - PR: Adjust font sizes to look better for Linux and Windows
* [PR 8854](https://github.com/spyder-ide/spyder/pull/8854) - PR: Fix stuck arrow and conditional breakpoints in the debugger panel ([8846](https://github.com/spyder-ide/spyder/issues/8846))
* [PR 8842](https://github.com/spyder-ide/spyder/pull/8842) - PR: Change default root_path for PyLS and refactor LSP related code
* [PR 8839](https://github.com/spyder-ide/spyder/pull/8839) - PR: Improve logging of PyLS server and our client in debug mode
* [PR 8837](https://github.com/spyder-ide/spyder/pull/8837) - PR: Automatically use a separate but persistent configuration directory for non-stable releases ([7680](https://github.com/spyder-ide/spyder/issues/7680))
* [PR 8836](https://github.com/spyder-ide/spyder/pull/8836) - PR: Don't show a file in the Editor immediately after it's selected in the switcher.
* [PR 8821](https://github.com/spyder-ide/spyder/pull/8821) - PR: Handle async functions and methods properly in Outline Explorer ([8556](https://github.com/spyder-ide/spyder/issues/8556))
* [PR 8810](https://github.com/spyder-ide/spyder/pull/8810) - PR: Fix failing Sympy test
* [PR 8782](https://github.com/spyder-ide/spyder/pull/8782) - PR: Enclose logger.debug call in a try/except ([8749](https://github.com/spyder-ide/spyder/issues/8749))
* [PR 8769](https://github.com/spyder-ide/spyder/pull/8769) - PR: Add new font size for file switcher according to the OS
* [PR 8754](https://github.com/spyder-ide/spyder/pull/8754) - PR: Fix spelling errors in test_mainwindow.py comments
* [PR 8740](https://github.com/spyder-ide/spyder/pull/8740) - PR: Use a single infowidget in the IPython console ([7091](https://github.com/spyder-ide/spyder/issues/7091))
* [PR 8733](https://github.com/spyder-ide/spyder/pull/8733) - PR: Remove autosave file if user chooses not to save when asked ([8655](https://github.com/spyder-ide/spyder/issues/8655))
* [PR 8724](https://github.com/spyder-ide/spyder/pull/8724) - PR: Add position to text completion ([8727](https://github.com/spyder-ide/spyder/issues/8727), [8723](https://github.com/spyder-ide/spyder/issues/8723))
* [PR 8719](https://github.com/spyder-ide/spyder/pull/8719) - PR: Show a place holder text in the file switcher
* [PR 8717](https://github.com/spyder-ide/spyder/pull/8717) - PR: Change the max number of files in the file switcher to 15
* [PR 8716](https://github.com/spyder-ide/spyder/pull/8716) - PR: Put section header rows in the file switcher at item level
* [PR 8704](https://github.com/spyder-ide/spyder/pull/8704) - PR: Update README's sponsors section
* [PR 8700](https://github.com/spyder-ide/spyder/pull/8700) - PR: Automatic docstring generation for functions ([4936](https://github.com/spyder-ide/spyder/issues/4936))
* [PR 8691](https://github.com/spyder-ide/spyder/pull/8691) - PR: Improve appearance of breakpoint icon
* [PR 8678](https://github.com/spyder-ide/spyder/pull/8678) - PR:  Use file type icons in the File Switcher
* [PR 8665](https://github.com/spyder-ide/spyder/pull/8665) - PR: Move config pages of missing plugins to their own modules
* [PR 8664](https://github.com/spyder-ide/spyder/pull/8664) - PR: Move ConsoleBaseWidget to the console plugin from the editor
* [PR 8661](https://github.com/spyder-ide/spyder/pull/8661) - PR: Simplify the way to import Editor extensions and panels
* [PR 8659](https://github.com/spyder-ide/spyder/pull/8659) - PR: Close quotes inside brackets and before commas, colons and semi-colons ([6827](https://github.com/spyder-ide/spyder/issues/6827))
* [PR 8657](https://github.com/spyder-ide/spyder/pull/8657) - PR: Change font size for file name and path in the file switcher
* [PR 8653](https://github.com/spyder-ide/spyder/pull/8653) - PR: Move some preferences entries to their own modules
* [PR 8650](https://github.com/spyder-ide/spyder/pull/8650) - PR: Fall back to copy and delete if replace fails when restoring autosave ([8631](https://github.com/spyder-ide/spyder/issues/8631))
* [PR 8648](https://github.com/spyder-ide/spyder/pull/8648) - PR: Add validation for blank spaces while doing completion ([8628](https://github.com/spyder-ide/spyder/issues/8628))
* [PR 8647](https://github.com/spyder-ide/spyder/pull/8647) - PR: Provide graphical options to configure the PyLS ([8816](https://github.com/spyder-ide/spyder/issues/8816), [3064](https://github.com/spyder-ide/spyder/issues/3064))
* [PR 8644](https://github.com/spyder-ide/spyder/pull/8644) - PR: Add ability to paste auto-formatted file paths into the Editor from the system file manager
* [PR 8643](https://github.com/spyder-ide/spyder/pull/8643) - PR: Assign a keyboard shortcut for "next figure" and "previous figure" of the Plots pane ([8641](https://github.com/spyder-ide/spyder/issues/8641))
* [PR 8642](https://github.com/spyder-ide/spyder/pull/8642) - PR: Rewrite LSPManager to inherit from QObject instead of SpyderPluginWidget
* [PR 8637](https://github.com/spyder-ide/spyder/pull/8637) - PR: Make a closebrackets extension for smarter brackets ([3414](https://github.com/spyder-ide/spyder/issues/3414))
* [PR 8627](https://github.com/spyder-ide/spyder/pull/8627) - PR: Fix printing warning about rendering of plots below the new prompt ([8626](https://github.com/spyder-ide/spyder/issues/8626))
* [PR 8616](https://github.com/spyder-ide/spyder/pull/8616) - PR: Use single row for file name and path and use gray for paths in file switcher
* [PR 8606](https://github.com/spyder-ide/spyder/pull/8606) - PR: Add the ability to copy/paste files and their paths in the File/Project Explorers ([8321](https://github.com/spyder-ide/spyder/issues/8321), [2641](https://github.com/spyder-ide/spyder/issues/2641))
* [PR 8604](https://github.com/spyder-ide/spyder/pull/8604) - PR: Fix missing IPython prompt ([8603](https://github.com/spyder-ide/spyder/issues/8603))
* [PR 8600](https://github.com/spyder-ide/spyder/pull/8600) - PR: Fix LSP consumer reading block on Windows ([8565](https://github.com/spyder-ide/spyder/issues/8565), [8153](https://github.com/spyder-ide/spyder/issues/8153), [8022](https://github.com/spyder-ide/spyder/issues/8022))
* [PR 8599](https://github.com/spyder-ide/spyder/pull/8599) - PR: Add ability to delete long nested directories on Windows from File/Project Explorers ([8567](https://github.com/spyder-ide/spyder/issues/8567))
* [PR 8598](https://github.com/spyder-ide/spyder/pull/8598) - PR: Enclose contents of load_more_data method in try/except NameError Block ([7880](https://github.com/spyder-ide/spyder/issues/7880))
* [PR 8593](https://github.com/spyder-ide/spyder/pull/8593) - PR: Fix code completion in the Internal Console ([8579](https://github.com/spyder-ide/spyder/issues/8579))
* [PR 8590](https://github.com/spyder-ide/spyder/pull/8590) - PR: Adjust attribute icons size on Linux and Windows
* [PR 8584](https://github.com/spyder-ide/spyder/pull/8584) - PR: Enclose console warning about rendering of plots ([8520](https://github.com/spyder-ide/spyder/issues/8520))
* [PR 8578](https://github.com/spyder-ide/spyder/pull/8578) - PR: Restructure console menus ([8478](https://github.com/spyder-ide/spyder/issues/8478))
* [PR 8571](https://github.com/spyder-ide/spyder/pull/8571) - PR: Remove test np_threshold from test_mainwindow.py
* [PR 8569](https://github.com/spyder-ide/spyder/pull/8569) - PR: Prevent pasting non-text data from clipboard into the editor ([8566](https://github.com/spyder-ide/spyder/issues/8566))
* [PR 8559](https://github.com/spyder-ide/spyder/pull/8559) - PR: Avoid KeyError when closing Variable Explorer editors ([8557](https://github.com/spyder-ide/spyder/issues/8557))
* [PR 8558](https://github.com/spyder-ide/spyder/pull/8558) - PR: Add parent reference to QLineEdit of EditTabNamePopup
* [PR 8552](https://github.com/spyder-ide/spyder/pull/8552) - PR: Improve layout of Appearance entry in Preferences (2)
* [PR 8550](https://github.com/spyder-ide/spyder/pull/8550) - PR: Improve index column resize in dataframe editor ([7629](https://github.com/spyder-ide/spyder/issues/7629))
* [PR 8548](https://github.com/spyder-ide/spyder/pull/8548) - PR: Improve layout of Appearance entry in Preferences
* [PR 8546](https://github.com/spyder-ide/spyder/pull/8546) - PR : Fix full screen action in dual monitor enviroment for Windows ([8545](https://github.com/spyder-ide/spyder/issues/8545))
* [PR 8541](https://github.com/spyder-ide/spyder/pull/8541) - PR: Use dark logo for the light theme ([7845](https://github.com/spyder-ide/spyder/issues/7845))
* [PR 8529](https://github.com/spyder-ide/spyder/pull/8529) - PR: Pin pytest to a version less than 4.1
* [PR 8528](https://github.com/spyder-ide/spyder/pull/8528) - PR: Make the directory tree view proxy model case insensitive on Windows
* [PR 8525](https://github.com/spyder-ide/spyder/pull/8525) - PR: Add tests for the Plots plugin
* [PR 8524](https://github.com/spyder-ide/spyder/pull/8524) - PR: Fix bad context menu stylesheet and figure blinking in the Plots plugin ([8523](https://github.com/spyder-ide/spyder/issues/8523))
* [PR 8517](https://github.com/spyder-ide/spyder/pull/8517) - PR: Fix go to cursor position in Outline for newly created files ([8510](https://github.com/spyder-ide/spyder/issues/8510))
* [PR 8516](https://github.com/spyder-ide/spyder/pull/8516) - PR: Fix delete project by moving the code from the project explorer to the plugin ([8515](https://github.com/spyder-ide/spyder/issues/8515))
* [PR 8512](https://github.com/spyder-ide/spyder/pull/8512) - PR: Fix the "Copy Figure" shortcut of Plots pane with multiple consoles ([8511](https://github.com/spyder-ide/spyder/issues/8511))
* [PR 8508](https://github.com/spyder-ide/spyder/pull/8508) - PR: Fix handling background color of Webview when using QWebView ([8506](https://github.com/spyder-ide/spyder/issues/8506))
* [PR 8497](https://github.com/spyder-ide/spyder/pull/8497) - PR: Set dark background color for webview in the Help and IPython Console plugins ([8477](https://github.com/spyder-ide/spyder/issues/8477))
* [PR 8489](https://github.com/spyder-ide/spyder/pull/8489) - PR: Fix actions shown on the Editor Options menu for undocked and new windows ([8486](https://github.com/spyder-ide/spyder/issues/8486))
* [PR 8481](https://github.com/spyder-ide/spyder/pull/8481) - PR: Add cursor position bookmarks in Editor
* [PR 8471](https://github.com/spyder-ide/spyder/pull/8471) - PR: Show tests for plugins that use a mocked main window
* [PR 8470](https://github.com/spyder-ide/spyder/pull/8470) - PR: Add the ability to copy a figure from the plot widget ([8468](https://github.com/spyder-ide/spyder/issues/8468))
* [PR 8469](https://github.com/spyder-ide/spyder/pull/8469) - PR: Make indentation guides to go up to last line with text ([7339](https://github.com/spyder-ide/spyder/issues/7339))
* [PR 8460](https://github.com/spyder-ide/spyder/pull/8460) - PR: Handle non-existing saved editor layout when loading projects ([8458](https://github.com/spyder-ide/spyder/issues/8458))
* [PR 8456](https://github.com/spyder-ide/spyder/pull/8456) - PR: Setup proxy filter before setting the root index ([8455](https://github.com/spyder-ide/spyder/issues/8455))
* [PR 8452](https://github.com/spyder-ide/spyder/pull/8452) - PR: Fix Recent Project submenu actions in Projects menu. ([8450](https://github.com/spyder-ide/spyder/issues/8450))
* [PR 8446](https://github.com/spyder-ide/spyder/pull/8446) - PR: Add kwarg for FigureCanvas background color ([8443](https://github.com/spyder-ide/spyder/issues/8443))
* [PR 8441](https://github.com/spyder-ide/spyder/pull/8441) - PR: Fix translation error in the Brazilian Portuguese translation ([8309](https://github.com/spyder-ide/spyder/issues/8309))
* [PR 8440](https://github.com/spyder-ide/spyder/pull/8440) - PR: Change image logos for several programming language type files ([8388](https://github.com/spyder-ide/spyder/issues/8388))
* [PR 8434](https://github.com/spyder-ide/spyder/pull/8434) - PR: Fix completion insertion in the Editor ([8297](https://github.com/spyder-ide/spyder/issues/8297))
* [PR 8431](https://github.com/spyder-ide/spyder/pull/8431) - PR: Fix macOS tests by pinning to Qt 5.9.6 for now
* [PR 8429](https://github.com/spyder-ide/spyder/pull/8429) - PR: Set projet filenames correctly when closing a project ([8375](https://github.com/spyder-ide/spyder/issues/8375))
* [PR 8419](https://github.com/spyder-ide/spyder/pull/8419) - PR: Increase width of the ThumbnailScrollBar and add render message ([8320](https://github.com/spyder-ide/spyder/issues/8320))
* [PR 8416](https://github.com/spyder-ide/spyder/pull/8416) - PR: Fix error when Editor's dockwidget is not yet initialized
* [PR 8403](https://github.com/spyder-ide/spyder/pull/8403) - PR: Fix dark CSS for tables and add custom dark scrollbar for the Help plugin
* [PR 8402](https://github.com/spyder-ide/spyder/pull/8402) - PR: Run Windows tests on Azure
* [PR 8399](https://github.com/spyder-ide/spyder/pull/8399) - PR: Disable Qt windows style if using the dark UI theme
* [PR 8397](https://github.com/spyder-ide/spyder/pull/8397) - PR: Change handling of server host and port config placeholders ([7875](https://github.com/spyder-ide/spyder/issues/7875))
* [PR 8396](https://github.com/spyder-ide/spyder/pull/8396) - PR: Start testing with Azure pipelines
* [PR 8390](https://github.com/spyder-ide/spyder/pull/8390) - PR: Change method/function/class icons ([8386](https://github.com/spyder-ide/spyder/issues/8386))
* [PR 8387](https://github.com/spyder-ide/spyder/pull/8387) - PR: Modify test_introspection to test module completion
* [PR 8378](https://github.com/spyder-ide/spyder/pull/8378) - PR: Set right size of error dialog title field in macOS ([8344](https://github.com/spyder-ide/spyder/issues/8344))
* [PR 8364](https://github.com/spyder-ide/spyder/pull/8364) - PR: Add dark background to the light theme buttons on macOS ([5907](https://github.com/spyder-ide/spyder/issues/5907))
* [PR 8363](https://github.com/spyder-ide/spyder/pull/8363) - PR: Add close tab buttons to the light theme on macOS ([4580](https://github.com/spyder-ide/spyder/issues/4580))
* [PR 8360](https://github.com/spyder-ide/spyder/pull/8360) - PR: Change creationflags to prevent showing a cmd for pyls ([8066](https://github.com/spyder-ide/spyder/issues/8066))
* [PR 8357](https://github.com/spyder-ide/spyder/pull/8357) - PR: Improve Spyder Dark syntax highlighting theme ([8284](https://github.com/spyder-ide/spyder/issues/8284))
* [PR 8351](https://github.com/spyder-ide/spyder/pull/8351) - PR: Improve robustness when starting pyls ([8159](https://github.com/spyder-ide/spyder/issues/8159))
* [PR 8349](https://github.com/spyder-ide/spyder/pull/8349) - PR: Validation of dockwidget existence before raising it ([8283](https://github.com/spyder-ide/spyder/issues/8283))
* [PR 8348](https://github.com/spyder-ide/spyder/pull/8348) - PR: Stop using ci-helpers to simplify testing
* [PR 8347](https://github.com/spyder-ide/spyder/pull/8347) - PR: Do atomic writes when saving files ([8237](https://github.com/spyder-ide/spyder/issues/8237))
* [PR 8342](https://github.com/spyder-ide/spyder/pull/8342) - PR: Transform texteditor title to unicode ([7930](https://github.com/spyder-ide/spyder/issues/7930))
* [PR 8340](https://github.com/spyder-ide/spyder/pull/8340) - PR: Increase minimal QtAwesome version to 0.5.2 ([8330](https://github.com/spyder-ide/spyder/issues/8330))
* [PR 8337](https://github.com/spyder-ide/spyder/pull/8337) - PR: Specify close_fds=False on Windows ([8013](https://github.com/spyder-ide/spyder/issues/8013))
* [PR 8300](https://github.com/spyder-ide/spyder/pull/8300) - PR: Add qdarkstyle to dependencies dialog ([8291](https://github.com/spyder-ide/spyder/issues/8291))
* [PR 8299](https://github.com/spyder-ide/spyder/pull/8299) - PR: Improve contributing guide
* [PR 8276](https://github.com/spyder-ide/spyder/pull/8276) - PR: Add additional escape slashes instead of a raw string in runcell ([8267](https://github.com/spyder-ide/spyder/issues/8267))
* [PR 8272](https://github.com/spyder-ide/spyder/pull/8272) - PR: Greatly simplify and clarify Github pull request template ([8270](https://github.com/spyder-ide/spyder/issues/8270))
* [PR 8266](https://github.com/spyder-ide/spyder/pull/8266) - PR: Centralize theme-related preferences under an 'Appearance' entry ([8080](https://github.com/spyder-ide/spyder/issues/8080), [8071](https://github.com/spyder-ide/spyder/issues/8071))
* [PR 8265](https://github.com/spyder-ide/spyder/pull/8265) - PR: Close scrollflag tests after they run
* [PR 8257](https://github.com/spyder-ide/spyder/pull/8257) - PR: LSP fixes, debugging, and minor code cleanup ([8172](https://github.com/spyder-ide/spyder/issues/8172))
* [PR 8251](https://github.com/spyder-ide/spyder/pull/8251) - PR: Make the internal console use the same theme as the other widgets ([8072](https://github.com/spyder-ide/spyder/issues/8072))
* [PR 8245](https://github.com/spyder-ide/spyder/pull/8245) - PR: Fix quotes and traceback lines in runcell ([8244](https://github.com/spyder-ide/spyder/issues/8244), [8242](https://github.com/spyder-ide/spyder/issues/8242))
* [PR 8243](https://github.com/spyder-ide/spyder/pull/8243) - PR : Fix for escaped string in runcell ([8241](https://github.com/spyder-ide/spyder/issues/8241))
* [PR 8222](https://github.com/spyder-ide/spyder/pull/8222) - PR: Save last accepted kernel settings in config ([3689](https://github.com/spyder-ide/spyder/issues/3689))
* [PR 8212](https://github.com/spyder-ide/spyder/pull/8212) - PR: Add system-specific shortcut names on macOS to the Shortcuts summary dialog ([7146](https://github.com/spyder-ide/spyder/issues/7146))
* [PR 8202](https://github.com/spyder-ide/spyder/pull/8202) - PR: Mark some tests as slow and skip others that are failing locally
* [PR 8201](https://github.com/spyder-ide/spyder/pull/8201) - PR: Missing dark style for QMenus, Tour, Pylint, Profiler and DataFrameEditor
* [PR 8197](https://github.com/spyder-ide/spyder/pull/8197) - PR: Add parent reference to dialogs to ensure correct setup of the dark theme
* [PR 8192](https://github.com/spyder-ide/spyder/pull/8192) - PR: Remove dockwidget title bars by default and improve dock/undock behavior ([8171](https://github.com/spyder-ide/spyder/issues/8171), [8011](https://github.com/spyder-ide/spyder/issues/8011), [5515](https://github.com/spyder-ide/spyder/issues/5515), [2855](https://github.com/spyder-ide/spyder/issues/2855), [2854](https://github.com/spyder-ide/spyder/issues/2854))
* [PR 8158](https://github.com/spyder-ide/spyder/pull/8158) - PR: Fix font color in dark theme for several widgets
* [PR 8104](https://github.com/spyder-ide/spyder/pull/8104) - PR: Hide plugins that do not have a layout ([7111](https://github.com/spyder-ide/spyder/issues/7111))
* [PR 8086](https://github.com/spyder-ide/spyder/pull/8086) - PR: Add dark css for the Help and IPython Console plugins ([8087](https://github.com/spyder-ide/spyder/issues/8087))
* [PR 8081](https://github.com/spyder-ide/spyder/pull/8081) - PR: Make all editor's background color to be applied correctly ([8069](https://github.com/spyder-ide/spyder/issues/8069))
* [PR 8079](https://github.com/spyder-ide/spyder/pull/8079) - PR: Accept event if Shift+Tab is pressed in the CodeEditor keyPressEvent to avoid losing focus
* [PR 8062](https://github.com/spyder-ide/spyder/pull/8062) - PR: Fix setting elapsed time for all consoles ([7751](https://github.com/spyder-ide/spyder/issues/7751))
* [PR 8059](https://github.com/spyder-ide/spyder/pull/8059) - Variable Explorer: Use distinctive background for missings in DataFrames ([8037](https://github.com/spyder-ide/spyder/issues/8037))
* [PR 8058](https://github.com/spyder-ide/spyder/pull/8058) - PR: Change the TODO checkmark ([2264](https://github.com/spyder-ide/spyder/issues/2264))
* [PR 8044](https://github.com/spyder-ide/spyder/pull/8044) - PR: Fix error in LSP when closing file ([8043](https://github.com/spyder-ide/spyder/issues/8043))
* [PR 8020](https://github.com/spyder-ide/spyder/pull/8020) - PR: Initial support for Spyder's dark theme
* [PR 8015](https://github.com/spyder-ide/spyder/pull/8015) - PR: Add the option to sync file order between the Outline Explorer and the current EditorStack ([7993](https://github.com/spyder-ide/spyder/issues/7993))
* [PR 8004](https://github.com/spyder-ide/spyder/pull/8004) - PR: Remove old code completion architecture ([7996](https://github.com/spyder-ide/spyder/issues/7996), [7963](https://github.com/spyder-ide/spyder/issues/7963))
* [PR 7994](https://github.com/spyder-ide/spyder/pull/7994) - PR: Refactor LSP response callback communication ([7833](https://github.com/spyder-ide/spyder/issues/7833))
* [PR 7992](https://github.com/spyder-ide/spyder/pull/7992) - PR: Add LSP client tests
* [PR 7984](https://github.com/spyder-ide/spyder/pull/7984) - PR: Show the root file item of files that are not Python files in the Outline Explorer ([7982](https://github.com/spyder-ide/spyder/issues/7982))
* [PR 7975](https://github.com/spyder-ide/spyder/pull/7975) - PR: Fix Go to definition feature in the Editor in Windows after the changes introduced with the new LSP ([7726](https://github.com/spyder-ide/spyder/issues/7726))
* [PR 7968](https://github.com/spyder-ide/spyder/pull/7968) - PR: Sync Outline Explorer at startup and preserve the file order in the tabbar ([7338](https://github.com/spyder-ide/spyder/issues/7338))
* [PR 7962](https://github.com/spyder-ide/spyder/pull/7962) - PR: Improvement to navigation and file switching in the Outline Explorer ([7214](https://github.com/spyder-ide/spyder/issues/7214))
* [PR 7954](https://github.com/spyder-ide/spyder/pull/7954) - PR: Improve how keyboard shortcuts are handled in the Editor (Take 2) ([7883](https://github.com/spyder-ide/spyder/issues/7883))
* [PR 7929](https://github.com/spyder-ide/spyder/pull/7929) - PR: Improve the Shortcut Editor and fix and extend emacs shortcut support ([7883](https://github.com/spyder-ide/spyder/issues/7883), [7854](https://github.com/spyder-ide/spyder/issues/7854), [7109](https://github.com/spyder-ide/spyder/issues/7109))
* [PR 7927](https://github.com/spyder-ide/spyder/pull/7927) - PR: Convert and optimize tutorial PNGs and profiler/pylint icons
* [PR 7914](https://github.com/spyder-ide/spyder/pull/7914) - PR: Have a choice between password or keyfile in "Connect to remote kernel" dialog ([7905](https://github.com/spyder-ide/spyder/issues/7905))
* [PR 7876](https://github.com/spyder-ide/spyder/pull/7876) - PR: Reinitialize Pylab, Sympy and Cython after clearing all variables ([7224](https://github.com/spyder-ide/spyder/issues/7224))
* [PR 7874](https://github.com/spyder-ide/spyder/pull/7874) - PR: Correct next/previous word shortcut callback in Spyder 4 ([7872](https://github.com/spyder-ide/spyder/issues/7872))
* [PR 7866](https://github.com/spyder-ide/spyder/pull/7866) - PR: Add OneColumnTree context menu item to the plugins that use it in their Options menu ([7865](https://github.com/spyder-ide/spyder/issues/7865), [7865](https://github.com/spyder-ide/spyder/issues/7865), [7235](https://github.com/spyder-ide/spyder/issues/7235))
* [PR 7852](https://github.com/spyder-ide/spyder/pull/7852) - PR: Remove '--cov-report=term-missing' from pytest args
* [PR 7835](https://github.com/spyder-ide/spyder/pull/7835) - PR: Refactor test_autoindent.py to make the pytest logs cleaner
* [PR 7827](https://github.com/spyder-ide/spyder/pull/7827) - PR: Legal, standards conformance and consistency modifications to headers and EOF/EOL
* [PR 7826](https://github.com/spyder-ide/spyder/pull/7826) - PR: Conform short dates dates to be properly ISO 8601
* [PR 7822](https://github.com/spyder-ide/spyder/pull/7822) - PR: Add pyls as a new dependency
* [PR 7799](https://github.com/spyder-ide/spyder/pull/7799) - PR: Remove file from the outline explorer when it is closed ([7798](https://github.com/spyder-ide/spyder/issues/7798))
* [PR 7789](https://github.com/spyder-ide/spyder/pull/7789) - PR: Add "find_replace" widget to qtbot in fixtures of "test_editor.py"
* [PR 7768](https://github.com/spyder-ide/spyder/pull/7768) - PR: Improve how keyboard shortcuts are handled in the Editor ([7743](https://github.com/spyder-ide/spyder/issues/7743))
* [PR 7758](https://github.com/spyder-ide/spyder/pull/7758) - PR: Fix saving a new file or renaming an existing file in master ([7754](https://github.com/spyder-ide/spyder/issues/7754))
* [PR 7745](https://github.com/spyder-ide/spyder/pull/7745) - PR: Make the "Go to cursor position" button of the outline explorer work also when the cursor is in the last item of the Editor ([7744](https://github.com/spyder-ide/spyder/issues/7744))
* [PR 7738](https://github.com/spyder-ide/spyder/pull/7738) - PR: Make Group cells setting persistent when restarting spyder ([7736](https://github.com/spyder-ide/spyder/issues/7736))
* [PR 7734](https://github.com/spyder-ide/spyder/pull/7734) - PR: Replace debug_print for the logging module and deprecate its use ([5326](https://github.com/spyder-ide/spyder/issues/5326))
* [PR 7730](https://github.com/spyder-ide/spyder/pull/7730) - PR: Add a "get_cursor_line_number" method to OutlineExplorerProxyEditor ([7729](https://github.com/spyder-ide/spyder/issues/7729))
* [PR 7725](https://github.com/spyder-ide/spyder/pull/7725) - PR: Split all plugins into their own modules ([4591](https://github.com/spyder-ide/spyder/issues/4591))
* [PR 7714](https://github.com/spyder-ide/spyder/pull/7714) - PR: Fix variable explorer actions are disabled when undocked in a new window
* [PR 7710](https://github.com/spyder-ide/spyder/pull/7710) - PR: Fix cog menu not showing in the variable explorer when more than one IPython console is opened ([7704](https://github.com/spyder-ide/spyder/issues/7704))
* [PR 7698](https://github.com/spyder-ide/spyder/pull/7698) - PR: Show normalized paths in "Create Project" dialog ([7518](https://github.com/spyder-ide/spyder/issues/7518))
* [PR 7660](https://github.com/spyder-ide/spyder/pull/7660) - PR: Implement an autosave and recover system in the Editor ([2111](https://github.com/spyder-ide/spyder/issues/2111))
* [PR 7310](https://github.com/spyder-ide/spyder/pull/7310) - PR: Run cells through a function instead of pasting their contents to the console ([7760](https://github.com/spyder-ide/spyder/issues/7760), [7113](https://github.com/spyder-ide/spyder/issues/7113))
* [PR 6791](https://github.com/spyder-ide/spyder/pull/6791) - PR: Final update to split-plugins
* [PR 6679](https://github.com/spyder-ide/spyder/pull/6679) - PR: Update split-plugins branch with master (take 3)
* [PR 6430](https://github.com/spyder-ide/spyder/pull/6430) - PR: Add a Plots plugin to browse figures generated by the IPython console ([2550](https://github.com/spyder-ide/spyder/issues/2550))
* [PR 5764](https://github.com/spyder-ide/spyder/pull/5764) - PR: Handle namespace browser column width ([5543](https://github.com/spyder-ide/spyder/issues/5543))
* [PR 5676](https://github.com/spyder-ide/spyder/pull/5676) - PR: Change word highlighting to support dot notation ([1634](https://github.com/spyder-ide/spyder/issues/1634))
* [PR 5438](https://github.com/spyder-ide/spyder/pull/5438) - PR: Merge translations from former external plugins
* [PR 5283](https://github.com/spyder-ide/spyder/pull/5283) - PR: Add a debugger panel ([8560](https://github.com/spyder-ide/spyder/issues/8560))
* [PR 5276](https://github.com/spyder-ide/spyder/pull/5276) - PR: Move external plugins inside the main package again
* [PR 5263](https://github.com/spyder-ide/spyder/pull/5263) - PR: Revert change of name for Variable Explorer editors
* [PR 5219](https://github.com/spyder-ide/spyder/pull/5219) - PR: Split Working Directory module
* [PR 5216](https://github.com/spyder-ide/spyder/pull/5216) - PR: Move preferences out of the plugins module
* [PR 5214](https://github.com/spyder-ide/spyder/pull/5214) - PR: Split Projects module
* [PR 5207](https://github.com/spyder-ide/spyder/pull/5207) - PR: Split Internal Console module
* [PR 5206](https://github.com/spyder-ide/spyder/pull/5206) - PR: Split IPython Console module
* [PR 4975](https://github.com/spyder-ide/spyder/pull/4975) - PR: Split Editor module
* [PR 4974](https://github.com/spyder-ide/spyder/pull/4974) - PR: Split Explorer module
* [PR 4812](https://github.com/spyder-ide/spyder/pull/4812) - PR: Split Outline explorer module
* [PR 4772](https://github.com/spyder-ide/spyder/pull/4772) - PR: Merge master into split-plugins
* [PR 4751](https://github.com/spyder-ide/spyder/pull/4751) - PR: Migrate introspection services to use the Language Server Protocol (LSP) ([4742](https://github.com/spyder-ide/spyder/issues/4742))
* [PR 4593](https://github.com/spyder-ide/spyder/pull/4593) - PR: Split History module
* [PR 4569](https://github.com/spyder-ide/spyder/pull/4569) - PR: Split Find in Files module
* [PR 4565](https://github.com/spyder-ide/spyder/pull/4565) - PR: Split Online Help module
* [PR 4557](https://github.com/spyder-ide/spyder/pull/4557) - PR: Split Variable Explorer module
* [PR 4548](https://github.com/spyder-ide/spyder/pull/4548) - PR: Split Help plugin

In this release 246 pull requests were closed.


----


## Version 4.0beta1 (2018-08-12)

### Issues Closed

* [Issue 7078](https://github.com/spyder-ide/spyder/issues/7078) - Shortcuts to open pylab and sympy consoles  ([PR 7099](https://github.com/spyder-ide/spyder/pull/7099))
* [Issue 6516](https://github.com/spyder-ide/spyder/issues/6516) - AttributeError in jedi_plugin.py:102 ([PR 6523](https://github.com/spyder-ide/spyder/pull/6523))
* [Issue 6474](https://github.com/spyder-ide/spyder/issues/6474) - test_completions_custom_path fails with jedi 0.9.0 (Spyder 4) ([PR 6497](https://github.com/spyder-ide/spyder/pull/6497))
* [Issue 5821](https://github.com/spyder-ide/spyder/issues/5821) - Outline Explorer: disable `if/else/try/for` statements ([PR 5842](https://github.com/spyder-ide/spyder/pull/5842))
* [Issue 5763](https://github.com/spyder-ide/spyder/issues/5763) - Make arrow-key selection in multiple-option tab-completion dialogs "roll over" ([PR 5771](https://github.com/spyder-ide/spyder/pull/5771))
* [Issue 5756](https://github.com/spyder-ide/spyder/issues/5756) - Ctrl-PageUp/Down does not go through tabs in Spyder 4.x
* [Issue 5721](https://github.com/spyder-ide/spyder/issues/5721) - Update obsolete QMessageBox Standard Button values ([PR 5722](https://github.com/spyder-ide/spyder/pull/5722))
* [Issue 5711](https://github.com/spyder-ide/spyder/issues/5711) - "Show blank spaces" with split view editor
* [Issue 5678](https://github.com/spyder-ide/spyder/issues/5678) - Fix Indentation always uses 4 spaces instead of the selected number of spaces ([PR 6063](https://github.com/spyder-ide/spyder/pull/6063))
* [Issue 5667](https://github.com/spyder-ide/spyder/issues/5667) - Strange font rendering in the splash ([PR 5706](https://github.com/spyder-ide/spyder/pull/5706))
* [Issue 5652](https://github.com/spyder-ide/spyder/issues/5652) - Improved dependency dialog ([PR 5691](https://github.com/spyder-ide/spyder/pull/5691))
* [Issue 5639](https://github.com/spyder-ide/spyder/issues/5639) - Use argparse instead of optparse ([PR 5689](https://github.com/spyder-ide/spyder/pull/5689))
* [Issue 5594](https://github.com/spyder-ide/spyder/issues/5594) - Right-clicking in empty Project Explorer shows error ([PR 5603](https://github.com/spyder-ide/spyder/pull/5603))
* [Issue 5488](https://github.com/spyder-ide/spyder/issues/5488) - Code style (pep8) toggle in source menu ([PR 5497](https://github.com/spyder-ide/spyder/pull/5497))
* [Issue 5486](https://github.com/spyder-ide/spyder/issues/5486) - Spyder crash when dragging a plugin with the mouse ([PR 5487](https://github.com/spyder-ide/spyder/pull/5487))
* [Issue 5458](https://github.com/spyder-ide/spyder/issues/5458) - Can't indent code blocks more than once (using tab) on Spyder 4 ([PR 5468](https://github.com/spyder-ide/spyder/pull/5468))
* [Issue 5454](https://github.com/spyder-ide/spyder/issues/5454) - Toggle comment (ctrl+1) does not always preserve indentation with 2 spaces ([PR 5470](https://github.com/spyder-ide/spyder/pull/5470))
* [Issue 5365](https://github.com/spyder-ide/spyder/issues/5365) - Add "Save all files with <eol> EOL characters" option ([PR 5367](https://github.com/spyder-ide/spyder/pull/5367))
* [Issue 5256](https://github.com/spyder-ide/spyder/issues/5256) - Update spyder splash for spyder4 ([PR 5262](https://github.com/spyder-ide/spyder/pull/5262))
* [Issue 5176](https://github.com/spyder-ide/spyder/issues/5176) - Unify how extra selection are added to the editor
* [Issue 5171](https://github.com/spyder-ide/spyder/issues/5171) - Variable explorer showing different format when using MultiIndex ([PR 3873](https://github.com/spyder-ide/spyder/pull/3873))
* [Issue 5131](https://github.com/spyder-ide/spyder/issues/5131) - Sources checkable preferences aren't sync with preferences
* [Issue 5116](https://github.com/spyder-ide/spyder/issues/5116) - Internal console error when selecting Source -> Next warning/error (or Previous warning/error) ([PR 5117](https://github.com/spyder-ide/spyder/pull/5117))
* [Issue 5085](https://github.com/spyder-ide/spyder/issues/5085) - There are two scroll bars in the Editor ([PR 5215](https://github.com/spyder-ide/spyder/pull/5215))
* [Issue 4963](https://github.com/spyder-ide/spyder/issues/4963) - Open project error ([PR 4968](https://github.com/spyder-ide/spyder/pull/4968))
* [Issue 4948](https://github.com/spyder-ide/spyder/issues/4948) - Class function dropdown should be deactivated by default
* [Issue 4884](https://github.com/spyder-ide/spyder/issues/4884) - prefix 'b' of bytes is not highlighting in the editor window ([PR 5011](https://github.com/spyder-ide/spyder/pull/5011))
* [Issue 4854](https://github.com/spyder-ide/spyder/issues/4854) - Error when trying to show indentation guidelines ([PR 4889](https://github.com/spyder-ide/spyder/pull/4889))
* [Issue 4787](https://github.com/spyder-ide/spyder/issues/4787) - Show spaces bug at start ([PR 4788](https://github.com/spyder-ide/spyder/pull/4788))
* [Issue 4778](https://github.com/spyder-ide/spyder/issues/4778) - Code folding does not open the correct line from the backtrace of the ipython window
* [Issue 4777](https://github.com/spyder-ide/spyder/issues/4777) - Code folding does not support clicking left to the line numbers (editor)
* [Issue 4709](https://github.com/spyder-ide/spyder/issues/4709) - Find does not open code-folded blocks ([PR 4731](https://github.com/spyder-ide/spyder/pull/4731))
* [Issue 4708](https://github.com/spyder-ide/spyder/issues/4708) - Code folding is wrong on commented lines ([PR 4728](https://github.com/spyder-ide/spyder/pull/4728))
* [Issue 4705](https://github.com/spyder-ide/spyder/issues/4705) - Unable to vertically split window
* [Issue 4590](https://github.com/spyder-ide/spyder/issues/4590) - Improve floating panels in the editor  ([PR 5132](https://github.com/spyder-ide/spyder/pull/5132))
* [Issue 4543](https://github.com/spyder-ide/spyder/issues/4543) - Code completion widget misplaced in the Editor ([PR 4545](https://github.com/spyder-ide/spyder/pull/4545))
* [Issue 4463](https://github.com/spyder-ide/spyder/issues/4463) - Code folding does not work on indentation level 0
* [Issue 4423](https://github.com/spyder-ide/spyder/issues/4423) - Missing manpage for spyder ([PR 4506](https://github.com/spyder-ide/spyder/pull/4506))
* [Issue 4376](https://github.com/spyder-ide/spyder/issues/4376) - Tab switcher dialog is not populated completely ([PR 4392](https://github.com/spyder-ide/spyder/pull/4392))
* [Issue 4153](https://github.com/spyder-ide/spyder/issues/4153) - vertical end-of-line in wrong place
* [Issue 4147](https://github.com/spyder-ide/spyder/issues/4147) - Improve visual style of code folding
* [Issue 4124](https://github.com/spyder-ide/spyder/issues/4124) - language reset to japanese on reboot ([PR 4159](https://github.com/spyder-ide/spyder/pull/4159))
* [Issue 4081](https://github.com/spyder-ide/spyder/issues/4081) - Add keyboard shortcuts for Source > Next|Previous Warning/Error ([PR 5126](https://github.com/spyder-ide/spyder/pull/5126))
* [Issue 4018](https://github.com/spyder-ide/spyder/issues/4018) - Add multiindex header support for the Variable Explorer ([PR 3873](https://github.com/spyder-ide/spyder/pull/3873))
* [Issue 3942](https://github.com/spyder-ide/spyder/issues/3942) - Error when deleting the file with last focus in a project ([PR 3953](https://github.com/spyder-ide/spyder/pull/3953))
* [Issue 3923](https://github.com/spyder-ide/spyder/issues/3923) - Profiler error when no filename is passed to it ([PR 3909](https://github.com/spyder-ide/spyder/pull/3909))
* [Issue 3887](https://github.com/spyder-ide/spyder/issues/3887) - Menus "File",  "Edit" and "Search" in master not available for mouse click ([PR 3892](https://github.com/spyder-ide/spyder/pull/3892))
* [Issue 3857](https://github.com/spyder-ide/spyder/issues/3857) - Go to line doesn't correspond to the correct file ([PR 5321](https://github.com/spyder-ide/spyder/pull/5321))
* [Issue 3790](https://github.com/spyder-ide/spyder/issues/3790) - Create new windows when undocking all plugins ([PR 3824](https://github.com/spyder-ide/spyder/pull/3824))
* [Issue 3758](https://github.com/spyder-ide/spyder/issues/3758) - Variable explorer should show variables of type pandas.indexes.base.Index ([PR 5149](https://github.com/spyder-ide/spyder/pull/5149))
* [Issue 3721](https://github.com/spyder-ide/spyder/issues/3721) - DataFrame viewer should display tooltips for truncated column headers ([PR 3873](https://github.com/spyder-ide/spyder/pull/3873))
* [Issue 3645](https://github.com/spyder-ide/spyder/issues/3645) - Autocompletion on Python consoles is crashing in master ([PR 3650](https://github.com/spyder-ide/spyder/pull/3650))
* [Issue 3592](https://github.com/spyder-ide/spyder/issues/3592) - Add multiple edgelines options in settings window ([PR 3607](https://github.com/spyder-ide/spyder/pull/3607))
* [Issue 3591](https://github.com/spyder-ide/spyder/issues/3591) - DataFrame viewer should use custom index name
* [Issue 3585](https://github.com/spyder-ide/spyder/issues/3585) - Editor grabs focus when opening files at startup ([PR 3858](https://github.com/spyder-ide/spyder/pull/3858))
* [Issue 3571](https://github.com/spyder-ide/spyder/issues/3571) - Help fails to produce Rich Text on annotated functions ([PR 3577](https://github.com/spyder-ide/spyder/pull/3577))
* [Issue 3563](https://github.com/spyder-ide/spyder/issues/3563) - Docks confusion when pressing undocking button ([PR 3824](https://github.com/spyder-ide/spyder/pull/3824))
* [Issue 3448](https://github.com/spyder-ide/spyder/issues/3448) - Break plugin creation into a spyder/api module for better decoupling and organization ([PR 3468](https://github.com/spyder-ide/spyder/pull/3468))
* [Issue 3345](https://github.com/spyder-ide/spyder/issues/3345) - Feature suggestion:  scroll over the end of file in the editor ([PR 5122](https://github.com/spyder-ide/spyder/pull/5122))
* [Issue 2987](https://github.com/spyder-ide/spyder/issues/2987) - Add feature that shows vertical lines to help identifying indentation structure
* [Issue 2845](https://github.com/spyder-ide/spyder/issues/2845) - Comment out lines according to indentation ([PR 3958](https://github.com/spyder-ide/spyder/pull/3958))
* [Issue 2627](https://github.com/spyder-ide/spyder/issues/2627) - Add optional display of current class/function that you're in. ([PR 4225](https://github.com/spyder-ide/spyder/pull/4225))
* [Issue 2553](https://github.com/spyder-ide/spyder/issues/2553) - Share code with gtabview
* [Issue 2419](https://github.com/spyder-ide/spyder/issues/2419) - Shortcuts for splitting and closing panels ([PR 5512](https://github.com/spyder-ide/spyder/pull/5512))
* [Issue 2406](https://github.com/spyder-ide/spyder/issues/2406) - File explorer enhancements ([PR 4939](https://github.com/spyder-ide/spyder/pull/4939))
* [Issue 2355](https://github.com/spyder-ide/spyder/issues/2355) - Variable Explorer does not show sets ([PR 5230](https://github.com/spyder-ide/spyder/pull/5230))
* [Issue 1785](https://github.com/spyder-ide/spyder/issues/1785) - Spyder comments (Ctrl+1 and Ctrl+4) generate pep8 warnings ([PR 3958](https://github.com/spyder-ide/spyder/pull/3958))
* [Issue 1778](https://github.com/spyder-ide/spyder/issues/1778) - Add a 72-char vertical line for docstrings ([PR 3512](https://github.com/spyder-ide/spyder/pull/3512))
* [Issue 1754](https://github.com/spyder-ide/spyder/issues/1754) - No undo for Source->Fix identation
* [Issue 1584](https://github.com/spyder-ide/spyder/issues/1584) - Newline added to default file ([PR 5797](https://github.com/spyder-ide/spyder/pull/5797))
* [Issue 1396](https://github.com/spyder-ide/spyder/issues/1396) - Autocomplete doesnt work in undocked Editor window
* [Issue 970](https://github.com/spyder-ide/spyder/issues/970) - History plugin: add an option to show/hide line numbers ([PR 5363](https://github.com/spyder-ide/spyder/pull/5363))
* [Issue 877](https://github.com/spyder-ide/spyder/issues/877) - Quote by select + ' or "
* [Issue 706](https://github.com/spyder-ide/spyder/issues/706) - Code folding missing in the Editor ([PR 3833](https://github.com/spyder-ide/spyder/pull/3833))

In this release 74 issues were closed.

### Pull Requests Merged

* [PR 7597](https://github.com/spyder-ide/spyder/pull/7597) - PR: Separate startup run_lines with semicolon instead of comma
* [PR 7410](https://github.com/spyder-ide/spyder/pull/7410) - PR: Remove manpage
* [PR 7262](https://github.com/spyder-ide/spyder/pull/7262) - PR: Update donation/funding status message in Readme
* [PR 7167](https://github.com/spyder-ide/spyder/pull/7167) - PR: Remove missing PyQt4 references in our tests
* [PR 7107](https://github.com/spyder-ide/spyder/pull/7107) - PR: Show group cells in Outline Explorer ([7086](https://github.com/spyder-ide/spyder/issues/7086))
* [PR 7099](https://github.com/spyder-ide/spyder/pull/7099) - PR: Add new menu entries to open Pylab, Sympy and Cython consoles ([7078](https://github.com/spyder-ide/spyder/issues/7078))
* [PR 6923](https://github.com/spyder-ide/spyder/pull/6923) - PR: Improve and update wording of funding announcement, and put screenshot above it
* [PR 6523](https://github.com/spyder-ide/spyder/pull/6523) - PR: Fix AttributeError in jedi_plugin ([6516](https://github.com/spyder-ide/spyder/issues/6516))
* [PR 6497](https://github.com/spyder-ide/spyder/pull/6497) - PR: Bump required version for Jedi to 0.11.0  ([6474](https://github.com/spyder-ide/spyder/issues/6474))
* [PR 6440](https://github.com/spyder-ide/spyder/pull/6440) - PR: Skip test_window_title in PyQt4 and PY3 because it's failing
* [PR 6340](https://github.com/spyder-ide/spyder/pull/6340) - PR: Fix EditorStack and EditorSplitter not closing correctly.
* [PR 6296](https://github.com/spyder-ide/spyder/pull/6296) - PR: Fix tests on Travis
* [PR 6151](https://github.com/spyder-ide/spyder/pull/6151) - PR: Hide unneeded Options buttons
* [PR 6133](https://github.com/spyder-ide/spyder/pull/6133) - PR: Fix test_dataframemodel_set_data_overflow
* [PR 6079](https://github.com/spyder-ide/spyder/pull/6079) - PR: Fix flaky test_find_in_files_search
* [PR 6063](https://github.com/spyder-ide/spyder/pull/6063) - PR: Change fix_indentation to use preference for number of spaces ([5678](https://github.com/spyder-ide/spyder/issues/5678))
* [PR 5842](https://github.com/spyder-ide/spyder/pull/5842) - PR: Remove `if/else/try/for` statements from the outline explorer tree ([5821](https://github.com/spyder-ide/spyder/issues/5821))
* [PR 5836](https://github.com/spyder-ide/spyder/pull/5836) - PR: Give a more modern appearence to the tour
* [PR 5797](https://github.com/spyder-ide/spyder/pull/5797) - PR: Don't add extra newline when using new file template ([1584](https://github.com/spyder-ide/spyder/issues/1584))
* [PR 5771](https://github.com/spyder-ide/spyder/pull/5771) - PR: Make arrow-key selection in completion widget "roll over" ([5763](https://github.com/spyder-ide/spyder/issues/5763))
* [PR 5768](https://github.com/spyder-ide/spyder/pull/5768) - PR: Fix broken shortcuts for changing editor tabs (Ctrl+PageUp, Ctrl+PageDown)
* [PR 5722](https://github.com/spyder-ide/spyder/pull/5722) - PR: Update obsolete enums in QMessageBox ([5721](https://github.com/spyder-ide/spyder/issues/5721))
* [PR 5706](https://github.com/spyder-ide/spyder/pull/5706) - PR: Splash SVG font change and convert font to path ([5667](https://github.com/spyder-ide/spyder/issues/5667))
* [PR 5691](https://github.com/spyder-ide/spyder/pull/5691) - PR: Improve dependencies dialog ([5652](https://github.com/spyder-ide/spyder/issues/5652))
* [PR 5689](https://github.com/spyder-ide/spyder/pull/5689) - PR: Convert command line options from optparse to argparse ([5639](https://github.com/spyder-ide/spyder/issues/5639))
* [PR 5657](https://github.com/spyder-ide/spyder/pull/5657) - PR: Allow undo/redo on Source > Fix indentation
* [PR 5603](https://github.com/spyder-ide/spyder/pull/5603) - PR: Fix crash on empty project explorer context menu ([5594](https://github.com/spyder-ide/spyder/issues/5594))
* [PR 5512](https://github.com/spyder-ide/spyder/pull/5512) - PR: Add shortcuts for splitting and closing panels ([2419](https://github.com/spyder-ide/spyder/issues/2419))
* [PR 5497](https://github.com/spyder-ide/spyder/pull/5497) - PR: Add option to toggle code style checks from Source menu ([5488](https://github.com/spyder-ide/spyder/issues/5488))
* [PR 5487](https://github.com/spyder-ide/spyder/pull/5487) - PR: Handle 'unlocked panes' state for undocking without generating a new window ([5486](https://github.com/spyder-ide/spyder/issues/5486))
* [PR 5471](https://github.com/spyder-ide/spyder/pull/5471) - PR: Fix test_sort_dataframe_with_category_dtypes
* [PR 5470](https://github.com/spyder-ide/spyder/pull/5470) - PR: Use indentation preferences to comment/uncomment. ([5454](https://github.com/spyder-ide/spyder/issues/5454))
* [PR 5468](https://github.com/spyder-ide/spyder/pull/5468) - PR: Fix indentation with selection ([5458](https://github.com/spyder-ide/spyder/issues/5458))
* [PR 5367](https://github.com/spyder-ide/spyder/pull/5367) - PR: Add an option to the Editor to convert EOL characters on save ([5365](https://github.com/spyder-ide/spyder/issues/5365))
* [PR 5363](https://github.com/spyder-ide/spyder/pull/5363) - PR: Add an option to show/hide line numbers to History ([970](https://github.com/spyder-ide/spyder/issues/970))
* [PR 5321](https://github.com/spyder-ide/spyder/pull/5321) - PR: Rearrange line count when opening files to correspond to the correct one ([3857](https://github.com/spyder-ide/spyder/issues/3857))
* [PR 5309](https://github.com/spyder-ide/spyder/pull/5309) - PR: Update font decorations when adding them to the editor.
* [PR 5274](https://github.com/spyder-ide/spyder/pull/5274) - PR: Remove duplicated logic in Editor checkable Actions
* [PR 5262](https://github.com/spyder-ide/spyder/pull/5262) - PR: Update version in splash screen ([5256](https://github.com/spyder-ide/spyder/issues/5256))
* [PR 5230](https://github.com/spyder-ide/spyder/pull/5230) - PR: Support for sets in the Variable Explorer ([2355](https://github.com/spyder-ide/spyder/issues/2355))
* [PR 5215](https://github.com/spyder-ide/spyder/pull/5215) - PR: Scroll flag area improvements ([5085](https://github.com/spyder-ide/spyder/issues/5085))
* [PR 5203](https://github.com/spyder-ide/spyder/pull/5203) - PR: Unify how extra selections are added to the Editor
* [PR 5159](https://github.com/spyder-ide/spyder/pull/5159) - PR: Make Ctrl+C to quit Spyder on Posix systems ([5305](https://github.com/spyder-ide/spyder/issues/5305))
* [PR 5149](https://github.com/spyder-ide/spyder/pull/5149) - PR: Support for all Pandas indexes in Variable Explorer ([3758](https://github.com/spyder-ide/spyder/issues/3758))
* [PR 5139](https://github.com/spyder-ide/spyder/pull/5139) - PR: Fix error Editor loosing focus
* [PR 5132](https://github.com/spyder-ide/spyder/pull/5132) - PR: Improve how floating panels are painted ([4590](https://github.com/spyder-ide/spyder/issues/4590))
* [PR 5130](https://github.com/spyder-ide/spyder/pull/5130) - PR: Deactivate class/function dropdown by default
* [PR 5126](https://github.com/spyder-ide/spyder/pull/5126) - PR: Add keyboard shortcuts for Next|Previous Warning/Error ([4081](https://github.com/spyder-ide/spyder/issues/4081))
* [PR 5122](https://github.com/spyder-ide/spyder/pull/5122) - PR: Enable scrolling past the end of the document ([3345](https://github.com/spyder-ide/spyder/issues/3345))
* [PR 5117](https://github.com/spyder-ide/spyder/pull/5117) - PR: Fix traceback error when selecting Next/Previous warning/error ([5116](https://github.com/spyder-ide/spyder/issues/5116))
* [PR 5083](https://github.com/spyder-ide/spyder/pull/5083) - PR: Fix unable to split editor
* [PR 5011](https://github.com/spyder-ide/spyder/pull/5011) - PR: Add all possible string prefixes for syntax highlighting ([4884](https://github.com/spyder-ide/spyder/issues/4884))
* [PR 5002](https://github.com/spyder-ide/spyder/pull/5002) - PR: Add Editor extensions
* [PR 4968](https://github.com/spyder-ide/spyder/pull/4968) - PR: Fix error when threre are no layout settings ([4963](https://github.com/spyder-ide/spyder/issues/4963))
* [PR 4939](https://github.com/spyder-ide/spyder/pull/4939) - PR: Some File Explorer Enhancements ([2406](https://github.com/spyder-ide/spyder/issues/2406))
* [PR 4889](https://github.com/spyder-ide/spyder/pull/4889) - PR: Fix error at startup when trying to set indent_guides. ([4854](https://github.com/spyder-ide/spyder/issues/4854))
* [PR 4804](https://github.com/spyder-ide/spyder/pull/4804) - PR: Fix some code folding related errors
* [PR 4788](https://github.com/spyder-ide/spyder/pull/4788) - PR: Add validation for editorstacks in showing spaces function ([4787](https://github.com/spyder-ide/spyder/issues/4787))
* [PR 4762](https://github.com/spyder-ide/spyder/pull/4762) - PR: Add missing QMessageBox import
* [PR 4731](https://github.com/spyder-ide/spyder/pull/4731) - PR: Make searching text to expand folded blocks ([4709](https://github.com/spyder-ide/spyder/issues/4709))
* [PR 4728](https://github.com/spyder-ide/spyder/pull/4728) - PR: Make folding to ignore indented comments ([4708](https://github.com/spyder-ide/spyder/issues/4708))
* [PR 4627](https://github.com/spyder-ide/spyder/pull/4627) - PR: Add pyopengl to Linux wheels only
* [PR 4618](https://github.com/spyder-ide/spyder/pull/4618) - PR: Add German translation
* [PR 4572](https://github.com/spyder-ide/spyder/pull/4572) - PR: Add indentation guidelines
* [PR 4545](https://github.com/spyder-ide/spyder/pull/4545) - PR: Take panels widths into account when calculating positions in the Editor  ([4543](https://github.com/spyder-ide/spyder/issues/4543))
* [PR 4540](https://github.com/spyder-ide/spyder/pull/4540) - PR: Fix update title signal
* [PR 4538](https://github.com/spyder-ide/spyder/pull/4538) - PR: Add Shift+Del shortcut to delete lines in the Editor  ([4496](https://github.com/spyder-ide/spyder/issues/4496), [3405](https://github.com/spyder-ide/spyder/issues/3405))
* [PR 4506](https://github.com/spyder-ide/spyder/pull/4506) - PR: Add manpage for Spyder ([4423](https://github.com/spyder-ide/spyder/issues/4423))
* [PR 4505](https://github.com/spyder-ide/spyder/pull/4505) - PR: Fix links to Fedora and openSUSE in docs
* [PR 4503](https://github.com/spyder-ide/spyder/pull/4503) - PR: Fold improvements
* [PR 4470](https://github.com/spyder-ide/spyder/pull/4470) - PR: Fix error in Find in Files because of changes in master
* [PR 4392](https://github.com/spyder-ide/spyder/pull/4392) - PR: Update StackHistory when focus isn't given to the Editor ([4376](https://github.com/spyder-ide/spyder/issues/4376))
* [PR 4286](https://github.com/spyder-ide/spyder/pull/4286) - PR: Only show removal message in Python consoles ([4284](https://github.com/spyder-ide/spyder/issues/4284))
* [PR 4265](https://github.com/spyder-ide/spyder/pull/4265) - PR: Improvements to visual style of code-folding
* [PR 4234](https://github.com/spyder-ide/spyder/pull/4234) - PR: Fix test that looks for print statements
* [PR 4225](https://github.com/spyder-ide/spyder/pull/4225) - PR: Add a new panel to show/explore class and methods/functions present in the current file ([2627](https://github.com/spyder-ide/spyder/issues/2627))
* [PR 4210](https://github.com/spyder-ide/spyder/pull/4210) - PR: Fix syntax highlighter missing Cython keywords
* [PR 4198](https://github.com/spyder-ide/spyder/pull/4198) - PR : Add Cython files import and run support
* [PR 4164](https://github.com/spyder-ide/spyder/pull/4164) - PR: Fix error edgeline offset, take code folding panel width in account. ([4163](https://github.com/spyder-ide/spyder/issues/4163))
* [PR 4162](https://github.com/spyder-ide/spyder/pull/4162) - PR: Fix wrong usage of is_text_string
* [PR 4159](https://github.com/spyder-ide/spyder/pull/4159) - PR: Try to eval string setting values after decoding in python2.7 ([4124](https://github.com/spyder-ide/spyder/issues/4124))
* [PR 4155](https://github.com/spyder-ide/spyder/pull/4155) - PR: Fix error edge line in python2.7
* [PR 3958](https://github.com/spyder-ide/spyder/pull/3958) - PR: Comment lines taking into account code indentation and pep8 ([2845](https://github.com/spyder-ide/spyder/issues/2845), [1785](https://github.com/spyder-ide/spyder/issues/1785))
* [PR 3953](https://github.com/spyder-ide/spyder/pull/3953) - PR: Prevent error when file with last focus is deleted from project ([3942](https://github.com/spyder-ide/spyder/issues/3942))
* [PR 3937](https://github.com/spyder-ide/spyder/pull/3937) - PR: Change ScrollFlagArea panel to use panel API
* [PR 3909](https://github.com/spyder-ide/spyder/pull/3909) - PR: Fix "TypeError: got multiple values for argument" in Profiler ([3923](https://github.com/spyder-ide/spyder/issues/3923))
* [PR 3892](https://github.com/spyder-ide/spyder/pull/3892) - PR: Raise the menu bar to the top of the main window widget's stack. ([3887](https://github.com/spyder-ide/spyder/issues/3887))
* [PR 3873](https://github.com/spyder-ide/spyder/pull/3873) - PR: Add multi-index display support to the Dataframe editor ([5171](https://github.com/spyder-ide/spyder/issues/5171), [4018](https://github.com/spyder-ide/spyder/issues/4018), [3721](https://github.com/spyder-ide/spyder/issues/3721))
* [PR 3858](https://github.com/spyder-ide/spyder/pull/3858) - PR: Load files in the background and set focus to the last one with focus in the previous session ([3585](https://github.com/spyder-ide/spyder/issues/3585))
* [PR 3833](https://github.com/spyder-ide/spyder/pull/3833) - PR: Add code folding to the Editor ([706](https://github.com/spyder-ide/spyder/issues/706))
* [PR 3824](https://github.com/spyder-ide/spyder/pull/3824) - PR: Create a separate window when undocking plugins ([3790](https://github.com/spyder-ide/spyder/issues/3790), [3563](https://github.com/spyder-ide/spyder/issues/3563))
* [PR 3803](https://github.com/spyder-ide/spyder/pull/3803) - PR: Add CircleCI to run pytest, ciocheck and coveralls
* [PR 3778](https://github.com/spyder-ide/spyder/pull/3778) - PR: Add Panels and PanelsManager, and use it to add LineNumberArea to editor
* [PR 3727](https://github.com/spyder-ide/spyder/pull/3727) - PR: Remove SpyderPluginMixin and improve external API
* [PR 3676](https://github.com/spyder-ide/spyder/pull/3676) - PR: Refactor and simplify NamespaceBrowser widget
* [PR 3650](https://github.com/spyder-ide/spyder/pull/3650) - PR: Revert error introduced by linenumber migration ([3645](https://github.com/spyder-ide/spyder/issues/3645))
* [PR 3607](https://github.com/spyder-ide/spyder/pull/3607) - PR: Multiple edge lines preferences ([3592](https://github.com/spyder-ide/spyder/issues/3592), [1778](https://github.com/spyder-ide/spyder/issues/1778))
* [PR 3577](https://github.com/spyder-ide/spyder/pull/3577) - PR: Use inspect.getfullargspec() in getdoc for PY3 to support annotated functions. ([3571](https://github.com/spyder-ide/spyder/issues/3571))
* [PR 3574](https://github.com/spyder-ide/spyder/pull/3574) - PR: Improve style of scientific startup script
* [PR 3534](https://github.com/spyder-ide/spyder/pull/3534) - PR: Added the Solarized color scheme
* [PR 3512](https://github.com/spyder-ide/spyder/pull/3512) - PR: Move edge line code out of editor to EdgeLine class ([1778](https://github.com/spyder-ide/spyder/issues/1778))
* [PR 3468](https://github.com/spyder-ide/spyder/pull/3468) - PR: Move plugin creation to spyder/api/plugins.py for decoupling  ([3448](https://github.com/spyder-ide/spyder/issues/3448))
* [PR 3463](https://github.com/spyder-ide/spyder/pull/3463) - PR: Migrate line number area to a panel widget
* [PR 2431](https://github.com/spyder-ide/spyder/pull/2431) - PR: Use right python.exe to run Spyder when multiple versions of Python are installled on Windows

In this release 104 pull requests were closed.


----


## Version 3.3.6 (2019-07-14)

### Issues Closed

* [Issue 9757](https://github.com/spyder-ide/spyder/issues/9757) - Text in help search bar becomes selected once help is displayed ([PR 9760](https://github.com/spyder-ide/spyder/pull/9760))
* [Issue 8336](https://github.com/spyder-ide/spyder/issues/8336) - AttributeError in profiler ([PR 9758](https://github.com/spyder-ide/spyder/pull/9758))

In this release 2 issues were closed.

### Pull Requests Merged

* [PR 9760](https://github.com/spyder-ide/spyder/pull/9760) - PR: Backport PR #9552 ([9757](https://github.com/spyder-ide/spyder/issues/9757))
* [PR 9758](https://github.com/spyder-ide/spyder/pull/9758) - PR: Avoid an error when profdata is None in Profiler ([8336](https://github.com/spyder-ide/spyder/issues/8336))
* [PR 9718](https://github.com/spyder-ide/spyder/pull/9718) - PR: Fix completion plugins listening to external hosts

In this release 3 pull requests were closed.


----


## Version 3.3.5 (2019-06-27)

### New features

* Add option to allow users showing/hiding CMD windows created by the
  `subprocess` module on Windows. The option can be found in
  `Preferences > IPython Console > Advanced settings > Windows adjustments`.

### Issues Closed

* [Issue 9520](https://github.com/spyder-ide/spyder/issues/9520) - Can't run profiler ([PR 9652](https://github.com/spyder-ide/spyder/pull/9652))
* [Issue 9304](https://github.com/spyder-ide/spyder/issues/9304) - PermissionError when trying to load a kernel connection file ([PR 9651](https://github.com/spyder-ide/spyder/pull/9651))
* [Issue 9262](https://github.com/spyder-ide/spyder/issues/9262) - Only require PyWebEngine on Python 3+ to avoid blocking py2 compat in pip wheels ([PR 9436](https://github.com/spyder-ide/spyder/pull/9436))
* [Issue 9240](https://github.com/spyder-ide/spyder/issues/9240) - The external system terminal close after running script if the Python console exits due to an exception ([PR 9312](https://github.com/spyder-ide/spyder/pull/9312))
* [Issue 9221](https://github.com/spyder-ide/spyder/issues/9221) - TypeError: cursor_position_changed ([PR 9650](https://github.com/spyder-ide/spyder/pull/9650))
* [Issue 9217](https://github.com/spyder-ide/spyder/issues/9217) - ValueError when clicking on a traceback link in the IPython console ([PR 9649](https://github.com/spyder-ide/spyder/pull/9649))
* [Issue 9143](https://github.com/spyder-ide/spyder/issues/9143) - Help pane doesn't accept aliased modules ([PR 9166](https://github.com/spyder-ide/spyder/pull/9166))
* [Issue 9113](https://github.com/spyder-ide/spyder/issues/9113) - Opening window in a subprocess from Spyder ([PR 9123](https://github.com/spyder-ide/spyder/pull/9123))
* [Issue 9093](https://github.com/spyder-ide/spyder/issues/9093) - Error when trying to create spyder.lock on an unwritable config directory ([PR 9098](https://github.com/spyder-ide/spyder/pull/9098))
* [Issue 9051](https://github.com/spyder-ide/spyder/issues/9051) - Variable explorer viewers go to the background on macOS ([PR 9119](https://github.com/spyder-ide/spyder/pull/9119))

In this release 10 issues were closed.

### Pull Requests Merged

* [PR 9658](https://github.com/spyder-ide/spyder/pull/9658) - PR: Require spyder-kernels 0.5.0 in setup.py
* [PR 9652](https://github.com/spyder-ide/spyder/pull/9652) - PR: Remove usage of QTextCodec because it's not really needed ([9520](https://github.com/spyder-ide/spyder/issues/9520))
* [PR 9651](https://github.com/spyder-ide/spyder/pull/9651) - PR: Catch error when loading kernel connection file ([9304](https://github.com/spyder-ide/spyder/issues/9304))
* [PR 9650](https://github.com/spyder-ide/spyder/pull/9650) - PR: Catch an error when disconnecting a signal in calltip widget ([9221](https://github.com/spyder-ide/spyder/issues/9221))
* [PR 9649](https://github.com/spyder-ide/spyder/pull/9649) - PR: Catch error when pressing the link of a traceback in IPython console ([9217](https://github.com/spyder-ide/spyder/issues/9217))
* [PR 9436](https://github.com/spyder-ide/spyder/pull/9436) - PR: Require pyqtwebengine only in Python 3 ([9262](https://github.com/spyder-ide/spyder/issues/9262))
* [PR 9312](https://github.com/spyder-ide/spyder/pull/9312) - PR: Improvements to the cmd used to start external terminals on Windows ([9240](https://github.com/spyder-ide/spyder/issues/9240))
* [PR 9166](https://github.com/spyder-ide/spyder/pull/9166) - PR: Fix Help plugin string validation for the console ([9143](https://github.com/spyder-ide/spyder/issues/9143))
* [PR 9123](https://github.com/spyder-ide/spyder/pull/9123) - PR: Add preference to show/hide cmd windows generated by the subprocess module ([9113](https://github.com/spyder-ide/spyder/issues/9113))
* [PR 9119](https://github.com/spyder-ide/spyder/pull/9119) - PR: Make Variable Explorer viewers stay on top in macOS ([9051](https://github.com/spyder-ide/spyder/issues/9051))
* [PR 9099](https://github.com/spyder-ide/spyder/pull/9099) - PR: Add sponsors sections and remove relative links to images in Readme
* [PR 9098](https://github.com/spyder-ide/spyder/pull/9098) - PR: Avoid some permission errors at startup on Windows  ([9093](https://github.com/spyder-ide/spyder/issues/9093))

In this release 12 pull requests were closed.


----


## Version 3.3.4 (2019-03-31)

### New features

* Fix several incompatibilities with PyQt5 5.12.
* Avoid errors when running `turtle` programs in the IPython console
  multiple times.
* Avoid the UMR to reload modules installed in the user site-packages
  directory.

### Issues Closed

* [Issue 8978](https://github.com/spyder-ide/spyder/issues/8978) - Github login window is resizing automatically ([PR 8993](https://github.com/spyder-ide/spyder/pull/8993))
* [Issue 8934](https://github.com/spyder-ide/spyder/issues/8934) - IOError raised when completion plugins fail to start ([PR 8950](https://github.com/spyder-ide/spyder/pull/8950))
* [Issue 8927](https://github.com/spyder-ide/spyder/issues/8927) - Change "Clear variables" to "Remove variables" in French translation ([PR 8951](https://github.com/spyder-ide/spyder/pull/8951))
* [Issue 8878](https://github.com/spyder-ide/spyder/issues/8878) - Error when try to type opening bracket in console ([PR 8879](https://github.com/spyder-ide/spyder/pull/8879))
* [Issue 8841](https://github.com/spyder-ide/spyder/issues/8841) - Static Code Analysis can be attempted without selected file ([PR 8921](https://github.com/spyder-ide/spyder/pull/8921))
* [Issue 8807](https://github.com/spyder-ide/spyder/issues/8807) - Error when saving LANG_FILE ([PR 8808](https://github.com/spyder-ide/spyder/pull/8808))
* [Issue 8789](https://github.com/spyder-ide/spyder/issues/8789) - spyder_io_hdf5 plugin no longer available ([PR 8790](https://github.com/spyder-ide/spyder/pull/8790))
* [Issue 8776](https://github.com/spyder-ide/spyder/issues/8776) - Problem with debugfile() in version >= 3.3.0
* [Issue 8764](https://github.com/spyder-ide/spyder/issues/8764) - VersionConflict when opening a file in the Editor ([PR 8781](https://github.com/spyder-ide/spyder/pull/8781))
* [Issue 8762](https://github.com/spyder-ide/spyder/issues/8762) - Text written in help pane gets automatically selected and replaced with every keystroke ([PR 8907](https://github.com/spyder-ide/spyder/pull/8907))
* [Issue 8748](https://github.com/spyder-ide/spyder/issues/8748) - spyder 3.3.3 icon theme Spyder 3 problem with PyQt 5.12 ([PR 8896](https://github.com/spyder-ide/spyder/pull/8896))
* [Issue 8747](https://github.com/spyder-ide/spyder/issues/8747) - Spyder should depend on QtWebEngine for pyqt >= 5.12 ([PR 8753](https://github.com/spyder-ide/spyder/pull/8753))
* [Issue 6278](https://github.com/spyder-ide/spyder/issues/6278) - Problems with running turtle programs in Spyder

In this release 13 issues were closed.

### Pull Requests Merged

* [PR 9073](https://github.com/spyder-ide/spyder/pull/9073) - PR: Increase minimal required version of spyder-kernels to 0.4.3
* [PR 9041](https://github.com/spyder-ide/spyder/pull/9041) - PR: Fix a recurrrent error with our IPython console tests
* [PR 9023](https://github.com/spyder-ide/spyder/pull/9023) - PR: Fix warning and todo action menu entries
* [PR 9020](https://github.com/spyder-ide/spyder/pull/9020) - PR: Fix our tests on Windows/Python 3.7
* [PR 8996](https://github.com/spyder-ide/spyder/pull/8996) - PR: Generate PyPI long description from README.md
* [PR 8993](https://github.com/spyder-ide/spyder/pull/8993) - PR: Fix over-height resize of the Github login dialog ([8978](https://github.com/spyder-ide/spyder/issues/8978))
* [PR 8953](https://github.com/spyder-ide/spyder/pull/8953) - PR: Compile French translation po file
* [PR 8951](https://github.com/spyder-ide/spyder/pull/8951) - PR: Change 'Supprimer' for 'Effacer' in remove variables text for French translation ([8927](https://github.com/spyder-ide/spyder/issues/8927))
* [PR 8950](https://github.com/spyder-ide/spyder/pull/8950) - PR: Don't raise an error if completion plugins fail to start ([8934](https://github.com/spyder-ide/spyder/issues/8934))
* [PR 8928](https://github.com/spyder-ide/spyder/pull/8928) - PR: Use generic Qt name instead of Qt4 when switching backend for Mayavi
* [PR 8921](https://github.com/spyder-ide/spyder/pull/8921) - PR: Set enabled value of start_button with is_valid (Static Code Analysis) ([8841](https://github.com/spyder-ide/spyder/issues/8841))
* [PR 8910](https://github.com/spyder-ide/spyder/pull/8910) - PR: Fix tests on Windows/Python 3.7
* [PR 8907](https://github.com/spyder-ide/spyder/pull/8907) - PR: Fix force_refresh to only force with valid object entries (Help plugin) ([8762](https://github.com/spyder-ide/spyder/issues/8762))
* [PR 8899](https://github.com/spyder-ide/spyder/pull/8899) - PR: Run our tests with pip on Windows/Python 3.7
* [PR 8896](https://github.com/spyder-ide/spyder/pull/8896) - PR: Increase minimal QtAwesome version to 0.5.7 ([8748](https://github.com/spyder-ide/spyder/issues/8748))
* [PR 8895](https://github.com/spyder-ide/spyder/pull/8895) - PR: Remove Appveyor support and stop testing on Windows/Python 2
* [PR 8879](https://github.com/spyder-ide/spyder/pull/8879) - PR: Don't fail on UnicodeEncodeError when saving Help's search history to disk ([8878](https://github.com/spyder-ide/spyder/issues/8878))
* [PR 8808](https://github.com/spyder-ide/spyder/pull/8808) - PR: Avoid errors when trying to save LANG_FILE ([8807](https://github.com/spyder-ide/spyder/issues/8807))
* [PR 8802](https://github.com/spyder-ide/spyder/pull/8802) - PR: Upgrade Travis config to use Xenial image
* [PR 8790](https://github.com/spyder-ide/spyder/pull/8790) - PR: Fix missing spyder_io_hdf5 plugin ([8789](https://github.com/spyder-ide/spyder/issues/8789))
* [PR 8781](https://github.com/spyder-ide/spyder/pull/8781) - PR: Avoid errors when using Pygments to detect the lexer used to highlight a file ([8764](https://github.com/spyder-ide/spyder/issues/8764))
* [PR 8756](https://github.com/spyder-ide/spyder/pull/8756) - PR: Fix PyQt5 pinning restrictions in setup.py
* [PR 8753](https://github.com/spyder-ide/spyder/pull/8753) - PR: Add pyqtwebengine as a new dependency ([8747](https://github.com/spyder-ide/spyder/issues/8747))

In this release 23 pull requests were closed.


----


## Version 3.3.3 (2019-02-09)

### New features

* Fix an incompatibility with Numpy 1.16 that generated an error
  when trying to open an array in the Variable Explorer.
* Increase maximum PyQt5 supported version to 5.12
* Increase minimal required version of spyder-kernels to 0.4.2
  to get important fixes about saving/loading the current
  namespace and skipping installed modules from our User Module
  Reloader (UMR).

### Issues Closed

* [Issue 8697](https://github.com/spyder-ide/spyder/issues/8697) - Starting a python file importing tensorflow the second time results in error
* [Issue 8681](https://github.com/spyder-ide/spyder/issues/8681) - PYTHONPATH environment variable not inherited if using non-default python interpreter ([PR 8685](https://github.com/spyder-ide/spyder/pull/8685))
* [Issue 8668](https://github.com/spyder-ide/spyder/issues/8668) - Console throws error about wurlitzer on fresh install
* [Issue 8582](https://github.com/spyder-ide/spyder/issues/8582) - Spyder encountered a problem when opening numpy array ([PR 8632](https://github.com/spyder-ide/spyder/pull/8632))
* [Issue 8581](https://github.com/spyder-ide/spyder/issues/8581) - An error ocurred while starting the kernel: b'' ([PR 8736](https://github.com/spyder-ide/spyder/pull/8736))
* [Issue 8475](https://github.com/spyder-ide/spyder/issues/8475) - pyqt5 Dependency seems outdated ([PR 8530](https://github.com/spyder-ide/spyder/pull/8530))

In this release 6 issues were closed.

### Pull Requests Merged

* [PR 8736](https://github.com/spyder-ide/spyder/pull/8736) - PR: Don't show empty kernel error messages ([8581](https://github.com/spyder-ide/spyder/issues/8581))
* [PR 8731](https://github.com/spyder-ide/spyder/pull/8731) - PR: Backport PR 8559
* [PR 8728](https://github.com/spyder-ide/spyder/pull/8728) - PR: Increase minimal spyder-kernels version in setup.py to avoid faulty release
* [PR 8696](https://github.com/spyder-ide/spyder/pull/8696) - PR: Increase minimal required version of spyder-kernels
* [PR 8689](https://github.com/spyder-ide/spyder/pull/8689) - PR: Backport PR 8363
* [PR 8686](https://github.com/spyder-ide/spyder/pull/8686) - PR: Backport PR 8452
* [PR 8685](https://github.com/spyder-ide/spyder/pull/8685) - PR: Avoid dropping predefined PYTHONPATH when using an external interpreter ([8681](https://github.com/spyder-ide/spyder/issues/8681))
* [PR 8636](https://github.com/spyder-ide/spyder/pull/8636) - PR: Improve warning for when only some namespace objs couldn't be saved
* [PR 8632](https://github.com/spyder-ide/spyder/pull/8632) - PR: Don't force write flag to True in ArrayEditor, to fix compat with Numpy >=1.16 ([8582](https://github.com/spyder-ide/spyder/issues/8582))
* [PR 8530](https://github.com/spyder-ide/spyder/pull/8530) - PR: Increase maximum PyQt5 supported version ([8475](https://github.com/spyder-ide/spyder/issues/8475))

In this release 10 pull requests were closed.


----


## Version 3.3.2 (2018-11-24)

#### Main Window

### New features


* Add new German and Hungarian translations.

#### Preferences

* Give users the ability to select the OpenGL implementation
  used by Qt. This option can be changed in
  `General > Advanced Settings > Rendering engine`.

#### Find in files

* Simplify the way to exclude files from search.
* Fix error that prevented to stop a search when it was in
  progress.
* Save its options when Spyder is closed.

#### Under the hood

* Don't remove Spyder's temporary directory when Spyder is
  closed. This avoids conflicts when multiple Spyder
  instances are running.

### Issues Closed

* [Issue 8290](https://github.com/spyder-ide/spyder/issues/8290) - spyder.desktop doesn't contain  WMClass variable for grouping windows ([PR 8292](https://github.com/spyder-ide/spyder/pull/8292))
* [Issue 8236](https://github.com/spyder-ide/spyder/issues/8236) - Update translations for 3.3.2
* [Issue 8216](https://github.com/spyder-ide/spyder/issues/8216) - Error on startup with non-clean config file (from previous files/projects open?) and recent master builds ([PR 8249](https://github.com/spyder-ide/spyder/pull/8249))
* [Issue 8179](https://github.com/spyder-ide/spyder/issues/8179) - Error when changing language from French to English ([PR 8188](https://github.com/spyder-ide/spyder/pull/8188))
* [Issue 8128](https://github.com/spyder-ide/spyder/issues/8128) - Error raises when use multiprocessing
* [Issue 8103](https://github.com/spyder-ide/spyder/issues/8103) - DeprecationWarning with iPython during executing certain commands in the console.
* [Issue 8046](https://github.com/spyder-ide/spyder/issues/8046) - PermissionError while launching Spyder ([PR 8048](https://github.com/spyder-ide/spyder/pull/8048))
* [Issue 8025](https://github.com/spyder-ide/spyder/issues/8025) - Custom interpreters are not shown in "Preferences > Python interpreter" ([PR 8231](https://github.com/spyder-ide/spyder/pull/8231))
* [Issue 8007](https://github.com/spyder-ide/spyder/issues/8007) - Kernel crash due to file with the same name of a stdlib Python module present in current working directory
* [Issue 7882](https://github.com/spyder-ide/spyder/issues/7882) - Error while restarting kernel ([PR 7887](https://github.com/spyder-ide/spyder/pull/7887))
* [Issue 7868](https://github.com/spyder-ide/spyder/issues/7868) - Connect to kernel dialog needs to be clearer that either the SSH keyfile *or* the password is required ([PR 7898](https://github.com/spyder-ide/spyder/pull/7898))
* [Issue 7862](https://github.com/spyder-ide/spyder/issues/7862) - 4.0beta1 is offered as an update when using a development version and a virtualenv ([PR 7902](https://github.com/spyder-ide/spyder/pull/7902))
* [Issue 7856](https://github.com/spyder-ide/spyder/issues/7856) - Nbconvert 5.4.0 breaking mainwindow notebook test due to change in output file text ([PR 7860](https://github.com/spyder-ide/spyder/pull/7860))
* [Issue 7811](https://github.com/spyder-ide/spyder/issues/7811) - Find In Files: empty "Exclude" field makes all files be excluded ([PR 7816](https://github.com/spyder-ide/spyder/pull/7816))
* [Issue 7810](https://github.com/spyder-ide/spyder/issues/7810) - Find In Files: regexp icon ([PR 7864](https://github.com/spyder-ide/spyder/pull/7864))
* [Issue 7809](https://github.com/spyder-ide/spyder/issues/7809) - Make visible by default the widget to exclude file types in Find in Files ([PR 7864](https://github.com/spyder-ide/spyder/pull/7864))
* [Issue 7804](https://github.com/spyder-ide/spyder/issues/7804) - Stopping a search using FindInFiles freezes the app ([PR 7806](https://github.com/spyder-ide/spyder/pull/7806))
* [Issue 7803](https://github.com/spyder-ide/spyder/issues/7803) - Change the way to exclude file types in Find in files ([PR 7806](https://github.com/spyder-ide/spyder/pull/7806))
* [Issue 7800](https://github.com/spyder-ide/spyder/issues/7800) - FileNotFoundError when using custom interpreter ([PR 7829](https://github.com/spyder-ide/spyder/pull/7829))
* [Issue 7753](https://github.com/spyder-ide/spyder/issues/7753) - Error when copying data from a dataframe ([PR 7759](https://github.com/spyder-ide/spyder/pull/7759))
* [Issue 7748](https://github.com/spyder-ide/spyder/issues/7748) - Cannot import notebook variables ([PR 7761](https://github.com/spyder-ide/spyder/pull/7761))
* [Issue 7742](https://github.com/spyder-ide/spyder/issues/7742) - Error when dropping files in the Editor ([PR 7764](https://github.com/spyder-ide/spyder/pull/7764))
* [Issue 7733](https://github.com/spyder-ide/spyder/issues/7733) - Error when browsing git repository ([PR 7766](https://github.com/spyder-ide/spyder/pull/7766))
* [Issue 7721](https://github.com/spyder-ide/spyder/issues/7721) - Error after upgrading to Python 3.7 ([PR 7807](https://github.com/spyder-ide/spyder/pull/7807))
* [Issue 7705](https://github.com/spyder-ide/spyder/issues/7705) - Error on saving generated by Pygments lexers ([PR 7712](https://github.com/spyder-ide/spyder/pull/7712))
* [Issue 7674](https://github.com/spyder-ide/spyder/issues/7674) - New Python interpreter selection combobox displays previous, not actual executable path if selected from file browser ([PR 7715](https://github.com/spyder-ide/spyder/pull/7715))
* [Issue 7619](https://github.com/spyder-ide/spyder/issues/7619) - Error when trying to display Latex through Matplotlib
* [Issue 7578](https://github.com/spyder-ide/spyder/issues/7578) - AttributeError: 'NoneType' object has no attribute 'input' ([PR 7716](https://github.com/spyder-ide/spyder/pull/7716))
* [Issue 7561](https://github.com/spyder-ide/spyder/issues/7561) - Annoying "Are you sure you want to restart the kernel?" ([PR 7694](https://github.com/spyder-ide/spyder/pull/7694))
* [Issue 7552](https://github.com/spyder-ide/spyder/issues/7552) - TypeError: scaledToWidth in the IPython console
* [Issue 7447](https://github.com/spyder-ide/spyder/issues/7447) - Main window is black when starting Spyder over ssh/X11 ([PR 7859](https://github.com/spyder-ide/spyder/pull/7859))
* [Issue 7302](https://github.com/spyder-ide/spyder/issues/7302) - PermissionError when launching kernel ([PR 7717](https://github.com/spyder-ide/spyder/pull/7717))
* [Issue 7244](https://github.com/spyder-ide/spyder/issues/7244) - AttributeError when pasting list in collectionseditor.py ([PR 7817](https://github.com/spyder-ide/spyder/pull/7817))
* [Issue 7236](https://github.com/spyder-ide/spyder/issues/7236) - UnicodeDecodeError when changing PYTHONPATH in Python 2 ([PR 7655](https://github.com/spyder-ide/spyder/pull/7655))
* [Issue 7195](https://github.com/spyder-ide/spyder/issues/7195) - Crash when displaying a pandas data frame with a column containing a data frame ([PR 8114](https://github.com/spyder-ide/spyder/pull/8114))
* [Issue 7177](https://github.com/spyder-ide/spyder/issues/7177) - Error when passing a regexp to the findreplace widget ([PR 8115](https://github.com/spyder-ide/spyder/pull/8115))
* [Issue 6936](https://github.com/spyder-ide/spyder/issues/6936) - Data Type of customized class is changed to base class when viewed in the Variable Explorer ([PR 7679](https://github.com/spyder-ide/spyder/pull/7679))
* [Issue 6535](https://github.com/spyder-ide/spyder/issues/6535) - Text in "About Spyder" menu is not selectable ([PR 7727](https://github.com/spyder-ide/spyder/pull/7727))
* [Issue 6218](https://github.com/spyder-ide/spyder/issues/6218) - UnicodeDecodeError when truncating results in Find in files ([PR 7812](https://github.com/spyder-ide/spyder/pull/7812))
* [Issue 6176](https://github.com/spyder-ide/spyder/issues/6176) - Find in Files options not saved to spyder.ini ([PR 7863](https://github.com/spyder-ide/spyder/pull/7863))
* [Issue 5898](https://github.com/spyder-ide/spyder/issues/5898) - Closing all files in split pane view with at least 2 open then clicking any menu triggers RuntimeError
* [Issue 4474](https://github.com/spyder-ide/spyder/issues/4474) - Find in files exclude as a textbox is very limited (not very UX friendly either) ([PR 7864](https://github.com/spyder-ide/spyder/pull/7864))
* [Issue 4291](https://github.com/spyder-ide/spyder/issues/4291) - Menu items don't show in full-screen mode ([PR 7720](https://github.com/spyder-ide/spyder/pull/7720))
* [Issue 3777](https://github.com/spyder-ide/spyder/issues/3777) - Output of C extensions is not shown in IPython console
* [Issue 937](https://github.com/spyder-ide/spyder/issues/937) - Editor maximized - Run script - console takes most of screen ([PR 7205](https://github.com/spyder-ide/spyder/pull/7205))

In this release 45 issues were closed.

### Pull Requests Merged

* [PR 8292](https://github.com/spyder-ide/spyder/pull/8292) - PR: Add StartupWMClass to Linux desktop files ([8290](https://github.com/spyder-ide/spyder/issues/8290))
* [PR 8278](https://github.com/spyder-ide/spyder/pull/8278) - PR: Update Spanish translation for 3.3.2
* [PR 8264](https://github.com/spyder-ide/spyder/pull/8264) - PR: French Translation for 3.3.2
* [PR 8263](https://github.com/spyder-ide/spyder/pull/8263) - PR: Fix tests in Appveyor/Python 2
* [PR 8261](https://github.com/spyder-ide/spyder/pull/8261) - PR: Fix error in Pydoc widget when quitting server in Python 2
* [PR 8259](https://github.com/spyder-ide/spyder/pull/8259) - PR: Fixes due to the new Pytest 4
* [PR 8256](https://github.com/spyder-ide/spyder/pull/8256) - PR: Add German translation
* [PR 8255](https://github.com/spyder-ide/spyder/pull/8255) - PR: Update Japanese translation for 3.3.2
* [PR 8250](https://github.com/spyder-ide/spyder/pull/8250) - PR: Update Hungarian translation for 3.3.2
* [PR 8249](https://github.com/spyder-ide/spyder/pull/8249) - PR: Prevent an error during the initialization of the Editor plugin ([8216](https://github.com/spyder-ide/spyder/issues/8216))
* [PR 8248](https://github.com/spyder-ide/spyder/pull/8248) - PR: Update Russian translation
* [PR 8232](https://github.com/spyder-ide/spyder/pull/8232) - PR: Fix passing --run-slow to runtests.py
* [PR 8231](https://github.com/spyder-ide/spyder/pull/8231) - PR: Don't associate the combobox of FileComboBox to the same option as its lineedit ([8025](https://github.com/spyder-ide/spyder/issues/8025))
* [PR 8188](https://github.com/spyder-ide/spyder/pull/8188) - PR: Catch errors when trying to change the interface language ([8179](https://github.com/spyder-ide/spyder/issues/8179))
* [PR 8187](https://github.com/spyder-ide/spyder/pull/8187) - PR: Don't install qtconsole from git on Appveyor because it's generating errors
* [PR 8173](https://github.com/spyder-ide/spyder/pull/8173) - PR: Fix various DeprecationWarnings and FutureWarnings
* [PR 8152](https://github.com/spyder-ide/spyder/pull/8152) - PR: Make test_codeanalysis more robust to changes in Pyflakes and Pycodestyle
* [PR 8133](https://github.com/spyder-ide/spyder/pull/8133) - PR: Skip test_values_dbg in Python 2 because it's timing out too much
* [PR 8123](https://github.com/spyder-ide/spyder/pull/8123) - PR: Improve usability of runtests locally and test output on the CIs
* [PR 8116](https://github.com/spyder-ide/spyder/pull/8116) - PR: Do not close split editor when empty or when switching project
* [PR 8115](https://github.com/spyder-ide/spyder/pull/8115) - PR: Catch errors when trying to replace text in the Editor with a regexp ([7177](https://github.com/spyder-ide/spyder/issues/7177))
* [PR 8114](https://github.com/spyder-ide/spyder/pull/8114) - PR: Catch errors when trying to display dataframe values as strings ([7195](https://github.com/spyder-ide/spyder/issues/7195))
* [PR 8111](https://github.com/spyder-ide/spyder/pull/8111) - PR: Remove several old files
* [PR 8110](https://github.com/spyder-ide/spyder/pull/8110) - PR: Use software OpenGL implementation by default
* [PR 8048](https://github.com/spyder-ide/spyder/pull/8048) - PR: Don't raise exceptions when writing config to disk fails ([8046](https://github.com/spyder-ide/spyder/issues/8046))
* [PR 8024](https://github.com/spyder-ide/spyder/pull/8024) - PR: Remove testpath condition now that its conda packages are in good shape
* [PR 8021](https://github.com/spyder-ide/spyder/pull/8021) - PR: Fix tests by pinning testpath and switching to Python 3.5 on Windows
* [PR 7928](https://github.com/spyder-ide/spyder/pull/7928) - PR: Update PR template to link to developer COI and clarify other text
* [PR 7926](https://github.com/spyder-ide/spyder/pull/7926) - PR: Convert and optimize needed PNGs in img_src directory
* [PR 7908](https://github.com/spyder-ide/spyder/pull/7908) - PR: Fix showing kernel creation error messages
* [PR 7902](https://github.com/spyder-ide/spyder/pull/7902) - PR: Improve detection of new Spyder versions to be offered for updates ([7862](https://github.com/spyder-ide/spyder/issues/7862))
* [PR 7898](https://github.com/spyder-ide/spyder/pull/7898) - PR: Clarify and improve Connect to kernel dialog text ([7868](https://github.com/spyder-ide/spyder/issues/7868))
* [PR 7888](https://github.com/spyder-ide/spyder/pull/7888) - PR: Remove old pdn image source files that are no longer needed
* [PR 7887](https://github.com/spyder-ide/spyder/pull/7887) - PR: Remove unnecessary code to restart kernels ([7882](https://github.com/spyder-ide/spyder/issues/7882))
* [PR 7873](https://github.com/spyder-ide/spyder/pull/7873) - PR: Correct next/previous word shortcut callback ([7872](https://github.com/spyder-ide/spyder/issues/7872))
* [PR 7864](https://github.com/spyder-ide/spyder/pull/7864) - PR: More improvements to Find in Files ([7810](https://github.com/spyder-ide/spyder/issues/7810), [7809](https://github.com/spyder-ide/spyder/issues/7809), [4474](https://github.com/spyder-ide/spyder/issues/4474))
* [PR 7863](https://github.com/spyder-ide/spyder/pull/7863) - PR: Correctly save Find in Files options when closing Spyder ([6176](https://github.com/spyder-ide/spyder/issues/6176))
* [PR 7860](https://github.com/spyder-ide/spyder/pull/7860) - PR: Fix failing test due to a new version of nbconvert ([7856](https://github.com/spyder-ide/spyder/issues/7856))
* [PR 7859](https://github.com/spyder-ide/spyder/pull/7859) - PR: Set selected OpenGL implementation for QtQuick too ([7447](https://github.com/spyder-ide/spyder/issues/7447))
* [PR 7838](https://github.com/spyder-ide/spyder/pull/7838) - PR: Start testing with Python 3.7 on Linux
* [PR 7837](https://github.com/spyder-ide/spyder/pull/7837) - PR: Fix tests after ci-helpers updated conda version
* [PR 7829](https://github.com/spyder-ide/spyder/pull/7829) - PR: Use a function to create and get our temporary directory ([7800](https://github.com/spyder-ide/spyder/issues/7800))
* [PR 7817](https://github.com/spyder-ide/spyder/pull/7817) - PR: Don't import objects in collectionseditor that are not dicts ([7244](https://github.com/spyder-ide/spyder/issues/7244))
* [PR 7816](https://github.com/spyder-ide/spyder/pull/7816) - PR: Don't ignore all files when exclude pattern is empty ([7811](https://github.com/spyder-ide/spyder/issues/7811))
* [PR 7812](https://github.com/spyder-ide/spyder/pull/7812) - PR: Truncate results correctly in Find in Files for Python 2 ([6218](https://github.com/spyder-ide/spyder/issues/6218))
* [PR 7807](https://github.com/spyder-ide/spyder/pull/7807) - PR: Correctly handling pydoc._start_server on Python 3.7 ([7721](https://github.com/spyder-ide/spyder/issues/7721))
* [PR 7806](https://github.com/spyder-ide/spyder/pull/7806) - PR: Stop searches in Find in Files correctly and improve how to exclude file types ([7804](https://github.com/spyder-ide/spyder/issues/7804), [7803](https://github.com/spyder-ide/spyder/issues/7803))
* [PR 7791](https://github.com/spyder-ide/spyder/pull/7791) - PR: Remove gettext scripts separated into their own repo
* [PR 7790](https://github.com/spyder-ide/spyder/pull/7790) - PR: Protect calls to unregister_editorstack_cb and pin sip in our tests
* [PR 7785](https://github.com/spyder-ide/spyder/pull/7785) - PR: House cleaning
* [PR 7769](https://github.com/spyder-ide/spyder/pull/7769) - PR: Exclude non-runnable code from coverage reports
* [PR 7766](https://github.com/spyder-ide/spyder/pull/7766) - PR: Fix Browse and Commit vcs actions in file and project explorers ([7733](https://github.com/spyder-ide/spyder/issues/7733))
* [PR 7765](https://github.com/spyder-ide/spyder/pull/7765) - PR: Fix minor issues with the tutorial as pointed out by Dr. Fangohr himself
* [PR 7764](https://github.com/spyder-ide/spyder/pull/7764) - PR: Catch error when dropping a file on the Editor doesn't have an associated url ([7742](https://github.com/spyder-ide/spyder/issues/7742))
* [PR 7761](https://github.com/spyder-ide/spyder/pull/7761) - PR: Catch errors generated when creating the env vars dialog  ([7748](https://github.com/spyder-ide/spyder/issues/7748))
* [PR 7759](https://github.com/spyder-ide/spyder/pull/7759) - PR: Catch any error when trying to copy the contents of a dataframe ([7753](https://github.com/spyder-ide/spyder/issues/7753))
* [PR 7727](https://github.com/spyder-ide/spyder/pull/7727) - PR: Make the text of the About Spyder message box selectable ([6535](https://github.com/spyder-ide/spyder/issues/6535))
* [PR 7720](https://github.com/spyder-ide/spyder/pull/7720) - PR: Implement a workaround to toggle on/off fullscreen mode for Windows systems ([4291](https://github.com/spyder-ide/spyder/issues/4291))
* [PR 7717](https://github.com/spyder-ide/spyder/pull/7717) - PR: Catch any error generated when trying to start kernels ([7302](https://github.com/spyder-ide/spyder/issues/7302))
* [PR 7716](https://github.com/spyder-ide/spyder/pull/7716) - PR: Catch error when writing to stdin and there's no kernel client available ([7578](https://github.com/spyder-ide/spyder/issues/7578))
* [PR 7715](https://github.com/spyder-ide/spyder/pull/7715) - PR: Simplify how custom interpreters are loaded/saved ([7674](https://github.com/spyder-ide/spyder/issues/7674))
* [PR 7712](https://github.com/spyder-ide/spyder/pull/7712) - PR: Catch errors when getting file type extensions supported by Pygments ([7705](https://github.com/spyder-ide/spyder/issues/7705))
* [PR 7700](https://github.com/spyder-ide/spyder/pull/7700) - PR: Add option to select OpenGL implementation used by Qt
* [PR 7694](https://github.com/spyder-ide/spyder/pull/7694) - PR: Make "Are you sure you want to restart the kernel?" warning optional ([7561](https://github.com/spyder-ide/spyder/issues/7561))
* [PR 7691](https://github.com/spyder-ide/spyder/pull/7691) - PR: Load css when showing kernel errors in the IPython console
* [PR 7679](https://github.com/spyder-ide/spyder/pull/7679) - PR: Make editor for collection types which copy incorrectly read-only ([6936](https://github.com/spyder-ide/spyder/issues/6936))
* [PR 7655](https://github.com/spyder-ide/spyder/pull/7655) - PR: Add validation in Python 2 to prevent the addition of paths with unicode characters to the PYTHONPATH ([7236](https://github.com/spyder-ide/spyder/issues/7236))
* [PR 7205](https://github.com/spyder-ide/spyder/pull/7205) - PR: Unmaximize plugins when an action or menu calls another plugin ([937](https://github.com/spyder-ide/spyder/issues/937))
* [PR 4473](https://github.com/spyder-ide/spyder/pull/4473) - PR: Add Hungarian translation

In this release 69 pull requests were closed.


----


## Version 3.3.1 (2018-08-11)

### New features

#### Preferences

* Save the list of custom interpreters introduced in
  `Preferences > Python interpreter`.

#### IPython console

* Do not save pdb commands in debugging history

### Issues Closed

* [Issue 7652](https://github.com/spyder-ide/spyder/issues/7652) - Tutorial should be conformed to the Spyder Docs style guide ([PR 7659](https://github.com/spyder-ide/spyder/pull/7659))
* [Issue 7641](https://github.com/spyder-ide/spyder/issues/7641) - Tutorial is out of date and needs updating ([PR 7643](https://github.com/spyder-ide/spyder/pull/7643))
* [Issue 7639](https://github.com/spyder-ide/spyder/issues/7639) - Include runtests.py in tarball ([PR 7651](https://github.com/spyder-ide/spyder/pull/7651))
* [Issue 7581](https://github.com/spyder-ide/spyder/issues/7581) - Update setup.py with polished, up to date description, links and metadata for PyPI ([PR 7582](https://github.com/spyder-ide/spyder/pull/7582))
* [Issue 7529](https://github.com/spyder-ide/spyder/issues/7529) - Improve selection of custom Python interpreter in Preferences ([PR 7566](https://github.com/spyder-ide/spyder/pull/7566))
* [Issue 7513](https://github.com/spyder-ide/spyder/issues/7513) - IOError when getting saved file names in a project ([PR 7515](https://github.com/spyder-ide/spyder/pull/7515))
* [Issue 7489](https://github.com/spyder-ide/spyder/issues/7489) - NameError: name '_' is not defined ([PR 7495](https://github.com/spyder-ide/spyder/pull/7495))
* [Issue 7465](https://github.com/spyder-ide/spyder/issues/7465) - "switch to console" keyboard shortcut doesn't do anything ([PR 7471](https://github.com/spyder-ide/spyder/pull/7471))
* [Issue 7452](https://github.com/spyder-ide/spyder/issues/7452) - Check for new conda packages in Anaconda's repos instead of Github ([PR 7478](https://github.com/spyder-ide/spyder/pull/7478))
* [Issue 7432](https://github.com/spyder-ide/spyder/issues/7432) - Error in display of tabulator in editor ([PR 7464](https://github.com/spyder-ide/spyder/pull/7464))
* [Issue 7404](https://github.com/spyder-ide/spyder/issues/7404) - Don't ask again ineffective in Console delete all variables dialog  ([PR 7462](https://github.com/spyder-ide/spyder/pull/7462))
* [Issue 7403](https://github.com/spyder-ide/spyder/issues/7403) - AttributeError: 'NoneType' object has no attribute 'get_active_project_path' ([PR 7409](https://github.com/spyder-ide/spyder/pull/7409))
* [Issue 7337](https://github.com/spyder-ide/spyder/issues/7337) - Update readme and contributing guide to reflect need to install (correct version of) spyder-kernels ([PR 7418](https://github.com/spyder-ide/spyder/pull/7418))
* [Issue 7328](https://github.com/spyder-ide/spyder/issues/7328) - Failure checking out a branch and the opened file is in a different path ([PR 7642](https://github.com/spyder-ide/spyder/pull/7642))
* [Issue 7324](https://github.com/spyder-ide/spyder/issues/7324) - Syntax highlighting for numeric literals containing underscores ([PR 7505](https://github.com/spyder-ide/spyder/pull/7505))
* [Issue 7299](https://github.com/spyder-ide/spyder/issues/7299) - Debugging history saves both python commands and pdb commands ([PR 7300](https://github.com/spyder-ide/spyder/pull/7300))
* [Issue 7082](https://github.com/spyder-ide/spyder/issues/7082) - Error when connecting to external kernels ([PR 7463](https://github.com/spyder-ide/spyder/pull/7463))
* [Issue 6292](https://github.com/spyder-ide/spyder/issues/6292) - Do not reopen Project explorer on startup ([PR 7546](https://github.com/spyder-ide/spyder/pull/7546))
* [Issue 1329](https://github.com/spyder-ide/spyder/issues/1329) - Spyder hangs on interactive input in internal console (input is not redirected) ([PR 7500](https://github.com/spyder-ide/spyder/pull/7500))

In this release 19 issues were closed.

### Pull Requests Merged

* [PR 7659](https://github.com/spyder-ide/spyder/pull/7659) - PR: Conform tutorial to docs style guide and further minor improvements ([7652](https://github.com/spyder-ide/spyder/issues/7652))
* [PR 7651](https://github.com/spyder-ide/spyder/pull/7651) - PR: Add runtests.py and conftest.py to our tarball ([7639](https://github.com/spyder-ide/spyder/issues/7639))
* [PR 7650](https://github.com/spyder-ide/spyder/pull/7650) - PR: Don't require keyring for Python 2 and Linux in our wheels
* [PR 7643](https://github.com/spyder-ide/spyder/pull/7643) - PR: Edit tutorial to update it, fix errors, copyedit and clarify ([7641](https://github.com/spyder-ide/spyder/issues/7641))
* [PR 7642](https://github.com/spyder-ide/spyder/pull/7642) - PR: Handle error when doing a browser history update ([7328](https://github.com/spyder-ide/spyder/issues/7328))
* [PR 7611](https://github.com/spyder-ide/spyder/pull/7611) - PR: Upgrade all links to use HTTPS where available, and fix link targets when broken/redirected
* [PR 7610](https://github.com/spyder-ide/spyder/pull/7610) - PR: Update conda install command for spyder-kernels 1.x
* [PR 7606](https://github.com/spyder-ide/spyder/pull/7606) - PR: Fix bug in spyder3.appdata.xml
* [PR 7605](https://github.com/spyder-ide/spyder/pull/7605) - PR: Send reported issues to Spyder's main repo in DEV mode
* [PR 7598](https://github.com/spyder-ide/spyder/pull/7598) - PR: Update capitalization of Spyder name, and standardize description with everywhere else
* [PR 7582](https://github.com/spyder-ide/spyder/pull/7582) - PR: Update setup.py description, metadata, links, and more ([7581](https://github.com/spyder-ide/spyder/issues/7581))
* [PR 7566](https://github.com/spyder-ide/spyder/pull/7566) - PR: Improve selection of custom interpreter ([7529](https://github.com/spyder-ide/spyder/issues/7529))
* [PR 7560](https://github.com/spyder-ide/spyder/pull/7560) - PR: Migrate to CircleCI 2.0
* [PR 7546](https://github.com/spyder-ide/spyder/pull/7546) - PR: Do not automatically open Project Explorer when opening project if user closed it ([6292](https://github.com/spyder-ide/spyder/issues/6292))
* [PR 7543](https://github.com/spyder-ide/spyder/pull/7543) - PR: Fix misspelling in Japanese translation
* [PR 7515](https://github.com/spyder-ide/spyder/pull/7515) - PR: Catch errors when saving/getting the list of open files per project ([7513](https://github.com/spyder-ide/spyder/issues/7513))
* [PR 7505](https://github.com/spyder-ide/spyder/pull/7505) - PR: Add support for numeric literals with underscores highlighting in Python 3.6 ([7324](https://github.com/spyder-ide/spyder/issues/7324))
* [PR 7502](https://github.com/spyder-ide/spyder/pull/7502) - PR: Setting tab stop width by using the width of multiple spaces ([7432](https://github.com/spyder-ide/spyder/issues/7432))
* [PR 7500](https://github.com/spyder-ide/spyder/pull/7500) - PR: Handle input commands correctly in the internal console. ([1329](https://github.com/spyder-ide/spyder/issues/1329))
* [PR 7497](https://github.com/spyder-ide/spyder/pull/7497) - PR: Reinstall Matplotlib in Appveyor in case it had been removed
* [PR 7495](https://github.com/spyder-ide/spyder/pull/7495) - PR: Avoid raising an error when getting available translations ([7489](https://github.com/spyder-ide/spyder/issues/7489))
* [PR 7478](https://github.com/spyder-ide/spyder/pull/7478) - PR: Change way to check for updates ([7452](https://github.com/spyder-ide/spyder/issues/7452))
* [PR 7471](https://github.com/spyder-ide/spyder/pull/7471) - PR: Remove old shortcut for the Python console ([7465](https://github.com/spyder-ide/spyder/issues/7465))
* [PR 7464](https://github.com/spyder-ide/spyder/pull/7464) - PR: Fix tabulation spacing by setting tab spacing after the font ([7432](https://github.com/spyder-ide/spyder/issues/7432))
* [PR 7463](https://github.com/spyder-ide/spyder/pull/7463) - PR: Fix connection to external kernels ([7082](https://github.com/spyder-ide/spyder/issues/7082))
* [PR 7462](https://github.com/spyder-ide/spyder/pull/7462) - PR: Really hide reset namespace warning in IPython console ([7404](https://github.com/spyder-ide/spyder/issues/7404))
* [PR 7453](https://github.com/spyder-ide/spyder/pull/7453) - PR: Improve message about the lack of spyder-kernels in external interpreters
* [PR 7418](https://github.com/spyder-ide/spyder/pull/7418) - PR: Update the running Github clone procedure in the readme and contributing guide to include spyder-kernels ([7337](https://github.com/spyder-ide/spyder/issues/7337))
* [PR 7409](https://github.com/spyder-ide/spyder/pull/7409) - PR: Catch AttributeError when trying to get the active project path ([7403](https://github.com/spyder-ide/spyder/issues/7403))
* [PR 7408](https://github.com/spyder-ide/spyder/pull/7408) - PR: Remove conda recipe
* [PR 7300](https://github.com/spyder-ide/spyder/pull/7300) - PR: Do not save pdb commands in debugging history ([7299](https://github.com/spyder-ide/spyder/issues/7299))

In this release 31 pull requests were closed.


----


## Version 3.3 (2018-07-06)

### New features

#### Main Window

* Add a new error reporting dialog to simplify and automate the process of
  submitting reports to Github.

#### IPython console

* Add an option to use a tight layout with inline plots. Activate it under
  `Preferences > IPython console > Graphics`.
* Add an option to turn on/off Jedi completions. Activate it under
  `Preferences > IPython console > Advanced`.

#### Variable Explorer

* Change the button names of all its viewers from `Ok` and `Cancel` to
  `Save and Close` and `Close`, respectively, to better express what each
  one really does.
* Fix several critical memory leaks.

#### Under the hood

* Remove support for PyQt 5.4 and older versions.
* Remove support for PyQt4.
* Remove support for Python 3.3.
* Move all code used to create kernels for our consoles to a new package
  called `spyder-kernels`. It's required version for Spyder 3.3+ is any
  `0.x.x` release (e.g `0.2.3`).
* Add the `keyring` package as a new dependency to safely save users
  Github passwords.

### Issues Closed

* [Issue 7356](https://github.com/spyder-ide/spyder/issues/7356) - Update translations for 3.3.0
* [Issue 7312](https://github.com/spyder-ide/spyder/issues/7312) - Spyder (Python 3.6) + Pandas 0.23 - Future Warning ([PR 7335](https://github.com/spyder-ide/spyder/pull/7335))
* [Issue 7295](https://github.com/spyder-ide/spyder/issues/7295) - HIstory browsing while debugging is broken ([PR 7296](https://github.com/spyder-ide/spyder/pull/7296))
* [Issue 7293](https://github.com/spyder-ide/spyder/issues/7293) - "Stop the current command" stops only the first run after "Run file" button is pressed more than one time ([PR 7294](https://github.com/spyder-ide/spyder/pull/7294))
* [Issue 7259](https://github.com/spyder-ide/spyder/issues/7259) - ImportError when trying to load third-party plugins ([PR 7263](https://github.com/spyder-ide/spyder/pull/7263))
* [Issue 7190](https://github.com/spyder-ide/spyder/issues/7190) - Add pythoncom and fastmat to the UMR blacklist ([PR 7198](https://github.com/spyder-ide/spyder/pull/7198))
* [Issue 7161](https://github.com/spyder-ide/spyder/issues/7161) - "SyntaxError: invalid syntax" when creating kernel manager ([PR 7163](https://github.com/spyder-ide/spyder/pull/7163))
* [Issue 7158](https://github.com/spyder-ide/spyder/issues/7158) - Validate serialized length of modified objects in the Variable Explorer ([PR 7218](https://github.com/spyder-ide/spyder/pull/7218))
* [Issue 7157](https://github.com/spyder-ide/spyder/issues/7157) - Ensure garbage collection is run in the main window when closing Variable Explorer editors ([PR 7234](https://github.com/spyder-ide/spyder/pull/7234))
* [Issue 7156](https://github.com/spyder-ide/spyder/issues/7156) - Change behavior of the Variable Explorer editors buttons ([PR 7202](https://github.com/spyder-ide/spyder/pull/7202))
* [Issue 7149](https://github.com/spyder-ide/spyder/issues/7149) - Don't save IPython history in safe mode ([PR 7151](https://github.com/spyder-ide/spyder/pull/7151))
* [Issue 7148](https://github.com/spyder-ide/spyder/issues/7148) - Error when getting Pygments lexers ([PR 7150](https://github.com/spyder-ide/spyder/pull/7150))
* [Issue 7112](https://github.com/spyder-ide/spyder/issues/7112) - Running ./bootstap.py --test should open an empty history.py ([PR 7115](https://github.com/spyder-ide/spyder/pull/7115))
* [Issue 7101](https://github.com/spyder-ide/spyder/issues/7101) - "Help > Report Issue" goes to a broken link if not logged into GitHub ([PR 7230](https://github.com/spyder-ide/spyder/pull/7230))
* [Issue 7100](https://github.com/spyder-ide/spyder/issues/7100) - typo in locale\fr ([PR 7160](https://github.com/spyder-ide/spyder/pull/7160))
* [Issue 7080](https://github.com/spyder-ide/spyder/issues/7080) - Spyder is slow to start due to big history file ([PR 7132](https://github.com/spyder-ide/spyder/pull/7132))
* [Issue 7063](https://github.com/spyder-ide/spyder/issues/7063) - RuntimeWarning when displaying min/max in the Variable Explorer ([PR 7154](https://github.com/spyder-ide/spyder/pull/7154))
* [Issue 7059](https://github.com/spyder-ide/spyder/issues/7059) - Can't use pythonw as interpreter when needed on Mac ([PR 7170](https://github.com/spyder-ide/spyder/pull/7170))
* [Issue 7051](https://github.com/spyder-ide/spyder/issues/7051) - ValueError: unknown locale when starting kernels ([PR 7159](https://github.com/spyder-ide/spyder/pull/7159))
* [Issue 7041](https://github.com/spyder-ide/spyder/issues/7041) - Multiple loading of pytorch module with script causes RuntimeError on IPython console. ([PR 7168](https://github.com/spyder-ide/spyder/pull/7168))
* [Issue 6996](https://github.com/spyder-ide/spyder/issues/6996) - Error when setting color scheme in the IPython console ([PR 7164](https://github.com/spyder-ide/spyder/pull/7164))
* [Issue 6975](https://github.com/spyder-ide/spyder/issues/6975) - AttributeError: Nonetype has no attribute "clear" when right clicking in the empty project explorer with no project open ([PR 7165](https://github.com/spyder-ide/spyder/pull/7165))
* [Issue 6970](https://github.com/spyder-ide/spyder/issues/6970) - Realtime code analysis stops working when non-ASCII characters are used in strings ([PR 7254](https://github.com/spyder-ide/spyder/pull/7254))
* [Issue 6968](https://github.com/spyder-ide/spyder/issues/6968) - Spyder crashes with segmentation fault on startup in Anaconda 4.5.0 ([PR 7029](https://github.com/spyder-ide/spyder/pull/7029))
* [Issue 6962](https://github.com/spyder-ide/spyder/issues/6962) - Add Astropy to default UMR blacklist for Python 2.7 due to resulting bug ([PR 7168](https://github.com/spyder-ide/spyder/pull/7168))
* [Issue 6942](https://github.com/spyder-ide/spyder/issues/6942) - Error when viewing bytes in the Variable Explorer ([PR 7206](https://github.com/spyder-ide/spyder/pull/7206))
* [Issue 6901](https://github.com/spyder-ide/spyder/issues/6901) - OSError: [Errno 28] No space left on device ([PR 7210](https://github.com/spyder-ide/spyder/pull/7210))
* [Issue 6899](https://github.com/spyder-ide/spyder/issues/6899) - Spyder opens new instances when double-clicking Python scripts ([PR 7260](https://github.com/spyder-ide/spyder/pull/7260))
* [Issue 6889](https://github.com/spyder-ide/spyder/issues/6889) - Remove support for PyQt4 ([PR 6961](https://github.com/spyder-ide/spyder/pull/6961))
* [Issue 6887](https://github.com/spyder-ide/spyder/issues/6887) - Include Matplotlib in Help > Dependencies ([PR 7166](https://github.com/spyder-ide/spyder/pull/7166))
* [Issue 6886](https://github.com/spyder-ide/spyder/issues/6886) - Spyder fails to start when trying to set language on Windows ([PR 7159](https://github.com/spyder-ide/spyder/pull/7159))
* [Issue 6864](https://github.com/spyder-ide/spyder/issues/6864) - UnicodeEncodeError when saving Help's history ([PR 7246](https://github.com/spyder-ide/spyder/pull/7246))
* [Issue 6851](https://github.com/spyder-ide/spyder/issues/6851) - Script executes in other console of its dedicated console is dedicated is on debugging ([PR 7243](https://github.com/spyder-ide/spyder/pull/7243))
* [Issue 6834](https://github.com/spyder-ide/spyder/issues/6834) - The tab switcher widget won't close if it loses focus ([PR 6759](https://github.com/spyder-ide/spyder/pull/6759))
* [Issue 6812](https://github.com/spyder-ide/spyder/issues/6812) - Find Russian symbols with a regexp gives an error ([PR 7209](https://github.com/spyder-ide/spyder/pull/7209))
* [Issue 6771](https://github.com/spyder-ide/spyder/issues/6771) - Cannot runfile if the name of the file contains a `'` character in Windows
* [Issue 6767](https://github.com/spyder-ide/spyder/issues/6767) - TypeError: unsupported operand type(s) for -: 'float' and 'NoneType' ([PR 6769](https://github.com/spyder-ide/spyder/pull/6769))
* [Issue 6746](https://github.com/spyder-ide/spyder/issues/6746) - 'Execute in an external system terminal' doesn't work if there is spaces in the path where the python interpreter is installed in Windows ([PR 6750](https://github.com/spyder-ide/spyder/pull/6750))
* [Issue 6743](https://github.com/spyder-ide/spyder/issues/6743) - Changing file in editor with [Ctl]+[tab] uncompatible with tiling window manager ([PR 6759](https://github.com/spyder-ide/spyder/pull/6759))
* [Issue 6619](https://github.com/spyder-ide/spyder/issues/6619) - The figure layout is not respected when plotting inline in the IPython console ([PR 6790](https://github.com/spyder-ide/spyder/pull/6790))
* [Issue 6617](https://github.com/spyder-ide/spyder/issues/6617) - Use an authentication dialog to send reports to Github ([PR 6707](https://github.com/spyder-ide/spyder/pull/6707))
* [Issue 6469](https://github.com/spyder-ide/spyder/issues/6469) - Errors when selecting a kernel from a different Python installation ([PR 7306](https://github.com/spyder-ide/spyder/pull/7306))
* [Issue 6351](https://github.com/spyder-ide/spyder/issues/6351) - No such file or directory when trying to access %userprofile ([PR 7287](https://github.com/spyder-ide/spyder/pull/7287))
* [Issue 6339](https://github.com/spyder-ide/spyder/issues/6339) - Plotting with Mayavi is broken ([PR 6919](https://github.com/spyder-ide/spyder/pull/6919))
* [Issue 6297](https://github.com/spyder-ide/spyder/issues/6297) - Avoid showing autoreload warnings ([PR 7306](https://github.com/spyder-ide/spyder/pull/7306))
* [Issue 6036](https://github.com/spyder-ide/spyder/issues/6036) - Error trying to open renamed project ([PR 7272](https://github.com/spyder-ide/spyder/pull/7272))
* [Issue 5986](https://github.com/spyder-ide/spyder/issues/5986) - Move online documentation to Github Pages ([PR 7007](https://github.com/spyder-ide/spyder/pull/7007))
* [Issue 5958](https://github.com/spyder-ide/spyder/issues/5958) - Stop button not working after second run on dedicated consoles ([PR 7245](https://github.com/spyder-ide/spyder/pull/7245))
* [Issue 5833](https://github.com/spyder-ide/spyder/issues/5833) - UnicodeDecodeError thrown when viewing Dataframes with non-ascii index ([PR 7242](https://github.com/spyder-ide/spyder/pull/7242))
* [Issue 5830](https://github.com/spyder-ide/spyder/issues/5830) - Variable Explorer is leaking memory when editing variables ([PR 7234](https://github.com/spyder-ide/spyder/pull/7234))
* [Issue 5201](https://github.com/spyder-ide/spyder/issues/5201) - Adding, removing, or moving a breakpoint while debugging changes the focus ([PR 7251](https://github.com/spyder-ide/spyder/pull/7251))

In this release 51 issues were closed.

### Pull Requests Merged

* [PR 7392](https://github.com/spyder-ide/spyder/pull/7392) - PR: Update Spanish translation for 3.3
* [PR 7376](https://github.com/spyder-ide/spyder/pull/7376) - PR: Update Brazilian Portuguese translation for 3.3
* [PR 7370](https://github.com/spyder-ide/spyder/pull/7370) - PR: French translation for 3.3
* [PR 7367](https://github.com/spyder-ide/spyder/pull/7367) - PR: Update Japanese translation for 3.3
* [PR 7335](https://github.com/spyder-ide/spyder/pull/7335) - PR: Handle deprecated Pandas methods in tests ([7312](https://github.com/spyder-ide/spyder/issues/7312))
* [PR 7306](https://github.com/spyder-ide/spyder/pull/7306) - PR: Move all kernel code to an external package called spyder-kernels ([6469](https://github.com/spyder-ide/spyder/issues/6469), [6297](https://github.com/spyder-ide/spyder/issues/6297))
* [PR 7296](https://github.com/spyder-ide/spyder/pull/7296) - PR: Fix history browsing while debugging ([7295](https://github.com/spyder-ide/spyder/issues/7295))
* [PR 7294](https://github.com/spyder-ide/spyder/pull/7294) - PR: Don't allow multiple executions in the IPython console when one is taking place ([7293](https://github.com/spyder-ide/spyder/issues/7293))
* [PR 7287](https://github.com/spyder-ide/spyder/pull/7287) - PR: Improve detection of users' home directory ([6351](https://github.com/spyder-ide/spyder/issues/6351))
* [PR 7279](https://github.com/spyder-ide/spyder/pull/7279) - PR: Fix crash while running our tests on CircleCI
* [PR 7278](https://github.com/spyder-ide/spyder/pull/7278) - PR: Fix links to Travis CI and Google Group
* [PR 7272](https://github.com/spyder-ide/spyder/pull/7272) - PR: Add validation when renaming the active project outside Spyder ([6036](https://github.com/spyder-ide/spyder/issues/6036))
* [PR 7263](https://github.com/spyder-ide/spyder/pull/7263) - PR: Catch any error when trying to load third-party plugins ([7259](https://github.com/spyder-ide/spyder/issues/7259))
* [PR 7260](https://github.com/spyder-ide/spyder/pull/7260) - PR: Add spyder-script.py as a valid name to be detected by lockfile ([6899](https://github.com/spyder-ide/spyder/issues/6899))
* [PR 7254](https://github.com/spyder-ide/spyder/pull/7254) - PR: Prevent realtime code analysis failures due to encoding errors ([6970](https://github.com/spyder-ide/spyder/issues/6970))
* [PR 7251](https://github.com/spyder-ide/spyder/pull/7251) - PR: Stop editor from jumping around when adding/removing lines with breakpoints while debugging ([5201](https://github.com/spyder-ide/spyder/issues/5201))
* [PR 7248](https://github.com/spyder-ide/spyder/pull/7248) - PR: Save credentials in the Github login dialog
* [PR 7246](https://github.com/spyder-ide/spyder/pull/7246) - PR: Catch possible errors when writing Help's history to disk ([6864](https://github.com/spyder-ide/spyder/issues/6864))
* [PR 7245](https://github.com/spyder-ide/spyder/pull/7245) - PR: Avoid disabling consoles stop button when an execution is taking place ([5958](https://github.com/spyder-ide/spyder/issues/5958))
* [PR 7243](https://github.com/spyder-ide/spyder/pull/7243) - PR: Show message in our consoles when trying to run a file while on debugging ([6851](https://github.com/spyder-ide/spyder/issues/6851))
* [PR 7242](https://github.com/spyder-ide/spyder/pull/7242) - PR: Fix error when viewing dataframe with a non-ascii index ([5833](https://github.com/spyder-ide/spyder/issues/5833))
* [PR 7237](https://github.com/spyder-ide/spyder/pull/7237) - PR: Improve pythonw detection
* [PR 7234](https://github.com/spyder-ide/spyder/pull/7234) - PR: Call garbage collector from Main Window after closing Variable Explorer editors ([7157](https://github.com/spyder-ide/spyder/issues/7157), [5830](https://github.com/spyder-ide/spyder/issues/5830))
* [PR 7232](https://github.com/spyder-ide/spyder/pull/7232) - PR: Run tests in macOS
* [PR 7230](https://github.com/spyder-ide/spyder/pull/7230) - PR: Use the error dialog to report issues too ([7101](https://github.com/spyder-ide/spyder/issues/7101))
* [PR 7218](https://github.com/spyder-ide/spyder/pull/7218) - PR: Limit length of serialized values in Variable Explorer when applying modifications ([7158](https://github.com/spyder-ide/spyder/issues/7158))
* [PR 7210](https://github.com/spyder-ide/spyder/pull/7210) - PR: Catch EnvironmentError in all places we write to disk ([6901](https://github.com/spyder-ide/spyder/issues/6901))
* [PR 7209](https://github.com/spyder-ide/spyder/pull/7209) - PR: Fix error when using unicode to search text with regular expressions in the Editor ([6812](https://github.com/spyder-ide/spyder/issues/6812))
* [PR 7206](https://github.com/spyder-ide/spyder/pull/7206) - PR: Add bytes or unicode ellipses in value_to_display ([6942](https://github.com/spyder-ide/spyder/issues/6942))
* [PR 7202](https://github.com/spyder-ide/spyder/pull/7202) - PR: Change behavior of Variable Explorer editor buttons ([7156](https://github.com/spyder-ide/spyder/issues/7156))
* [PR 7198](https://github.com/spyder-ide/spyder/pull/7198) - PR: Add fastmat and pythoncom to UMR blacklist. ([7190](https://github.com/spyder-ide/spyder/issues/7190))
* [PR 7189](https://github.com/spyder-ide/spyder/pull/7189) - PR: Add env var to prevent showing useless warning in macOS
* [PR 7170](https://github.com/spyder-ide/spyder/pull/7170) - PR: Change validation to allow pythonw executables as valid interpreters ([7059](https://github.com/spyder-ide/spyder/issues/7059))
* [PR 7169](https://github.com/spyder-ide/spyder/pull/7169) - PR: Remove internal copy of our docs
* [PR 7168](https://github.com/spyder-ide/spyder/pull/7168) - PR: Add astropy and pythorch to UMR blacklist by default. ([7041](https://github.com/spyder-ide/spyder/issues/7041), [6962](https://github.com/spyder-ide/spyder/issues/6962))
* [PR 7166](https://github.com/spyder-ide/spyder/pull/7166) - PR: Add Matplotlib as optional dependency for the IPython Console. ([6887](https://github.com/spyder-ide/spyder/issues/6887))
* [PR 7165](https://github.com/spyder-ide/spyder/pull/7165) - PR: Handle not initialized menu in DirView. ([6975](https://github.com/spyder-ide/spyder/issues/6975))
* [PR 7164](https://github.com/spyder-ide/spyder/pull/7164) - PR: Handle AttributeError when setting color scheme in the IPython Console. ([6996](https://github.com/spyder-ide/spyder/issues/6996))
* [PR 7163](https://github.com/spyder-ide/spyder/pull/7163) - PR: Show errors generated when creating QtKernelManager inside the IPython console ([7161](https://github.com/spyder-ide/spyder/issues/7161))
* [PR 7160](https://github.com/spyder-ide/spyder/pull/7160) - PR: Fix typo in 'Save File' french translation. ([7100](https://github.com/spyder-ide/spyder/issues/7100))
* [PR 7159](https://github.com/spyder-ide/spyder/pull/7159) - PR: Fix a couple of problems when setting and detecting the system locale ([7051](https://github.com/spyder-ide/spyder/issues/7051), [6886](https://github.com/spyder-ide/spyder/issues/6886))
* [PR 7154](https://github.com/spyder-ide/spyder/pull/7154) - PR: Filter a Numpy 1.14 warning shown in our consoles ([7063](https://github.com/spyder-ide/spyder/issues/7063))
* [PR 7151](https://github.com/spyder-ide/spyder/pull/7151) - PR: Avoid loading/saving IPython console history in safe mode or testing ([7149](https://github.com/spyder-ide/spyder/issues/7149))
* [PR 7150](https://github.com/spyder-ide/spyder/pull/7150) - PR: Catch any exception when trying to get Pygments lexers ([7148](https://github.com/spyder-ide/spyder/issues/7148))
* [PR 7132](https://github.com/spyder-ide/spyder/pull/7132) - PR: Limit the number of lines in history according to the relevant setting ([7080](https://github.com/spyder-ide/spyder/issues/7080))
* [PR 7115](https://github.com/spyder-ide/spyder/pull/7115) - PR: Add --safe-mode option to start with a clean config directory ([7112](https://github.com/spyder-ide/spyder/issues/7112))
* [PR 7079](https://github.com/spyder-ide/spyder/pull/7079) - PR: Add Twitter and Facebook links to Readme, for SEO/visibility
* [PR 7075](https://github.com/spyder-ide/spyder/pull/7075) - PR: Remove Jedi pinnings in our CIs
* [PR 7029](https://github.com/spyder-ide/spyder/pull/7029) - PR: Load libGL using low-level function without requiring pyopengl ([6968](https://github.com/spyder-ide/spyder/issues/6968))
* [PR 7007](https://github.com/spyder-ide/spyder/pull/7007) - PR: Update links to docs when they are ready  ([5986](https://github.com/spyder-ide/spyder/issues/5986))
* [PR 6986](https://github.com/spyder-ide/spyder/pull/6986) - PR: Adapt sphinxify for changes in Sphinx 1.8
* [PR 6977](https://github.com/spyder-ide/spyder/pull/6977) - PR: Skip tests numpy_returns and matplotlib_figure_returns for now on jedi >=0.12 and pin CIs to 0.11.1
* [PR 6973](https://github.com/spyder-ide/spyder/pull/6973) - PR: Update minimum Python version in setup.py to 3.4
* [PR 6963](https://github.com/spyder-ide/spyder/pull/6963) - PR: Add a few extra badges, fix troubleshooting link in readme and update banner
* [PR 6961](https://github.com/spyder-ide/spyder/pull/6961) - PR: Remove support for PyQt4 ([6889](https://github.com/spyder-ide/spyder/issues/6889))
* [PR 6937](https://github.com/spyder-ide/spyder/pull/6937) - PR: Check "use a tight layout for inline plots" by default in the preferences
* [PR 6925](https://github.com/spyder-ide/spyder/pull/6925) - PR: Update contributing doc with better organization, standard links and minor fixes
* [PR 6921](https://github.com/spyder-ide/spyder/pull/6921) - PR: Fix often failing elapsed time test with fuzzier check and more reps
* [PR 6920](https://github.com/spyder-ide/spyder/pull/6920) - PR: Fix tests after update to PyQt 5.9
* [PR 6919](https://github.com/spyder-ide/spyder/pull/6919) - PR: Fix Mayavi plotting in our consoles ([6339](https://github.com/spyder-ide/spyder/issues/6339))
* [PR 6909](https://github.com/spyder-ide/spyder/pull/6909) - PR: Update readme screenshot, streamline organization, add banner and update/cleanup content
* [PR 6890](https://github.com/spyder-ide/spyder/pull/6890) - PR: Bump next version to be 3.3.0
* [PR 6870](https://github.com/spyder-ide/spyder/pull/6870) - PR: Add checklists for Github issue report and pull requests
* [PR 6845](https://github.com/spyder-ide/spyder/pull/6845) - PR: Remove old code present in our kernel
* [PR 6832](https://github.com/spyder-ide/spyder/pull/6832) - PR: Add option to use Jedi in the IPython console + warning on greedy completer
* [PR 6826](https://github.com/spyder-ide/spyder/pull/6826) - PR: Add instance pattern "cls" for class methods
* [PR 6790](https://github.com/spyder-ide/spyder/pull/6790) - PR: Add an option to control bbox_inches option when plotting inline ([6619](https://github.com/spyder-ide/spyder/issues/6619))
* [PR 6772](https://github.com/spyder-ide/spyder/pull/6772) - PR: Fix a bug when running a file with a single quote character in its name
* [PR 6769](https://github.com/spyder-ide/spyder/pull/6769) - PR: Initialize start time to a time and not None ([6767](https://github.com/spyder-ide/spyder/issues/6767))
* [PR 6763](https://github.com/spyder-ide/spyder/pull/6763) - PR: Add 3.2.8 version header to the changelog
* [PR 6759](https://github.com/spyder-ide/spyder/pull/6759) - PR: Change Editor's tab switcher from Qt.SubWindow to Qt.Popup for tiling window managers ([6834](https://github.com/spyder-ide/spyder/issues/6834), [6743](https://github.com/spyder-ide/spyder/issues/6743))
* [PR 6750](https://github.com/spyder-ide/spyder/pull/6750) - PR: Enclose python exe path in double quotes ([6746](https://github.com/spyder-ide/spyder/issues/6746))
* [PR 6707](https://github.com/spyder-ide/spyder/pull/6707) - PR: Add authentication dialog to submit issues to Github ([6617](https://github.com/spyder-ide/spyder/issues/6617))

In this release 73 pull requests were closed.


----


## Version 3.2.8 (2018-03-14)

### New features

#### Editor

* Add `Ctrl+Shift+Enter` shortcut to introduce new lines at any point.

#### IPython console

* Always run Cython files in a dedicated console.

### Issues Closed

* [Issue 6729](https://github.com/spyder-ide/spyder/issues/6729) - ValueError trying to open pandas.DateOffset objects in Variable Explorer ([PR 6731](https://github.com/spyder-ide/spyder/pull/6731))
* [Issue 6728](https://github.com/spyder-ide/spyder/issues/6728) - AttributeError when attempting to edit non-writeable or non-settable attributes of certain (e.g. many common Pandas) objects in CollectionsEditor ([PR 6731](https://github.com/spyder-ide/spyder/pull/6731))
* [Issue 6727](https://github.com/spyder-ide/spyder/issues/6727) - TypeError and Python hard crash to desktop after modifying _typ attribute of pandas Period in CollectionsEditor ([PR 6731](https://github.com/spyder-ide/spyder/pull/6731))
* [Issue 6689](https://github.com/spyder-ide/spyder/issues/6689) - Saving session data (spydata) deletes all arrays nested inside other data structures ([PR 6692](https://github.com/spyder-ide/spyder/pull/6692))
* [Issue 6682](https://github.com/spyder-ide/spyder/issues/6682) - System time change causes Spyder error ([PR 6699](https://github.com/spyder-ide/spyder/pull/6699))
* [Issue 6673](https://github.com/spyder-ide/spyder/issues/6673) - AttributeError: 'NoneType' object has no attribute 'apply_plugin_settings' when attempting to activate Automatic Connections for Help
* [Issue 6664](https://github.com/spyder-ide/spyder/issues/6664) - Typo in introspection.utils.get_words
* [Issue 6570](https://github.com/spyder-ide/spyder/issues/6570) - Sphinx html_use_smartypants is deprecated as of 1.6 and removed in 1.7 ([PR 6575](https://github.com/spyder-ide/spyder/pull/6575))
* [Issue 6524](https://github.com/spyder-ide/spyder/issues/6524) - Spyder always open a new instance after updating to 3.2.7 version ([PR 6712](https://github.com/spyder-ide/spyder/pull/6712))
* [Issue 6520](https://github.com/spyder-ide/spyder/issues/6520) - Strange behavior for Spyder code annotations ([PR 6681](https://github.com/spyder-ide/spyder/pull/6681))
* [Issue 6519](https://github.com/spyder-ide/spyder/issues/6519) - AttributeError: 'NoneType' object has no attribute 'apply_plugin_settings' ([PR 6587](https://github.com/spyder-ide/spyder/pull/6587))
* [Issue 6518](https://github.com/spyder-ide/spyder/issues/6518) - AttributeError: 'NoneType' object has no attribute 'load_module' ([PR 6597](https://github.com/spyder-ide/spyder/pull/6597))
* [Issue 6451](https://github.com/spyder-ide/spyder/issues/6451) - Setting a path containing a single quote ([PR 6543](https://github.com/spyder-ide/spyder/pull/6543))
* [Issue 6445](https://github.com/spyder-ide/spyder/issues/6445) - ValueError when closing a file whose folder changed name in File Explorer ([PR 6569](https://github.com/spyder-ide/spyder/pull/6569))
* [Issue 6284](https://github.com/spyder-ide/spyder/issues/6284) - When browsing MultiIndex in Object Explorer, Pandas raises NotImplementedError: isna is not defined for MultiIndex ([PR 6710](https://github.com/spyder-ide/spyder/pull/6710))
* [Issue 5717](https://github.com/spyder-ide/spyder/issues/5717) - FileNotFoundError generated for template.py ([PR 6598](https://github.com/spyder-ide/spyder/pull/6598))
* [Issue 5696](https://github.com/spyder-ide/spyder/issues/5696) - Variable Explorer windows don't close when Spyder exits; prevents it from reopening until manually closed ([PR 6703](https://github.com/spyder-ide/spyder/pull/6703))
* [Issue 5680](https://github.com/spyder-ide/spyder/issues/5680) - Bug: Find and Replace indicate "no matches" when "[", "(", or ")" included in the search string ([PR 6526](https://github.com/spyder-ide/spyder/pull/6526))
* [Issue 5642](https://github.com/spyder-ide/spyder/issues/5642) - AttributeError when attempting to view dom.minidom.Element object in Variable Explorer ([PR 6731](https://github.com/spyder-ide/spyder/pull/6731))
* [Issue 5466](https://github.com/spyder-ide/spyder/issues/5466) - How do I move to a new line while I'm in the middle of the current line? ([PR 6423](https://github.com/spyder-ide/spyder/pull/6423))
* [Issue 5299](https://github.com/spyder-ide/spyder/issues/5299) - pyximport.install() in sitecustomize.py is not a good idea ([PR 6607](https://github.com/spyder-ide/spyder/pull/6607))
* [Issue 4231](https://github.com/spyder-ide/spyder/issues/4231) - delete (context="editor", name="delete") keyboard shortcut doesn't work ([PR 6530](https://github.com/spyder-ide/spyder/pull/6530))
* [Issue 919](https://github.com/spyder-ide/spyder/issues/919) - Saving large workspace on network drive crashes Spyder on Windows ([PR 6692](https://github.com/spyder-ide/spyder/pull/6692))

In this release 23 issues were closed.

### Pull Requests Merged

* [PR 6736](https://github.com/spyder-ide/spyder/pull/6736) - PR: Error report stopgap to make instructions harder to miss
* [PR 6731](https://github.com/spyder-ide/spyder/pull/6731) - PR: Fix various bugs in Variable Explorer, including an application crash to desktop ([6729](https://github.com/spyder-ide/spyder/issues/6729), [6728](https://github.com/spyder-ide/spyder/issues/6728), [6727](https://github.com/spyder-ide/spyder/issues/6727), [5642](https://github.com/spyder-ide/spyder/issues/5642))
* [PR 6715](https://github.com/spyder-ide/spyder/pull/6715) - PR: Replace deprecated function in inline CollectionsEditor tests and add recently supported data types
* [PR 6714](https://github.com/spyder-ide/spyder/pull/6714) - PR: Make several GUI/qtbot tests more reliable by increasing timeouts and tweaking the methods used
* [PR 6713](https://github.com/spyder-ide/spyder/pull/6713) - PR: Add .pytest_cache to gitignore
* [PR 6712](https://github.com/spyder-ide/spyder/pull/6712) - PR: Fix new instance validation on Windows. ([6524](https://github.com/spyder-ide/spyder/issues/6524))
* [PR 6710](https://github.com/spyder-ide/spyder/pull/6710) - PR: Fix NotImplementedError when browsing a MultiIndex in the Collection Editor ([6284](https://github.com/spyder-ide/spyder/issues/6284))
* [PR 6703](https://github.com/spyder-ide/spyder/pull/6703) - PR: Set parent for Variable Explorer editors so Spyder closes properly ([5696](https://github.com/spyder-ide/spyder/issues/5696))
* [PR 6699](https://github.com/spyder-ide/spyder/pull/6699) - PR: Change time elapsed calculation to prevent OSError ([6682](https://github.com/spyder-ide/spyder/issues/6682))
* [PR 6692](https://github.com/spyder-ide/spyder/pull/6692) - PR: Fix bugs in session saving to spydata and improve tests ([919](https://github.com/spyder-ide/spyder/issues/919), [6689](https://github.com/spyder-ide/spyder/issues/6689))
* [PR 6681](https://github.com/spyder-ide/spyder/pull/6681) - PR: Allow TODO check marks with blank line ([6520](https://github.com/spyder-ide/spyder/issues/6520))
* [PR 6667](https://github.com/spyder-ide/spyder/pull/6667) - PR: Fix typo in utils.introspection.get_words
* [PR 6626](https://github.com/spyder-ide/spyder/pull/6626) - PR: Pin to a Tornado version less than 5.0 to avoid hangs in our tests
* [PR 6607](https://github.com/spyder-ide/spyder/pull/6607) - PR: Run Cython files in a dedicated console ([5299](https://github.com/spyder-ide/spyder/issues/5299))
* [PR 6602](https://github.com/spyder-ide/spyder/pull/6602) - PR: Avoid showing dialogs in IPython console tests to avoid segfaults
* [PR 6598](https://github.com/spyder-ide/spyder/pull/6598) - PR: Be able to open files in the Editor if no template is found ([5717](https://github.com/spyder-ide/spyder/issues/5717))
* [PR 6597](https://github.com/spyder-ide/spyder/pull/6597) - PR: Add handling for AttributteError when importing module from path ([6518](https://github.com/spyder-ide/spyder/issues/6518))
* [PR 6587](https://github.com/spyder-ide/spyder/pull/6587) - PR: Remove ipyconsole and editor attrs from the Help plugin ([6519](https://github.com/spyder-ide/spyder/issues/6519))
* [PR 6575](https://github.com/spyder-ide/spyder/pull/6575) - PR: Update deprecated Sphinx directive html_use_smartypants ([6570](https://github.com/spyder-ide/spyder/issues/6570))
* [PR 6569](https://github.com/spyder-ide/spyder/pull/6569) - PR: Allow rename from Explorer to work for directories ([6445](https://github.com/spyder-ide/spyder/issues/6445))
* [PR 6543](https://github.com/spyder-ide/spyder/pull/6543) - PR: Fix error when setting a path with a single quote ([6451](https://github.com/spyder-ide/spyder/issues/6451))
* [PR 6540](https://github.com/spyder-ide/spyder/pull/6540) - PR: Delay check whether we are running under pytest until run time
* [PR 6530](https://github.com/spyder-ide/spyder/pull/6530) - PR: Allow shortcut key for editor/delete to work like Del key ([4231](https://github.com/spyder-ide/spyder/issues/4231))
* [PR 6528](https://github.com/spyder-ide/spyder/pull/6528) - PR: Restore the previous wording for package versions in error report
* [PR 6527](https://github.com/spyder-ide/spyder/pull/6527) - PR: Skip some IPython console tests in PyQt4 because they are segfaulting too much
* [PR 6526](https://github.com/spyder-ide/spyder/pull/6526) - PR: Find/replace - return match counts on unescaped characters ([5680](https://github.com/spyder-ide/spyder/issues/5680))
* [PR 6423](https://github.com/spyder-ide/spyder/pull/6423) - PR: Add Ctrl+Shift+Enter to enter a new line in the Editor ([5466](https://github.com/spyder-ide/spyder/issues/5466))

In this release 27 pull requests were closed.


----


## Version 3.2.7 (2018-02-25)

### New features

#### Main Window

* Improve the interface to report errors to Github.

#### Variable Explorer

* Enable the display of many more Numpy array types.

#### Editor

* Copy text from the search field to the replace one
  after pressing `Tab`.

#### IPython console

* Make `%edit foo.py` open `foo.py` in the Editor on
  Windows.

#### Find in Files

* Remove items from the `Search in` list when hovering
  over them and pressing `Del`.
* Add a `Clear this list` option below `Select other
  directory`.

#### Under the hood

* Demand PyQt less than 5.10 for our wheels.

### Issues Closed

* [Issue 6484](https://github.com/spyder-ide/spyder/issues/6484) - Update translations for 3.2.7 ([PR 6491](https://github.com/spyder-ide/spyder/pull/6491))
* [Issue 6447](https://github.com/spyder-ide/spyder/issues/6447) - test_completions_custom_path fails with jedi 0.9.0 (Spyder 3) ([PR 6473](https://github.com/spyder-ide/spyder/pull/6473))
* [Issue 6431](https://github.com/spyder-ide/spyder/issues/6431) - FileNotFoundError history.py when running code in the IPython console ([PR 6434](https://github.com/spyder-ide/spyder/pull/6434))
* [Issue 6393](https://github.com/spyder-ide/spyder/issues/6393) - Mouse cursor issue with PyQt 5.10 ([PR 6478](https://github.com/spyder-ide/spyder/pull/6478))
* [Issue 6361](https://github.com/spyder-ide/spyder/issues/6361) - Add the the Collapse All and Expand All buttons to the toolbar of the Outline Explorer ([PR 6360](https://github.com/spyder-ide/spyder/pull/6360))
* [Issue 6319](https://github.com/spyder-ide/spyder/issues/6319) - PermissionError when Spyder is started ([PR 6383](https://github.com/spyder-ide/spyder/pull/6383))
* [Issue 6317](https://github.com/spyder-ide/spyder/issues/6317) - Selecting "tutorial" from help menu does not bring up Help pane automatically if not loaded, leading to user confusion ([PR 6345](https://github.com/spyder-ide/spyder/pull/6345))
* [Issue 6314](https://github.com/spyder-ide/spyder/issues/6314) - IndexError when getting help of an object ([PR 6331](https://github.com/spyder-ide/spyder/pull/6331))
* [Issue 6308](https://github.com/spyder-ide/spyder/issues/6308) - AttributeError when running code in the IPython console ([PR 6330](https://github.com/spyder-ide/spyder/pull/6330))
* [Issue 6299](https://github.com/spyder-ide/spyder/issues/6299) - RuntimeError when interrupting kernel ([PR 6303](https://github.com/spyder-ide/spyder/pull/6303))
* [Issue 6295](https://github.com/spyder-ide/spyder/issues/6295) - pdb history doesn't collapse similar text ([PR 6301](https://github.com/spyder-ide/spyder/pull/6301))
* [Issue 6267](https://github.com/spyder-ide/spyder/issues/6267) - IOError when trying to write to stderr file ([PR 6305](https://github.com/spyder-ide/spyder/pull/6305))
* [Issue 6254](https://github.com/spyder-ide/spyder/issues/6254) - Convert re expressions to use raw strings ([PR 6263](https://github.com/spyder-ide/spyder/pull/6263))
* [Issue 6245](https://github.com/spyder-ide/spyder/issues/6245) - Errors pop up when change the key shortcuts in python 2.7 ([PR 6251](https://github.com/spyder-ide/spyder/pull/6251))
* [Issue 6240](https://github.com/spyder-ide/spyder/issues/6240) - %edit magic command does not work on Windows ([PR 6244](https://github.com/spyder-ide/spyder/pull/6244))
* [Issue 6235](https://github.com/spyder-ide/spyder/issues/6235) - Color scheme changes after kernel restart ([PR 6256](https://github.com/spyder-ide/spyder/pull/6256))
* [Issue 6220](https://github.com/spyder-ide/spyder/issues/6220) - Spyder Profiler Hangs/Freezes ([PR 6238](https://github.com/spyder-ide/spyder/pull/6238))
* [Issue 6202](https://github.com/spyder-ide/spyder/issues/6202) - Bug with saved window layouts ([PR 6293](https://github.com/spyder-ide/spyder/pull/6293))
* [Issue 6188](https://github.com/spyder-ide/spyder/issues/6188) - Icon should be moved from share/pixmaps to share/icons ([PR 6408](https://github.com/spyder-ide/spyder/pull/6408))
* [Issue 6187](https://github.com/spyder-ide/spyder/issues/6187) - UnicodeEncodeError when searching text in the Editor ([PR 6189](https://github.com/spyder-ide/spyder/pull/6189))
* [Issue 6177](https://github.com/spyder-ide/spyder/issues/6177) - Uncaught error when opening a pandas DataFrame with out of bounds timestamps ([PR 6237](https://github.com/spyder-ide/spyder/pull/6237))
* [Issue 6064](https://github.com/spyder-ide/spyder/issues/6064) - Several tests fail locally under user environment with customized keyboard shortcuts due to relying on hardcoded keybindings ([PR 6262](https://github.com/spyder-ide/spyder/pull/6262))
* [Issue 5813](https://github.com/spyder-ide/spyder/issues/5813) - TypeError: tabText(self, int) when moving plugin tabs ([PR 6333](https://github.com/spyder-ide/spyder/pull/6333))
* [Issue 5799](https://github.com/spyder-ide/spyder/issues/5799) - UnicodeEncodeError when using a project with non-ascii characters on it ([PR 6435](https://github.com/spyder-ide/spyder/pull/6435))
* [Issue 5601](https://github.com/spyder-ide/spyder/issues/5601) - UnicodeDecodeError when moving a file with Project Explorer ([PR 6413](https://github.com/spyder-ide/spyder/pull/6413))
* [Issue 5316](https://github.com/spyder-ide/spyder/issues/5316) - Add missing Keywords metadata in desktop file ([PR 6409](https://github.com/spyder-ide/spyder/pull/6409))
* [Issue 5306](https://github.com/spyder-ide/spyder/issues/5306) - Paths in the "Search in" combobox of the "Find in File" plugin becomes corrupted ([PR 6095](https://github.com/spyder-ide/spyder/pull/6095))
* [Issue 5247](https://github.com/spyder-ide/spyder/issues/5247) - Improve interface to report errors ([PR 5346](https://github.com/spyder-ide/spyder/pull/5346))
* [Issue 4958](https://github.com/spyder-ide/spyder/issues/4958) - IPython console failing when custom interpreter is removed ([PR 6354](https://github.com/spyder-ide/spyder/pull/6354))
* [Issue 4482](https://github.com/spyder-ide/spyder/issues/4482) - Use Tab key to copy text to "Replace with:" field ([PR 6180](https://github.com/spyder-ide/spyder/pull/6180))

In this release 30 issues were closed.

### Pull Requests Merged

* [PR 6510](https://github.com/spyder-ide/spyder/pull/6510) - PR: Update Spanish translation
* [PR 6491](https://github.com/spyder-ide/spyder/pull/6491) - PR: French translation for 3.2.7 ([6484](https://github.com/spyder-ide/spyder/issues/6484))
* [PR 6487](https://github.com/spyder-ide/spyder/pull/6487) - PR: Update Japanese translation for 3.2.7
* [PR 6486](https://github.com/spyder-ide/spyder/pull/6486) - PR: Update Brazilian Portuguese translation
* [PR 6485](https://github.com/spyder-ide/spyder/pull/6485) - PR: Update Russian translation
* [PR 6478](https://github.com/spyder-ide/spyder/pull/6478) - PR: Demand PyQt5 less than 5.10 in our wheels ([6393](https://github.com/spyder-ide/spyder/issues/6393))
* [PR 6473](https://github.com/spyder-ide/spyder/pull/6473) - PR: Skip test_completions_custom_path if jedi version before 0.10.0 ([6447](https://github.com/spyder-ide/spyder/issues/6447))
* [PR 6468](https://github.com/spyder-ide/spyder/pull/6468) - PR: Update broken matplotlib project URL in install doc
* [PR 6435](https://github.com/spyder-ide/spyder/pull/6435) - PR: Make projects work on unicode directories ([5799](https://github.com/spyder-ide/spyder/issues/5799))
* [PR 6434](https://github.com/spyder-ide/spyder/pull/6434) - PR: Handle errors when writing history to disk in the IPython Console ([6431](https://github.com/spyder-ide/spyder/issues/6431))
* [PR 6433](https://github.com/spyder-ide/spyder/pull/6433) - PR: Fix all test files to be run independently
* [PR 6432](https://github.com/spyder-ide/spyder/pull/6432) - PR: Xfail test_auto_backend for certain versions of zmq and ipykernel
* [PR 6413](https://github.com/spyder-ide/spyder/pull/6413) - PR: Add test for file directory change in the Project Explorer. ([5601](https://github.com/spyder-ide/spyder/issues/5601))
* [PR 6409](https://github.com/spyder-ide/spyder/pull/6409) - PR: Add keywords to desktop files ([5316](https://github.com/spyder-ide/spyder/issues/5316))
* [PR 6408](https://github.com/spyder-ide/spyder/pull/6408) - PR: Change share/pixmaps to share/icons in setup.py ([6188](https://github.com/spyder-ide/spyder/issues/6188))
* [PR 6383](https://github.com/spyder-ide/spyder/pull/6383) - PR: Add error handling for the lockfile symlink on Windows ([6319](https://github.com/spyder-ide/spyder/issues/6319))
* [PR 6360](https://github.com/spyder-ide/spyder/pull/6360) - PR: Harmonized the toolbar of the Outline Explorer with its context menu. ([6361](https://github.com/spyder-ide/spyder/issues/6361))
* [PR 6354](https://github.com/spyder-ide/spyder/pull/6354) - PR: Add validation for custom interpreter option ([4958](https://github.com/spyder-ide/spyder/issues/4958))
* [PR 6345](https://github.com/spyder-ide/spyder/pull/6345) - PR: Show Help if closed when opening tutorial to avoid user confusion ([6317](https://github.com/spyder-ide/spyder/issues/6317))
* [PR 6333](https://github.com/spyder-ide/spyder/pull/6333) - PR: Fix and catch typeerror thrown when from_index is None while moving plugin tab ([5813](https://github.com/spyder-ide/spyder/issues/5813))
* [PR 6331](https://github.com/spyder-ide/spyder/pull/6331) - PR: Catch any error in the isdefined method of dochelpers ([6314](https://github.com/spyder-ide/spyder/issues/6314))
* [PR 6330](https://github.com/spyder-ide/spyder/pull/6330) - PR: Handle AttributeError when running code in the IPython Console. ([6308](https://github.com/spyder-ide/spyder/issues/6308))
* [PR 6305](https://github.com/spyder-ide/spyder/pull/6305) - PR: Catch any error when creating stderr files in the IPython console ([6267](https://github.com/spyder-ide/spyder/issues/6267))
* [PR 6303](https://github.com/spyder-ide/spyder/pull/6303) - PR: Catch RuntimeError when no kernel is running ([6299](https://github.com/spyder-ide/spyder/issues/6299))
* [PR 6302](https://github.com/spyder-ide/spyder/pull/6302) - PR: Skip test_tab_copies_find_to_replace on Linux because it fails
* [PR 6301](https://github.com/spyder-ide/spyder/pull/6301) - PR: Don't add repeated entries to history while on pdb ([6295](https://github.com/spyder-ide/spyder/issues/6295))
* [PR 6298](https://github.com/spyder-ide/spyder/pull/6298) - PR: Skip test_calltip on Python 3 and PyQt < 5.9 because it's failing there
* [PR 6293](https://github.com/spyder-ide/spyder/pull/6293) - PR: Custom layouts not working when hexstate is None ([6202](https://github.com/spyder-ide/spyder/issues/6202))
* [PR 6289](https://github.com/spyder-ide/spyder/pull/6289) - PR: Pin pyqt5 to 5.9.2 on tests because 5.10 is giving segfaults during the collection phase
* [PR 6286](https://github.com/spyder-ide/spyder/pull/6286) - PR: Install and run window manager in Travis to fix focus issues and unskip now-passing tests
* [PR 6283](https://github.com/spyder-ide/spyder/pull/6283) - PR: Update Brazilian Portuguese translation
* [PR 6263](https://github.com/spyder-ide/spyder/pull/6263) - PR: Change to re strings for Deprecation Warning ([6254](https://github.com/spyder-ide/spyder/issues/6254))
* [PR 6262](https://github.com/spyder-ide/spyder/pull/6262) - PR: Use a temporary config directory to run our tests ([6064](https://github.com/spyder-ide/spyder/issues/6064))
* [PR 6256](https://github.com/spyder-ide/spyder/pull/6256) - PR: Preserve color scheme on kernel restart ([6235](https://github.com/spyder-ide/spyder/issues/6235))
* [PR 6251](https://github.com/spyder-ide/spyder/pull/6251) - PR: Update super() call to use Python 2 style call ([6245](https://github.com/spyder-ide/spyder/issues/6245))
* [PR 6244](https://github.com/spyder-ide/spyder/pull/6244) - PR: Fix %edit magic on Windows ([6240](https://github.com/spyder-ide/spyder/issues/6240))
* [PR 6238](https://github.com/spyder-ide/spyder/pull/6238) - PR: Fix Profiler error when run is stopped ([6220](https://github.com/spyder-ide/spyder/issues/6220))
* [PR 6237](https://github.com/spyder-ide/spyder/pull/6237) - PR: Catch OutOfBoundsDatetime errors from pandas ([6177](https://github.com/spyder-ide/spyder/issues/6177))
* [PR 6207](https://github.com/spyder-ide/spyder/pull/6207) - PR: Use a checkbox in error dialog to dismiss it instead of a button
* [PR 6206](https://github.com/spyder-ide/spyder/pull/6206) - PR: Fix some completion errors in the Editor and show again no docs message in Help
* [PR 6189](https://github.com/spyder-ide/spyder/pull/6189) - PR: Fix error when searching text in the Editor in translated interfaces ([6187](https://github.com/spyder-ide/spyder/issues/6187))
* [PR 6180](https://github.com/spyder-ide/spyder/pull/6180) - PR: Find/replace - Copy search text to replace textbox on tabbing between them ([4482](https://github.com/spyder-ide/spyder/issues/4482))
* [PR 6154](https://github.com/spyder-ide/spyder/pull/6154) - PR: Add troubleshooting blurb and OS version to issue template and enhance UI
* [PR 6137](https://github.com/spyder-ide/spyder/pull/6137) - PR: Add Troubleshooting links and blurb to various appropriate places in Spyder and doc
* [PR 6129](https://github.com/spyder-ide/spyder/pull/6129) - PR: Enable the display of many more numpy array types in the Variable Explorer
* [PR 6095](https://github.com/spyder-ide/spyder/pull/6095) - PR: Fix 3 bugs and add 4 improvements to Find in Files ([5306](https://github.com/spyder-ide/spyder/issues/5306))
* [PR 6084](https://github.com/spyder-ide/spyder/pull/6084) - PR: Major overhaul of Readme, contributing and install docs
* [PR 6017](https://github.com/spyder-ide/spyder/pull/6017) - PR: Differenciate between ), }, and ] when closing brackets
* [PR 5346](https://github.com/spyder-ide/spyder/pull/5346) - PR: Change error report dialog to enter issue description before submitting it ([5247](https://github.com/spyder-ide/spyder/issues/5247))

In this release 49 pull requests were closed.


----


## Version 3.2.6 (2018-01-09)

### New features

#### Editor
* Make `Shift+Del` to cut text if users have some text
  selected.
* Make `Shift+Ins` to paste text.
* Make `Ctrl+PgUp`, `Ctrl+PgDn` and `Ctrl+Tab` shortcuts
  configurable.

#### Variable Explorer
* Display date/times in human readable format.
* Disable editing for immutable types (e.g. tuples).

#### Under the hood
* Fix installation of wheels with `pip`.

### Bugs fixed

**Issues**

* [Issue 6169](https://github.com/spyder-ide/spyder/issues/6169) - Error on Maximize Current Pane
* [Issue 6163](https://github.com/spyder-ide/spyder/issues/6163) - AttributeError when resetting console namespace
* [Issue 6152](https://github.com/spyder-ide/spyder/issues/6152) - Not able to change layouts after resetting
* [Issue 6115](https://github.com/spyder-ide/spyder/issues/6115) - DataFrame Editor raises TypeError when editing any complex type
* [Issue 6114](https://github.com/spyder-ide/spyder/issues/6114) - Fix errors when entering a value for a cell larger than the max int in Array and Dataframe editors
* [Issue 6098](https://github.com/spyder-ide/spyder/issues/6098) - Consoles get renamed when moved in the IPython console
* [Issue 6091](https://github.com/spyder-ide/spyder/issues/6091) - 3.2.5 fails to activate Matplotlib Qt5 backend
* [Issue 6080](https://github.com/spyder-ide/spyder/issues/6080) - Variable Explorer throws an error instead of displaying contents when attempting to inspect any loaded modules
* [Issue 6076](https://github.com/spyder-ide/spyder/issues/6076) - Spyder not starting in macOS because pyopengl is present
* [Issue 6075](https://github.com/spyder-ide/spyder/issues/6075) - Update to 3.2.5 with pip fails for Python 2.7 as it pulls pyqt5
* [Issue 6060](https://github.com/spyder-ide/spyder/issues/6060) - Spyder crashes upon typing `net(` in editor
* [Issue 6032](https://github.com/spyder-ide/spyder/issues/6032) - When comparing a generated and loaded profile, any negative deltas show (actual_value - ?) 1h:60min, not actual value
* [Issue 6003](https://github.com/spyder-ide/spyder/issues/6003) - Improve how we detect that Spyder is running under Anaconda
* [Issue 5973](https://github.com/spyder-ide/spyder/issues/5973) - Shift+del should delete line only when empty selection, otherwise clipboard cut
* [Issue 5953](https://github.com/spyder-ide/spyder/issues/5953) - Tuples can be "edited" in Variable Explorer but changes are discarded
* [Issue 5636](https://github.com/spyder-ide/spyder/issues/5636) - "ValueError: malformed node or string" when evaluating code that contains Path elements
* [Issue 5477](https://github.com/spyder-ide/spyder/issues/5477) - Window layout setting error
* [Issue 5426](https://github.com/spyder-ide/spyder/issues/5426) - Segmentation fault when trying to change keyboard shortcuts in Preferences
* [Issue 5384](https://github.com/spyder-ide/spyder/issues/5384) - File switcher error
* [Issue 5080](https://github.com/spyder-ide/spyder/issues/5080) - ValueError: not enough values to unpack in the File Explorer
* [Issue 4842](https://github.com/spyder-ide/spyder/issues/4842) - Add ability to change Ctrl+PgUp and PgDn shortcuts
* [Issue 4111](https://github.com/spyder-ide/spyder/issues/4111) - Keyboard shortcut hint is missing from menu item Search/Find in files
* [Issue 3674](https://github.com/spyder-ide/spyder/issues/3674) - Tab in-between find and replace text boxes

In this release 23 issues were closed

**Pull requests**

* [PR 6173](https://github.com/spyder-ide/spyder/pull/6173) - PR: Fix error when trying to maximize plugins that don't have a dock widget
* [PR 6170](https://github.com/spyder-ide/spyder/pull/6170) - PR: Catch error when resetting console namespace and no kernel_client is available
* [PR 6158](https://github.com/spyder-ide/spyder/pull/6158) - PR: Skip some tests because they are failing locally or segfaulting
* [PR 6153](https://github.com/spyder-ide/spyder/pull/6153) - PR: Cannot change windows layout on first start after reset
* [PR 6141](https://github.com/spyder-ide/spyder/pull/6141) - PR: Add shortcut to Find in Files in Search menu
* [PR 6138](https://github.com/spyder-ide/spyder/pull/6138) - PR: Mark introspection test slow and re-enable it on certain CIs
* [PR 6135](https://github.com/spyder-ide/spyder/pull/6135) - PR: Add test to verify that the Automatic backend is working correctly
* [PR 6134](https://github.com/spyder-ide/spyder/pull/6134) - PR: Run slow tests only in our CIs
* [PR 6132](https://github.com/spyder-ide/spyder/pull/6132) - PR: Fix TypeError editing any complex val in DataFrameEditor, and bug resulting in bool_s being treated as uneditable
* [PR 6125](https://github.com/spyder-ide/spyder/pull/6125) - PR: Prevent an error in the FileSwitcher when all tabs are closed in the last focused widget.
* [PR 6123](https://github.com/spyder-ide/spyder/pull/6123) - PR: Allow tab cycling shortcuts to be configurable in Editor
* [PR 6121](https://github.com/spyder-ide/spyder/pull/6121) - PR: Patch ipykernel to avoid errors when setting the Qt5 Matplotlib backend
* [PR 6118](https://github.com/spyder-ide/spyder/pull/6118) - PR: Fix crash and error dialog when triggering OverflowError (too large int) when editing arrays and dataframes
* [PR 6108](https://github.com/spyder-ide/spyder/pull/6108) - PR: Fix renames when moving IPython console tabs
* [PR 6106](https://github.com/spyder-ide/spyder/pull/6106) - PR: Fix negative deltas on profiler
* [PR 6104](https://github.com/spyder-ide/spyder/pull/6104) - PR: Avoid a calltip crash when docstring is None
* [PR 6100](https://github.com/spyder-ide/spyder/pull/6100) - PR: Fix mime type error detection in the File Explorer
* [PR 6099](https://github.com/spyder-ide/spyder/pull/6099) - PR: Remove unnecessary flaky from introspection test, minor cleanup
* [PR 6094](https://github.com/spyder-ide/spyder/pull/6094) - PR: Make Tab key properly switch between find and replace fields
* [PR 6092](https://github.com/spyder-ide/spyder/pull/6092) - PR: Fix segfault on shortcut preferences when using mouse
* [PR 6090](https://github.com/spyder-ide/spyder/pull/6090) - PR: Improve how we detect if we are running under Anaconda
* [PR 6089](https://github.com/spyder-ide/spyder/pull/6089) - PR: Avoid errors when importing pyopengl at startup
* [PR 6088](https://github.com/spyder-ide/spyder/pull/6088) - PR: Make pyqt5 a wheel dependency only for Python 3
* [PR 6081](https://github.com/spyder-ide/spyder/pull/6081) - PR: Fix error when attempting to view module contents in CollectionsEditor
* [PR 6062](https://github.com/spyder-ide/spyder/pull/6062) - PR: Add expected default behavior for Shift+Del and Shift+Ins
* [PR 6057](https://github.com/spyder-ide/spyder/pull/6057) - PR: Add coverage files and Notepad++ backups to gitignore
* [PR 6044](https://github.com/spyder-ide/spyder/pull/6044) - PR: Skip several failing tests on Windows and one on a specific CI build
* [PR 6042](https://github.com/spyder-ide/spyder/pull/6042) - PR: Add test coverage reporting with AppVeyor to Codecov
* [PR 6000](https://github.com/spyder-ide/spyder/pull/6000) - PR: Display date/times in human readable format in Variable Explorer
* [PR 5992](https://github.com/spyder-ide/spyder/pull/5992) - PR: Make bullets/numbers/headings more consistent and add Anaconda for Linux in install doc
* [PR 5991](https://github.com/spyder-ide/spyder/pull/5991) - PR: Properly disable editing in Variable Explorer for values in immutable collections (e.g. tuples)
* [PR 5746](https://github.com/spyder-ide/spyder/pull/5746) - PR: Manage types that extend str in value_to_display

In this release 32 pull requests were merged


----


## Version 3.2.5 (2017-12-25)

### New features

#### IPython Console
* Improve kernel startup time.
* Add option to show kernel elapsed time.
* Add button and option to remove all user-defined variables.
* Load `%autoreload` magic at kernel startup to make changes to
  modules take effect instantly in the console.
* Use `cloudpickle` to serialize/deserialize data between kernels
  and Spyder.

#### Variable Explorer
* Add support for `datetime.timedelta` objects.

#### Under the hood
* Add `pyqt5` as a new wheel dependency.
* Add a new `--hide-console` option and deprecate `--show-console`
  on Windows.

### Bugs fixed

**Issues**

* [Issue 5988](https://github.com/spyder-ide/spyder/issues/5988) - Update translations for 3.2.5
* [Issue 5978](https://github.com/spyder-ide/spyder/issues/5978) - Remove 'DMG Installers' option from documentation
* [Issue 5944](https://github.com/spyder-ide/spyder/issues/5944) - UserWarning: Config option use_jedi not recognized by IPCompleter
* [Issue 5885](https://github.com/spyder-ide/spyder/issues/5885) - Error when choosing rename option after editing tuple value from Variable explorer.
* [Issue 5877](https://github.com/spyder-ide/spyder/issues/5877) - Code from one file not updating when called from another if run directly in the console
* [Issue 5791](https://github.com/spyder-ide/spyder/issues/5791) - "Real-time code style analysis" checkbox in Prefs > Editor > Introspection checks for pep8, not pycodestyle
* [Issue 5776](https://github.com/spyder-ide/spyder/issues/5776) - Return value of EditorStack.has_filename not checked properly
* [Issue 5759](https://github.com/spyder-ide/spyder/issues/5759) - IPython console missing features with respect to the old Python console
* [Issue 5755](https://github.com/spyder-ide/spyder/issues/5755) - AttributeError is thrown when trying to get help of an object
* [Issue 5750](https://github.com/spyder-ide/spyder/issues/5750) - Improve working directory dropdown box
* [Issue 5748](https://github.com/spyder-ide/spyder/issues/5748) - TypeError: disconnect() failed between 'sig_prompt_ready' and all its connections
* [Issue 5728](https://github.com/spyder-ide/spyder/issues/5728) - Missing python doc in help menu
* [Issue 5718](https://github.com/spyder-ide/spyder/issues/5718) - Problems with backend "TkAgg" on Linux
* [Issue 5707](https://github.com/spyder-ide/spyder/issues/5707) - NameError when running isdefined
* [Issue 5703](https://github.com/spyder-ide/spyder/issues/5703) - Save after moving editor tabs with split panes changes wrong files
* [Issue 5661](https://github.com/spyder-ide/spyder/issues/5661) - Symbol finder gives error message
* [Issue 5640](https://github.com/spyder-ide/spyder/issues/5640) - Cannot run static code analysis on Spyder 3.2.4
* [Issue 5628](https://github.com/spyder-ide/spyder/issues/5628) - Error when trying to explore empty numpy array
* [Issue 5591](https://github.com/spyder-ide/spyder/issues/5591) - Variable explorer broken because of DeprecationWarning in ipykernel
* [Issue 5588](https://github.com/spyder-ide/spyder/issues/5588) - Close parenthesis when unmatched
* [Issue 5587](https://github.com/spyder-ide/spyder/issues/5587) - Crash on profiler because of lack of profiler.results
* [Issue 5578](https://github.com/spyder-ide/spyder/issues/5578) - Can't open preferences anymore as I get an error message
* [Issue 5568](https://github.com/spyder-ide/spyder/issues/5568) - Runtime Error raised while closing IPython Console instance
* [Issue 5559](https://github.com/spyder-ide/spyder/issues/5559) - AttributeError: 'InternalShell' object has no attribute 'is_running'
* [Issue 5557](https://github.com/spyder-ide/spyder/issues/5557) - Keyboard shortcuts reset button cannot be canceled/undone and too easy to trigger
* [Issue 5552](https://github.com/spyder-ide/spyder/issues/5552) - Explicitly stated default Russian encoding on Windows not recognized
* [Issue 5541](https://github.com/spyder-ide/spyder/issues/5541) - Automatic graphics backend throws an error
* [Issue 5535](https://github.com/spyder-ide/spyder/issues/5535) - Can't enable debug mode
* [Issue 5514](https://github.com/spyder-ide/spyder/issues/5514) - Spyder crashes after typing plt.plot( at the ipython console
* [Issue 5495](https://github.com/spyder-ide/spyder/issues/5495) - Change --show-console for --hide-console
* [Issue 5494](https://github.com/spyder-ide/spyder/issues/5494) - "Replace Selection" Erroneously Removing/Interpreting Escape Sequences
* [Issue 5475](https://github.com/spyder-ide/spyder/issues/5475) - 'Show in external file explorer' on editor menu more than once for split panels
* [Issue 5402](https://github.com/spyder-ide/spyder/issues/5402) - ValueError: invalid literal for int() with base 10: b''
* [Issue 5386](https://github.com/spyder-ide/spyder/issues/5386) - Error when replacing "\" by "\\"
* [Issue 5373](https://github.com/spyder-ide/spyder/issues/5373) - Add Clear button to (find) entry boxes
* [Issue 5360](https://github.com/spyder-ide/spyder/issues/5360) - Don't set current working directory for external kernels
* [Issue 5218](https://github.com/spyder-ide/spyder/issues/5218) - Error when drag and drop file from zip
* [Issue 5057](https://github.com/spyder-ide/spyder/issues/5057) - Fast file switch and fast symbol search do not work properly if the editor is splitted
* [Issue 5036](https://github.com/spyder-ide/spyder/issues/5036) - Exploring variables in debugging mode is giving focus to the Editor
* [Issue 4186](https://github.com/spyder-ide/spyder/issues/4186) - Spyder always opens a new instance
* [Issue 3612](https://github.com/spyder-ide/spyder/issues/3612) - Variable explorer should list datetime.timedelta variables
* [Issue 3242](https://github.com/spyder-ide/spyder/issues/3242) - Spyder is not installing the PyQt5 wheel when using pip
* [Issue 2883](https://github.com/spyder-ide/spyder/issues/2883) - Outline explorer doesn't work with second Editor window
* [Issue 2179](https://github.com/spyder-ide/spyder/issues/2179) - Breakpoint doesn't appear in gui (red circle) but is listed in Debug > Breakpoints > List breakpoints
* [Issue 1492](https://github.com/spyder-ide/spyder/issues/1492) - There should be a way to donate money to support the project

In this release 45 issues were closed

**Pull requests**

* [PR 6005](https://github.com/spyder-ide/spyder/pull/6005) - PR: Update Japanese translation for 3.2.5
* [PR 6002](https://github.com/spyder-ide/spyder/pull/6002) - PR: Update French translation for 3.2.5
* [PR 5997](https://github.com/spyder-ide/spyder/pull/5997) - PR: Update Spanish translations for 3.2.5
* [PR 5995](https://github.com/spyder-ide/spyder/pull/5995) - PR: Update Russian translation for 3.2.5
* [PR 5987](https://github.com/spyder-ide/spyder/pull/5987) - PR: Load %autoreload magic at kernel startup
* [PR 5979](https://github.com/spyder-ide/spyder/pull/5979) - PR: Remove/update outdated refs to Mac OS X, Mac DMG installers and Continuum.io
* [PR 5952](https://github.com/spyder-ide/spyder/pull/5952) - PR: Skip a test that started to fail on Windows and Python 2
* [PR 5950](https://github.com/spyder-ide/spyder/pull/5950) - PR: Disable renames for list, set and tuple in the Variable Explorer
* [PR 5902](https://github.com/spyder-ide/spyder/pull/5902) - PR: Make tabs drag behavior in the IPython console to be the same as the Editor one
* [PR 5878](https://github.com/spyder-ide/spyder/pull/5878) - PR: Several improvements to the IPython console
* [PR 5865](https://github.com/spyder-ide/spyder/pull/5865) - PR: Fix missing documentation links
* [PR 5862](https://github.com/spyder-ide/spyder/pull/5862) - PR: Add PyQt5 as a new wheel dependency
* [PR 5792](https://github.com/spyder-ide/spyder/pull/5792) - PR: Change pep8 check_executable for pycodestyle.
* [PR 5784](https://github.com/spyder-ide/spyder/pull/5784) - PR: Change for file save on split editor when tabs are moved
* [PR 5780](https://github.com/spyder-ide/spyder/pull/5780) - PR: Disable smartpants quotes in Sphinx to prevent crash with MathJax
* [PR 5778](https://github.com/spyder-ide/spyder/pull/5778) - PR: Catch AttributeError while using the Help plugin
* [PR 5777](https://github.com/spyder-ide/spyder/pull/5777) - PR: Adjust calls to use has_filenames return value of None
* [PR 5766](https://github.com/spyder-ide/spyder/pull/5766) - PR: Simplify how pyopengl is declared in setup.py
* [PR 5762](https://github.com/spyder-ide/spyder/pull/5762) - PR: Add a tooltip showing the full path of highlighted item in the working directory dropdown box
* [PR 5758](https://github.com/spyder-ide/spyder/pull/5758) - PR: Improve how Matplotlib backend is set in the IPython console
* [PR 5752](https://github.com/spyder-ide/spyder/pull/5752) - PR: Catch TypeError while executing code instructions in the IPython console
* [PR 5742](https://github.com/spyder-ide/spyder/pull/5742) - PR: Prevent Editor dockwidget to become visible when clicking on the outline explorer if the Editor is in a separate window
* [PR 5731](https://github.com/spyder-ide/spyder/pull/5731) - PR: Skip test_load_kernel_file in PyQt4 because it segfaults too much
* [PR 5714](https://github.com/spyder-ide/spyder/pull/5714) - PR: Catch NameError in isdefined
* [PR 5694](https://github.com/spyder-ide/spyder/pull/5694) - PR: Add validation for mimedata2url in Editor's dragEnterEvent
* [PR 5688](https://github.com/spyder-ide/spyder/pull/5688) - PR: Ignore warning generated by ipykernel.datapub
* [PR 5674](https://github.com/spyder-ide/spyder/pull/5674) - PR: Skip test_issue_4066 in our CIs with PyQt >= 5.9
* [PR 5666](https://github.com/spyder-ide/spyder/pull/5666) - PR: Set focus for filter line when doing symbol search
* [PR 5662](https://github.com/spyder-ide/spyder/pull/5662) - PR: Handle 3d empty numpy arrays
* [PR 5646](https://github.com/spyder-ide/spyder/pull/5646) - PR: Change position of data loading to prevent not calling validation in the Pylint plugin
* [PR 5635](https://github.com/spyder-ide/spyder/pull/5635) - PR: Change default behavior of --show-console option
* [PR 5634](https://github.com/spyder-ide/spyder/pull/5634) - PR: Catch not found file error when loading profiler results.
* [PR 5632](https://github.com/spyder-ide/spyder/pull/5632) - PR: Skip some dataframe tests on Linux
* [PR 5624](https://github.com/spyder-ide/spyder/pull/5624) - PR: Add validation for attribute 'is_running' in the Help plugin
* [PR 5619](https://github.com/spyder-ide/spyder/pull/5619) - PR: Support datetime.timedelta in variable explorer
* [PR 5618](https://github.com/spyder-ide/spyder/pull/5618) - PR: Catch search regexp error while doing replace/find
* [PR 5614](https://github.com/spyder-ide/spyder/pull/5614) - PR: Better feedback for regexp errors in find/replace
* [PR 5604](https://github.com/spyder-ide/spyder/pull/5604) - PR: Do not overwrite unmatched braces
* [PR 5585](https://github.com/spyder-ide/spyder/pull/5585) - PR: Fix ValueError when switching Python interpreters
* [PR 5584](https://github.com/spyder-ide/spyder/pull/5584) - PR: Fix typo in Solarized color schemes.
* [PR 5577](https://github.com/spyder-ide/spyder/pull/5577) - PR: Add confirmation message to reset shortcuts.
* [PR 5576](https://github.com/spyder-ide/spyder/pull/5576) - PR: Add handling for RuntimeError while closing an IPython console instance.
* [PR 5575](https://github.com/spyder-ide/spyder/pull/5575) - PR: Fix syncing of line number and plugin list for breakpoints and add unit tests.
* [PR 5560](https://github.com/spyder-ide/spyder/pull/5560) - PR: Make clear line shortcut configurable in the IPython console
* [PR 5555](https://github.com/spyder-ide/spyder/pull/5555) - PR: Don't unescape control characteres in replace in selection
* [PR 5553](https://github.com/spyder-ide/spyder/pull/5553) - PR: Add cp1251 (default Russian) encoding on Windows to be recognized by the Editor
* [PR 5538](https://github.com/spyder-ide/spyder/pull/5538) - PR: Reduce row height in dependencies dialog
* [PR 5537](https://github.com/spyder-ide/spyder/pull/5537) - PR: Add clear button to find comboboxes
* [PR 5536](https://github.com/spyder-ide/spyder/pull/5536) - PR: Fix bootstrap.py --debug
* [PR 5528](https://github.com/spyder-ide/spyder/pull/5528) - PR: Add validation to not publish pdb_state after getting values of variables
* [PR 5476](https://github.com/spyder-ide/spyder/pull/5476) - PR: Fix EditorSplitter menu_actions and add test.
* [PR 5472](https://github.com/spyder-ide/spyder/pull/5472) - PR: Don't rely on process name when detecting a previous instance
* [PR 5341](https://github.com/spyder-ide/spyder/pull/5341) - PR: Trade ipykernel.serialize for cloudpickle and remove use of publish_data
* [PR 5221](https://github.com/spyder-ide/spyder/pull/5221) - PR: Make the fileswitcher aware of split editorstacks

In this release 54 pull requests were merged


----


## Version 3.2.4 (2017-10-18)

### New features

* Add compatibility with Jedi 0.11
* Display lists with all types of elements in the Variable Explorer.

### Bugs fixed

**Issues**

* [Issue 5416](https://github.com/spyder-ide/spyder/issues/5416) - Cannot get past splash screen
* [Issue 5361](https://github.com/spyder-ide/spyder/issues/5361) - Sorting by column in variable explorer
* [Issue 5330](https://github.com/spyder-ide/spyder/issues/5330) - Error in variable explorer for dicts with mixed-type keys
* [Issue 5324](https://github.com/spyder-ide/spyder/issues/5324) - Spyder crashes because of race condition in ZMQ
* [Issue 5317](https://github.com/spyder-ide/spyder/issues/5317) - Error when opening a new project
* [Issue 5313](https://github.com/spyder-ide/spyder/issues/5313) - Not all lists are supported by the variable explorer
* [Issue 5305](https://github.com/spyder-ide/spyder/issues/5305) - Error when pressing Ctrl+C in the terminal where Spyder was started
* [Issue 5296](https://github.com/spyder-ide/spyder/issues/5296) - Increase kernel_client.hb_channel.time_to_dead even more
* [Issue 5294](https://github.com/spyder-ide/spyder/issues/5294) - Variable Explorer: sort by values not working
* [Issue 5289](https://github.com/spyder-ide/spyder/issues/5289) - Checking/Unchecking path in the pathmanager is not working as expected in the IPython console
* [Issue 5280](https://github.com/spyder-ide/spyder/issues/5280) - Enter in IPython console inserts new line when big Dataframes are in namespace
* [Issue 5271](https://github.com/spyder-ide/spyder/issues/5271) - Problem when closing files with split editors whose tabs order are not synced.
* [Issue 5254](https://github.com/spyder-ide/spyder/issues/5254) - Variable explorer crash when viewing numpy structured array
* [Issue 5253](https://github.com/spyder-ide/spyder/issues/5253) - Profiler incorrectly detects recursion
* [Issue 5232](https://github.com/spyder-ide/spyder/issues/5232) - Variable explorer raise error when try to sort dict by values
* [Issue 5226](https://github.com/spyder-ide/spyder/issues/5226) - error when closing a file
* [Issue 5225](https://github.com/spyder-ide/spyder/issues/5225) - Error when trying to sort dataframe with duplicate columns
* [Issue 5213](https://github.com/spyder-ide/spyder/issues/5213) - Error when Selecting Fig from Variable Explorer
* [Issue 5202](https://github.com/spyder-ide/spyder/issues/5202) - In ipdb, the up and down keys have a strange behaviour
* [Issue 5200](https://github.com/spyder-ide/spyder/issues/5200) - pdb.pm() raises an Error
* [Issue 5183](https://github.com/spyder-ide/spyder/issues/5183) - Issues with recognizing directory renaming
* [Issue 5099](https://github.com/spyder-ide/spyder/issues/5099) - Closing last open file while being in non-existing working dir raises exception
* [Issue 5053](https://github.com/spyder-ide/spyder/issues/5053) - AttributeError: 'NoneType' object has no attribute 'execute'
* [Issue 5003](https://github.com/spyder-ide/spyder/issues/5003) - Error when trying to edit elements of a float numpy array in variable explorer
* [Issue 4856](https://github.com/spyder-ide/spyder/issues/4856) - Some issues with dedicated consoles
* [Issue 4156](https://github.com/spyder-ide/spyder/issues/4156) - "Save as" dialog extremely slow

In this release 26 issues were closed

**Pull requests**

* [PR 5467](https://github.com/spyder-ide/spyder/pull/5467) - PR: Add an error message when sorting a dataframe on categorical dtypes
* [PR 5457](https://github.com/spyder-ide/spyder/pull/5457) - PR: Make consoles to start without an stderr file
* [PR 5450](https://github.com/spyder-ide/spyder/pull/5450) - PR: Update minimal QtPy required version
* [PR 5445](https://github.com/spyder-ide/spyder/pull/5445) - PR: Skip a Matplotlib test in PyQt4 because it's failing too much
* [PR 5392](https://github.com/spyder-ide/spyder/pull/5392) - PR: Backport PR 5159
* [PR 5389](https://github.com/spyder-ide/spyder/pull/5389) - PR: Fix crashing of the fileswitcher after closing the last file of the Editor.
* [PR 5388](https://github.com/spyder-ide/spyder/pull/5388) - PR: Change spyderproject for spyproject in some missing places.
* [PR 5358](https://github.com/spyder-ide/spyder/pull/5358) - PR: Add an error message when failing to serialize an object
* [PR 5357](https://github.com/spyder-ide/spyder/pull/5357) - PR: Skip some tests to prevent recurrent failures and segfaults
* [PR 5356](https://github.com/spyder-ide/spyder/pull/5356) - PR: Prevent a race condition with ZMQ during startup
* [PR 5342](https://github.com/spyder-ide/spyder/pull/5342) - PR: Fix history browsing while debugging
* [PR 5340](https://github.com/spyder-ide/spyder/pull/5340) - PR: Add handling for OSError's when changing directories.
* [PR 5337](https://github.com/spyder-ide/spyder/pull/5337) - PR: Display all lists in the variable explorer
* [PR 5336](https://github.com/spyder-ide/spyder/pull/5336) - PR: Add a safe getcwd function to handle errors when the current working was deleted
* [PR 5327](https://github.com/spyder-ide/spyder/pull/5327) - PR: Show error when trying to sort dataframe with duplicate columns
* [PR 5320](https://github.com/spyder-ide/spyder/pull/5320) - PR: Fix editing floats in array editor
* [PR 5311](https://github.com/spyder-ide/spyder/pull/5311) - PR: Sync correctly the closing of files in multiple editorstacks.
* [PR 5301](https://github.com/spyder-ide/spyder/pull/5301) - PR: Wait until console is ready before executing code for dedicated consoles
* [PR 5298](https://github.com/spyder-ide/spyder/pull/5298) - PR: Fix some execution delays in the IPython console
* [PR 5297](https://github.com/spyder-ide/spyder/pull/5297) - PR: A couple of fixes for Jedi 0.11
* [PR 5295](https://github.com/spyder-ide/spyder/pull/5295) - PR: Enable sorting by values in Variable Explorer
* [PR 5290](https://github.com/spyder-ide/spyder/pull/5290) - PR: Prevent unchecked paths in the pathmanager to be added to the IPython console sys.path
* [PR 5272](https://github.com/spyder-ide/spyder/pull/5272) - PR: Fix recursion error in profiler
* [PR 5259](https://github.com/spyder-ide/spyder/pull/5259) - PR: Prevent hard crash when inspecting certain structured arrays
* [PR 5246](https://github.com/spyder-ide/spyder/pull/5246) - PR: Don't show errors when kernel_client is None
* [PR 5245](https://github.com/spyder-ide/spyder/pull/5245) - PR: Fix some issues with the Editor Save dialog
* [PR 5244](https://github.com/spyder-ide/spyder/pull/5244) - PR: Apply window style only if it's not None
* [PR 5234](https://github.com/spyder-ide/spyder/pull/5234) - PR: Handle error when using deepcopy in the collections editor.
* [PR 5229](https://github.com/spyder-ide/spyder/pull/5229) - PR: Editor historystack improvements
* [PR 5204](https://github.com/spyder-ide/spyder/pull/5204) - PR: Fix calling pdb.pm() in a console

In this release 30 pull requests were merged


----


## Version 3.2.3 (2017-09-11)

### New features

* Add a button to the Variable Explorer to remove all variables at
  once.

### Bugs fixed

**Issues**

* [Issue 5167](https://github.com/spyder-ide/spyder/issues/5167) - AttributeError when using outline and split code
* [Issue 5165](https://github.com/spyder-ide/spyder/issues/5165) - 'Execute in external system terminal' unwantedly uses python2 on ubuntu16.04
* [Issue 5158](https://github.com/spyder-ide/spyder/issues/5158) - AttributeError: 'super' object has no attribute '_handle_error' in IPython console
* [Issue 5157](https://github.com/spyder-ide/spyder/issues/5157) - Renaming file containing folders yields IndexError.
* [Issue 5144](https://github.com/spyder-ide/spyder/issues/5144) - pip created executable name changes between versions
* [Issue 5114](https://github.com/spyder-ide/spyder/issues/5114) - KeyboardInterrupt error in waitingspinner
* [Issue 4680](https://github.com/spyder-ide/spyder/issues/4680) - Debug: "Run Current Line" past the end of a script doesn't exit the debugger
* [Issue 4313](https://github.com/spyder-ide/spyder/issues/4313) - "unblockcomment" incompatible with "automatically remove trailing spaces"
* [Issue 3390](https://github.com/spyder-ide/spyder/issues/3390) - RuntimeError when using outline and split code editor
* [Issue 313](https://github.com/spyder-ide/spyder/issues/313) - Variable Explorer: Add a button to remove all variables at once

In this release 10 issues were closed

**Pull requests**

* [PR 5181](https://github.com/spyder-ide/spyder/pull/5181) - PR: Use get_python_executable to run in external terminals
* [PR 5166](https://github.com/spyder-ide/spyder/pull/5166) - PR: Fix RuntimeError and AttributeError when using outline and split code editor
* [PR 5164](https://github.com/spyder-ide/spyder/pull/5164) - PR: Stop creating universal wheels
* [PR 5163](https://github.com/spyder-ide/spyder/pull/5163) - PR: Add handling for IndexError in the Editor when renaming folder containing file
* [PR 5162](https://github.com/spyder-ide/spyder/pull/5162) - PR: Don't use super in _handle_error method of IPython console
* [PR 5129](https://github.com/spyder-ide/spyder/pull/5129) - PR: Avoid KeyboardInterrupt to raise an error in waitingspinner
* [PR 5089](https://github.com/spyder-ide/spyder/pull/5089) - PR: Exit the debugger if we are about to enter to sitecustomize.py
* [PR 5017](https://github.com/spyder-ide/spyder/pull/5017) - PR: Fix unblock comments
* [PR 4885](https://github.com/spyder-ide/spyder/pull/4885) - PR: Add a button in the Variable Explorer toolbar to reset namespace

In this release 9 pull requests were merged


----


## Version 3.2.2 (2017-09-05)

### New features

* Add a button to Find in Files to make searches case sensitive.
* Extend Find in Files to select other search directories.
* Add an option to set cursor blinking speed in miliseconds in
  `Preferences > General > Interface > Cursor blinking`.
* Add checkboxes to PYTHONPATH manager to enable/disable paths.
* Show the number of matches in the Find/Replace widget.

### Bugs fixed

**Issues**

* [Issue 5111](https://github.com/spyder-ide/spyder/issues/5111) - Unable to save file in Python
* [Issue 5074](https://github.com/spyder-ide/spyder/issues/5074) - Editor - Cannot close a (vertical) split after open
* [Issue 5040](https://github.com/spyder-ide/spyder/issues/5040) - Word operators do not have a color style in the IPython console
* [Issue 5026](https://github.com/spyder-ide/spyder/issues/5026) - Increase the limit of DPI setting for IPython inline graphics
* [Issue 5019](https://github.com/spyder-ide/spyder/issues/5019) - IPython consoles can't start if Spyder temp directory is missing
* [Issue 5014](https://github.com/spyder-ide/spyder/issues/5014) - BUG: Error editing element of numpy array in variable explorer
* [Issue 4989](https://github.com/spyder-ide/spyder/issues/4989) - Spyder Issue when using ctrl+P : goto line
* [Issue 4981](https://github.com/spyder-ide/spyder/issues/4981) - Unable to start Array builder using keyboard shortcut
* [Issue 4970](https://github.com/spyder-ide/spyder/issues/4970) - Console slow to close when debugging
* [Issue 4953](https://github.com/spyder-ide/spyder/issues/4953) - Consistent layout in different panes
* [Issue 4934](https://github.com/spyder-ide/spyder/issues/4934) - "Replace selection" adds "\." anytime the string to be added contains "."
* [Issue 4921](https://github.com/spyder-ide/spyder/issues/4921) - IPython: Run Code at Startup - Magics
* [Issue 4881](https://github.com/spyder-ide/spyder/issues/4881) - Force-stop does not work on hanged progress.
* [Issue 4879](https://github.com/spyder-ide/spyder/issues/4879) - Run Configuration per file: Working Directory not remembered
* [Issue 4851](https://github.com/spyder-ide/spyder/issues/4851) - Error when trying to load third-party plugins
* [Issue 4844](https://github.com/spyder-ide/spyder/issues/4844) - Pressing Ctrl+Tab wanting to switch to another tab raises an IndexError
* [Issue 4839](https://github.com/spyder-ide/spyder/issues/4839) - Make Spyder remember tab order
* [Issue 4836](https://github.com/spyder-ide/spyder/issues/4836) - Kernels fail to start because they can't create stderr files in non-ascii accounts on Windows
* [Issue 4829](https://github.com/spyder-ide/spyder/issues/4829) - SPYDER_DEBUG=3 is failing on Windows
* [Issue 4819](https://github.com/spyder-ide/spyder/issues/4819) - Find in Files should have ignore case flag
* [Issue 4814](https://github.com/spyder-ide/spyder/issues/4814) - Extend Find in Files to select other directories
* [Issue 4684](https://github.com/spyder-ide/spyder/issues/4684) - Array editor: Change default float formatter from %.3f to %.6g
* [Issue 4681](https://github.com/spyder-ide/spyder/issues/4681) - Debug: If a breakpoint is on the first line of a script the whole script runs
* [Issue 4504](https://github.com/spyder-ide/spyder/issues/4504) - Exceptions swallow the prompt!
* [Issue 4444](https://github.com/spyder-ide/spyder/issues/4444) - Add icon to mac dock when running with bootstrap
* [Issue 4410](https://github.com/spyder-ide/spyder/issues/4410) - Editor autocompletion and help extraction not working in Spyder 3.1.4
* [Issue 4277](https://github.com/spyder-ide/spyder/issues/4277) - Option to Disable Blinking Cursor
* [Issue 4221](https://github.com/spyder-ide/spyder/issues/4221) - Spyder stops executing commands if Variable explorer shows complicated objects
* [Issue 4001](https://github.com/spyder-ide/spyder/issues/4001) - Ctrl+F should show the number of appearances in the file as #current/#total
* [Issue 3529](https://github.com/spyder-ide/spyder/issues/3529) - Spyder 3 opens a command prompt window when running certain commands
* [Issue 1105](https://github.com/spyder-ide/spyder/issues/1105) - Add the possibility to disable entries in the PYTHONPATH manager

In this release 31 issues were closed

**Pull requests**

* [PR 5128](https://github.com/spyder-ide/spyder/pull/5128) - PR: Skip package names that end in certain suffixes when loading third-party plugins
* [PR 5125](https://github.com/spyder-ide/spyder/pull/5125) - PR: Correctly move to first breakpoint after entering debugging
* [PR 5118](https://github.com/spyder-ide/spyder/pull/5118) - PR: Fix error when creating some error messagebox
* [PR 5110](https://github.com/spyder-ide/spyder/pull/5110) - PR: Add handling for non existing indexes in IPython Console clients
* [PR 5109](https://github.com/spyder-ide/spyder/pull/5109) - PR: Add more handling to actions with reference deleted
* [PR 5094](https://github.com/spyder-ide/spyder/pull/5094) - PR: Deactivate editor actions when Tab Swither is shown
* [PR 5093](https://github.com/spyder-ide/spyder/pull/5093) - PR: Skip some tests in our CIs
* [PR 5086](https://github.com/spyder-ide/spyder/pull/5086) - PR: Don't run continue when starting debug if there is a breakpoint in the first line with code.
* [PR 5079](https://github.com/spyder-ide/spyder/pull/5079) - PR: Create Spyder TEMPDIR if it does not exist when creating new consoles
* [PR 5078](https://github.com/spyder-ide/spyder/pull/5078) - PR: Fix cwd issues in the "Run > Configuration per file" dialog
* [PR 5069](https://github.com/spyder-ide/spyder/pull/5069) - PR: Increase waiting time and repetitions for tests that enter debugging
* [PR 5064](https://github.com/spyder-ide/spyder/pull/5064) - PR: Fix 1D Numpy arrays edition in the Variable Explorer
* [PR 5051](https://github.com/spyder-ide/spyder/pull/5051) - PR: Make inactive paths to be ignored when Spyder's path list is synchronized with PYTHONPATH on Windows
* [PR 5048](https://github.com/spyder-ide/spyder/pull/5048) - PR: Increase dpi limit of inline plots
* [PR 5045](https://github.com/spyder-ide/spyder/pull/5045) - PR: Allow values with '%' in config system
* [PR 5042](https://github.com/spyder-ide/spyder/pull/5042) - PR: Add a style for word operator tokens in the IPython pygments dictionary
* [PR 5028](https://github.com/spyder-ide/spyder/pull/5028) - PR: Make value_to_display more robust
* [PR 5027](https://github.com/spyder-ide/spyder/pull/5027) - PR: Increase tries for a couple of flaky tests
* [PR 5013](https://github.com/spyder-ide/spyder/pull/5013) - PR: Add test with non-ascii directory for consoles stderr file
* [PR 5008](https://github.com/spyder-ide/spyder/pull/5008) - PR: Fix setting SPYDER_DEBUG variable on Windows
* [PR 4993](https://github.com/spyder-ide/spyder/pull/4993) - PR: Fix handling of line count in the fileswitcher
* [PR 4992](https://github.com/spyder-ide/spyder/pull/4992) - PR: Prevent subprocess.Popen calls to create visible consoles on Windows.
* [PR 4991](https://github.com/spyder-ide/spyder/pull/4991) - PR: Remove regex escape characters from replacement string on the Find/Replace widget
* [PR 4990](https://github.com/spyder-ide/spyder/pull/4990) - PR: Fix shortcut to make array builders appear in the IPython Console
* [PR 4978](https://github.com/spyder-ide/spyder/pull/4978) - PR: Minor fixes in Find in Files
* [PR 4971](https://github.com/spyder-ide/spyder/pull/4971) - PR: Stop console before closing it
* [PR 4962](https://github.com/spyder-ide/spyder/pull/4962) - PR: Send Spyder python path to introspection plugins
* [PR 4961](https://github.com/spyder-ide/spyder/pull/4961) - PR: Reduce row height in shortcut dialog
* [PR 4957](https://github.com/spyder-ide/spyder/pull/4957) - PR: Clean Spyder config before re-running our tests
* [PR 4955](https://github.com/spyder-ide/spyder/pull/4955) - PR: Change format in array and dataframe editors
* [PR 4954](https://github.com/spyder-ide/spyder/pull/4954) - PR: Unify layout for panes and widgets
* [PR 4914](https://github.com/spyder-ide/spyder/pull/4914) - PR: Display prompt after errors
* [PR 4880](https://github.com/spyder-ide/spyder/pull/4880) - PR: Preserve order when saving/loading files from a project.
* [PR 4822](https://github.com/spyder-ide/spyder/pull/4822) - PR: Extend Find in Files to select other search directories
* [PR 4820](https://github.com/spyder-ide/spyder/pull/4820) - PR: Add a button to Find in Files to make searches case sensitive
* [PR 4758](https://github.com/spyder-ide/spyder/pull/4758) - PR: Add an option to set cursor blinking speed in miliseconds
* [PR 4756](https://github.com/spyder-ide/spyder/pull/4756) - PR: Add checkboxes to PYTHONPATH manager to enable/disable paths
* [PR 4443](https://github.com/spyder-ide/spyder/pull/4443) - PR: Add icon earlier when running application
* [PR 4060](https://github.com/spyder-ide/spyder/pull/4060) - PR: Show the number of matches in the Find/Replace widget

In this release 39 pull requests were merged


----


## Version 3.2.1 (2017-08-13)

### Bugs fixed

**Issues**

* [Issue 4943](https://github.com/spyder-ide/spyder/issues/4943) - Unicode symbols are not highlighted in the Editor
* [Issue 4922](https://github.com/spyder-ide/spyder/issues/4922) - Static code analysis produces error when running with empty filename
* [Issue 4873](https://github.com/spyder-ide/spyder/issues/4873) - Error when trying to get a very large namespace view from the kernel
* [Issue 4862](https://github.com/spyder-ide/spyder/issues/4862) - File execution fails with AttributeError: _Feature instance has no attribute '__len__'
* [Issue 4843](https://github.com/spyder-ide/spyder/issues/4843) - Error when attempting to close a split panel in the editor window
* [Issue 4841](https://github.com/spyder-ide/spyder/issues/4841) - Setting  QT_SCREEN_SCALE_FACTORS is not working as expected
* [Issue 4831](https://github.com/spyder-ide/spyder/issues/4831) - Error when rearranging tabs and multiple Editors
* [Issue 4824](https://github.com/spyder-ide/spyder/issues/4824) - Error when trying to print source code - AttributeError: 'QPrintDialog' object has no attribute 'addEnabledOption'
* [Issue 4816](https://github.com/spyder-ide/spyder/issues/4816) - Error when trying to change to non-ascii directories in the Working Directory toolbar
* [Issue 4811](https://github.com/spyder-ide/spyder/issues/4811) - Editor line number font size does not increase when zooming on windows
* [Issue 4810](https://github.com/spyder-ide/spyder/issues/4810) - Spyder crashes when attempting to define function named setup in IPython console
* [Issue 4806](https://github.com/spyder-ide/spyder/issues/4806) - Change color of matched parens in the IPython console
* [Issue 4797](https://github.com/spyder-ide/spyder/issues/4797) - Remove scientific_startup.py
* [Issue 4769](https://github.com/spyder-ide/spyder/issues/4769) - Exception raised when running file from project explorer
* [Issue 4763](https://github.com/spyder-ide/spyder/issues/4763) - In the Editor, tab does not switch when ctrl is released and focus remains on the tab_switcher
* [Issue 4754](https://github.com/spyder-ide/spyder/issues/4754) - Shifting multiple lines of code with ctrl + cmd + down-arrow-key doesn't work properly after first shift
* [Issue 4734](https://github.com/spyder-ide/spyder/issues/4734) - High DPI scaling messes up placement of breakpoint red circles
* [Issue 4453](https://github.com/spyder-ide/spyder/issues/4453) - Crash when opened file is renamed/deleted outside Spyder
* [Issue 4442](https://github.com/spyder-ide/spyder/issues/4442) - Segfault when closing with temporary file open
* [Issue 4304](https://github.com/spyder-ide/spyder/issues/4304) - EOLs incorrectly switch from LF to CRLF on split editor panes
* [Issue 4039](https://github.com/spyder-ide/spyder/issues/4039) - Sorting order of profiler is wrong
* [Issue 3166](https://github.com/spyder-ide/spyder/issues/3166) - Editor line numbers dissappear

In this release 22 issues were closed

**Pull requests**

* [PR 4949](https://github.com/spyder-ide/spyder/pull/4949) - PR: Add basic pep8speaks config file.
* [PR 4946](https://github.com/spyder-ide/spyder/pull/4946) - PR: Fix error when the selecting an unicode word
* [PR 4928](https://github.com/spyder-ide/spyder/pull/4928) - PR: Check that combobox text is not empty string before emiting valid signal
* [PR 4918](https://github.com/spyder-ide/spyder/pull/4918) - PR: Handle truncated dictionary of namespace view from the kernel
* [PR 4899](https://github.com/spyder-ide/spyder/pull/4899) - PR: Remove capture_dir_change method of IPython console shell widget
* [PR 4875](https://github.com/spyder-ide/spyder/pull/4875) - PR: Separate the installation of Qt from running our tests in Travis
* [PR 4870](https://github.com/spyder-ide/spyder/pull/4870) - PR: Save a reference to messagebox in EditorStack to avoid memory to be freed.
* [PR 4869](https://github.com/spyder-ide/spyder/pull/4869) - PR: Omit editor split menu option if its reference was deleted
* [PR 4866](https://github.com/spyder-ide/spyder/pull/4866) - PR: Remove TypeError and AttributeError exceptions from SpyderKernel
* [PR 4864](https://github.com/spyder-ide/spyder/pull/4864) - PR: Fix Run option in File and Project explorers
* [PR 4863](https://github.com/spyder-ide/spyder/pull/4863) - PR: Fix sorting in Profiler
* [PR 4861](https://github.com/spyder-ide/spyder/pull/4861) - PR: Install qtpy and qtconsole from Github when testing
* [PR 4850](https://github.com/spyder-ide/spyder/pull/4850) - PR: Update only current editor stack when moving tabs.
* [PR 4849](https://github.com/spyder-ide/spyder/pull/4849) - PR: Prevent importing packages that raise SystemExit exceptions when verifying if an object is defined
* [PR 4847](https://github.com/spyder-ide/spyder/pull/4847) - PR: Use Editor font to paint line numbers on all platforms
* [PR 4846](https://github.com/spyder-ide/spyder/pull/4846) - PR: Use QT_SCALE_FACTOR when users set only one scale factor
* [PR 4845](https://github.com/spyder-ide/spyder/pull/4845) - PR: Set eol_chars in cloned editor on split editor panes
* [PR 4835](https://github.com/spyder-ide/spyder/pull/4835) - PR: Delete print test because it segfaults too frequently
* [PR 4830](https://github.com/spyder-ide/spyder/pull/4830) - PR: Fix error when printing source code
* [PR 4828](https://github.com/spyder-ide/spyder/pull/4828) - PR: Fix error when using non-ascii current directory to run code
* [PR 4813](https://github.com/spyder-ide/spyder/pull/4813) - PR: Make highlighting colors in the IPython Console match those used in the Spyder Editor
* [PR 4799](https://github.com/spyder-ide/spyder/pull/4799) - PR: Delete scientific_startup.py
* [PR 4774](https://github.com/spyder-ide/spyder/pull/4774) - PR: Fix shifting code selection issues in the Editor
* [PR 4764](https://github.com/spyder-ide/spyder/pull/4764) - PR: Fix tab does not switch when ctrl is released issue
* [PR 4759](https://github.com/spyder-ide/spyder/pull/4759) - PR: Fix enable/disable spinbox bug in Editor preferences panel
* [PR 4749](https://github.com/spyder-ide/spyder/pull/4749) - PR: Add icon to MessageCheckBox while avoiding unclickable issue
* [PR 4738](https://github.com/spyder-ide/spyder/pull/4738) - PR: Update pixmap height calculation
* [PR 4733](https://github.com/spyder-ide/spyder/pull/4733) - PR: Avoid visible_blocks to be empty when first visible block is wrapped

In this release 28 pull requests were merged


----


## Version 3.2 (2017-07-24)

### New features

#### Python Console
* Remove it for all operating systems. For an explanation, please see
  [here](https://github.com/spyder-ide/spyder/issues/4524).

#### Main Window
* Add a dialog to quickly view all keyboard shortcuts defined in Spyder.
  It can be accessed in the `Help > Shortcuts Summary` menu or using
  the `Meta+F1` shortcut.
* Add an option to set a custom screen resolution scale factor. This option
  is available in `Preferences > Appearance > Screen resolution`.
* Show Spyder internal errors in a special dialog to ease submitting them
  to Github.

#### Editor
* Add the ability to reorganize tabs by drag and drop.
* Add option to only replace in a selection.
* Add `Ctrl+Up` and `Ctrl+Down` shortcuts to move to the next/previous
  cell, respectively.
* Add `Alt+Enter` shortcut to re-run the last cell.
* Add support to run Cython files from the Editor (i.e. by simply
  pressing `F5`).
* Add syntax highlighting support for Markdown files.
* Add a tab switcher dialog to navigate files in most recently used
  order. This dialog is activated with `Ctrl+Tab` and
  `Ctrl+Shift+Tab` to go in forward or backward order, respectively.
* Make `Shift+Enter` search text backwards in the find/replace
  widget.
* Add `Shift+Del` shortcut to delete lines.
* Add `Ctrl+]` and `Ctrl+[` shortcuts to indent/unindent text,
  respectively.
* Add a *Save copy as* action.
* Add a context menu entry to show the selected file in the operating
  system file explorer.
* Apply smart indentation rules to Python files only. For non-Python
  files, the Editor will preserve the indentation level of the
  previous line.

#### IPython Console
* Several improvements to its debugger:
  - Restore the ability to inspect variables using the Variable
    Explorer.
  - Make plotting work with a new `%plot` magic, but only using
    the `inline` backend (e.g. `%plot plt.plot(range(10))`).
  - Add history browsing with the Up and Down arrow keys.
  - Make the *Clear console* and *Reset* keyboard shortcuts to work.
  - Show plots from the Variable Explorer.
  - Change the current working directory using the Working Directory toolbar.
  - Use `Ctrl+Shift+C` to copy text.
* Add the possibility to run a file in the same (dedicated) console all the
  time.
* Allow to rename consoles by doing a double-click on their tabs and setting
  a new name.
* Make drag and drop of its tabs to work.
* Make the `%cd` magic to change the current working directory of the File
  Explorer and Working Directory toolbar.
* Add menu entries to show environment variables and `sys.path` contents for
  each console.
* Make it use the same color scheme of the Editor.
* Automatically load the Cython extension if Cython is installed.

#### Find in Files
* Add options to search on the current file, project or working directory.
* Display results as search takes place.
* Allow to order results alphabetically.
* Add a spinner as indicator of a search in progress.
* Simplify visualization of results.
* Remove previous search results when a new search takes place.
* Improve file and string encoding to bypass and correct errors
  associated with codification.
* Inform users if search regexp patterns are incorrect.
* Remove unused search options.
* Omit binary files during a search.

#### File Explorer
* Add an option to show the selected file in the operating system
  file explorer.
* Show icons for different file types (pdf, image, video, audio,
  compressed and MS Office files).
* Make it change the current working directory of the active console
  when changing directories on it.

#### Working Directory toolbar
* Rename it to *Current working directory* (it was Global working
  directory).
* Simplify its options to make them more understandable.
* Make it show the working directory of the active IPython console and
  the current directory in the File Explorer.

#### Preferences
* Prevent assignment of `Shift+<single key>` shortcuts because they can't
  be used by Qt applications unless they are hard-coded in the application
  itself.

#### Under the hood
* Use `pycodestyle` package instead of `pep8` to do style analysis.
* Add `pyopengl` as a new dependency to our pip wheels on Linux to
  prevent crashes related to OpenGL in PyQt 5.7+.
* Demand `rope` 0.10.5+ in our wheels because it supports Python 2
  and 3 with the same codebase.

### Bugs fixed

**Issues**

* [Issue 4730](https://github.com/spyder-ide/spyder/issues/4730) - Update translations for 3.2
* [Issue 4725](https://github.com/spyder-ide/spyder/issues/4725) - RuntimeError when closing spyder
* [Issue 4722](https://github.com/spyder-ide/spyder/issues/4722) - Indentation changes after zoom-in
* [Issue 4721](https://github.com/spyder-ide/spyder/issues/4721) - Add tests for dedicated consoles and run config options
* [Issue 4698](https://github.com/spyder-ide/spyder/issues/4698) - Fancy exception handler does not show exception
* [Issue 4694](https://github.com/spyder-ide/spyder/issues/4694) - Disambiguate dedicated IPython consoles
* [Issue 4693](https://github.com/spyder-ide/spyder/issues/4693) - Change "Path" option to "Current working directory" in Find in Files
* [Issue 4692](https://github.com/spyder-ide/spyder/issues/4692) - Make file switcher to have a minimal width
* [Issue 4679](https://github.com/spyder-ide/spyder/issues/4679) - Add IPython to Help > Dependencies
* [Issue 4665](https://github.com/spyder-ide/spyder/issues/4665) - Don't register external plugins if check_compatibility fails
* [Issue 4664](https://github.com/spyder-ide/spyder/issues/4664) - Detect external Spyder kernels
* [Issue 4663](https://github.com/spyder-ide/spyder/issues/4663) - Inspecting Numpy bool arrays in Var. Explorer uses deprecated '-' operator in Numpy
* [Issue 4648](https://github.com/spyder-ide/spyder/issues/4648) - File switcher is changing size when changing from symbols to files
* [Issue 4646](https://github.com/spyder-ide/spyder/issues/4646) - Setting Numpy threshold to nan in console makes the Variable Explorer really slow
* [Issue 4641](https://github.com/spyder-ide/spyder/issues/4641) - Add a check_compatibility method to PluginMixin
* [Issue 4636](https://github.com/spyder-ide/spyder/issues/4636) - Focus doesn't go to the selected entry in file switcher when filtering
* [Issue 4632](https://github.com/spyder-ide/spyder/issues/4632) - Spyder fails to start because of UnicodeDecodeError when creating kernel spec
* [Issue 4619](https://github.com/spyder-ide/spyder/issues/4619) - Scroll down/up scrolls down twice
* [Issue 4615](https://github.com/spyder-ide/spyder/issues/4615) - Lists with None elements don't appear in the Variable Explorer
* [Issue 4611](https://github.com/spyder-ide/spyder/issues/4611) - Goto previous cell behaviour is different than other IDEs
* [Issue 4597](https://github.com/spyder-ide/spyder/issues/4597) - Editors not gaining focus when changing by tab click
* [Issue 4596](https://github.com/spyder-ide/spyder/issues/4596) - Even more improvements to Find in Files
* [Issue 4595](https://github.com/spyder-ide/spyder/issues/4595) - Editor hangs when trying to open Spyder's own CHANGELOG.md file
* [Issue 4592](https://github.com/spyder-ide/spyder/issues/4592) - Add useful commands for working with branches to Contributing Guide
* [Issue 4584](https://github.com/spyder-ide/spyder/issues/4584) - Tips of the introductory tour pop up when window moved or resized
* [Issue 4581](https://github.com/spyder-ide/spyder/issues/4581) - Multiple whitespaces as a separator in variable explorer
* [Issue 4575](https://github.com/spyder-ide/spyder/issues/4575) - Make a unique instance of the file switcher
* [Issue 4553](https://github.com/spyder-ide/spyder/issues/4553) - Spyder hangs after Introduction Tour
* [Issue 4526](https://github.com/spyder-ide/spyder/issues/4526) - Error in syntaxhighlighting of decorators
* [Issue 4524](https://github.com/spyder-ide/spyder/issues/4524) - Remove the Python console
* [Issue 4520](https://github.com/spyder-ide/spyder/issues/4520) - Line is not being highlighted in cells
* [Issue 4496](https://github.com/spyder-ide/spyder/issues/4496) - Shift+Space shortcut doesn't work
* [Issue 4490](https://github.com/spyder-ide/spyder/issues/4490) - More Find in Files improvements
* [Issue 4487](https://github.com/spyder-ide/spyder/issues/4487) - spyder_io_hdf5 plugin not available
* [Issue 4481](https://github.com/spyder-ide/spyder/issues/4481) - Auto-indent Incorrect following line starting with return as part of variable name.
* [Issue 4475](https://github.com/spyder-ide/spyder/issues/4475) - Inserting a line-break in code/comment with parenthesis deletes part of the code/comment
* [Issue 4452](https://github.com/spyder-ide/spyder/issues/4452) - Add more annotation keywords to the Editor (e.g. BUG, OPTIMIZE, etc)
* [Issue 4421](https://github.com/spyder-ide/spyder/issues/4421) - Step-by-step debugging with IPython console doesn't work in 3.1.4.
* [Issue 4418](https://github.com/spyder-ide/spyder/issues/4418) - No option for dedicated IPython console
* [Issue 4411](https://github.com/spyder-ide/spyder/issues/4411) - Part of file switcher always outside of screen when full-screen
* [Issue 4403](https://github.com/spyder-ide/spyder/issues/4403) - Debugging hangs in iPython console
* [Issue 4316](https://github.com/spyder-ide/spyder/issues/4316) - Spyder looks terrible on a very high resolution screen
* [Issue 4307](https://github.com/spyder-ide/spyder/issues/4307) - Additional shortcuts are making the outline explorer to appear
* [Issue 4285](https://github.com/spyder-ide/spyder/issues/4285) - Move to support only Rope 0.10.5+
* [Issue 4282](https://github.com/spyder-ide/spyder/issues/4282) - Create a flaky conda package on conda-forge and move it to the spyder-ide channel
* [Issue 4268](https://github.com/spyder-ide/spyder/issues/4268) - QKeySequence not defined in the arrayeditor
* [Issue 4259](https://github.com/spyder-ide/spyder/issues/4259) - Display file path of file in the Editor title again
* [Issue 4257](https://github.com/spyder-ide/spyder/issues/4257) - Numpy array copy format
* [Issue 4216](https://github.com/spyder-ide/spyder/issues/4216) - Delete unused file formlayout.py
* [Issue 4214](https://github.com/spyder-ide/spyder/issues/4214) - Spyder debugger doesn't terminate
* [Issue 4197](https://github.com/spyder-ide/spyder/issues/4197) - Find in Files not working in 3.1.3
* [Issue 4157](https://github.com/spyder-ide/spyder/issues/4157) - Implement simple indentation fon non-python files
* [Issue 4134](https://github.com/spyder-ide/spyder/issues/4134) - Non-ascii characters not displayed correctly in Find in files
* [Issue 4132](https://github.com/spyder-ide/spyder/issues/4132) - Spyder crashes because of socket initialization errors on Windows
* [Issue 4061](https://github.com/spyder-ide/spyder/issues/4061) - Find occurrences backwards with Shift + Enter (inside find or find/replace mode)
* [Issue 4020](https://github.com/spyder-ide/spyder/issues/4020) - Add "run selection" icon
* [Issue 4016](https://github.com/spyder-ide/spyder/issues/4016) - save file doesn't work on new files unless you change them
* [Issue 4013](https://github.com/spyder-ide/spyder/issues/4013) - Variable Explorer and Editor are not updated when breakpoints are placed in submodules
* [Issue 4010](https://github.com/spyder-ide/spyder/issues/4010) - Pressing Enter in the "Replace with" entry of Find/Replace should replace the currently selected text
* [Issue 3986](https://github.com/spyder-ide/spyder/issues/3986) - Write additional information on 3.1, 3.x and master branches and how to do bugfixes
* [Issue 3959](https://github.com/spyder-ide/spyder/issues/3959) - Shortcut feature request: re-run the previous cell
* [Issue 3945](https://github.com/spyder-ide/spyder/issues/3945) - Cannot change local variables in debug mode
* [Issue 3940](https://github.com/spyder-ide/spyder/issues/3940) - Spyder crashes when pressing ctrl-g in editor to go to definition
* [Issue 3825](https://github.com/spyder-ide/spyder/issues/3825) - Improve icons in the File explorer
* [Issue 3771](https://github.com/spyder-ide/spyder/issues/3771) - Error when hit 'run file' button in debug mode
* [Issue 3711](https://github.com/spyder-ide/spyder/issues/3711) - Variable Explorer is not showing variables in debug mode
* [Issue 3673](https://github.com/spyder-ide/spyder/issues/3673) - Error when trying to view the contents of a binary string in the Variable Explorer for Python 2
* [Issue 3573](https://github.com/spyder-ide/spyder/issues/3573) - Create requirements file to ease introduction to development and testing
* [Issue 3555](https://github.com/spyder-ide/spyder/issues/3555) - Spyder 3 can't inspect values through the variable explorer while debugging
* [Issue 3406](https://github.com/spyder-ide/spyder/issues/3406) - Add Ctrl+] and Ctrl+[ as indent and unindent shortcuts
* [Issue 3405](https://github.com/spyder-ide/spyder/issues/3405) - Cannot create Shift+Del as a shortcut for delete line
* [Issue 3332](https://github.com/spyder-ide/spyder/issues/3332) - Spyder can't start because of problems with OpenGL and PyQt5
* [Issue 3275](https://github.com/spyder-ide/spyder/issues/3275) - Print all keyboard shortcuts to cheatset
* [Issue 3257](https://github.com/spyder-ide/spyder/issues/3257) - The distinction between "working directory for newly opened consoles" and "working directory for current console" is hard to understand
* [Issue 3197](https://github.com/spyder-ide/spyder/issues/3197) - Use pycodestyle instead of pep8
* [Issue 2963](https://github.com/spyder-ide/spyder/issues/2963) - Find in files results disappear when search path loses focus
* [Issue 2850](https://github.com/spyder-ide/spyder/issues/2850) - Adapt the Find in Files so results display is flat, like ACK
* [Issue 2730](https://github.com/spyder-ide/spyder/issues/2730) - Find in files default include and exclude values should be empty!
* [Issue 2628](https://github.com/spyder-ide/spyder/issues/2628) - Show current file in file browser
* [Issue 2238](https://github.com/spyder-ide/spyder/issues/2238) - Preserve size in status bar widgets
* [Issue 2122](https://github.com/spyder-ide/spyder/issues/2122) - QSyntaxHighlighter and Pygments do not properly interoperate, leading to occasional mis-highlighting
* [Issue 2030](https://github.com/spyder-ide/spyder/issues/2030) - Some inconsistencies about the use of "working directories"
* [Issue 2020](https://github.com/spyder-ide/spyder/issues/2020) - ipdb freezes and doesn't allow to debug properly
* [Issue 1977](https://github.com/spyder-ide/spyder/issues/1977) - Error in Variable explorer when modifying nested objects in wrong order
* [Issue 1962](https://github.com/spyder-ide/spyder/issues/1962) - Allow to rename IPython consoles
* [Issue 1833](https://github.com/spyder-ide/spyder/issues/1833) - Provide move to next/previous cell shortcut
* [Issue 1787](https://github.com/spyder-ide/spyder/issues/1787) - Debugger not responding after copying text from IPython Console
* [Issue 1717](https://github.com/spyder-ide/spyder/issues/1717) - Spyder hangs when calling pdb.set_trace() in class definition
* [Issue 1706](https://github.com/spyder-ide/spyder/issues/1706) - Breakpoints on continued lines (with \ character) don't work
* [Issue 1555](https://github.com/spyder-ide/spyder/issues/1555) - Find in Files unusable
* [Issue 1525](https://github.com/spyder-ide/spyder/issues/1525) - Show internal errors in a QMessageBox instead of poping up the Internal Console
* [Issue 1352](https://github.com/spyder-ide/spyder/issues/1352) - Keybord short-cut to switch between last open files
* [Issue 1170](https://github.com/spyder-ide/spyder/issues/1170) - File tabs have unconventional behaviour
* [Issue 1049](https://github.com/spyder-ide/spyder/issues/1049) - Update the cwd name on the working directory toolbar when changing focus between consoles
* [Issue 916](https://github.com/spyder-ide/spyder/issues/916) - Add color schemes to IPython console
* [Issue 564](https://github.com/spyder-ide/spyder/issues/564) - Editor: drag n' drop (movable) tabs
* [Issue 358](https://github.com/spyder-ide/spyder/issues/358) - Find/Replace widget: add option to find/replace in selection only
* [Issue 43](https://github.com/spyder-ide/spyder/issues/43) - Make Ctrl+Tab to navigate between tabs in Most Recently Used (MRU) order

In this release 98 issues were closed

**Pull requests**

* [PR 4791](https://github.com/spyder-ide/spyder/pull/4791) - PR: Update Spanish translations for 3.2
* [PR 4785](https://github.com/spyder-ide/spyder/pull/4785) - PR: Prevent Jedi and Rope to open two previously unopened files simultaneously
* [PR 4782](https://github.com/spyder-ide/spyder/pull/4782) - PR: Update Russian translation for 3.2
* [PR 4765](https://github.com/spyder-ide/spyder/pull/4765) - PR: Prevent potential problems when importing third-party modules
* [PR 4755](https://github.com/spyder-ide/spyder/pull/4755) - PR: Update French translation for 3.2
* [PR 4752](https://github.com/spyder-ide/spyder/pull/4752) - PR: Remove startup options of working directory plugin
* [PR 4750](https://github.com/spyder-ide/spyder/pull/4750) - PR: Don't set pandas.core.common.in_qtconsole anymore
* [PR 4746](https://github.com/spyder-ide/spyder/pull/4746) - PR: Update Japanese translation
* [PR 4737](https://github.com/spyder-ide/spyder/pull/4737) - PR: Add mdw as markdown extension.
* [PR 4729](https://github.com/spyder-ide/spyder/pull/4729) - PR: Add tests for dedicated consoles and runconfig options
* [PR 4726](https://github.com/spyder-ide/spyder/pull/4726) - PR: Fix error when closing window and we ask users if they want to close it or not
* [PR 4723](https://github.com/spyder-ide/spyder/pull/4723) - PR: Update tabwidth when changing zoom in Editor.
* [PR 4719](https://github.com/spyder-ide/spyder/pull/4719) - PR: Fix running in dedicated consoles and other UI fixes
* [PR 4713](https://github.com/spyder-ide/spyder/pull/4713) - PR: Remove all code related to the Python console
* [PR 4711](https://github.com/spyder-ide/spyder/pull/4711) - PR: Show complete exception (not only the traceback) in error QMessageBox.
* [PR 4706](https://github.com/spyder-ide/spyder/pull/4706) - PR: Revert PR #4651
* [PR 4700](https://github.com/spyder-ide/spyder/pull/4700) - PR: Add disambiguation for dedicated IPython consoles
* [PR 4699](https://github.com/spyder-ide/spyder/pull/4699) - PR: Set width of file switcher according to main window width
* [PR 4696](https://github.com/spyder-ide/spyder/pull/4696) - PR: Rename "Path" label to "Current working directory" in Find in Files
* [PR 4691](https://github.com/spyder-ide/spyder/pull/4691) - PR: Implement dedicated IPython consoles
* [PR 4682](https://github.com/spyder-ide/spyder/pull/4682) - PR: Added IPython >= 4.0 as a dependency
* [PR 4670](https://github.com/spyder-ide/spyder/pull/4670) - PR: Add detection of external Spyder kernels
* [PR 4667](https://github.com/spyder-ide/spyder/pull/4667) - PR: Update ArrayEditor to correct deprecated Numpy operator
* [PR 4666](https://github.com/spyder-ide/spyder/pull/4666) - PR: Don't register external plugins if check_compatibility fails
* [PR 4661](https://github.com/spyder-ide/spyder/pull/4661) - PR: Fix fileswitcher size during its setup
* [PR 4651](https://github.com/spyder-ide/spyder/pull/4651) - PR: Avoid comments to generate pep8 warnings
* [PR 4647](https://github.com/spyder-ide/spyder/pull/4647) - PR: Set Numpy threshold every time we run value_to_display
* [PR 4644](https://github.com/spyder-ide/spyder/pull/4644) - PR: Add a check to verify compatibility to plugins
* [PR 4638](https://github.com/spyder-ide/spyder/pull/4638) - PR: Implement "Replace in selection" in the Editor
* [PR 4637](https://github.com/spyder-ide/spyder/pull/4637) - PR: Give focus to the right entry in the file switcher
* [PR 4634](https://github.com/spyder-ide/spyder/pull/4634) - PR: Fix several issues about the Working Directory toolbar
* [PR 4633](https://github.com/spyder-ide/spyder/pull/4633) - PR: Make test_calltip to time out to avoid long waiting times in Appveyor
* [PR 4631](https://github.com/spyder-ide/spyder/pull/4631) - PR: Fix error when calling keyPressEvent in keyReleaseEvent in CodeEditor
* [PR 4630](https://github.com/spyder-ide/spyder/pull/4630) - PR: Move Spyder kernel spec to its own file
* [PR 4628](https://github.com/spyder-ide/spyder/pull/4628) - PR: Backport PR #4627
* [PR 4626](https://github.com/spyder-ide/spyder/pull/4626) - PR: Create a unique instance of the file switcher attached to the main window
* [PR 4621](https://github.com/spyder-ide/spyder/pull/4621) - PR: Add git command for changing base branch to Contributing guide
* [PR 4616](https://github.com/spyder-ide/spyder/pull/4616) - PR: Display collections with None values in the Variable Explorer
* [PR 4613](https://github.com/spyder-ide/spyder/pull/4613) - PR: Move modules test to Circle and all pytest's to Travis
* [PR 4612](https://github.com/spyder-ide/spyder/pull/4612) - PR: Add same behaviour for go to previous cell as the one in Matlab
* [PR 4607](https://github.com/spyder-ide/spyder/pull/4607) - PR: Fix unwanted scrolling when selecting tabs
* [PR 4603](https://github.com/spyder-ide/spyder/pull/4603) - PR: Add break condition to Markdown syntax highlighter loop
* [PR 4602](https://github.com/spyder-ide/spyder/pull/4602) - PR: Update Rope to 0.10.5+
* [PR 4601](https://github.com/spyder-ide/spyder/pull/4601) - PR: Add pyopengl to setup.py to fix errors with some Nvidia/Intel drivers
* [PR 4599](https://github.com/spyder-ide/spyder/pull/4599) - PR: More find in files improvements
* [PR 4598](https://github.com/spyder-ide/spyder/pull/4598) - PR: Add more file type icons to File Explorer
* [PR 4585](https://github.com/spyder-ide/spyder/pull/4585) - PR: Prevent hangs and showing tips after tour
* [PR 4583](https://github.com/spyder-ide/spyder/pull/4583) - PR: Add Whitespace option in the import wizard
* [PR 4579](https://github.com/spyder-ide/spyder/pull/4579) - PR: Return value of fix_indentation_smart in fix_indentation
* [PR 4573](https://github.com/spyder-ide/spyder/pull/4573) - PR: Invert indent shortcuts
* [PR 4567](https://github.com/spyder-ide/spyder/pull/4567) - PR: Add indentation shortcuts and simple indentation for non-Python files
* [PR 4562](https://github.com/spyder-ide/spyder/pull/4562) - PR: Add actions to show sys.path and environment variables contents to the IPython console
* [PR 4561](https://github.com/spyder-ide/spyder/pull/4561) - PR: Use Python module to launch pylint
* [PR 4558](https://github.com/spyder-ide/spyder/pull/4558) - PR: Backport PR 4538
* [PR 4549](https://github.com/spyder-ide/spyder/pull/4549) - PR: Stop loading the Python console
* [PR 4544](https://github.com/spyder-ide/spyder/pull/4544) - PR: Fix font size for the Help plugin
* [PR 4541](https://github.com/spyder-ide/spyder/pull/4541) - PR: Remove connection between the Editor and the Python console
* [PR 4539](https://github.com/spyder-ide/spyder/pull/4539) - PR: Make Shift+Enter search backwards in Find and Replace widget
* [PR 4537](https://github.com/spyder-ide/spyder/pull/4537) - PR: Find in Files style and UI improvements
* [PR 4536](https://github.com/spyder-ide/spyder/pull/4536) - PR: Hide the Python console at startup until we completely remove it
* [PR 4535](https://github.com/spyder-ide/spyder/pull/4535) - PR: Change Editor title to display file path again
* [PR 4534](https://github.com/spyder-ide/spyder/pull/4534) - PR: Force current cell to be before of current line in extra_selections
* [PR 4533](https://github.com/spyder-ide/spyder/pull/4533) - PR: Remove connection between Help and the Python Console
* [PR 4532](https://github.com/spyder-ide/spyder/pull/4532) - PR: Delete extra shortcut for the Outline Explorer
* [PR 4528](https://github.com/spyder-ide/spyder/pull/4528) - PR: Skip test_values_dbg because it times out too much
* [PR 4527](https://github.com/spyder-ide/spyder/pull/4527) - PR: Fix error in decorators regex in syntaxhighlighter.
* [PR 4525](https://github.com/spyder-ide/spyder/pull/4525) - PR: Remove connection between the Variable Explorer and the Python console
* [PR 4523](https://github.com/spyder-ide/spyder/pull/4523) - PR: Add "Save copy as..." to file menu
* [PR 4522](https://github.com/spyder-ide/spyder/pull/4522) - PR: Handle socket creation errors during start up
* [PR 4521](https://github.com/spyder-ide/spyder/pull/4521) - PR: Register spyder_io plugins correctly
* [PR 4511](https://github.com/spyder-ide/spyder/pull/4511) - PR: Fix error in message about reseting Spyder configuration
* [PR 4507](https://github.com/spyder-ide/spyder/pull/4507) - PR: Restore Python 3.6 tests in AppVeyor and add Python 3.5 as well
* [PR 4500](https://github.com/spyder-ide/spyder/pull/4500) - PR: Move some tests and coveralls to Travis
* [PR 4486](https://github.com/spyder-ide/spyder/pull/4486) - PR:  Some indentation fixes
* [PR 4485](https://github.com/spyder-ide/spyder/pull/4485) - PR: Fix indentation error when a line starts with return but it's not a return statement
* [PR 4477](https://github.com/spyder-ide/spyder/pull/4477) - PR: Disable tab with setting when indent chars are spaces.
* [PR 4465](https://github.com/spyder-ide/spyder/pull/4465) - PR: Complete annotation types in Preferences and Source toolbox
* [PR 4456](https://github.com/spyder-ide/spyder/pull/4456) - PR: Add more regular code annotation types
* [PR 4454](https://github.com/spyder-ide/spyder/pull/4454) - PR: Add an option to set a custom HiDPI scale factor
* [PR 4449](https://github.com/spyder-ide/spyder/pull/4449) - PR: Fix a couple of errors in our tests after Pandas 0.20 was released
* [PR 4448](https://github.com/spyder-ide/spyder/pull/4448) - PR: Fix a few typos in the FR locale file
* [PR 4414](https://github.com/spyder-ide/spyder/pull/4414) - PR: Implement go to previous/next cell shortcuts
* [PR 4370](https://github.com/spyder-ide/spyder/pull/4370) - PR: Remove misplaced flags from re.sub() call
* [PR 4354](https://github.com/spyder-ide/spyder/pull/4354) - PR: Delete formlayout.py
* [PR 4352](https://github.com/spyder-ide/spyder/pull/4352) - PR: Add Markdown syntax highlighter.
* [PR 4346](https://github.com/spyder-ide/spyder/pull/4346) - PR: Fix tests in Appveyor
* [PR 4337](https://github.com/spyder-ide/spyder/pull/4337) - PR: Add 'Show in external file explorer' option
* [PR 4302](https://github.com/spyder-ide/spyder/pull/4302) - PR: Add a tab switcher dialog to the Editor
* [PR 4301](https://github.com/spyder-ide/spyder/pull/4301) - PR: Avoid tab scrolling when changing current tab.
* [PR 4273](https://github.com/spyder-ide/spyder/pull/4273) - PR: Add Contributing file
* [PR 4267](https://github.com/spyder-ide/spyder/pull/4267) - PR: Add missing parameter to copy contents with the format defined in array editor
* [PR 4252](https://github.com/spyder-ide/spyder/pull/4252) - PR: Make Cython a test dependency in setup.py
* [PR 4229](https://github.com/spyder-ide/spyder/pull/4229) - PR: Backport PR #4198 - Cython support
* [PR 4218](https://github.com/spyder-ide/spyder/pull/4218) - PR: Change from pep8 to pycodestyle for style analysis
* [PR 4211](https://github.com/spyder-ide/spyder/pull/4211) - PR: Backport PR #4210 - Improve Cython syntax highlighting
* [PR 4202](https://github.com/spyder-ide/spyder/pull/4202) - PR: Fix several IPdb problems and add some improvements to it
* [PR 4201](https://github.com/spyder-ide/spyder/pull/4201) - PR: Remove u function from py3compat
* [PR 4092](https://github.com/spyder-ide/spyder/pull/4092) - PR: Add the possibility to rename IPython consoles
* [PR 4056](https://github.com/spyder-ide/spyder/pull/4056) - PR: Several Find in Files improvements
* [PR 4045](https://github.com/spyder-ide/spyder/pull/4045) - PR: Make status bar widgets to have a fixed width
* [PR 4044](https://github.com/spyder-ide/spyder/pull/4044) - PR: Add "run selection" icon to run toolbar
* [PR 4040](https://github.com/spyder-ide/spyder/pull/4040) - PR: Show internal errors in a QMessageBox
* [PR 4033](https://github.com/spyder-ide/spyder/pull/4033) - PR: Allow new files to be saved before modifing them.
* [PR 4027](https://github.com/spyder-ide/spyder/pull/4027) - PR: Pressing Enter in the "Replace with" entry of Find/Replace replaces the currently selected text
* [PR 4000](https://github.com/spyder-ide/spyder/pull/4000) - PR: Make IPython Console to use the same color scheme of the Editor
* [PR 3974](https://github.com/spyder-ide/spyder/pull/3974) - PR: Added shortcut and menu option to re-run last cell
* [PR 3964](https://github.com/spyder-ide/spyder/pull/3964) - PR: Update load_matlab and add test
* [PR 3946](https://github.com/spyder-ide/spyder/pull/3946) - PR: Make Editor tabs movable
* [PR 3906](https://github.com/spyder-ide/spyder/pull/3906) - PR: Don't show TextEditor if it fails to be initialized
* [PR 3491](https://github.com/spyder-ide/spyder/pull/3491) - PR: Make Pygments to work correctly with QSyntaxHighlighter
* [PR 3464](https://github.com/spyder-ide/spyder/pull/3464) - PR: Add a Shortcuts Summary window

In this release 111 pull requests were merged


----


## Version 3.1.4 (2017-04-24)

### Bugs fixed

**Issues**

* [Issue 4372](https://github.com/spyder-ide/spyder/issues/4372) - Update translations for 3.1.4
* [Issue 4284](https://github.com/spyder-ide/spyder/issues/4284) - The message about the removal of the Python console is also shown on the Internal console
* [Issue 4233](https://github.com/spyder-ide/spyder/issues/4233) - Python console is stealing focus at startup because of message about its removal
* [Issue 4217](https://github.com/spyder-ide/spyder/issues/4217) - "Unable to connect to the internet" problem
* [Issue 4191](https://github.com/spyder-ide/spyder/issues/4191) - Kernel dies and can't report errors because of failure to read stderr file
* [Issue 4174](https://github.com/spyder-ide/spyder/issues/4174) - Add our required packages for testing to setup.py
* [Issue 4173](https://github.com/spyder-ide/spyder/issues/4173) - Add a message in the update dialog about not using pip if Spyder is running under Anaconda/Miniconda
* [Issue 4172](https://github.com/spyder-ide/spyder/issues/4172) - Add a message to the Python console about its removal in Spyder 3.2
* [Issue 4170](https://github.com/spyder-ide/spyder/issues/4170) - IPython console fails to start (Ipython >=6.x)
* [Issue 4161](https://github.com/spyder-ide/spyder/issues/4161) - Create a test for finding print statements in the code
* [Issue 4141](https://github.com/spyder-ide/spyder/issues/4141) - Code completion breaks with  Spyder 3 for modules added through the Python path manager
* [Issue 4003](https://github.com/spyder-ide/spyder/issues/4003) - Debugging seems to break with recent versions of Spyder and tqdm
* [Issue 4002](https://github.com/spyder-ide/spyder/issues/4002) - %matplolib magic command in IPython terminal needs to be executed twice
* [Issue 3985](https://github.com/spyder-ide/spyder/issues/3985) - Add CI testing with Python 3.6
* [Issue 3967](https://github.com/spyder-ide/spyder/issues/3967) - Hide calltip when a matching `)` is written up to the starting point where it's shown
* [Issue 3926](https://github.com/spyder-ide/spyder/issues/3926) - File switcher doesn't leave focus in its last selected file when it looses focus
* [Issue 3823](https://github.com/spyder-ide/spyder/issues/3823) - sig_new_file error when converting notebook to script
* [Issue 3195](https://github.com/spyder-ide/spyder/issues/3195) - Test stand alone widgets in application
* [Issue 1855](https://github.com/spyder-ide/spyder/issues/1855) - can't run doctest - unexpected keyword argument 'nosigint'

In this release 19 issues were closed

**Pull requests**

* [PR 4389](https://github.com/spyder-ide/spyder/pull/4389) - PR: Update Spanish translation
* [PR 4387](https://github.com/spyder-ide/spyder/pull/4387) - PR: Update Japanese translation
* [PR 4375](https://github.com/spyder-ide/spyder/pull/4375) - PR: Update Russian translations
* [PR 4369](https://github.com/spyder-ide/spyder/pull/4369) - PR: Add encoding handling to stderr files in the IPython Console
* [PR 4361](https://github.com/spyder-ide/spyder/pull/4361) - PR: Fix some inline backend issues
* [PR 4353](https://github.com/spyder-ide/spyder/pull/4353) - PR: Test conversion of notebooks to Python files from the Project Explorer
* [PR 4345](https://github.com/spyder-ide/spyder/pull/4345) - PR: Simplify Appveyor installation
* [PR 4342](https://github.com/spyder-ide/spyder/pull/4342) - PR: Decrease test times by moving Qt4 tests to Travis
* [PR 4341](https://github.com/spyder-ide/spyder/pull/4341) - PR: Make jedi_patch.py to work with Jedi 0.10.x versions
* [PR 4321](https://github.com/spyder-ide/spyder/pull/4321) - PR: Add all tests to the distributed package
* [PR 4311](https://github.com/spyder-ide/spyder/pull/4311) - PR: More robust username query
* [PR 4293](https://github.com/spyder-ide/spyder/pull/4293) - PR: Skip and re-run some tests that fail too much
* [PR 4292](https://github.com/spyder-ide/spyder/pull/4292) - PR: Backport PR #4286
* [PR 4290](https://github.com/spyder-ide/spyder/pull/4290) - PR: Add support for other plugins in File Switcher
* [PR 4283](https://github.com/spyder-ide/spyder/pull/4283) - PR: Don't fail while running tests if coveralls fails for whatever reason
* [PR 4263](https://github.com/spyder-ide/spyder/pull/4263) - PR: Add Spyder PYTHONPATH to PluginClient
* [PR 4256](https://github.com/spyder-ide/spyder/pull/4256) - PR: Some test fixes
* [PR 4251](https://github.com/spyder-ide/spyder/pull/4251) - PR: Add pytest-xvfb to our test dependencies
* [PR 4249](https://github.com/spyder-ide/spyder/pull/4249) - PR: Run our tests with PyQt5 wheels on CircleCI
* [PR 4248](https://github.com/spyder-ide/spyder/pull/4248) - PR: Change how to add removal message for the Python console to not make it steal focus
* [PR 4247](https://github.com/spyder-ide/spyder/pull/4247) - PR: Added sigint argument to SpyderPdb constructor
* [PR 4246](https://github.com/spyder-ide/spyder/pull/4246) - PR: Make %matplotlib magic to really change backends
* [PR 4237](https://github.com/spyder-ide/spyder/pull/4237) - PR: Don't show internet conection errors on startup when trying to check for new releases
* [PR 4230](https://github.com/spyder-ide/spyder/pull/4230) - PR: Run tests for PyQt4 and Python 3.6 on CircleCI
* [PR 4226](https://github.com/spyder-ide/spyder/pull/4226) - PR: Generalice previous is_instance test to search other avoided patterns
* [PR 4224](https://github.com/spyder-ide/spyder/pull/4224) - PR: Add warning message about updating Spyder if installed with Anaconda
* [PR 4208](https://github.com/spyder-ide/spyder/pull/4208) - PR: Surround deprecated IPython quick_quide import by try/except block
* [PR 4199](https://github.com/spyder-ide/spyder/pull/4199) - PR: Move all tests to be pytest's
* [PR 4189](https://github.com/spyder-ide/spyder/pull/4189) - PR: Fixup MANIFEST.in to include the changelog
* [PR 4185](https://github.com/spyder-ide/spyder/pull/4185) - PR: Add testing requirements to setup.py
* [PR 4177](https://github.com/spyder-ide/spyder/pull/4177) - PR: Add a message informing the removal of the Python console
* [PR 4123](https://github.com/spyder-ide/spyder/pull/4123) - PR: Add AppStream metainfo file
* [PR 4121](https://github.com/spyder-ide/spyder/pull/4121) - PR: Monkey patch Jedi 0.10.0 for numpydoc
* [PR 4019](https://github.com/spyder-ide/spyder/pull/4019) - PR: Handle errors while debugging code when importing tqdm
* [PR 3984](https://github.com/spyder-ide/spyder/pull/3984) - PR: Correctly hide calltip when matching closing parenthesis
* [PR 3956](https://github.com/spyder-ide/spyder/pull/3956) - PR: Add missing signal to convert notebooks from the project explorer
* [PR 3952](https://github.com/spyder-ide/spyder/pull/3952) - PR: Make File Switcher leave focus on its last selected file when it loses focus

In this release 37 pull requests were merged


----


## Version 3.1.3 (2017-02-20)

### Bugs fixed

**Issues**

* [Issue 4139](https://github.com/spyder-ide/spyder/issues/4139) - Nan value in dataframe editor crash Spyder
* [Issue 4128](https://github.com/spyder-ide/spyder/issues/4128) - Add the version of PyQt in the report of the issue
* [Issue 4127](https://github.com/spyder-ide/spyder/issues/4127) - UnboundLocalError: local variable 'img_path' referenced before assignment
* [Issue 4122](https://github.com/spyder-ide/spyder/issues/4122) - Spyder closes after completing Run settings dialog for a first run.
* [Issue 4096](https://github.com/spyder-ide/spyder/issues/4096) - More issues with autoindentation
* [Issue 4088](https://github.com/spyder-ide/spyder/issues/4088) - Crash when saving an image in the IPython console
* [Issue 4086](https://github.com/spyder-ide/spyder/issues/4086) - Error when launching a new Editor window from the options in the menu.
* [Issue 4085](https://github.com/spyder-ide/spyder/issues/4085) - Crash in "New window" when opening new file.
* [Issue 4076](https://github.com/spyder-ide/spyder/issues/4076) - Add tests to verify that importing .mat files is working
* [Issue 4074](https://github.com/spyder-ide/spyder/issues/4074) - Identation broken after statements with closing parenthesis followed by more code
* [Issue 4072](https://github.com/spyder-ide/spyder/issues/4072) - Case sensitive replace does not respect case
* [Issue 4066](https://github.com/spyder-ide/spyder/issues/4066) - Spyder core dumps if an opened variable in variable explorer gets deleted
* [Issue 4063](https://github.com/spyder-ide/spyder/issues/4063) - Spyder crashes when killing the current process to start a new one
* [Issue 4053](https://github.com/spyder-ide/spyder/issues/4053) - Spyder 3.1.2 cannot connect to kernel as 3.0.2
* [Issue 4052](https://github.com/spyder-ide/spyder/issues/4052) - Maximising current pane fails and hangs Spyder 3.1.x
* [Issue 4050](https://github.com/spyder-ide/spyder/issues/4050) - Wrong binary in Python 3 wheels
* [Issue 4041](https://github.com/spyder-ide/spyder/issues/4041) - Create a way to add tests for the whole app
* [Issue 4037](https://github.com/spyder-ide/spyder/issues/4037) - Tabs as indentation - characters being removed in editor
* [Issue 4030](https://github.com/spyder-ide/spyder/issues/4030) - Inconsistent icon for "Find symbols in file..."
* [Issue 4005](https://github.com/spyder-ide/spyder/issues/4005) - Find in Files not working after 3.1.0 update
* [Issue 3992](https://github.com/spyder-ide/spyder/issues/3992) - Remove unnecessary newlines in run cell
* [Issue 3972](https://github.com/spyder-ide/spyder/issues/3972) - Remove file path from Editor's plugin title
* [Issue 3970](https://github.com/spyder-ide/spyder/issues/3970) - Error when editing markdown
* [Issue 3917](https://github.com/spyder-ide/spyder/issues/3917) - Failed to import data in Variable Explorer on Windows
* [Issue 3476](https://github.com/spyder-ide/spyder/issues/3476) - New breakpoints can't be created in the IPython console

In this release 25 issues were closed

**Pull requests**

* [PR 4175](https://github.com/spyder-ide/spyder/pull/4175) - PR: Set new breakpoints in the IPython console while on a debugging session
* [PR 4171](https://github.com/spyder-ide/spyder/pull/4171) - PR: Re-run flaky tests several times
* [PR 4165](https://github.com/spyder-ide/spyder/pull/4165) - PR: Loading spydata files now uncompress them inside a temp folder
* [PR 4152](https://github.com/spyder-ide/spyder/pull/4152) - PR: Skip matlab import test if SciPy is not installed.
* [PR 4151](https://github.com/spyder-ide/spyder/pull/4151) - PR: Make tests more reliable
* [PR 4148](https://github.com/spyder-ide/spyder/pull/4148) - PR: Use an older Miniconda version for Python 3
* [PR 4144](https://github.com/spyder-ide/spyder/pull/4144) - PR: Some fixes for Find in files
* [PR 4142](https://github.com/spyder-ide/spyder/pull/4142) - PR: Gracefully handle ValueError in DataFrameModel
* [PR 4140](https://github.com/spyder-ide/spyder/pull/4140) - PR: Disable some tests on Windows because they are timing out recurrently
* [PR 4133](https://github.com/spyder-ide/spyder/pull/4133) - PR: Add an initialization value to img_path
* [PR 4130](https://github.com/spyder-ide/spyder/pull/4130) - PR: Correctly stop pytest's on failure
* [PR 4129](https://github.com/spyder-ide/spyder/pull/4129) - PR: Add Qt and PyQt version in the report of the issue
* [PR 4125](https://github.com/spyder-ide/spyder/pull/4125) - PR: Make loading IPython kernels by using their ids to work again
* [PR 4113](https://github.com/spyder-ide/spyder/pull/4113) - PR: Add a validation for the PyQt version used to show a message in the Python console
* [PR 4110](https://github.com/spyder-ide/spyder/pull/4110) - PR: Add more tests for the main window
* [PR 4109](https://github.com/spyder-ide/spyder/pull/4109) - PR: Fix maximize button
* [PR 4106](https://github.com/spyder-ide/spyder/pull/4106) - PR: Prevent some crashes and errors when editing objects in the Variable Explorer
* [PR 4105](https://github.com/spyder-ide/spyder/pull/4105) - PR: Fix hard crash when trying to open files in a new editor window
* [PR 4104](https://github.com/spyder-ide/spyder/pull/4104) - PR: Pin Jedi to 0.9.0
* [PR 4102](https://github.com/spyder-ide/spyder/pull/4102) - PR: Added Matlab files import tests
* [PR 4097](https://github.com/spyder-ide/spyder/pull/4097) - PR: Add a validation for editorstack existence
* [PR 4082](https://github.com/spyder-ide/spyder/pull/4082) - PR: More autoindentation fixes
* [PR 4079](https://github.com/spyder-ide/spyder/pull/4079) - PR: Add a flag to use case sensitive search/replace
* [PR 4069](https://github.com/spyder-ide/spyder/pull/4069) - PR: Fix executable name in Python 3 wheels
* [PR 4043](https://github.com/spyder-ide/spyder/pull/4043) - PR: Use the "at" symbol to represent the symbol finder everywhere
* [PR 4042](https://github.com/spyder-ide/spyder/pull/4042) - PR: Unindent with tabs was deleting some text.
* [PR 4034](https://github.com/spyder-ide/spyder/pull/4034) - PR: Fix error when using TextSH (default highligher)
* [PR 4006](https://github.com/spyder-ide/spyder/pull/4006) - PR: Remove unnecessary new lines when running cells
* [PR 3975](https://github.com/spyder-ide/spyder/pull/3975) - PR: Remove file path from the Editor's plugin title.

In this release 29 pull requests were merged


----


## Version 3.1.2 (2017-01-24)

### Bugs fixed

**Issues**

* [Issue 4025](https://github.com/spyder-ide/spyder/issues/4025) - Error when running cell for the first time in the Editor
* [Issue 4021](https://github.com/spyder-ide/spyder/issues/4021) - Spyder fails to import numpy on first line of a file

In this release 2 issues were closed

**Pull requests**

* [PR 4031](https://github.com/spyder-ide/spyder/pull/4031) - PR: Fix error when running cells because previous_focused_widget is not initialized in main window
* [PR 4029](https://github.com/spyder-ide/spyder/pull/4029) - PR: Fix fix_indent() when editor cursor is on the first line

In this release 2 pull requests were merged


----


## Version 3.1.1 (2017-01-22)

### Bugs fixed

**Issues**

* [Issue 4012](https://github.com/spyder-ide/spyder/issues/4012) - Edit menu items greyed out after update to Spyder 3.1.0
* [Issue 3989](https://github.com/spyder-ide/spyder/issues/3989) - Spyder won't start after upgrade to 3.1.0 due to an error with QRegularExpression
* [Issue 3987](https://github.com/spyder-ide/spyder/issues/3987) - Errors running or importing code because sys.argv is empty

In this release 3 issues were closed

**Pull requests**

* [PR 4022](https://github.com/spyder-ide/spyder/pull/4022) - PR: Edit menu disable error
* [PR 3997](https://github.com/spyder-ide/spyder/pull/3997) - PR: Enclosing quotes of sys.argv clearing instruction are now consistent
* [PR 3994](https://github.com/spyder-ide/spyder/pull/3994) - PR: Use QRegularExpression only for Qt 5.5+

In this release 3 pull requests were merged


----


## Version 3.1 (2017-01-18)

### New features

#### Main Window
* Add Introduction interactive tour to explain the main Spyder
  components (in `Help > Interactive tours`). This tour was
  announced in Spyder 3.0 but deactivated due to an error.

#### Editor
* Add the Solarized Light and Dark color schemes.
* Add support for greedy regular expressions in the find/replace widget
  (only available with PyQt5).
* Improve the use of tabs instead of spaces for indentation.
* Add `Ctrl+Shift+T` shortcut to reopen the last closed file.
* Show completions for Numpy and Matplotlib compiled objects (e.g.
  `np.array` and `plt.figure`)
* Disambiguate tabs in case users open several files with the same
  name.
* Add the shortcut `Ctrl+Alt+P` to open a switcher to select among
  the symbols (functions, methods or classes) present in a file.
  Also add an entry in the `File` menu and toolbar button to show
  this switcher.

#### Variable Explorer
* Add support for the most important numeric types of Numpy (32 and 64
  bits int, float and complex numbers).
* Save format for floats in DataFrame editor.
* Make the index column of DataFrame editor always visible when scrolling
  to right and left.
* Add support for Pandas DatetimeIndex objects.
* Show empty Numpy arrays.

#### IPython Console
* Be able to load kernel json files anywhere in the file system when
  connecting to external kernels.
* Add an option (under `Preferences > Run` and `Run > Configure`) to
  clear all variables present in a console before running a file (it
  runs `%reset -f` in the associated kernel).

#### Profiler
* Show time units (in seconds) spent by each function or method.

#### Settings
* Make all keyboard shortcuts configurable

#### Under the hood
* Add the `--project <path-to-dir>` command line option to load
  projects at startup.
* Add the chardet and numpydoc libraries as new dependencies.

### Bugs fixed

**Issues**

* [Issue 3968](https://github.com/spyder-ide/spyder/issues/3968) - Update translations for 3.1
* [Issue 3962](https://github.com/spyder-ide/spyder/issues/3962) - Update Appveyor Badge for new username spyder-ide
* [Issue 3961](https://github.com/spyder-ide/spyder/issues/3961) - Add devs to the Appveyor account
* [Issue 3949](https://github.com/spyder-ide/spyder/issues/3949) - F9 broken in latest git master
* [Issue 3943](https://github.com/spyder-ide/spyder/issues/3943) - Qtpy 1.2.0 breaks Spyder with Qt4
* [Issue 3932](https://github.com/spyder-ide/spyder/issues/3932) - Add verification for 'text/plain' key in all evaluations of the IPython console
* [Issue 3925](https://github.com/spyder-ide/spyder/issues/3925) - Go-to-line dialog shows a question mark button that does nothing
* [Issue 3901](https://github.com/spyder-ide/spyder/issues/3901) - Incorrect use of "it's" in tutorial
* [Issue 3896](https://github.com/spyder-ide/spyder/issues/3896) - Spyder Variable explorer crashes when double clicking a 2 line DataFrame
* [Issue 3883](https://github.com/spyder-ide/spyder/issues/3883) - Error when executing argparse in IPython console
* [Issue 3875](https://github.com/spyder-ide/spyder/issues/3875) - async and await keywords highlight
* [Issue 3874](https://github.com/spyder-ide/spyder/issues/3874) - Spyder freezes on new project creation
* [Issue 3859](https://github.com/spyder-ide/spyder/issues/3859) - Extra selections should be ordered
* [Issue 3855](https://github.com/spyder-ide/spyder/issues/3855) - Add fuzzy function/class search shortcut
* [Issue 3848](https://github.com/spyder-ide/spyder/issues/3848) -  'self' not defined in DataFrameView.update_section_height()
* [Issue 3843](https://github.com/spyder-ide/spyder/issues/3843) - Spyder shows blank screen because of errors in QtAwesome
* [Issue 3830](https://github.com/spyder-ide/spyder/issues/3830) - Add a command line option to load projects
* [Issue 3818](https://github.com/spyder-ide/spyder/issues/3818) - F1 shortcut is hard-coded
* [Issue 3809](https://github.com/spyder-ide/spyder/issues/3809) - No call tips when 'Automatic insertion of parentheses, braces and brackets' is unchecked
* [Issue 3807](https://github.com/spyder-ide/spyder/issues/3807) - Directory with non-ascii characters throws an error when it's made the working directory on the IPython console
* [Issue 3800](https://github.com/spyder-ide/spyder/issues/3800) - Auto indentation of line following indented block
* [Issue 3794](https://github.com/spyder-ide/spyder/issues/3794) - Create menu separator instead of None
* [Issue 3788](https://github.com/spyder-ide/spyder/issues/3788) - runfile with path containing apostrophe will not work
* [Issue 3772](https://github.com/spyder-ide/spyder/issues/3772) - Configparser error leads to crash of Spyder 3 under Python(x,y)
* [Issue 3764](https://github.com/spyder-ide/spyder/issues/3764) - Problems with default extension in save_as
* [Issue 3763](https://github.com/spyder-ide/spyder/issues/3763) - Replace contents of Find widget with current selection
* [Issue 3759](https://github.com/spyder-ide/spyder/issues/3759) - KeyError: 'execution_count' in IPython console
* [Issue 3756](https://github.com/spyder-ide/spyder/issues/3756) - Verify that the interpreter selected in Main Interpreter is really a Python interpreter
* [Issue 3755](https://github.com/spyder-ide/spyder/issues/3755) - Redefined hotkeys are not displayed in menu
* [Issue 3753](https://github.com/spyder-ide/spyder/issues/3753) - Saving a file is not respecting the encoding detected with chardet
* [Issue 3748](https://github.com/spyder-ide/spyder/issues/3748) - Bad window size in spyder.ini prevents Spyder from showing
* [Issue 3746](https://github.com/spyder-ide/spyder/issues/3746) - Menu view/toolbar has empty contents
* [Issue 3738](https://github.com/spyder-ide/spyder/issues/3738) - Spyder crashes at startup because of errors when importing Sympy
* [Issue 3737](https://github.com/spyder-ide/spyder/issues/3737) - Fast switch between files gives error for unicode files
* [Issue 3731](https://github.com/spyder-ide/spyder/issues/3731) - Correctly report the encoding of files in the Editor using the chardet library
* [Issue 3729](https://github.com/spyder-ide/spyder/issues/3729) - Define tabulation width in term of spaces instead of pixels
* [Issue 3706](https://github.com/spyder-ide/spyder/issues/3706) - Spyder fails to create kernel.json files if jupyter_runtime_dir is not writable
* [Issue 3704](https://github.com/spyder-ide/spyder/issues/3704) - Create a get_words method in introspection utils
* [Issue 3703](https://github.com/spyder-ide/spyder/issues/3703) - Don't replace text in the find widget if there's text there
* [Issue 3700](https://github.com/spyder-ide/spyder/issues/3700) - Wrong autoindentation with lists that contains strings with parenthesis
* [Issue 3680](https://github.com/spyder-ide/spyder/issues/3680) - Autoindentation not working in first line
* [Issue 3678](https://github.com/spyder-ide/spyder/issues/3678) - Weird behaviour of Save as...
* [Issue 3672](https://github.com/spyder-ide/spyder/issues/3672) - Profiler is not showing time units
* [Issue 3670](https://github.com/spyder-ide/spyder/issues/3670) - Dragging and dropping files in the Editor is failing
* [Issue 3651](https://github.com/spyder-ide/spyder/issues/3651) - Improve indentation tests
* [Issue 3648](https://github.com/spyder-ide/spyder/issues/3648) - Edit menu shortcuts are invisible
* [Issue 3638](https://github.com/spyder-ide/spyder/issues/3638) - Variable explorer should display the value of numpy.int64 variables
* [Issue 3631](https://github.com/spyder-ide/spyder/issues/3631) - Edit context menu appears only for utf-8 files in project explorer
* [Issue 3630](https://github.com/spyder-ide/spyder/issues/3630) - Load external kernel json files from anywhere in the file system
* [Issue 3627](https://github.com/spyder-ide/spyder/issues/3627) - Spyder won't start because of "ValueError: unknown locale: UTF-8" in macOS
* [Issue 3608](https://github.com/spyder-ide/spyder/issues/3608) - Syntax highlighting of decorators
* [Issue 3535](https://github.com/spyder-ide/spyder/issues/3535) - Run ciocheck as part of our tests to test code style
* [Issue 3508](https://github.com/spyder-ide/spyder/issues/3508) - Indentation issue using Tabs
* [Issue 3480](https://github.com/spyder-ide/spyder/issues/3480) - Editor doesn't support hanging indentation
* [Issue 3473](https://github.com/spyder-ide/spyder/issues/3473) - Incorrect auto-indentation
* [Issue 3461](https://github.com/spyder-ide/spyder/issues/3461) - Click on outisde of tour should exit tour
* [Issue 3459](https://github.com/spyder-ide/spyder/issues/3459) - Auto-adjust rows height in the Variable Explorer
* [Issue 3458](https://github.com/spyder-ide/spyder/issues/3458) - Feature Request: Clear Console After Kernel Restart
* [Issue 3452](https://github.com/spyder-ide/spyder/issues/3452) - Interactive tour freezes Spyder on Windows
* [Issue 3415](https://github.com/spyder-ide/spyder/issues/3415) - Can't change Run Selection keyboard shortcut from F9 to Cmd + Shift + Enter
* [Issue 3408](https://github.com/spyder-ide/spyder/issues/3408) - Find and replace: Greedy regular expressions
* [Issue 3407](https://github.com/spyder-ide/spyder/issues/3407) - Sitecustomize fails when  current directory has non-ascii chars
* [Issue 3395](https://github.com/spyder-ide/spyder/issues/3395) - Don't hard code the Ctrl+Enter shortcut
* [Issue 3380](https://github.com/spyder-ide/spyder/issues/3380) - DatetimeIndex types are not visible in the Variable Explorer
* [Issue 3322](https://github.com/spyder-ide/spyder/issues/3322) - Spyder crashes with Unicode symbols in editor
* [Issue 3249](https://github.com/spyder-ide/spyder/issues/3249) - Regex is not fully functional when using to find&replace
* [Issue 3160](https://github.com/spyder-ide/spyder/issues/3160) - Disambiguate Editor tabs
* [Issue 3141](https://github.com/spyder-ide/spyder/issues/3141) - Search for backslash (\) sign
* [Issue 3026](https://github.com/spyder-ide/spyder/issues/3026) - File save as: file is unavailable
* [Issue 3005](https://github.com/spyder-ide/spyder/issues/3005) - Getting "Spyder already running" warning when it's not
* [Issue 2927](https://github.com/spyder-ide/spyder/issues/2927) - Editor: "move line up/down" commands broken when moving past a blank line
* [Issue 2907](https://github.com/spyder-ide/spyder/issues/2907) - Modified file flag ('*') disappears from tab in the Editor
* [Issue 2728](https://github.com/spyder-ide/spyder/issues/2728) - Add the default format in dataframe editor to user preferences
* [Issue 2644](https://github.com/spyder-ide/spyder/issues/2644) - Editor: Popup showing function arguments only displayed for 3 seconds
* [Issue 2563](https://github.com/spyder-ide/spyder/issues/2563) - Enhancement: add option to "clear all" variables before running script
* [Issue 2512](https://github.com/spyder-ide/spyder/issues/2512) - Index column of Pandas DataFrame should be visible all the time
* [Issue 2415](https://github.com/spyder-ide/spyder/issues/2415) - Add shortcut to open last closed tab
* [Issue 2392](https://github.com/spyder-ide/spyder/issues/2392) - Current EOL status is displayed incorrectly after changing it
* [Issue 1165](https://github.com/spyder-ide/spyder/issues/1165) - Console tabs are too big because they display the full filename

In this release 79 issues were closed

**Pull requests**

* [PR 3983](https://github.com/spyder-ide/spyder/pull/3983) - Update Spanish translations
* [PR 3982](https://github.com/spyder-ide/spyder/pull/3982) - PR: More fixes for Appveyor
* [PR 3979](https://github.com/spyder-ide/spyder/pull/3979) - Update Brazilian Portuguese translation
* [PR 3971](https://github.com/spyder-ide/spyder/pull/3971) - PR: Don't run pytest tests when running modules_test.bat in Appveyor
* [PR 3963](https://github.com/spyder-ide/spyder/pull/3963) - PR: Update AppVeyor badge in Readme because of move to org account
* [PR 3960](https://github.com/spyder-ide/spyder/pull/3960) - PR: Ping conda-build to 2.1.0 for compatibility with conda 4.3 in Travis and AppVeyor
* [PR 3951](https://github.com/spyder-ide/spyder/pull/3951) - PR: Add default value to clear_variables=False in execute code method
* [PR 3944](https://github.com/spyder-ide/spyder/pull/3944) - PR: Change setResizeMode to setSectionResizeMode
* [PR 3936](https://github.com/spyder-ide/spyder/pull/3936) - PR: Backport PR #3577 - Use inspect.getfullargspec to support annotated functions in the Help pane
* [PR 3935](https://github.com/spyder-ide/spyder/pull/3935) - PR: Add validation for 'text/plain' key in all if clauses of handle_exec_method
* [PR 3933](https://github.com/spyder-ide/spyder/pull/3933) - PR: Catch LookupError when encoding in encode() function
* [PR 3931](https://github.com/spyder-ide/spyder/pull/3931) - PR: Add some tests for indentation with brackets
* [PR 3930](https://github.com/spyder-ide/spyder/pull/3930) - PR: Use encoding.encode function in run_code_analysis.
* [PR 3929](https://github.com/spyder-ide/spyder/pull/3929) - PR:  Save file with original encoding if possible
* [PR 3927](https://github.com/spyder-ide/spyder/pull/3927) - PR: Remove question mark button on the 'Go to line' dialog.
* [PR 3920](https://github.com/spyder-ide/spyder/pull/3920) - PR: Incorrect use of "it's" in tutorial
* [PR 3918](https://github.com/spyder-ide/spyder/pull/3918) - PR: Clean sys.argv in our IPython kernels
* [PR 3898](https://github.com/spyder-ide/spyder/pull/3898) - PR: Get the proper encoding for the header text of Dataframe editor
* [PR 3893](https://github.com/spyder-ide/spyder/pull/3893) - PR: Show calltips when 'Automatic insertion of parentheses, braces and brackets' is unchecked
* [PR 3886](https://github.com/spyder-ide/spyder/pull/3886) - PR: Add a way to handle font errors in QtAwesome
* [PR 3885](https://github.com/spyder-ide/spyder/pull/3885) - PR: Add async and await as keywords for syntax highlighting
* [PR 3884](https://github.com/spyder-ide/spyder/pull/3884) - PR: Hide tour tips dialog when Spyder looses focus
* [PR 3879](https://github.com/spyder-ide/spyder/pull/3879) - PR:  Make Spyder not to freeze on new project creation
* [PR 3878](https://github.com/spyder-ide/spyder/pull/3878) - PR: Add function/class search shortcut, menu and toolbar entries
* [PR 3871](https://github.com/spyder-ide/spyder/pull/3871) - PR: Add option to "clear all" variables before running file
* [PR 3866](https://github.com/spyder-ide/spyder/pull/3866) - PR: Add code to cancel active Appveyor builds in a branch
* [PR 3864](https://github.com/spyder-ide/spyder/pull/3864) - PR: Extra selections is now an ordered dictionary
* [PR 3861](https://github.com/spyder-ide/spyder/pull/3861) - PR: Show kernel initialization errors in the IPython console
* [PR 3854](https://github.com/spyder-ide/spyder/pull/3854) - PR: Add disambiguation functionality to the Python console
* [PR 3853](https://github.com/spyder-ide/spyder/pull/3853) - PR: Move rope_patch.py to utils/introspection
* [PR 3852](https://github.com/spyder-ide/spyder/pull/3852) - PR: Add missing 'self' to DataFrameView.update_section_height
* [PR 3849](https://github.com/spyder-ide/spyder/pull/3849) - PR: Support DatetimeIndex in Variable Explorer
* [PR 3847](https://github.com/spyder-ide/spyder/pull/3847) - PR: Make regex fully functional when using find & replace
* [PR 3845](https://github.com/spyder-ide/spyder/pull/3845) - PR: Install ciocheck from the spyder-ide Anaconda channel
* [PR 3842](https://github.com/spyder-ide/spyder/pull/3842) - PR: Validate that Main Interpreter is really a Python interpreter
* [PR 3840](https://github.com/spyder-ide/spyder/pull/3840) - PR: Make conda respect channel priority in CircleCI
* [PR 3837](https://github.com/spyder-ide/spyder/pull/3837) - PR: Catch UnicodeDecodeError when trying to import matplotlib in sitecustomize.py.
* [PR 3836](https://github.com/spyder-ide/spyder/pull/3836) - PR: Ignore some superflous errors reported by ciocheck
* [PR 3834](https://github.com/spyder-ide/spyder/pull/3834) - PR: Add a command line option to load projects
* [PR 3827](https://github.com/spyder-ide/spyder/pull/3827) - PR: Don't run Pylint with ciocheck
* [PR 3826](https://github.com/spyder-ide/spyder/pull/3826) - PR: Improve auto indentation of line following indented block
* [PR 3822](https://github.com/spyder-ide/spyder/pull/3822) - PR: Make Spyder documentation keyboard shortcut configurable
* [PR 3817](https://github.com/spyder-ide/spyder/pull/3817) - PR: Fix "move line down" behavior in the presence of blank lines
* [PR 3813](https://github.com/spyder-ide/spyder/pull/3813) - PR: Fixed encoding issue when changing cwd in the IPython console
* [PR 3811](https://github.com/spyder-ide/spyder/pull/3811) - PR: Make index column of DataFrame editor always visible
* [PR 3808](https://github.com/spyder-ide/spyder/pull/3808) - Patch Jedi to get completions for compiled objects in Numpy and Matplotlib
* [PR 3806](https://github.com/spyder-ide/spyder/pull/3806) - PR: Added management for toolbars in new Editor windows instances.
* [PR 3805](https://github.com/spyder-ide/spyder/pull/3805) - PR: Backport #3803 - Use CircleCI for testing
* [PR 3802](https://github.com/spyder-ide/spyder/pull/3802) - PR: Add missing menus to show shortcuts for in macOS
* [PR 3796](https://github.com/spyder-ide/spyder/pull/3796) - PR: Make running a file with single quotes on its path not to throw an error on Windows
* [PR 3795](https://github.com/spyder-ide/spyder/pull/3795) - PR: Use a menu separator constant instead of None
* [PR 3793](https://github.com/spyder-ide/spyder/pull/3793) - PR: Closing tour does not freeze Spyder on windows
* [PR 3791](https://github.com/spyder-ide/spyder/pull/3791) - PR: Catch error raised in isbinaryornot when trying to open a directory
* [PR 3787](https://github.com/spyder-ide/spyder/pull/3787) - PR: Redefinition of upper/lower shortcuts was not updated in Edit menu
* [PR 3785](https://github.com/spyder-ide/spyder/pull/3785) - PR: Change file switcher entries to unicode
* [PR 3781](https://github.com/spyder-ide/spyder/pull/3781) - PR: Backport #3574 - Improve style of scientific startup script
* [PR 3776](https://github.com/spyder-ide/spyder/pull/3776) - Improve highlighter decorator regexp
* [PR 3774](https://github.com/spyder-ide/spyder/pull/3774) - PR: Delete references to the 'xy' module.
* [PR 3770](https://github.com/spyder-ide/spyder/pull/3770) - PR: Modified behavior for the Find widget to replace contents with current selection
* [PR 3765](https://github.com/spyder-ide/spyder/pull/3765) - PR: Set Python as default file extension for the "Save As" dialog
* [PR 3760](https://github.com/spyder-ide/spyder/pull/3760) - PR: Define tabulation width in term of spaces instead of pixels
* [PR 3757](https://github.com/spyder-ide/spyder/pull/3757) - PR: Add get_words function to introspection/utils
* [PR 3754](https://github.com/spyder-ide/spyder/pull/3754) - PR: Added validation to window/position config value saved in spyder.ini
* [PR 3752](https://github.com/spyder-ide/spyder/pull/3752) - Backport pull request #3534 (Solarized themes)
* [PR 3749](https://github.com/spyder-ide/spyder/pull/3749) - PR: Fix View/Toolbars menu
* [PR 3742](https://github.com/spyder-ide/spyder/pull/3742) - PR: Use chardet as a fallback for encoding detection
* [PR 3741](https://github.com/spyder-ide/spyder/pull/3741) - PR: Show time units in Profiler
* [PR 3739](https://github.com/spyder-ide/spyder/pull/3739) - Utils: Make is_module_installed to catch all errors when importing a module
* [PR 3733](https://github.com/spyder-ide/spyder/pull/3733) - PR: Fix EOL status after changing it
* [PR 3719](https://github.com/spyder-ide/spyder/pull/3719) - PR: Spyder wont crash if it can not acces jupyter runtime dir
* [PR 3717](https://github.com/spyder-ide/spyder/pull/3717) - PR: Load kernel json files anywhere in the filesystem
* [PR 3715](https://github.com/spyder-ide/spyder/pull/3715) - PR: Add disambiguation functionality for Editor tabs
* [PR 3709](https://github.com/spyder-ide/spyder/pull/3709) - PR: Don't replace text in the find widget if there's text there
* [PR 3707](https://github.com/spyder-ide/spyder/pull/3707) - PR: Disable languages whose translations are outdated
* [PR 3699](https://github.com/spyder-ide/spyder/pull/3699) - PR: Remove logic to delete last dir separator (\, /) in find and replace widget
* [PR 3696](https://github.com/spyder-ide/spyder/pull/3696) - PR: Use QRegularExpression for find and replace (only for PyQt5)
* [PR 3695](https://github.com/spyder-ide/spyder/pull/3695) - PR: Set English as default language if getdefaultlocale gives errors
* [PR 3685](https://github.com/spyder-ide/spyder/pull/3685) - PR: Fixed weird behavior of "Save as"
* [PR 3675](https://github.com/spyder-ide/spyder/pull/3675) - PR: Several fixes for the Variable Explorer
* [PR 3663](https://github.com/spyder-ide/spyder/pull/3663) - PR: Fix some errors of Indentation with tabs
* [PR 3659](https://github.com/spyder-ide/spyder/pull/3659) - PR: Improve spyder.lock pid verfication
* [PR 3654](https://github.com/spyder-ide/spyder/pull/3654) - PR: Add regex to highlight decorators
* [PR 3653](https://github.com/spyder-ide/spyder/pull/3653) - PR: Added support to the principal numeric Numpy types in the Variable Explorer
* [PR 3640](https://github.com/spyder-ide/spyder/pull/3640) - PR: Check if files are text files using the binaryornot package
* [PR 3620](https://github.com/spyder-ide/spyder/pull/3620) - PR: Add Ctrl+Shift+T shortcut to reopen the last closed Editor tab
* [PR 3611](https://github.com/spyder-ide/spyder/pull/3611) - PR: Remember format for floats in DataFrame editor
* [PR 3604](https://github.com/spyder-ide/spyder/pull/3604) - PR: Add ciocheck linter formater tester
* [PR 3498](https://github.com/spyder-ide/spyder/pull/3498) - PR: Change fixed shortcuts for configurable ones
* [PR 3487](https://github.com/spyder-ide/spyder/pull/3487) - PR: Add hanging Indentation to the Editor
* [PR 3296](https://github.com/spyder-ide/spyder/pull/3296) - PR: Don't hide calltip widget with a timer

In this release 91 pull requests were merged


----


## Version 3.0.2 (2016/11/20)

### New features

* Add an option under *Preferences > General* to enable/disable high DPI scaling (disabled by default).
* Add a menu entry in the Projects menu to cleanly delete projects.
* Add the shortcuts `Ctrl+U` and `Ctrl+Shift+U` to turn text into lower/uppercase respectively.

### Bugs fixed

**Issues**

* [Issue 3647](https://github.com/spyder-ide/spyder/issues/3647) - "%reset -s" is giving an error in the IPython console
* [Issue 3618](https://github.com/spyder-ide/spyder/issues/3618) - Removing a project deletes also the files on the disk
* [Issue 3609](https://github.com/spyder-ide/spyder/issues/3609) - New release dialog is un-clickable
* [Issue 3588](https://github.com/spyder-ide/spyder/issues/3588) - Files are opened twice at startup if a project is active
* [Issue 3583](https://github.com/spyder-ide/spyder/issues/3583) - Error when connecting to external kernels
* [Issue 3575](https://github.com/spyder-ide/spyder/issues/3575) - Cannot press Enter after underscore in File Switcher
* [Issue 3564](https://github.com/spyder-ide/spyder/issues/3564) - Error when reloading modules in the IPython Console in Python 2
* [Issue 3561](https://github.com/spyder-ide/spyder/issues/3561) - Working Directory toolbar is not working for IPython Consoles
* [Issue 3553](https://github.com/spyder-ide/spyder/issues/3553) - Spyder fails to launch because of Unicode errors in create_kernel_spec
* [Issue 3522](https://github.com/spyder-ide/spyder/issues/3522) - Dependencies diaog not updating correctly when installing dependencies while spyder is running
* [Issue 3519](https://github.com/spyder-ide/spyder/issues/3519) - Cannot set Maximum Number of Recent Files
* [Issue 3513](https://github.com/spyder-ide/spyder/issues/3513) - Spyder does not free up memory after closing windows with datasets in the Variable explorer
* [Issue 3489](https://github.com/spyder-ide/spyder/issues/3489) - Display problems on systems that use 'display scaling'
* [Issue 3444](https://github.com/spyder-ide/spyder/issues/3444) - Reports of Kernel Death are greatly exagerated
* [Issue 3436](https://github.com/spyder-ide/spyder/issues/3436) - Default file extension should be .py instead of empty
* [Issue 3430](https://github.com/spyder-ide/spyder/issues/3430) - Update translations
* [Issue 3214](https://github.com/spyder-ide/spyder/issues/3214) - Indentation after a line with [] and {} is reset
* [Issue 3127](https://github.com/spyder-ide/spyder/issues/3127) - Spyder fails to launch because of errors in spyder.ini
* [Issue 2159](https://github.com/spyder-ide/spyder/issues/2159) - Built-in 'print' statement is displayed as two different colors depending on indentation
* [Issue 1669](https://github.com/spyder-ide/spyder/issues/1669) - Menu item and shortcut to toggle UPPER and lower case of selected text
* [Issue 1665](https://github.com/spyder-ide/spyder/issues/1665) - sympy shadows matplotlib in ipython console
* [Issue 1373](https://github.com/spyder-ide/spyder/issues/1373) - Editor autoindentation fails after list, dict

In this release 22 issues were closed

**Pull requests**

* [PR 3702](https://github.com/spyder-ide/spyder/pull/3702) - PR: Update French translation
* [PR 3694](https://github.com/spyder-ide/spyder/pull/3694) - Restore icons in the code completion widget
* [PR 3687](https://github.com/spyder-ide/spyder/pull/3687) - Increase time to detect if an IPython kernel is alive
* [PR 3681](https://github.com/spyder-ide/spyder/pull/3681) - Update Spanish translation
* [PR 3679](https://github.com/spyder-ide/spyder/pull/3679) - Update Russian translations
* [PR 3664](https://github.com/spyder-ide/spyder/pull/3664) - Free memory when closing a Variable Explorer editor
* [PR 3661](https://github.com/spyder-ide/spyder/pull/3661) - IPython Console: Fix error when running "%reset -s"
* [PR 3660](https://github.com/spyder-ide/spyder/pull/3660) - IPython Console: Simple fix after PR #3641
* [PR 3642](https://github.com/spyder-ide/spyder/pull/3642) - PR: Fix unclickable update message box
* [PR 3641](https://github.com/spyder-ide/spyder/pull/3641) - PR: Fix error when trying to add a non-ascii module in Python 2 to the UMR blacklist
* [PR 3629](https://github.com/spyder-ide/spyder/pull/3629) - PR: Add shortcut for Upper/Lower functionality
* [PR 3626](https://github.com/spyder-ide/spyder/pull/3626) - PR: Added management for delete operation of a project
* [PR 3622](https://github.com/spyder-ide/spyder/pull/3622) - Fix connection between the IPython Console and the Working Directory toolbar
* [PR 3621](https://github.com/spyder-ide/spyder/pull/3621) - Some corrections after pull request #3580
* [PR 3619](https://github.com/spyder-ide/spyder/pull/3619) - Fix another error when connecting to external kernels
* [PR 3615](https://github.com/spyder-ide/spyder/pull/3615) - PR: Allow underscore to be valid for Enter in File Switcher
* [PR 3599](https://github.com/spyder-ide/spyder/pull/3599) - Load default settings if there is any error in spyder.ini
* [PR 3596](https://github.com/spyder-ide/spyder/pull/3596) - PR: New warning message in IPython console when both pylab and sympy are enabled
* [PR 3590](https://github.com/spyder-ide/spyder/pull/3590) - Fix builtin and keywords highlighting depending on indentation
* [PR 3589](https://github.com/spyder-ide/spyder/pull/3589) - Don't open files saved as part of a project twice at startup
* [PR 3582](https://github.com/spyder-ide/spyder/pull/3582) - PR: Added a verification for the existence of the 'text/plain' key
* [PR 3581](https://github.com/spyder-ide/spyder/pull/3581) - PR: remove spyder/widgets/tests/__init__.py because of error in execution of pytest -rxs
* [PR 3580](https://github.com/spyder-ide/spyder/pull/3580) - PR: Set default file extension in save dialog
* [PR 3576](https://github.com/spyder-ide/spyder/pull/3576) - Fix autoindentation after data structures.
* [PR 3572](https://github.com/spyder-ide/spyder/pull/3572) - PR: Change deprecated funtion QInputDialog.getInteger for QInputDialog.getInt
* [PR 3551](https://github.com/spyder-ide/spyder/pull/3551) - Add option to set/unset dpi scaling for screens that are not high resolution
* [PR 3543](https://github.com/spyder-ide/spyder/pull/3543) - PR: Change of the label in the dependencies dialog

In this release 27 pull requests were merged


----


## Version 3.0.1 (2016-10-19)

### Bugfixes

**Issues**

* [Issue 3528](https://github.com/spyder-ide/spyder/issues/3528) - Cannot see numpy datatypes in variable explorer
* [Issue 3518](https://github.com/spyder-ide/spyder/issues/3518) - Spyder hangs with big numpy structured arrays
* [Issue 3484](https://github.com/spyder-ide/spyder/issues/3484) - Fix menus in macOS
* [Issue 3475](https://github.com/spyder-ide/spyder/issues/3475) - Cannot type left parenthesis in ipdb when automatic Help is turned on
* [Issue 3472](https://github.com/spyder-ide/spyder/issues/3472) - Cannot connect to existing ipython kernel after upgrading to 3.0
* [Issue 3471](https://github.com/spyder-ide/spyder/issues/3471) - "Local variable 'reply' referenced before assignment" on debugger exit
* [Issue 3454](https://github.com/spyder-ide/spyder/issues/3454) - ImportError with create_app.py
* [Issue 3453](https://github.com/spyder-ide/spyder/issues/3453) - Update docs for Projects
* [Issue 3317](https://github.com/spyder-ide/spyder/issues/3317) - Console/Editor lose focus when auto-connected to help
* [Issue 2284](https://github.com/spyder-ide/spyder/issues/2284) - Very slow boot time on Mac app

In this release 10 issues were closed

**Pull requests**

* [PR 3560](https://github.com/spyder-ide/spyder/pull/3560) - Update documentation
* [PR 3550](https://github.com/spyder-ide/spyder/pull/3550) - Prevent WebEngine to steal focus when setting html on the page
* [PR 3548](https://github.com/spyder-ide/spyder/pull/3548) - Fix some ipdb issues
* [PR 3546](https://github.com/spyder-ide/spyder/pull/3546) - Truncate all values shown in the Variable Explorer
* [PR 3544](https://github.com/spyder-ide/spyder/pull/3544) - Don't try to get shape and ndim for objects that are not ndarrays
* [PR 3541](https://github.com/spyder-ide/spyder/pull/3541) - Update create_app.py for Spyder 3.0
* [PR 3540](https://github.com/spyder-ide/spyder/pull/3540) - Fix problems when connecting to external kernels
* [PR 3501](https://github.com/spyder-ide/spyder/pull/3501) - PR: Handle Mac menubar icon bug
* [PR 3499](https://github.com/spyder-ide/spyder/pull/3499) - Testing: Pin conda-build to 2.0.0

In this release 9 pull requests were merged


----


## Version 3.0 (2016-09-24)

### New features

#### Main Window

* The *Object Inspector* pane was renamed to *Help*.
* Add a new icon theme based on FontAwesome.
* Add an *Introduction* interactive tutorial (under the `Help` menu).
* Add new default layouts (Horizontal, Vertical, Matlab and Rstudio), and also the
  possibility to name custom layouts.
* Panes that are tabbed next to each other can now be rearranged by dragging and
  dropping their tabs.
* Check for Spyder updates at startup, and also if you go to the menu entry
  `Help > Check for updates`.
* Add the shortcut `Shift+Alt+R` to restart the application.
* Add an option to warn when exiting the application, under
  `Preferences > General > Interface > Prompt when exiting`.
* Add Portuguese, Russian and Japanese translations.
* Remove light mode

#### Editor

* Add highlighting and code completion to all file types supported by Pygments
  (a syntax highlighting library)
* Use `Ctrl+M` and `Ctrl+Alt+M` to visually create matrices and vectors. It also
  works on the Python and IPython consoles.
* Add a new file switcher inspired by the Sublime Text one, which can be called
  with the `Ctrl+P` shortcut. It can also be used to look for classes, functions
  and methods inside a file, using the `@my_function` syntax.

#### Projects

* A new menu entry called *Projects* was added to the main window with all
  actions related to projects.
* A project now saves the state of open files in the Editor, so that people can
  easily work on different coding efforts at the same time.
* The project's path is added to `PYTHONPATH`, so that Python packages
  developed as part of a project can be easily imported in Spyder consoles.
* The project explorer now shows a file tree view of the current project, as
  other editors and IDEs do (e.g. Sublime Text and VSCode).
* Projects are completely optional and not imposed on users, i.e. users can work
  without creating any project.

#### Settings

* Keyboard shortcuts can now be entered in an easier and more intuitive way.
* Add a menu entry to reset to default settings, under
  `Tools > Reset Spyder to factory defaults`.
* The language used in the main interface can now be changed. The option to
  do it is present in `General > Advanced Settings`.
* `Syntax coloring` now has a preview of the selected theme and it's able to
  change the current theme for all plugins.
* Plain and Rich text fonts for all plugins are now changed in
  `General > Appearance`.
* Add a new entry called `Python interpreter` to allow people to select the
  interpreter used for all Python and IPython consoles (this was before in
  `Console > Advanced settings`).
* Rename the `Console` entry to `Python console`.

#### IPython console

* Drop support for IPython 3.0 and older versions.
* Support the new `qtconsole` package instead.
* Communicate directly with IPython kernels instead of doing it through the
  Python  console.

#### Debugging

* Enter debugging mode if running a file generates errors. This is not activated
  by default but you can do it by going to `Run > Configure > General settings`.

#### Profiler

* Add the ability to save and restore profiler data to compare speed improvements.

#### Working directory toolbar

* Get directory completions by pressing the `Tab` key twice on it.

#### API Changes

##### Major changes

* The `spyderlib` module was renamed to `spyder`
* `spyderplugins` has been removed and its plugins have been assigned to different
  different modules (`spyder_profiler`, `spyder_breakpoints`, etc) still
  distributed with the Spyder package.

##### Minor changes

* `spyderlib.widgets.dicteditor.DictEditor` has been renamed to
  `spyder.widgets.variableexplorer.collectionseditor.CollectionsEditor`.
* `spyderlib/widgets/dicteditorutils.py` has been renamed to
  `spyder/widgets/variableexplorer/utils.py`.
* `spyderlib/widgets/externalshell/namespacebrowser.py` has been moved to
  `spyder/widgets/variableexplorer`.
* `spyderlib/widgets/externalshell/syntaxhighlighters.py` has been moved to
  `spyder/utils/`.
* Variable Explorer editor widgets were moved from `spyderlib.widgets`
  to `spyder.widgets.variableexplorer`:
    * `spyder.widgets.variableexplorer.arrayeditor`
    * `spyder.widgets.variableexplorer.collectionseditor`
    * `spyder.widgets.variableexplorer.objecteditor`
    * `spyder.widgets.variableexplorer.texteditor`
    * `spyder.widgets.variableexplorer.dataframeeditor`
* Modules used for configuration options (e.g. `spyderlib.config`,
  `spyderlib.baseconfig`, etc) were moved to a new namespace called
  `spyder.config`.
* Modules and files related to the application have been moved to
  `spyder.app`.
* `spyderlib/plugins/projectexplorer.py` has been renamed to
  `spyder/plugins/projects.py`
* `spyderlib/widgets/projectexplorer.py` has been renamed to
  `spyder/widgets/projects/explorer.py`
* `spyderlib/plugins/inspector.py` was renamed to
  `spyder/plugins/help.py`.
* `spyderlib/utils/inspector` was renamed to `spyder/utils/help`.
* `spyderlib.qt` was removed.
* `spyderlib/widgets/ipython.py` was broken in several files inside
   `spyder/widgets/ipythonconsole`.
* `spyder/widgets/externalshell/{sitecustomize.py, osx_app_site.py}` were
  moved to `spyder/utils/site`
* `spyder/widgets/externalshell/start_ipython_kernel.py` was moved to
  `spyder/utils/ipython`

#### Under the hood

* Drop support for Python 2.6 and 3.2.
* Support PyQt5.
* Drop official support for PySide. Support for it will have to come from the community.
* Move our settings directory to `HOME/.spyder{-py3}`. Previous location was `HOME/.spyder2{-py3}`
* On Linux we now follow the XDG specification to save our settings, i.e. they are saved in
  `~/.config/spyder{-py3}` or `$XDG_CONFIG_HOME/spyder{-py3}` if `$XDG_CONFIG_HOME` is
  defined.
* Use the new (pythonic) style for signals and slots.
* Test Spyder with the help of Travis and AppVeyor.
* Code completions and help retrieval on the Editor are done asynchronously using a
  client/server architecture based on PyZMQ.
* Spyder now uses the `qtpy` package to be able to work with PyQt4 and PyQt5 seamlessly.

### Bugfixes

**Issues**

* [Issue 3428](https://github.com/spyder-ide/spyder/issues/3428) - runfile is not defined ?
* [Issue 3427](https://github.com/spyder-ide/spyder/issues/3427) - Spyder is opening black DOS windows now

In this release 2 issues were closed

**Pull requests**

* [PR 3451](https://github.com/spyder-ide/spyder/pull/3451) - Update Brazilian Portuguese translation
* [PR 3450](https://github.com/spyder-ide/spyder/pull/3450) - Update Spanish translation
* [PR 3446](https://github.com/spyder-ide/spyder/pull/3446) - Some fixes for Appveyor and Travis
* [PR 3442](https://github.com/spyder-ide/spyder/pull/3442) - Avoid showing cmd consoles when starting IPython kernels on Windows
* [PR 3441](https://github.com/spyder-ide/spyder/pull/3441) - Update Russian translation
* [PR 3439](https://github.com/spyder-ide/spyder/pull/3439) - Fix profiler
* [PR 3438](https://github.com/spyder-ide/spyder/pull/3438) - Add an init file to utils/site so it can be added to our tarballs

In this release 7 pull requests were merged


----


## Version 3.0beta7 (2016-09-16)

### Bugfixes

**Issues**

* [Issue 3419](https://github.com/spyder-ide/spyder/issues/3419) - IPython console: help window hijacks `?` keypress
* [Issue 3403](https://github.com/spyder-ide/spyder/issues/3403) - Error when opening project and cancelling
* [Issue 3354](https://github.com/spyder-ide/spyder/issues/3354) - IPython console run code lines not being saved in preferences
* [Issue 3109](https://github.com/spyder-ide/spyder/issues/3109) - Auto select the only IPython or Python console after startup
* [Issue 3011](https://github.com/spyder-ide/spyder/issues/3011) - Cannot connect to existing kernel with full path specified
* [Issue 2945](https://github.com/spyder-ide/spyder/issues/2945) - Cannot locate kernel json file when connecting to remote ipython kernel
* [Issue 2918](https://github.com/spyder-ide/spyder/issues/2918) - Spyder always switches back to IPython kernel from IPyhton console
* [Issue 2846](https://github.com/spyder-ide/spyder/issues/2846) - Import runfile() produces errors when using a virtualenv
* [Issue 2844](https://github.com/spyder-ide/spyder/issues/2844) - Spyder won't connect to kernel / IPython console after switching to an external interpreter
* [Issue 2790](https://github.com/spyder-ide/spyder/issues/2790) - Make "Ask for confirmation before closing tabs" in IPython console work for all consoles
* [Issue 2696](https://github.com/spyder-ide/spyder/issues/2696) - Enter in the IPython console inserts new line instead of executing current line after kernel restart
* [Issue 1860](https://github.com/spyder-ide/spyder/issues/1860) - Don't show IPython kernels in the Python console by default

In this release 12 issues were closed

**Pull requests**

* [PR 3423](https://github.com/spyder-ide/spyder/pull/3423) - Try to fix plotting on Windows for the Python Console
* [PR 3422](https://github.com/spyder-ide/spyder/pull/3422) - Don't try to use "?" to automatically get help in the IPython console
* [PR 3421](https://github.com/spyder-ide/spyder/pull/3421) - Don't show a message when users press cancel in the "Open project" dialog
* [PR 3420](https://github.com/spyder-ide/spyder/pull/3420) - Skip testing the Spyder kernel for IPython consoles
* [PR 3386](https://github.com/spyder-ide/spyder/pull/3386) - Allow plugins with no dockwidgets
* [PR 3368](https://github.com/spyder-ide/spyder/pull/3368) - Avoid eval() when reading config file
* [PR 2878](https://github.com/spyder-ide/spyder/pull/2878) - PR: Remove IPython kernels from the Python console and connect directly to them

In this release 7 pull requests were merged


----


## Version 3.0beta6 (2016-08-30)

### Bugfixes

**Issues**

* [Issue 3363](https://github.com/spyder-ide/spyder/issues/3363) - Spyder wont start unless file ".spyderproject" is deleted. UnpicklingError
* [Issue 3274](https://github.com/spyder-ide/spyder/issues/3274) - Text not visible in new file switcher in KDE
* [Issue 3211](https://github.com/spyder-ide/spyder/issues/3211) - Edited syntax coloring preferences are not applied or saved
* [Issue 3128](https://github.com/spyder-ide/spyder/issues/3128) - Project Explorer filename filter (minor)
* [Issue 3099](https://github.com/spyder-ide/spyder/issues/3099) - Can existing files be added to a Spyder project?
* [Issue 2887](https://github.com/spyder-ide/spyder/issues/2887) - Make .spyderproject a textfile
* [Issue 2636](https://github.com/spyder-ide/spyder/issues/2636) - Problems with filename extension for saved sessions
* [Issue 2595](https://github.com/spyder-ide/spyder/issues/2595) - Spyder project renames/creates folders by removing first letter of imported directories
* [Issue 2460](https://github.com/spyder-ide/spyder/issues/2460) - Design for Projects in 3.0
* [Issue 1964](https://github.com/spyder-ide/spyder/issues/1964) - Project explorer doesn't refresh its contents
* [Issue 1947](https://github.com/spyder-ide/spyder/issues/1947) - New Project not getting created
* [Issue 1642](https://github.com/spyder-ide/spyder/issues/1642) - Files excluded by the filter list are displayed in the project explorer after start of spyder
* [Issue 1554](https://github.com/spyder-ide/spyder/issues/1554) - Add project's path to our PYTHONPATH so that it can be imported in the console
* [Issue 1320](https://github.com/spyder-ide/spyder/issues/1320) - Reorganize Spyder repository
* [Issue 1317](https://github.com/spyder-ide/spyder/issues/1317) - Make Project Explorer remember state of open files when reopening

In this release 15 issues were closed

**Pull requests**

* [PR 3377](https://github.com/spyder-ide/spyder/pull/3377) - Completely rewrite our support for Projects
* [PR 3370](https://github.com/spyder-ide/spyder/pull/3370) - Some improvements to our CI services
* [PR 3369](https://github.com/spyder-ide/spyder/pull/3369) - Remove some old files and directories
* [PR 3356](https://github.com/spyder-ide/spyder/pull/3356) - Remove icons from tabs for the Editor and IPython Console
* [PR 3355](https://github.com/spyder-ide/spyder/pull/3355) - Some improvements to our file switcher
* [PR 3277](https://github.com/spyder-ide/spyder/pull/3277) - Finish reorganization of the Spyder repo

In this release 6 pull requests were merged


----


## Version 3.0beta5 (2016-08-22)

### Bugfixes

**Issues**

* [Issue 3351](https://github.com/spyder-ide/spyder/issues/3351) - Spyder not opening because of problems with spyder.lock
* [Issue 3327](https://github.com/spyder-ide/spyder/issues/3327) - Drag and drop from OS file explorer is not working
* [Issue 3308](https://github.com/spyder-ide/spyder/issues/3308) - Variable Explorer fails to display DataFrame with categories
* [Issue 3306](https://github.com/spyder-ide/spyder/issues/3306) - Spyder unresponsive, requires forced quit (OS X)
* [Issue 3297](https://github.com/spyder-ide/spyder/issues/3297) - Pressing Ctrl+P twice opens file switcher twice
* [Issue 3293](https://github.com/spyder-ide/spyder/issues/3293) - F9 does not auto advance when it's at the last line
* [Issue 3288](https://github.com/spyder-ide/spyder/issues/3288) - "Quit Spyder" menu entry doesn't work in 3.0.0b4 (OS X 10.11)
* [Issue 3287](https://github.com/spyder-ide/spyder/issues/3287) - Spyder can't open a console because of problems with Beautiful Soup
* [Issue 3282](https://github.com/spyder-ide/spyder/issues/3282) - QApplication is used from QtGui instead of QtWidgets in app/spyder.py
* [Issue 2940](https://github.com/spyder-ide/spyder/issues/2940) - Variable explorer can't show Pandas objects containing timezone aware columns
* [Issue 2629](https://github.com/spyder-ide/spyder/issues/2629) - Use XDG_CONFIG_HOME for config directory on Linux
* [Issue 2465](https://github.com/spyder-ide/spyder/issues/2465) - Images are not rendered by the Help pane on Windows
* [Issue 2119](https://github.com/spyder-ide/spyder/issues/2119) - Spyder doesn't render well on HighDpi screens

In this release 13 issues were closed

**Pull requests**

* [PR 3366](https://github.com/spyder-ide/spyder/pull/3366) - Fix "Quit Spyder" action on OS X
* [PR 3357](https://github.com/spyder-ide/spyder/pull/3357) - Remove lock file as part of --reset
* [PR 3353](https://github.com/spyder-ide/spyder/pull/3353) - Rewrite computation of max and min in dataframe editor
* [PR 3352](https://github.com/spyder-ide/spyder/pull/3352) - Use XDG_CONFIG_HOME to save our settings on Linux
* [PR 3339](https://github.com/spyder-ide/spyder/pull/3339) - Fix dragging and dropping files to the Editor
* [PR 3338](https://github.com/spyder-ide/spyder/pull/3338) - Testing: Use Qt/PyQt 5.6 packages in Travis
* [PR 3336](https://github.com/spyder-ide/spyder/pull/3336) - PR: Update readme and organize badges
* [PR 3333](https://github.com/spyder-ide/spyder/pull/3333) - Enable high DPI scaling on Qt >= 5.6
* [PR 3325](https://github.com/spyder-ide/spyder/pull/3325) - Fix further freezes because of pyzmq
* [PR 3324](https://github.com/spyder-ide/spyder/pull/3324) - Make 'run line' add a blank line if on last line.
* [PR 3319](https://github.com/spyder-ide/spyder/pull/3319) - Test Spyder with Qt 5.6 in AppVeyor
* [PR 3315](https://github.com/spyder-ide/spyder/pull/3315) - Fix showing images in the Help plugin for Windows
* [PR 3313](https://github.com/spyder-ide/spyder/pull/3313) - Toggle file switcher when pressing its keyboard shortcut
* [PR 3312](https://github.com/spyder-ide/spyder/pull/3312) - Fix monkey-patching of QApplication
* [PR 3310](https://github.com/spyder-ide/spyder/pull/3310) - Fix error when Beautiful Soup is installed incorrectly
* [PR 3300](https://github.com/spyder-ide/spyder/pull/3300) - Re-include plugins in setup.py packages
* [PR 3295](https://github.com/spyder-ide/spyder/pull/3295) - PR: Fix/Find in files
* [PR 3294](https://github.com/spyder-ide/spyder/pull/3294) - Add keyboard shortcuts to context menu in editor
* [PR 3285](https://github.com/spyder-ide/spyder/pull/3285) - Japanese translation
* [PR 3273](https://github.com/spyder-ide/spyder/pull/3273) - Testing: Don't use particular tags when installing local conda packages

In this release 20 pull requests were merged


----


## Version 3.0beta4 (2016-07-01)

### Bugfixes

**Issues**

* [Issue 3267](https://github.com/spyder-ide/spyder/issues/3267) - Spyder 3.0 Beta3 fails to start in OS X
* [Issue 3237](https://github.com/spyder-ide/spyder/issues/3237) - Unable to see Float16 in Spyder Variable Explorer
* [Issue 3231](https://github.com/spyder-ide/spyder/issues/3231) - Deprecation warning from IPython 5.0.0b4
* [Issue 3230](https://github.com/spyder-ide/spyder/issues/3230) - Spyder is failing because of wrong qtpy version
* [Issue 3223](https://github.com/spyder-ide/spyder/issues/3223) - Spyder 3.0 Beta 3 crashing or freezing because of zmq problems
* [Issue 3219](https://github.com/spyder-ide/spyder/issues/3219) - Pylint report not jumping to line
* [Issue 3206](https://github.com/spyder-ide/spyder/issues/3206) - Local variable 'backends' referenced before assignment when starting IPython kernel
* [Issue 3188](https://github.com/spyder-ide/spyder/issues/3188) - Spyder crashes after creating a new file from Project/File Explorer
* [Issue 3187](https://github.com/spyder-ide/spyder/issues/3187) - Spyder crashes after deleting a folder in File explorer
* [Issue 3186](https://github.com/spyder-ide/spyder/issues/3186) - "New -> Module..." menu not saving the new module file to the disk
* [Issue 3159](https://github.com/spyder-ide/spyder/issues/3159) - Cannot search text in Help pane
* [Issue 3155](https://github.com/spyder-ide/spyder/issues/3155) - Exception raised when running script in external terminal
* [Issue 3150](https://github.com/spyder-ide/spyder/issues/3150) - Fix external plugins import
* [Issue 3116](https://github.com/spyder-ide/spyder/issues/3116) - Console panel resizing itself as new console tabs are opened
* [Issue 3020](https://github.com/spyder-ide/spyder/issues/3020) - DataFrame editor should first sort up, then down
* [Issue 3010](https://github.com/spyder-ide/spyder/issues/3010) - DataFrame editor should do a stable sort
* [Issue 2995](https://github.com/spyder-ide/spyder/issues/2995) - Variable explorer - Sequence break with wrong mapping
* [Issue 2976](https://github.com/spyder-ide/spyder/issues/2976) - Profiling hangs/freezes Spyder
* [Issue 2915](https://github.com/spyder-ide/spyder/issues/2915) - Problems with changing keyboard shortcuts on Mac
* [Issue 2914](https://github.com/spyder-ide/spyder/issues/2914) - Change keybinding for Replace text (⌘H) in the Editor on Mac
* [Issue 1462](https://github.com/spyder-ide/spyder/issues/1462) - Repeatable segfault while editing HTML file
* [Issue 872](https://github.com/spyder-ide/spyder/issues/872) - Quotes and colons autocompletion

In this release 22 issues were closed

**Pull requests**

* [PR 3271](https://github.com/spyder-ide/spyder/pull/3271) - Fix introspection plugin server restart and timeout
* [PR 3266](https://github.com/spyder-ide/spyder/pull/3266) - Fix searching text in our Web widgets
* [PR 3264](https://github.com/spyder-ide/spyder/pull/3264) - Support float16 values in array editor
* [PR 3261](https://github.com/spyder-ide/spyder/pull/3261) - Fix timeouts in AppVeyor
* [PR 3260](https://github.com/spyder-ide/spyder/pull/3260) - Fix handling of unmatched end-of-HTML-comment.
* [PR 3253](https://github.com/spyder-ide/spyder/pull/3253) - Update minimal required version of several of our dependencies
* [PR 3252](https://github.com/spyder-ide/spyder/pull/3252) - Change Replace shortcut from Ctrl/Cmd+H to Ctrl/Cmd+R
* [PR 3251](https://github.com/spyder-ide/spyder/pull/3251) - Fix problems in AppVeyor because of update in conda-build
* [PR 3248](https://github.com/spyder-ide/spyder/pull/3248) - Fix heartbeat in introspection client/server
* [PR 3240](https://github.com/spyder-ide/spyder/pull/3240) - Improve sorting in dataframe editor
* [PR 3235](https://github.com/spyder-ide/spyder/pull/3235) - Fix several problems with our shortcuts system
* [PR 3234](https://github.com/spyder-ide/spyder/pull/3234) - Create only one instance of IntrospectionManager for the application
* [PR 3233](https://github.com/spyder-ide/spyder/pull/3233) - Fixes for qtpy 1.1.0
* [PR 3228](https://github.com/spyder-ide/spyder/pull/3228) - Fix a bug preventing Spyder to open external file In Mac application
* [PR 3227](https://github.com/spyder-ide/spyder/pull/3227) - Fix keyboard interrupt handling in plugin_server.py
* [PR 3222](https://github.com/spyder-ide/spyder/pull/3222) - Variable explorer: Disregard list1 when sorting list1 against list2
* [PR 3218](https://github.com/spyder-ide/spyder/pull/3218) - PR: Allow empty wdir option to run_python_script_in_terminal
* [PR 3217](https://github.com/spyder-ide/spyder/pull/3217) - Fix icon name in conda windows build script.
* [PR 3210](https://github.com/spyder-ide/spyder/pull/3210) - PR: Follow the Flask plugin model instead of namespace packages
* [PR 3209](https://github.com/spyder-ide/spyder/pull/3209) - Fix undefined `backends` when starting IPython kernel
* [PR 3190](https://github.com/spyder-ide/spyder/pull/3190) - Fix small Explorer bugs about file operations
* [PR 3177](https://github.com/spyder-ide/spyder/pull/3177) - PR: Fix automatic insertion of colon
* [PR 3174](https://github.com/spyder-ide/spyder/pull/3174) - PR: Fix tutorial images on Windows
* [PR 3095](https://github.com/spyder-ide/spyder/pull/3095) - Add some indentation tests
* [PR 3024](https://github.com/spyder-ide/spyder/pull/3024) - Added QMutex protection to write_output in Python consoles to avoid crashes when writing long outputs

In this release 25 pull requests were merged


----


## Version 3.0beta3 (2016-06-06)

### Bugfixes

**Issues**

* [Issue 3145](https://github.com/spyder-ide/spyder/issues/3145) - Spyder doesn't work with Qt 5.6
* [Issue 3129](https://github.com/spyder-ide/spyder/issues/3129) - Is there a way to modify the main window title?
* [Issue 3122](https://github.com/spyder-ide/spyder/issues/3122) - Test array builder widget
* [Issue 3115](https://github.com/spyder-ide/spyder/issues/3115) - Automatically advance to the next line after pressing F9
* [Issue 3113](https://github.com/spyder-ide/spyder/issues/3113) - Cannot change font or font size
* [Issue 3112](https://github.com/spyder-ide/spyder/issues/3112) - Cannot open preferences dialog because of missing PYQT5 constant
* [Issue 3101](https://github.com/spyder-ide/spyder/issues/3101) - Migrate to qtpy
* [Issue 3100](https://github.com/spyder-ide/spyder/issues/3100) - Migrate to qtpy: Remove internal Qt shim used by Spyder.
* [Issue 3084](https://github.com/spyder-ide/spyder/issues/3084) - Variable Explorer generates an error while editing a DataFrame
* [Issue 3078](https://github.com/spyder-ide/spyder/issues/3078) - (I)Python consoles are not setting PyQt API to #2
* [Issue 3073](https://github.com/spyder-ide/spyder/issues/3073) - Spyder doesn't work with QtWebEngine
* [Issue 3061](https://github.com/spyder-ide/spyder/issues/3061) - Different output for internal and external console on Windows
* [Issue 3053](https://github.com/spyder-ide/spyder/issues/3053) - Ctrl+I doesn't seem to work on the editor on current tree on Windows
* [Issue 3041](https://github.com/spyder-ide/spyder/issues/3041) - Spyder crash with "too many files open" message
* [Issue 3033](https://github.com/spyder-ide/spyder/issues/3033) - Create a Remote Procedure Call helper
* [Issue 3022](https://github.com/spyder-ide/spyder/issues/3022) - Turn off module completion fallback
* [Issue 3021](https://github.com/spyder-ide/spyder/issues/3021) - Ghost completions
* [Issue 3013](https://github.com/spyder-ide/spyder/issues/3013) - "Goto definition" stopped working (3.0.0b2 Mac)
* [Issue 3009](https://github.com/spyder-ide/spyder/issues/3009) - Spyder crashes with Python 3.5 and pyqt4 if there are no existing configuration files
* [Issue 3000](https://github.com/spyder-ide/spyder/issues/3000) - Shortcuts: reset console / empty namespace
* [Issue 2986](https://github.com/spyder-ide/spyder/issues/2986) - Add context menu option for %reset
* [Issue 2968](https://github.com/spyder-ide/spyder/issues/2968) - Variable explorer gives an error when copying values
* [Issue 2912](https://github.com/spyder-ide/spyder/issues/2912) - Change keybinding for re-running last script
* [Issue 2910](https://github.com/spyder-ide/spyder/issues/2910) - Automatically set working directory in console
* [Issue 2900](https://github.com/spyder-ide/spyder/issues/2900) - 'Commit' command in File explorer not working in Spyder 3.0.0b2
* [Issue 2877](https://github.com/spyder-ide/spyder/issues/2877) - path module not available in 3.0.0b2
* [Issue 2853](https://github.com/spyder-ide/spyder/issues/2853) - Set all fonts to be one and only one for all plugins in spyder
* [Issue 2835](https://github.com/spyder-ide/spyder/issues/2835) - Control+C should not copy if it has nothing selected on the editor
* [Issue 2724](https://github.com/spyder-ide/spyder/issues/2724) - Editor very slow on Mac Yosemite and El Capitan
* [Issue 2703](https://github.com/spyder-ide/spyder/issues/2703) - File in Project Explorer is being executed(?) on dbl-click
* [Issue 2619](https://github.com/spyder-ide/spyder/issues/2619) - Spyder fails to start on light mode because of check_updates code
* [Issue 2438](https://github.com/spyder-ide/spyder/issues/2438) - Use a single font for all panes
* [Issue 2407](https://github.com/spyder-ide/spyder/issues/2407) - very slow auto completion with pandas
* [Issue 2376](https://github.com/spyder-ide/spyder/issues/2376) - Rename Object Inspector plug-in
* [Issue 2354](https://github.com/spyder-ide/spyder/issues/2354) - Context menu for tabs in editor should allow "close all but this" and "close all to the right"
* [Issue 2268](https://github.com/spyder-ide/spyder/issues/2268) - Start testing with pytest/pytest-qt and coverage for Spyder
* [Issue 1996](https://github.com/spyder-ide/spyder/issues/1996) - Unable to change the interface colors despite saving them in the preferences.
* [Issue 1750](https://github.com/spyder-ide/spyder/issues/1750) - Fail to do automatic indentation after comments
* [Issue 1730](https://github.com/spyder-ide/spyder/issues/1730) - 2 or 4 spaces, not 3
* [Issue 820](https://github.com/spyder-ide/spyder/issues/820) - Move all color-related options into Preferences -> Color scheme

In this release 40 issues were closed

**Pull requests**

* [PR 3204](https://github.com/spyder-ide/spyder/pull/3204) - Make "Spyder 3" the default icon theme
* [PR 3201](https://github.com/spyder-ide/spyder/pull/3201) - Fix AppVeyor failures
* [PR 3198](https://github.com/spyder-ide/spyder/pull/3198) - Support PyQt 5.6
* [PR 3151](https://github.com/spyder-ide/spyder/pull/3151) - More robust plugin initialization in layout
* [PR 3146](https://github.com/spyder-ide/spyder/pull/3146) - Editor: Move to next line in run_selection() if nothing selected
* [PR 3133](https://github.com/spyder-ide/spyder/pull/3133) - Add an option to set window title to the command line
* [PR 3120](https://github.com/spyder-ide/spyder/pull/3120) - PR: Add pytests for array builder, code coverage and quantified code
* [PR 3119](https://github.com/spyder-ide/spyder/pull/3119) - PR: fix Russian translation
* [PR 3105](https://github.com/spyder-ide/spyder/pull/3105) - Remove our internal Qt shim in favor of QtPy
* [PR 3098](https://github.com/spyder-ide/spyder/pull/3098) - PR: Migrate to qtpy
* [PR 3086](https://github.com/spyder-ide/spyder/pull/3086) - Fix interrupt handling on Windows
* [PR 3072](https://github.com/spyder-ide/spyder/pull/3072) - Added Russian translation. Updated POT file
* [PR 3062](https://github.com/spyder-ide/spyder/pull/3062) - Fix consoles encoding in Python 3
* [PR 3060](https://github.com/spyder-ide/spyder/pull/3060) - Start testing with Qt5 on Windows
* [PR 3049](https://github.com/spyder-ide/spyder/pull/3049) - Implement a new Async Server approach based on pyzmq to get completions on the Editor
* [PR 3043](https://github.com/spyder-ide/spyder/pull/3043) - Copying when nothing is selected no longer affects the clipboard.
* [PR 3036](https://github.com/spyder-ide/spyder/pull/3036) - PR: Improve Syntax Coloring preferences page and set color scheme for all plugins there
* [PR 3035](https://github.com/spyder-ide/spyder/pull/3035) - PR: Remove font groups from plugins and move to general preferences
* [PR 3034](https://github.com/spyder-ide/spyder/pull/3034) - Report missing hard dependencies after startup
* [PR 3032](https://github.com/spyder-ide/spyder/pull/3032) - Fix errant completions
* [PR 3029](https://github.com/spyder-ide/spyder/pull/3029) - Add shebang line to default template.py
* [PR 3023](https://github.com/spyder-ide/spyder/pull/3023) - Fix bug in get encoding from "coding" comment line
* [PR 3018](https://github.com/spyder-ide/spyder/pull/3018) - PR: Remove Jedi special code in tests and other minor fixes
* [PR 3015](https://github.com/spyder-ide/spyder/pull/3015) - Editor: Fix code completions when working with bootstrap
* [PR 2997](https://github.com/spyder-ide/spyder/pull/2997) - Added context menu option to reset IPython namespace
* [PR 2974](https://github.com/spyder-ide/spyder/pull/2974) - Center cell icon
* [PR 2973](https://github.com/spyder-ide/spyder/pull/2973) - PR: Show all supported text files when opening files with "File > Open"
* [PR 2971](https://github.com/spyder-ide/spyder/pull/2971) - Make run-cell icons pixel-perfect
* [PR 2957](https://github.com/spyder-ide/spyder/pull/2957) - PR: Select the word under cursor if nothing is selected in Find/Replace
* [PR 2955](https://github.com/spyder-ide/spyder/pull/2955) - PR: Make backspace move to parent directory in file explorer
* [PR 2952](https://github.com/spyder-ide/spyder/pull/2952) - PR: Enable 'Save All' if there are files to be saved
* [PR 2939](https://github.com/spyder-ide/spyder/pull/2939) - PR: More accurate test for text-like files
* [PR 2935](https://github.com/spyder-ide/spyder/pull/2935) - PR: Improving Spyder 3 icon theme
* [PR 2932](https://github.com/spyder-ide/spyder/pull/2932) - PR: Asynchronous introspection for the Editor
* [PR 2930](https://github.com/spyder-ide/spyder/pull/2930) - PR: fix not decorated slots connected to 'triggered' and 'clicked' signals
* [PR 2929](https://github.com/spyder-ide/spyder/pull/2929) - Hide Help plugin if Sphinx is not installed
* [PR 2919](https://github.com/spyder-ide/spyder/pull/2919) - PR: Synchronize entry in Working Directory toolbar with console's current working directory
* [PR 2917](https://github.com/spyder-ide/spyder/pull/2917) - PR: Create a new module called app and move there all modules related to our application
* [PR 2913](https://github.com/spyder-ide/spyder/pull/2913) - Move to use Jupyter imports and remove support for IPython 3
* [PR 2897](https://github.com/spyder-ide/spyder/pull/2897) - Fixed typos (thanks to Benjamin Weis)
* [PR 2890](https://github.com/spyder-ide/spyder/pull/2890) - Added .idea folder to .gitignore for PyCharm users
* [PR 2888](https://github.com/spyder-ide/spyder/pull/2888) - Add 3,5,6,7,8 spaces as options in indentation of the Editor
* [PR 2886](https://github.com/spyder-ide/spyder/pull/2886) - Remove official support for PySide
* [PR 2881](https://github.com/spyder-ide/spyder/pull/2881) - PR: Crashing on shortcut assignment with PyQt5
* [PR 2879](https://github.com/spyder-ide/spyder/pull/2879) - Use PyQt5 as default API
* [PR 2874](https://github.com/spyder-ide/spyder/pull/2874) - Remove light mode
* [PR 2873](https://github.com/spyder-ide/spyder/pull/2873) - Rename Object Inspector plugin to Help
* [PR 2669](https://github.com/spyder-ide/spyder/pull/2669) - PR: Use pygments in introspection
* [PR 2519](https://github.com/spyder-ide/spyder/pull/2519) - Add "close all but this" and "close all to the right" entries to the Editor context menu
* [PR 2184](https://github.com/spyder-ide/spyder/pull/2184) - Prevent cmd.exe shell windows popping up in the background when calling subprocess

In this release 50 pull requests were merged


----


## Version 3.0beta1/beta2 (2015-12-11)

### Bugfixes

**Issues**

* [Issue 2852](https://github.com/spyder-ide/spyder/issues/2852) - Create conda.recipe folder at repo level
* [Issue 2836](https://github.com/spyder-ide/spyder/issues/2836) - Dicom plugin error in bootstrap.py
* [Issue 2795](https://github.com/spyder-ide/spyder/issues/2795) - Option  'Automatic insertion of parentheses, braces and brackets' has issues when un-checked
* [Issue 2792](https://github.com/spyder-ide/spyder/issues/2792) - Changing IPython graphics backend to "Qt" will result in error when using Qt5
* [Issue 2788](https://github.com/spyder-ide/spyder/issues/2788) - Plots are requiring a Ctrl+C in the Python console when using the Qt4 backend on Windows
* [Issue 2779](https://github.com/spyder-ide/spyder/issues/2779) - Bundled rope version is causing Spyder to crash
* [Issue 2766](https://github.com/spyder-ide/spyder/issues/2766) - fix ArrayEditor under PyQt5
* [Issue 2763](https://github.com/spyder-ide/spyder/issues/2763) - Release 3.0 with PyQt5 as default
* [Issue 2756](https://github.com/spyder-ide/spyder/issues/2756) - fallback_plugin tests are failing
* [Issue 2748](https://github.com/spyder-ide/spyder/issues/2748) - Spyder freezes when large MaskedArrays are in memory
* [Issue 2737](https://github.com/spyder-ide/spyder/issues/2737) - UI issues with collapse/expand in the profiler
* [Issue 2736](https://github.com/spyder-ide/spyder/issues/2736) - Profiler config does not carry command line arguments correctly
* [Issue 2685](https://github.com/spyder-ide/spyder/issues/2685) - "unable to connect to the internet" nag screen in 3.0.0b1
* [Issue 2677](https://github.com/spyder-ide/spyder/issues/2677) - Autocomplete for working directory widget
* [Issue 2674](https://github.com/spyder-ide/spyder/issues/2674) - Add run cell (and run cell advance) to right click prompt
* [Issue 2672](https://github.com/spyder-ide/spyder/issues/2672) - Autocomplete does not insert correct word when requested with Ctrl+Space
* [Issue 2612](https://github.com/spyder-ide/spyder/issues/2612) - Fix version detection on the Dependencies dialog
* [Issue 2598](https://github.com/spyder-ide/spyder/issues/2598) - Cannot change between UI tabs on OSX
* [Issue 2597](https://github.com/spyder-ide/spyder/issues/2597) - new icon theme broken on OSX
* [Issue 2581](https://github.com/spyder-ide/spyder/issues/2581) - Autoparens appear when autocompleting in the import section
* [Issue 2574](https://github.com/spyder-ide/spyder/issues/2574) - Create wheels for Spyder
* [Issue 2573](https://github.com/spyder-ide/spyder/issues/2573) - Spyder is crashing with PyQt5.5.0 on Windows / Python 3.4
* [Issue 2569](https://github.com/spyder-ide/spyder/issues/2569) - Spyper cannot read yahoo stock price
* [Issue 2555](https://github.com/spyder-ide/spyder/issues/2555) - Main window is bigger than screen size, after a first start in Mac and KDE
* [Issue 2527](https://github.com/spyder-ide/spyder/issues/2527) - More suggestions for the "Spyder 3" icon theme
* [Issue 2481](https://github.com/spyder-ide/spyder/issues/2481) - Align boxes for different lines in preferences dialog
* [Issue 2471](https://github.com/spyder-ide/spyder/issues/2471) - Matplotlib Gtk backend is broken in Python consoles
* [Issue 2439](https://github.com/spyder-ide/spyder/issues/2439) - Rope not autocompleting when *args or **kwargs are present in function definition
* [Issue 2436](https://github.com/spyder-ide/spyder/issues/2436) - Background coloring in array view (variable explorer) doesn't work if array contains nans
* [Issue 2433](https://github.com/spyder-ide/spyder/issues/2433) - Argument cannot work in Spyder 2.3.4
* [Issue 2427](https://github.com/spyder-ide/spyder/issues/2427) - can't find pylint installed as python3-pylint
* [Issue 2422](https://github.com/spyder-ide/spyder/issues/2422) - Selecting line numbers from the side areas with pointer potentially buggy?
* [Issue 2420](https://github.com/spyder-ide/spyder/issues/2420) - Zoom should not be associated with a file
* [Issue 2408](https://github.com/spyder-ide/spyder/issues/2408) - Exception on autocomplete in the internal console
* [Issue 2404](https://github.com/spyder-ide/spyder/issues/2404) - Code completion raise exception when the editor widget is floating
* [Issue 2401](https://github.com/spyder-ide/spyder/issues/2401) - Unable to reset settings from the Main Window
* [Issue 2395](https://github.com/spyder-ide/spyder/issues/2395) - Can not show exception information correctly in IPython Console
* [Issue 2390](https://github.com/spyder-ide/spyder/issues/2390) - Code completion is failing on Python consoles
* [Issue 2389](https://github.com/spyder-ide/spyder/issues/2389) - Move helper widgets to helperwidgets.py
* [Issue 2386](https://github.com/spyder-ide/spyder/issues/2386) - Error in Python console on startup
* [Issue 2385](https://github.com/spyder-ide/spyder/issues/2385) - Can't report issue on master with PyQt5
* [Issue 2381](https://github.com/spyder-ide/spyder/issues/2381) - Disable post-crash popup in dev mode
* [Issue 2379](https://github.com/spyder-ide/spyder/issues/2379) - Spyder can't switch lines of code when those two lines are the last two in the file
* [Issue 2352](https://github.com/spyder-ide/spyder/issues/2352) - Some issues with code completion in the Editor
* [Issue 2348](https://github.com/spyder-ide/spyder/issues/2348) - Combobox to choose Matplotlib backend
* [Issue 2347](https://github.com/spyder-ide/spyder/issues/2347) - Add shortcuts to move to next/previous line in the Editor
* [Issue 2340](https://github.com/spyder-ide/spyder/issues/2340) - SublimeText-like file switching widget
* [Issue 2317](https://github.com/spyder-ide/spyder/issues/2317) - Object Inspector Text on Mac OS X is Misleading
* [Issue 2313](https://github.com/spyder-ide/spyder/issues/2313) - 'NoneType' is not iterable in introspection/fallback_plugin.py
* [Issue 2308](https://github.com/spyder-ide/spyder/issues/2308) - Python console stops running after first execution
* [Issue 2307](https://github.com/spyder-ide/spyder/issues/2307) - Enhancement: Add check for updates and allow for autoupdating inside spyder
* [Issue 2306](https://github.com/spyder-ide/spyder/issues/2306) - Enhancement: Add restart functionality to spyder.
* [Issue 2305](https://github.com/spyder-ide/spyder/issues/2305) - Profiling error
* [Issue 2300](https://github.com/spyder-ide/spyder/issues/2300) - Unable to start my Spyder
* [Issue 2289](https://github.com/spyder-ide/spyder/issues/2289) - Disable icons in menus on Mac OS X
* [Issue 2282](https://github.com/spyder-ide/spyder/issues/2282) - Incorrect setting of Qt API n°2
* [Issue 2277](https://github.com/spyder-ide/spyder/issues/2277) - "TypeError: decoding Unicode is not supported" when debugging
* [Issue 2275](https://github.com/spyder-ide/spyder/issues/2275) - Can not report issue from dev version
* [Issue 2274](https://github.com/spyder-ide/spyder/issues/2274) - Can not start spyder under python2 because guidata doesn't support PyQt5
* [Issue 2267](https://github.com/spyder-ide/spyder/issues/2267) - Move Conda Package Manager to its own repo
* [Issue 2251](https://github.com/spyder-ide/spyder/issues/2251) - Spyder crashing on very long output
* [Issue 2250](https://github.com/spyder-ide/spyder/issues/2250) - IPython 3.0 is showing a deprecation warning in the Internal Console
* [Issue 2249](https://github.com/spyder-ide/spyder/issues/2249) - TypeError: 'method' object is not connected: self.timer.timeout.disconnect(self.show_time)
* [Issue 2248](https://github.com/spyder-ide/spyder/issues/2248) - ImportError: No module named 'conda_api_q'
* [Issue 2235](https://github.com/spyder-ide/spyder/issues/2235) - Error when running Spyder with Python 2 and PyQt5
* [Issue 2231](https://github.com/spyder-ide/spyder/issues/2231) - Master has issues when plotting graphs through matplotlib in Python consoles
* [Issue 2213](https://github.com/spyder-ide/spyder/issues/2213) - Show absolute and relative (to the current file in Editor) images in Object inspector
* [Issue 2210](https://github.com/spyder-ide/spyder/issues/2210) - Icons as vector graphics to support retina displays
* [Issue 2204](https://github.com/spyder-ide/spyder/issues/2204) - Windows: something is preventing "File" and "Edit" menus being clicked
* [Issue 2141](https://github.com/spyder-ide/spyder/issues/2141) - File list management broken in master
* [Issue 2125](https://github.com/spyder-ide/spyder/issues/2125) - Removal of keyboard shortcut causes errors to be thrown
* [Issue 2117](https://github.com/spyder-ide/spyder/issues/2117) - Add missing methods to SpyderPluginMixin
* [Issue 2096](https://github.com/spyder-ide/spyder/issues/2096) - Feature Request: Add option to lock window/pane layout
* [Issue 2083](https://github.com/spyder-ide/spyder/issues/2083) - Spyder stopped working with Qt4.6
* [Issue 2061](https://github.com/spyder-ide/spyder/issues/2061) - Spyder cannot load matplotlib if the latter tries to use PyQt5
* [Issue 2047](https://github.com/spyder-ide/spyder/issues/2047) - Provide Keyboard Shortcut for Save As
* [Issue 2024](https://github.com/spyder-ide/spyder/issues/2024) - Add folders with subfolders with path manager
* [Issue 2010](https://github.com/spyder-ide/spyder/issues/2010) - runfile arguments with spaces
* [Issue 2001](https://github.com/spyder-ide/spyder/issues/2001) - inserting line break in code line does not align well on next line
* [Issue 1966](https://github.com/spyder-ide/spyder/issues/1966) - Add fallback syntax highlighter using Pygments autodetection
* [Issue 1940](https://github.com/spyder-ide/spyder/issues/1940) - Add search functionality for keyboard shortcuts
* [Issue 1924](https://github.com/spyder-ide/spyder/issues/1924) - Add interactive tutorials
* [Issue 1923](https://github.com/spyder-ide/spyder/issues/1923) - Bug when changing output and input prompts in the IPython console
* [Issue 1876](https://github.com/spyder-ide/spyder/issues/1876) - Editor: Move suggested completion item to top of window
* [Issue 1850](https://github.com/spyder-ide/spyder/issues/1850) - Calltip traceback while using Jedi
* [Issue 1761](https://github.com/spyder-ide/spyder/issues/1761) - F5 (run) saves editor file, but F10 (profile) does not
* [Issue 1749](https://github.com/spyder-ide/spyder/issues/1749) - Cycle tabs via Ctrl-PageUp/PageDown
* [Issue 1394](https://github.com/spyder-ide/spyder/issues/1394) - Let the user select his/her own localization settings
* [Issue 1387](https://github.com/spyder-ide/spyder/issues/1387) - Integrate post mortem debugging (like IEP)
* [Issue 1335](https://github.com/spyder-ide/spyder/issues/1335) - Add option for naming the custom layouts
* [Issue 1239](https://github.com/spyder-ide/spyder/issues/1239) - Include a package manager
* [Issue 1221](https://github.com/spyder-ide/spyder/issues/1221) - Spyder doesn't use Native OS X fullscreen
* [Issue 1212](https://github.com/spyder-ide/spyder/issues/1212) - Add keyboard shortcuts for beginning of line and end of line
* [Issue 1001](https://github.com/spyder-ide/spyder/issues/1001) - How to change UI language
* [Issue 729](https://github.com/spyder-ide/spyder/issues/729) - Enable assigning shortcuts for cursor navigation on the Editor
* [Issue 494](https://github.com/spyder-ide/spyder/issues/494) - Need to hit Enter to change a keyboard shortcut (unintuitive)
* [Issue 478](https://github.com/spyder-ide/spyder/issues/478) - Slash does not work as keyboard shortcut key
* [Issue 404](https://github.com/spyder-ide/spyder/issues/404) - Spyder becomes unresponsive while loading a large source file
* [Issue 195](https://github.com/spyder-ide/spyder/issues/195) - Backspace (\b) and carriage return (\r) characters are not printed correctly in the console

In this release 99 issues were closed

**Pull requests**

* [PR 2847](https://github.com/spyder-ide/spyder/pull/2847) - Use High dpi pixmaps
* [PR 2838](https://github.com/spyder-ide/spyder/pull/2838) - Import spyplugins only if there's a valid spec/module
* [PR 2831](https://github.com/spyder-ide/spyder/pull/2831) - Remove external dependencies
* [PR 2826](https://github.com/spyder-ide/spyder/pull/2826) - Remove imports from widgets/__init__ because they are making Spyder crash
* [PR 2825](https://github.com/spyder-ide/spyder/pull/2825) - Fix tests in Travis after a recent update of conda-build
* [PR 2813](https://github.com/spyder-ide/spyder/pull/2813) - Test spyplugins widgets on AppVeyor and other minor fixes
* [PR 2810](https://github.com/spyder-ide/spyder/pull/2810) - Restore the insertion of the "(" character when parameter close_parentheses_enabled is False
* [PR 2808](https://github.com/spyder-ide/spyder/pull/2808) - Make F10 (profile) save the current file before running
* [PR 2800](https://github.com/spyder-ide/spyder/pull/2800) - Fix problems in AppVeyor and Travis
* [PR 2786](https://github.com/spyder-ide/spyder/pull/2786) - Move the spyder script to the right place if it isn't present in the site Scripts directory
* [PR 2784](https://github.com/spyder-ide/spyder/pull/2784) - Fix runfile argument parsing error by using shlex
* [PR 2778](https://github.com/spyder-ide/spyder/pull/2778) - Use Appveyor to test on Windows
* [PR 2777](https://github.com/spyder-ide/spyder/pull/2777) - Fix important errors in Travis
* [PR 2776](https://github.com/spyder-ide/spyder/pull/2776) - Rename spyderlib.widgets.editors to spyderlib.widgets.variableexplorer
* [PR 2774](https://github.com/spyder-ide/spyder/pull/2774) - Add dependencies to pip
* [PR 2767](https://github.com/spyder-ide/spyder/pull/2767) - Fix arrayeditor import error in PyQt5
* [PR 2762](https://github.com/spyder-ide/spyder/pull/2762) - Start testing with PyQt5
* [PR 2761](https://github.com/spyder-ide/spyder/pull/2761) - Test Spyder with Python 3.5
* [PR 2758](https://github.com/spyder-ide/spyder/pull/2758) - Fix failing fallback_plugin tests and add to modules_test
* [PR 2752](https://github.com/spyder-ide/spyder/pull/2752) - Test widgets in Travis
* [PR 2750](https://github.com/spyder-ide/spyder/pull/2750) - Improved copying and selection behaviour of array editor
* [PR 2747](https://github.com/spyder-ide/spyder/pull/2747) - Don't use bootstrap on Travis
* [PR 2746](https://github.com/spyder-ide/spyder/pull/2746) - Move Variable Explorer widgets and utility libraries to its own namespace: widgets/varexp
* [PR 2741](https://github.com/spyder-ide/spyder/pull/2741) - Get rid of the last shim warning with IPython/Jupyter 4
* [PR 2740](https://github.com/spyder-ide/spyder/pull/2740) - Read correctly the run config for profiling
* [PR 2739](https://github.com/spyder-ide/spyder/pull/2739) - Fix collapse/expand buttons in profiler widget
* [PR 2718](https://github.com/spyder-ide/spyder/pull/2718) - Fix issue with qtawesome fonts not rendering on OS X
* [PR 2702](https://github.com/spyder-ide/spyder/pull/2702) - Fix tabbar issue in OSX
* [PR 2692](https://github.com/spyder-ide/spyder/pull/2692) - Add tab completions for PathCombobox
* [PR 2691](https://github.com/spyder-ide/spyder/pull/2691) - Fixed PyQt5 detection without QT_API env var
* [PR 2687](https://github.com/spyder-ide/spyder/pull/2687) - Opt out of certificate verification on check for updates
* [PR 2673](https://github.com/spyder-ide/spyder/pull/2673) - Fix single item completion
* [PR 2671](https://github.com/spyder-ide/spyder/pull/2671) - Test module importing on Travis
* [PR 2602](https://github.com/spyder-ide/spyder/pull/2602) - Revert auto open parens on completion
* [PR 2594](https://github.com/spyder-ide/spyder/pull/2594) - Import HelperToolButton from helperwidgets.py in arraybuilder
* [PR 2590](https://github.com/spyder-ide/spyder/pull/2590) - Redesign file switcher (a la Sublime Text)
* [PR 2587](https://github.com/spyder-ide/spyder/pull/2587) - Homogenize History Pane UI
* [PR 2585](https://github.com/spyder-ide/spyder/pull/2585) - Homogenize Object inspector UI
* [PR 2584](https://github.com/spyder-ide/spyder/pull/2584) - Homogenize variable explorer UI
* [PR 2583](https://github.com/spyder-ide/spyder/pull/2583) - Homogenize file explorer UI
* [PR 2582](https://github.com/spyder-ide/spyder/pull/2582) - Move MessageCheckBox widget from workers to helperwidgets.py
* [PR 2577](https://github.com/spyder-ide/spyder/pull/2577) - Make "copy" work better with numpy arrays
* [PR 2576](https://github.com/spyder-ide/spyder/pull/2576) - Fix issues in Python3/PyQt5.5
* [PR 2575](https://github.com/spyder-ide/spyder/pull/2575) - Reorganize repo: grouped config files inside spyderlib/config
* [PR 2565](https://github.com/spyder-ide/spyder/pull/2565) - Change plugins directory to spyplugins and make it a namespace package
* [PR 2559](https://github.com/spyder-ide/spyder/pull/2559) - Fix default layout dockwidget on first Spyder start
* [PR 2547](https://github.com/spyder-ide/spyder/pull/2547) - Fix resetting IPython custom exception hook
* [PR 2537](https://github.com/spyder-ide/spyder/pull/2537) - fix misspelled extension
* [PR 2533](https://github.com/spyder-ide/spyder/pull/2533) - Spyder 3 icon theme changes
* [PR 2523](https://github.com/spyder-ide/spyder/pull/2523) - Keyboard shortcut editor enhancements
* [PR 2511](https://github.com/spyder-ide/spyder/pull/2511) - New Spyder 3 icons for run-cell and run-cell inplace
* [PR 2504](https://github.com/spyder-ide/spyder/pull/2504) - Update Spyder 3 icon theme: vertical alignment of maximize/unmaximize
* [PR 2501](https://github.com/spyder-ide/spyder/pull/2501) - Make blank space less apparent.
* [PR 2492](https://github.com/spyder-ide/spyder/pull/2492) - proof read tutorial.rst and removed several typos
* [PR 2489](https://github.com/spyder-ide/spyder/pull/2489) - Remove warning message associated to language on Linux
* [PR 2488](https://github.com/spyder-ide/spyder/pull/2488) - Improve appearance of options inside the preferences dialog
* [PR 2480](https://github.com/spyder-ide/spyder/pull/2480) - Enable standard icons
* [PR 2457](https://github.com/spyder-ide/spyder/pull/2457) - Return default language in case no locale is found
* [PR 2445](https://github.com/spyder-ide/spyder/pull/2445) - Fix handling of jedi completions for jedi 0.9
* [PR 2426](https://github.com/spyder-ide/spyder/pull/2426) - Add option to toggle toolbars visibility
* [PR 2425](https://github.com/spyder-ide/spyder/pull/2425) - Add option in preferences to show/hide status bar
* [PR 2423](https://github.com/spyder-ide/spyder/pull/2423) - Reset spyder and restart from within running application
* [PR 2412](https://github.com/spyder-ide/spyder/pull/2412) - Open preferences dialog even if a plugin raises errors
* [PR 2410](https://github.com/spyder-ide/spyder/pull/2410) - Print git revision and branch in bootstrap.py instead of mercurial
* [PR 2409](https://github.com/spyder-ide/spyder/pull/2409) - Fix error when trying an empty complete in internal console
* [PR 2405](https://github.com/spyder-ide/spyder/pull/2405) - Avoid exception when the Editor is floating and users are trying to get completions
* [PR 2391](https://github.com/spyder-ide/spyder/pull/2391) - Fix #2390, completions in python console
* [PR 2382](https://github.com/spyder-ide/spyder/pull/2382) - Allow the last two lines in a file to be switched
* [PR 2371](https://github.com/spyder-ide/spyder/pull/2371) - Automatically add parens for function completions
* [PR 2369](https://github.com/spyder-ide/spyder/pull/2369) - Add drag support for dockwidgets sharing same position
* [PR 2367](https://github.com/spyder-ide/spyder/pull/2367) - New KeySequence Editor for Keyboard Shortcut Preferences
* [PR 2366](https://github.com/spyder-ide/spyder/pull/2366) - Update Path.py to version 7.3
* [PR 2357](https://github.com/spyder-ide/spyder/pull/2357) - Fix some completion issues on the Editor (issue #2352)
* [PR 2349](https://github.com/spyder-ide/spyder/pull/2349) - Add support for language selection in preferences
* [PR 2345](https://github.com/spyder-ide/spyder/pull/2345) - Add lock/unlock option for panes
* [PR 2337](https://github.com/spyder-ide/spyder/pull/2337) - Add Icons to Completions
* [PR 2331](https://github.com/spyder-ide/spyder/pull/2331) - Finish Introduction tour
* [PR 2328](https://github.com/spyder-ide/spyder/pull/2328) - README.md running from source is a killer feature
* [PR 2322](https://github.com/spyder-ide/spyder/pull/2322) - Make completions scroll to top of list
* [PR 2321](https://github.com/spyder-ide/spyder/pull/2321) - Add a check for updates method
* [PR 2319](https://github.com/spyder-ide/spyder/pull/2319) - Handle a connection abort error on shutdown
* [PR 2318](https://github.com/spyder-ide/spyder/pull/2318) - Fix Object inspector message for OSX
* [PR 2316](https://github.com/spyder-ide/spyder/pull/2316) - Use empty string instead of None for fallback.  Fixes #2313.
* [PR 2312](https://github.com/spyder-ide/spyder/pull/2312) - Fixes #2306: Add a restart method
* [PR 2309](https://github.com/spyder-ide/spyder/pull/2309) - Replace obsolete setTextColor method by setForeground in qtreewidgetitem
* [PR 2301](https://github.com/spyder-ide/spyder/pull/2301) - Run selection enabled even with empty selection
* [PR 2295](https://github.com/spyder-ide/spyder/pull/2295) - Update CHANGELOG.md
* [PR 2291](https://github.com/spyder-ide/spyder/pull/2291) - Add "func" to enaml highlighter
* [PR 2286](https://github.com/spyder-ide/spyder/pull/2286) - Setting Qt API n°2 for all supported objects
* [PR 2281](https://github.com/spyder-ide/spyder/pull/2281) - Add travis support for basic start of spyder
* [PR 2260](https://github.com/spyder-ide/spyder/pull/2260) - New set of icons based on FontAwesome
* [PR 2253](https://github.com/spyder-ide/spyder/pull/2253) - Try to avoid crashes on long output into Python console in a short time
* [PR 2243](https://github.com/spyder-ide/spyder/pull/2243) - Don't add invalid paths to IMG_PATH
* [PR 2237](https://github.com/spyder-ide/spyder/pull/2237) - Changed the IPython completion option from a checkbox to a combobox
* [PR 2226](https://github.com/spyder-ide/spyder/pull/2226) - Add PyQt5 to Qt binding choices for Python consoles
* [PR 2222](https://github.com/spyder-ide/spyder/pull/2222) - Update pep8 version shipped with spyder from 1.4.6 to 1.6.2
* [PR 2218](https://github.com/spyder-ide/spyder/pull/2218) - Update AUTHORS
* [PR 2217](https://github.com/spyder-ide/spyder/pull/2217) - Keybinding Enhancements
* [PR 2208](https://github.com/spyder-ide/spyder/pull/2208) - Fix issue 2204 in tour - blocking file and edit menu
* [PR 2205](https://github.com/spyder-ide/spyder/pull/2205) - Added Brazilian Portuguese translation
* [PR 2202](https://github.com/spyder-ide/spyder/pull/2202) - Allow tab cycling with ctrl+pageup/down
* [PR 2198](https://github.com/spyder-ide/spyder/pull/2198) - Fill in missing global run config options
* [PR 2189](https://github.com/spyder-ide/spyder/pull/2189) - Provide a base implementation for closing_plugin

In this release 103 pull requests were merged


----


## Version 2.3.9

### New features

* Preferences
    * Fix a crash when using certain versions of colorama (which is a Jedi dependency)
* Python and IPython consoles
    * Filter a RuntimeWarning generated for DataFrames with nan values
* Variable Explorer
    * Fix a freeze when binary strings can't be converted to unicode in Python 2
    * Fix a freeze with Numpy arrays containing strings

### Bug fixes

**Issues**

* [Issue 3067](../../issues/3067) - File left open in sitecustomize when executing it in Python 3
* [Issue 3031](../../issues/3031) - Variable Explorer freezes when certain binary data is loaded
* [Issue 2991](../../issues/2991) - RuntimeWarning with pandas.dataframes that contain np.nan values
* [Issue 2984](../../issues/2984) - Can't access Preferences in spyder
* [Issue 2983](../../issues/2983) - Freeze while assigning data from numpy array when the data is a string

In this release 5 issues were closed


----


## Version 2.3.8

### New features

* Python and IPython consoles
    * Fix a sitecustomize error when using Matplotlib 1.5 with Python 2 on Linux
* Variable Explorer
    * Add support for Pandas Series when using Pandas 0.17+
    * Fix a freeze when creating empty DataFrames in Python 2
    * Fix a freeze when working with big Numpy recarray's
* Under the hood
    * Avoid startup crashes when there are errors importing Numpy, SciPy or Pillow

### Bug fixes

**Issues**

* [Issue 2819](../../issues/2819) - Spyder fails to start because of an error with scipy
* [Issue 2815](../../issues/2815) - Variable explorer is not recognizing Pandas Series objects
* [Issue 2793](../../issues/2793) - Connecting to kernel fails because of update to Matplotlib 1.5
* [Issue 2791](../../issues/2791) - DataFrame with no rows gives error when trying to view it
* [Issue 2783](../../issues/2783) - Spyder freezes on assigning a fits table data
* [Issue 2744](../../issues/2744) - Spyder hangs when creating an empty DataFrame on Python 2

In this release 6 issues were closed


----


## Version 2.3.7

### New features

* Editor
    * Remove support for Jedi 0.9 because it was causing crashes
* Variable Explorer
    * Fix crashes and freezes when working with DataFrames on Python 2
* Under the hodd
    * Restore support for PySide

### Bug fixes

**Issues**

* [Issue 2709](../../issues/2709) - IPython console error when trying to use SymPy
* [Issue 2693](../../issues/2693) - README should link to manual
* [Issue 2689](../../issues/2689) - "Resize" button in variable explorer chops off the array
* [Issue 2684](../../issues/2684) - Applications directory link is broken in Spyder 2.3.6 dmg's
* [Issue 2680](../../issues/2680) - "Close all files" hangs Spyder
* [Issue 2661](../../issues/2661) - Conda package manager is packed in 2.3.6 win32 distribution leading to errors
* [Issue 2659](../../issues/2659) - Crash while getting completions of DataFrames on the Editor because of Jedi 0.9
* [Issue 2654](../../issues/2654) - Creating DataFrames in Python or IPython consoles make Spyder 2.3.6 to hang
* [Issue 2649](../../issues/2649) - PySide can not be used on 2.3.6
* [Issue 2296](../../issues/2296) - Line numbers misaligned when zooming and scrolling in Mac
* [Issue 2036](../../issues/2036) - Code analysis and tooltips are not displayed in Ubuntu

In this release 11 issues were closed

**Pull requests**

* [PR 2650](../../pull/2650) - Failed sip import blocks fallback to PySide

In this release 1 pull requests were merged


----


## Version 2.3.6

### New features

* IPython Console
    * Make it fully compatible with IPython/Jupyter 4.0
* Variable Explorer
    * Don't refresh it when focused to avoid slow downs when working with big data
    * Add variable name to DataFrame editor
    * Fix several crashes and freezes when working with DataFrames
* Under the hood
    * Use PyQt4 API #2 by default (API #1 is not supported anymore). This is necessary to support IPython/Jupyter 4.0

### Bug fixes

**Issues**

* [Issue 2625](../../issues/2625) - Multiple untitled files generate at close
* [Issue 2614](../../issues/2614) - Indenting at the first position in file fails/crashes
* [Issue 2608](../../issues/2608) - Crash after update IPython to 4.0
* [Issue 2596](../../issues/2596) - Call tips and auto completion tips go out of screen on a second monitor
* [Issue 2593](../../issues/2593) - Having a lof of data in the Variable explorer slows down Spyder considerably
* [Issue 2566](../../issues/2566) - Spyder crash on launch with Babel 2.0/Python 3.4
* [Issue 2560](../../issues/2560) - List of pandas dataframes in variable explorer slows down Spyder
* [Issue 2517](../../issues/2517) - Variable explorer auto-refreshes after kernel restarts
* [Issue 2514](../../issues/2514) - DataFrames with headers that contain BOM utf-8 data are freezing/crashing Spyder (in Python 2)
* [Issue 2491](../../issues/2491) - Spyder crashes when displaying DataFrames with duplicate column names in the Variable Explorer
* [Issue 2413](../../issues/2413) - Don't ask to confirm exit on default untitled files
* [Issue 2315](../../issues/2315) - Display object name in DataFrame editor

In this release 12 issues were closed

**Pull requests**

* [PR 2639](../../pull/2639) - Fix missing exception on Windows when importing data on the Variable Explorer
* [PR 2617](../../pull/2617) - Show call tips at right position when there are multiple screens
* [PR 2615](../../pull/2615) - Fix error when indenting on the first line of a file

In this release 3 pull requests were merged

----


## Version 2.3.5.2

**Note**: Versions 2.3.5 and 2.3.5.1 have serious startup bugs on Windows and Mac respectively.
Hence they are not listed here.

### New features

* Editor
    * Add support for Jedi 0.9
* IPython Console
    * Add initial support for IPython/Jupyter 4.0
* Main Window
    * Improve how Spyder looks in MacOS X
    * Several fixes to prevent startup crashes

### Bug fixes

**Issues**

* [Issue 2468](../../issues/2468) - 'Connect to existing kernel' fails if json file not in PWD
* [Issue 2466](../../issues/2466) - No Notification of Running Instance
* [Issue 2463](../../issues/2463) - Failure to preserve Matplotlib backend when using symbolic math
* [Issue 2456](../../issues/2456) - Launching IPython console fails because of errors importing Pandas or Matplotlib
* [Issue 2452](../../issues/2452) - os.system causes TypeError in Python 3
* [Issue 2448](../../issues/2448) - Spyder crashes using Variable Explorer with BeautifulSoup
* [Issue 2446](../../issues/2446) - When importing putting two periods in a row produces an error in a Python console
* [Issue 2363](../../issues/2363) - Spyder fails to start because of problems with lockfile
* [Issue 2356](../../issues/2356) - Block comment incorporating whitespace excludes last line
* [Issue 2341](../../issues/2341) - IPython console: "sre_constants.error: unbalanced parenthesis" while typing
* [Issue 2314](../../issues/2314) - Cell highlighting not updated after closing the FindReplace widget
* [Issue 2302](../../issues/2302) - Closing all files in editor shouldn't leave it empty
* [Issue 2299](../../issues/2299) - IPython preference "Automatically load Pylab and Numpy Modules" not followed
* [Issue 2298](../../issues/2298) - Cannot stop executing when runing a flask app with debug=True
* [Issue 2285](../../issues/2285) - Copying from Spyder and pasting into LibreOffice displays strange comments
* [Issue 2228](../../issues/2228) - Shortcut to run cells on Mac is not working
* [Issue 2188](../../issues/2188) - can't run win_post_install from pip
* [Issue 2171](../../issues/2171) - Spyder Mac apps (for Python 2 and 3) hang on startup with OSX 10.9.5
* [Issue 2028](../../issues/2028) - Background color of theme is not set properly on Mac OSX
* [Issue 1957](../../issues/1957) - Python 3 Mac app can't start Python or IPython consoles
* [Issue 1844](../../issues/1844) - "Set as current console's working directory" button not working on Python 3
* [Issue 1615](../../issues/1615) - Mac app - Matplotlib does not work with Canopy

In this release 22 issues were closed

**Pull requests**

* [PR 2486](../../pull/2486) - Stop using IPython.lib.kernel 0.13.2 shim and add initial support for Jupyter
* [PR 2484](../../pull/2484) - Remove unnecessary changes to detected kernel json file when connecting to external kernels
* [PR 2434](../../pull/2434) - Match for pylint when parsing pylint version
* [PR 2411](../../pull/2411) - Improve github issue template
* [PR 2377](../../pull/2377) - Fix the fact that spyder_win_post_install.py can't be run from pip
* [PR 2293](../../pull/2293) - Hide menu icons on Mac OS X
* [PR 2247](../../pull/2247) - Add support to run Python programs on xfce and xterm external terminals
* [PR 2216](../../pull/2216) - Fix broken png files: libpng 1.6.2 and newer has stricter iCCP rules

In this release 8 pull requests were merged


----


## Version 2.3.4

### New features

* Debugging
    * After pressing the Debug button (or `Ctrl+F5`) move to the first breakpoint
* IPython Console
    * Drop support for Sympy versions less than 0.7.3
* Python Console
    * Remove support to run system commands with ! (like `!diff`)
* Editor
    * Accept drops from compressed files on Windows

### Bug fixes

**Issues**

* [Issue 2259](../../issues/2259) - spyder crashes if ipython installed but not pygments
* [Issue 2257](../../issues/2257) - Cannot plot inline in IPython console on Linux
* [Issue 2252](../../issues/2252) - Update French translations for 2.3.4
* [Issue 2245](../../issues/2245) - Importing a module with debugger causes "TypeError: decoding Unicode is not supported"
* [Issue 2239](../../issues/2239) - SyntaxErrors with Python 3.2
* [Issue 2234](../../issues/2234) - Object Inspector is not showing "No documentation available" for objects without docstring
* [Issue 2227](../../issues/2227) - IPython does not work with brewed or virtualenv Python(s) in MacOSX
* [Issue 2223](../../issues/2223) - Spyder2.3.3 Code completion breaks
* [Issue 2207](../../issues/2207) - Spyder's WM_CLASS is empty, resulting in unexpected behavior for task managers
* [Issue 2203](../../issues/2203) - Code completion issue with Jedi
* [Issue 2197](../../issues/2197) - IPython consoles are not named correctly when connecting to existing kernels and passing the full kernel path
* [Issue 2158](../../issues/2158) - runfile with path containing apostrophes (quotes) will not work
* [Issue 2151](../../issues/2151) - Long NumPy arrays throw off errors
* [Issue 2146](../../issues/2146) - Special character "!" is not processed correctly when debugging in Python consoles
* [Issue 2081](../../issues/2081) - Spyder crashes on Windows because of non-ascii chars in working directory
* [Issue 2058](../../issues/2058) - Don't execute external commands (!) when running pdb in python consoles
* [Issue 2034](../../issues/2034) - Execute until first breakpoint when pressing the Debug button
* [Issue 2032](../../issues/2032) - Dragging (not dropping) file from 7zip over spyder window causes TypeError in dragEnterEvent
* [Issue 1952](../../issues/1952) - spyderlib.utils.external overrides modules for script execution
* [Issue 1948](../../issues/1948) - spyder 2.3 ipython console startup code or file not working
* [Issue 1856](../../issues/1856) - Running in external system terminals is not working on Windows and Python 3
* [Issue 1845](../../issues/1845) - Spyder crashes on launch trying to load the project config file (.spyderproject)
* [Issue 1568](../../issues/1568) - raw_input borks with '!'
* [Issue 1529](../../issues/1529) - Plot A List Of Floats In Variable Explorer Not Possible
* [Issue 1380](../../issues/1380) - Problems with sitecustomize because of pickleshare library
* [Issue 1366](../../issues/1366) - "Highlight occurrences" setting is lost after IDE restart
* [Issue 1359](../../issues/1359) - Mac app - Sometimes it's not possible to get the user env vars
* [Issue 1321](../../issues/1321) - The PYTHONPATH manager on the Mac app does not work with the EPD64 interpreter
* [Issue 1151](../../issues/1151) - Ctrl-C doesn't copy to clipboard in object inspector

In this release 29 issues were closed

**Pull requests**

* [PR 2255](../../pull/2255) - Update French translations
* [PR 2242](../../pull/2242) - Improve message for no docstring
* [PR 2233](../../pull/2233) - catch a reason to crash on startup
* [PR 2224](../../pull/2224) - Fix a bug in completion if callback value is not converted to string
* [PR 2219](../../pull/2219) - Open configuration file with utf-8 encoding on Windows and Python 2
* [PR 2214](../../pull/2214) - Fix zlib segmentation fault in Anaconda 3.4 Linux

In this release 6 pull requests were merged


----


## Version 2.3.3

### New features

* Editor
    * Use the [Jedi](http://http://jedi.jedidjah.ch) library to do code completions
    * Add `Ctrl+=` as a shortcut to do Zoom in and `Ctrl+0` to reset zoom
    * Add an option to show blank spaces, under the Source menu. There is also an option to make this permanent under `Preferences > Editor`.
* IPython Console
    * Don't print DataFrames as html tables because this won't be supported since IPython 3.0
    * Drop support for IPython 0.13
    * Support the upcoming 3.0 version
    * Add `Ctrl+T` as shortcut to open new consoles
    * Simplify how consoles are named
* Variable Explorer
    * More optimizations to handle big DataFrames and NumPy arrays (i.e. with more than 1e6 elements).
* Main Window
    * Add `Ctrl+W` and `Ctrl+F4` to close tabs in all platforms
    * Show shortcuts to move to each pane in `View > Panes`

### Bug fixes

* [Issue 670](../../issues/670) - Visual help for indentation: draw spaces and tabs
* [Issue 987](../../issues/987) - Allow the file explorer to open any file into the editor as text
* [Issue 1213](../../issues/1213) - Augment or replace rope with Jedi
* [Issue 1461](../../issues/1461) - Kill button 'clicked' signal is connected but never disconnected on the python shell
* [Issue 1469](../../issues/1469) - Add support to get code completions for compiled modules (e.g. OpenCV)
* [Issue 1484](../../issues/1484) - Debug ignores breakpoints, if there's no ASCII characters in a file path
* [Issue 1574](../../issues/1574) - Creating file gives TypeError on Python 3
* [Issue 1718](../../issues/1718) - Keyboard shortcut to come back to normal zoom level
* [Issue 1808](../../issues/1808) - Shortcuts to create and close IPython consoles
* [Issue 1911](../../issues/1911) - Transition to git and github
* [Issue 1930](../../issues/1930) - Evaluating cell or selection in Python consoles takes ages
* [Issue 1946](../../issues/1946) - Spyder with GTK/GTKAgg backend on GNOME freezes
* [Issue 1987](../../issues/1987) - Matplotlib backend in Mac can't be changed when using PySide
* [Issue 1990](../../issues/1990) - exception in spyder internal console when typing 'exit(' in editor
* [Issue 1993](../../issues/1993) - autocomplete in the middle of a word
* [Issue 2006](../../issues/2006) - Your IPython frontend and kernel versions are incompatible
* [Issue 2019](../../issues/2019) - Winpdb (F7) doesn't work in Python 3
* [Issue 2022](../../issues/2022) - TkAgg backend unresponsive window on Linux and OS X
* [Issue 2040](../../issues/2040) - Improve inline backend options
* [Issue 2049](../../issues/2049) - Pandas Dataframe not opening in Variable Explorer
* [Issue 2064](../../issues/2064) - "About spyder" and "Report issue ..." output errors
* [Issue 2072](../../issues/2072) - Unable to bring up tutorial
* [Issue 2074](../../issues/2074) - Profiler - sorting by Total Time sorts by string order, not numeric order
* [Issue 2080](../../issues/2080) - Bug on Variable Explorer while viewing DataFrames, with timestamp columns
* [Issue 2082](../../issues/2082) - Missing py27 dmg download
* [Issue 2092](../../issues/2092) - PYTHON pathmanager on windows 8 does not work properly
* [Issue 2105](../../issues/2105) - Spyder 2.3.2 freezes when viewing big collections on the Variable Explorer
* [Issue 2108](../../issues/2108) - UnicodeDecodeError in the Internal console when trying to run a file with non-ascii chars and synatx errors in it
* [Issue 2109](../../issues/2109) - Go to definition menu item inactive with rope present.
* [Issue 2126](../../issues/2126) - iPython console rendering of pandas.DataFrame._repr_html_() note in changelog
* [Issue 2139](../../issues/2139) - Small typo in Help : Plotting examples
* [Issue 2143](../../issues/2143) - Closing takes a long time with Python 3.4
* [Issue 2160](../../issues/2160) - UnicodeDecodeError when inspecting pandas DataFrame in ipython console
* [Issue 2190](../../issues/2190) - Update French translations for 2.3.3


----


## Version 2.3.2

### New features

* Editor
    * Improve cells visualization
    * Add support for drag selection and improve look of line number area
    * Open on it any text file present in the File Explorer
    * View and edit IPython notebooks as Json files
    * Syntax highlighting for Json and Yaml files
* Variable Explorer:
    * Import csv files as DataFrames (if Pandas is present)
    * Improve browsing speed for NumPy arrays and DataFrames with more than 1e5 rows
* Debugging
    * Make it easier to set conditions through the Breakpoints pane
* IPython Console
    * Add a stop button to easily stop computations
* Python Console
    * Fixes various issues with unicode

### Bug fixes

* [Issue 556](../../issues/556) - Deal with DOS/Windows encoding
* [Issue 681](../../issues/681) - Allow printing Unicode characters
* [Issue 875](../../issues/875) - Add indication that console is busy
* [Issue 883](../../issues/883) - Open all text files in the Editor from the File Explorer
* [Issue 1200](../../issues/1200) - Strings with accents and variable explorer
* [Issue 1546](../../issues/1546) - Spyder issues with unicode under windows
* [Issue 1767](../../issues/1767) - Some support for the ipynb format
* [Issue 1774](../../issues/1774) - can't open preferences or interpreter after changing path to intepreter
* [Issue 1789](../../issues/1789) - Getting warning "WARNING: Unexpected error discovering local network interfaces: 'SysOutput' object has no attribute 'flush"
* [Issue 1809](../../issues/1809) - Shortcut to get to file explorer
* [Issue 1812](../../issues/1812) - Erros when pressing Tab key in the Editor
* [Issue 1830](../../issues/1830) - Don't modify python default system encoding in the console
* [Issue 1832](../../issues/1832) - Select line via line numbers
* [Issue 1847](../../issues/1847) - Preferences panel don't appear
* [Issue 1849](../../issues/1849) - Support yaml files in editor
* [Issue 1859](../../issues/1859) - Latest rope breaks the Object Inspector
* [Issue 1874](../../issues/1874) - Wheel mouse scrolling not enabled in numberlinemarker or flag area
* [Issue 1877](../../issues/1877) - Cell higlighting and scrollbar
* [Issue 1878](../../issues/1878) - Cell highlighting on startup
* [Issue 1891](../../issues/1891) - Sorting Variable explorer gives a traceback
* [Issue 1892](../../issues/1892) - Spyder crashes because pyzmq is missing
* [Issue 1949](../../issues/1949) - Spyder 'support for graphics' should not require pylab
* [Issue 1953](../../issues/1953) - Please do not break API in minor releases
* [Issue 1958](../../issues/1958) - Disable Variable Explorer auto-refresh feature by default
* [Issue 1961](../../issues/1961) - opening bracket in editor or console: focus switches to internal console (which also display an error)
* [Issue 1970](../../issues/1970) - Connecting to an IPython kernel through ssh hangs if you have never connected to hostname before
* [Issue 1973](../../issues/1973) - Pandas DataFrame in variable explorer can crash the app if it gets out of memory
* [Issue 1975](../../issues/1975) - Improve confusing "UMD has deleted" message
* [Issue 1978](../../issues/1978) - 'Edit' context menu in Variable Explorer should work in all columns
* [Issue 1979](../../issues/1979) - Spyder crashes or hangs when creating some pandas DataFrame's
* [Issue 1982](../../issues/1982) - Middle mouse button *CUTS* text in editor in linux
* [Issue 2004](../../issues/2004) - Open sys.stdin with the right encoding in the console for Python 2
* [Issue 2005](../../issues/2005) - Error when running files in folders with UTF-8 in path
* [Issue 2008](../../issues/2008) - Wrong path to favicon.ico
* [Issue 2015](../../issues/2015) - Printing large pandas DataFrame clears iPython terminal
* [Issue 2033](../../issues/2033) - Link to new WinPython site
* [Issue 2042](../../issues/2042) - IPython console doens't work with Pygments 2.0rc1
* [Issue 2044](../../issues/2044) - Autocomplete in the editor appends the completed variable onto the preceding expression if there's a token in between


----


## Version 2.3.1

### New features

* Variable Explorer
    * Support for Pandas DataFrame's and TimeSerie's types
    * Support for Numpy 3D arrays
    * Drag and drop works for all its supported file types (e.g. images, mat files, json files, etc)
* Editor
    * F9 runs the current line under the cursor if nothing is selected
    * Focus remains on it after evaluating cells and selections (an option was added to return to the old behavior)
* IPython console
    * Connect to external kernels through ssh
* Object Inspector
    * Add a tutorial for beginners
* Main Window
    * Improve style on Mac

### Bug fixes

* [Issue 93](../../issues/93) - Variable explorer: allow array editor to deal with arrays with more than 2 dimensions
* [Issue 1160](../../issues/1160) - Variable Explorer: add support for pandas objects
* [Issue 1305](../../issues/1305) - mayavi plot hangs when IPython graphics backend is inline (default)
* [Issue 1319](../../issues/1319) - Spyder is not getting its taskbar icon right in Win 7/8
* [Issue 1445](../../issues/1445) - Linux style middle mouse button paste not executed in console
* [Issue 1530](../../issues/1530) - Wrong encoding for date in pylint widget
* [Issue 1590](../../issues/1590) - Add numpy matrices as a supported type to the Variable Explorer
* [Issue 1604](../../issues/1604) - spyder 2.2.5 freezes with netCDF4-python
* [Issue 1627](../../issues/1627) - Run selection (F9) changes focus to Python interpreter, but ex-Matlab users expect the focus to remain on the editor
* [Issue 1670](../../issues/1670) - Provide a "Run current line" feature
* [Issue 1690](../../issues/1690) - Feature request: connect to existing IPython kernel over ssh
* [Issue 1699](../../issues/1699) - Option to disable middle button paste
* [Issue 1783](../../issues/1783) - The new cell delimiter when converting a notebook to python file is # In[`*`]
* [Issue 1863](../../issues/1863) - Ctrl-C doesn't work in a *restarted* IPython console
* [Issue 1893](../../issues/1893) - Matplotlib plots do not display correctly in 2.3.0 (when running in dedicated python interpreter)


----


## Version 2.3.0

### New features

* **Python 3 support**
* Editor
    * Use the Tab key to do code completions
    * Highlight cells, i.e. portions of a file delimited by separators of the form `# %%`
    * First-class support for Enaml files
    * Syntax highlighting for Julia files
    * Use Shift+Tab to show the signature corresponding to a function/method while it's been called
    * Do code completions using the tokens (or words) found in a file
    * Token-based completions work for any file type supported by the Editor
    * Add a new tooltip widget (borrowed from the IPython project) to better handle how to show function signatures
* IPython console
    * Assign the keyboard shortcut Ctrl+Shift+I to move to it
    * Open a console by default at startup
    * Give visual feedback when opening a console
    * Show kernel error messages in the client tab
* Object Inspector
    * Add an intro message to explain how to use it
    * New style based on the Bootswatch Cerulean theme
* Main Window
    * Reorganize several menus
* Under the hood
    * Improve startup time
    * Develop a new way to update configuration defaults (that doesn't involve resetting user settings)

### Bug fixes

* [Issue 696](../../issues/696) - Use Tab to do code completion in the Editor
* [Issue 944](../../issues/944) - Add Python 3 support
* [Issue 1068](../../issues/1068) - Shortcut key to switch to IPython console
* [Issue 1082](../../issues/1082) - IPython console: multiprocessing print output goes to kernel not client
* [Issue 1152](../../issues/1152) - Use the Editor/Console fonts for the code completion widget
* [Issue 1243](../../issues/1243) - Bootstrap fails under Python 3.2
* [Issue 1356](../../issues/1356) - IPython ImportError by not using absolute_import
* [Issue 1374](../../issues/1374) - IPython 1.0dev is giving "ImportError: No module named kernelmanager"
* [Issue 1402](../../issues/1402) - Execute pyflakes, pep8, ... with the Python interpreter specified in Preferences>Console
* [Issue 1420](../../issues/1420) - Deactivate pager by default in the iPython console (because it's perceived as a freeze)
* [Issue 1424](../../issues/1424) - Object inspector is broken for external console
* [Issue 1429](../../issues/1429) - Windows installer for Python 3.3 doesn't finish correctly
* [Issue 1437](../../issues/1437) - Corrupted contents when saving non-unicode .py files with non-ASCII characters
* [Issue 1441](../../issues/1441) - Spyder has several problems to start on Windows because pywin32 is not installed
* [Issue 1465](../../issues/1465) - scientific_startup is defining print_function for Python 2.X interactive consoles
* [Issue 1466](../../issues/1466) - unicode_literals breaks PySide
* [Issue 1467](../../issues/1467) - pyflakes flags print "" on python2 systems
* [Issue 1471](../../issues/1471) - IPython is not enabled in 2.3 (because of mismatched IPython version)
* [Issue 1473](../../issues/1473) - IPython kernel can't be started, complaining that 'sys' doesn't have attribute 'argv'
* [Issue 1475](../../issues/1475) - Plotting from the Variable Explorer is not working for IPython consoles
* [Issue 1479](../../issues/1479) - Opening another file in a running Spyder from the terminal fails in Python 3
* [Issue 1496](../../issues/1496) - Ctrl+C don't interrupt computations in either the Console or IPython console
* [Issue 1513](../../issues/1513) - "Replace all" crashes (not always, but regularly)
* [Issue 1514](../../issues/1514) - Python 3 / Spyder 2.3 : impossible to run temporary script in current interpreter
* [Issue 1517](../../issues/1517) - Console/IPython console reappear each time Spyder starts
* [Issue 1519](../../issues/1519) - Old .spyder.ini is not copied to spyder.ini
* [Issue 1528](../../issues/1528) - Error while shutting down Spyder
* [Issue 1540](../../issues/1540) - Exception instead of dialog box
* [Issue 1542](../../issues/1542) - Braces/Parentheses/Brackets Highlighting is broken with v2.3.0dev6 on Windows/Python 3
* [Issue 1545](../../issues/1545) - Win32 "Spyder Documentation" fails to open
* [Issue 1556](../../issues/1556) - Show cells in the outline explorer
* [Issue 1562](../../issues/1562) - Make Windows installers create a desktop shortcut for Spyder
* [Issue 1567](../../issues/1567) - Accept newer versions of pyflakes
* [Issue 1618](../../issues/1618) - Please provide a way to not compile the documentation during the build process
* [Issue 1619](../../issues/1619) - Python3 invalid syntax in figureoptions.py
* [Issue 1623](../../issues/1623) - Mac app: Editor slow on mac after os update to mavericks
* [Issue 1628](../../issues/1628) - Profiler runs but doesn't show the results
* [Issue 1631](../../issues/1631) - Documentation problem with numpy.concatenate
* [Issue 1646](../../issues/1646) - Different numerical results from "runfile" and "execfile"
* [Issue 1649](../../issues/1649) - Variable Explorer does not show complex number variables
* [Issue 1653](../../issues/1653) - 2 popup windows during lauch
* [Issue 1664](../../issues/1664) - Window gone transparent after splash screen
* [Issue 1675](../../issues/1675) - Redifing any for numpy.any in the console
* [Issue 1692](../../issues/1692) - Minor problem with the new Tab completion functionality
* [Issue 1695](../../issues/1695) - Add "psutil" to the list of optional dependancies
* [Issue 1696](../../issues/1696) - Check marks in display > windows menu are unchecked by moving plugins
* [Issue 1697](../../issues/1697) - Variable explorer freezes spyder
* [Issue 1701](../../issues/1701) - pip install spyder does not work any longer (pip version >=1.5)
* [Issue 1715](../../issues/1715) - debian lintian4py check
* [Issue 1716](../../issues/1716) - Add new icon and scripts for python3 in Linux
* [Issue 1723](../../issues/1723) - .pyx Comment and syntax color error in editor
* [Issue 1731](../../issues/1731) - Support Julia files (.jl) in editor
* [Issue 1735](../../issues/1735) - Small correction in French translations
* [Issue 1745](../../issues/1745) - Fix over-aggressive code completion on dot
* [Issue 1746](../../issues/1746) - Errors when running empty cells
* [Issue 1752](../../issues/1752) - Unable to read Spyder Documentation. F1 key does not work
* [Issue 1753](../../issues/1753) - A fix for the behavior of spyderlib\utils\system.py on Windows
* [Issue 1763](../../issues/1763) - Editor with auto-closing bracket enabled : unabled to type "0" before ")"
* [Issue 1772](../../issues/1772) - Fix download links on the main page
* [Issue 1786](../../issues/1786) - problem of icon with spyder 2.3.0 beta4
* [Issue 1793](../../issues/1793) - Highlight current cell slows down the Editor on big files
* [Issue 1794](../../issues/1794) - Mouse pointer on vertical line
* [Issue 1819](../../issues/1819) - Quick layout change unsuccessful
* [Issue 1828](../../issues/1828) - QAction::eventFilter: Ambiguous shortcut overload: Ctrl+W
* [Issue 1829](../../issues/1829) - Keyboard shortcuts, Reset to default values errors
* [Issue 1836](../../issues/1836) - [CTRL]+F4 does not close tabs
* [Issue 1879](../../issues/1879) - Can't start bootstrap.py with pyqt
* [Issue 1881](../../issues/1881) - Bootstrap.py won't start with python3


----


## Version 2.2.5

### Bug fixes

* [Issue 1322](../../issues/1322) - Problems with scientific_startup in other interpreters from the one Spyder is running on
* [Issue 1337](../../issues/1337) - Mac app - Update to Qt 4.8.4 for HDPI
* [Issue 1450](../../issues/1450) - IPython kernel cpu usage increases with time
* [Issue 1520](../../issues/1520) - LinuxColor for ipython plugin
* [Issue 1551](../../issues/1551) - /doc/installation.rst: update Arch Linux package link
* [Issue 1560](../../issues/1560) - spyder 2.2.3 incompatible with pylint 0.25.1 on Windows
* [Issue 1564](../../issues/1564) - Fix several Editor cell problems
* [Issue 1578](../../issues/1578) - Typo in your 'About Spyder...' dialog.
* [Issue 1581](../../issues/1581) - Cannot launch Spyder 2.2.4 installed from DMG on Mac OS X.
* [Issue 1589](../../issues/1589) - Mention what types of objects our Variable Explorer support in our docs
* [Issue 1595](../../issues/1595) - Fail to start an ipython console when variable explorer autorefresh is turned off in Preferences
* [Issue 1596](../../issues/1596) - Spelling mistake in dialog ('loose' --> 'lose')

### Other Changes

* Update our Mac application to the latest versions of Python, Qt and PyQt (now it's based in Homebrew).
* Several important compatibility fixes for PySide.
* Improve our support for IPython 1.0+.

----

## Version 2.2.4

### Bug fixes

* [Issue 347](../../issues/347) - Matplotlib hangs on Mac if using PySide
* [Issue 1265](../../issues/1265) - Create a Debug menu to easily show how to set breakpoints
* [Issue 1489](../../issues/1489) - Project Explorer does not load all projects in workspace.
* [Issue 1516](../../issues/1516) - Make Spyder compatible with both IPython 0.13 and 1.0
* [Issue 1531](../../issues/1531) - Pyflakes version check is looking for 0.5.0 only
* [Issue 1539](../../issues/1539) - /tmp/spyder is owned by the first user on the server to launch spyder

### Other Changes

* Make Spyder compatible with SymPy 0.7.3+
* Add shortcuts to the tooltips of all toolbars
* Make IPython Console work better if Matplotlib is not installed

----

## Version 2.2.3

### Bug fixes

* [Issue 634](../../issues/634) - Debugging: Lingering break points
* [Issue 639](../../issues/639) - Project Explorer: horizontal size issue (added an optional horizontal scrollbar. This option may be enabled/disabled in the widget context menu)
* [Issue 749](../../issues/749) - Outline Explorer: Duplicate entries
* [Issue 852](../../issues/852) - Implement matlab-like cell features
* [Issue 1388](../../issues/1388) - Add an "About Spyder dependencies" dialog box
* [Issue 1438](../../issues/1438) - "runfile" doesn't work correctly if unicode_literals has been imported (replaced backslashes by slashes in paths)
* [Issue 1515](../../issues/1515) - Add an option to use the same interpreter Spyder is running on as "Python executable" for external consoles
* [Issue 1522](../../issues/1522) - licenses of the images (especially the .png)
* [Issue 1526](../../issues/1526) - Build script (setup.py) includes the wrong version of pyflakes/rope in Windows installer
* [Issue 1527](../../issues/1527) - please include the LICENSE file in the source package

### Other Changes

* New "Run selection" (F9), "Run cell" (Ctrl+Enter) and "Run cell and advance" (Shift+Enter) actions in "Run" menu entry, as a replacement to the old "Run selection or block" and "Run block and advance" actions.
* Added "Optional Dependencies" dialog box in "?" menu.
* Editor: added Monokai and Zenburn syntax coloring schemes.
* Keyboard shortcuts: removing deprecated shortcuts at startup. Otherwise, when renaming the name of a registered shortcut (in the code), the old shortcut will stay in Spyder configuration file and opening the Preferences dialog will show a shortcut conflict dialog box. In other words, shortcuts were added to configuration file when registered but never removed if they were removed from the registered shortcuts in the code (or if their context or name was renamed).
* External console tabs: fixed history browsing with Ctrl+Tab and added Shift+Ctrl+Tab support.
* Preferences>Console>Advanced: new option to switch between the default Python executable (i.e. the one used to run Spyder itself) and the custom Python executable that the user may choose freely. This change avoid side-effects when switching from a Python distribution to another on the same OS (with the same Spyder configuration file): many users do not change the Python executable and because of the way it was written in externalconsole.py, changing from a distribution of Python to another with the same Spyder config file could lead to an unexpected configuration (Spyder is executed with the new interpreter but scripts inside Spyder are executed with the old interpreter).
* Run Icons: removed deprecated images, updated other images to the new design
* setup.py/Windows installers: now building CHM documentation for Windows
* SPYDER_DEBUG environment variable now supports 3 levels of debug mode:
    * SPYDER_DEBUG=0 or False: debug mode is off
    * SPYDER_DEBUG=1 or True: debug level 1 is on (internal console is disconnected)
    * SPYDER_DEBUG=2: debug level 2 is on (+ logging coms with external Python processes)
    * SPYDER_DEBUG=3: debug level 3 is on (+ enabling -v option in external Python processes and debugging editor)

----

## Version 2.2.2

### Bug fixes

* [Issue 1497](../../issues/1497) - Spyder 2.2.1 does not work with Python < 2.7
* [Issue 1498](../../issues/1498) - TypeError thrown by IPython Console when the pager is off
* [Issue 1499](../../issues/1499) - Console (Terminal) throws NotImplementedError for Home/End keys
* [Issue 1509](../../issues/1509) - Add support for javascript syntax highlighting
* [Issue 1510](../../issues/1510) - Problems with zooming in/out

### Other Changes

* Add new icons to the Run, Debug and Main toolbars
* Update Pylint plugin to work with pylint 1.0
* Add Ctrl/Cmd+[+,-] to zoom in/out in the Editor
* Disable Crtl+MouseWheel to zoom in/out in Mac (See Issue 1509)

----

## Version 2.2.1

### Bug fixes

* [Issue 1231](../../issues/1231) - Some strange messages are printed in the terminal when Spyder is running
* [Issue 1318](../../issues/1318) - Mac app - Unable to use the keyboard when completion widget is displayed and the app loses focus
* [Issue 1331](../../issues/1331) - Git Bash: Spyder's script has wrong shebang
* [Issue 1333](../../issues/1333) - Spyder is unable to detect git if installed with msysgit (Microsoft Windows PC's)
* [Issue 1370](../../issues/1370) - Unit tests exceptions in IPython are displayed in its kernel tab
* [Issue 1395](../../issues/1395) - Mac App - Importing matplotlib fails on Snow Leopard due to incompatible version of libpng
* [Issue 1399](../../issues/1399) - Recommend to use pip instead of easy_install
* [Issue 1426](../../issues/1426) - Background colour of Object Inspector (docstring) in Rich Text mode is same as the window's
* [Issue 1439](../../issues/1439) - Update pil_patch to be compatible with Pillow
* [Issue 1449](../../issues/1449) - Spyder --light is not functioning
* [Issue 1470](../../issues/1470) - Preferences size is not saved when using PySide
* [Issue 1472](../../issues/1472) - matplotlib plot's docstring is not rendered correctly in the Object Inspector

### Other Changes

* All scientific libraries in our Mac application were updated to their latest releases.
* The _Run Settings_ dialog has now its own icon. Before it was the same as the _Preferences_ pane one.
* Update and improve our _Installation_ instructions for all platforms.
* Add support for Google TODO comments: "TODO(username@domain.com): blabla"

----

## Version 2.2.0

### New features

* **Better integration with IPython**.
    * A dedicated preferences page from which you can set its most important options
    * An easy way to manage IPython kernels inside Spyder (i.e. interrupts and restarts).
    * Each console can be configured separately (which is not possible in IPython-qtconsole)
    * Each console is now connected to the Object Inspector and the History log.
    * Learn how to use IPython reading its documentation on the Object Inspector.
    * Find text in the console and pager using our Find Widget.
* A new **MacOS X Application**
    * We now provide a DMG for simple drag and drop installation.
    * The App comes with its own interpreter, which has the main Python scientific libraries preinstalled: Numpy, SciPy, Matplotlib, IPython, Pandas, Sympy, Scikit-learn and Scikit-image.
* A much improved debugging experience
    * A new debugger toolbar, quite similar in spirit to the one present in Matlab. It works with both Python and IPython consoles.
    * A new breakpoints widget, which lists all active breakpoints set in  open or closed files.
    * Breakpoints are updated in the Python and IPython consoles after being added or removed from the Editor.
* Several Editor improvements
    * Faster and more accurate code completions for the most important scientific packages
    * Zoom in and out with Ctrl + the mouse wheel
    * A new dark theme
    * Automatic insertion of colons
    * Automatic insertion of quotes
    * New syntax highlighters for Matlab, batch, ini, NSIS and IDL files.
* A better looking and faster Object Inspector
    * Several improvements to its style.
    * It can now show mathematical equations written in Latex, using the MathJax Sphinx plugin.
    * Rich text docs are now rendered in a thread to avoid UI lookup.
* **Single instance mode**
    * Users can now open Python scripts from their file explorer on the currently available instance.
    * Linux users can also open their files from the terminal.
* Spanish translation of the interface

### Bug fixes

* [Issue 318](../../issues/318) - Create a widget to list all breakpoints
* [Issue 349](../../issues/349) - Add "Run selection or current block" action to Editor's context menu
* [Issue 448](../../issues/448) - Editor: disable code-related features inside comments (code completion, auto-indentation, ...)
* [Issue 466](../../issues/466) - Can't use Spyder to open python scripts (.py files) from the terminal or the file explorer
* [Issue 554](../../issues/554) - Improved debugger integration
* [Issue 609](../../issues/609) - Debugging: Unsetting a breakpoint in the editor isn't reflected until you restart debugging entirely
* [Issue 650](../../issues/650) - After deleting a directory set as working directory and changing to a new working directory the script won't run
* [Issue 687](../../issues/687) - Indentation error when trying to "run selection" on simple indented code
* [Issue 697](../../issues/697) - Create a DMG package for Spyder
* [Issue 764](../../issues/764) - Jump to the next result when pressing Enter in search field
* [Issue 836](../../issues/836) - Spyder is sometimes not detecting file changes from external editors
* [Issue 849](../../issues/849) - Breakpoints are ignored sometimes
* [Issue 853](../../issues/853) - Problems with code completion after adding submodules to ROPE_PREFS/extension_modules
* [Issue 865](../../issues/865) - Run selection (F9) in IPython console 0.11+: problem with indented blank lines
* [Issue 940](../../issues/940) - open_in_spyder not defined
* [Issue 955](../../issues/955) - Breakpoints in debugger do not move correctly when editing code
* [Issue 971](../../issues/971) - Add "Open with Spyder" entry to Windows File Explorer's context menu
* [Issue 994](../../issues/994) - mathjax does not get installed properly
* [Issue 997](../../issues/997) - Some docstrings are getting truncated in the object inspector
* [Issue 1008](../../issues/1008) - Fail on context menu call in project explorer when project files are inside symlinked dir
* [Issue 1018](../../issues/1018) - Menu locations, "Run Configurations" &  "Preferences"
* [Issue 1026](../../issues/1026) - Decide the best strategy to comment selections on the Editor
* [Issue 1032](../../issues/1032) - Running a script from editor does not send runfile() correctly to IPython Qt plugin
* [Issue 1050](../../issues/1050) - First implementation of the "IPython Console" plugin (single instance version)
* [Issue 1051](../../issues/1051) - New IPython Console (Spyder 2.2+): add support for the %edit magic command
* [Issue 1054](../../issues/1054) - New IPython Console (Spyder 2.2+): update variable explorer after new prompt
* [Issue 1055](../../issues/1055) - New IPython Console (Spyder 2.2+): add support for history management
* [Issue 1056](../../issues/1056) - New IPython Console (Spyder 2.2+): add an option to customize In/Out prompts
* [Issue 1057](../../issues/1057) - New IPython Console (Spyder 2.2+): Add our FindReplace widget to every console
* [Issue 1058](../../issues/1058) - New IPython Console (Spyder 2.2+): Add Ctrl+I keyboard shortcut to send an object the Object Inspector
* [Issue 1059](../../issues/1059) - New IPython Console (Spyder 2.2+): drop support for IPython in external console
* [Issue 1061](../../issues/1061) - New IPython Console (Spyder 2.2+): add support for "Find in files" plugin
* [Issue 1062](../../issues/1062) - New IPython Console (Spyder 2.2+): add a dedicated section in documentation
* [Issue 1064](../../issues/1064) - Editor performance issue since revision d98df4092e16
* [Issue 1069](../../issues/1069) - Focus goes to kernel not client with pdb in IPython client
* [Issue 1078](../../issues/1078) - IPython Console: Cannot interrupt started processes
* [Issue 1079](../../issues/1079) - Can't input Unicode in Internal Console
* [Issue 1081](../../issues/1081) - ipython-qtconsole not listed as optional dependency in Ubuntu
* [Issue 1083](../../issues/1083) - Make Ipython qtconsole widget more intuitive
* [Issue 1085](../../issues/1085) - IPython console: sometimes files are executed in wrong IPython
* [Issue 1094](../../issues/1094) - Error message when trying to save a file
* [Issue 1095](../../issues/1095) - Preferences Dialog doesn't remember size
* [Issue 1101](../../issues/1101) - Interrupt (Ctrl+C) in the console does not work in Spyder on Mac Os X
* [Issue 1106](../../issues/1106) - Spyder console crashes when trying to type in console after running script
* [Issue 1112](../../issues/1112) - Opening a file from the linux command line
* [Issue 1128](../../issues/1128) - please remove pyflakes and rope from the .zip files
* [Issue 1136](../../issues/1136) - IPython console: cannot connect to external kernels
* [Issue 1138](../../issues/1138) - Rich text in object inspector mishandles some scipy docstrings
* [Issue 1163](../../issues/1163) - Improve the spyder.desktop file fo easier integration into Linux
* [Issue 1169](../../issues/1169) - Saving variables does not retain uppercase letters of variable names
* [Issue 1179](../../issues/1179) - Pylint "go to line" does not work with the additional dot in filename
* [Issue 1186](../../issues/1186) - scipy.weave doesn't work in the Mac app
* [Issue 1191](../../issues/1191) - Inconsistent behaviour of the Editor on code completion and object introspection
* [Issue 1199](../../issues/1199) - spyderlib/utils/windows.py has incorrect encoding
* [Issue 1201](../../issues/1201) - Let the user set the default filter when opening file
* [Issue 1210](../../issues/1210) - Enhancement: Create sphinx rich text docstrings in QThread
* [Issue 1226](../../issues/1226) - MacOS X App - Can't import libraries from other Python interpreters
* [Issue 1227](../../issues/1227) - Auto inserted colon causes pylint error
* [Issue 1229](../../issues/1229) - Which version of ipython is needed for Spyder 2.2.0?
* [Issue 1230](../../issues/1230) - Better handle for mathjax and jquery embeded libraries on linux systems
* [Issue 1232](../../issues/1232) - Cmd-Space is not showing code-completion options
* [Issue 1233](../../issues/1233) - ERROR and WARNING when compiling the documentation
* [Issue 1234](../../issues/1234) - Edit .enaml files as text file
* [Issue 1236](../../issues/1236) - Fix Qt Network Access warning messages that appear on the terminal
* [Issue 1241](../../issues/1241) - 'Remove block comment' is not working
* [Issue 1242](../../issues/1242) - Can't start spyder2.2 on Win 7, crashes upon saving .spyder.ini
* [Issue 1249](../../issues/1249) - "Run block" and "Run File" are not working for external IPython kernels
* [Issue 1250](../../issues/1250) - Spyder crashes on launch if the project explorer is used
* [Issue 1252](../../issues/1252) - Expansion of nodes on tree view undoes itself
* [Issue 1253](../../issues/1253) - Spyder is not detecting the presence of iPython 0.13.1rc2 nor IPython 1.0dev
* [Issue 1258](../../issues/1258) - Focusing the "Replace with:" Text Box causes the editor to jump to the next instance of the item that's in the find box
* [Issue 1261](../../issues/1261) - IPython kernel/clients: error when closing an IPython console
* [Issue 1266](../../issues/1266) - Let the user eliminate breakpoints from the "Breakpoints widget"
* [Issue 1269](../../issues/1269) - Dataloss when Spyder gets confused about which file goes with which editor tab
* [Issue 1271](../../issues/1271) - Find and replace by empty string
* [Issue 1272](../../issues/1272) - Fix code completion speed issues on the Editor
* [Issue 1275](../../issues/1275) - Spyderlib fails to start new IPython consoles, raises socket exception
* [Issue 1277](../../issues/1277) - Enthought Python Distribution and Spyder DMG are not working well on Mac OS X
* [Issue 1281](../../issues/1281) - Mac App - Spyder swallows AssertionErrors while executing a file
* [Issue 1285](../../issues/1285) - Object Inspector Crashes when Reloading Page
* [Issue 1286](../../issues/1286) - Broken links in Help
* [Issue 1287](../../issues/1287) - Saving file under different file name in split-window mode lets non-focused window jump to first file
* [Issue 1288](../../issues/1288) - Some rope_patch improvements
* [Issue 1296](../../issues/1296) - Clickable tracebacks in console are not working in PySide
* [Issue 1298](../../issues/1298) - Mac App - matplotlib is not detecting ffmpeg to create animations
* [Issue 1299](../../issues/1299) - pylint keeps opening same file at startup
* [Issue 1309](../../issues/1309) - Clicking on filename in structure widget sets the cursor at the beginning of the file
* [Issue 1314](../../issues/1314) - QPainter warnings when moving/undocking widgets in main window
* [Issue 1315](../../issues/1315) - Project not closing files associated with after closing it
* [Issue 1325](../../issues/1325) - Spyder cannot be re-opened on Windows if parent console is closed
* [Issue 1327](../../issues/1327) - Allow global options for Run Configuration
* [Issue 1344](../../issues/1344) - Mac App - Spyder crashed and can't be open again
* [Issue 1345](../../issues/1345) - Code Review Request: Update breakpoints during pdb sessions
* [Issue 1347](../../issues/1347) - The spyder.desktop has an wrong line
* [Issue 1353](../../issues/1353) - Error messages in internal console when rope is not installed
* [Issue 1363](../../issues/1363) - 2.2rc installation takes a long time because of sphinx dependency
* [Issue 1364](../../issues/1364) - No spyder.ico after installation on Windows
* [Issue 1369](../../issues/1369) - Using the subprocess.check_output function breaks compatibility with Python 2.5 and 2.6
* [Issue 1371](../../issues/1371) - Crash when adding text to multiline comment is CSS
* [Issue 1372](../../issues/1372) - SphinxThread might return AttributeError


----


## Version 2.1.13.1

### Bug fixes

* Spyder startup: fixed PyQt minimum version requirement test (the old poor comparison algorithm was considering that v4.10 was older than v4.4...) (See [Issue 1291](../../issues/1291))
* Console: Matplotlib was always imported even when the Matplotlib's Patch option was not available (i.e. the Matplotlib installed version was not compatible with the patch). As a consequence, even when disabling every console advanced option in preferences, the preloaded module list was huge
* Editor:
    * When closing Spyder with unsaved modified files, Spyder was asking confirmation as many times as there were editor windows. Only one confirmation is necessary because, with current editor design, all editor windows are synced.
    * When creating two new files, saving one of them will lead to temporarily mask the leading '`*`' indicating the fact that the other untitled file was not already saved. This is simply a display issue: internally, it is clear that the file is in a non-saved state and Spyder will ask for it to be saved when trying to close the file
    * Multiple windows: when saving a new untitled file, other editor windows were getting confused on file list order -- eventually leading to data loss
    * Open file dialog: default file type filter now matches the current file (See [Issue 1201](../../issues/1201))
* Fixed "PyQt Reference Guide" link

### Other changes

* Editor: Ctrl+MouseWheel is now zooming in/out the editor text size (see [Issue 1270](../../issues/1270))
* About dialog box: changed the "This project is part of Python(x,y)" part to more general words (which are also closer to the initial meaning of this sentence) including a citation of WinPython


----


## Version 2.1.13

### Bug fixes

* Fixed [Issue 1158](../../issues/1158): "pip install spyder" fails on non-Windows platforms due to a bug in pip installation process (missing spyderlib_win_postinstall.py script)
* File Explorer/Windows/Fixed "remove tree" feature: added an error handler in shutil.rmtree to be able to remove a non-empty folder with shutil.rmtree is not working on Windows when it contains read-only files
* (See [Issue 1106](../../issues/1106)) Fixed "error: unpack requires a string argument of length 8" related to socket communication between Spyder and the remote Python process
* Editor:
    * After splitting horizontally or vertically the editor window, filenames were not synchronized when saving a file as another name (see [Issue 1120](../../issues/1120))
    * Fixed error when trying to "Save as..." a file with extension to a file without any extension (see [Issue 1183](../../issues/1183))
    * pep8 code analysis: a new line character was abusively added by Spyder to source code before analyzing it because it's necessary for pyflakes but it's not for pep8! (see [Issue 1123](../../issues/1123))
    * Fixed UnboundLocalError when clicking on "Search/Replace" button if both search pattern and replace pattern fields are empty (see [Issue 1188](../../issues/1188))
* Pylint plugin/tree widget: "go to line" was not working when filename contained additionnal dots (see [Issue 1179](../../issues/1179))
* Fixed critical bug when an invalid/unsupported version of pyflakes is installed (see [Issue 1181](../../issues/1181))
* Editor/block comments: fixed remaining PyQt API v2 compatibility issues (see [Issue 905](../../issues/905))
* Variable explorer: more flexible name fixing algorithm (even if it's not a good practice to use reference names with upper case letters, we do not remove them anymore) -- See [Issue 1169](../../issues/1169)

### Other changes

* Spyder about dialog box: added Python build architecture (32 or 64 bits)
* Find in files: fixed default 'exclude pattern' which was accidently excluding all files starting with 'build' instead of simply excluding 'build' folders as intended
* For the sake of consistency, now using single-clicks for activating entries of all tree widgets in Spyder ("Find in files" and "Pylint" are now consistent with the "Outline" explorer) -- See [Issue 1180](../../issues/1180)


----


## Version 2.1.12

### Bug fixes

* Spyder settings: sometimes (virus protection?) the .ini file can't be written, and removing the .ini file before writing seems to help, as suggested [here](https://groups.google.com/forum/#!msg/spyderlib/a_P9JBJEZeE/gOK_Pr2WbE8J) (see [Issue 1086](../../issues/1086))
* Fixed Home/End key behaviour inconsistency on MacOS X (See [Issue 495](../../issues/495))
* Internal console: new option "Pop up internal console when errors were intercepted" -- default: False, which avoids loosing focus when a traceback is shown in the internal console... but features may also fail silently! (bugs could stay hidden a while before being taken care of) -- See [Issue 1016](../../issues/1016)
* Fixed "TypeError: file_saved(long,long).emit(): argument 1 has unexpected type 'long'" error occuring on some Linux 32-bit platforms -- See [Issue 1094](../../issues/1094)
* Console: find/replace widget "Search next/previous occurrence" feature was broken

### Other changes

* Portable version of Spyder (inside WinPython):
    * Spyder '?' menu: added documentation detection (.chm, .pdf) in sys.prefix\Doc (Windows-only)
    * Project explorer:
        * Handling errors when opening a workspace which has been moved
        * Workspace is now configured with relative paths, so it can be moved from a location to another and still be opened in Spyder
* Windows: moved the functions hiding parent console to spyderlib/utils/windows.py


----


### Version 2.1.11

### Bug fixes

* Critical bugs:
    * Editor ([Issue 960](../../issues/960)): cannot open/save files from GUI (QFileDialog issue with PyQt4 v4.6)
* General:
    * Spyder menu bar: fixed menu ordering issue with Ubuntu/Unity
    * All console widgets: Shell widget: fixed "Clear terminal" (Ctrl+L) shortcut
* Console:
    * Cleaned up widget interactions after Python script execution (before this changeset, it was possible to send data to console, which not only was not needed but was generating disturbing errors in the internal console...)
* Editor:
    * If user accept to fix "mixed end-of-line characters", when opening file, the current editor was set as "modified" (the tab title had a `*` at the end) instead of the newly created editor
    * "occurrence highlighting" was highlighting previous word even if there was a whitespace between cursor and this word
    * Code analysis thread manager: handling errors while executing threads
    * "Replace all" was not regrouping changes into a single undo/redo step
    * "Find/Replace": replacements were not done for case unsensitive searches
    * Position of the 79-chars edge line is now more accurate on Linux, the older processed position was inaccurate with some font size of the classic "DejaVu Sans Mono" monospace font
* IPython:
    * Version detection was broken so Preferences...Console...External Modules was incorreclty hiding the command line options line edit
    * Because the detection was not working correctly, it was not possible to start an IPython kernel with the just released IPython 0.13
* Project explorer was sometimes producing AttributeError when loading because of the workspace was not defined at the beginning of the class constructor
* pyflakes code analysis function:
    * Handling files with invalid \x or null chars
    * This fixes a part of [Issue 1016](../../issues/1016) by handling the following pyflakes bugs:
      * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=674796
      * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=674797

### Other changes

* Installer for Windows (bdist_wininst/bdist_msi):
    * added Start Menu shortcuts
    * added 'pyflakes' and 'rope' (if available in the repository) to the package list (this is not conventional but Spyder really need those tools and there is not decent package manager on Windows platforms, so...)
    * This change will make the Spyder building process simpler for Windows as the Python(x,y) won't be needed anymore to provide Start Menu shortcuts or to install 'rope' and 'pyflakes' at the same time. Now, there is no significative difference between the standard installers built with distutils (bdist_wininst or bdist_msi options) and the Python(x,y) plugin, except for the "package upgrade" ability (uninstall previous version) which is still not (and won't be) supported by distutils.


----


## Version 2.1.10

### Bug fixes

* Critical bugs:
    * Spyder crashed at startup/TypeError: `_isdir()` takes exactly 1 argument (0 given). Affects only Windows platforms with Python 3.2.2+ or 2.7.3+)
    * Spyder was freezing when working with netCDF4 objects in the interactive console
    * Console: h5py was systematically imported to avoid crashes with the HDF5 plugin (Variable Explorer's I/O plugin). These ugly workarounds introduced with revision 3affc82ce081 were removed in this changeset to avoid side effects like DLL version conflict on Windows platforms. The main risk of this change is to break the HDF5 plugin on some configurations. But this is the best compromise.
* General:
    * Fixed regression: when no Qt library is installed (PyQt/PySide), warning the user with a Tkinter dialog box (if possible)
    * Fixed Preferences Dialog flickering issue introduced with revision a4e1565e93c5
    * Run configuration dialog: fixed Tab focus order behavior
    * Fixed "Run > Configure..." and "PYTHONPATH management" entry locations on MacOSX
    * Updated bootstrap script and Qt library selection logic to accommodate launch of Spyder using PySide while PyQt is also installed ([Issue 1013](../../issues/1013), see [Issue 975](../../issues/975) for additional background).
    * Fixed several encoding problems preventing Spyder from launching when the user's home directory contains non-ASCII characters ([Issue 812](../../issues/812), [Issue 1027](../../issues/2017)).
    * Debugging: [Issue 684](../../issues/684): Debug with winpdb will now use the command line options and working directory specified in the General Setting section of the Run Configuration dialog
* Console:
    * Changed "Clear shell" shortcut to "Ctrl+L" to avoid conflict with the Windows Task Manager shortcut on Windows platforms
    * Preferences/Advanced options: added option to start an IPython kernel at startup
* Editor:
    * When multiple files were open, close-clicking 1 file was closing 2 files on 64-bits OS
    * Conditional breakpoint could not be changed to regular breakpoint
    * Outline Explorer: removed obsolete decorated methods icon (a decorated method is now shown exactly as a regular method)
    * Top-left corner menu (file list): fixed common prefix removal feature
    * "Outline" item selection opened in incorrect split panel due to a lost signal when focus changed from an editor to another
    * when splitting window after changing a shortcut, old shortcut was still active
* Internal console/fixed an old regression: re-added help(), raw_input() support
* Profiler: tree was sometimes empty + fixed error when file path contained "&"
* File/Project explorer: fixed [by shchelokovskyy] Git commit/browse support
* Find in files: fixed crash due to a bug in the common prefix finder function

### Other changes

* Checked Spyder's `rope` patch compatibility with rope v0.9.4
* IPython plugin (experimental):
    * added support for "Execute in current interpreter"
    * added support for "Execute selection or block (F9)"
    * imports from local directory did not work
    * when a new kernel is started in Console, tabifying the frontend to the Console (for the first created frontend) and the next frontends to the previously created frontend
    * clients (frontends) may now really be closed (see context menu). The associated kernel and related clients may be closed as well (a message box dialog ask the user about this)
    * added support for the "Object Inspector to/from IPython kernel" link
    * improved reliability of the "Editor to/from IPython kernel" link
    * fixed focus management issue (link with variable explorer and object inspector)


----


## Version 2.1.9

### Bug fixes

* Run configuration/bugfix: command line options were not properly parsed
* Preferences dialog was not showing up with PySide installed *and* without PyQt4
* Editor:
    * Closing additional editor window produced traceback and primary editor breakdown
    * File/Open: embedded editor popped up even if there is one in a separate window
    * Selecting a part of a word raises an IndexError exception
    * Revert option was prompting for user input even on an unmodified buffer
    * Added missing .f77 file extensions for Fortran files filter
    * Occurrence highlighting was not working when cursor was at the left side of a word and if the next character was ':', ',' or '(' (or any other character not matching the "word regexp")
* Console:
    * Console was unusable (endless tracebacks) when monitor was disabled
    * File drag'n drop was not working (should execute dropped file)
* (Experimental) IPython plugin:
    * Fixed compatibility issues with PyQt4 and IPython 0.12
    * Fixed multiple instances issue (it was not possible to open more than one IPython frontend) and other issues
    * IPython kernel connections were unpredictable ([Issue 977](../../issues/977))
* Dictionary editor (Variable explorer): fixed UnboundLocalError when context menu is called on an empty table
* Object inspector failed to show an error message due to unicode error
* Project Explorer:
    * "Show all files" option was broken after restarting Spyder
    * It was impossible to create a project from an existing directory located outside the workspace


----


## Version 2.1.8

### Bug fixes

* Editor/Source code toolbar:
    * "Show task list" and "Go to the next task" actions: the "Show TODO/FIXME/XXX/HINT/TIP comments list" button was not working
    * "Show warning/error list" and "Go to the next warning/error" actions: the "Show code analysis warnings/errors" button was not working


----


## Version 2.1.7

### Bug fixes

* Main window:
    * Detached dockwidgets were not painted after restarting Spyder ([Issue 880](../../issues/880))
* Console:
    * Enhanced Python interpreter: %clear command was broken since v2.1.5
* Object inspector's rich text mode: fixed unexpected indent error
* IPython plugin: fixed compatibility issue with latest v0.12dev (thanks to Boris Gorelik)

### Other changes

* Variable explorer/Array editor: added support for masked arrays
* Showing Spyder's internal console automatically when there is a traceback
* Do not crash when a 3rd party plugin failed to import
* Editor:
    * Automatic insertion of single, double and triple quotes
    * Automatically colons insertion when pressing Enter after 'if', 'def', etc
    * Don't trigger code completion on comments if text ends with a dot
    * Added keyboard shortcut (Ctrl+Shift+Escape) to clear the console
    * Added keyboard shortcut (Ctrl+P) to print current file (thanks to fheday at gmail dot com for the contribution)
    * Code introspection features (code completion, calltips, go-to-definition) are now working even if script has syntax errors


----


## Version 2.1.6

### Bug fixes

* Critical bug on certain Windows platforms (not sure yet if it's related to a particular version of PyQt or something else): all plugins (dockwidgets) were shown detached (or hidden) from the mainwindow at startup (this is related to the attempt fixing [Issue 880](../../issues/880))


----


## Version 2.1.5

### Bug fixes

* Detached dockwidgets (Console, ...) were not painted after restarting Spyder
* Editor/Outline-bugfix: duplicate entries were shown when the editor was synchronizing file contents with disk
* File/Project explorer:
    * Fixed regression regarding [Issue 740](../../issues/740) (fixed in v2.1.0, re-introduced in v2.1.2): couldn't open files with non-ascii characters in their names
    * SCM support: commit/log actions were not working when right-clicking on a file instead of a folder
* Console:
    * Monitor/Introspection: fixed socket communication issue due to a MemoryError -- This error was mixing communication messages, causing various problems described in [Issue 857](../../issues/847) and [Issue 858](../../issues/858). This bug was reported by ruoyu0088, who also tried (and succeeded) to fix it and suggested a workaround which is implemented in this release
    * Fix critical console hang on OS X when using the "Run selection or current block feature" (see [Issue 502](../../issues/502))
    * Apply the right scheme color to the IPython console when there weren't any options provided by the user or when the only option was "-colors LightBG"
* Windows platforms:
    * "Preferences" dialog was not shown if account username contained non-ASCII characters
* Object Inspector:
    * Show signatures for docstrings sent from the Editor (see [Issue 690](../../issues/690))

### Other changes

* Debugging: when a non-empty SPYDER_DEBUG environment variable exists, Spyder switch to debug mode (log files are created in user's home directory and debug prints are available in the terminal)
* Variable explorer/Dictionary editor: added option to plot histogram from a 1-D array
* Console:
    * standard Python interpreter is now a real Python interactive session: the older implementation was running a startup script and tried to emulate a standard Python interactive session (changing attributes like __name__, running the PYTHONSTARTUP script, etc.). But this implementation was not close enough to the standard Python interactive session, i.e. when you execute `python` outside Spyder, without any argument. A recent bug report confirmed this: the PYTHONSTARTUP script was executed but not exactly the same way as it is outside Spyder: for example, doing `from __future__ import division` in the startup script had no effect whereas it did outside Spyder.
    * when running a standard Python interpreter, instead of running the startup script (spyderlib/widgets/externalshell/startup.py), the shell widget (ExternalPythonShell) simply runs the python executable with -u -i options, that's all. So now, the PYTHONSTARTUP script is executed as expected.
    * Scientific startup script (default PYTHONSTARTUP in Spyder): added floating point division (from __future__ import division)
    * PySide support:
        * Added new "Qt (PyQt/PySide)" settings group in "External modules" tab
        * It is now possible to select the Qt-Python bindings library: default (i.e. depends on the QT_API environment variable), PyQt or PySide
        * The PyQt input hook has been adapted for PySide, so it is now possible to do interactive (non-blocking) plotting with PySide
    * New options for standard Python interpreters (no effect on IPython):
        * "Merge process standard output/error channels": merging the output channels of the process means that the standard error won't be written in red anymore, but this has the effect of speeding up display
        * "Colorize standard error channel using ANSI escape codes": this method is the only way to have colorized standard error channel when the output channels have been merged
* Internal console ([Issue 868](../../issues/868)): output is now immediately available
* "Maximize current plugin" action: now automatically shows the "Outline" plugin when maximizing the "Editor" plugin
* Editor/Outline comment separators: allow space betwee hash and dash, e.g "# --- Outline Separator"


----


## Version 2.1.4

### Bug fixes

* Console:
    * *Critical bugfix* for IPython support: variable explorer link was broken (regression introduced with v2.1.3)

### Other changes

* Console:
    * option "Open an IPython interperter at startup" is now *explicitely* disabled for IPython v0.11+ (these versions of IPython are not fully supported through Spyder's console plugin)


----


## Version 2.1.3

### Enhancements

* Variable explorer performance were improved, especially when dealing with very long sequences -- See [this discussion](http://groups.google.com/group/spyderlib/browse_thread/thread/3a7ef892695e417a)
* Variable explorer / dictionary editor: added support for unknown objects -- this allows browsing any object attributes -- This is still experimental.

### Bug fixes

* General:
    * Spyder preferences/bugfix: comboboxes with keys other than strings (e.g. the PyQt API selection combo box) were not initialized properly
    * Fixed memory leaks (QThread objects) in the "Editor" and "Find in files" plugins. In those two plugins, QThread objects were created, then started but were never garbage-collected after they finished their execution
* Editor:
    * Supported file types: added missing C++ file extensions (.cc, .hh, .hxx)
* Variable explorer:
    * Debugging: added support for editing objects within functions
    * Debugging: when debugging, variable explorer link was broken after restarting program
    * handling errors when trying to enable/disable autorefresh (if one of the running console has no monitor enabled)
* Project explorer:
    * when the workspace has not yet been defined, creating a new project not only warns the user but also proposes to set it right away


----


## Version 2.1.2

### Bug fixes

* General:
    * Patched external path library to avoid a crash with a user HOME directory with non-ascii characters
    * Doc/README: warning the user about the fact that the 'python setup.py install' method does not uninstall a previous version
* Console:
    * Fixed "AccessInit: hash collision: 3 for both 1 and 1" error (see [Issue 595](../../issues/595))
* Project explorer:
    * empty workspace/critical bugfix: impossible to create/import projects from context menu (this bug was introduced with a recent revision and stayed unnoticed until then because one has to test this from an empty workspace)
    * it is now possible to rename projects (safely)
    * now handling the I/O errors (e.g. read-only configuration files) occuring when loading/saving projects or the workspace: warning the user when an IOError exception was raised and mention the projects which could not be saved properly
* File/Project explorer:
    * keyboard shortcut 'F2' (rename file/directory) was broken
    * the "Open" action (context menu) was failing silently for directories (expected behavior: open an external file explorer to browse the directory)
    * programs.start_file/bugfix: feature was not working on Windows 7
* Editor:
    * Fix empty username in new file template on OS X (patch by Christoph Gohle)
* Object inspector:
    * Rich text mode was not showing headings when invoked from editor ([Issue 690](../../issues/690))

### Enhancements

* File/Project explorer:
    * Added "Delete" keyboard shortcut to remove selected file(s)/folder(s)
    * SCM integration: added support for TortoiseHg v2 (only v1 was supported)
* Console/Matplotlib options: the backend may now be set separately from the Matplotlib patch

### Other changes

* Console:
    * The Matplotlib patch is only applied for Matplotlib <=v1.0
    * PyQt API version issues (error like "ValueError: API 'QString' has already been set to version 1"): the "ignore setapi errors" option is disabled by default, to avoid masking these errors and associated tracebacks


----


## Version 2.1.1

_Note:_ v2.1.1 is a minor update of v2.1.0 (licence issues and minor bug fixes)

Follow Spyder news on our official blog:
http://spyder-ide.blogspot.com/

### Compatibility/Requirements

Since version 2.1:
* Spyder is now compatible with:
    * PyQt's API v1 (i.e. compatible with PyQt 4.4 and 4.5), the default Python 2 API
    * *and* PyQt's API v2 (this is the future: default Python 3 API and PySide-compatible API)
    * *and* with PySide (PySide support is still experimental as this library is still young but its stability is evolving rapidly)
* Editor/code analysis: Spyder now requires *pyflakes v0.5.0* (included in Windows installers).

### New features since v2.0.12

* New *Profiler* plugin (thanks to Santiago Jaramillo)
* New experimental *IPython* plugin embedding IPython's Qt console: see [here](http://spyder-ide.blogspot.com/2011/08/preview-of-new-ipython-plugin-for.html)
* General:
    * Main window:
        * added "Custom window layouts" management (see menu "View")/handling 3 custom layouts: default shortcuts Shift+Alt+FX to switch to/from layout #X and Ctrl+Shift+Alt+FX to set layout #X
        * "General" preferences page: added option to set the Qt windows style, depending on platform (Plastique, Cleanlooks, CDE, Windows...)
        * Menu "?": added menu entry to report Spyder issues, filling automatically informations on your configuration
        * Reorganized "Run"/"Source" menu, added "Interpreters" menu
        * Fixed application name for Gnome 3/Fedora 15
* Command line options: added option "--defaults" to reset settings (stored in .spyder.ini) to defaults (a lot of settings are preserved: shortcuts, window layouts, ...) -- this is less brutal than "--reset" which reset all settings by removing all configuration files related to Spyder
* *Outline* (function/class browser) is now a plugin in itself, embedded in its own dockwidget: Spyder's window layout is even more customizable than before
* *Code completion*
    * (Editor/Console): entries starting with an underscore character are now placed to the end of the suggested list
    * (Editor/Console): Import statements are now completed correctly
* *Console*:
    * Major code cleaning: running Python applications in Spyder has never been cleaner and is very close to a simple Python interpreter
    * Added built-in function `open_in_spyder` to open a file in Spyder's source code editor from the console
    * Standard Python interpreter:
        * now refresh the variable explorer at each new prompt (even if auto-refresh is disabled -- actually, this is the typical use case)
        * added support for basic special commands (%pwd, %ls, %clear) and system commands (starting with '!', e.g. !dir or !ls)
        * added ["scientific" startup script](http://spyder-ide.blogspot.com/2011/09/new-enhanced-scientific-python.html) with support for numpy, scipy and matplotlib
    * Preferences (External modules tab):
        * added an option to set PyQt API to v1 or v2 -- this avoids issues with Enthought Tool Suite or any other library/program using PyQt API v2 which is *not* the default API for Python 2
        * changed matplotlib patch to fix compatiblity issue with PyQt API v2
    * Preferences (Advanced Settings tab): added option "Python executable" to customize path to Python interpreter executable binary
* *Variable explorer*:
    * New HDF5 plugin by [DavidAnthonyPowell](http://code.google.com/u/DavidAnthonyPowell/): import/export HDF5 files to/from the variable explorer
    * Dictionary editor/Variable explorer:
        * Added support for more NumPy data types
        * Added action "Resize rows to contents" (partially implements feature requested with [Issue 807](../../issues/807))
* *Editor*:
    * find/replace:
        * added support for *multiline* regular expression search pattern
        * added support for *multiline* regular expression text replacement
        * added button "Highlight matches" to highlight all found results
    * syntax highlighting: added support for OpenCL, gettext files, patch/diff files, CSS and HTML files
    * support for "2 spaces" and "tabs" indentation characters
    * new code analysis feature: added support for the [pep8](http://pypi.python.org/pypi/pep8) style guide checker
    * "Comment" and "Uncomment" actions were replaced by a single "Comment/Uncommment" toggle action
    * (Fixes  [Issue 811](../../issues/811) ) "Run configuration": added "Run in an external system terminal" option
* *File explorer* and *Project explorer*:
    * great performance improvement (using a multithreaded file system model)
    * Added minimalist SCM support (Mercurial and git are currently supported)
* *File explorer*: added an option to "Show current directory only"
* *Project explorer*: this plugin was entirely rewritten to improve performances and usability
* *Pylint plugin*:
    * added option to save file before analyzing it
* Spyder's console embedded in your application (spyderlib.widgets.internalshell):
    * in traceback, a clickable link now opens the associated file in Spyder (if application was launched from Spyder with monitor enabled)
    * Application sample embedding Spyder's internal shell: upgraded to guidata v1.4+ (simplified build script a lot)
* Windows platforms specific changes:
    * (requires pywin32) Hiding the attached console window:
        * allow running Spyder with 'python.exe' without visible console (this avoid using 'pythonw.exe' which does not attach a console to the process, hence preventing standard I/O to be redirected in a subprocess executed within Spyder, e.g. in your own program)
        * the attached console may be shown/hidden from menu entry "View > Attached console window (debugging)"
* Major change for Windows/PyQt users: standard Python interpreter now supports interactive GUI manipulations thanks to a new Spyder-specific input hook (replacing PyQt's input hook which is not working within Spyder on Windows platforms) -- the input hook works even better than PyQt's builtin input hook (with a Python interpreter opened outside Spyder)
* Spyder's stand-alone version building process was improved. This version is now available on project's download page.

### Bug fixes (since v2.0.12)

* Spyder's main window:
    * QtDesigner and QtLinguist were not detected on Fedora
    * Console/Editor: code completion widget was partially hidden when working on two monitors and if Spyder's window was on the right screen
    * Fixed bugs due to too early/frequent calls to plugin refresh methods during startup
* Console:
    * IPython Interpreter: Turn off autoindent magic to avoid indentation errors with code with inline comments
* Editor:
    * Fortran syntax highlighter was made case insensitive
    * Fixed IndentationError when running first line of a file
    * Read only files allowed ".", "[", "(", etc. to be entered into the text editor
    * Fixed segmentation faults occuring after using the vertical-horizontal splitting feature
    * If a file name had non-ascii characters then code completion (and all other rope-based features) in the editor stopped working
    * Code analysis: fixed tasks pattern (for example, previous one was matching "TIP" in "MULTIPLICATION"... now it will match only single "TIP:" or "TIP ")
    * (Fixes  [Issue 704](../../issues/704)) Outline was showing the delimiters of block comments ('#------...-'), causing nesting inconsistencies because block comments are not indented properly with respect to the code around
    * Fixed several bugs with the "Run selection or current block" feature.
* Object inspector:
    * Rich text mode was failing for non-ascii docstrings
* Find/Replace widget:
    * Combo box history was populated only when pressing Enter (now pressing F3 to find next occurrence will add the current entry to history)


----


## Version 2.0.12

### Bug fixes

* (Fixes [Issue 476](../../issues/476)) Editor/bugfix: print preview was not working
* Completion widget/bugfix (editor/console): combo box was truncated by main window depending on its size
* widgets.sourcecode.base.TextEditBaseWidget/bugfix: parenting to None was not working
* Console/Text wrap mode: character wrapping was not implemented since we switched from QTextEdit to QPlainTextEdit
* (Fixes [Issue 649](../../issues/649)) Patch submitted by [DavidAnthonyPowell](http://code.google.com/u/DavidAnthonyPowell/) - Syntax highlighter does not recognise imaginary, binary or octal numbers
* Spyder's layout: fixed window position/size issues when maximized/fullscreen mode was active
* Object inspector: fixed minor bug (simple traceback in the internal console) when handling a sphinx error
* (Fixes [Issue 667](../../issues/667)) Editor/bugfix: Shift+Enter inserted lines that did not get line numbers
* (Fixes [Issue 672](../../issues/672)) Editor: TODO/FIXME were not detected if not followed by ':' (HINT/TIP were properly detected)

### Enhancements

* (Fixes [Issue 655](../../issues/655)) Editor/pyflakes-powered code analysis: warnings are now ignored for lines containing "pyflakes:ignore"

### Other changes

* Internal console (Spyder debugging only): turned off the multithreaded mode


----


## Version 2.0.11

### Bug fixes (since v2.0.9)

* (Fixes [Issue 616](../../issues/616)) Pylint plugin: tree widget header text was not updated when analyizing a new script (the last analyzed script name was still shown)
* Editor/completion widget/bugfix: pressing shift was hiding the completion combo box
* (Fixes [Issue 630](../../issues/630)) Added missing default settings for "Spyder light" (only necessary when installing from scratch and without any remaining .spyder.ini file)
* Editor/Console-bugfix: info tooltips (calltips) were hidden right after being shown (i.e. when typing any character after the left parenthesis)
* (Fixes [Issue 631](../../issues/631)) Drag and drop of files into editor on Linux was pasting path instead of opening the file
* (Fixes [Issue 640](../../issues/640)) Editor: block comment was not working correctly at end of file
* Code completion widget (Editor/Console) - bugfix: parenting to the ancestor widget was necessary on Linux
* (Fixes [Issue 546](../../issues/546)) (Contributor: [Alex Fargus](http://code.google.com/u/alex.fargus/)) C/Cpp syntax highlighting bugfix
* (Fixes [Issue 646](../../issues/646)) IPython integration: fixed pyreadline monkey-patch for pyreadline v1.7

### Enhancements (since v2.0.9)

* File explorer widget/plugin: improved performances (widget is now populated in a separate thread)
* Spyder crash dialog: warning the user about the '--reset' option (this will remove all configuration files)


----


## Version 2.0.9

### Bug fixes

* Console: added option to ignore PyQt/sip errors when trying to set sip API (fixed Enthought Tool Suite 3.6.0 compatibility issue)
* utils.dochelpers.getargtxt/bugfix: retrieving builtin function arguments was no longer working
* (Fixes [Issue 499](../../issues/499)) Editor-related keyboard shortcuts were not applied after opening files
* (Fixes [Issue 575](../../issues/575)) Tab scroll buttons were not shown on OS X resulting in clamped/changing window sizes
* (Fixes [Issue 574](../../issues/574)) Debugging: Spyder only synced at debugger breakpoints
* (Fixes [Issue 576](../../issues/576)) "Source / Remove trailing spaces" was removing newline at the end of file (+ added support for "undo")
* (Fixes [Issue 582](../../issues/582)) Console: changing font preferences was requiring a restart to be fully taken into account
* (Fixes [Issue 562](../../issues/562)) Spyder was unable to restore editor's outline explorer tree when mixed ' and " characters were found in tree entries
* (Fixes [Issue 590](../../issues/590)) Shell/"Clear line" shortcut was not correct: this is actually "Shift+Escape" (not "Escape")
* (Fixes [Issue 591](../../issues/591)) History log was systematically erased when updating Spyder version
* Outline explorer/bugfix: when opening file, the 'show/hide all files' option was not applied (this was then applied when switching from a file to another)
* (Fixes [Issue 602](../../issues/602)) Backported from v2.1 a couple of bugfixes related to Editor and multiple panels
* Object inspector: when raised automatically above other dockwidgets, plugin refresh was unnecessarily triggered
* Editor/code completion-bugfix: some key events (e.g. Ctrl+V) were lost during code completion-related hang-up
* (Fixes [Issue 599](../../issues/599)) Multiline text pasting was not working in a newly opened console (i.e. first prompt)

### Enhancements

* Major change/Translations: moved from 'QtLinguist' to 'gettext' (localizing Spyder should now be easier)
* Console: increased default maximum line count (buffer depth) up to 10,000 lines (instead of only 300 lines)
* Editor's rope-based introspection features (code completion, calltips, go to definition): new rope monkey-patch providing major performance improvements
* File explorer/Project explorer - opening file with associated application: now supported on all platforms
* Added action "Reset window layout" in "View" menu to reset main window layout to default
* Documentation: added page on debugging
* Editor: added syntax highlighters for diff/patch files (.diff, .patch, .rej) and gettext files (.po, .pot)
* (Fixes [Issue 537](../../issues/537)) Global working directory toolbar: removed label considering the fact that the toolbar widgets are quite explicit on its role (and the combo box tooltip is explaining it in detail)
* (Fixes [Issue 598](../../issues/598)) Added a .desktop file in source package
* (Fixes [Issue 87](../../issues/87)) Editor plugin's title now show the current script filename


----


## Version 2.0.8

### Bug fixes (since v2.0.6)

* Consoles/bugfix: saving history log (see context menu) was not working following a recent code cleaning/refactoring
* On non-Windows platforms, the file selection dialog "All files (*.*)" filter was not matching files without extension
* dochelpers.isdefined/bugfix: ignoring syntax errors while evaluating object
* Preferences Dialog (dialog box + keyboard shortcut page): improved size/resize behavior
* Editor: when cursor was on the very last line, Duplicate/Delete line features were getting stuck in an infinite loop
* Editor/duplicate line feature - fixed unexpected behavior: when duplicating selected text, text selection was extended to duplicated part
* Editor/bugfix with multiple editor windows: when opening file on one editor window, the top-left corner menu (file list) was not updated correctly in other editor windows
* Editor/fixed unexpected behavior: when clicking on the main window's outline explorer while a separate editor window had focus, the latter was used to show the associated line of code
* Project explorer: added new debugging options (profiling 'rope' calls)
* Console/Advanced settings/UMD module list: removing all entries (empty module list) was not working
* Editor/File list management dialog (Ctrl+E): double clicking/pressing Return on a listwidget item will switch to the associated file
* Editor/Tab bar: fixed missing tooltips issue (and missing file switch menu entries)
* Code completion/bugfix: list widget was not hiding as expected when pressing ':'
* Editor/fixed unexpected behavior: when some text was selected, "Ctrl+Left mouse click" was trying to "go to definition" instead of doing the standard drag n'drop feature
* Editor/bugfix: disabling code completion/calltips for non-Python source code (was not working -as expected- but was taking time to simply not work...)
* Editor/go to line: fixed unicode error
* Code editor/bugfix: cursor position was not restored when undoing an indent operation with "tab always indent" feature turned on *and* the cursor at the end of the line
* Tab behavior when "tab always indents" is turned off: inserting 4-(len(leading_text) % 4) spaces (instead of 4)
* Object inspector/bugfix: ignoring unknown objects when called automatically from editor/console, i.e. do not log, do not show 'no doc available'

### Other changes (since v2.0.6)

* Code editor syntax highlighting: added more keywords to Cython syntax highlighter (cpdef, inline, cimport and DEF)
* Added example of application using the Spyder's internal shell as a debugging console (demonstrates also the py2exe deployment procedure)
* Object inspector: added "Source" combo box (Console/Editor) -> object inspected from editor are now analyzed only with rope (if available) and then shown in object inspector
* Added keyboard shortcut to open Preferences Dialog (default: Ctrl+Alt+Shift+P)
* Editor: added "Copy line" feature (Ctrl+Alt+Down), similar to "Duplicate line" (Ctrl+Alt+Up) but paste text before the current line/selected text (instead of after)
* Array editor: added option to set row/col labels (resp. ylabels and xlabels)
* Editor/rope: improved performance for calltips/doc feature


----


## Version 2.0.6

### Bug fixes

* Console: menu entries "Environment variables", "Current working directory" and "Show sys.path" were not disabled when the Monitor was turned off
* Preferences dialog box/Keyboard shortcuts:
    * conflicts are now ignored if shortcuts have different contexts *except* if one of this context is '`_`' (i.e. global context)
    * conflict warnings are now also shown when showing the preferences dialog box (not only when modifying shortcuts and applying changes)
* Drag/drop Python script to console: fixed TypeError (TypeError: start() got an unexpected keyword argument 'ask_for_arguments')
* Console base widget: added support for FF (Form Feed) ANSI sequence - Fixes bug in IPython console: 'cls' and 'clear' magic commands were inactive in IPython consoles
* Editor: code completion was sometimes very slow when editing files within a Spyder project
* Code editor: fixed "Delete line" feature (Ctrl+D) / was not working with multiline selection

### Other changes

* Editor/80-column vertical edge line: added options to show/hide this line and change the column number
* Editor: added "Comment"/"Uncomment" actions to context menu
* Source code and shell editor widgets: code refactoring/cleaning (this should help people using these widgets outside Spyder)
