# -*- coding: utf-8 -*-

"""
***************************************************************************
    acceptable_missing_doc.py
    ---------------------
    Date                 : March 2016
    Copyright            : (C) 2016 by Stéphane Brunner
    Email                : stephane dot brunner at camptocamp dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Stéphane Brunner'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Stéphane Brunner'

# -*- coding: utf-8 -*-
"""
The list of acceptable documentation missing
"""
__author__ = 'Stéphane Brunner'
__date__ = '18/03/2016'
__copyright__ = 'Copyright 2016, The QGIS Project'

ACCEPTABLE_MISSING_DOCS = {
    "QgsFeatureRequest": ["Flag"],
    "QgsValueRelationSearchWidgetWrapper": ["value() const"],
    "QgsRasterFileWriter": ["setMaxTileWidth(int w)", "setPyramidsFormat(QgsRaster::RasterPyramidsFormat f)", "buildPyramidsFlag() const", "maxTileHeight() const", "pyramidsFormat() const", "setPyramidsList(const QList< int > &list)", "setTiledMode(bool t)", "pyramidsConfigOptions() const", "setPyramidsConfigOptions(const QStringList &list)", "tiledMode() const", "setOutputFormat(const QString &format)", "setPyramidsResampling(const QString &str)", "QgsRasterFileWriter(const QString &outputUrl)", "outputFormat() const", "maxTileWidth() const", "createOptions() const", "setBuildPyramidsFlag(QgsRaster::RasterBuildPyramids f)", "WriterError", "setMaxTileHeight(int h)", "setCreateOptions(const QStringList &list)", "outputProviderKey() const", "pyramidsResampling() const", "pyramidsList() const", "Mode", "setOutputProviderKey(const QString &key)"],
    "QgsSingleBandPseudoColorRenderer": ["classificationMax() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "setClassificationMin(double min)", "setClassificationMax(double max)", "classificationMin() const"],
    "QgsVectorFileWriter::StringOption": ["StringOption(const QString &docString, const QString &defaultValue=QString())"],
    "QgsPenCapStyleComboBox": ["setPenCapStyle(Qt::PenCapStyle style)", "penCapStyle() const", "QgsPenCapStyleComboBox(QWidget *parent=nullptr)"],
    "QgsAttributeEditorElement": ["AttributeEditorType"],
    "QgsDataDefinedValueDialog": ["dataDefinedChanged()"],
    "QgsOWSSourceSelect": ["enableLayersForCrs(QTreeWidgetItem *item)"],
    "QgsAttributeFormInterface": ["form()", "feature()", "acceptChanges(const QgsFeature &feature)", "featureChanged()", "QgsAttributeFormInterface(QgsAttributeForm *form)", "initForm()"],
    "QgsAttributeActionDialog": ["actions() const", "QgsAttributeActionDialog(const QgsActionManager &actions, QWidget *parent=nullptr)", "showWidgetInAttributeTable() const", "attributeTableWidgetStyle() const", "init(const QgsActionManager &action, const QgsAttributeTableConfig &attributeTableConfig)"],
    "QgsFeatureRenderer": ["type() const", "setUsingSymbolLevels(bool usingSymbolLevels)", "QgsFeatureRenderer(const QString &type)", "usingSymbolLevels() const"],
    "QgsGeometryContainedCheckError": ["QgsGeometryContainedCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QgsGeometryCheckerUtils::LayerFeature &containingFeature)", "containingFeature() const"],
    "QgsDetailedItemWidget": ["setData(const QgsDetailedItemData &data)", "setChecked(bool flag)"],
    "QgsRuleBasedLabeling": ["rootRule() const", "rootRule()"],
    "QgsFeatureSelectionModel": ["QgsFeatureSelectionModel(QAbstractItemModel *model, QgsFeatureModel *featureModel, QgsIFeatureSelectionManager *featureSelectionHandler, QObject *parent)", "setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)"],
    "QgsVectorLayerEditPassthrough": ["QgsVectorLayerEditPassthrough(QgsVectorLayer *layer)"],
    "QgsLayerTreeGroup": ["nodeVisibilityChanged(QgsLayerTreeNode *node)", "QgsLayerTreeGroup(const QgsLayerTreeGroup &other)"],
    "QgsLayerItem": ["iconRaster()", "iconPolygon()", "iconLine()", "iconPoint()", "iconDefault()", "iconTable()"],
    "QgsRuleBasedRenderer::Rule": ["label() const", "setLabel(const QString &label)", "symbol()", "dependsOnScale() const", "save(QDomDocument &doc, QgsSymbolMap &symbolMap) const", "initFilter()"],
    "QgsMapSettings": ["updateDerived()", "writeXml(QDomNode &node, QDomDocument &doc)", "mapToPixel() const", "readXml(QDomNode &node)"],
    "QgsSingleCategoryDiagramRenderer": ["setDiagramSettings(const QgsDiagramSettings &s)"],
    "pal::LabelPosition": ["getPartId() const", "getQuadrant() const", "getUpsideDown() const", "getNumOverlaps() const", "getReversed() const", "getHeight() const", "resetNumOverlaps()", "getWidth() const", "getProblemFeatureId() const", "setPartId(int id)"],
    "pal::PointSet": ["invalidateGeos()", "PointSet(int nbPoints, double *x, double *y)", "getNumPoints() const", "deleteCoords()", "PointSet(double x, double y)", "getGeosType() const", "getCentroid(double &px, double &py, bool forceInside=false) const", "createGeosGeom() const", "preparedGeom() const", "PointSet(const PointSet &ps)"],
    "QgsRasterPyramidsOptionsWidget": ["checkAllLevels(bool checked)", "setRasterLayer(QgsRasterLayer *rasterLayer)", "resamplingMethod() const", "pyramidsFormat() const", "createOptionsWidget()", "overviewList() const", "setRasterFileName(const QString &file)", "overviewListChanged()", "apply()", "configOptions() const", "someValueChanged()"],
    "QgsRasterLayerSaveAsDialog": ["pyramidsResamplingMethod() const", "mode() const", "buildPyramidsFlag() const", "outputFileName() const", "pyramidsFormat() const", "hideOutput()", "pyramidsConfigOptions() const", "nColumns() const", "noData() const", "outputRectangle() const", "ResolutionState", "outputFormat() const", "CrsState", "tileMode() const", "createOptions() const", "maximumTileSizeY() const", "nRows() const", "hideFormat()", "yResolution() const", "outputCrs()", "maximumTileSizeX() const", "pyramidsList() const", "Mode", "xResolution() const"],
    "QgsGeometrySelfContactCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "QgsGeometrySelfContactCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsStyleGroupSelectionDialog": ["QgsStyleGroupSelectionDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsDiagramProperties": ["showSizeLegendDialog()", "mDiagramAttributesTreeWidget_itemDoubleClicked(QTreeWidgetItem *item, int column)", "mEngineSettingsButton_clicked()", "mRemoveCategoryPushButton_clicked()", "mAttributesTreeWidget_itemDoubleClicked(QTreeWidgetItem *item, int column)", "QgsDiagramProperties(QgsVectorLayer *layer, QWidget *parent, QgsMapCanvas *canvas)", "mAddCategoryPushButton_clicked()", "scalingTypeChanged()", "updatePlacementWidgets()", "mFindMaximumValueButton_clicked()", "auxiliaryFieldCreated()", "apply()", "mDiagramStackedWidget_currentChanged(int index)", "showAddAttributeExpressionDialog()", "mDiagramTypeComboBox_currentIndexChanged(int index)"],
    "QgsVectorFileWriter::SetOption": ["SetOption(const QString &docString, const QStringList &values, const QString &defaultValue, bool allowNone=false)"],
    "QgsAttributeDialog": ["attributeForm()", "feature()"],
    "QgsLayerTreeLayer": ["QgsLayerTreeLayer(QgsMapLayer *layer)", "QgsLayerTreeLayer(const QgsLayerTreeLayer &other)", "attachToLayer()"],
    "QgsMultiRenderChecker": ["setControlPathPrefix(const QString &prefix)"],
    "QgsColorEffectWidget": ["QgsColorEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsSourceFieldsProperties": ["AttrColumns", "loadRows()", "setRow(int row, int idx, const QgsField &field)", "updateButtons()", "init()", "apply()", "QgsSourceFieldsProperties(QgsVectorLayer *layer, QWidget *parent=nullptr)", "toggleEditing()"],
    "QgsVertexMarker": ["setIconSize(int iconSize)", "setPenWidth(int width)", "setIconType(int iconType)", "QgsVertexMarker(QgsMapCanvas *mapCanvas)"],
    "QgsMapRendererParallelJob": ["QgsMapRendererParallelJob(const QgsMapSettings &settings)"],
    "QgsClipToMinMaxEnhancement": ["QgsClipToMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsRasterProjector": ["setPrecision(Precision precision)", "precision() const", "precisionLabel(Precision precision)"],
    "QgsGlowWidget": ["QgsGlowWidget(QWidget *parent=nullptr)", "create()"],
    "QgsJoinDialog": ["QgsJoinDialog(QgsVectorLayer *layer, QList< QgsMapLayer * > alreadyJoinedLayers, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags())"],
    "QgsPluginLayerType": ["QgsPluginLayerType(const QString &name)", "name()"],
    "QgsExternalResourceWidget": ["DocumentViewerContent", "setDocumentPath(const QVariant &documentPath)"],
    "QgsBrowserModel": ["removeRootItems()", "updateProjectHome()", "beginInsertItems(QgsDataItem *parent, int first, int last)", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "ItemDataRole", "endRemoveItems()", "itemDataChanged(QgsDataItem *item)", "endInsertItems()"],
    "QgsRuleBasedRendererWidget": ["removeRule()", "refineRuleRanges()", "refineRule(int type)", "selectedRules()", "selectedRulesChanged()", "addRule()", "restoreSectionWidths()", "editRule(const QModelIndex &index)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "refineRuleCategories()", "refineRuleScales()", "refineRuleScalesGui(const QModelIndexList &index)", "QgsRuleBasedRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "clearFeatureCounts()", "currentRule()", "saveSectionWidth(int section, int oldSize, int newSize)", "countFeatures()", "editRule()", "currentRuleChanged(const QModelIndex &current=QModelIndex(), const QModelIndex &previous=QModelIndex())", "setRenderingOrder()"],
    "QgsRunProcess": ["create(const QString &action, bool capture)"],
    "pal::GeomFunction": ["dist_euc2d(double x1, double y1, double x2, double y2)", "findLineCircleIntersection(double cx, double cy, double radius, double x1, double y1, double x2, double y2, double &xRes, double &yRes)", "dist_euc2d_sq(double x1, double y1, double x2, double y2)", "cross_product(double x1, double y1, double x2, double y2, double x3, double y3)"],
    "QgsDataDefinedWidthDialog": ["QgsDataDefinedWidthDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsDefaultRasterLayerLegend": ["QgsDefaultRasterLayerLegend(QgsRasterLayer *rl)"],
    "QgsGeometrySelfIntersectionCheck": ["ResolutionMethod", "QgsGeometrySelfIntersectionCheck(const QgsGeometryCheckContext *context, const QVariantMap &configuration=QVariantMap())"],
    "QgsAttributeTableFilterModel": ["fidToIndexList(QgsFeatureId fid)", "mapFromMaster(const QModelIndex &sourceIndex) const", "mapToMaster(const QModelIndex &proxyIndex) const"],
    "QgsSpatialIndexCopyVisitor": ["QgsSpatialIndexCopyVisitor(SpatialIndex::ISpatialIndex *newIndex)"],
    "QgsDiagramLayerSettings": ["Placement"],
    "QgsLongLongValidator": ["bottom() const", "QgsLongLongValidator(QObject *parent)", "setRange(qint64 bottom, qint64 top)", "top() const", "setBottom(qint64 bottom)", "QgsLongLongValidator(qint64 bottom, qint64 top, QObject *parent)", "setTop(qint64 top)"],
    "QgsRasterFormatSaveOptionsWidget": ["QgsRasterFormatSaveOptionsWidget(QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &format=\"GTiff\", QgsRasterFormatSaveOptionsWidget::Type type=Default, const QString &provider=\"gdal\")", "optionsChanged()", "apply()", "Type"],
    "QgsNewNameDialog": ["fullNames(const QString &name, const QStringList &extensions)", "matching(const QStringList &newNames, const QStringList &existingNames, Qt::CaseSensitivity cs=Qt::CaseSensitive)", "highlightText(const QString &text)", "nameChanged()"],
    "QgsFillSymbol": ["setAngle(double angle)"],
    "QgsSymbolSelectorDialog": ["moveLayerDown()", "layerChanged()", "removeLayer()", "symbolModified()", "moveLayerUp()", "addLayer()", "lockLayer()", "updateLayerPreview()", "updatePreview()"],
    "QgsBrushStyleComboBox": ["QgsBrushStyleComboBox(QWidget *parent=nullptr)", "brushStyle() const", "setBrushStyle(Qt::BrushStyle style)", "iconForBrush(Qt::BrushStyle style)"],
    "QgsCollapsibleGroupBox": ["QgsCollapsibleGroupBox(const QString &title, QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "setSettings(QgsSettings *settings)", "saveCollapsedState()", "saveCheckedState()", "init()", "QgsCollapsibleGroupBox(QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "saveKey() const"],
    "QgsGeometryPointInPolygonCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "QgsGeometryPointInPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsProject": ["relationManager() const"],
    "QgisPlugin": ["name()"],
    "QgsRasterChecker": ["report()"],
    "QgsRasterNuller": ["setNoData(int bandNo, const QgsRasterRangeList &noData)", "noData(int bandNo) const", "QgsRasterNuller(QgsRasterInterface *input=nullptr)"],
    "QgsBrightnessContrastFilter": ["QgsBrightnessContrastFilter(QgsRasterInterface *input=nullptr)"],
    "QgsCollapsibleGroupBoxBasic": ["checkToggled(bool ckd)", "QgsCollapsibleGroupBoxBasic(QWidget *parent=nullptr)", "QgsCollapsibleGroupBoxBasic(const QString &title, QWidget *parent=nullptr)", "checkClicked(bool ckd)", "init()", "toggleCollapsed()", "clearModifiers()", "titleRect() const", "updateStyle()"],
    "QgsPreviewEffect": ["PreviewMode", "QgsPreviewEffect(QObject *parent)"],
    "QgsGeos": ["fromGeosPolygon(const GEOSGeometry *geos)", "getGEOSHandler()", "coordSeqPoint(const GEOSCoordSequence *cs, int i, bool hasZ, bool hasM)"],
    "QgsPointLocator_VisitorNearestVertex": ["QgsPointLocator_VisitorNearestVertex(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsDartMeasurement": ["QgsDartMeasurement(const QString &name, Type type, const QString &value)", "send() const", "toString() const", "Type"],
    "QgsRasterInterface": ["ySize() const", "yBlockSize() const", "QgsRasterInterface(QgsRasterInterface *input=nullptr)"],
    "QgsCptCityColorRamp": ["copyingInfo() const", "setName(const QString &schemeName, const QString &variantName=QString(), const QStringList &variantList=QStringList())", "copyingFileName() const", "hasMultiStops() const", "fileLoaded() const", "variantName() const", "cloneGradientRamp() const", "loadFile()", "variantList() const", "setVariantList(const QStringList &variantList)", "fileName() const", "descFileName() const", "schemeName() const", "copy(const QgsCptCityColorRamp *other)", "loadPalette()", "setSchemeName(const QString &schemeName)", "setVariantName(const QString &variantName)"],
    "QgsIdentifyMenu": ["resultsIfExternalAction()", "MenuLevel", "showFeatureActions()", "allowMultipleReturn()", "maxLayerDisplay()", "maxFeatureDisplay()", "execWithSingleResult()"],
    "QgsLayerPropertiesWidget": ["layerTypeChanged()", "changed()", "emitSignalChanged()", "changeLayer(QgsSymbolLayer *)", "populateLayerTypes()", "updateSymbolLayerWidget(QgsSymbolLayer *layer)"],
    "QgsPointLocator_Stream": ["QgsPointLocator_Stream(const QLinkedList< RTree::Data * > &dataList)"],
    "QgsMapLayerProxyModel": ["Filter"],
    "QgsGradientFillSymbolLayerWidget": ["setColor2(const QColor &color)", "setColor(const QColor &color)", "setGradientSpread(int index)", "setCoordinateMode(int index)", "setGradientType(int index)"],
    "QgsVectorFileWriter::Option": ["Option(const QString &docString, QgsVectorFileWriter::OptionType type)"],
    "QgsLineSymbolLayer": ["QgsLineSymbolLayer(bool locked=false)", "widthMapUnitScale() const", "setWidthMapUnitScale(const QgsMapUnitScale &scale)"],
    "QgsConstWkbPtr": ["operator-=(int n)", "operator>>(float &r) const", "operator const unsigned char *() const", "QgsConstWkbPtr(const unsigned char *p, int size)", "operator>>(int &v) const", "operator>>(unsigned int &v) const", "operator+=(int n)", "operator>>(char &v) const", "operator>>(double &v) const"],
    "QgsSymbolLayerUtils": ["decodePenCapStyle(const QString &str)", "decodeSldAlpha(const QString &str)", "drawStippledBackground(QPainter *painter, QRect rect)", "fillToSld(QDomDocument &doc, QDomElement &element, Qt::BrushStyle brushStyle, const QColor &color=QColor())", "createMarkerLayerFromSld(QDomElement &element)", "createVendorOptionElement(QDomDocument &doc, const QString &name, const QString &value)", "decodeSldLineCapStyle(const QString &str)", "decodeRealVector(const QString &s)", "encodeSldFontWeight(int weight)", "decodePenJoinStyle(const QString &str)", "encodeSldFontStyle(QFont::Style style)", "onlineResourceFromSldElement(QDomElement &element, QString &path, QString &format)", "externalGraphicFromSld(QDomElement &element, QString &path, QString &mime, QColor &color, double &size)", "decodeSldFontStyle(const QString &str)", "decodeSldRealVector(const QString &s)", "geometryFromSldElement(QDomElement &element, QString &geomFunc)", "createFillLayerFromSld(QDomElement &element)", "encodeMapUnitScale(const QgsMapUnitScale &mapUnitScale)", "encodePenJoinStyle(Qt::PenJoinStyle style)", "needLinePatternFill(QDomElement &element)", "needEllipseMarker(QDomElement &element)", "encodeRealVector(const QVector< qreal > &v)", "createSvgParameterElement(QDomDocument &doc, const QString &name, const QString &value)", "encodeBrushStyle(Qt::BrushStyle style)", "rotationFromSldElement(QDomElement &element, QString &rotationFunc)", "encodeSldAlpha(int alpha)", "decodeBlendMode(const QString &s)", "decodePenStyle(const QString &str)", "hasExternalGraphic(QDomElement &element)", "encodePenStyle(Qt::PenStyle style)", "getVendorOptionList(QDomElement &element)", "createFunctionElement(QDomDocument &doc, QDomElement &element, const QString &function)", "encodeSldRealVector(const QVector< qreal > &v)", "decodeSldLineJoinStyle(const QString &str)", "createDisplacementElement(QDomDocument &doc, QDomElement &element, QPointF offset)", "lineFromSld(QDomElement &element, Qt::PenStyle &penStyle, QColor &color, double &width, Qt::PenJoinStyle *penJoinStyle=nullptr, Qt::PenCapStyle *penCapStyle=nullptr, QVector< qreal > *customDashPattern=nullptr, double *dashOffset=nullptr)", "needSvgMarker(QDomElement &element)", "clearSymbolMap(QgsSymbolMap &symbols)", "displacementFromSldElement(QDomElement &element, QPointF &offset)", "decodeSldBrushStyle(const QString &str)", "decodeColor(const QString &str)", "functionFromSldElement(QDomElement &element, QString &function)", "labelTextToSld(QDomDocument &doc, QDomElement &element, const QString &label, const QFont &font, const QColor &color=QColor(), double size=-1)", "needMarkerLine(QDomElement &element)", "needPointPatternFill(QDomElement &element)", "createLineLayerFromSld(QDomElement &element)", "encodeColor(const QColor &color)", "externalGraphicToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &mime, const QColor &color, double size=-1)", "decodeMapUnitScale(const QString &str)", "fillFromSld(QDomElement &element, Qt::BrushStyle &brushStyle, QColor &color)", "encodePenCapStyle(Qt::PenCapStyle style)", "decodeSldFontWeight(const QString &str)", "hasWellKnownMark(QDomElement &element)", "needFontMarker(QDomElement &element)", "needSvgFill(QDomElement &element)", "opacityFromSldElement(QDomElement &element, QString &alphaFunc)", "createGeometryElement(QDomDocument &doc, QDomElement &element, const QString &geomFunc)", "createOnlineResourceElement(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format)", "createRotationElement(QDomDocument &doc, QDomElement &element, const QString &rotationFunc)", "decodeBrushStyle(const QString &str)", "encodeSldBrushStyle(Qt::BrushStyle style)", "encodeSldLineJoinStyle(Qt::PenJoinStyle style)", "encodeSldLineCapStyle(Qt::PenCapStyle style)", "createOpacityElement(QDomDocument &doc, QDomElement &element, const QString &alphaFunc)", "externalMarkerFromSld(QDomElement &element, QString &path, QString &format, int &markIndex, QColor &color, double &size)", "getSvgParameterList(QDomElement &element)", "externalMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format, int *markIndex=nullptr, const QColor &color=QColor(), double size=-1)", "wellKnownMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &name, const QColor &color, const QColor &strokeColor, Qt::PenStyle strokeStyle, double strokeWidth=-1, double size=-1)"],
    "QgsRelief": ["addReliefColorClass(const QgsRelief::ReliefColor &color)", "QgsRelief(const QString &inputFile, const QString &outputFile, const QString &outputFormat)", "reliefColors() const", "zFactor() const", "setZFactor(double factor)", "setReliefColors(const QList< QgsRelief::ReliefColor > &c)", "clearReliefColors()"],
    "QgsFeatureListModel": ["displayExpression() const", "masterModel()", "Role", "featureByIndex(const QModelIndex &index, QgsFeature &feat)", "fidToIndexList(QgsFeatureId fid)", "mapSelectionToMaster(const QItemSelection &selection) const", "mapSelectionFromMaster(const QItemSelection &selection) const", "mapFromMaster(const QModelIndex &sourceIndex) const", "mapToMaster(const QModelIndex &proxyIndex) const", "setSourceModel(QgsAttributeTableFilterModel *sourceModel)"],
    "QgsCurvePolygon": ["QgsCurvePolygon(const QgsCurvePolygon &p)"],
    "QgsGeometry::Error": ["Error(const QString &m)", "Error(const QString &m, const QgsPointXY &p)"],
    "QgsMeshDatasetGroupTreeItemDelagate": ["QgsMeshDatasetGroupTreeItemDelagate(QObject *parent=nullptr)"],
    "QgsGeometryCollection": ["QgsGeometryCollection(const QgsGeometryCollection &c)"],
    "QgsCptCityBrowserModel": ["removeRootItems()", "connectItem(QgsCptCityDataItem *item)", "ViewType", "QgsCptCityBrowserModel(QObject *parent=nullptr, QgsCptCityArchive *archive=QgsCptCityArchive::defaultArchive(), ViewType Type=Authors)", "reload()", "refresh(const QModelIndex &index=QModelIndex())", "refresh(const QString &path)", "endRemoveItems()", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "addRootItems()", "findItem(QgsCptCityDataItem *item, QgsCptCityDataItem *parent=nullptr) const", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "endInsertItems()"],
    "QgsVectorLayerSelectionManager": ["QgsVectorLayerSelectionManager(QgsVectorLayer *layer, QObject *parent=nullptr)"],
    "QgisInterface": ["actionHideSelectedLayers()=0", "actionPluginListSeparator()=0", "actionNewVectorLayer()=0", "actionDuplicateLayer()=0", "actionOpenTable()=0", "actionRollbackEdits()=0", "pluginManagerInterface()=0", "actionAddRasterLayer()=0", "actionToggleFullScreen()=0", "actionAddPgLayer()=0", "actionRemoveAllFromOverview()=0", "actionShowPythonDialog()=0", "actionAddAllToOverview()=0", "actionCancelAllEdits()=0", "actionOpenFieldCalculator()=0", "actionRollbackAllEdits()=0", "actionHideAllLayers()=0", "actionLayerProperties()=0", "actionCopyLayerStyle()=0", "actionCancelEdits()=0", "actionQgisHomePage()=0", "actionSaveEdits()=0", "actionToggleEditing()=0", "actionOptions()=0", "actionLayerSaveAs()=0", "actionSaveAllEdits()=0", "actionManagePlugins()=0", "actionCustomProjection()=0", "actionAddOgrLayer()=0", "layerTreeView()=0", "actionAddToOverview()=0", "actionAddWmsLayer()=0", "actionShowSelectedLayers()=0", "actionAbout()=0", "actionPasteLayerStyle()=0", "actionAllEdits()=0", "actionShowAllLayers()=0", "actionHelpContents()=0", "actionCheckQgisVersion()=0", "actionSaveActiveLayerEdits()=0"],
    "QgsMapRendererCustomPainterJob": ["QgsMapRendererCustomPainterJob(const QgsMapSettings &settings, QPainter *painter)"],
    "QgsValueMapConfigDlg": ["QgsValueMapConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsEncodingFileDialog": ["pbnCancelAll_clicked()", "saveUsedEncoding()"],
    "QgsRendererRangeLabelFormat": ["format() const", "trimTrailingZeroes() const", "setTrimTrailingZeroes(bool trimTrailingZeroes)", "saveToDomElement(QDomElement &element)", "setPrecision(int precision)", "setFormat(const QString &format)", "labelForRange(const QgsRendererRange &range) const", "precision() const", "QgsRendererRangeLabelFormat(const QString &format, int precision=4, bool trimTrailingZeroes=false)", "setFromDomElement(QDomElement &element)", "formatNumber(double value) const"],
    "QgsGeometryChecker": ["fixError(QgsGeometryCheckError *error, int method, bool triggerRepaint=false)", "execute(int *totalSteps=nullptr)", "QgsGeometryChecker(const QList< QgsGeometryCheck * > &checks, QgsGeometryCheckContext *context, const QMap< QString, QgsFeaturePool * > &featurePools)", "progressValue(int value)", "errorUpdated(QgsGeometryCheckError *error, bool statusChanged)", "errorAdded(QgsGeometryCheckError *error)", "getChecks() const", "featurePools() const", "getContext() const", "setMergeAttributeIndices(const QMap< QString, int > &mergeAttributeIndices)", "getMessages() const"],
    "QgsGeometryContainedCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometryContainedCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsDataDefinedSizeDialog": ["QgsDataDefinedSizeDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsGeometryEngine": ["envelope(QString *errorMsg=nullptr) const =0", "simplify(double tolerance, QString *errorMsg=nullptr) const =0", "QgsGeometryEngine(const QgsAbstractGeometry *geometry)", "interpolate(double distance, QString *errorMsg=nullptr) const =0", "area(QString *errorMsg=nullptr) const =0", "buffer(double distance, int segments, QString *errorMsg=nullptr) const =0", "length(QString *errorMsg=nullptr) const =0", "isEmpty(QString *errorMsg) const =0"],
    "QgsPointLocator_VisitorNearestEdge": ["QgsPointLocator_VisitorNearestEdge(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsDiagramRenderer": ["setDiagram(QgsDiagram *d)", "rendererName() const =0", "QgsDiagramRenderer(const QgsDiagramRenderer &other)", "diagram() const"],
    "QgsSingleBandGrayRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsSingleBandGrayRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "QgsOfflineEditing": ["ProgressMode"],
    "QgsVectorDataProvider": ["convertValue(QVariant::Type type, const QString &value)"],
    "QgsDxfPaintDevice": ["setLayer(const QString &layer)", "QgsDxfPaintDevice(QgsDxfExport *dxf)", "setDrawingSize(QSizeF size)", "setShift(QPointF shift)", "setOutputSize(const QRectF &r)"],
    "QgsSimpleFillSymbolLayer": ["createFromSld(QDomElement &element)", "brushStyle() const", "setPenJoinStyle(Qt::PenJoinStyle style)", "strokeWidth() const", "penJoinStyle() const", "QgsSimpleFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, Qt::BrushStyle style=DEFAULT_SIMPLEFILL_STYLE, const QColor &strokeColor=DEFAULT_SIMPLEFILL_BORDERCOLOR, Qt::PenStyle strokeStyle=DEFAULT_SIMPLEFILL_BORDERSTYLE, double strokeWidth=DEFAULT_SIMPLEFILL_BORDERWIDTH, Qt::PenJoinStyle penJoinStyle=DEFAULT_SIMPLEFILL_JOINSTYLE)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "strokeStyle() const", "strokeWidthMapUnitScale() const", "setStrokeWidth(double strokeWidth)", "setStrokeStyle(Qt::PenStyle strokeStyle)", "setBrushStyle(Qt::BrushStyle style)"],
    "QgsFeatureIterator": ["rewind()", "close()", "nextFeature(QgsFeature &f)"],
    "QgsAttributesFormProperties::DnDTreeItemData": ["showLabel() const", "name() const", "visibilityExpression() const", "displayName() const", "setColumnCount(int count)", "setRelationEditorConfiguration(RelationEditorConfiguration relationEditorConfiguration)", "setName(const QString &name)", "setType(Type type)", "showAsGroupBox() const", "type() const", "setHtmlElementEditorConfiguration(HtmlElementEditorConfiguration htmlElementEditorConfiguration)", "Type", "DnDTreeItemData()=default", "setVisibilityExpression(const QgsOptionalExpression &visibilityExpression)", "setBackgroundColor(const QColor &backgroundColor)", "setQmlElementEditorConfiguration(QmlElementEditorConfiguration qmlElementEditorConfiguration)", "backgroundColor() const", "htmlElementEditorConfiguration() const", "qmlElementEditorConfiguration() const", "relationEditorConfiguration() const", "DnDTreeItemData(Type type, const QString &name, const QString &displayName, const QColor &backgroundColor=QColor())", "columnCount() const", "operator QVariant()", "setShowLabel(bool showLabel)", "setDisplayName(const QString &displayName)", "setShowAsGroupBox(bool showAsGroupBox)"],
    "QgsGpsdConnection": ["QgsGpsdConnection(const QString &host, qint16 port, const QString &device)"],
    "QgsPalettedRendererWidget": ["QgsPalettedRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "create(QgsRasterLayer *layer, const QgsRectangle &extent)"],
    "QgsMultiBandColorRendererWidget": ["QgsMultiBandColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "create(QgsRasterLayer *layer, const QgsRectangle &extent)"],
    "QgsDefaultVectorLayerLegend": ["QgsDefaultVectorLayerLegend(QgsVectorLayer *vl)"],
    "QgsCptCityAllRampsItem": ["QgsCptCityAllRampsItem(QgsCptCityDataItem *parent, const QString &name, const QVector< QgsCptCityDataItem * > &items)"],
    "QgsSimpleFillSymbolLayerWidget": ["setStrokeColor(const QColor &color)", "setColor(const QColor &color)"],
    "QgsLinearMinMaxEnhancementWithClip": ["QgsLinearMinMaxEnhancementWithClip(Qgis::DataType, double, double)"],
    "QgsDrawSourceWidget": ["create()", "QgsDrawSourceWidget(QWidget *parent=nullptr)"],
    "QgsDiagramSettings": ["LabelPlacementMethod"],
    "QgsAbstractGeometry": ["QgsAbstractGeometry(const QgsAbstractGeometry &geom)"],
    "QgsSingleBandColorDataRenderer": ["QgsSingleBandColorDataRenderer(QgsRasterInterface *input, int band)", "create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsDataItem": ["populate(const QVector< QgsDataItem * > &children)", "rowCount()", "toolTip() const", "deleteLater(QVector< QgsDataItem * > &items)", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "setIcon(const QIcon &icon)", "endRemoveItems()", "type() const", "children() const", "dataChanged(QgsDataItem *item)", "endInsertItems()", "populate(bool foreground=false)", "beginInsertItems(QgsDataItem *parent, int first, int last)", "icon()", "setPath(const QString &path)", "hasChildren()", "findItem(QVector< QgsDataItem * > items, QgsDataItem *item)", "refresh()", "path() const", "setToolTip(const QString &msg)", "childrenCreated()", "setIconName(const QString &iconName)"],
    "QgsRasterShader": ["QgsRasterShader(double minimumValue=0.0, double maximumValue=255.0)", "rasterShaderFunction()", "rasterShaderFunction() const"],
    "QgsMapLayerAction": ["Target"],
    "QgsMeshVariableStrokeWidthButton": ["widgetChanged()"],
    "QgsMeshDatasetGroupTreeModel": ["QgsMeshDatasetGroupTreeModel(QObject *parent=nullptr)", "Roles"],
    "QgsLabelingEngine": ["processProvider(QgsAbstractLabelProvider *provider, QgsRenderContext &context, pal::Pal &p)"],
    "QgsCodeEditor": ["isFixedPitch(const QFont &font)"],
    "QgsAction": ["ActionType"],
    "QgsMeshActiveDatasetGroupTreeView": ["QgsMeshActiveDatasetGroupTreeView(QWidget *parent=nullptr)"],
    "QgsGmlFeatureClass": ["fields()", "QgsGmlFeatureClass(const QString &name, const QString &path)", "geometryAttributes()", "path() const", "fieldIndex(const QString &name)"],
    "QgsRenderContext": ["QgsRenderContext(const QgsRenderContext &rh)"],
    "QgsAbstractFeatureIteratorFromSource": ["QgsAbstractFeatureIteratorFromSource(T *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsMapToolIdentifyFeature": ["featureIdentified(QgsFeatureId)", "featureIdentified(const QgsFeature &)"],
    "QgsProjectFileTransform": ["updateRevision(const QgsProjectVersion &version)", "convertRasterProperties(QDomDocument &doc, QDomNode &parentNode, QDomElement &rasterPropertiesElem, QgsRasterLayer *rlayer)"],
    "QgsMapCanvas": ["setCurrentLayer(QgsMapLayer *layer)"],
    "QgsMeshDatasetGroupListModel": ["variableNames() const", "setDisplayProviderName(bool displayProviderName)", "QgsMeshDatasetGroupListModel(QObject *parent)"],
    "QgsSlopeFilter": ["QgsSlopeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsUniqueValuesConfigDlg": ["QgsUniqueValuesConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsLabelCandidate": ["QgsLabelCandidate(const QRectF &r, double c)"],
    "QgsSymbolRenderContext": ["setFeature(const QgsFeature *f)"],
    "QgsVectorFileWriter::BoolOption": ["BoolOption(const QString &docString, bool defaultValue)"],
    "QgsDerivativeFilter": ["QgsDerivativeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsGpsConnection": ["nmeaSentenceReceived(const QString &substring)", "stateChanged(const QgsGpsInformation &info)", "Status"],
    "QgsPointLocator_VisitorEdgesInRect": ["QgsPointLocator_VisitorEdgesInRect(QgsPointLocator *pl, QgsPointLocator::MatchList &lst, const QgsRectangle &srcRect, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsAttributeTableDelegate": ["setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)"],
    "QgsSmartGroupCondition": ["QgsSmartGroupCondition(int id, QWidget *parent=nullptr)", "removed(int)", "destruct()"],
    "QgsRelationReferenceFactory": ["QgsRelationReferenceFactory(const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar)"],
    "QgsGraduatedSymbolRenderer": ["addClass(QgsSymbol *symbol)", "updateRangeLabel(int rangeIndex, const QString &label)", "sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)", "updateRangeUpperValue(int rangeIndex, double value)", "deleteClass(int idx)", "updateRangeLowerValue(int rangeIndex, double value)", "deleteAllClasses()", "setClassAttribute(const QString &attr)", "classAttribute() const", "sortByValue(Qt::SortOrder order=Qt::AscendingOrder)", "updateRangeSymbol(int rangeIndex, QgsSymbol *symbol)", "QgsGraduatedSymbolRenderer(const QString &attrName=QString(), const QgsRangeList &ranges=QgsRangeList())", "ranges() const", "GraduatedMethod"],
    "ParametricLine": ["setParent(ParametricLine *paral)=0", "add(ParametricLine *pl)=0", "getControlPoly() const =0", "getControlPoint(int number) const =0", "setControlPoly(QVector< QgsPoint * > *cp)=0", "calcPoint(float t, QgsPoint *p)=0", "getDegree() const =0", "calcFirstDer(float t, Vector3D *v)=0", "getParent() const =0", "changeDirection()=0", "calcSecDer(float t, Vector3D *v)=0", "remove(int i)=0"],
    "QgsLayerTreeModel": ["legendNodeData(QgsLayerTreeModelLegendNode *node, int role) const", "removeLegendFromLayer(QgsLayerTreeLayer *nodeLayer)", "disconnectFromLayers(QgsLayerTreeGroup *parentGroup)", "legendNodeFlags(QgsLayerTreeModelLegendNode *node) const", "layerLegendChanged()", "legendNodeRowCount(QgsLayerTreeModelLegendNode *node) const", "legendRootIndex(int row, int column, QgsLayerTreeLayer *nL) const", "nodeVisibilityChanged(QgsLayerTreeNode *node)", "legendIconEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "connectToRootNode()", "legendCleanup()", "disconnectFromRootNode()", "layerNeedsUpdate()", "addLegendToLayer(QgsLayerTreeLayer *nodeL)", "legendNodeIndex(int row, int column, QgsLayerTreeModelLegendNode *node) const", "connectToLayer(QgsLayerTreeLayer *nodeLayer)", "iconGroup()", "Flag", "invalidateLegendMapBasedData()", "nodeRemovedChildren()", "nodeLayerLoaded()", "legendParent(QgsLayerTreeModelLegendNode *legendNode) const", "nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)", "nodeLayerWillBeUnloaded()", "nodeWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendNodeDataChanged()", "legendRootRowCount(QgsLayerTreeLayer *nL) const", "nodeWillAddChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "connectToLayers(QgsLayerTreeGroup *parentGroup)", "indexOfParentLayerTreeNode(QgsLayerTreeNode *parentNode) const", "legendInvalidateMapBasedData()", "disconnectFromLayer(QgsLayerTreeLayer *nodeLayer)", "nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const"],
    "QgsGeometryAreaCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryDescription()", "factoryId()", "QgsGeometryAreaCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsLinearlyInterpolatedDiagramRenderer": ["setClassificationAttributeExpression(const QString &expression)", "setLowerValue(double val)", "setUpperSize(QSizeF s)", "lowerSize() const", "upperValue() const", "setDiagramSettings(const QgsDiagramSettings &s)", "setLowerSize(QSizeF s)", "setClassificationAttributeIsExpression(bool isExpression)", "upperSize() const", "classificationAttributeExpression() const", "classificationAttributeIsExpression() const", "setUpperValue(double val)", "lowerValue() const"],
    "QgsRuleBasedLabelProvider": ["QgsRuleBasedLabelProvider(const QgsRuleBasedLabeling &rules, QgsVectorLayer *layer, bool withFeatureLoop=true)"],
    "QgsMeshDatasetGroupSaveMenu": ["createSaveMenu(int groupIndex, QMenu *parentMenu=nullptr)", "setMeshLayer(QgsMeshLayer *meshLayer)", "datasetGroupSaved(const QString &uri)", "QgsMeshDatasetGroupSaveMenu(QObject *parent=nullptr)"],
    "QgsAdvancedDigitizingCanvasItem": ["QgsAdvancedDigitizingCanvasItem(QgsMapCanvas *canvas, QgsAdvancedDigitizingDockWidget *cadDockWidget)"],
    "QgsGpsDetector": ["advance()", "detected(const QgsGpsInformation &)", "QgsGpsDetector(const QString &portName)", "availablePorts()", "detectionFailed()", "connDestroyed(QObject *)"],
    "QgsCptCitySelectionItem": ["QgsCptCitySelectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "selectionsList() const", "parseXml()"],
    "QgsBlurWidget": ["QgsBlurWidget(QWidget *parent=nullptr)", "create()"],
    "QgsWkbException": ["QgsWkbException(QString const &what)"],
    "QgsMapToolAdvancedDigitizing": ["cadDockWidget() const"],
    "QgsRasterDataProvider": ["identifyFormatName(QgsRaster::IdentifyFormat format)", "colorName(int colorInterpretation) const", "colorTable(int bandNo) const", "identifyFormatToCapability(QgsRaster::IdentifyFormat format)", "identifyFormatLabel(QgsRaster::IdentifyFormat format)", "setUserNoDataValue(int bandNo, const QgsRasterRangeList &noData)", "identifyFormatFromName(const QString &formatName)"],
    "QgsVectorFileWriter::HiddenOption": ["HiddenOption(const QString &value)"],
    "QgsSimpleLineSymbolLayerWidget": ["updatePatternIcon()"],
    "QgsCptCityDataItem": ["info() const", "name() const", "equal(const QgsCptCityDataItem *other)", "paramWidget()", "rowCount()", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "icon(QSize size)", "toolTip() const", "setIcon(const QIcon &icon)", "isPopulated()", "type() const", "children() const", "endRemoveItems()", "Type", "parent() const", "populate()", "findItem(QVector< QgsCptCityDataItem * > items, QgsCptCityDataItem *item)", "endInsertItems()", "setParent(QgsCptCityDataItem *parent)", "handleDrop(const QMimeData *, Qt::DropAction)", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "createChildren()", "icon()", "isValid()", "addChildItem(QgsCptCityDataItem *child, bool refresh=false)", "hasChildren()", "deleteChildItem(QgsCptCityDataItem *child)", "removeChildItem(QgsCptCityDataItem *child)", "shortInfo() const", "acceptDrop()", "refresh()", "path() const", "setToolTip(const QString &msg)", "QgsCptCityDataItem(QgsCptCityDataItem::Type type, QgsCptCityDataItem *parent, const QString &name, const QString &path)", "leafCount() const"],
    "QgsDirectoryParamWidget": ["showHideColumn()", "QgsDirectoryParamWidget(const QString &path, QWidget *parent=nullptr)"],
    "QgsSlider": ["setValue(const QVariant &value)", "variantValue() const", "setSingleStep(const QVariant &step)", "setMaximum(const QVariant &max)", "setMinimum(const QVariant &min)", "valueChanged(const QVariant &)"],
    "QgsTransformWidget": ["create()", "QgsTransformWidget(QWidget *parent=nullptr)"],
    "QgsGeometryTypeCheck": ["factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)", "QgsGeometryTypeCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, int allowedTypes)"],
    "QgsGpsConnectionRegistry": ["connectionList() const"],
    "QgsScopeLogger": ["QgsScopeLogger(const char *file, const char *func, int line)"],
    "QgsRasterLayerRenderer": ["QgsRasterLayerRenderer(QgsRasterLayer *layer, QgsRenderContext &rendererContext)"],
    "QgsRelationReferenceWidget": ["setEmbedForm(bool display)", "init()", "setRelation(const QgsRelation &relation, bool allowNullValue)", "setRelationEditable(bool editable)", "setOpenFormButtonVisible(bool openFormButtonVisible)", "QgsRelationReferenceWidget(QWidget *parent)", "CanvasExtent", "setAllowMapIdentification(bool allowMapIdentification)", "setReadOnlySelector(bool readOnly)"],
    "QgsNetworkAccessManager": ["requestTimedOut(QNetworkReply *)", "QgsNetworkAccessManager(QObject *parent=nullptr)"],
    "QgsActionMenu": ["reinit()", "ActionType"],
    "QgsAttributeTableView": ["repaintRequested(const QModelIndexList &indexes)", "_q_selectRow(int row)", "selectRow(int row)", "setModel(QgsAttributeTableFilterModel *filterModel)", "finished()", "repaintRequested()"],
    "QgsFeatureListViewDelegate": ["setCurrentFeatureEdited(bool state)", "positionToElement(QPoint pos)", "setEditSelectionModel(QItemSelectionModel *editSelectionModel)", "Element", "QgsFeatureListViewDelegate(QgsFeatureListModel *listModel, QObject *parent=nullptr)", "editButtonClicked(QModelIndex &index)", "setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)"],
    "QgsGenericFeatureSelectionManager": ["QgsGenericFeatureSelectionManager(QObject *parent=nullptr)", "QgsGenericFeatureSelectionManager(const QgsFeatureIds &initialSelection, QObject *parent=nullptr)"],
    "QgsUnitSelectionWidget": ["changed()"],
    "QgsPixmapLabel": ["setPixmap(const QPixmap &)"],
    "QgsMeshDatasetGroupProxyModel": ["QgsMeshDatasetGroupProxyModel(QAbstractItemModel *sourceModel)"],
    "QgsSvgSelectorGroupsModel": ["QgsSvgSelectorGroupsModel(QObject *parent)"],
    "QgsEditorWidgetRegistry": ["createSearchWidget(const QString &widgetId, QgsVectorLayer *vl, int fieldIdx, const QVariantMap &config, QWidget *parent, const QgsAttributeEditorContext &context=QgsAttributeEditorContext())"],
    "QgsCharacterSelectorDialog": ["QgsCharacterSelectorDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgsPointLocator": ["rebuildIndex(int maxFeaturesToIndex=-1)", "destroyIndex()"],
    "QgsSimpleMarkerSymbolLayerWidget": ["setColorStroke(const QColor &color)", "setColorFill(const QColor &color)"],
    "QgsPointPatternFillSymbolLayer": ["createFromSld(QDomElement &element)"],
    "QgsRasterLayer": ["showStatusMessage(const QString &message)", "isValidRasterFileName(const QString &fileNameQString)"],
    "QgsVectorLayer": ["setDiagramLayerSettings(const QgsDiagramLayerSettings &s)", "diagramLayerSettings() const", "vectorJoins() const", "diagramRenderer() const"],
    "QgsVectorLayerEditBuffer": ["updateLayerFields()", "featureAdded(QgsFeatureId fid)", "committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)", "committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)", "committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)", "featureDeleted(QgsFeatureId fid)", "attributeAdded(int idx)", "attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)", "attributeDeleted(int idx)", "undoIndexChanged(int index)", "committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)", "committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)", "QgsVectorLayerEditBuffer(QgsVectorLayer *layer)"],
    "QgsMapToolIdentify": ["IdentifyMode", "identifyMessage(const QString &)", "changedRasterResults(QList< QgsMapToolIdentify::IdentifyResult > &)", "Type", "identifyProgress(int, int)", "formatChanged(QgsRasterLayer *layer)"],
    "QgsPaintEffectWidget": ["QgsPaintEffectWidget(QWidget *parent=nullptr)"],
    "QgsGeometryValidator": ["addError(const QgsGeometry::Error &)", "stop()"],
    "QgsGeometrySelfIntersectionCheckError": ["QgsGeometrySelfIntersectionCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsVertexId vertexId, const QgsGeometryUtils::SelfIntersection &intersection)", "intersection() const"],
    "QgsInterpolator": ["QgsInterpolator(const QList< QgsInterpolator::LayerData > &layerData)"],
    "QgsRasterShaderFunction": ["minimumMaximumRange() const", "QgsRasterShaderFunction(double minimumValue=0.0, double maximumValue=255.0)"],
    "QgsCentroidFillSymbolLayer": ["createFromSld(QDomElement &element)", "setPointOnSurface(bool pointOnSurface)", "pointOnSurface() const"],
    "QgsHillshadeFilter": ["QgsHillshadeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat, double lightAzimuth=300, double lightAngle=40)", "lightAngle() const", "setLightAngle(float angle)", "setLightAzimuth(float azimuth)", "lightAzimuth() const"],
    "QgsRendererRulePropsDialog": ["buildExpression()", "rule()", "testFilter()"],
    "QgsAttributeActionPropertiesDialog": ["iconPath() const", "shortTitle() const", "QgsAttributeActionPropertiesDialog(QgsVectorLayer *layer, QWidget *parent=nullptr)", "description() const", "QgsAttributeActionPropertiesDialog(QgsAction::ActionType type, const QString &description, const QString &shortTitle, const QString &iconPath, const QString &actionText, bool capture, const QSet< QString > &actionScopes, const QString &notificationMessage, bool isEnabledOnlyWhenEditable, QgsVectorLayer *layer, QWidget *parent=nullptr)", "capture() const", "type() const", "notificationMessage() const", "actionText() const", "actionScopes() const", "isEnabledOnlyWhenEditable() const"],
    "pal::Layer": ["UpsideDownLabels", "displayAll() const"],
    "QgsExpressionBuilderDialog": ["QgsExpressionBuilderDialog(QgsVectorLayer *layer, const QString &startText=QString(), QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &key=\"generic\", const QgsExpressionContext &context=QgsExpressionContext())", "expressionText()", "setExpressionText(const QString &text)"],
    "QgsSvgMarkerSymbolLayer": ["createFromSld(QDomElement &element)", "strokeWidth() const", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "strokeWidthMapUnitScale() const", "setStrokeWidth(double w)"],
    "QgsCptCityDirectoryItem": ["dataItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "rampsMap()", "dirEntries() const", "QgsCptCityDirectoryItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)"],
    "QgsMapRendererQImageJob": ["QgsMapRendererQImageJob(const QgsMapSettings &settings)"],
    "QgsTransaction": ["QgsTransaction(const QString &connString)"],
    "QgsHeatmapRenderer": ["convertFromRenderer(const QgsFeatureRenderer *renderer)"],
    "QgsAbstractFeatureSource": ["iteratorClosed(QgsAbstractFeatureIterator *it)", "iteratorOpened(QgsAbstractFeatureIterator *it)"],
    "QgsDummyConfigDlg": ["QgsDummyConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent, const QString &description)"],
    "QgsValueRelationConfigDlg": ["QgsValueRelationConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)", "editExpression()"],
    "QgsAttributesFormProperties": ["createAttributeEditorWidget(QTreeWidgetItem *item, QgsAttributeEditorElement *parent, bool forceGroup=true)", "updateButtons()", "init()", "initAvailableWidgetsTree()", "initLayoutConfig()", "initSuppressCombo()", "QgsAttributesFormProperties(QgsVectorLayer *layer, QWidget *parent=nullptr)", "initInitPython()", "FieldPropertiesRoles", "apply()", "initFormLayoutTree()", "loadRelations()"],
    "pal::Pal": ["FnIsCanceled)(void *ctx)"],
    "QgsMarkerLineSymbolLayerWidget": ["setInterval(double val)", "setOffsetAlongLine(double val)"],
    "QgsMeshAvailableDatasetGroupTreeModel": ["QgsMeshAvailableDatasetGroupTreeModel(QObject *parent=nullptr)"],
    "QgsMessageViewer": ["setMessageAsHtml(const QString &msg)", "setCheckBoxState(Qt::CheckState state)", "setCheckBoxQgsSettingsLabel(const QString &label)", "QgsMessageViewer(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags, bool deleteOnClose=true)", "setCheckBoxVisible(bool visible)", "setMessageAsPlainText(const QString &msg)", "checkBoxState()", "setCheckBoxText(const QString &text)"],
    "QgsVectorLayerSaveStyleDialog": ["saveOnlyCurrentStyle() const", "saveToDbSettings() const", "setSaveOnlyCurrentStyle(bool saveCurrentStyle)", "QgsVectorLayerSaveStyleDialog(QgsVectorLayer *layer, QWidget *parent=nullptr)", "styleCategories() const", "stylesWidget()", "currentStyleType() const", "outputFilePath() const"],
    "QgsFillSymbolLayer": ["QgsFillSymbolLayer(bool locked=false)", "angle() const", "setAngle(double angle)"],
    "QgsConnectionPoolGroup": ["initTimer(QObject *parent)", "onConnectionExpired()", "QgsConnectionPoolGroup(const QString &ci)", "release(T conn)", "invalidateConnections()"],
    "QgsVectorLayerFeatureIterator": ["QgsVectorLayerFeatureIterator(QgsVectorLayerFeatureSource *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsSymbolLayerAbstractMetadata": ["type() const", "name() const", "visibleName() const"],
    "QgsGeometryTypeCheckError": ["QgsGeometryTypeCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsWkbTypes::Type flatType)"],
    "QgsVectorLayerProperties": ["QgsVectorLayerProperties(QgsMapCanvas *canvas, QgsMessageBar *messageBar, QgsVectorLayer *lyr=nullptr, QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)", "StyleType", "exportAuxiliaryLayer(QgsAuxiliaryLayer *layer)", "toggleEditing(QgsMapLayer *)"],
    "QgsCptCityArchive": ["isEmpty()", "rootItems() const", "clearArchives()", "initArchive(const QString &archiveName, const QString &archiveBaseDir)", "initArchives(bool loadAll=false)", "descFileName(const QString &dirName) const", "copyingFileName(const QString &dirName) const", "copyingInfo(const QString &fileName)", "baseDir(QString archiveName)", "QgsCptCityArchive(const QString &archiveName=DEFAULT_CPTCITY_ARCHIVE, const QString &baseDir=QString())", "archiveName() const", "description(const QString &fileName)", "setBaseDir(const QString &dirName)", "initDefaultArchive()", "findFileName(const QString &target, const QString &startDir, const QString &baseDir)", "baseDir() const", "defaultBaseDir()", "defaultArchive()", "archiveRegistry()", "selectionItems() const"],
    "QgsVectorLayerCache": ["QgsVectorLayerCache(QgsVectorLayer *layer, int cacheSize, QObject *parent=nullptr)"],
    "QgsMeshRendererMeshSettingsWidget": ["MeshType"],
    "QgsLayerTreeNode": ["QgsLayerTreeNode(const QgsLayerTreeNode &other)"],
    "QgsRasterResampleFilter": ["zoomedInResampler() const", "maxOversampling() const", "zoomedOutResampler() const", "QgsRasterResampleFilter(QgsRasterInterface *input=nullptr)", "setMaxOversampling(double os)"],
    "QgsRuleBasedRenderer": ["FeatureFlags", "rootRule()", "createFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType)"],
    "QgsRangeConfigDlg": ["QgsRangeConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)", "rangeWidgetChanged(int index)"],
    "QgsManageConnectionsDialog": ["doExportImport()", "selectionChanged()", "clearSelection()", "Type", "selectAll()", "Mode"],
    "QgsRelationReferenceConfigDlg": ["QgsRelationReferenceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsColorBrewerPalette": ["listSchemeColors(const QString &schemeName, int colors)", "listSchemeVariants(const QString &schemeName)", "listSchemes()"],
    "QgsGeometryHoleCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)", "QgsGeometryHoleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsGeometrySliverPolygonCheck": ["factoryDescription()", "factoryId()", "QgsGeometrySliverPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsWmsDimensionDialog": ["setInfo(const QgsMapLayerServerProperties::WmsDimensionInfo &info)", "info() const", "QgsWmsDimensionDialog(QgsVectorLayer *layer, QStringList alreadyDefinedDimensions, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags())"],
    "QgsHueSaturationFilter": ["saturation() const", "colorizeColor() const", "colorizeStrength() const", "colorizeOn() const", "setColorizeColor(const QColor &colorizeColor)", "QgsHueSaturationFilter(QgsRasterInterface *input=nullptr)", "setColorizeOn(bool colorizeOn)", "setGrayscaleMode(QgsHueSaturationFilter::GrayscaleMode grayscaleMode)", "grayscaleMode() const", "setColorizeStrength(int colorizeStrength)", "GrayscaleMode", "setSaturation(int saturation)"],
    "QgsMultiBandColorRenderer": ["setRedBand(int band)", "create(const QDomElement &elem, QgsRasterInterface *input)", "blueBand() const", "setBlueBand(int band)", "greenBand() const", "redBand() const", "setGreenBand(int band)", "QgsMultiBandColorRenderer(QgsRasterInterface *input, int redBand, int greenBand, int blueBand, QgsContrastEnhancement *redEnhancement=nullptr, QgsContrastEnhancement *greenEnhancement=nullptr, QgsContrastEnhancement *blueEnhancement=nullptr)"],
    "QgsSymbolLayer": ["drawPreviewIcon(QgsSymbolRenderContext &context, QSize size)=0", "setMapUnitScale(const QgsMapUnitScale &scale)", "type() const", "mapUnitScale() const", "ogrFeatureStyle(double mmScaleFactor, double mapUnitScaleFactor) const"],
    "QgsFeatureListView": ["repaintRequested(const QModelIndexList &indexes)", "repaintRequested()"],
    "QgsLayerTreeViewDefaultActions": ["zoomToGroup(QgsMapCanvas *canvas)", "zoomToLayers(QgsMapCanvas *canvas, const QList< QgsMapLayer * > &layers)", "actionRemoveGroupOrLayer(QObject *parent=nullptr)", "removeGroupOrLayer()", "actionShowFeatureCount(QObject *parent=nullptr)", "actionAddGroup(QObject *parent=nullptr)", "actionShowInOverview(QObject *parent=nullptr)", "showInOverview()", "actionZoomToGroup(QgsMapCanvas *canvas, QObject *parent=nullptr)", "addGroup()", "actionRenameGroupOrLayer(QObject *parent=nullptr)", "QgsLayerTreeViewDefaultActions(QgsLayerTreeView *view)", "zoomToGroup()", "renameGroupOrLayer()", "showFeatureCount()", "actionGroupSelected(QObject *parent=nullptr)", "uniqueGroupName(QgsLayerTreeGroup *parentGroup)", "groupSelected()"],
    "QgsZipItem": ["iconZip()", "vsiPrefix(const QString &uri)", "getZipFileList()"],
    "QgsSublayersDialog": ["ProviderType"],
    "QgsBusyIndicatorDialog": ["setMessage(const QString &message)", "message() const"],
    "QgsRasterRenderer": ["usesTransparency() const", "setRasterTransparency(QgsRasterTransparency *t)", "setAlphaBand(int band)", "type() const", "rasterTransparency() const", "alphaBand() const"],
    "QgsDxfExport": ["SymbologyExport"],
    "QgsRendererRange": ["renderState() const", "label() const", "setLabel(const QString &label)", "upperValue() const", "swap(QgsRendererRange &other)", "setSymbol(QgsSymbol *s)", "setUpperValue(double upperValue)", "symbol() const", "QgsRendererRange(const QgsRendererRange &range)", "QgsRendererRange(double lowerValue, double upperValue, QgsSymbol *symbol, const QString &label, bool render=true)", "setLowerValue(double lowerValue)", "dump() const", "setRenderState(bool render)", "operator<(const QgsRendererRange &other) const", "lowerValue() const"],
    "QgsExpressionFieldBuffer": ["expressions() const"],
    "QgsLabelSorter": ["QgsLabelSorter(const QgsMapSettings &mapSettings)", "operator()(pal::LabelPosition *lp1, pal::LabelPosition *lp2) const"],
    "QgsNineCellFilter": ["outputNodataValue() const", "cellSizeX() const", "setCellSizeX(double size)", "setCellSizeY(double size)", "zFactor() const", "cellSizeY() const", "inputNodataValue() const", "setZFactor(double factor)", "setInputNodataValue(double value)", "setOutputNodataValue(double value)"],
    "HalfEdge": ["HalfEdge(int dual, int next, int point, bool mbreak, bool forced)"],
    "QgsEffectDrawModeComboBox": ["QgsEffectDrawModeComboBox(QWidget *parent SIP_TRANSFERTHIS=nullptr)"],
    "QgsRasterRendererRegistry": ["insert(const QgsRasterRendererRegistryEntry &entry)", "insertWidgetFunction(const QString &rendererName, QgsRasterRendererWidgetCreateFunc func)", "renderersList() const", "entries() const", "rendererData(const QString &rendererName, QgsRasterRendererRegistryEntry &data) const"],
    "QgsMeshDatasetGroupTreeView": ["deselectAllGroups()", "selectAllGroups()", "QgsMeshDatasetGroupTreeView(QWidget *parent=nullptr)", "apply()", "syncToLayer(QgsMeshLayer *layer)", "resetDefault(QgsMeshLayer *meshLayer)", "datasetGroupTreeRootItem()"],
    "QgsVectorLayerLegendWidget": ["QgsVectorLayerLegendWidget(QWidget *parent=nullptr)"],
    "QgsVectorLayerRenderer": ["QgsVectorLayerRenderer(QgsVectorLayer *layer, QgsRenderContext &context)"],
    "QgsMapLayer": ["readSld(const QDomNode &node, QString &errorMessage)"],
    "QgsOptionsDialogBase": ["setSettings(QgsSettings *settings)", "updateWindowTitle()", "warnAboutMissingObjects()"],
    "QgsSymbolLayerWidget": ["updateDataDefinedProperty()", "setSymbolLayer(QgsSymbolLayer *layer)=0", "symbolLayer()=0"],
    "QgsVectorLayerJoinBuffer": ["vectorJoins() const", "QgsVectorLayerJoinBuffer(QgsVectorLayer *layer=nullptr)"],
    "QgsCredentials": ["getMasterPassword(QString &password, bool stored=false)"],
    "QgsAttributeForm": ["QgsAttributeForm(QgsVectorLayer *vl, const QgsFeature &feature=QgsFeature(), const QgsAttributeEditorContext &context=QgsAttributeEditorContext(), QWidget *parent=nullptr)", "feature()"],
    "QgsGraduatedSymbolRendererWidget": ["graduatedColumnChanged(const QString &field)", "modelDataChanged()", "findSymbolForRange(double lowerBound, double upperBound, const QgsRangeList &ranges) const", "connectUpdateHandlers()", "classifyGraduated()", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "selectedRanges()", "disconnectUpdateHandlers()", "rangesDoubleClicked(const QModelIndex &idx)", "labelFormatChanged()", "reapplyColorRamp()", "changeRange(int rangeIdx)", "changeCurrentValue(QStandardItem *item)", "QgsGraduatedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "changeRangeSymbol(int rangeIdx)", "reapplySizes()", "updateUiFromRenderer(bool updateCount=true)", "rowsMoved()", "showSymbolLevels()", "rowsOrdered()", "rangesClicked(const QModelIndex &idx)", "changeSelectedSymbols()"],
    "QgsRasterCalcNode": ["QgsRasterCalcNode(const QString &rasterName)", "parseRasterCalcString(const QString &str, QString &parserErrorMsg)", "QgsRasterCalcNode(Operator op, QgsRasterCalcNode *left, QgsRasterCalcNode *right)", "QgsRasterCalcNode(double number)", "setRight(QgsRasterCalcNode *right)", "type() const", "setLeft(QgsRasterCalcNode *left)", "QgsRasterCalcNode(QgsRasterMatrix *matrix)"],
    "QgsPluginLayer": ["QgsPluginLayer(const QString &layerType, const QString &layerName=QString())"],
    "QgsGlowEffect": ["QgsGlowEffect(const QgsGlowEffect &other)"],
    "QgsMapToolEdit": ["createGeometryRubberBand(QgsWkbTypes::GeometryType geometryType=QgsWkbTypes::LineGeometry, bool alternativeBand=false) const", "QgsMapToolEdit(QgsMapCanvas *canvas)"],
    "QgsMeshDatasetGroupTreeWidget": ["datasetGroupAdded()"],
    "QgsMimeDataUtils": ["decodeUriList(const QMimeData *data)", "isUriList(const QMimeData *data)"],
    "QgsTextDiagram": ["Shape", "Orientation"],
    "QgsGeometryAngleCheck": ["QgsGeometryAngleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "CharacterWidget": ["updateFontMerging(bool enable)"],
    "QgsAuthMethodConfig": ["setMethod(const QString &method)", "setUri(const QString &uri)"],
    "QgsAbstractLabelProvider": ["Flag"],
    "QgsCheckBoxConfigDlg": ["QgsCheckBoxConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsAttributeTableModel": ["Role", "idToIndex(QgsFeatureId id) const", "finished()", "idToIndexList(QgsFeatureId id) const"],
    "QgsConditionalStyle": ["QgsConditionalStyle(const QString &rule)", "QgsConditionalStyle(const QgsConditionalStyle &other)"],
    "CloughTocherInterpolator": ["setTriangulation(NormVecDecorator *tin)"],
    "QgsGeometryDuplicateCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "QgsGeometryDuplicateCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsMasterPasswordResetDialog": ["requestMasterPasswordReset(QString *newpass, QString *oldpass, bool *keepbackup)", "QgsMasterPasswordResetDialog(QWidget *parent=nullptr)"],
    "QgsSnappingUtils": ["mapSettings() const", "IndexingStrategy"],
    "QgsGeometryLineLayerIntersectionCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometryLineLayerIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsLinearMinMaxEnhancement": ["QgsLinearMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsGeometryMultipartCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometryMultipartCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsCategorizedSymbolRendererWidget": ["addCategories()", "QgsCategorizedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "categoriesDoubleClicked(const QModelIndex &idx)", "selectedCategoryList()", "addCategory()", "deleteAllCategories()", "populateCategories()", "updateUiFromRenderer()", "rowsMoved()", "deleteCategories()", "showSymbolLevels()", "changeCategorySymbol()", "changeCategorizedSymbol()", "categoryColumnChanged(const QString &field)"],
    "QgsColorSwatchDelegate": ["QgsColorSwatchDelegate(QWidget *parent=nullptr)"],
    "QgsAlignRaster": ["setGridOffset(QPointF offset)", "gridOffset() const"],
    "QgsDxfPaintEngine": ["setLayer(const QString &layer)", "layer() const", "setShift(QPointF shift)", "QgsDxfPaintEngine(const QgsDxfPaintDevice *dxfDevice, QgsDxfExport *dxf)"],
    "QgsMapLayerComboBox": ["indexChanged(int i)", "rowsChanged()"],
    "QgsFieldComboBox": ["indexChanged(int i)"],
    "QgsCategorizedSymbolRenderer": ["rebuildHash()"],
    "QgsRasterMatrix": ["setNodataValue(double d)", "lesserEqual(const QgsRasterMatrix &other)", "tangens()", "squareRoot()", "changeSign()", "logicalAnd(const QgsRasterMatrix &other)", "nodataValue() const", "log()", "number() const", "sinus()", "divide(const QgsRasterMatrix &other)", "atangens()", "asinus()", "greaterEqual(const QgsRasterMatrix &other)", "acosinus()", "cosinus()", "nColumns() const", "TwoArgOperator", "logicalOr(const QgsRasterMatrix &other)", "setData(int cols, int rows, double *data, double nodataValue)", "QgsRasterMatrix(const QgsRasterMatrix &m)", "lesserThan(const QgsRasterMatrix &other)", "OneArgOperator", "log10()", "nRows() const", "power(const QgsRasterMatrix &other)", "equal(const QgsRasterMatrix &other)", "multiply(const QgsRasterMatrix &other)", "greaterThan(const QgsRasterMatrix &other)", "notEqual(const QgsRasterMatrix &other)"],
    "QgsShapeburstFillSymbolLayer": ["setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "distanceMapUnitScale() const", "offsetMapUnitScale() const"],
    "QgsPenStyleComboBox": ["QgsPenStyleComboBox(QWidget *parent=nullptr)", "penStyle() const", "iconForPen(Qt::PenStyle style)", "setPenStyle(Qt::PenStyle style)"],
    "QgsGeometryCheckerUtils": ["canDeleteVertex(const QgsAbstractGeometry *geom, int iPart, int iRing)", "createGeomEngine(const QgsAbstractGeometry *geometry, double tolerance)", "polygonRings(const QgsPolygon *polygon)", "sharedEdgeLength(const QgsAbstractGeometry *geom1, const QgsAbstractGeometry *geom2, double tol)", "lineIntersections(const QgsLineString *line1, const QgsLineString *line2, double tol)", "getGeomPart(QgsAbstractGeometry *geom, int partIdx)", "pointOnLine(const QgsPoint &p, const QgsLineString *line, double tol, bool excludeExtremities=false)", "filter1DTypes(QgsAbstractGeometry *geom)", "getGeomPart(const QgsAbstractGeometry *geom, int partIdx)"],
    "QgsBrowserTreeView": ["hasExpandedDescendant(const QModelIndex &index) const", "setSettingsSection(const QString &section)"],
    "QgsAttributesFormInitCode": ["initFunction() const", "setCodeSource(QgsEditFormConfig::PythonInitCodeSource initCodeSourceComboBoxIndex)", "codeSource() const", "initFilePath() const", "setInitCode(const QString &initCode)", "setInitFilePath(const QString &initFilePath)", "initCode() const", "setInitFunction(const QString &initFunction)"],
    "QgsLinePatternFillSymbolLayer": ["ogrFeatureStyleWidth(double widthScaleFactor) const"],
    "QgsStyleManagerDialog": ["currentItemName()", "editSymbol()", "editColorRamp()", "currentItemType()"],
    "QgsSearchQueryBuilder": ["loadQuery()", "saveQuery()"],
    "QgsLegendSymbolItem": ["QgsLegendSymbolItem(const QgsLegendSymbolItem &other)"],
    "QgsLayerTreeRegistryBridge": ["setEnabled(bool enabled)", "isEnabled() const", "groupRemovedChildren()", "layersAdded(const QList< QgsMapLayer * > &layers)", "setNewLayersVisible(bool enabled)", "layersWillBeRemoved(const QStringList &layerIds)", "groupWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "newLayersVisible() const", "removeLayersFromRegistry(const QStringList &layerIds)"],
    "QgsRuleBasedRendererModel": ["removeRule(const QModelIndex &index)", "clearFeatureCounts()", "insertRule(const QModelIndex &parent, int before, QgsRuleBasedRenderer::Rule *newrule)", "updateRule(const QModelIndex &parent, int row)", "willAddRules(const QModelIndex &parent, int count)", "updateRule(const QModelIndex &index)", "finishedAddingRules()", "ruleForIndex(const QModelIndex &index) const"],
    "QgsFields": ["FieldOrigin"],
    "QgsFeatureModel": ["fidToIndex(QgsFeatureId fid)=0"],
    "QgsTextEditConfigDlg": ["QgsTextEditConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsSymbolsListWidget": ["clipFeaturesToggled(bool checked)", "updateDataDefinedLineWidth()", "setMarkerSize(double size)", "changed()", "updateDataDefinedMarkerSize()", "updateDataDefinedMarkerAngle()", "setLineWidth(double width)", "setSymbolColor(const QColor &color)", "setMarkerAngle(double angle)"],
    "QgsAttributeTableAction": ["featureForm()", "execute()"],
    "QgsAttributeTypeLoadDialog": ["QgsAttributeTypeLoadDialog(QgsVectorLayer *vl)"],
    "QgsAuthCertInfo": ["trustCacheRebuilt()"],
    "QgsRendererCategory": ["swap(QgsRendererCategory &other)"],
    "QgsMapRendererJob": ["QgsMapRendererJob(const QgsMapSettings &settings)"],
    "QgsFieldCalculator": ["mOutputFieldTypeComboBox_activated(int index)", "mCreateVirtualFieldCheckbox_stateChanged(int state)", "QgsFieldCalculator(QgsVectorLayer *vl, QWidget *parent=nullptr)", "mUpdateExistingGroupBox_toggled(bool on)", "mNewFieldGroupBox_toggled(bool on)", "changedAttributeId() const", "mOutputFieldNameLineEdit_textChanged(const QString &text)"],
    "QgsWkbPtr": ["operator>>(float &r) const", "operator unsigned char *() const", "operator>>(int &v) const", "operator>>(unsigned int &v) const", "operator+=(int n)", "operator>>(char &v) const", "QgsWkbPtr(unsigned char *p, int size)", "operator>>(QgsWkbTypes::Type &v) const", "operator>>(double &v) const"],
    "QgsLayerTreeMapCanvasBridge": ["autoSetupOnFirstLayer() const", "rootGroup() const", "mapCanvas() const"],
    "QgsGeometrySegmentLengthCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometrySegmentLengthCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsGeometryDuplicateNodesCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometryDuplicateNodesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsLUDialog": ["QgsLUDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)", "upperValue() const", "setUpperValue(const QString &val)", "setLowerValue(const QString &val)", "lowerValue() const"],
    "QgsIFeatureSelectionManager": ["QgsIFeatureSelectionManager(QObject *parent)"],
    "QgsAttributeEditorContext": ["QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, FormMode formMode)", "parentContext() const", "FormMode", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, const QgsRelation &relation, RelationMode relationMode, FormMode widgetMode)"],
    "QgsGeometryRubberBand": ["QgsGeometryRubberBand(QgsMapCanvas *mapCanvas, QgsWkbTypes::GeometryType geomType=QgsWkbTypes::LineGeometry)", "IconType"],
    "QgsExpressionHighlighter": ["addFields(const QStringList &fieldList)", "QgsExpressionHighlighter(QTextDocument *parent=nullptr)"],
    "QgsErrorMessage": ["tag() const", "message() const", "line() const", "file() const", "function() const"],
    "QgsSingleSymbolRendererWidget": ["create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "QgsSingleSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsPaintEngineHack": ["fixFlags()", "fixEngineFlags(QPaintEngine *engine)"],
    "QgsCompoundCurve": ["QgsCompoundCurve(const QgsCompoundCurve &curve)"],
    "QgsDateTimeEditConfig": ["QgsDateTimeEditConfig(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsShapeburstFillSymbolLayerWidget": ["setColor2(const QColor &color)", "setColor(const QColor &color)"],
    "QgsGroupBoxCollapseButton": ["QgsGroupBoxCollapseButton(QWidget *parent=nullptr)", "setShiftDown(bool shiftdown)", "setAltDown(bool updown)", "shiftDown() const", "altDown() const"],
    "QgsSimplifyMethod": ["MethodType"],
    "pal::Problem": ["reduce()", "init_sol_falp()"],
    "QgsLayerTreeView": ["onModelReset()", "modelRowsRemoved()", "onExpandedChanged(QgsLayerTreeNode *node, bool expanded)", "updateExpandedStateFromNode(QgsLayerTreeNode *node)", "layerForIndex(const QModelIndex &index) const", "modelRowsInserted(const QModelIndex &index, int start, int end)", "onCurrentChanged()", "updateExpandedStateToNode(const QModelIndex &index)"],
    "QgsErrorItem": ["QgsErrorItem(QgsDataItem *parent, const QString &error, const QString &path)"],
    "QgsCPLErrorHandler": ["QgsCPLErrorHandler(const QgsCPLErrorHandler &other)=delete"],
    "QgsRasterBlock": ["applyNoDataValues(const QgsRasterRangeList &rangeList)", "toString() const"],
    "QgsMapRendererSequentialJob": ["QgsMapRendererSequentialJob(const QgsMapSettings &settings)", "internalFinished()"],
    "QgsGeometryDegeneratePolygonCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "QgsGeometryDegeneratePolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "EditBlockerDelegate": ["EditBlockerDelegate(QObject *parent=nullptr)"],
    "QgsRaster": ["RasterPyramidsFormat", "IdentifyFormat", "ColorInterpretation", "RasterBuildPyramids", "RasterProgressType"],
    "QgsSingleBandGrayRenderer": ["Gradient", "setGrayBand(int band)", "contrastEnhancement() const", "gradient() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "setGradient(Gradient gradient)", "grayBand() const", "QgsSingleBandGrayRenderer(QgsRasterInterface *input, int grayBand)"],
    "QgsFontMarkerSymbolLayerWidget": ["setFontFamily(const QFont &font)", "setColor(const QColor &color)", "setSize(double size)", "setAngle(double angle)"],
    "QgsFieldValidator": ["QgsFieldValidator(QObject *parent, const QgsField &field, const QString &defaultValue, const QString &dateFormat=\"yyyy-MM-dd\")", "dateFormat() const"],
    "QgsRenderChecker": ["setElapsedTimeTarget(int target)", "setControlPathSuffix(const QString &name)"],
    "QgsDataCollectionItem": ["addChild(QgsDataItem *item)"],
    "QgsExpressionItem": ["getExpressionText() const", "QgsExpressionItem(const QString &label, const QString &expressionText, const QString &helpText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "ItemType", "QgsExpressionItem(const QString &label, const QString &expressionText, QgsExpressionItem::ItemType itemType=ExpressionNode)"],
    "QgsAttributesDnDTree": ["QgsAttributesDnDTree(QgsVectorLayer *layer, QWidget *parent=nullptr)", "addContainer(QTreeWidgetItem *parent, const QString &title, int columnCount)", "type() const", "Type", "setType(QgsAttributesDnDTree::Type value)", "selectFirstMatchingItem(const QgsAttributesFormProperties::DnDTreeItemData &data)"],
    "QgsVectorFileWriter": ["setSymbologyExport(QgsVectorFileWriter::SymbologyExport symExport)", "OptionType", "WriterError", "driverMetadata(const QString &driverName, MetaData &driverMetadata)", "symbologyExport() const", "SymbologyExport"],
    "QgsMapLayerLegendUtils": ["legendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "hasLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "setLegendNodeOrder(QgsLayerTreeLayer *nodeLayer, const QList< int > &order)", "setLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex, const QString &newLabel)", "legendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "hasLegendNodeOrder(QgsLayerTreeLayer *nodeLayer)"],
    "QgsDataDefinedRotationDialog": ["QgsDataDefinedRotationDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsDetailedItemDelegate": ["verticalSpacing() const", "setHorizontalSpacing(int value)", "setVerticalSpacing(int value)", "horizontalSpacing() const"],
    "QgsMapOverviewCanvas": ["QgsMapOverviewCanvas(QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)", "mapRenderingFinished()", "enableAntiAliasing(bool flag)", "updateFullExtent()"],
    "QgsDiagram": ["clearCache()", "QgsDiagram(const QgsDiagram &other)"],
    "QgsGeometryDangleCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "QgsGeometryDangleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsRasterMinMaxWidget": ["setBands(const QList< int > &bands)"],
    "QgsGml": ["QgsGml(const QString &typeName, const QString &geometryAttribute, const QgsFields &fields)", "dataReadProgress(int progress)", "totalStepsUpdate(int totalSteps)"],
    "QgsRendererWidget": ["paste()", "QgsRendererWidget(QgsVectorLayer *layer, QgsStyle *style)", "refreshSymbolView()", "contextMenuViewCategories(QPoint p)", "copy()"],
    "QgsVectorFieldSymbolLayer": ["AngleOrientation", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "createFromSld(QDomElement &element)", "setScale(double s)", "AngleUnits", "setVectorFieldType(VectorFieldType type)", "VectorFieldType", "setAngleOrientation(AngleOrientation orientation)", "scale() const", "xAttribute() const", "setYAttribute(const QString &attribute)", "setAngleUnits(AngleUnits units)", "angleUnits() const", "angleOrientation() const", "setXAttribute(const QString &attribute)", "yAttribute() const", "distanceMapUnitScale() const", "vectorFieldType() const"],
    "QgsCptCityCollectionItem": ["childrenRamps(bool recursive)", "QgsCptCityCollectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "setPopulated()", "addChild(QgsCptCityDataItem *item)"],
    "QgsRuggednessFilter": ["QgsRuggednessFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsGeometryDuplicateCheckError": ["duplicates() const", "QgsGeometryDuplicateCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QMap< QString, QgsFeaturePool * > &featurePools, const QMap< QString, QList< QgsFeatureId >> &duplicates)"],
    "QgsStyleExportImportDialog": ["doExportImport()", "importTypeChanged(int)"],
    "pal::PriorityQueue": ["decreaseKey(int key)", "insert(int key, double p)", "getId(int key)", "getSizeByPos()", "upheap(int key)", "print()", "setPriority(int key, double new_p)", "getSize()", "downheap(int id)", "remove(int key)", "sort()", "getBest()", "isIn(int key)"],
    "QgsAspectFilter": ["QgsAspectFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsTotalCurvatureFilter": ["QgsTotalCurvatureFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsDualView": ["openConditionalStyles()"],
    "QgsDial": ["setValue(const QVariant &value)", "variantValue() const", "setSingleStep(const QVariant &step)", "setMaximum(const QVariant &max)", "setMinimum(const QVariant &min)", "valueChanged(const QVariant &)"],
    "QgsCptCityColorRampItem": ["ramp() const", "init()", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QStringList &variantList, bool initialize=false)", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QString &variantName=QString(), bool initialize=false)"],
    "QgsClipper": ["trimPolygon(QPolygonF &pts, const QgsRectangle &clipRect)"],
    "QgsVectorFileWriter::IntOption": ["IntOption(const QString &docString, int defaultValue)"],
    "QgsPointDisplacementRendererWidget": ["create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "QgsPointDisplacementRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsLayerTreeModelLegendNode": ["userLabel() const", "setEmbeddedInParent(bool embedded)", "isEmbeddedInParent() const", "isScaleOK(double scale) const", "setUserLabel(const QString &userLabel)"],
    "QgsCacheIndexFeatureId": ["QgsCacheIndexFeatureId(QgsVectorLayerCache *)"],
    "QgsXmlUtils": ["readRectangle(const QDomElement &element)"],
    "QgsGeometryPointCoveredByLineCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometryPointCoveredByLineCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsShadowEffectWidget": ["QgsShadowEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsPalLayerSettings": ["QuadrantPosition", "UpsideDownLabels", "MultiLineAlign", "QgsPalLayerSettings(const QgsPalLayerSettings &s)"],
    "QgsContrastEnhancementFunction": ["QgsContrastEnhancementFunction(Qgis::DataType, double, double)", "QgsContrastEnhancementFunction(const QgsContrastEnhancementFunction &f)"],
    "QgsGeometryFollowBoundariesCheck": ["factoryCompatibleGeometryTypes()", "QgsGeometryFollowBoundariesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, QgsVectorLayer *checkLayer)", "factoryCheckType()", "factoryDescription()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsMapLayerModel": ["removeLayers(const QStringList &layerIds)", "addLayers(const QList< QgsMapLayer * > &layers)"],
    "QgsEllipseSymbolLayer": ["setSymbolWidth(double w)", "symbolWidth() const", "createFromSld(QDomElement &element)", "setSymbolHeight(double h)", "symbolHeightMapUnitScale() const", "strokeWidth() const", "symbolWidthMapUnitScale() const", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "strokeStyle() const", "setStrokeWidth(double w)", "strokeWidthMapUnitScale() const", "setSymbolHeightMapUnitScale(const QgsMapUnitScale &scale)", "setStrokeStyle(Qt::PenStyle strokeStyle)", "symbolHeight() const", "setSymbolWidthMapUnitScale(const QgsMapUnitScale &scale)"],
    "QgsQueryBuilder": ["clear()", "setDatasourceDescription(const QString &uri)"],
    "QgsSmartGroupEditorDialog": ["QgsSmartGroupEditorDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsVectorLayerEditUtils": ["QgsVectorLayerEditUtils(QgsVectorLayer *layer)"],
    "QgsExpression": ["Functions()", "BuiltinFunctions()", "SpatialOperator"],
    "QgsPythonRunner": ["evalCommand(QString command, QString &result)=0", "runCommand(QString command, QString messageOnError=QString())=0"],
    "QgsSvgSelectorWidget": ["populateList()", "currentSvgPath() const", "svgSelected(const QString &path)"],
    "QgsAttributeFormLegacyInterface": ["QgsAttributeFormLegacyInterface(const QString &function, const QString &pyFormName, QgsAttributeForm *form)"],
    "pal::Util": ["unmulti(const GEOSGeometry *the_geom)"],
    "QgsContrastEnhancement": ["writeXml(QDomDocument &doc, QDomElement &parentElem) const", "QgsContrastEnhancement(const QgsContrastEnhancement &ce)", "contrastEnhancementAlgorithm() const", "readXml(const QDomElement &elem)"],
    "QgsRasterRendererWidget": ["stdDev()", "selectedBand(int index=0)", "max(int index=0)", "setStdDev(const QString &value)", "setMin(const QString &value, int index=0)", "setMax(const QString &value, int index=0)", "QgsRasterRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent)", "min(int index=0)"],
    "QgsSymbolLevelItem": ["QgsSymbolLevelItem(QgsSymbol *symbol, int layer)"],
    "QgsPaintEffect": ["QgsPaintEffect(const QgsPaintEffect &other)"],
    "QgsRendererAbstractMetadata": ["createRendererFromSld(QDomElement &elem, QgsWkbTypes::GeometryType geomType)"],
    "QgsPenJoinStyleComboBox": ["QgsPenJoinStyleComboBox(QWidget *parent=nullptr)", "penJoinStyle() const", "setPenJoinStyle(Qt::PenJoinStyle style)"],
    "QgsRasterBandStats": ["Stats"],
    "QgsPalettedRasterRenderer": ["create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsFieldExpressionWidget": ["currentFieldChanged()", "setLeftHandButtonStyle(bool isLeft)", "isExpressionValid(const QString &expressionStr)"],
    "QgsDirectoryItem": ["directoryChanged()", "init()"],
    "QgsSymbolLevelsDialog": ["setForceOrderingEnabled(bool enabled)"],
    "QgsEffectStack": ["QgsEffectStack(const QgsEffectStack &other)"],
    "pal::FeaturePart": ["FeaturePart(const FeaturePart &other)"],
    "QgsGeometryLineIntersectionCheck": ["factoryCompatibleGeometryTypes()", "ResolutionMethod", "factoryCheckType()", "factoryDescription()", "factoryId()", "QgsGeometryLineIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsAttributeTableMapLayerAction": ["QgsAttributeTableMapLayerAction(const QString &name, QgsDualView *dualView, QgsMapLayerAction *action, const QModelIndex &fieldIdx)", "execute()"],
    "QgisVisitor": ["QgisVisitor(QList< QgsFeatureId > &list)"],
}

ACCEPTABLE_MISSING_ADDED_NOTE = [
    'QgsAuthConfigIdEdit',
    'QgsDial',
    'QgsMapLayerAction',
    'QgsSvgSelectorGroupsModel',
    'QgsLinePatternFillSymbolLayer',
    'QgsImageFillSymbolLayer',
    'QgsAuthMethodRegistry',
    'QgsExpressionNodeFunction',
    'QgsSQLStatement::Visitor',
    'QgsDiagramLayerSettings',
    'QgsRenderChecker',
    'QgsSQLStatement::NodeColumnSorted',
    'pal::FeaturePart',
    'QgsRasterResampleFilter',
    'QgsPluginManagerInterface',
    'QgsAttributes',
    'QgsRangeWidgetFactory',
    'QgsMarkerSymbol',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsAspectFilter',
    'QgsValueRelationConfigDlg',
    'QgsOgcUtils',
    'QgsGeometryMultipartCheck',
    'QgsFillSymbol',
    'QgsArrowSymbolLayerWidget',
    'QgsDataDefinedValueDialog',
    'QgsCheckboxWidgetFactory',
    'QgisVisitor',
    'QgsVectorLayerFeatureSource',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsPaintEngineHack',
    'QgsFieldExpressionWidget',
    'QgsGradientFillSymbolLayer',
    'QgsValueRelationSearchWidgetWrapper',
    'QgsMasterPasswordResetDialog',
    'QgsPointPatternFillSymbolLayer',
    'QgsDerivativeFilter',
    'QgsSymbolLayerMetadata',
    'QgsGpsConnection',
    'QgsAbstractFeatureIteratorFromSource',
    'QgsDiagramLabelFeature',
    'QgsRasterDataProvider',
    'QgsSymbolLayer',
    'QgsGpsInformation',
    'QgsActionManager',
    'QgsLUDialog',
    'QgsPointLocator_DumpTree',
    'QgsExpressionNodeBinaryOperator',
    'QgsErrorMessage',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsAuthMethodEdit',
    'QgsGenericFeatureSelectionManager',
    'QgsSQLComposerDialog::TableSelectedCallback',
    'QgsAbstractCacheIndex',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsExternalResourceWidgetWrapper',
    'QgsRuntimeProfiler',
    'QgsRasterLayer',
    'QgsMarkerSymbolLayer',
    'QgsAdvancedDigitizingDockWidget::CadConstraint',
    'QgsScaleCalculator',
    'QgsRelation',
    'QgsDiagramRenderer',
    'QgsAttributeEditorRelation',
    'QgsSymbolLevelsDialog',
    'QgsRasterRenderer',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsRenderContext',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsConnectionPool',
    'QgsProjectBadLayerHandler',
    'QgsMarkerLineSymbolLayer',
    'QgsTextLabelFeature',
    'QgsLineSymbol',
    'QgsDataDefinedWidthDialog',
    'pal::InternalException',
    'QgsCredentials',
    'QgsHistogramDiagram',
    'QgsDiagramSettings',
    'QgsSQLStatement::NodeCast',
    'QgsVectorLayerUndoCommandChangeGeometry',
    'QgsRelief',
    'QgsCsException',
    'QgsMessageLogViewer',
    'QgsDateTimeEdit',
    'QgsBilinearRasterResampler',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'QgsExpressionNode::NodeList',
    'QgsVirtualLayerDefinitionUtils',
    'QgisInterface',
    'QgsAuthIdentitiesEditor',
    'QgsLinearMinMaxEnhancement',
    'QgsActionMenu',
    'QgsMessageBar',
    'QgsMapToolAdvancedDigitizing',
    'QgsWidgetWrapper',
    'pal::CostCalculator',
    'QgsGeometrySelfContactCheck',
    'QgsSQLStatement::RecursiveVisitor',
    'QgsVectorLayerJoinBuffer',
    'QgsRequestHandler',
    'QgsExpressionHighlighter',
    'QgisPlugin',
    'QgsExpressionNodeLiteral',
    'QgsAuthConfigEdit',
    'QgsAdvancedDigitizingCanvasItem',
    'QgsFillSymbolLayer',
    'QgsVectorLayerTools',
    'QgsRendererRange',
    'QgsPointLocator_Stream',
    'QgsSQLStatement::NodeLiteral',
    'QgsRunProcess',
    'QgsDataProvider',
    'QgsVectorFileWriter::HiddenOption',
    'QgsRasterHistogram',
    'QgsDashSpaceDialog',
    'QgsCubicRasterResampler',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsAttributeFormLegacyInterface',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsAuthEditorWidgets',
    'QgsFeatureRenderer',
    'pal::PalException::UnknownFeature',
    'QgsConnectionPoolGroup',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsContrastEnhancementFunction',
    'QgsGeometryPointInPolygonCheck',
    'QgsPluginLayer',
    'QgsDiagramInterpolationSettings',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsAuthConfigSslServer',
    'QgsVirtualLayerDefinition::SourceLayer',
    'QgsLabelSorter',
    'QgsSQLStatement::NodeBinaryOperator',
    'QgsLayerDefinition',
    'QgsMapUnitScaleDialog',
    'QgsSpinBox',
    'QgsExpressionNode',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsEditorWidgetFactory',
    'QgsMessageOutput',
    'QgsProviderRegistry',
    'QgsEditorConfigWidget',
    'QgsRasterFormatSaveOptionsWidget',
    'TriDecorator',
    'QgsHiddenWidgetWrapper',
    'QgsAuthAuthoritiesEditor',
    'QgsSingleBandColorDataRenderer',
    'QgsLabelPosition',
    'QgsSQLStatement::NodeList',
    'QgsUnitSelectionWidget',
    'QgsMapToolIdentifyFeature',
    'QgsGraphAnalyzer',
    'QgsUniqueValuesWidgetWrapper',
    'QgsSQLStatement::NodeUnaryOperator',
    'QgsPixmapLabel',
    'QgsDxfRuleBasedLabelProvider',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsStaticExpressionFunction',
    'QgsDetailedItemData',
    'QgsGpsdConnection',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsRasterPipe',
    'QgsScaleVisibilityDialog',
    'QgsMessageBarItem',
    'pal::Feats',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'QgsTransaction',
    'QgsSQLStatement::NodeInOperator',
    'QgsFileWidget',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsAccessControlFilter',
    'QgsSQLComposerDialog::SQLValidatorCallback',
    'QgsRasterHistogramWidget',
    'QgsEditorWidgetWrapper',
    'QgsExpressionItemSearchProxy',
    'QgsDartMeasurement',
    'QgsCptCityDirectoryItem',
    'QgsMapToPixel',
    'QgsDateTimeEditFactory',
    'NormVecDecorator',
    'QgsMapCanvas::CanvasProperties',
    'LinTriangleInterpolator',
    'QWebFrame',
    'QgsDirectoryItem',
    'QgsRasterInterface',
    'QgsSymbol',
    'QgsExpressionFunction',
    'QgsRelationManager',
    'QgsRasterTransparencyWidget',
    'QgsPieDiagram',
    'QgsAuthConfigSelect',
    'QgsInternalGeometryEngine',
    'QgsVectorLayerFeatureIterator',
    'QgsOptionsDialogBase',
    'QgsPythonRunner',
    'QgsGeometryValidator',
    'QgsRasterRange',
    'QgsExternalResourceWidget',
    'QgsGeometrySelfIntersectionCheck',
    'QgsAttributeTableModel',
    'QgsMapToolIdentify',
    'QgsSQLStatement::NodeTableDef',
    'QgsStyleManagerDialog',
    'QgsRangeConfigDlg',
    'QgsFilterLineEdit',
    'QgsGeos',
    'QgsException',
    'QgsSymbolsListWidget',
    'QgsRuleBasedRenderer',
    'Qgis',
    'QgsCoordinateReferenceSystem',
    'QgsAuthMethodPlugins',
    'QgsSQLStatement::NodeSelectedColumn',
    'QgsGml',
    'QgsDummyConfigDlg',
    'QgsRendererCategory',
    'QgsRasterResampler',
    'QgsEnumerationWidgetFactory',
    'QgsSvgCache',
    'QgsAttributeTableDelegate',
    'QgsFeature',
    'QgsSatelliteInfo',
    'QgsAuthGuiUtils',
    'QgsAttributeEditorContext',
    'QgsGeometryDuplicateNodesCheck',
    'QgsRasterDrawer',
    'QgsBlendModeComboBox',
    'QgsExpressionNodeCondition::WhenThen',
    'pal::InternalException::WrongGeometry',
    'QgsAbstractGeometrySimplifier',
    'pal::LabelPosition',
    'QgsPointLocator_VisitorEdgesInRect',
    'QgsAuthConfigUriEdit',
    'QgsGpsConnectionRegistry',
    'QgsAuthCertInfo',
    'QgsPanelWidgetStack',
    'QgsGmlStreamingParser::LayerProperties',
    'QgsIFeatureSelectionManager',
    'QgsRaster',
    'QgsVectorLayerEditPassthrough',
    'QgsFeatureListView',
    'QgsGeometryTypeCheck',
    'QgsAuthSslErrorsDialog',
    'pal::Layer',
    'QgsSQLStatement::NodeSelect',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsAdvancedDigitizingDockWidget',
    'QgsPointLocator_VisitorNearestEdge',
    'QgsAuthCertTrustPolicyComboBox',
    'QgsPreviewEffect',
    'QgsGeometryAreaCheck',
    'QgsVectorLayerUndoCommand',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsAttributeEditorField',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsProjectVersion',
    'QgsSingleBandPseudoColorRenderer',
    'QgsAuthSslConfigDialog',
    'QgsOgcUtilsExprToFilter',
    'QgsOgcUtilsSQLStatementToFilter',
    'QgsPointLocator_VisitorNearestVertex',
    'QgsTransactionGroup',
    'QgsTolerance',
    'pal::Problem',
    'QgsAuthMethod',
    'QgsStyle',
    'QgsTextEditWrapper',
    'QgsAuthMethodConfig',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsRasterShader',
    'QgsAuthSslConfigWidget',
    'pal::PalException::NotImplemented',
    'QgsZipItem',
    'QgsSvgMarkerSymbolLayer',
    'QgsPalettedRasterRenderer',
    'QgsGraphDirector',
    'QgsRectangle',
    'QgsGeometry::Error',
    'QgsServerInterface',
    'QgsInterpolator',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsExpressionSelectionDialog',
    'QgsRasterBlock',
    'QgsSingleBandPseudoColorRendererWidget',
    'QgsRubberBand',
    'QgsAttributeEditorElement',
    'QgsHighlight',
    'QgsConstWkbPtr',
    'QgsCharacterSelectorDialog',
    'QgsMapTip',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsGeometry',
    'QgsValueMapSearchWidgetWrapper',
    'QgsMapCanvasItem',
    'QgsEncodingFileDialog',
    'QgsRendererRulePropsWidget',
    'QgsFeatureStore',
    'QgsIDWInterpolator',
    'pal::InternalException::Empty',
    'QgsTextEditConfigDlg',
    'QgsConditionalLayerStyles',
    'QgsExpressionNodeUnaryOperator',
    'QgsMessageOutputConsole',
    'QgsRelationReferenceWidgetWrapper',
    'QgsRasterCalculator',
    'QgsNineCellFilter',
    'Triangulation',
    'QgsDualView',
    'QgsAuthCrypto',
    'QgsDetailedItemWidget',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsConditionalStyle',
    'QgsGeometryFollowBoundariesCheck',
    'QgsBrightnessContrastFilter',
    'QgsDxfPaintDevice',
    'QgsLongLongValidator',
    'QgsMapLayerActionRegistry',
    'QgsHueSaturationFilter',
    'QgsPanelWidget',
    'QgsTextEditWidgetFactory',
    'QgsCachedFeatureWriterIterator',
    'QgsVectorLayerRendererInterruptionChecker',
    'QgsCredentialsNone',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsFeatureRequest',
    'QgsVectorLayer',
    'QgsSingleBandGrayRendererWidget',
    'QgsXmlUtils',
    'Vector3D',
    'QgsMapToolZoom',
    'QgsMapToolPan',
    'QgsRangeWidgetWrapper',
    'QgsPluginLayerRegistry',
    'QgsAction',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDetailedItemDelegate',
    'QgsDxfPaintEngine',
    'QgsExpressionItem',
    'QgsDateTimeEditWrapper',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsVectorFileWriter',
    'QgsSQLComposerDialog',
    'QgsMapToolCapture',
    'pal::InternalException::UnknownGeometry',
    'QgsDiagram',
    'QgsExpressionBuilderWidget',
    'QgsRendererRasterPropertiesWidget',
    'QgsRasterRendererRegistry',
    'TriangleInterpolator',
    'QgsDxfLabelProvider',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'CharacterWidget',
    'QgsSearchQueryBuilder',
    'QgsMessageLogConsole',
    'QgsVectorLayerSelectionManager',
    'QgsVector',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsMapUnitScale',
    'QgsFeatureSelectionModel',
    'QgsVectorLayerUndoCommandDeleteAttribute',
    'QgsRasterChecker',
    'QgsPkiBundle',
    'QgsAbstractFeatureIterator',
    'QgsScaleWidget',
    'QgsDataDefinedRotationDialog',
    'QgsAuthTrustedCAsDialog',
    'QgsAuthCertUtils',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsCredentialDialog',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsSpatialIndex',
    'QgsAnimatedIcon',
    'QgsRasterIterator',
    'QgsMapLayer',
    'QgsVectorLayerUndoCommandChangeAttribute',
    'QgsUniqueValuesConfigDlg',
    'QgsRuleBasedRendererModel',
    'QgsHeatmapRendererWidget',
    'QgsCapabilitiesCache',
    'QgsScaleUtils',
    'QgsError',
    'pal::PointSet',
    'QgsExpressionBuilderDialog',
    'QgsExpressionNodeColumnRef',
    'QgsBusyIndicatorDialog',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'pal::InternalException::Full',
    'QgsRendererMetadata',
    'QgsNetworkReplyParser',
    'QgsDefaultSearchWidgetWrapper',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsOWSSourceSelect',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'DualEdgeTriangulation',
    'CloughTocherInterpolator',
    'QgsTableWidgetItem',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsZonalStatistics',
    'QgsLinearMinMaxEnhancementWithClip',
    'QgsSlopeFilter',
    'QgsValueRelationWidgetWrapper',
    'QgsSymbolLayerRegistry',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsSymbolLayerAbstractMetadata',
    'QgsQueryBuilder',
    'QgsSQLStatement::NodeColumnRef',
    'QgsVirtualLayerDefinition',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsProviderMetadata',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsValueMapWidgetWrapper',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsAuthMethodMetadata',
    'QgsMapServiceException',
    'QgsEllipseSymbolLayer',
    'QgsMultiBandColorRendererWidget',
    'QgsContrastEnhancement',
    'QgsCollapsibleGroupBoxBasic',
    'pal::PalException::LayerExists',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsDataCollectionItem',
    'QgsPalLabeling',
    'pal::Pal',
    'QgsAuthCertManager',
    'QgsSymbolSelectorWidget',
    'QgsLabelSearchTree',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsProjectItem',
    'QgsVectorFileWriter::IntOption',
    'QgsWkbException',
    'QgsGeometryRubberBand',
    'QgsGeometryLineIntersectionCheck',
    'QgsAuthCertEditors',
    'QgsSymbolRenderContext',
    'QgsVertexMarker',
    'QgsRasterFileWriter',
    'QgsCategorizedSymbolRendererWidget',
    'QgsMapOverviewCanvas',
    'pal::GeomFunction',
    'QgsRuleBasedRenderer::Rule',
    'QgsErrorItem',
    'QgsRendererRulePropsDialog',
    'QgsGraphBuilderInterface',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsServerFilter',
    'QgsDataSourceUri',
    'QgsGeometryTypeCheckError',
    'QgsGmlFeatureClass',
    'QgsRasterProjector',
    'QgsTopologyPreservingSimplifier',
    'QgsMapToPixelSimplifier',
    'QgsNewVectorLayerDialog',
    'QgsRendererRegistry',
    'QgsVectorDataProvider',
    'QgsRasterNuller',
    'QgsMapMouseEvent',
    'QgsRasterBandStats',
    'QgsAuthManager',
    'QgsPointDisplacementRenderer',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsPanelWidgetWrapper',
    'QgsCredentialsConsole',
    'QgsDoubleSpinBox',
    'QgsVectorLayerUndoCommandAddAttribute',
    'pal::LabelInfo',
    'pal::PalException::UnknownLayer',
    'QgsSmartGroupEditorDialog',
    'QgsMultiBandColorRenderer',
    'QgsAuthConfigEditor',
    'QgsSimpleLineSymbolLayer',
    'QgsMapTool',
    'QgsSlider',
    'QgsVectorLayerCache',
    'QgsDirectoryParamWidget',
    'QgsAttributeDialog',
    'QgsRasterPyramidsOptionsWidget',
    'QgsVectorFileWriter::SetOption',
    'QgsPkiConfigBundle',
    'QgsApplication',
    'pal::PalStat',
    'QgsLayerDefinition::DependencySorter',
    'QgsNewMemoryLayerDialog',
    'QgsLayerItem',
    'QgsNetworkDiskCache',
    'QgsVectorLayerUndoCommandDeleteFeature',
    'QWebPage',
    'pal::PalException',
    'QgsCheckBoxConfigDlg',
    'QgsCptCityColorRampItem',
    'QgsEnumerationWidgetWrapper',
    'QgsSingleCategoryDiagramRenderer',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsCptCityCollectionItem',
    'QgsCheckboxWidgetWrapper',
    'QgsFields',
    'QgsVectorLayerUndoCommandAddFeature',
    'QgsGraphBuilder',
    'QgsRuggednessFilter',
    'QgsDialog',
    'QgsExpression',
    'QgsGraduatedSymbolRenderer',
    'QgsColorWidgetWrapper',
    'QgsExpressionNodeCondition',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsSingleBandGrayRenderer',
    'QgsRasterTransparency',
    'QgsWebView',
    'QgsGeometryCheckFactoryT',
    'QgsMapToolEmitPoint',
    'QgsBlurWidget',
    'QgsLogger',
    'QgsPointLocator_VisitorArea',
    'QgsScaleComboBox',
    'QgsVectorFieldSymbolLayer',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsBrowserModel',
    'QgsSQLStatementCollectTableNames',
    'QgsOfflineEditing',
    'QgsMessageLog',
    'QgsDistanceArea',
    'QgsAttributeTableView',
    'QgsField',
    'pal::PalException::ValueNotInRange',
    'QgsExpressionNodeInOperator',
    'QgsColorRampShader',
    'QgsDataItem',
    'QgsGridFileWriter',
    'QgsCollapsibleGroupBox',
    'QgsValueMapWidgetFactory',
    'QgsEditorWidgetRegistry',
    'QgsSQLStatement::Node',
    'QgsRasterPyramid',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsRendererAbstractMetadata',
    'QgsNewHttpConnection',
    'QWebSettings',
    'QgsExternalResourceWidgetFactory',
    'QgsMapLayerStyleManagerWidget',
    'QgsCptCitySelectionItem',
    'QgsEditFormConfig',
    'QgsAuthServersEditor',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'pal::PalException::FeatureExists',
    'QgsAuthSslImportDialog',
    'QgsLegendStyle',
    'QgsRelation::FieldPair',
    'QgsServer',
    'Bezier3D',
    'QgsAuthImportCertDialog',
    'QgsIndexedFeature',
    'QgsGeometryDuplicateCheck',
    'QgsCptCityAllRampsItem',
    'QgsScaleRangeWidget',
    'QgsCoordinateTransform',
    'QgsMapCanvas',
    'QgsRendererWidget',
    'QgsPalettedRendererWidget',
    'QgsMapToolEdit',
    'QgsRasterShaderFunction',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsMessageViewer',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsClipToMinMaxEnhancement',
    'QgsDataDefinedSizeDialog',
    'QgsSVGFillSymbolLayer',
    'QgsAuthImportIdentityDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsNewGeoPackageLayerDialog',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsGpsDetector',
    'QgsSQLStatement::NodeFunction',
    'QgsClipper',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsUuidWidgetWrapper',
    'ParametricLine',
    'QgsSQLStatement::NodeBetweenOperator',
    'QgsSvgSelectorListModel',
    'QgsGradientFillSymbolLayerWidget',
    'pal::InternalException::NoLabelPosition',
    'QgsIdentifyMenu',
    'QgsRasterFillSymbolLayerWidget',
    'QgsOwsConnection',
    'QgsAttributeEditorContainer',
    'QgsProject',
    'QgsTotalCurvatureFilter',
    'QgsSimpleMarkerSymbolLayer',
    'QgsNetworkAccessManager',
    'QgsSQLStatement::NodeJoin',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsPluginLayerType',
    'QgsSearchWidgetWrapper',
    'QgsCachedFeatureIterator',
    'QgsFeatureIterator',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg',
    'QgsCptCityDataItem',
    'QgsAuthCertInfoDialog',
    'QgsRasterIdentifyResult',
    'QgsAttributeActionDialog',
    'QgsDiagramProperties',
    'QgsSourceFieldsProperties',
    'QgsJoinDialog',
    'QgsApplyDialog',
    'QgsMeshDatasetGroupTreeItemDelagate',
    'QgsAttributesFormProperties::DnDTreeItemData',
    'QgsMeshVariableStrokeWidthButton',
    'QgsMeshDatasetGroupTreeModel',
    'QgsMeshActiveDatasetGroupTreeView',
    'QgsMeshDatasetGroupListModel',
    'QgsMeshDatasetGroupSaveMenu',
    'QgsMeshDatasetGroupProxyModel',
    'QgsRendererMeshPropertiesWidget',
    'QgsMeshRendererVectorSettingsWidget',
    'QgsAttributeActionPropertiesDialog',
    'QgsAttributesFormProperties',
    'QgsMeshAvailableDatasetGroupTreeModel',
    'QgsVectorLayerSaveStyleDialog',
    'QgsVectorLayerProperties',
    'QgsMeshRendererMeshSettingsWidget',
    'QgsWmsDimensionDialog',
    'QgsSettingsEntryBase',
    'QgsMeshDatasetGroupTreeView',
    'QgsVectorLayerLegendWidget',
    'QgsMeshDatasetGroupTreeWidget',
    'QgsMeshRendererActiveDatasetWidget',
    'QgsAttributesFormInitCode',
    'QgsMeshRendererScalarSettingsWidget',
    'QgsMeshDatasetListModel',
    'QgsFieldCalculator',
    'QgsCPLErrorHandler',
    'EditBlockerDelegate',
    'QgsMeshRenderer3dAveragingWidget',
    'QgsAttributesDnDTree',
    'QgsMeshLayerProperties',
    'QgsMeshVariableStrokeWidthWidget',
    'QgsMeshStaticDatasetWidget'
]

ACCEPTABLE_MISSING_BRIEF = [
    'QgsDial',
    'QgsPluginManagerInterface',
    'QgsRangeWidgetFactory',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsValueRelationConfigDlg',
    'QgsGeometryMultipartCheck',
    'QgsArrowSymbolLayerWidget',
    'QgsCheckboxWidgetFactory',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsGradientFillSymbolLayer',
    'QgsPointPatternFillSymbolLayer',
    'QgsSymbolLayer',
    'QgsLUDialog',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsRuntimeProfiler',
    'QgsRelation',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsDataDefinedWidthDialog',
    'QgsHistogramDiagram',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'pal::CostCalculator',
    'QgsRendererRangeLabelFormat',
    'QgsGeometrySelfContactCheck',
    'QgsExpressionHighlighter',
    'QgsFillSymbolLayer',
    'QgsRendererRange',
    'QgsVectorFileWriter::HiddenOption',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsFeatureRenderer',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsGeometryPointInPolygonCheck',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsLabelPosition',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsMessageBarItem',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsDartMeasurement',
    'QgsDateTimeEditFactory',
    'QgsPieDiagram',
    'QgsVectorLayerFeatureIterator',
    'QgsGeometryValidator',
    'QgsGeometrySelfIntersectionCheck',
    'QgsRangeConfigDlg',
    'QgsSymbolsListWidget',
    'QgsDummyConfigDlg',
    'QgsEnumerationWidgetFactory',
    'QgsGeometryDuplicateNodesCheck',
    'QgsVectorLayerEditPassthrough',
    'QgsGeometryTypeCheck',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsGeometryAreaCheck',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsTransactionGroup',
    'QgsStyle',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsSvgMarkerSymbolLayer',
    'QgsGeometry::Error',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsConstWkbPtr',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsRendererRulePropsWidget',
    'QgsTextEditConfigDlg',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsGeometryFollowBoundariesCheck',
    'QgsLongLongValidator',
    'QgsTextEditWidgetFactory',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsSingleBandGrayRendererWidget',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDxfPaintEngine',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsMapToolCapture',
    'QgsRendererRasterPropertiesWidget',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'QgsVectorLayerSelectionManager',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsFeatureSelectionModel',
    'QgsDataDefinedRotationDialog',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsUniqueValuesConfigDlg',
    'QgsHeatmapRendererWidget',
    'QgsScaleUtils',
    'pal::PointSet',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'QgsRuleBasedLabeling',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsMultiBandColorRendererWidget',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsPalLabeling',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsVectorFileWriter::IntOption',
    'QgsGeometryLineIntersectionCheck',
    'QgsSymbolRenderContext',
    'QgsCategorizedSymbolRendererWidget',
    'pal::GeomFunction',
    'QgsRendererRulePropsDialog',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsGeometryTypeCheckError',
    'QgsNewVectorLayerDialog',
    'QgsRuleBasedLabeling::Rule',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsSmartGroupEditorDialog',
    'QgsSlider',
    'QgsAttributeDialog',
    'QgsVectorFileWriter::SetOption',
    'QgsNewMemoryLayerDialog',
    'QgsCheckBoxConfigDlg',
    'QgsEnumerationWidgetWrapper',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsGraduatedSymbolRenderer',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsBlurWidget',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsOfflineEditing',
    'QgsValueMapWidgetFactory',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsExternalResourceWidgetFactory',
    'QgsEditFormConfig',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'QgsGeometryDuplicateCheck',
    'QgsPalettedRendererWidget',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsDataDefinedSizeDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsGradientFillSymbolLayerWidget',
    'QgsRasterFillSymbolLayerWidget',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg',
    'QgsAttributeActionDialog',
    'QgsDiagramProperties',
    'QgsSourceFieldsProperties',
    'QgsJoinDialog',
    'QgsAttributesFormProperties::DnDTreeItemData',
    'QgsMeshDatasetGroupListModel',
    'QgsMeshDatasetGroupSaveMenu',
    'QgsMeshDatasetGroupProxyModel',
    'QgsAttributeActionPropertiesDialog',
    'QgsAttributesFormProperties',
    'QgsMeshAvailableDatasetGroupTreeModel',
    'QgsVectorLayerProperties',
    'QgsSettingsEntryBase',
    'QgsMeshDatasetGroupTreeWidget',
    'QgsAttributesFormInitCode',
    'QgsMeshRendererScalarSettingsWidget',
    'QgsCPLErrorHandler',
    'EditBlockerDelegate'
]

if __name__ == '__main__':
    for k in sorted(list(ACCEPTABLE_MISSING_DOCS.keys())):
        print('    "{}": {},'.format(k, sorted(ACCEPTABLE_MISSING_DOCS[k])))
