/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Status;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.TreeBasedTask;

public class StarTeamList
extends TreeBasedTask {
    private static final String blankstr = StarTeamList.blanks(30);

    public void setLabel(String label) {
        this._setLabel(label);
    }

    protected View createSnapshotView(View raw) {
        int labelID = this.getLabelID(raw);
        if (labelID >= 0) {
            return new View(raw, ViewConfiguration.createFromLabel((int)labelID));
        }
        return new View(raw, ViewConfiguration.createTip());
    }

    protected void testPreconditions() throws BuildException {
    }

    protected void visit(Folder starteamFolder, File targetFolder) throws BuildException {
        try {
            if (null == this.getRootLocalFolder()) {
                this.log("Folder: " + starteamFolder.getName() + " (Default folder: " + targetFolder + ")");
            } else {
                this.log("Folder: " + starteamFolder.getName() + " (Local folder: " + targetFolder + ")");
            }
            Hashtable localFiles = TreeBasedTask.listLocalFiles(targetFolder);
            Item[] files = starteamFolder.getItems("File");
            int i = 0;
            while (i < files.length) {
                com.starbase.starteam.File eachFile = (com.starbase.starteam.File)files[i];
                String filename = eachFile.getName();
                File localFile = new File(targetFolder, filename);
                this.delistLocalFile(localFiles, localFile);
                if (this.shouldProcess(filename)) {
                    this.list(eachFile, localFile);
                }
                ++i;
            }
            Folder[] subFolders = starteamFolder.getSubFolders();
            int i2 = 0;
            while (i2 < subFolders.length) {
                File targetSubfolder = new File(targetFolder, subFolders[i2].getName());
                this.delistLocalFile(localFiles, targetSubfolder);
                if (this.isRecursive()) {
                    this.visit(subFolders[i2], targetSubfolder);
                }
                ++i2;
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void list(com.starbase.starteam.File reposFile, File localFile) throws IOException {
        StringBuffer b = new StringBuffer();
        if (null == this.getRootLocalFolder()) {
            b.append(StarTeamList.pad(Status.name((int)reposFile.getStatus()), 12)).append(' ');
        }
        b.append(StarTeamList.pad(this.getUserName(reposFile.getLocker()), 20)).append(' ').append(reposFile.getModifiedTime().toString()).append(StarTeamList.rpad(String.valueOf(reposFile.getSize()), 9)).append(' ').append(reposFile.getName());
        this.log(b.toString());
    }

    private static String blanks(int len) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < len) {
            b.append(' ');
            ++i;
        }
        return b.toString();
    }

    protected static String pad(String s, int padlen) {
        return (s + blankstr).substring(0, padlen);
    }

    protected static String rpad(String s, int padlen) {
        s = blankstr + s;
        return s.substring(s.length() - padlen);
    }
}

