/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VerifyUtils {
    private static final boolean DEBUG = false;

    public static void checkLsns(Database db) throws DatabaseException {
        Long lsn;
        DatabaseImpl dbImpl = DbInternal.dbGetDatabaseImpl(db);
        GatherLSNs gatherLsns = new GatherLSNs();
        long rootLsn = dbImpl.getTree().getRootLsn();
        SortedLSNTreeWalker walker = new SortedLSNTreeWalker(dbImpl, false, false, rootLsn, gatherLsns);
        walker.walk();
        Set lsnsInTree = gatherLsns.getLsns();
        lsnsInTree.add(new Long(rootLsn));
        Iterator iter = lsnsInTree.iterator();
        HashSet<Long> fileNums = new HashSet<Long>();
        while (iter.hasNext()) {
            long lsn2 = (Long)iter.next();
            fileNums.add(new Long(DbLsn.getFileNumber(lsn2)));
        }
        iter = fileNums.iterator();
        HashSet<Long> obsoleteLsns = new HashSet<Long>();
        UtilizationProfile profile = dbImpl.getDbEnvironment().getUtilizationProfile();
        while (iter.hasNext()) {
            Long fileNum = (Long)iter.next();
            PackedOffsets obsoleteOffsets = new PackedOffsets();
            TrackedFileSummary tfs = profile.getObsoleteDetail(fileNum, obsoleteOffsets, false);
            PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
            while (obsoleteIter.hasNext()) {
                long offset = obsoleteIter.next();
                Long oneLsn = new Long(DbLsn.makeLsn(fileNum, offset));
                obsoleteLsns.add(oneLsn);
            }
        }
        boolean error = false;
        iter = lsnsInTree.iterator();
        while (iter.hasNext()) {
            lsn = (Long)iter.next();
            if (!obsoleteLsns.contains(lsn)) continue;
            System.err.println("Obsolete lsns contains valid lsn " + DbLsn.getNoFormatString(lsn));
            error = true;
        }
        iter = obsoleteLsns.iterator();
        while (iter.hasNext()) {
            lsn = (Long)iter.next();
            if (!lsnsInTree.contains(lsn)) continue;
            System.err.println("Tree contains obsolete lsn " + DbLsn.getNoFormatString(lsn));
            error = true;
        }
        if (error) {
            throw new DatabaseException("Lsn mismatch");
        }
    }

    private static class GatherLSNs
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private Set lsns = new HashSet();

        private GatherLSNs() {
        }

        public void processLSN(long childLSN, LogEntryType childType) {
            this.lsns.add(new Long(childLSN));
        }

        public Set getLsns() {
            return this.lsns;
        }
    }
}

