/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class INLogEntry
implements LogEntry,
LoggableObject,
NodeLogEntry,
INContainingEntry {
    private IN in;
    private DatabaseId dbId;
    private long obsoleteLsn;
    private long nodeId;
    private Class logClass;

    public INLogEntry(Class logClass) {
        this.logClass = logClass;
    }

    public INLogEntry(IN in) {
        this.in = in;
        this.dbId = in.getDatabase().getId();
        this.logClass = in.getClass();
        this.nodeId = in.getNodeId();
        this.obsoleteLsn = in.getLastFullVersion();
    }

    public void readEntry(ByteBuffer entryBuffer, int entrySize, byte entryTypeVersion, boolean readFullItem) throws DatabaseException {
        entryTypeVersion = (byte)(entryTypeVersion & LogEntryType.clearProvisional(entryTypeVersion));
        try {
            long fileNum;
            if (readFullItem) {
                this.in = (IN)this.logClass.newInstance();
                this.in.readFromLog(entryBuffer, entryTypeVersion);
                this.nodeId = this.in.getNodeId();
            } else {
                int position = entryBuffer.position() + entrySize;
                if (entryTypeVersion == 1) {
                    position -= 4;
                } else if (entryTypeVersion >= 2) {
                    position -= 8;
                }
                this.nodeId = LogUtils.readLong(entryBuffer);
                entryBuffer.position(position -= 4);
                this.in = null;
            }
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, entryTypeVersion);
            this.obsoleteLsn = entryTypeVersion < 1 ? -1L : (entryTypeVersion == 1 ? ((fileNum = LogUtils.getUnsignedInt(entryBuffer)) == 0xFFFFFFFFL ? -1L : DbLsn.makeLsn(fileNum, 0L)) : LogUtils.readLong(entryBuffer));
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public long getObsoleteLsn() {
        return this.obsoleteLsn;
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.in.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        return sb;
    }

    public Object getMainItem() {
        return this.in;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public LogEntryType getLogType() {
        return this.in.getLogType();
    }

    public boolean marshallOutsideWriteLatch() {
        return this.in.marshallOutsideWriteLatch();
    }

    public boolean countAsObsoleteWhenLogged() {
        return false;
    }

    public void postLogWork(long justLoggedLsn) {
    }

    public int getLogSize() {
        return this.in.getLogSize() + this.dbId.getLogSize() + 8;
    }

    public void writeToLog(ByteBuffer destBuffer) {
        this.in.writeToLog(destBuffer);
        this.dbId.writeToLog(destBuffer);
        LogUtils.writeLong(destBuffer, this.obsoleteLsn);
    }

    public IN getIN(EnvironmentImpl env) throws DatabaseException {
        return this.in;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getLsnOfIN(long lastReadLsn) {
        return lastReadLsn;
    }
}

