/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.Key;
import java.nio.ByteBuffer;

public class INDupDeleteInfo
implements LoggableObject,
LogReadable,
LogWritable {
    private long deletedNodeId;
    private byte[] deletedMainKey;
    private byte[] deletedDupKey;
    private DatabaseId dbId;

    public INDupDeleteInfo(long deletedNodeId, byte[] deletedMainKey, byte[] deletedDupKey, DatabaseId dbId) {
        this.deletedNodeId = deletedNodeId;
        this.deletedMainKey = deletedMainKey;
        this.deletedDupKey = deletedDupKey;
        this.dbId = dbId;
    }

    public INDupDeleteInfo() {
        this.dbId = new DatabaseId();
    }

    public long getDeletedNodeId() {
        return this.deletedNodeId;
    }

    public byte[] getDeletedMainKey() {
        return this.deletedMainKey;
    }

    public byte[] getDeletedDupKey() {
        return this.deletedDupKey;
    }

    public DatabaseId getDatabaseId() {
        return this.dbId;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN_DUPDELETE_INFO;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public boolean countAsObsoleteWhenLogged() {
        return false;
    }

    public void postLogWork(long justLoggedLsn) {
    }

    public int getLogSize() {
        return 8 + LogUtils.getByteArrayLogSize(this.deletedMainKey) + LogUtils.getByteArrayLogSize(this.deletedDupKey) + this.dbId.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.deletedNodeId);
        LogUtils.writeByteArray(logBuffer, this.deletedMainKey);
        LogUtils.writeByteArray(logBuffer, this.deletedDupKey);
        this.dbId.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        this.deletedNodeId = LogUtils.readLong(itemBuffer);
        this.deletedMainKey = LogUtils.readByteArray(itemBuffer);
        this.deletedDupKey = LogUtils.readByteArray(itemBuffer);
        this.dbId.readFromLog(itemBuffer, entryTypeVersion);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<INDupDeleteEntry node=\"").append(this.deletedNodeId);
        sb.append("\">");
        sb.append(Key.dumpString(this.deletedMainKey, 0));
        sb.append(Key.dumpString(this.deletedDupKey, 0));
        this.dbId.dumpLog(sb, verbose);
        sb.append("</INDupDeleteEntry>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

