/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.quickfixj.jmx.mbean.JmxSupport;
import org.quickfixj.jmx.mbean.connector.ConnectorAdmin;
import org.quickfixj.jmx.mbean.connector.SocketAcceptorAdminMBean;
import org.quickfixj.jmx.mbean.session.SessionJmxExporter;
import org.quickfixj.jmx.openmbean.TabularDataAdapter;
import quickfix.SessionID;
import quickfix.mina.acceptor.AbstractSocketAcceptor;

public class SocketAcceptorAdmin
extends ConnectorAdmin
implements SocketAcceptorAdminMBean {
    private final AbstractSocketAcceptor acceptor;
    private static final TabularDataAdapter tabularDataAdapter = new TabularDataAdapter();
    private final SessionJmxExporter sessionExporter;

    public SocketAcceptorAdmin(AbstractSocketAcceptor connector, SessionJmxExporter sessionExporter) {
        super(connector, sessionExporter);
        this.sessionExporter = sessionExporter;
        this.acceptor = connector;
    }

    public TabularData getAcceptorAddresses() throws IOException {
        ArrayList<SessionAcceptorAddressRow> rows = new ArrayList<SessionAcceptorAddressRow>();
        Iterator<Map.Entry<SessionID, SocketAddress>> entries = this.acceptor.getAcceptorAddresses().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<SessionID, SocketAddress> entry = entries.next();
            SessionID sessionID = entry.getKey();
            SocketAddress address = entry.getValue();
            rows.add(new SessionAcceptorAddressRow(sessionID, address, this.sessionExporter.getSessionName(sessionID)));
        }
        try {
            return tabularDataAdapter.fromBeanList("AcceptorAddresses", "AddressInfo", "sessionID", rows);
        }
        catch (OpenDataException e) {
            throw JmxSupport.toIOException(e);
        }
    }

    public static class SessionAcceptorAddressRow {
        private SessionID sessionID;
        private SocketAddress acceptorAddress;
        private final ObjectName sessionName;

        public SessionAcceptorAddressRow(SessionID sessionID, SocketAddress accceptorAddress, ObjectName sessionName) {
            this.sessionID = sessionID;
            this.acceptorAddress = accceptorAddress;
            this.sessionName = sessionName;
        }

        public String getAcceptorAddress() {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.acceptorAddress;
            return inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        }

        public SessionID getSessionID() {
            return this.sessionID;
        }

        public ObjectName getSessionName() {
            return this.sessionName;
        }
    }
}

