/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Map;
import org.quickfixj.QFJException;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._String;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.MessageUtils;
import quickfix.field.ApplVerID;

public class DefaultDataDictionaryProvider
implements DataDictionaryProvider {
    private static final String CUSTOM_APPL_VERSION_DELIM = "_";
    private Map<String, DataDictionary> transportDictionaries = new ConcurrentHashMap();
    private Map<AppVersionKey, DataDictionary> applicationDictionaries = new ConcurrentHashMap();
    private final boolean findDataDictionaries;

    public DefaultDataDictionaryProvider() {
        this.findDataDictionaries = true;
    }

    public DefaultDataDictionaryProvider(boolean findDataDictionaries) {
        this.findDataDictionaries = findDataDictionaries;
    }

    public synchronized DataDictionary getSessionDataDictionary(String beginString) {
        DataDictionary dd = this.transportDictionaries.get(beginString);
        if (dd == null && this.findDataDictionaries) {
            String path = _String.replace(beginString, ".", "") + ".xml";
            try {
                dd = new DataDictionary(path);
                this.transportDictionaries.put(beginString, dd);
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return dd;
    }

    public DataDictionary getApplicationDataDictionary(ApplVerID applVerID, String customApplVerID) {
        AppVersionKey appVersionKey = new AppVersionKey(applVerID, customApplVerID);
        DataDictionary dd = this.applicationDictionaries.get(appVersionKey);
        if (dd == null && this.findDataDictionaries) {
            String beginString = MessageUtils.toBeginString(applVerID);
            String path = _String.replace(beginString, ".", "") + (customApplVerID != null ? CUSTOM_APPL_VERSION_DELIM + customApplVerID : "") + ".xml";
            try {
                dd = new DataDictionary(path);
                this.applicationDictionaries.put(appVersionKey, dd);
            }
            catch (ConfigError e) {
                throw new QFJException(e);
            }
        }
        return dd;
    }

    public void addTransportDictionary(String beginString, DataDictionary dd) {
        this.transportDictionaries.put(beginString, dd);
    }

    public void addApplicationDictionary(ApplVerID applVerID, String customApplVerID, DataDictionary dataDictionary) {
        this.applicationDictionaries.put(new AppVersionKey(applVerID, customApplVerID), dataDictionary);
    }

    private static class AppVersionKey {
        private final ApplVerID applVerID;
        private final String customApplVerID;

        public AppVersionKey(ApplVerID applVerID, String customApplVerID) {
            this.applVerID = applVerID;
            this.customApplVerID = customApplVerID;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.applVerID == null ? 0 : this.applVerID.hashCode());
            result = 31 * result + (this.customApplVerID == null ? 0 : this.customApplVerID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AppVersionKey other = (AppVersionKey)obj;
            if (this.applVerID == null ? other.applVerID != null : !this.applVerID.equals(other.applVerID)) {
                return false;
            }
            return !(this.customApplVerID == null ? other.customApplVerID != null : !this.customApplVerID.equals(other.customApplVerID));
        }
    }
}

