/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Map;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import quickfix.Group;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageUtils;

public class DefaultMessageFactory
implements MessageFactory {
    private final Map<String, MessageFactory> messageFactories = new ConcurrentHashMap();

    public DefaultMessageFactory() {
        this.discoverFactory("FIX.4.0", "quickfix.fix40.MessageFactory");
        this.discoverFactory("FIX.4.1", "quickfix.fix41.MessageFactory");
        this.discoverFactory("FIX.4.2", "quickfix.fix42.MessageFactory");
        this.discoverFactory("FIX.4.3", "quickfix.fix43.MessageFactory");
        this.discoverFactory("FIX.4.4", "quickfix.fix44.MessageFactory");
        this.discoverFactory("FIXT.1.1", "quickfix.fixt11.MessageFactory");
        this.discoverFactory("FIX.5.0", "quickfix.fix50.MessageFactory");
    }

    private void discoverFactory(String beginString, String factoryClassName) {
        try {
            this.messageFactories.put(beginString, (MessageFactory)Class.forName(factoryClassName).newInstance());
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Message create(String beginString, String msgType) {
        MessageFactory messageFactory = this.messageFactories.get(beginString);
        if (beginString.equals("FIXT.1.1") && !MessageUtils.isAdminMessage(msgType)) {
            messageFactory = this.messageFactories.get("FIX.5.0");
        }
        if (messageFactory != null) {
            return messageFactory.create(beginString, msgType);
        }
        return new Message();
    }

    public Group create(String beginString, String msgType, int correspondingFieldID) {
        MessageFactory messageFactory = this.messageFactories.get(beginString);
        if (messageFactory != null) {
            return messageFactory.create(beginString, msgType, correspondingFieldID);
        }
        throw new IllegalArgumentException("Unsupported FIX version: " + beginString);
    }
}

