/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DefaultDataDictionaryProvider;
import quickfix.DefaultMessageFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSchedule;
import quickfix.SessionSettings;
import quickfix.field.ApplVerID;
import quickfix.field.DefaultApplVerID;

public class DefaultSessionFactory
implements SessionFactory {
    private static final Map<String, DataDictionary> dictionaryCache = new Hashtable<String, DataDictionary>();
    private final Application application;
    private final MessageStoreFactory messageStoreFactory;
    private final LogFactory logFactory;
    private final MessageFactory messageFactory;

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = new DefaultMessageFactory();
    }

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = messageFactory;
    }

    public Session create(SessionID sessionID, SessionSettings settings) throws ConfigError {
        try {
            String connectionType = null;
            if (settings.isSetting(sessionID, "ConnectionType")) {
                connectionType = settings.getString(sessionID, "ConnectionType");
            }
            if (connectionType == null) {
                throw new ConfigError("Missing ConnectionType");
            }
            if (!connectionType.equals("acceptor") && !connectionType.equals("initiator")) {
                throw new ConfigError("Invalid ConnectionType");
            }
            if (connectionType.equals("acceptor") && settings.isSetting(sessionID, "SessionQualifier")) {
                throw new ConfigError("SessionQualifier cannot be used with acceptor.");
            }
            DefaultApplVerID senderDefaultApplVerID = null;
            if (sessionID.isFIXT()) {
                if (!settings.isSetting(sessionID, "DefaultApplVerID")) {
                    throw new ConfigError("DefaultApplVerID is required for FIXT transport");
                }
                senderDefaultApplVerID = new DefaultApplVerID(this.toApplVerID(settings.getString(sessionID, "DefaultApplVerID")).getValue());
            }
            boolean useDataDictionary = true;
            if (settings.isSetting(sessionID, "UseDataDictionary")) {
                useDataDictionary = settings.getBool(sessionID, "UseDataDictionary");
            }
            DefaultDataDictionaryProvider dataDictionaryProvider = new DefaultDataDictionaryProvider();
            if (useDataDictionary) {
                if (sessionID.isFIXT()) {
                    this.processFixtDataDictionaries(sessionID, settings, dataDictionaryProvider);
                } else {
                    this.processPreFixtDataDictionary(sessionID, settings, dataDictionaryProvider);
                }
            }
            int heartbeatInterval = 0;
            if (connectionType.equals("initiator") && (heartbeatInterval = (int)settings.getLong(sessionID, "HeartBtInt")) <= 0) {
                throw new ConfigError("Heartbeat must be greater than zero");
            }
            boolean checkLatency = this.getSetting(settings, sessionID, "CheckLatency", true);
            int maxLatency = this.getSetting(settings, sessionID, "MaxLatency", 120);
            double testRequestDelayMultiplier = this.getSetting(settings, sessionID, "TestRequestDelayMultiplier", 0.5);
            boolean millisInTimestamp = this.getSetting(settings, sessionID, "MillisecondsInTimeStamp", true);
            boolean resetOnLogout = this.getSetting(settings, sessionID, "ResetOnLogout", false);
            boolean resetOnDisconnect = this.getSetting(settings, sessionID, "ResetOnDisconnect", false);
            boolean resetOnLogon = this.getSetting(settings, sessionID, "ResetOnLogon", false);
            boolean refreshAtLogon = this.getSetting(settings, sessionID, "RefreshOnLogon", false);
            boolean checkCompID = this.getSetting(settings, sessionID, "CheckCompID", true);
            boolean redundantResentRequestAllowed = this.getSetting(settings, sessionID, "SendRedundantResendRequests", false);
            boolean persistMessages = this.getSetting(settings, sessionID, "PersistMessages", true);
            boolean useClosedIntervalForResend = this.getSetting(settings, sessionID, "ClosedResendInterval", false);
            int logonTimeout = this.getSetting(settings, sessionID, "LogonTimeout", 10);
            int logoutTimeout = this.getSetting(settings, sessionID, "LogoutTimeout", 2);
            Session session = new Session(this.application, this.messageStoreFactory, sessionID, dataDictionaryProvider, new SessionSchedule(settings, sessionID), this.logFactory, this.messageFactory, heartbeatInterval, checkLatency, maxLatency, millisInTimestamp, resetOnLogon, resetOnLogout, resetOnDisconnect, refreshAtLogon, checkCompID, redundantResentRequestAllowed, persistMessages, useClosedIntervalForResend, testRequestDelayMultiplier, senderDefaultApplVerID);
            session.setLogonTimeout(logonTimeout);
            session.setLogoutTimeout(logoutTimeout);
            this.application.onCreate(sessionID);
            return session;
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e.getMessage());
        }
    }

    private void processPreFixtDataDictionary(SessionID sessionID, SessionSettings settings, DefaultDataDictionaryProvider dataDictionaryProvider) throws ConfigError, FieldConvertError {
        DataDictionary dataDictionary = this.createDataDictionary(sessionID, settings, "DataDictionary", sessionID.getBeginString());
        dataDictionaryProvider.addTransportDictionary(sessionID.getBeginString(), dataDictionary);
        dataDictionaryProvider.addApplicationDictionary(MessageUtils.toApplVerID(sessionID.getBeginString()), null, dataDictionary);
    }

    private DataDictionary createDataDictionary(SessionID sessionID, SessionSettings settings, String settingsKey, String beginString) throws ConfigError, FieldConvertError {
        String path = this.getDictionaryPath(sessionID, settings, settingsKey, beginString);
        DataDictionary dataDictionary = this.getDataDictionary(path);
        if (settings.isSetting(sessionID, "ValidateFieldsOutOfOrder")) {
            dataDictionary.setCheckFieldsOutOfOrder(settings.getBool(sessionID, "ValidateFieldsOutOfOrder"));
        }
        if (settings.isSetting(sessionID, "ValidateFieldsHaveValues")) {
            dataDictionary.setCheckFieldsHaveValues(settings.getBool(sessionID, "ValidateFieldsHaveValues"));
        }
        if (settings.isSetting(sessionID, "ValidateUserDefinedFields")) {
            dataDictionary.setCheckUserDefinedFields(settings.getBool(sessionID, "ValidateUserDefinedFields"));
        }
        if (settings.isSetting(sessionID, "AllowUnknownMsgFields")) {
            dataDictionary.setAllowUnknownMessageFields(settings.getBool(sessionID, "AllowUnknownMsgFields"));
        }
        return dataDictionary;
    }

    private void processFixtDataDictionaries(SessionID sessionID, SessionSettings settings, DefaultDataDictionaryProvider dataDictionaryProvider) throws ConfigError, FieldConvertError {
        dataDictionaryProvider.addTransportDictionary(sessionID.getBeginString(), this.createDataDictionary(sessionID, settings, "TransportDataDictionary", sessionID.getBeginString()));
        Properties sessionProperties = settings.getSessionProperties(sessionID);
        Enumeration<?> keys = sessionProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("AppDataDictionary")) continue;
            if (key.equals("AppDataDictionary")) {
                ApplVerID applVerID = this.toApplVerID(settings.getString(sessionID, "DefaultApplVerID"));
                DataDictionary dd = this.createDataDictionary(sessionID, settings, "AppDataDictionary", sessionID.getBeginString());
                dataDictionaryProvider.addApplicationDictionary(applVerID, null, dd);
                continue;
            }
            int offset = key.indexOf(46);
            if (offset == -1) {
                throw new ConfigError("Malformed AppDataDictionary: " + key);
            }
            String beginStringQualifier = key.substring(offset + 1);
            DataDictionary dd = this.createDataDictionary(sessionID, settings, key, beginStringQualifier);
            dataDictionaryProvider.addApplicationDictionary(MessageUtils.toApplVerID(beginStringQualifier), null, dd);
        }
    }

    private ApplVerID toApplVerID(String value) {
        if (this.isApplVerIdEnum(value)) {
            return new ApplVerID(value);
        }
        return MessageUtils.toApplVerID(value);
    }

    private boolean isApplVerIdEnum(String value) {
        return value.matches("[0-9]+");
    }

    private String getDictionaryPath(SessionID sessionID, SessionSettings settings, String settingsKey, String beginString) throws ConfigError, FieldConvertError {
        String path = settings.isSetting(sessionID, settingsKey) ? settings.getString(sessionID, settingsKey) : this.toDictionaryPath(beginString);
        return path;
    }

    private String toDictionaryPath(String beginString) {
        return beginString.replaceAll("\\.", "") + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataDictionary getDataDictionary(String path) throws ConfigError {
        Map<String, DataDictionary> map = dictionaryCache;
        synchronized (map) {
            DataDictionary dataDictionary = dictionaryCache.get(path);
            if (dataDictionary == null) {
                dataDictionary = new DataDictionary(path);
                dictionaryCache.put(path, dataDictionary);
            }
            return dataDictionary;
        }
    }

    private boolean getSetting(SessionSettings settings, SessionID sessionID, String key, boolean defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? settings.getBool(sessionID, key) : defaultValue;
    }

    private int getSetting(SessionSettings settings, SessionID sessionID, String key, int defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? (int)settings.getLong(sessionID, key) : defaultValue;
    }

    private double getSetting(SessionSettings settings, SessionID sessionID, String key, double defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? Double.parseDouble(settings.getString(sessionID, key)) : defaultValue;
    }
}

