/*
 * Decompiled with CFR 0.152.
 */
package quickfix.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import quickfix.codegen.CodeGenerationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageCodeGenerator {
    private static final String BIGDECIMAL_TYPE_OPTION = "generator.decimal";
    private static final String ORDERED_FIELDS_OPTION = "generator.orderedFields";
    private static final String OVERWRITE_OPTION = "generator.overwrite";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long SERIAL_UID = 20050617L;
    private static final String SERIAL_UID_STR = String.valueOf(20050617L);
    private static final String XSLPARAM_SERIAL_UID = "serialVersionUID";
    private Map<String, Document> specificationCache = new HashMap<String, Document>();
    static /* synthetic */ Class class$quickfix$codegen$MessageCodeGenerator;

    private void generateMessageBaseClass(Task task) throws TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info(new StringBuffer().append(task.getName()).append(": generating message base class").toString());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
        this.generateClassCode(task, "Message", hashMap);
    }

    private void generateMessageFactoryClass(Task task) throws TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.generateClassCode(task, "MessageFactory", null);
    }

    private void generateMessageCrackerClass(Task task) throws TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.generateClassCode(task, "MessageCracker", null);
    }

    private void generateClassCode(Task task, String string, Map<String, String> map) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, TransformerException {
        this.log.debug(new StringBuffer().append("generating ").append(string).append(" for ").append(task.getName()).toString());
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("messagePackage", task.getMessagePackage());
        map.put("fieldPackage", task.getFieldPackage());
        Document document = this.getSpecification(task);
        this.generateCodeFile(task, document, map, new StringBuffer().append(task.getOutputBaseDirectory()).append("/").append(task.getMessageDirectory()).append("/").append(string).append(".java").toString(), this.createTransformer(task, new StringBuffer().append(string).append(".xsl").toString()));
    }

    private void generateFieldClasses(Task task) throws ParserConfigurationException, SAXException, IOException {
        this.log.info(new StringBuffer().append(task.getName()).append(": generating field classes").toString());
        String string = new StringBuffer().append(task.getOutputBaseDirectory()).append("/").append(task.getFieldDirectory()).append("/").toString();
        this.writePackageDocumentation(string, new StringBuffer().append("FIX field definitions for ").append(task.getName()).toString());
        Document document = this.getSpecification(task);
        List<String> list = this.getNames(document.getDocumentElement(), "fields/field");
        try {
            Transformer transformer = this.createTransformer(task, "Fields.xsl");
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                String string3 = new StringBuffer().append(string).append(string2).append(".java").toString();
                if (new File(string3).exists()) continue;
                this.log.debug(new StringBuffer().append("field: ").append(string2).toString());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("fieldName", string2);
                hashMap.put("fieldPackage", task.getFieldPackage());
                if (task.isDecimalGenerated()) {
                    hashMap.put("decimalType", "java.math.BigDecimal");
                    hashMap.put("decimalConverter", "Decimal");
                }
                hashMap.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
                this.generateCodeFile(task, document, hashMap, string3, transformer);
            }
        }
        catch (Exception exception) {
            this.log.error("error while generating field classes", (Throwable)exception);
        }
    }

    private void generateMessageSubclasses(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info(new StringBuffer().append(task.getName()).append(": generating message subclasses").toString());
        String string = new StringBuffer().append(task.getOutputBaseDirectory()).append("/").append(task.getMessageDirectory()).append("/").toString();
        this.writePackageDocumentation(string, "Message classes");
        Document document = this.getSpecification(task);
        List<String> list = this.getNames(document.getDocumentElement(), "messages/message");
        Transformer transformer = this.createTransformer(task, "MessageSubclass.xsl");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            this.log.debug(new StringBuffer().append("generating message class: ").append(string2).toString());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("itemName", string2);
            hashMap.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
            hashMap.put("orderedFields", Boolean.toString(task.isOrderedFields()));
            hashMap.put("fieldPackage", task.getFieldPackage());
            hashMap.put("messagePackage", task.getMessagePackage());
            this.generateCodeFile(task, document, hashMap, new StringBuffer().append(string).append(string2).append(".java").toString(), transformer);
        }
    }

    private void generateComponentClasses(Task task) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info(new StringBuffer().append(task.getName()).append(": generating component classes").toString());
        String string = new StringBuffer().append(task.getOutputBaseDirectory()).append("/").append(task.getMessageDirectory()).append("/component/").toString();
        Document document = this.getSpecification(task);
        List<String> list = this.getNames(document.getDocumentElement(), "components/component");
        if (list.size() > 0) {
            this.writePackageDocumentation(string, "Message component classes");
        }
        Transformer transformer = this.createTransformer(task, "MessageSubclass.xsl");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            this.log.debug(new StringBuffer().append("generating component class: ").append(string2).toString());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("itemName", string2);
            hashMap.put("baseClass", "quickfix.MessageComponent");
            hashMap.put("subpackage", ".component");
            hashMap.put("fieldPackage", task.getFieldPackage());
            hashMap.put("messagePackage", task.getMessagePackage());
            hashMap.put("orderedFields", Boolean.toString(task.isOrderedFields()));
            hashMap.put(XSLPARAM_SERIAL_UID, SERIAL_UID_STR);
            this.generateCodeFile(task, document, hashMap, new StringBuffer().append(string).append(string2).append(".java").toString(), transformer);
        }
    }

    private Transformer createTransformer(Task task, String string) throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        StreamSource streamSource = new StreamSource(new File(new StringBuffer().append(task.getTransformDirectory()).append("/").append(string).toString()));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        return transformer;
    }

    private Document getSpecification(Task task) throws ParserConfigurationException, SAXException, IOException {
        Document document = this.specificationCache.get(task.getName());
        if (document == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(task.getSpecification()));
            this.specificationCache.put(task.getName(), document);
        }
        return document;
    }

    private void writePackageDocumentation(String string, String string2) throws FileNotFoundException {
        File file = new File(new StringBuffer().append(string).append("package.html").toString());
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        printStream.println("<html>");
        printStream.println("<head><title/></head>");
        printStream.println(new StringBuffer().append("<body>").append(string2).append("</body>").toString());
        printStream.println("</html>");
        printStream.close();
    }

    private List<String> getNames(Element element, String string) {
        return this.getNames(element, string, new ArrayList<String>());
    }

    private List<String> getNames(Element element, String string, List<String> list) {
        int n = string.indexOf("/");
        if (n == -1) {
            NodeList nodeList = element.getElementsByTagName(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                list.add(((Element)nodeList.item(i)).getAttribute("name"));
            }
        } else {
            String string2 = string.substring(0, n);
            NodeList nodeList = element.getElementsByTagName(string2);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.getNames((Element)nodeList.item(i), string.substring(n + 1), list);
            }
        }
        return list;
    }

    private void generateCodeFile(Task task, Document document, Map<String, String> map, String string, Transformer transformer) throws TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, TransformerException {
        Object object;
        Object object2;
        if (map != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                transformer.setParameter((String)object.getKey(), object.getValue());
            }
        }
        if (!((File)(object2 = new File(string))).getParentFile().exists()) {
            ((File)object2).getParentFile().mkdirs();
        }
        object = new File(string);
        if (!task.isOverwrite() && ((File)object).exists()) {
            return;
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new FileOutputStream((File)object));
        transformer.transform(dOMSource, streamResult);
    }

    public void generate(Task task) {
        try {
            this.generateFieldClasses(task);
            this.generateMessageBaseClass(task);
            this.generateMessageFactoryClass(task);
            this.generateMessageCrackerClass(task);
            this.generateComponentClasses(task);
            this.generateMessageSubclasses(task);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    public static String stripSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '.') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        MessageCodeGenerator messageCodeGenerator = new MessageCodeGenerator();
        try {
            Object object;
            if (stringArray.length != 3) {
                Class<?> clazz = class$quickfix$codegen$MessageCodeGenerator;
                if (clazz == null) {
                    clazz = class$quickfix$codegen$MessageCodeGenerator = new MessageCodeGenerator[0].getClass().getComponentType();
                }
                String string = clazz.getName();
                System.err.println(new StringBuffer().append("usage: ").append(string).append(" specDir xformDir outputBaseDir").toString());
                return;
            }
            boolean bl = MessageCodeGenerator.getOption(OVERWRITE_OPTION, true);
            boolean bl2 = MessageCodeGenerator.getOption(ORDERED_FIELDS_OPTION, false);
            boolean bl3 = MessageCodeGenerator.getOption(BIGDECIMAL_TYPE_OPTION, false);
            long l = System.currentTimeMillis();
            String[] stringArray2 = new String[]{"FIXT 1.1", "FIX 5.0", "FIX 4.4", "FIX 4.3", "FIX 4.2", "FIX 4.1", "FIX 4.0"};
            for (int i = 0; i < stringArray2.length; ++i) {
                Task task = new Task();
                task.setName(stringArray2[i]);
                object = MessageCodeGenerator.stripSpaces(stringArray2[i]);
                task.setSpecification(new StringBuffer().append(stringArray[0]).append("/").append((String)object).append(".xml").toString());
                task.setTransformDirectory(stringArray[1]);
                task.setMessagePackage(new StringBuffer().append("quickfix.").append(((String)object).toLowerCase()).toString());
                task.setOutputBaseDirectory(stringArray[2]);
                task.setFieldPackage("quickfix.field");
                task.setOverwrite(bl);
                task.setOrderedFields(bl2);
                task.setDecimalGenerated(bl3);
                messageCodeGenerator.generate(task);
            }
            double d = System.currentTimeMillis() - l;
            object = new DecimalFormat("#.###");
            messageCodeGenerator.log.info(new StringBuffer().append("Time for generation: ").append(((NumberFormat)object).format(d / 1000.0)).append(" seconds").toString());
        }
        catch (Exception exception) {
            messageCodeGenerator.log.error("error during code generation", (Throwable)exception);
            System.exit(1);
        }
    }

    private static boolean getOption(String string, boolean bl) {
        return System.getProperties().containsKey(string) ? Boolean.getBoolean(string) : bl;
    }

    public static class Task {
        private String name;
        private String specification;
        private String outputBaseDirectory;
        private String messagePackage;
        private String fieldPackage;
        private boolean overwrite = true;
        private String transformDirectory;
        private boolean orderedFields;
        private boolean useDecimal;

        public String getName() {
            return this.name;
        }

        public void setOrderedFields(boolean bl) {
            this.orderedFields = bl;
        }

        public boolean isOrderedFields() {
            return this.orderedFields;
        }

        public String getTransformDirectory() {
            return this.transformDirectory;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getFieldPackage() {
            return this.fieldPackage;
        }

        public String getFieldDirectory() {
            return this.fieldPackage.replace('.', '/');
        }

        public void setFieldPackage(String string) {
            this.fieldPackage = string;
        }

        public String getMessageDirectory() {
            return this.messagePackage.replace('.', '/');
        }

        public String getMessagePackage() {
            return this.messagePackage;
        }

        public void setMessagePackage(String string) {
            this.messagePackage = string;
        }

        public String getOutputBaseDirectory() {
            return this.outputBaseDirectory;
        }

        public void setOutputBaseDirectory(String string) {
            this.outputBaseDirectory = string;
        }

        public String getSpecification() {
            return this.specification;
        }

        public void setSpecification(String string) {
            this.specification = string;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean bl) {
            this.overwrite = bl;
        }

        public void setTransformDirectory(String string) {
            this.transformDirectory = string;
        }

        public void setDecimalGenerated(boolean bl) {
            this.useDecimal = bl;
        }

        public boolean isDecimalGenerated() {
            return this.useDecimal;
        }
    }
}

