/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.util.Collection;
import java.util.Map;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.EventHandlingStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPerSessionEventHandlingStrategy
implements EventHandlingStrategy {
    private final Map<SessionID, MessageDispatchingThread> dispatchers = new ConcurrentHashMap();

    @Override
    public void onMessage(Session quickfixSession, Message message) {
        MessageDispatchingThread dispatcher = this.dispatchers.get(quickfixSession.getSessionID());
        if (dispatcher == null) {
            dispatcher = new MessageDispatchingThread(quickfixSession);
            this.dispatchers.put(quickfixSession.getSessionID(), dispatcher);
            this.startDispatcherThread(dispatcher);
        }
        dispatcher.enqueue(message);
    }

    protected void startDispatcherThread(MessageDispatchingThread dispatcher) {
        dispatcher.start();
    }

    public void stopDispatcherThreads() {
        Collection<MessageDispatchingThread> dispatchersToShutdown = this.dispatchers.values();
        this.dispatchers.clear();
        for (MessageDispatchingThread dispatcher : dispatchersToShutdown) {
            dispatcher.stopDispatcher();
        }
    }

    BlockingQueue<Message> getMessages(SessionID sessionID) {
        MessageDispatchingThread dispatcher = this.getDispatcher(sessionID);
        return dispatcher.messages;
    }

    MessageDispatchingThread getDispatcher(SessionID sessionID) {
        return this.dispatchers.get(sessionID);
    }

    Message getNextMessage(BlockingQueue<Message> messages) throws InterruptedException {
        return (Message)messages.take();
    }

    class MessageDispatchingThread
    extends Thread {
        private final Session quickfixSession;
        private final BlockingQueue<Message> messages;
        private volatile boolean stopped;

        public MessageDispatchingThread(Session session) {
            super("QF/J Session dispatcher: " + session.getSessionID());
            this.messages = new LinkedBlockingQueue();
            this.quickfixSession = session;
        }

        public void enqueue(Message message) {
            try {
                this.messages.put((Object)message);
            }
            catch (InterruptedException e) {
                this.quickfixSession.getLog().onEvent(e.getMessage());
            }
        }

        public void run() {
            while (!this.stopped) {
                try {
                    Message message = ThreadPerSessionEventHandlingStrategy.this.getNextMessage(this.messages);
                    if (!this.quickfixSession.hasResponder()) continue;
                    this.quickfixSession.next(message);
                }
                catch (InterruptedException e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), "Message dispatcher interrupted", (Throwable)e);
                    return;
                }
                catch (Throwable e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), "Error during message processing", e);
                }
            }
        }

        public void stopDispatcher() {
            this.stopped = true;
        }
    }
}

