/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfigurator
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog((Class)XMLConfigurator.class);
    private StringBuffer content = new StringBuffer();
    private String poolName;
    private String driverClass;
    private String driverUrl;
    private Properties properties = new Properties();
    private static final String PROXOOL = "proxool";
    private static final String DRIVER_PROPERTIES = "driver-properties";
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private boolean insideDelegateProperties;
    private boolean insideProxool;

    public void startElement(String uri, String lname, String qname, Attributes attributes) throws SAXException {
        this.content.setLength(0);
        if (!this.namespaceOk(uri)) {
            return;
        }
        String elementName = this.getElementName(uri, lname, qname);
        if (elementName.equals(PROXOOL)) {
            if (this.insideProxool) {
                throw new SAXException("A <proxool> element can't contain another <proxool> element.");
            }
            this.insideProxool = true;
            this.properties.clear();
            this.driverClass = null;
            this.driverUrl = null;
        }
        if (this.insideProxool) {
            if (elementName.equals(DRIVER_PROPERTIES)) {
                this.insideDelegateProperties = true;
            } else if (this.insideDelegateProperties && elementName.equals(PROPERTY)) {
                this.setDriverProperty(attributes);
            }
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.insideProxool) {
            this.content.append(chars, start, length);
        }
    }

    public void endElement(String uri, String lname, String qname) throws SAXException {
        if (!this.namespaceOk(uri)) {
            return;
        }
        String elementName = this.getElementName(uri, lname, qname);
        if (elementName.equals(PROXOOL)) {
            if (this.driverClass == null || this.driverUrl == null) {
                throw new SAXException("You must define the driver-class and the driver-url.");
            }
            StringBuffer url = new StringBuffer();
            url.append(PROXOOL);
            if (this.poolName != null) {
                url.append(".");
                url.append(this.poolName);
            }
            url.append(":");
            url.append(this.driverClass);
            url.append(":");
            url.append(this.driverUrl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created url: " + url));
            }
            try {
                ProxoolFacade.registerConnectionPool(url.toString(), this.properties);
            }
            catch (ProxoolException e) {
                throw new SAXException(e);
            }
            this.insideProxool = false;
        }
        if (this.insideProxool && !elementName.equals(PROXOOL)) {
            if (elementName.equals(DRIVER_PROPERTIES)) {
                this.insideDelegateProperties = false;
            } else if (!this.insideDelegateProperties) {
                this.setProxoolProperty(elementName, this.content.toString().trim());
            }
        }
    }

    private void setProxoolProperty(String localName, String value) {
        if (localName.equals("alias")) {
            this.poolName = value;
        } else if (localName.equals("driver-class")) {
            this.driverClass = value;
        } else if (localName.equals("driver-url")) {
            this.driverUrl = value;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting property 'proxool." + localName + "' to value '" + value + "'."));
            }
            this.properties.put("proxool." + localName, value);
        }
    }

    private void setDriverProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue(NAME);
        String value = attributes.getValue(VALUE);
        if (name == null || name.length() < 1 || value == null) {
            throw new SAXException("Name or value attribute missing from property element.Name: '" + name + "' Value: '" + value + "'.");
        }
        if (LOG.isDebugEnabled()) {
            if (name.toLowerCase().indexOf("password") > -1) {
                LOG.debug((Object)("Adding driver property: " + name + "=" + "*******"));
            } else {
                LOG.debug((Object)("Adding driver property: " + name + "=" + value));
            }
        }
        this.properties.put(name, value);
    }

    public void warning(SAXParseException e) throws SAXException {
        LOG.debug((Object)"The saxparser reported a warning.", (Throwable)e);
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    private String getElementName(String uri, String lname, String qname) {
        if (uri == null || "".equals(uri)) {
            return qname;
        }
        return lname;
    }

    private boolean namespaceOk(String uri) {
        return uri == null || uri.length() == 0 || uri.equals("The latest version is available at http://proxool.sourceforge.net/xml-namespace");
    }
}

