/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.demux;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderFactory;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.mina.filter.codec.demux.MessageEncoderFactory;
import org.apache.mina.util.IdentityHashSet;

public class DemuxingProtocolCodecFactory
implements ProtocolCodecFactory {
    private MessageDecoderFactory[] decoderFactories = new MessageDecoderFactory[0];
    private MessageEncoderFactory[] encoderFactories = new MessageEncoderFactory[0];
    private static final Class[] EMPTY_PARAMS = new Class[0];

    public void register(Class encoderOrDecoderClass) {
        if (encoderOrDecoderClass == null) {
            throw new NullPointerException("encoderOrDecoderClass");
        }
        try {
            encoderOrDecoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specifiec class doesn't have a public default constructor.");
        }
        boolean registered = false;
        if (MessageEncoder.class.isAssignableFrom(encoderOrDecoderClass)) {
            this.register(new DefaultConstructorMessageEncoderFactory(encoderOrDecoderClass));
            registered = true;
        }
        if (MessageDecoder.class.isAssignableFrom(encoderOrDecoderClass)) {
            this.register(new DefaultConstructorMessageDecoderFactory(encoderOrDecoderClass));
            registered = true;
        }
        if (!registered) {
            throw new IllegalArgumentException("Unregisterable type: " + encoderOrDecoderClass);
        }
    }

    public void register(MessageEncoder encoder) {
        this.register(new SingletonMessageEncoderFactory(encoder));
    }

    public void register(MessageEncoderFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        MessageEncoderFactory[] encoderFactories = this.encoderFactories;
        MessageEncoderFactory[] newEncoderFactories = new MessageEncoderFactory[encoderFactories.length + 1];
        System.arraycopy(encoderFactories, 0, newEncoderFactories, 0, encoderFactories.length);
        newEncoderFactories[encoderFactories.length] = factory;
        this.encoderFactories = newEncoderFactories;
    }

    public void register(MessageDecoder decoder) {
        this.register(new SingletonMessageDecoderFactory(decoder));
    }

    public void register(MessageDecoderFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        MessageDecoderFactory[] decoderFactories = this.decoderFactories;
        MessageDecoderFactory[] newDecoderFactories = new MessageDecoderFactory[decoderFactories.length + 1];
        System.arraycopy(decoderFactories, 0, newDecoderFactories, 0, decoderFactories.length);
        newDecoderFactories[decoderFactories.length] = factory;
        this.decoderFactories = newDecoderFactories;
    }

    public ProtocolEncoder getEncoder() throws Exception {
        return new ProtocolEncoderImpl();
    }

    public ProtocolDecoder getDecoder() throws Exception {
        return new ProtocolDecoderImpl();
    }

    protected void disposeCodecResources(IoSession session) {
        session.getTransportType();
    }

    private static class DefaultConstructorMessageDecoderFactory
    implements MessageDecoderFactory {
        private final Class decoderClass;

        private DefaultConstructorMessageDecoderFactory(Class decoderClass) {
            if (decoderClass == null) {
                throw new NullPointerException("decoderClass");
            }
            if (!(class$org$apache$mina$filter$codec$demux$MessageDecoder == null ? (class$org$apache$mina$filter$codec$demux$MessageDecoder = DemuxingProtocolCodecFactory.class$("org.apache.mina.filter.codec.demux.MessageDecoder")) : class$org$apache$mina$filter$codec$demux$MessageDecoder).isAssignableFrom(decoderClass)) {
                throw new IllegalArgumentException("decoderClass is not assignable to MessageDecoder");
            }
            this.decoderClass = decoderClass;
        }

        public MessageDecoder getDecoder() throws Exception {
            return (MessageDecoder)this.decoderClass.newInstance();
        }
    }

    private static class DefaultConstructorMessageEncoderFactory
    implements MessageEncoderFactory {
        private final Class encoderClass;

        private DefaultConstructorMessageEncoderFactory(Class encoderClass) {
            if (encoderClass == null) {
                throw new NullPointerException("encoderClass");
            }
            if (!(class$org$apache$mina$filter$codec$demux$MessageEncoder == null ? (class$org$apache$mina$filter$codec$demux$MessageEncoder = DemuxingProtocolCodecFactory.class$("org.apache.mina.filter.codec.demux.MessageEncoder")) : class$org$apache$mina$filter$codec$demux$MessageEncoder).isAssignableFrom(encoderClass)) {
                throw new IllegalArgumentException("encoderClass is not assignable to MessageEncoder");
            }
            this.encoderClass = encoderClass;
        }

        public MessageEncoder getEncoder() throws Exception {
            return (MessageEncoder)this.encoderClass.newInstance();
        }
    }

    private static class SingletonMessageDecoderFactory
    implements MessageDecoderFactory {
        private final MessageDecoder decoder;

        private SingletonMessageDecoderFactory(MessageDecoder decoder) {
            if (decoder == null) {
                throw new NullPointerException("decoder");
            }
            this.decoder = decoder;
        }

        public MessageDecoder getDecoder() {
            return this.decoder;
        }
    }

    private static class SingletonMessageEncoderFactory
    implements MessageEncoderFactory {
        private final MessageEncoder encoder;

        private SingletonMessageEncoderFactory(MessageEncoder encoder) {
            if (encoder == null) {
                throw new NullPointerException("encoder");
            }
            this.encoder = encoder;
        }

        public MessageEncoder getEncoder() {
            return this.encoder;
        }
    }

    private class ProtocolDecoderImpl
    extends CumulativeProtocolDecoder {
        private final MessageDecoder[] decoders;
        private MessageDecoder currentDecoder;

        protected ProtocolDecoderImpl() throws Exception {
            MessageDecoderFactory[] decoderFactories = DemuxingProtocolCodecFactory.this.decoderFactories;
            this.decoders = new MessageDecoder[decoderFactories.length];
            for (int i = decoderFactories.length - 1; i >= 0; --i) {
                this.decoders[i] = decoderFactories[i].getDecoder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
            MessageDecoderResult result;
            if (this.currentDecoder == null) {
                MessageDecoder[] decoders = this.decoders;
                int undecodables = 0;
                for (int i = decoders.length - 1; i >= 0; --i) {
                    MessageDecoderResult result2;
                    MessageDecoder decoder = decoders[i];
                    int limit = in.limit();
                    int pos = in.position();
                    try {
                        result2 = decoder.decodable(session, in);
                    }
                    finally {
                        in.position(pos);
                        in.limit(limit);
                    }
                    if (result2 == MessageDecoder.OK) {
                        this.currentDecoder = decoder;
                        break;
                    }
                    if (result2 == MessageDecoder.NOT_OK) {
                        ++undecodables;
                        continue;
                    }
                    if (result2 == MessageDecoder.NEED_DATA) continue;
                    throw new IllegalStateException("Unexpected decode result (see your decodable()): " + result2);
                }
                if (undecodables == decoders.length) {
                    String dump = in.getHexDump();
                    in.position(in.limit());
                    throw new ProtocolDecoderException("No appropriate message decoder: " + dump);
                }
                if (this.currentDecoder == null) {
                    return false;
                }
            }
            if ((result = this.currentDecoder.decode(session, in, out)) == MessageDecoder.OK) {
                this.currentDecoder = null;
                return true;
            }
            if (result == MessageDecoder.NEED_DATA) {
                return false;
            }
            if (result == MessageDecoder.NOT_OK) {
                throw new ProtocolDecoderException("Message decoder returned NOT_OK.");
            }
            throw new IllegalStateException("Unexpected decode result (see your decode()): " + result);
        }

        public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
            if (this.currentDecoder == null) {
                return;
            }
            this.currentDecoder.finishDecode(session, out);
        }

        public void dispose(IoSession session) throws Exception {
            super.dispose(session);
        }
    }

    private class ProtocolEncoderImpl
    implements ProtocolEncoder {
        private final Map encoders = new IdentityHashMap();

        private ProtocolEncoderImpl() throws Exception {
            MessageEncoderFactory[] encoderFactories = DemuxingProtocolCodecFactory.this.encoderFactories;
            for (int i = encoderFactories.length - 1; i >= 0; --i) {
                MessageEncoder encoder = encoderFactories[i].getEncoder();
                Set messageTypes = encoder.getMessageTypes();
                if (messageTypes == null) {
                    throw new IllegalStateException(encoder.getClass().getName() + "#getMessageTypes() may not return null.");
                }
                Iterator it = messageTypes.iterator();
                while (it.hasNext()) {
                    Class type = (Class)it.next();
                    this.encoders.put(type, encoder);
                }
            }
        }

        public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
            Class<?> type = message.getClass();
            MessageEncoder encoder = this.findEncoder(type);
            if (encoder == null) {
                throw new ProtocolEncoderException("Unexpected message type: " + type);
            }
            encoder.encode(session, message, out);
        }

        private MessageEncoder findEncoder(Class type) {
            MessageEncoder encoder = (MessageEncoder)this.encoders.get(type);
            if (encoder == null) {
                encoder = this.findEncoder(type, new IdentityHashSet());
            }
            return encoder;
        }

        private MessageEncoder findEncoder(Class type, Set triedClasses) {
            if (triedClasses.contains(type)) {
                return null;
            }
            triedClasses.add(type);
            MessageEncoder encoder = (MessageEncoder)this.encoders.get(type);
            if (encoder == null) {
                encoder = this.findEncoder(type, triedClasses);
                if (encoder != null) {
                    return encoder;
                }
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    encoder = this.findEncoder(interfaces[i], triedClasses);
                    if (encoder == null) continue;
                    return encoder;
                }
                return null;
            }
            return encoder;
        }

        public void dispose(IoSession session) throws Exception {
            DemuxingProtocolCodecFactory.this.disposeCodecResources(session);
        }
    }
}

