/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.demux;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.handler.demux.UnknownMessageTypeException;
import org.apache.mina.util.IdentityHashSet;

public class DemuxingIoHandler
extends IoHandlerAdapter {
    private final Map findHandlerCache = new Hashtable();
    private final Map type2handler = new Hashtable();

    public MessageHandler addMessageHandler(Class type, MessageHandler handler) {
        this.findHandlerCache.clear();
        return this.type2handler.put(type, handler);
    }

    public MessageHandler removeMessageHandler(Class type) {
        this.findHandlerCache.clear();
        return (MessageHandler)this.type2handler.remove(type);
    }

    public MessageHandler getMessageHandler(Class type) {
        return (MessageHandler)this.type2handler.get(type);
    }

    public Map getMessageHandlerMap() {
        return Collections.unmodifiableMap(this.type2handler);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        MessageHandler handler = this.findHandler(message.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No message handler found for message: " + message);
        }
        handler.messageReceived(session, message);
    }

    protected MessageHandler findHandler(Class type) {
        return this.findHandler(type, null);
    }

    private MessageHandler findHandler(Class type, Set triedClasses) {
        Class superclass;
        MessageHandler handler = null;
        if (triedClasses != null && triedClasses.contains(type)) {
            return null;
        }
        handler = (MessageHandler)this.findHandlerCache.get(type);
        if (handler != null) {
            return handler;
        }
        handler = (MessageHandler)this.type2handler.get(type);
        if (handler == null) {
            if (triedClasses == null) {
                triedClasses = new IdentityHashSet();
            }
            triedClasses.add(type);
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length && (handler = this.findHandler(interfaces[i], triedClasses)) == null; ++i) {
            }
        }
        if (handler == null && (superclass = type.getSuperclass()) != null) {
            handler = this.findHandler(superclass);
        }
        if (handler != null) {
            this.findHandlerCache.put(type, handler);
        }
        return handler;
    }
}

