/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.support;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class IoSessionOutputStream
extends OutputStream {
    private final IoSession session;
    private WriteFuture lastWriteFuture;

    public IoSessionOutputStream(IoSession session) {
        this.session = session;
    }

    public void close() {
        this.session.close().join();
    }

    private void checkClosed() throws IOException {
        if (!this.session.isConnected()) {
            throw new IOException("The session has been closed.");
        }
    }

    private synchronized void write(ByteBuffer buf) throws IOException {
        WriteFuture future;
        this.checkClosed();
        this.lastWriteFuture = future = this.session.write(buf);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b, off, len));
    }

    public void write(int b) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)b);
        buf.flip();
        this.write(buf);
    }

    public synchronized void flush() throws IOException {
        if (this.lastWriteFuture == null) {
            return;
        }
        this.lastWriteFuture.join();
        if (!this.lastWriteFuture.isWritten()) {
            throw new IOException("The bytes could not be written to the session");
        }
    }
}

