/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.BooleanBinding;
import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.CharacterBinding;
import com.sleepycat.bind.tuple.DoubleBinding;
import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.ShortBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;
import java.util.HashMap;
import java.util.Map;

public abstract class TupleBinding
extends TupleBase
implements EntryBinding {
    private static final Map primitives = new HashMap();

    private static void addPrimitive(Class cls1, Class cls2, TupleBinding binding) {
        primitives.put(cls1, binding);
        primitives.put(cls2, binding);
    }

    public Object entryToObject(DatabaseEntry entry) {
        return this.entryToObject(TupleBinding.entryToInput(entry));
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        TupleOutput output = this.getTupleOutput(object);
        this.objectToEntry(object, output);
        TupleBinding.outputToEntry(output, entry);
    }

    public abstract Object entryToObject(TupleInput var1);

    public abstract void objectToEntry(Object var1, TupleOutput var2);

    public static TupleBinding getPrimitiveBinding(Class cls) {
        return (TupleBinding)primitives.get(cls);
    }

    static {
        TupleBinding.addPrimitive(String.class, String.class, new StringBinding());
        TupleBinding.addPrimitive(Character.class, Character.TYPE, new CharacterBinding());
        TupleBinding.addPrimitive(Boolean.class, Boolean.TYPE, new BooleanBinding());
        TupleBinding.addPrimitive(Byte.class, Byte.TYPE, new ByteBinding());
        TupleBinding.addPrimitive(Short.class, Short.TYPE, new ShortBinding());
        TupleBinding.addPrimitive(Integer.class, Integer.TYPE, new IntegerBinding());
        TupleBinding.addPrimitive(Long.class, Long.TYPE, new LongBinding());
        TupleBinding.addPrimitive(Float.class, Float.TYPE, new FloatBinding());
        TupleBinding.addPrimitive(Double.class, Double.TYPE, new DoubleBinding());
    }
}

