/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class EnvironmentMutableConfig
implements Cloneable {
    private boolean txnNoSync = false;
    private boolean txnWriteNoSync = false;
    protected long cacheSize;
    private Properties props;
    private boolean loadPropertyFile = true;
    private boolean validateParams = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnvironmentMutableConfig() {
        this.props = new Properties();
    }

    EnvironmentMutableConfig(Properties properties) throws IllegalArgumentException {
        this.validateProperties(properties);
        this.props = new Properties();
        this.props.putAll((Map<?, ?>)properties);
    }

    public void setTxnNoSync(boolean noSync) {
        this.txnNoSync = noSync;
    }

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public void setTxnWriteNoSync(boolean writeNoSync) {
        this.txnWriteNoSync = writeNoSync;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public void setCacheSize(long totalBytes) throws IllegalArgumentException {
        this.setVal(EnvironmentParams.MAX_MEMORY, Long.toString(totalBytes));
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCachePercent(int percent) throws IllegalArgumentException {
        this.setVal(EnvironmentParams.MAX_MEMORY_PERCENT, Integer.toString(percent));
    }

    public int getCachePercent() {
        String val = this.getVal(EnvironmentParams.MAX_MEMORY_PERCENT);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cache percent is not a valid integer: " + e.getMessage());
        }
    }

    public void setConfigParam(String paramName, String value) throws IllegalArgumentException {
        ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment configuration");
        }
        if (!param.isMutable()) {
            throw new IllegalArgumentException(paramName + " is not a mutable BDBJE environment configuration");
        }
        this.setVal(param, value);
    }

    public String getConfigParam(String paramName) throws IllegalArgumentException {
        ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment configuration");
        }
        return this.getVal(param);
    }

    String getVal(ConfigParam param) {
        String val = this.props.getProperty(param.getName());
        if (val == null) {
            val = param.getDefault();
        }
        return val;
    }

    void setVal(ConfigParam param, String val) throws IllegalArgumentException {
        if (this.validateParams) {
            param.validateValue(val);
        }
        this.props.setProperty(param.getName(), val);
    }

    void setValidateParams(boolean validateParams) {
        this.validateParams = validateParams;
    }

    void validateProperties(Properties props) throws IllegalArgumentException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(name);
            if (param == null) {
                throw new IllegalArgumentException(name + " is not a valid BDBJE environment configuration");
            }
            param.validateValue(props.getProperty(name));
        }
    }

    void checkImmutablePropsForEquality(EnvironmentMutableConfig passedConfig) throws IllegalArgumentException {
        Properties passedProps = passedConfig.props;
        Iterator iter = EnvironmentParams.SUPPORTED_PARAMS.keySet().iterator();
        while (iter.hasNext()) {
            String paramName = (String)iter.next();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (!$assertionsDisabled && param == null) {
                throw new AssertionError();
            }
            if (param.isMutable()) continue;
            String paramVal = this.props.getProperty(paramName);
            String useParamVal = passedProps.getProperty(paramName);
            if (!(paramVal != null ? !paramVal.equals(useParamVal) : useParamVal != null)) continue;
            throw new IllegalArgumentException(paramName + " is set to " + useParamVal + " in the config parameter" + " which is incompatible" + " with the value of " + paramVal + " in the" + " underlying environment");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        EnvironmentMutableConfig copy = (EnvironmentMutableConfig)super.clone();
        copy.props = (Properties)this.props.clone();
        return copy;
    }

    EnvironmentMutableConfig cloneMutableConfig() {
        try {
            EnvironmentMutableConfig copy = (EnvironmentMutableConfig)this.clone();
            copy.clearImmutableProps();
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void copyHandlePropsTo(EnvironmentMutableConfig other) {
        other.txnNoSync = this.txnNoSync;
        other.txnWriteNoSync = this.txnWriteNoSync;
    }

    void copyMutablePropsTo(EnvironmentMutableConfig toConfig) {
        Properties toProps = toConfig.props;
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (!$assertionsDisabled && param == null) {
                throw new AssertionError();
            }
            if (!param.isMutable()) continue;
            String newVal = this.props.getProperty(paramName);
            toProps.setProperty(paramName, newVal);
        }
    }

    void fillInEnvironmentGeneratedProps(EnvironmentImpl envImpl) {
        this.cacheSize = envImpl.getMemoryBudget().getMaxMemory();
    }

    private void clearImmutableProps() {
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            if (!$assertionsDisabled && param == null) {
                throw new AssertionError();
            }
            if (param.isMutable()) continue;
            this.props.remove(paramName);
        }
    }

    void setLoadPropertyFile(boolean loadPropertyFile) {
        this.loadPropertyFile = loadPropertyFile;
    }

    boolean getLoadPropertyFile() {
        return this.loadPropertyFile;
    }

    int getNumExplicitlySetParams() {
        return this.props.size();
    }

    public String toString() {
        return this.props.toString();
    }

    static {
        $assertionsDisabled = !EnvironmentMutableConfig.class.desiredAssertionStatus();
    }
}

