/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.WriteLockInfo;
import java.nio.ByteBuffer;
import java.util.Map;

public class LN
extends Node
implements LoggableObject,
LogReadable {
    private static final String BEGIN_TAG = "<ln>";
    private static final String END_TAG = "</ln>";
    private byte[] data;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LN() {
        super(false);
        this.data = null;
    }

    public LN(byte[] data) {
        super(true);
        if (data == null) {
            this.data = null;
        } else {
            this.init(data, 0, data.length);
        }
    }

    public LN(DatabaseEntry dbt) {
        super(true);
        byte[] data = dbt.getData();
        if (data == null) {
            this.data = null;
        } else if (dbt.getPartial()) {
            this.init(data, dbt.getOffset(), dbt.getPartialOffset() + dbt.getSize(), dbt.getPartialOffset(), dbt.getSize());
        } else {
            this.init(data, dbt.getOffset(), dbt.getSize());
        }
    }

    private void init(byte[] data, int off, int len, int doff, int dlen) {
        if (len == 0) {
            this.data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        } else {
            this.data = new byte[len];
            System.arraycopy(data, off, this.data, doff, dlen);
        }
    }

    private void init(byte[] data, int off, int len) {
        this.init(data, off, len, 0, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] copyData() {
        int len = this.data.length;
        byte[] ret = new byte[len];
        System.arraycopy(this.data, 0, ret, 0, len);
        return ret;
    }

    public boolean isDeleted() {
        return this.data == null;
    }

    void makeDeleted() {
        this.data = null;
    }

    boolean isValidForDelete() {
        return false;
    }

    protected boolean isSoughtNode(long nid, boolean updateGeneration) {
        return false;
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return false;
    }

    public long delete(DatabaseImpl database, byte[] lnKey, byte[] dupKey, long oldLsn, Locker locker) throws DatabaseException {
        this.makeDeleted();
        EnvironmentImpl env = database.getDbEnvironment();
        long newLsn = -1L;
        if (dupKey != null) {
            Txn logTxn;
            boolean logAbortKnownDeleted;
            long logAbortLsn;
            LogEntryType entryType;
            if (locker.isTransactional()) {
                entryType = LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL;
                WriteLockInfo info = locker.getWriteLockInfo(this.getNodeId());
                logAbortLsn = info.getAbortLsn();
                logAbortKnownDeleted = info.getAbortKnownDeleted();
                logTxn = locker.getTxnLocker();
            } else {
                entryType = LogEntryType.LOG_DEL_DUPLN;
                logAbortLsn = -1L;
                logAbortKnownDeleted = true;
                logTxn = null;
            }
            if (oldLsn == logAbortLsn) {
                oldLsn = -1L;
            }
            DeletedDupLNLogEntry logEntry = new DeletedDupLNLogEntry(entryType, this, database.getId(), dupKey, lnKey, logAbortLsn, logAbortKnownDeleted, logTxn);
            LogManager logManager = env.getLogManager();
            newLsn = logManager.log(logEntry, false, oldLsn);
        } else {
            newLsn = this.log(env, database.getId(), lnKey, oldLsn, locker);
        }
        return newLsn;
    }

    public long modify(byte[] newData, DatabaseImpl database, byte[] lnKey, long oldLsn, Locker locker) throws DatabaseException {
        this.data = newData;
        EnvironmentImpl env = database.getDbEnvironment();
        long newLsn = this.log(env, database.getId(), lnKey, oldLsn, locker);
        return newLsn;
    }

    void addToDirtyMap(Map dirtyMap) {
    }

    void rebuildINList(INList inList) {
    }

    void accountForSubtreeRemoval(INList inList, UtilizationTracker tracker) {
    }

    public long getMemorySizeIncludedByParent() {
        int size = MemoryBudget.LN_OVERHEAD;
        if (this.data != null) {
            size += MemoryBudget.byteArraySize(this.data.length);
        }
        return size;
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer self = new StringBuffer();
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.beginTag());
            self.append('\n');
        }
        self.append(super.dumpString(nSpaces + 2, true));
        self.append('\n');
        if (this.data != null) {
            self.append(TreeUtils.indent(nSpaces + 2));
            self.append("<data>");
            self.append(TreeUtils.dumpByteArray(this.data));
            self.append("</data>");
            self.append('\n');
        }
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.endTag());
        }
        return self.toString();
    }

    public long logProvisional(EnvironmentImpl env, DatabaseId dbId, byte[] key, long oldLsn) throws DatabaseException {
        return this.log(env, dbId, key, oldLsn, null, true);
    }

    public long log(EnvironmentImpl env, DatabaseId dbId, byte[] key, long oldLsn, Locker locker) throws DatabaseException {
        return this.log(env, dbId, key, oldLsn, locker, false);
    }

    private long log(EnvironmentImpl env, DatabaseId dbId, byte[] key, long oldLsn, Locker locker, boolean isProvisional) throws DatabaseException {
        Txn logTxn;
        boolean logAbortKnownDeleted;
        long logAbortLsn;
        LogEntryType entryType;
        if (locker != null && locker.isTransactional()) {
            entryType = this.getTransactionalLogType();
            WriteLockInfo info = locker.getWriteLockInfo(this.getNodeId());
            logAbortLsn = info.getAbortLsn();
            logAbortKnownDeleted = info.getAbortKnownDeleted();
            logTxn = locker.getTxnLocker();
            if (!$assertionsDisabled && logTxn == null) {
                throw new AssertionError();
            }
        } else {
            entryType = this.getLogType();
            logAbortLsn = -1L;
            logAbortKnownDeleted = false;
            logTxn = null;
        }
        if (oldLsn == logAbortLsn) {
            oldLsn = -1L;
        }
        LNLogEntry logEntry = new LNLogEntry(entryType, this, dbId, key, logAbortLsn, logAbortKnownDeleted, logTxn);
        LogManager logManager = env.getLogManager();
        return logManager.log(logEntry, isProvisional, oldLsn);
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_LN_TRANSACTIONAL;
    }

    public boolean countAsObsoleteWhenLogged() {
        return false;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_LN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        size += LogUtils.getBooleanLogSize();
        if (!this.isDeleted()) {
            size += LogUtils.getByteArrayLogSize(this.data);
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        boolean dataExists = !this.isDeleted();
        LogUtils.writeBoolean(logBuffer, dataExists);
        if (dataExists) {
            LogUtils.writeByteArray(logBuffer, this.data);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        super.readFromLog(itemBuffer, entryTypeVersion);
        boolean dataExists = LogUtils.readBoolean(itemBuffer);
        if (dataExists) {
            this.data = LogUtils.readByteArray(itemBuffer);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        if (this.data != null) {
            sb.append("<data>");
            sb.append(TreeUtils.dumpByteArray(this.data));
            sb.append("</data>");
        }
        this.dumpLogAdditional(sb, verbose);
        sb.append(this.endTag());
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    protected void dumpLogAdditional(StringBuffer sb, boolean verbose) {
    }

    static {
        $assertionsDisabled = !LN.class.desiredAssertionStatus();
    }
}

