/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.InvalidMessage;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.CriticalProtocolCodecException;
import quickfix.mina.NetworkingOptions;

public abstract class AbstractIoHandler
extends IoHandlerAdapter {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NetworkingOptions networkingOptions;

    public AbstractIoHandler(NetworkingOptions options) {
        this.networkingOptions = options;
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        boolean disconnectNeeded = false;
        Session quickFixSession = this.findQFSession(ioSession);
        if (cause instanceof ProtocolDecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof IOException) {
            SocketAddress remoteAddress = ioSession.getRemoteAddress();
            String message = cause.getMessage();
            this.log.error("socket exception (" + remoteAddress + "): " + message);
            disconnectNeeded = true;
        } else if (cause instanceof CriticalProtocolCodecException) {
            this.log.error("critical protocol codec error: " + cause.getMessage());
            disconnectNeeded = true;
        } else if (cause instanceof ProtocolCodecException) {
            String text = "protocol handler exception: " + cause.getMessage();
            if (quickFixSession != null) {
                quickFixSession.getLog().onEvent(text);
            } else {
                this.log.error(text);
            }
        } else if (quickFixSession != null) {
            LogUtil.logThrowable(quickFixSession.getLog(), cause.getMessage(), cause);
        } else {
            this.log.error("protocol handler exception", cause);
        }
        if (disconnectNeeded) {
            if (quickFixSession != null) {
                quickFixSession.disconnect();
            } else {
                ioSession.close();
            }
        }
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        super.sessionCreated(ioSession);
        this.networkingOptions.apply(ioSession);
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        Session quickFixSession = this.findQFSession(ioSession);
        if (quickFixSession != null) {
            ioSession.removeAttribute("QF_SESSION");
            if (quickFixSession.hasResponder()) {
                quickFixSession.disconnect();
            }
        }
    }

    public void messageReceived(IoSession ioSession, Object message) throws Exception {
        block5: {
            String messageString = (String)message;
            SessionID remoteSessionID = MessageUtils.getReverseSessionID(messageString);
            Session quickFixSession = this.findQFSession(ioSession, remoteSessionID);
            if (quickFixSession != null) {
                quickFixSession.getLog().onIncoming(messageString);
                try {
                    Message fixMessage = MessageUtils.parse(quickFixSession, messageString);
                    this.processMessage(ioSession, fixMessage);
                }
                catch (InvalidMessage e) {
                    if ("A".equals(MessageUtils.getMessageType(messageString))) {
                        this.log.error("Invalid LOGON message, disconnecting: " + e.getMessage());
                        ioSession.close();
                        break block5;
                    }
                    this.log.error("Invalid message: " + e.getMessage());
                }
            } else {
                this.log.error("Disconnecting; received message for unknown session: " + messageString);
                ioSession.close();
            }
        }
    }

    protected Session findQFSession(IoSession ioSession, SessionID sessionID) {
        Session quickfixSession = this.findQFSession(ioSession);
        if (quickfixSession == null) {
            quickfixSession = Session.lookupSession(sessionID);
        }
        return quickfixSession;
    }

    private Session findQFSession(IoSession ioSession) {
        return (Session)ioSession.getAttribute("QF_SESSION");
    }

    protected NetworkingOptions getNetworkingOptions() {
        return this.networkingOptions;
    }

    protected abstract void processMessage(IoSession var1, Message var2) throws Exception;
}

