/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Responder;

public class IoSessionResponder
implements Responder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IoSession ioSession;
    private final boolean synchronousWrites;
    private final long synchronousWriteTimeout;

    public IoSessionResponder(IoSession session, boolean synchronousWrites, long synchronousWriteTimeout) {
        this.ioSession = session;
        this.synchronousWrites = synchronousWrites;
        this.synchronousWriteTimeout = synchronousWriteTimeout;
    }

    public boolean send(String data) {
        WriteFuture future = this.ioSession.write((Object)data);
        if (this.synchronousWrites) {
            try {
                if (!future.join(this.synchronousWriteTimeout)) {
                    this.log.error("Synchronous write timed out after " + this.synchronousWriteTimeout + "ms");
                    return false;
                }
            }
            catch (RuntimeException e) {
                this.log.error("Synchronous write failed: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void disconnect() {
        this.waitForScheduleMessagesToBeWritten();
        this.ioSession.close();
    }

    private void waitForScheduleMessagesToBeWritten() {
        for (int i = 0; i < 5 && this.ioSession.getScheduledWriteRequests() > 0; ++i) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String getRemoteIPAddress() {
        return this.ioSession.getRemoteAddress().toString();
    }
}

