/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._Integer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.FieldConvertError;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.IntConverter;

public class NetworkingOptions {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Boolean keepAlive;
    private final Boolean oobInline;
    private final Integer receiveBufferSize;
    private final Boolean reuseAddress;
    private final Integer sendBufferSize;
    private final Integer soLinger;
    private final Boolean tcpNoDelay;
    private final Integer trafficClass;
    private final Boolean synchronousWrites;
    private final Integer synchronousWriteTimeout;
    public static final String SETTING_SOCKET_KEEPALIVE = "SocketKeepAlive";
    public static final String SETTING_SOCKET_OOBINLINE = "SocketOobInline";
    public static final String SETTING_SOCKET_RECEIVE_BUFFER_SIZE = "SocketReceiveBufferSize";
    public static final String SETTING_SOCKET_REUSE_ADDRESS = "SocketReuseAddress";
    public static final String SETTING_SOCKET_SEND_BUFFER_SIZE = "SocketSendBufferSize";
    public static final String SETTING_SOCKET_LINGER = "SocketLinger";
    public static final String SETTING_SOCKET_TCP_NODELAY = "SocketTcpNoDelay";
    public static final String SETTING_SOCKET_TRAFFIC_CLASS = "SocketTrafficClass";
    public static final String SETTING_SOCKET_SYNCHRONOUS_WRITES = "SocketSynchronousWrites";
    public static final String SETTING_SOCKET_SYNCHRONOUS_WRITE_TIMEOUT = "SocketSynchronousWriteTimeout";
    public static final String IPTOC_LOWCOST = "IPTOS_LOWCOST";
    public static final String IPTOC_RELIABILITY = "IPTOS_RELIABILITY";
    public static final String IPTOC_THROUGHPUT = "IPTOS_THROUGHPUT";
    public static final String IPTOC_LOWDELAY = "IPTOS_LOWDELAY";
    public static final Map<String, Integer> trafficClasses = new HashMap<String, Integer>();

    public NetworkingOptions(Properties properties) throws FieldConvertError {
        Integer trafficClassSetting;
        this.keepAlive = this.getBoolean(properties, SETTING_SOCKET_KEEPALIVE, null);
        this.oobInline = this.getBoolean(properties, SETTING_SOCKET_OOBINLINE, null);
        this.receiveBufferSize = this.getInteger(properties, SETTING_SOCKET_RECEIVE_BUFFER_SIZE, null);
        this.reuseAddress = this.getBoolean(properties, SETTING_SOCKET_REUSE_ADDRESS, null);
        this.sendBufferSize = this.getInteger(properties, SETTING_SOCKET_SEND_BUFFER_SIZE, null);
        this.soLinger = this.getInteger(properties, SETTING_SOCKET_LINGER, null);
        this.tcpNoDelay = this.getBoolean(properties, SETTING_SOCKET_TCP_NODELAY, Boolean.TRUE);
        this.synchronousWrites = this.getBoolean(properties, SETTING_SOCKET_SYNCHRONOUS_WRITES, Boolean.FALSE);
        this.synchronousWriteTimeout = this.getInteger(properties, SETTING_SOCKET_SYNCHRONOUS_WRITE_TIMEOUT, _Integer.valueOf(30000));
        try {
            trafficClassSetting = this.getInteger(properties, SETTING_SOCKET_TRAFFIC_CLASS, null);
        }
        catch (FieldConvertError e) {
            String trafficClassEnumString = properties.getProperty(SETTING_SOCKET_TRAFFIC_CLASS);
            int trafficClassBits = 0;
            String[] trafficClassEnums = trafficClassEnumString.split("[,|]");
            for (int i = 0; i < trafficClassEnums.length; ++i) {
                if (trafficClasses.containsKey(trafficClassEnums[i])) {
                    trafficClassBits |= trafficClasses.get(trafficClassEnums[i]).intValue();
                    continue;
                }
                throw new FieldConvertError("Can't parse traffic class: " + trafficClassEnums[i]);
            }
            trafficClassSetting = _Integer.valueOf(trafficClassBits);
            this.log.info("Socket option: SocketTrafficClass= 0x" + Integer.toHexString(trafficClassBits) + " (" + trafficClassEnumString + ")");
        }
        this.trafficClass = trafficClassSetting;
    }

    private Boolean getBoolean(Properties properties, String key, Boolean defaultValue) throws FieldConvertError {
        Boolean value = properties.containsKey(key) ? Boolean.valueOf(BooleanConverter.convert(properties.getProperty(key))) : defaultValue;
        this.logOption(key, value);
        return value;
    }

    private void logOption(String key, Object value) {
        if (value != null) {
            this.log.info("Socket option: " + key + "=" + value);
        }
    }

    private Integer getInteger(Properties properties, String key, Integer defaultValue) throws FieldConvertError {
        Integer value = properties.containsKey(key) ? _Integer.valueOf(IntConverter.convert(properties.getProperty(key))) : defaultValue;
        this.logOption(key, value);
        return value;
    }

    public void apply(IoSession session) throws SocketException {
        IoSessionConfig sessionConfig = session.getConfig();
        if (sessionConfig instanceof SocketSessionConfig) {
            SocketSessionConfig socketSessionConfig = (SocketSessionConfig)sessionConfig;
            if (this.keepAlive != null) {
                socketSessionConfig.setKeepAlive(this.keepAlive.booleanValue());
            }
            if (this.oobInline != null) {
                socketSessionConfig.setOobInline(this.oobInline.booleanValue());
            }
            if (this.receiveBufferSize != null) {
                socketSessionConfig.setReceiveBufferSize(this.receiveBufferSize.intValue());
            }
            if (this.reuseAddress != null) {
                socketSessionConfig.setReuseAddress(this.reuseAddress.booleanValue());
            }
            if (this.sendBufferSize != null) {
                socketSessionConfig.setSendBufferSize(this.sendBufferSize.intValue());
            }
            if (this.soLinger != null) {
                int linger = this.soLinger;
                socketSessionConfig.setSoLinger(linger);
            }
            if (this.tcpNoDelay != null) {
                socketSessionConfig.setTcpNoDelay(this.tcpNoDelay.booleanValue());
            }
            if (this.trafficClass != null) {
                socketSessionConfig.setTrafficClass(this.trafficClass.intValue());
            }
        }
    }

    public Boolean getSynchronousWrites() {
        return this.synchronousWrites;
    }

    public Integer getSynchronousWriteTimeout() {
        return this.synchronousWriteTimeout;
    }

    static {
        trafficClasses.put(IPTOC_LOWCOST, _Integer.valueOf(2));
        trafficClasses.put(IPTOC_RELIABILITY, _Integer.valueOf(4));
        trafficClasses.put(IPTOC_THROUGHPUT, _Integer.valueOf(8));
        trafficClasses.put(IPTOC_LOWDELAY, _Integer.valueOf(16));
    }
}

