/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class SSLSupport {
    public static final String FILTER_NAME = "SSLFilter";
    public static final String SETTING_KEY_STORE_PWD = "SocketKeyStorePassword";
    public static final String SETTING_KEY_STORE_NAME = "SocketKeyStore";
    public static final String SETTING_USE_SSL = "SocketUseSSL";
    static final String QUICKFIXJ_CERT = "quickfixj.cert";
    static final String QUICKFIXJ_PW = "quickfixjpw";

    public static String getKeystoreName(SessionSettings settings, SessionID sessionID) {
        String keyStoreName = QUICKFIXJ_CERT;
        if (settings.isSetting(sessionID, SETTING_KEY_STORE_NAME)) {
            try {
                keyStoreName = settings.getString(sessionID, SETTING_KEY_STORE_NAME);
            }
            catch (ConfigError ignored) {
            }
            catch (FieldConvertError fieldConvertError) {
                // empty catch block
            }
        }
        return keyStoreName;
    }

    public static String getKeystorePasswd(SessionSettings settings, SessionID sessionID) {
        String keyStorePassword = QUICKFIXJ_PW;
        if (settings.isSetting(sessionID, SETTING_KEY_STORE_PWD)) {
            try {
                keyStorePassword = settings.getString(sessionID, SETTING_KEY_STORE_PWD);
            }
            catch (ConfigError ignored) {
            }
            catch (FieldConvertError fieldConvertError) {
                // empty catch block
            }
        }
        return keyStorePassword;
    }
}

