/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.Modifier;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.cglib.proxy.Callback;
import org.logicalcobwebs.cglib.proxy.Enhancer;
import org.logicalcobwebs.cglib.proxy.Factory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyDatabaseMetaData;
import org.logicalcobwebs.proxool.ProxyStatement;
import org.logicalcobwebs.proxool.WrappedConnection;

class ProxyFactory {
    private static final Log LOG = LogFactory.getLog((Class)ProxyFactory.class);
    private static Map interfaceMap = new HashMap();

    ProxyFactory() {
    }

    protected static Connection getWrappedConnection(ProxyConnection proxyConnection) {
        return (Connection)ProxyFactory.getProxy(proxyConnection.getConnection(), new WrappedConnection(proxyConnection), proxyConnection.getDefinition());
    }

    protected static Statement getStatement(Statement delegate, ConnectionPool connectionPool, ProxyConnectionIF proxyConnection, String sqlStatement) {
        return (Statement)ProxyFactory.getProxy(delegate, new ProxyStatement(delegate, connectionPool, proxyConnection, sqlStatement), proxyConnection.getDefinition());
    }

    protected static DatabaseMetaData getDatabaseMetaData(DatabaseMetaData databaseMetaData, Connection wrappedConnection) {
        return (DatabaseMetaData)ProxyFactory.getProxy(databaseMetaData, new ProxyDatabaseMetaData(databaseMetaData, wrappedConnection), null);
    }

    private static Object getProxy(Object delegate, Callback callback, ConnectionPoolDefinitionIF def) {
        Enhancer e = new Enhancer();
        e.setInterfaces(ProxyFactory.getInterfaces(delegate.getClass(), def));
        e.setCallback(callback);
        e.setClassLoader(ProxyFactory.class.getClassLoader());
        return e.create();
    }

    protected static Statement getDelegateStatement(Statement statement) {
        Statement ds = statement;
        ProxyStatement ps = (ProxyStatement)((Factory)((Object)statement)).getCallback(0);
        ds = ps.getDelegateStatement();
        return ds;
    }

    protected static Connection getDelegateConnection(Connection connection) {
        WrappedConnection wc = (WrappedConnection)((Factory)((Object)connection)).getCallback(0);
        return wc.getProxyConnection().getConnection();
    }

    private static Class[] getInterfaces(Class clazz, ConnectionPoolDefinitionIF cpd) {
        Class[] interfaceArray = (Class[])interfaceMap.get(clazz);
        if (interfaceArray == null) {
            HashSet<Class> interfaces = new HashSet<Class>();
            ProxyFactory.traverseInterfacesRecursively(interfaces, clazz);
            if (cpd != null) {
                Class injectableClass;
                if (Connection.class.isAssignableFrom(clazz) && (injectableClass = cpd.getInjectableConnectionInterface()) != null) {
                    interfaces.add(injectableClass);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Injecting " + injectableClass + " into " + clazz));
                    }
                }
                if (CallableStatement.class.isAssignableFrom(clazz)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Getting injectableCallableStatementInterface");
                    }
                    if ((injectableClass = cpd.getInjectableCallableStatementInterface()) != null) {
                        interfaces.add(injectableClass);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Injecting " + injectableClass + " into " + clazz));
                        }
                    }
                }
                if (PreparedStatement.class.isAssignableFrom(clazz) && (injectableClass = cpd.getInjectablePreparedStatementInterface()) != null) {
                    interfaces.add(injectableClass);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Injecting " + injectableClass + " into " + clazz));
                    }
                }
                if (Statement.class.isAssignableFrom(clazz) && (injectableClass = cpd.getInjectableStatementInterface()) != null) {
                    interfaces.add(injectableClass);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Injecting " + injectableClass + " into " + clazz));
                    }
                }
            }
            interfaceArray = interfaces.toArray(new Class[interfaces.size()]);
            if (LOG.isDebugEnabled()) {
                for (int i = 0; i < interfaceArray.length; ++i) {
                    Class aClass = interfaceArray[i];
                    LOG.debug((Object)("Implementing " + aClass));
                }
            }
            interfaceMap.put(clazz, interfaceArray);
        }
        return interfaceArray;
    }

    private static void traverseInterfacesRecursively(Set interfaces, Class clazz) {
        if (!interfaces.contains(clazz)) {
            Class<?>[] interfaceArray = clazz.getInterfaces();
            for (int i = 0; i < interfaceArray.length; ++i) {
                ProxyFactory.traverseInterfacesRecursively(interfaces, interfaceArray[i]);
                if (!Modifier.isPublic(interfaceArray[i].getModifiers())) continue;
                interfaces.add(interfaceArray[i]);
            }
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                ProxyFactory.traverseInterfacesRecursively(interfaces, superClazz);
            }
        }
    }

    public static WrappedConnection getWrappedConnection(Connection connection) {
        return (WrappedConnection)((Factory)((Object)connection)).getCallback(0);
    }
}

