/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSArray(SystemVersion).h"
#include <Carbon/Carbon.h>

@implementation NSArray(SystemVersion)

/* return the name of the transcript appropriate for the current version of the OS */
+ ( NSArray * )negativeTranscriptsForCurrentSystem
{
    SInt32		version;
    
    Gestalt( gestaltSystemVersion, &version );
    
    /* we don't support anything < 10.2.3 */
    if ( version < 0x00001023 ) {
        return( nil );
    }
    
    if ( version >= 0x00001023 && version < 0x00001030 ) {
        return( [ NSArray arrayWithObjects: @"10.2-desktop-negative",
                            @"10.2-lab-negative", nil ] );
    }
    
    if ( version >= 0x00001030 && version < 0x00001040 ) {
        return( [ NSArray arrayWithObjects: @"10.3-desktop-negative",
                            @"10.3-lab-negative", nil ] );
    }
    
    if ( version >= 0x00001040 && version < 0x00001050 ) {
	return( [ NSArray arrayWithObjects: @"10.4-desktop-negative",
                            @"10.4-lab-negative", nil ] );
    }
    
    return( nil );
}

@end
