/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSWorkspace(QuitOtherApplications).h"

@implementation NSWorkspace(QuitOtherApplications)

- ( BOOL )quitOtherOpenApplications
{
    NSArray		*openApplications = [[ NSWorkspace sharedWorkspace ] launchedApplications ];
    NSString		*name = nil, *scriptSource = nil;
    NSAppleScript	*as = nil;
    NSDictionary	*errorDict;
    unsigned int	i;
    
    for ( i = 0; i < [ openApplications count ]; i++ ) {
        name = [[ openApplications objectAtIndex: i ] objectForKey: @"NSApplicationName" ];
        
        if ( [ name isEqualToString: @"Radmind Assistant" ] ) {
            continue;
        }
        
        scriptSource = [ NSString stringWithFormat: @"tell application \"%@\"\rquit\rend tell", name ];
        
        as = [[ NSAppleScript alloc ] initWithSource: scriptSource ];
        
        if ( [ as executeAndReturnError: &errorDict ] == nil ) {
            NSLog( @"Couldn't quit %@: %@", name,
                    [ errorDict objectForKey: @"NSAppleScriptErrorMessage" ] );
            [ as release ];
            return( NO );
        }
        [ as release ];
    }
    
    return( YES );
}

@end
