/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import <Cocoa/Cocoa.h>
#import <Security/Authorization.h>

@class RCMStepController;

@protocol RAAuthExecInterface

- ( oneway void )onewayExecuteTool: ( int )tool
	    withArgs: ( NSArray * )args
	    controller: ( id )controller;

@end

@interface RAAuthExec : NSObject <RAAuthExecInterface> {
    NSString		*err;
}

+ ( void )connectWithPorts: ( NSArray * )ports;
- ( id )init;
- ( int )executeTool: ( int )tool withArgs: ( NSArray * )args
            controller: ( id )controller;

int	exec_command( AuthorizationRef authRef,
            int command,
            NSArray *args );
            

int	authorize_and_exec( AuthorizationItem right,
                int command,
                NSArray *args );

@end
