/* RAScriptManager */

#import <Cocoa/Cocoa.h>

#import "RASTableView.h"

@interface RAScriptManager : NSObject
{
    IBOutlet RASTableView   *scriptManagerPostApplyTable;
    IBOutlet RASTableView   *scriptManagerPreApplyTable;
    IBOutlet NSPanel	    *scriptManagerPanel;
    IBOutlet NSTabView	    *scriptManagerTabView;
    
@private
    NSArray		    *_raPreApplyScriptArray;
    NSArray		    *_raPostApplyScriptArray;
    int			    _raIndexOfActiveTabViewItem;
}

/* script array accessor methods */
- ( void )setPreApplyScriptArray: ( NSArray * )array;
- ( NSArray * )preApplyScriptArray;
- ( void )setPostApplyScriptArray: ( NSArray * )array;
- ( NSArray * )postApplyScriptArray;

/* active tabview item accessor methods */
- ( void )setIndexOfActiveTabViewItem: ( int )index;
- ( int )indexOfActiveTabViewItem;

- ( IBAction )installPrePostScript: ( id )sender;
- ( IBAction )removePrePostScript: ( id )sender;

- ( void )showScriptManagementPanelForWindow: ( NSWindow * )window;
- ( IBAction )dismissScriptManagerPanel: ( id )sender;

@end
