#import "RAScriptManager.h"
#import "RAAuthExec.h"
#import "AppDelegate.h"

@implementation RAScriptManager

static NSString		*tmpdir = nil;

- ( id )init
{
    _raPreApplyScriptArray = nil;
    _raPostApplyScriptArray = nil;
    _raIndexOfActiveTabViewItem = 0;
    
    self = [ super init ];
    return( self );
}

- ( void )awakeFromNib
{
    NSArray		*tables = [ NSArray arrayWithObjects: scriptManagerPreApplyTable,
					scriptManagerPostApplyTable, nil ];
    NSBrowserCell	*cell = [[[ NSBrowserCell alloc ] init ] autorelease ];
    NSTableColumn	*column;
    int			i;
    
    [ cell setImage: [ NSImage imageNamed: @"script.png" ]];
    [ cell setLeaf: YES ];
    [ cell setFont: [ NSFont systemFontOfSize: 12.0 ]];
    [ cell setEditable: NO ];
    
    for ( i = 0; i < [ tables count ]; i++ ) {
	 column = [[[ tables objectAtIndex: i ] tableColumns ] objectAtIndex: 0 ];
    
	[ column setDataCell: cell ];
	[ column setEditable: NO ];
    
	column = [[[ tables objectAtIndex: i ] tableColumns ] objectAtIndex: 1 ];
	[ column setEditable: NO ];
    
	[[ tables objectAtIndex: i ] setUsesAlternatingRowBackgroundColors: YES ];
	[[ tables objectAtIndex: i ] setAllowsColumnSelection: NO ];
	[[ tables objectAtIndex: i ] setTarget: self ];
	[[ tables objectAtIndex: i ] setAction: nil ];
	[[ tables objectAtIndex: i ] setDoubleAction: nil ];
	[[ tables objectAtIndex: i ] registerForDraggedTypes:
			    [ NSArray arrayWithObject: NSFilenamesPboardType ]];
    }
}

- ( void )setPreApplyScriptArray: ( NSArray * )array
{
    if ( _raPreApplyScriptArray != nil ) {
	[ _raPreApplyScriptArray release ];
	_raPreApplyScriptArray = nil;
    }
    
    _raPreApplyScriptArray = [ array retain ];
}

- ( NSArray * )preApplyScriptArray
{
    return( _raPreApplyScriptArray );
}

- ( void )setPostApplyScriptArray: ( NSArray * )array
{
    if ( _raPostApplyScriptArray != nil ) {
	[ _raPostApplyScriptArray release ];
	_raPostApplyScriptArray = nil;
    }
    
    _raPostApplyScriptArray = [ array retain ];
}

- ( NSArray * )postApplyScriptArray
{
    return( _raPostApplyScriptArray );
}

- ( void )setIndexOfActiveTabViewItem: ( int )index
{
    _raIndexOfActiveTabViewItem = index;
}

- ( int )indexOfActiveTabViewItem
{
    return( _raIndexOfActiveTabViewItem );
}

- ( void )installScript: ( NSString * )scriptPath
	    destination: ( NSString * )destination
{
    NSArray			*args;
    RAAuthExec			*rae = nil;
    int				rc;
    
    rae = [[ RAAuthExec alloc ] init ];
    
    args = [ NSArray arrayWithObjects: @"-A",
		@"InstallPrePostScript", @"--",
		scriptPath, destination, nil ];
		
    rc = [ rae executeTool: -1
		withArgs: args
		controller: nil ];
    [ rae release ];
    
    if ( rc != 0 ) {
	NSLog( @"failed to install %@", scriptPath );
	return;
    }
    
    [ self showScriptManagementPanelForWindow: nil ];
}

- ( IBAction )installPrePostScript: ( id )sender
{
    NSOpenPanel			*op = [ NSOpenPanel openPanel ];
    NSString			*path = nil;
    NSString			*type = nil;
    int				rc;
    
    [ op setCanChooseDirectories: NO ];
    [ op setAllowsMultipleSelection: NO ];
    [ op setPrompt: NSLocalizedString( @"Install", @"Install" ) ];
    [ op setTitle: NSLocalizedString( @"Install Script",
					@"Install Script" ) ];
					
    rc = [ op runModalForDirectory: nil file: nil types: nil ];
    switch ( rc ) {
    case NSOKButton:
	break;
	
    default:
	return;
    }
    
    path = [ op filename ];
    
    switch ( [ self indexOfActiveTabViewItem ] ) {
    case -1:
    default:
	NSLog( @"invalid active tabview index %d", [ self indexOfActiveTabViewItem ] );
	return;
	
    case 0:
	type = @"preapply";
	break;
	
    case 1:
	type = @"postapply";
	break;
    }
    
    [ self installScript: path destination: type ];
}

- ( IBAction )removePrePostScript:( id )sender
{
    NSAlert			*alert;
    NSArray			*args = nil, *items = nil;
    NSArray			*scriptArray = nil;
    NSString			*scriptPath, *scriptTmpPath, *scriptName;
    NSString			*scriptTmpDir = nil;
    RAAuthExec			*rae = nil;
    RASTableView		*table = nil;
    int				rc, row, optag;
    int				atv = [ self indexOfActiveTabViewItem ];
    
    switch ( atv ) {
    case -1:
    default:
	return;
	
    case 0:
	table = scriptManagerPreApplyTable;
	scriptArray = [ self preApplyScriptArray ];
	break;
	
    case 1:
	table = scriptManagerPostApplyTable;
	scriptArray = [ self postApplyScriptArray ];
	break;
    }

    if (( row = [ table selectedRow ] ) < 0 ) {
	NSLog( @"No script selected" );
	return;
    }
    
    scriptName = [[ scriptArray objectAtIndex: row ]
		    objectForKey: @"RAScriptName" ];
    
    alert = [ NSAlert alertWithMessageText:
		NSLocalizedString( @"Delete selected script?",
				    @"Delete selected script ?" )
		defaultButton: NSLocalizedString( @"Delete", @"Delete" )
		alternateButton: NSLocalizedString( @"Cancel", @"Cancel" )
		otherButton: @""
		informativeTextWithFormat:
		    NSLocalizedString( @"%@ will be moved to the trash.",
					@"%@ will be moved to the trash." ), scriptName ];
					
    rc = [ alert runModal ];
    switch ( rc ) {
    case NSOKButton:
    case NSAlertFirstButtonReturn:
	break;
	
    default:
	return;
    }
    
    scriptPath = [[ scriptArray objectAtIndex: row ]
		    objectForKey: @"RAScriptPath" ];
    if ( scriptPath == nil ) {
	NSLog( @"No script path found!" );
	return;
    }
    scriptTmpPath = [[ scriptArray objectAtIndex: row ]
		    objectForKey: @"RAScriptTmpPath" ];
    if ( scriptTmpPath == nil ) {
	NSLog( @"No script tmp path found!" );
	return;
    }
    
    rae = [[ RAAuthExec alloc ] init ];
    
    args = [ NSArray arrayWithObjects: @"-A",
		@"RemovePrePostScript", @"--", scriptPath, nil ];
		
    rc = [ rae executeTool: -1 withArgs: args controller: nil ];
    [ rae release ];
    
    if ( rc != 0 ) {
	NSLog( @"failed to remove %@", scriptPath );
	return;
    }
    
    /*
     * move the temporary script copy to the trash
     * so the user can retrieve it later
     */
     items = [ NSArray arrayWithObject: scriptName ];
     scriptTmpDir = [ scriptTmpPath stringByDeletingLastPathComponent ];
     if ( [[ NSWorkspace sharedWorkspace ]
	    performFileOperation: NSWorkspaceRecycleOperation
	    source: scriptTmpDir destination: @"/"
	    files: items tag: &optag ] == NO ) {
	NSLog( @"Failed to move %@ to the trash.", scriptTmpPath );
	return;
    }
    
    [ self showScriptManagementPanelForWindow: nil ];
}

- ( void )showScriptManagementPanelForWindow: ( NSWindow * )window
{
    NSArray		    *args = nil, *scriptDirs;
    NSArray		    *preapply = nil, *postapply = nil;
    NSDictionary	    *dict = nil;
    NSDirectoryEnumerator   *de = nil;
    NSString		    *file, *scriptDir;
    NSString		    *dateString = nil, *type;
    RAAuthExec		    *rae = nil;
    int			    rc, i;
    
    if (( tmpdir = [[ NSApp delegate ] sessionTemporaryDirectory ] ) == nil ) {
	NSLog( @"failed to get session temporary directory" );
	return;
    }
    
    rae = [[ RAAuthExec alloc ] init ];
    
    args = [ NSArray arrayWithObjects: @"-A",
		@"CopyPrePostScripts", @"--", tmpdir, nil ];
		
    rc = [ rae executeTool: -1
		withArgs: args
		controller: nil ];
    [ rae release ];
    
    if ( rc != 0 ) {
	NSLog( @"failed to copy scripts" );
	return;
    }
    
    scriptDirs = [ NSArray arrayWithObjects:
			[ NSString stringWithFormat: @"%@/preapply", tmpdir ],
			[ NSString stringWithFormat: @"%@/postapply", tmpdir ],
			nil ];
    
    for ( i = 0; i < [ scriptDirs count ]; i++ ) {
	scriptDir = [ scriptDirs objectAtIndex: i ];
	type = [ scriptDir lastPathComponent ];
	
	de = [[ NSFileManager defaultManager ] enumeratorAtPath: scriptDir ];
	[ de skipDescendents ];
	
	while (( file = [ de nextObject ] ) != nil ) {
	    if ( [ file characterAtIndex: 0 ] == '.' ) {
		continue;
	    }
	    
	    dict = [[ NSFileManager defaultManager ]
			fileAttributesAtPath: [ scriptDir stringByAppendingPathComponent: file ]
			traverseLink: YES ];
	    if ( !dict ) {
		NSLog( @"-fileAttributesAtPath:traverseLink: failed" );
		continue;
	    }
	    
	    /* format: 10 Feb 1978 12:47 pm */
	    dateString = [[ dict objectForKey: NSFileModificationDate ]
			descriptionWithCalendarFormat: @"%e %b %Y %I:%M %p"
			timeZone: nil locale: nil ];
	    
	    dict = [ NSDictionary dictionaryWithObjectsAndKeys:
			file, @"RAScriptName",
			[ NSString stringWithFormat: @"/var/radmind/%@/%@", type, file ],
			@"RAScriptPath",
			[ NSString stringWithFormat: @"%@/%@/%@", tmpdir, type, file ],
			@"RAScriptTmpPath",
			dateString, @"RAScriptModificationTime", nil ];
			
	    if ( [ type isEqualToString: @"preapply" ] ) {
		if ( preapply == nil ) {
		    preapply = [ NSArray arrayWithObject: dict ];
		} else {
		    preapply = [ preapply arrayByAddingObject: dict ];
		}
	    } else if ( [ type isEqualToString: @"postapply" ] ) {
		if ( postapply == nil ) {
		    postapply = [ NSArray arrayWithObject: dict ];
		} else {
		    postapply = [ postapply arrayByAddingObject: dict ];
		}
	    }
	}
    }
    [ self setPreApplyScriptArray: preapply ];
    [ self setPostApplyScriptArray: postapply ];
    
    [ scriptManagerPreApplyTable reloadData ];
    [ scriptManagerPostApplyTable reloadData ];
    
    if ( ! [ scriptManagerPanel isVisible ] ) {
	[ NSApp beginSheet: scriptManagerPanel
		modalForWindow: window
		modalDelegate: self
		didEndSelector: @selector( scriptManagerPanelDidEnd:returnCode:contextInfo: )
		contextInfo: window ];
    }
}


- ( IBAction )dismissScriptManagerPanel: ( id )sender
{
    [ scriptManagerPanel orderOut: nil ];
    [ NSApp endSheet: scriptManagerPanel ];
}

- ( void )scriptManagerPanelDidEnd: ( NSPanel * )panel
	    returnCode: ( int )rc contextInfo: ( void * )contextInfo
{
    NSWindow		*window = ( NSWindow * )contextInfo;
    
    if ( window == nil || ! [ window isKindOfClass: [ NSWindow class ]] ) {
	return;
    }
    
    [ window makeKeyAndOrderFront: self ];
}

/* NSTabView delegate methods */
- ( void )tabView: ( NSTabView * )tabView
	    didSelectTabViewItem: ( NSTabViewItem * )tabViewItem
{
    int			    index;
    
    if (( index = [ tabView indexOfTabViewItem: tabViewItem ] ) == NSNotFound ) {
	return;
    }
    
    [ self setIndexOfActiveTabViewItem: index ];
}

/* tableview delegate and datasource methods */
- ( int )numberOfRowsInTableView: ( NSTableView * )aTableView
{
    if ( [ aTableView isEqual: scriptManagerPreApplyTable ] ) {
	return( [[ self preApplyScriptArray ] count ] );
    } else if ( [ aTableView isEqual: scriptManagerPostApplyTable ] ) {
	return( [[ self postApplyScriptArray ] count ] );
    }
    
    return( 0 );
}

- ( id )tableView: ( NSTableView * )aTableView
        objectValueForTableColumn: ( NSTableColumn * )aTableColumn
        row: ( int )rowIndex
{
    NSString		*string = @"";
    NSArray		*array = nil;
    
    if ( [ aTableView isEqual: scriptManagerPreApplyTable ] ) {
	array = [ self preApplyScriptArray ];
    } else if ( [ aTableView isEqual: scriptManagerPostApplyTable ] ) {
	array = [ self postApplyScriptArray ];
    }
				    
    if ( [[ aTableColumn identifier ] isEqualToString: @"ScriptName" ] ) {
	string = [[ array objectAtIndex: rowIndex ]
		    objectForKey: @"RAScriptName" ];
    } else if ( [[ aTableColumn identifier ] isEqualToString: @"LastModified" ] ) {
	string = [[ array objectAtIndex: rowIndex ]
		    objectForKey: @"RAScriptModificationTime" ];
    }
    
    if ( string == nil ) {
	string = @"n/a";
    }

    return( string );
}

- ( BOOL )tableView: ( NSTableView * )tableView
        writeRows: ( NSArray * )rows
        toPasteboard: ( NSPasteboard * )pboard
{
    NSArray			*array;
    NSArray			*scriptArray = nil;
    int				i;
    
    if ( [ tableView isEqual: scriptManagerPreApplyTable ] ) {
	scriptArray = [ self preApplyScriptArray ];
    } else if ( [ tableView isEqual: scriptManagerPostApplyTable ] ) {
	scriptArray = [ self postApplyScriptArray ];
    }
    
    array = [ NSArray array ];
    for ( i = 0; i < [ rows count ]; i++ ) {
	array = [ array arrayByAddingObject:
		    [[ scriptArray objectAtIndex:
			[[ rows objectAtIndex: i ] intValue ]]
			objectForKey: @"RAScriptTmpPath" ]];
    }
    
    [ pboard declareTypes: [ NSArray arrayWithObject: NSFilenamesPboardType ]
		owner: self ];
    [ pboard setPropertyList: array forType: NSFilenamesPboardType ];
    
    return( YES );
}

- ( NSDragOperation )tableView: ( NSTableView * )tableView
        validateDrop: ( id <NSDraggingInfo> )info
        proposedRow: ( int )row
        proposedDropOperation: ( NSTableViewDropOperation )operation
{
    if ( operation == NSTableViewDropAbove ) {
	[ tableView setDropRow: -1 dropOperation: NSTableViewDropOn ];
	return( NSDragOperationCopy );
    }

    return( NSDragOperationNone );
}

- ( BOOL )tableView: ( NSTableView * )tableView
        acceptDrop: ( id <NSDraggingInfo> )info
        row: ( int )row
        dropOperation: ( NSTableViewDropOperation )operation
{
    NSPasteboard		*pb;
    NSString			*type = @"";
    id				dragData;
    int				i;

    pb = [ info draggingPasteboard ];
        
    if ( [ pb availableTypeFromArray:
	    [ NSArray arrayWithObject: NSFilenamesPboardType ]] == nil ) {
	return( NO );
    }
    
    dragData = [ pb propertyListForType: [ pb availableTypeFromArray:
		    [ NSArray arrayWithObject: NSFilenamesPboardType ]]];

    if ( dragData == nil ) {
	return( NO );
    }
    
    if ( [ tableView isEqual: scriptManagerPreApplyTable ] ) {
	type = @"preapply";
    } else if ( [ tableView isEqual: scriptManagerPostApplyTable ] ) {
	type = @"postapply";
    }
    
    for ( i = 0; i < [ dragData count ]; i++ ) {
	[ self installScript: [ dragData objectAtIndex: i ]
		destination: type ];
    }
    
    return( YES );
}

@end
