#include <sys/types.h>
#include <sys/param.h>
#include <sys/uio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "copy.h"

extern int	errno;

    void       
copy( char *src, char *dest, mode_t mode )
{
    int         ifd, ofd, rr;
    char        buf[ MAXPATHLEN ] = { 0 };

    if (( ifd = open( src, O_RDONLY, 0 )) < 0 ) {
        fprintf( stderr, "open %s: %s\n", src, strerror( errno ));
        exit( 2 );
    }
    if (( ofd = open( dest, O_RDWR | O_CREAT | O_TRUNC, mode )) < 0 ) {
        fprintf( stderr, "open %s: %s\n", dest, strerror( errno ));
        exit( 2 );

    }

    while (( rr = read( ifd, buf, MAXPATHLEN )) > 0 ) {
        if ( write( ofd, buf, rr ) != rr ) {
            fprintf( stderr, "write error: %s\n", strerror( errno ));
            exit( 2 );
        }
    }
    if ( rr < 0 ) {
        fprintf( stderr, "read error: %s\n", strerror( errno ));
        exit( 2 );
    }

    if ( close( ifd ) != 0 ) {
	perror( "close" );
	exit( 2 );
    }
    if ( close( ofd ) != 0 ) {
	perror( "close" );
	exit( 2 );
    }
}
