#include <CoreFoundation/CoreFoundation.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "defaults.h"

extern int		errno;

/*
 * Copy defaults set in GUI from user's prefs to /Library/Preferences
 */
    void
copydefaults()
{
    CFArrayRef		keys;
    CFStringRef		appID = CFSTR( "edu.umich.radmindassistant" );
    const CFStringRef	gAppID =
		CFSTR( "/Library/Preferences/edu.umich.radmindassistant" );
    const CFStringRef	cKeys[] = {
					CFSTR( "runfrompath" ),
					CFSTR( "radmindhost" ),
					CFSTR( "cksum" ),
					CFSTR( "tlslevel" ),
					CFSTR( "RAContinueOnReboot" ),
					CFSTR( "RATmpDirectory" ),
					CFSTR( "UMTemplateHome" ),
					CFSTR( "UMTmpHome" ),
					CFSTR( "UMMaxDiskUsage" ),
					CFSTR( "UMMaxHomeLife" ),
					CFSTR( "UMIgnoredUser" )
				   };
    const CFStringRef	user = kCFPreferencesCurrentUser;
    const CFStringRef	host = kCFPreferencesAnyHost;
    CFDictionaryRef	dict = NULL;
    const char *gp = "/Library/Preferences/edu.umich.radmindassistant.plist";

    if (( keys = CFArrayCreate( kCFAllocatorDefault,
			    ( const void ** )&cKeys, 11, NULL )) == NULL ) {
	fprintf( stderr, "CFArrayCreate failed.\n" );
	syslog( LOG_ERR, "CFArrayCreate failed.\n" );
	exit( 2 );
    }

    /* get prefs for GUI user */
    dict = CFPreferencesCopyMultiple( keys, appID, user, host );
    if ( dict == NULL ) {
	fprintf( stderr, "CFPreferencesCopyMultiple failed.\n" );
	syslog( LOG_ERR, "CFPreferencesCopyMultiple failed.\n" );
	exit( 2 );
    }
    CFRelease( keys );

    /* become root again */
    if ( geteuid() != 0 ) {
	if ( setuid( 0 ) < 0 ) {
	    fprintf( stderr, "setuid 0 failed: %s\n", strerror( errno ));
	    syslog( LOG_ERR, "setuid 0 failed: %s\n", strerror( errno ));	
	    return;
	}
    }

    /* write prefs for root in /Library/Preferences */
    CFPreferencesSetMultiple( dict, NULL, gAppID, user, host );    
    CFRelease( dict );
    CFPreferencesSynchronize( gAppID, user, host );
    syslog( LOG_INFO, "prefs set" );

    /* update the mode so administrators can read the global prefs */
    if ( chown( gp, 0, 80 ) != 0 ) {
	syslog( LOG_ERR, "chown %s: %m", gp );
    }
    if ( chmod( gp, 0640 ) != 0 ) {
	syslog( LOG_ERR, "chmod %s: %m", gp );
    }
}

/*
 * Set login or logout hook. if hookpath == NULL, delete the preference.
 */
    void
sethook( char *hookkey, char *hookpath )
{
    CFStringRef		key = NULL;
    CFStringRef		value = NULL;

    if (( key = CFStringCreateWithCString( kCFAllocatorDefault, hookkey,
		CFStringGetSystemEncoding())) == NULL ) {
	fprintf( stderr, "Failed to create CFStringRef from %s.\n", hookkey );
	exit( 2 );
    }
    if ( hookpath != NULL ) {
	value = CFStringCreateWithCString( kCFAllocatorDefault, hookpath,
		CFStringGetSystemEncoding());
	if ( value == NULL ) {
	    fprintf( stderr, "Failed to create CFStringRef from %s.\n",
			hookpath );
	    exit( 2 );
	}
    }

    CFPreferencesSetAppValue( key, ( CFPropertyListRef )value,
	    CFSTR( "com.apple.loginwindow" ));

    CFRelease( key );

    if ( value != NULL ) {
	CFRelease( value );
    }

    CFPreferencesSynchronize( CFSTR( "com.apple.loginwindow" ),
	    kCFPreferencesCurrentUser, kCFPreferencesAnyHost );
}
