#include <sys/types.h>
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "argcargv.h"
#include "kvalid.h"
#include "rmauthexec.h"

extern int		errno;

    static struct list *
list_new( char *path )
{
    struct list		*new = NULL;

    if (( new = (struct list *)malloc( sizeof( struct list ))) == NULL ) {
	perror( "malloc" );
	exit( 2 );
    }

    memset( new, 0, sizeof( struct list ));

    strcpy( new->l_path, path );
    new->l_next = NULL;

    return( new );
}

    static void
list_append( struct list **head, struct list *new )
{
    struct list		**cur;

    for ( cur = head; *cur != NULL; cur = &( *cur )->l_next ) {
    }

    new->l_next = *cur;
    *cur = new;
}

    static int
list_search( struct list *list, char *search )
{
    struct list		*cur;

    for ( cur = list; cur != NULL; cur = cur->l_next ) {
	if ( strcmp( cur->l_path, search ) == 0 ) {
	    return( 1 );
	}
    }

    return( 0 );
}

    static void
list_free( struct list *head )
{
    struct list		*next;

    for ( ; head != NULL; head = next ) {
	next = head->l_next;
	free( head );
    }
}

/*
 * return values:
 *
 * -1: error, errno set
 *  0: type not present
 *  1: type present
 */
    int
kfile_type_present( char *kfile, char type )
{
    struct list		*klist, *knew, *kcur;
    FILE		*kf = NULL;
    char		buf[ MAXPATHLEN ];
    char		path[ MAXPATHLEN ];
    char		**tav;
    int			tac;
    int			found = 0;

    if ( kfile == NULL ) {
	errno = EINVAL;
	fprintf( stderr, "invalid kfile\n" );
	return( -1 );
    }
    if ( strlen( kfile ) >= MAXPATHLEN ) {
	errno = ENAMETOOLONG;
	perror( kfile );
	return( -1 );
    }

    klist = NULL;
    knew = NULL;

    /* add main command file to the list */
    klist = list_new( kfile );

    for ( kcur = klist; kcur != NULL; kcur = kcur->l_next ) {
	/* open and read command file, adding k lines to list */
	if (( kf = fopen( kcur->l_path, "r" )) == NULL ) {
	    perror( kcur->l_path );
	    exit( 2 );
	}

	while ( fgets( buf, MAXPATHLEN, kf ) != NULL ) {
	    if (( tac = argcargv( buf, &tav )) != 2 ) {
		continue;
	    }

	    if ( *tav[ 0 ] == type ) {
		/* if we find type, we're done */
		found = 1;
		goto TYPE_CHECK_DONE;
	    } else if ( *tav[ 0 ] != 'k' ) {
		/* otherwise, we only want kfiles */
		continue;
	    }
		
	    /* XXX should respect radmind_path */
	    if ( snprintf( path, MAXPATHLEN, "/var/radmind/client/%s",
		    tav[ 1 ] ) >= MAXPATHLEN ) {
		fprintf( stderr, "/var/radmind/client/%s: too long\n",
			tav[ 1 ] );
		exit( 2 );
	    }
	    
	    if ( list_search( klist, path ) == 0 ) {
		knew = list_new( path );
		list_append( &klist, knew );
	    }
	}

	if ( fclose( kf ) != 0 ) {
	    fprintf( stderr, "fclose: %s\n", strerror( errno ));
	    exit( 2 );
	}
	kf = NULL;
    }

TYPE_CHECK_DONE:
    list_free( klist );
    if ( kf != NULL ) {
	if ( fclose( kf ) != 0 ) {
	    fprintf( stderr, "fclose: %s\n", strerror( errno ));
	    exit( 2 );
	}
    }

    return( found );
}
