/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSTextView(LogMessage).h"

@implementation NSTextView(LogMessage)

- ( void )logMessage: ( NSString * )fmt, ...
{
    NSString            *msg = nil;
    va_list             val;
    
    va_start( val, fmt );
    
    msg = [[[ NSString alloc ] initWithFormat: fmt
                            arguments: val ] autorelease ];
                                        
    va_end( val );

    [ self insertText: msg ];
}

@end
